//==============================================================================
// LN_MysteryRogueSystem.js
// -----------------------------------------------------------------------------
// Copyright (c) 2022 lriki
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// -----------------------------------------------------------------------------
// [GitHub]  : https://github.com/lriki/LN_MysteryRogueSystem
// [Twitter] : https://twitter.com/lriki8
//==============================================================================

/*:ja
 * @target MZ
 * @plugindesc LN_MysteryRogueSystem v0.8.0
 * @author lriki
 *
 * @help test.
 *
 * MIT License
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @param Group_Inventory
 * @text 持ち物
 * @default ------------------------------------------------------------
 * 
 * @param InventoryCapacity
 * @parent Group_Inventory
 * @text 持ち物の最大数
 * @type number
 * @default 24
 * 
 * @param InventoryItemsPerPage
 * @parent Group_Inventory
 * @text ウィンドウの1ページ分のアイテム数
 * @type number
 * @default 12
 * 
 * @param Group_Map
 * @text マップ
 * @default ------------------------------------------------------------
* 
 * @param RandomMapPaddingX
 * @parent Group_Map
 * @text ランダムマップの外周幅 (上下)
 * @desc ランダムマップ作成時の、マップ外周の侵入不可領域の大きさです。ゲーム画面のサイズに応じて、プレイヤーキャラを画面中央に表示するために変更できます。
 * @type number
 * @default 8
 *
 * @param RandomPaddingY
* @parent Group_Map
 * @text ランダムマップの外周幅 (左右)
 * @desc ランダムマップ作成時の、マップ外周の侵入不可領域の大きさです。ゲーム画面のサイズに応じて、プレイヤーキャラを画面中央に表示するために変更できます。
 * @type number
 * @default 6
 *
 * @param SuspendMenuEnabled
 * @text [中断] メニューの表示有無
 * @desc MRタクティクスマップ上でのメニュー画面で、[中断] を表示するかどうかを指定します。
 * @type boolean
 * @default false
 *
 * @param Group_System
 * @text システム
 * @default ------------------------------------------------------------
  * 
 * @param SyncActorParams
 * @text ステータスの同期
 * @desc エンティティからアクターへステータスを同期します。
 * @parent Group_System
 * @type boolean
 * @default true
 *
 * @param Group_UI
 * @text インターフェイス
 * @default ------------------------------------------------------------
  * 
 * @param DisableWindowStencil
 * @text 背面ウィンドウクリッピングの無効化
 * @desc ウィンドウが重なるとき、背面ウィンドウが透過表示されるようになります。
 * @parent Group_UI
 * @type boolean
 * @default false
 *
 * @param Group_Experimental
 * @text 試験的な機能
 * @default ------------------------------------------------------------
 *
 * @param UIMode
 * @text UIモード
 * @parent Group_Experimental
 * @type select
 * @option Default
 * @value Default
 * @option Traditional
 * @value Traditional
 * @default Traditional
 *
 * @param SandboxWorldSystem
 * @text 箱庭世界システム
 * @parent Group_Experimental
 * @type boolean
 * @default false
 *
 *
 *
 *
 *
 * @command MR-FinishChallenge
 * @text MR-FinishChallenge
 * @desc チャレンジを終了し、直前の Land の結果に応じた処理を実行します。 https://lriki.github.io/LN_MysteryRogueSystemSite/reference/plugin-commands/
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

 * @command RE.ShowChallengeResult
 * @text ShowChallengeResult
 * @desc test
 *
 * @command MR-ShowWarehouseStoreDialog
 * @text ShowWarehouseStoreDialog
 * @desc 預ける
 * @arg serviceProviderKey
 * @type string
 * @arg serviceUserKey
 * @type string

 * @command MR-ShowWarehouseWithdrawDialog
 * @text ShowWarehouseWithdrawDialog
 * @desc 引き出す
 * @arg serviceProviderKey
 * @type string
 * @arg serviceUserKey
 * @type string

 * @command MR-ShowItemSellDialog
 * @desc 売る
 * @arg serviceProviderKey
 * @type string
 * @arg serviceUserKey
 * @type string
 * @arg inventoryOwnerKey
 * @type string

 * @command MR-ProceedFloorForward
 * @text ProceedFloorForward
 * @desc 次のフロアへ
 *
 * @command MR-ProceedFloorBackword
 * @text ProceedFloorBackword
 * @desc 前のフロアへ
 *
 * @command MR-SetProperty
 * @text MR-SetProperty
 * @desc entityKey で指定された Entity へ様々な情報を設定します。
 * @arg entityKey
 * @type string
 * @arg property
 * @type string
 * @arg value

 * @command MR-GetProperty
 * @text MR-GetProperty
 * @desc entityKey で指定された Entity から様々な情報を取得し、変数に代入します。
 * @arg entityKey
 * @type string
 * @arg property
 * @type string
 * @arg variable
 *
 * @command MR-ResetStatus
 * @text MR-ResetStatus
 * @desc entityKey で指定された Entity のパラメータ及びステートを初期状態に戻します。
 * @arg entityKey
 * @type string
 *
 * @command MR-ResetInventory
 * @text MR-ResetInventory
 * @desc entityKey で指定された Entity のインベントリを初期状態に戻します。
 * @arg entityKey
 * @type string
 *
 *
 *
 * @command MR-LivingResult-GetIncludesState
 * @text MR-LivingResult-GetIncludesState
 * @desc actorKey で指定された Entity の戦闘不能原因に、stateKey で指定されたステートが含まれているかを確認します。
 *       MR-CommndResult1: 1=含まれている, 0=含まれていない, -1=Entityが見つからなかった
 * @arg actorKey
 * @type string
 * @arg stateKey
 * @type string
 * 
 * 
 * @command MR-SetContext
 * @text MR-SetContext
 * @desc イベントコマンドの操作対象となる Entity を変更します。詳細は http://... を参照してください。
 * @arg key
 * @type string
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @command MR-AddPostTalkCommand
 * @text [experimental] MR-AddPostTalkCommand
 * @desc 次の MR-ShowPostTalkDialog で表示するコマンドを追加します。
 * @arg name
 * @type string
 * @arg label
 * @type string
 * 
 * @command MR-ShowPostTalkDialog
 * @text [experimental] MR-ShowPostTalkDialog
 * 
 * 
 * @command MR-OpenQuest
 * @text [experimental] MR-OpenQuest
 * @desc クエストを開始(受領)できる状態にします。
 * @arg questKey
 * @type string

 * @command MR-AdvanceQuestTask
 * @text [experimental] MR-AdvanceQuestTask
 * @desc クエストを受領または進行させます
 * @arg questKey
 * @type string
 * @arg questTaskKey
 * @type string
 * 
 */
 

 
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@pixi/accessibility/lib/accessibility.es.js":
/*!******************************************************************!*\
  !*** ./node_modules/@pixi/accessibility/lib/accessibility.es.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AccessibilityManager\": () => (/* binding */ AccessibilityManager),\n/* harmony export */   \"accessibleTarget\": () => (/* binding */ accessibleTarget)\n/* harmony export */ });\n/* harmony import */ var _pixi_display__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/display */ \"./node_modules/@pixi/display/lib/display.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/*!\n * @pixi/accessibility - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/accessibility is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n/**\n * Default property values of accessible objects\n * used by {@link PIXI.AccessibilityManager}.\n *\n * @private\n * @function accessibleTarget\n * @memberof PIXI\n * @type {Object}\n * @example\n *      function MyObject() {}\n *\n *      Object.assign(\n *          MyObject.prototype,\n *          PIXI.accessibleTarget\n *      );\n */\nvar accessibleTarget = {\n    /**\n     *  Flag for if the object is accessible. If true AccessibilityManager will overlay a\n     *   shadow div with attributes set\n     *\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     */\n    accessible: false,\n    /**\n     * Sets the title attribute of the shadow div\n     * If accessibleTitle AND accessibleHint has not been this will default to 'displayObject [tabIndex]'\n     *\n     * @member {?string}\n     * @memberof PIXI.DisplayObject#\n     */\n    accessibleTitle: null,\n    /**\n     * Sets the aria-label attribute of the shadow div\n     *\n     * @member {string}\n     * @memberof PIXI.DisplayObject#\n     */\n    accessibleHint: null,\n    /**\n     * @member {number}\n     * @memberof PIXI.DisplayObject#\n     * @private\n     * @todo Needs docs.\n     */\n    tabIndex: 0,\n    /**\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     * @todo Needs docs.\n     */\n    _accessibleActive: false,\n    /**\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     * @todo Needs docs.\n     */\n    _accessibleDiv: null,\n    /**\n     * Specify the type of div the accessible layer is. Screen readers treat the element differently\n     * depending on this type. Defaults to button.\n     *\n     * @member {string}\n     * @memberof PIXI.DisplayObject#\n     * @default 'button'\n     */\n    accessibleType: 'button',\n    /**\n     * Specify the pointer-events the accessible div will use\n     * Defaults to auto.\n     *\n     * @member {string}\n     * @memberof PIXI.DisplayObject#\n     * @default 'auto'\n     */\n    accessiblePointerEvents: 'auto',\n    /**\n     * Setting to false will prevent any children inside this container to\n     * be accessible. Defaults to true.\n     *\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     * @default true\n     */\n    accessibleChildren: true,\n    renderId: -1,\n};\n\n// add some extra variables to the container..\n_pixi_display__WEBPACK_IMPORTED_MODULE_0__.DisplayObject.mixin(accessibleTarget);\nvar KEY_CODE_TAB = 9;\nvar DIV_TOUCH_SIZE = 100;\nvar DIV_TOUCH_POS_X = 0;\nvar DIV_TOUCH_POS_Y = 0;\nvar DIV_TOUCH_ZINDEX = 2;\nvar DIV_HOOK_SIZE = 1;\nvar DIV_HOOK_POS_X = -1000;\nvar DIV_HOOK_POS_Y = -1000;\nvar DIV_HOOK_ZINDEX = 2;\n/**\n * The Accessibility manager recreates the ability to tab and have content read by screen readers.\n * This is very important as it can possibly help people with disabilities access PixiJS content.\n *\n * A DisplayObject can be made accessible just like it can be made interactive. This manager will map the\n * events as if the mouse was being used, minimizing the effort required to implement.\n *\n * An instance of this class is automatically created by default, and can be found at `renderer.plugins.accessibility`\n *\n * @class\n * @memberof PIXI\n */\nvar AccessibilityManager = /** @class */ (function () {\n    /**\n     * @param {PIXI.CanvasRenderer|PIXI.Renderer} renderer - A reference to the current renderer\n     */\n    function AccessibilityManager(renderer) {\n        /**\n         * @type {?HTMLElement}\n         * @private\n         */\n        this._hookDiv = null;\n        if (_pixi_utils__WEBPACK_IMPORTED_MODULE_1__.isMobile.tablet || _pixi_utils__WEBPACK_IMPORTED_MODULE_1__.isMobile.phone) {\n            this.createTouchHook();\n        }\n        // first we create a div that will sit over the PixiJS element. This is where the div overlays will go.\n        var div = document.createElement('div');\n        div.style.width = DIV_TOUCH_SIZE + \"px\";\n        div.style.height = DIV_TOUCH_SIZE + \"px\";\n        div.style.position = 'absolute';\n        div.style.top = DIV_TOUCH_POS_X + \"px\";\n        div.style.left = DIV_TOUCH_POS_Y + \"px\";\n        div.style.zIndex = DIV_TOUCH_ZINDEX.toString();\n        /**\n         * This is the dom element that will sit over the PixiJS element. This is where the div overlays will go.\n         *\n         * @type {HTMLElement}\n         * @private\n         */\n        this.div = div;\n        /**\n         * A simple pool for storing divs.\n         *\n         * @type {*}\n         * @private\n         */\n        this.pool = [];\n        /**\n         * This is a tick used to check if an object is no longer being rendered.\n         *\n         * @type {Number}\n         * @private\n         */\n        this.renderId = 0;\n        /**\n         * Setting this to true will visually show the divs.\n         *\n         * @type {boolean}\n         */\n        this.debug = false;\n        /**\n         * The renderer this accessibility manager works for.\n         *\n         * @member {PIXI.AbstractRenderer}\n         */\n        this.renderer = renderer;\n        /**\n         * The array of currently active accessible items.\n         *\n         * @member {Array<*>}\n         * @private\n         */\n        this.children = [];\n        /**\n         * pre-bind the functions\n         *\n         * @type {Function}\n         * @private\n         */\n        this._onKeyDown = this._onKeyDown.bind(this);\n        /**\n         * pre-bind the functions\n         *\n         * @type {Function}\n         * @private\n         */\n        this._onMouseMove = this._onMouseMove.bind(this);\n        this._isActive = false;\n        this._isMobileAccessibility = false;\n        /**\n         * count to throttle div updates on android devices\n         * @type number\n         * @private\n         */\n        this.androidUpdateCount = 0;\n        /**\n         * the frequency to update the div elements ()\n         * @private\n         */\n        this.androidUpdateFrequency = 500; // 2fps\n        // let listen for tab.. once pressed we can fire up and show the accessibility layer\n        window.addEventListener('keydown', this._onKeyDown, false);\n    }\n    Object.defineProperty(AccessibilityManager.prototype, \"isActive\", {\n        /**\n         * A flag\n         * @member {boolean}\n         * @readonly\n         */\n        get: function () {\n            return this._isActive;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(AccessibilityManager.prototype, \"isMobileAccessibility\", {\n        /**\n         * A flag\n         * @member {boolean}\n         * @readonly\n         */\n        get: function () {\n            return this._isMobileAccessibility;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Creates the touch hooks.\n     *\n     * @private\n     */\n    AccessibilityManager.prototype.createTouchHook = function () {\n        var _this = this;\n        var hookDiv = document.createElement('button');\n        hookDiv.style.width = DIV_HOOK_SIZE + \"px\";\n        hookDiv.style.height = DIV_HOOK_SIZE + \"px\";\n        hookDiv.style.position = 'absolute';\n        hookDiv.style.top = DIV_HOOK_POS_X + \"px\";\n        hookDiv.style.left = DIV_HOOK_POS_Y + \"px\";\n        hookDiv.style.zIndex = DIV_HOOK_ZINDEX.toString();\n        hookDiv.style.backgroundColor = '#FF0000';\n        hookDiv.title = 'select to enable accessability for this content';\n        hookDiv.addEventListener('focus', function () {\n            _this._isMobileAccessibility = true;\n            _this.activate();\n            _this.destroyTouchHook();\n        });\n        document.body.appendChild(hookDiv);\n        this._hookDiv = hookDiv;\n    };\n    /**\n     * Destroys the touch hooks.\n     *\n     * @private\n     */\n    AccessibilityManager.prototype.destroyTouchHook = function () {\n        if (!this._hookDiv) {\n            return;\n        }\n        document.body.removeChild(this._hookDiv);\n        this._hookDiv = null;\n    };\n    /**\n     * Activating will cause the Accessibility layer to be shown.\n     * This is called when a user presses the tab key.\n     *\n     * @private\n     */\n    AccessibilityManager.prototype.activate = function () {\n        if (this._isActive) {\n            return;\n        }\n        this._isActive = true;\n        window.document.addEventListener('mousemove', this._onMouseMove, true);\n        window.removeEventListener('keydown', this._onKeyDown, false);\n        // TODO: Remove casting when CanvasRenderer is converted\n        this.renderer.on('postrender', this.update, this);\n        if (this.renderer.view.parentNode) {\n            this.renderer.view.parentNode.appendChild(this.div);\n        }\n    };\n    /**\n     * Deactivating will cause the Accessibility layer to be hidden.\n     * This is called when a user moves the mouse.\n     *\n     * @private\n     */\n    AccessibilityManager.prototype.deactivate = function () {\n        if (!this._isActive || this._isMobileAccessibility) {\n            return;\n        }\n        this._isActive = false;\n        window.document.removeEventListener('mousemove', this._onMouseMove, true);\n        window.addEventListener('keydown', this._onKeyDown, false);\n        // TODO: Remove casting when CanvasRenderer is converted\n        this.renderer.off('postrender', this.update);\n        if (this.div.parentNode) {\n            this.div.parentNode.removeChild(this.div);\n        }\n    };\n    /**\n     * This recursive function will run through the scene graph and add any new accessible objects to the DOM layer.\n     *\n     * @private\n     * @param {PIXI.Container} displayObject - The DisplayObject to check.\n     */\n    AccessibilityManager.prototype.updateAccessibleObjects = function (displayObject) {\n        if (!displayObject.visible || !displayObject.accessibleChildren) {\n            return;\n        }\n        if (displayObject.accessible && displayObject.interactive) {\n            if (!displayObject._accessibleActive) {\n                this.addChild(displayObject);\n            }\n            displayObject.renderId = this.renderId;\n        }\n        var children = displayObject.children;\n        for (var i = 0; i < children.length; i++) {\n            this.updateAccessibleObjects(children[i]);\n        }\n    };\n    /**\n     * Before each render this function will ensure that all divs are mapped correctly to their DisplayObjects.\n     *\n     * @private\n     */\n    AccessibilityManager.prototype.update = function () {\n        /* On Android default web browser, tab order seems to be calculated by position rather than tabIndex,\n        *  moving buttons can cause focus to flicker between two buttons making it hard/impossible to navigate,\n        *  so I am just running update every half a second, seems to fix it.\n        */\n        var now = performance.now();\n        if (_pixi_utils__WEBPACK_IMPORTED_MODULE_1__.isMobile.android.device && now < this.androidUpdateCount) {\n            return;\n        }\n        this.androidUpdateCount = now + this.androidUpdateFrequency;\n        if (!this.renderer.renderingToScreen) {\n            return;\n        }\n        // update children...\n        if (this.renderer._lastObjectRendered) {\n            this.updateAccessibleObjects(this.renderer._lastObjectRendered);\n        }\n        // TODO: Remove casting when CanvasRenderer is converted\n        var rect = this.renderer.view.getBoundingClientRect();\n        var resolution = this.renderer.resolution;\n        var sx = (rect.width / this.renderer.width) * resolution;\n        var sy = (rect.height / this.renderer.height) * resolution;\n        var div = this.div;\n        div.style.left = rect.left + \"px\";\n        div.style.top = rect.top + \"px\";\n        div.style.width = this.renderer.width + \"px\";\n        div.style.height = this.renderer.height + \"px\";\n        for (var i = 0; i < this.children.length; i++) {\n            var child = this.children[i];\n            if (child.renderId !== this.renderId) {\n                child._accessibleActive = false;\n                (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_1__.removeItems)(this.children, i, 1);\n                this.div.removeChild(child._accessibleDiv);\n                this.pool.push(child._accessibleDiv);\n                child._accessibleDiv = null;\n                i--;\n            }\n            else {\n                // map div to display..\n                div = child._accessibleDiv;\n                var hitArea = child.hitArea;\n                var wt = child.worldTransform;\n                if (child.hitArea) {\n                    div.style.left = (wt.tx + (hitArea.x * wt.a)) * sx + \"px\";\n                    div.style.top = (wt.ty + (hitArea.y * wt.d)) * sy + \"px\";\n                    div.style.width = hitArea.width * wt.a * sx + \"px\";\n                    div.style.height = hitArea.height * wt.d * sy + \"px\";\n                }\n                else {\n                    hitArea = child.getBounds();\n                    this.capHitArea(hitArea);\n                    div.style.left = hitArea.x * sx + \"px\";\n                    div.style.top = hitArea.y * sy + \"px\";\n                    div.style.width = hitArea.width * sx + \"px\";\n                    div.style.height = hitArea.height * sy + \"px\";\n                    // update button titles and hints if they exist and they've changed\n                    if (div.title !== child.accessibleTitle && child.accessibleTitle !== null) {\n                        div.title = child.accessibleTitle;\n                    }\n                    if (div.getAttribute('aria-label') !== child.accessibleHint\n                        && child.accessibleHint !== null) {\n                        div.setAttribute('aria-label', child.accessibleHint);\n                    }\n                }\n                // the title or index may have changed, if so lets update it!\n                if (child.accessibleTitle !== div.title || child.tabIndex !== div.tabIndex) {\n                    div.title = child.accessibleTitle;\n                    div.tabIndex = child.tabIndex;\n                    if (this.debug)\n                        { this.updateDebugHTML(div); }\n                }\n            }\n        }\n        // increment the render id..\n        this.renderId++;\n    };\n    /**\n     * private function that will visually add the information to the\n     * accessability div\n     *\n     * @param {HTMLElement} div\n     */\n    AccessibilityManager.prototype.updateDebugHTML = function (div) {\n        div.innerHTML = \"type: \" + div.type + \"</br> title : \" + div.title + \"</br> tabIndex: \" + div.tabIndex;\n    };\n    /**\n     * Adjust the hit area based on the bounds of a display object\n     *\n     * @param {PIXI.Rectangle} hitArea - Bounds of the child\n     */\n    AccessibilityManager.prototype.capHitArea = function (hitArea) {\n        if (hitArea.x < 0) {\n            hitArea.width += hitArea.x;\n            hitArea.x = 0;\n        }\n        if (hitArea.y < 0) {\n            hitArea.height += hitArea.y;\n            hitArea.y = 0;\n        }\n        // TODO: Remove casting when CanvasRenderer is converted\n        if (hitArea.x + hitArea.width > this.renderer.width) {\n            hitArea.width = this.renderer.width - hitArea.x;\n        }\n        if (hitArea.y + hitArea.height > this.renderer.height) {\n            hitArea.height = this.renderer.height - hitArea.y;\n        }\n    };\n    /**\n     * Adds a DisplayObject to the accessibility manager\n     *\n     * @private\n     * @param {PIXI.DisplayObject} displayObject - The child to make accessible.\n     */\n    AccessibilityManager.prototype.addChild = function (displayObject) {\n        //    this.activate();\n        var div = this.pool.pop();\n        if (!div) {\n            div = document.createElement('button');\n            div.style.width = DIV_TOUCH_SIZE + \"px\";\n            div.style.height = DIV_TOUCH_SIZE + \"px\";\n            div.style.backgroundColor = this.debug ? 'rgba(255,255,255,0.5)' : 'transparent';\n            div.style.position = 'absolute';\n            div.style.zIndex = DIV_TOUCH_ZINDEX.toString();\n            div.style.borderStyle = 'none';\n            // ARIA attributes ensure that button title and hint updates are announced properly\n            if (navigator.userAgent.toLowerCase().indexOf('chrome') > -1) {\n                // Chrome doesn't need aria-live to work as intended; in fact it just gets more confused.\n                div.setAttribute('aria-live', 'off');\n            }\n            else {\n                div.setAttribute('aria-live', 'polite');\n            }\n            if (navigator.userAgent.match(/rv:.*Gecko\\//)) {\n                // FireFox needs this to announce only the new button name\n                div.setAttribute('aria-relevant', 'additions');\n            }\n            else {\n                // required by IE, other browsers don't much care\n                div.setAttribute('aria-relevant', 'text');\n            }\n            div.addEventListener('click', this._onClick.bind(this));\n            div.addEventListener('focus', this._onFocus.bind(this));\n            div.addEventListener('focusout', this._onFocusOut.bind(this));\n        }\n        // set pointer events\n        div.style.pointerEvents = displayObject.accessiblePointerEvents;\n        // set the type, this defaults to button!\n        div.type = displayObject.accessibleType;\n        if (displayObject.accessibleTitle && displayObject.accessibleTitle !== null) {\n            div.title = displayObject.accessibleTitle;\n        }\n        else if (!displayObject.accessibleHint\n            || displayObject.accessibleHint === null) {\n            div.title = \"displayObject \" + displayObject.tabIndex;\n        }\n        if (displayObject.accessibleHint\n            && displayObject.accessibleHint !== null) {\n            div.setAttribute('aria-label', displayObject.accessibleHint);\n        }\n        if (this.debug)\n            { this.updateDebugHTML(div); }\n        displayObject._accessibleActive = true;\n        displayObject._accessibleDiv = div;\n        div.displayObject = displayObject;\n        this.children.push(displayObject);\n        this.div.appendChild(displayObject._accessibleDiv);\n        displayObject._accessibleDiv.tabIndex = displayObject.tabIndex;\n    };\n    /**\n     * Maps the div button press to pixi's InteractionManager (click)\n     *\n     * @private\n     * @param {MouseEvent} e - The click event.\n     */\n    AccessibilityManager.prototype._onClick = function (e) {\n        // TODO: Remove casting when CanvasRenderer is converted\n        var interactionManager = this.renderer.plugins.interaction;\n        interactionManager.dispatchEvent(e.target.displayObject, 'click', interactionManager.eventData);\n        interactionManager.dispatchEvent(e.target.displayObject, 'pointertap', interactionManager.eventData);\n        interactionManager.dispatchEvent(e.target.displayObject, 'tap', interactionManager.eventData);\n    };\n    /**\n     * Maps the div focus events to pixi's InteractionManager (mouseover)\n     *\n     * @private\n     * @param {FocusEvent} e - The focus event.\n     */\n    AccessibilityManager.prototype._onFocus = function (e) {\n        if (!e.target.getAttribute('aria-live')) {\n            e.target.setAttribute('aria-live', 'assertive');\n        }\n        // TODO: Remove casting when CanvasRenderer is converted\n        var interactionManager = this.renderer.plugins.interaction;\n        interactionManager.dispatchEvent(e.target.displayObject, 'mouseover', interactionManager.eventData);\n    };\n    /**\n     * Maps the div focus events to pixi's InteractionManager (mouseout)\n     *\n     * @private\n     * @param {FocusEvent} e - The focusout event.\n     */\n    AccessibilityManager.prototype._onFocusOut = function (e) {\n        if (!e.target.getAttribute('aria-live')) {\n            e.target.setAttribute('aria-live', 'polite');\n        }\n        // TODO: Remove casting when CanvasRenderer is converted\n        var interactionManager = this.renderer.plugins.interaction;\n        interactionManager.dispatchEvent(e.target.displayObject, 'mouseout', interactionManager.eventData);\n    };\n    /**\n     * Is called when a key is pressed\n     *\n     * @private\n     * @param {KeyboardEvent} e - The keydown event.\n     */\n    AccessibilityManager.prototype._onKeyDown = function (e) {\n        if (e.keyCode !== KEY_CODE_TAB) {\n            return;\n        }\n        this.activate();\n    };\n    /**\n     * Is called when the mouse moves across the renderer element\n     *\n     * @private\n     * @param {MouseEvent} e - The mouse event.\n     */\n    AccessibilityManager.prototype._onMouseMove = function (e) {\n        if (e.movementX === 0 && e.movementY === 0) {\n            return;\n        }\n        this.deactivate();\n    };\n    /**\n     * Destroys the accessibility manager\n     *\n     */\n    AccessibilityManager.prototype.destroy = function () {\n        this.destroyTouchHook();\n        this.div = null;\n        window.document.removeEventListener('mousemove', this._onMouseMove, true);\n        window.removeEventListener('keydown', this._onKeyDown);\n        this.pool = null;\n        this.children = null;\n        this.renderer = null;\n    };\n    return AccessibilityManager;\n}());\n\n\n//# sourceMappingURL=accessibility.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/accessibility/lib/accessibility.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/app/lib/app.es.js":
/*!**********************************************!*\
  !*** ./node_modules/@pixi/app/lib/app.es.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Application\": () => (/* binding */ Application)\n/* harmony export */ });\n/* harmony import */ var _pixi_display__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/display */ \"./node_modules/@pixi/display/lib/display.es.js\");\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/app - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/app is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n/**\n * Convenience class to create a new PIXI application.\n *\n * This class automatically creates the renderer, ticker and root container.\n *\n * @example\n * // Create the application\n * const app = new PIXI.Application();\n *\n * // Add the view to the DOM\n * document.body.appendChild(app.view);\n *\n * // ex, add display objects\n * app.stage.addChild(PIXI.Sprite.from('something.png'));\n *\n * @class\n * @memberof PIXI\n */\nvar Application = /** @class */ (function () {\n    /**\n     * @param {object} [options] - The optional renderer parameters.\n     * @param {boolean} [options.autoStart=true] - Automatically starts the rendering after the construction.\n     *     **Note**: Setting this parameter to false does NOT stop the shared ticker even if you set\n     *     options.sharedTicker to true in case that it is already started. Stop it by your own.\n     * @param {number} [options.width=800] - The width of the renderers view.\n     * @param {number} [options.height=600] - The height of the renderers view.\n     * @param {HTMLCanvasElement} [options.view] - The canvas to use as a view, optional.\n     * @param {boolean} [options.transparent=false] - If the render view is transparent.\n     * @param {boolean} [options.autoDensity=false] - Resizes renderer view in CSS pixels to allow for\n     *   resolutions other than 1.\n     * @param {boolean} [options.antialias=false] - Sets antialias\n     * @param {boolean} [options.preserveDrawingBuffer=false] - Enables drawing buffer preservation, enable this if you\n     *  need to call toDataUrl on the WebGL context.\n     * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the renderer, retina would be 2.\n     * @param {boolean} [options.forceCanvas=false] - prevents selection of WebGL renderer, even if such is present, this\n     *   option only is available when using **pixi.js-legacy** or **@pixi/canvas-renderer** modules, otherwise\n     *   it is ignored.\n     * @param {number} [options.backgroundColor=0x000000] - The background color of the rendered area\n     *  (shown if not transparent).\n     * @param {boolean} [options.clearBeforeRender=true] - This sets if the renderer will clear the canvas or\n     *   not before the new render pass.\n     * @param {string} [options.powerPreference] - Parameter passed to webgl context, set to \"high-performance\"\n     *  for devices with dual graphics card. **(WebGL only)**.\n     * @param {boolean} [options.sharedTicker=false] - `true` to use PIXI.Ticker.shared, `false` to create new ticker.\n     *  If set to false, you cannot register a handler to occur before anything that runs on the shared ticker.\n     *  The system ticker will always run before both the shared ticker and the app ticker.\n     * @param {boolean} [options.sharedLoader=false] - `true` to use PIXI.Loader.shared, `false` to create new Loader.\n     * @param {Window|HTMLElement} [options.resizeTo] - Element to automatically resize stage to.\n     */\n    function Application(options) {\n        var _this = this;\n        // The default options\n        options = Object.assign({\n            forceCanvas: false,\n        }, options);\n        /**\n         * WebGL renderer if available, otherwise CanvasRenderer.\n         * @member {PIXI.Renderer|PIXI.CanvasRenderer}\n         */\n        this.renderer = (0,_pixi_core__WEBPACK_IMPORTED_MODULE_1__.autoDetectRenderer)(options);\n        /**\n         * The root display container that's rendered.\n         * @member {PIXI.Container}\n         */\n        this.stage = new _pixi_display__WEBPACK_IMPORTED_MODULE_0__.Container();\n        // install plugins here\n        Application._plugins.forEach(function (plugin) {\n            plugin.init.call(_this, options);\n        });\n    }\n    /**\n     * Register a middleware plugin for the application\n     * @static\n     * @param {PIXI.Application.Plugin} plugin - Plugin being installed\n     */\n    Application.registerPlugin = function (plugin) {\n        Application._plugins.push(plugin);\n    };\n    /**\n     * Render the current stage.\n     */\n    Application.prototype.render = function () {\n        // TODO: Since CanvasRenderer has not been converted this function thinks it takes DisplayObject & PIXI.DisplayObject\n        // This can be fixed when CanvasRenderer is converted.\n        this.renderer.render(this.stage);\n    };\n    Object.defineProperty(Application.prototype, \"view\", {\n        /**\n         * Reference to the renderer's canvas element.\n         * @member {HTMLCanvasElement}\n         * @readonly\n         */\n        get: function () {\n            return this.renderer.view;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Application.prototype, \"screen\", {\n        /**\n         * Reference to the renderer's screen rectangle. Its safe to use as `filterArea` or `hitArea` for the whole screen.\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        get: function () {\n            return this.renderer.screen;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Destroy and don't use after this.\n     * @param {Boolean} [removeView=false] - Automatically remove canvas from DOM.\n     * @param {object|boolean} [stageOptions] - Options parameter. A boolean will act as if all options\n     *  have been set to that value\n     * @param {boolean} [stageOptions.children=false] - if set to true, all the children will have their destroy\n     *  method called as well. 'stageOptions' will be passed on to those calls.\n     * @param {boolean} [stageOptions.texture=false] - Only used for child Sprites if stageOptions.children is set\n     *  to true. Should it destroy the texture of the child sprite\n     * @param {boolean} [stageOptions.baseTexture=false] - Only used for child Sprites if stageOptions.children is set\n     *  to true. Should it destroy the base texture of the child sprite\n     */\n    Application.prototype.destroy = function (removeView, stageOptions) {\n        var _this = this;\n        // Destroy plugins in the opposite order\n        // which they were constructed\n        var plugins = Application._plugins.slice(0);\n        plugins.reverse();\n        plugins.forEach(function (plugin) {\n            plugin.destroy.call(_this);\n        });\n        this.stage.destroy(stageOptions);\n        this.stage = null;\n        this.renderer.destroy(removeView);\n        this.renderer = null;\n    };\n    return Application;\n}());\n/**\n * @memberof PIXI.Application\n * @typedef {object} Plugin\n * @property {function} init - Called when Application is constructed, scoped to Application instance.\n *  Passes in `options` as the only argument, which are Application constructor options.\n * @property {function} destroy - Called when destroying Application, scoped to Application instance\n */\n/**\n * Collection of installed plugins.\n * @static\n * @private\n * @type {PIXI.Application.Plugin[]}\n */\nApplication._plugins = [];\n\n/**\n * Middleware for for Application's resize functionality\n * @private\n * @class\n */\nvar ResizePlugin = /** @class */ (function () {\n    function ResizePlugin() {\n    }\n    /**\n     * Initialize the plugin with scope of application instance\n     * @static\n     * @private\n     * @param {object} [options] - See application options\n     */\n    ResizePlugin.init = function (options) {\n        var _this = this;\n        /**\n         * The HTML element or window to automatically resize the\n         * renderer's view element to match width and height.\n         * @type {Window|HTMLElement}\n         * @name resizeTo\n         * @memberof PIXI.Application#\n         */\n        Object.defineProperty(this, 'resizeTo', {\n            set: function (dom) {\n                window.removeEventListener('resize', this.queueResize);\n                this._resizeTo = dom;\n                if (dom) {\n                    window.addEventListener('resize', this.queueResize);\n                    this.resize();\n                }\n            },\n            get: function () {\n                return this._resizeTo;\n            },\n        });\n        /**\n         * Resize is throttled, so it's\n         * safe to call this multiple times per frame and it'll\n         * only be called once.\n         * @method PIXI.Application#queueResize\n         */\n        this.queueResize = function () {\n            if (!_this._resizeTo) {\n                return;\n            }\n            _this.cancelResize();\n            // // Throttle resize events per raf\n            _this._resizeId = requestAnimationFrame(function () { return _this.resize(); });\n        };\n        /**\n         * Cancel the resize queue.\n         * @method PIXI.Application#cancelResize\n         * @private\n         */\n        this.cancelResize = function () {\n            if (_this._resizeId) {\n                cancelAnimationFrame(_this._resizeId);\n                _this._resizeId = null;\n            }\n        };\n        /**\n         * Execute an immediate resize on the renderer, this is not\n         * throttled and can be expensive to call many times in a row.\n         * Will resize only if `resizeTo` property is set.\n         * @method PIXI.Application#resize\n         */\n        this.resize = function () {\n            if (!_this._resizeTo) {\n                return;\n            }\n            // clear queue resize\n            _this.cancelResize();\n            var width;\n            var height;\n            // Resize to the window\n            if (_this._resizeTo === window) {\n                width = window.innerWidth;\n                height = window.innerHeight;\n            }\n            // Resize to other HTML entities\n            else {\n                var _a = _this._resizeTo, clientWidth = _a.clientWidth, clientHeight = _a.clientHeight;\n                width = clientWidth;\n                height = clientHeight;\n            }\n            _this.renderer.resize(width, height);\n        };\n        // On resize\n        this._resizeId = null;\n        this._resizeTo = null;\n        this.resizeTo = options.resizeTo || null;\n    };\n    /**\n     * Clean up the ticker, scoped to application\n     * @static\n     * @private\n     */\n    ResizePlugin.destroy = function () {\n        window.removeEventListener('resize', this.queueResize);\n        this.cancelResize();\n        this.cancelResize = null;\n        this.queueResize = null;\n        this.resizeTo = null;\n        this.resize = null;\n    };\n    return ResizePlugin;\n}());\n\nApplication.registerPlugin(ResizePlugin);\n\n\n//# sourceMappingURL=app.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/app/lib/app.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/constants/lib/constants.es.js":
/*!**********************************************************!*\
  !*** ./node_modules/@pixi/constants/lib/constants.es.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ALPHA_MODES\": () => (/* binding */ ALPHA_MODES),\n/* harmony export */   \"BLEND_MODES\": () => (/* binding */ BLEND_MODES),\n/* harmony export */   \"BUFFER_BITS\": () => (/* binding */ BUFFER_BITS),\n/* harmony export */   \"CLEAR_MODES\": () => (/* binding */ CLEAR_MODES),\n/* harmony export */   \"DRAW_MODES\": () => (/* binding */ DRAW_MODES),\n/* harmony export */   \"ENV\": () => (/* binding */ ENV),\n/* harmony export */   \"FORMATS\": () => (/* binding */ FORMATS),\n/* harmony export */   \"GC_MODES\": () => (/* binding */ GC_MODES),\n/* harmony export */   \"MASK_TYPES\": () => (/* binding */ MASK_TYPES),\n/* harmony export */   \"MIPMAP_MODES\": () => (/* binding */ MIPMAP_MODES),\n/* harmony export */   \"MSAA_QUALITY\": () => (/* binding */ MSAA_QUALITY),\n/* harmony export */   \"PRECISION\": () => (/* binding */ PRECISION),\n/* harmony export */   \"RENDERER_TYPE\": () => (/* binding */ RENDERER_TYPE),\n/* harmony export */   \"SCALE_MODES\": () => (/* binding */ SCALE_MODES),\n/* harmony export */   \"TARGETS\": () => (/* binding */ TARGETS),\n/* harmony export */   \"TYPES\": () => (/* binding */ TYPES),\n/* harmony export */   \"WRAP_MODES\": () => (/* binding */ WRAP_MODES)\n/* harmony export */ });\n/*!\n * @pixi/constants - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/constants is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n/**\n * Different types of environments for WebGL.\n *\n * @static\n * @memberof PIXI\n * @name ENV\n * @enum {number}\n * @property {number} WEBGL_LEGACY - Used for older v1 WebGL devices. PixiJS will aim to ensure compatibility\n *  with older / less advanced devices. If you experience unexplained flickering prefer this environment.\n * @property {number} WEBGL - Version 1 of WebGL\n * @property {number} WEBGL2 - Version 2 of WebGL\n */\nvar ENV;\n(function (ENV) {\n    ENV[ENV[\"WEBGL_LEGACY\"] = 0] = \"WEBGL_LEGACY\";\n    ENV[ENV[\"WEBGL\"] = 1] = \"WEBGL\";\n    ENV[ENV[\"WEBGL2\"] = 2] = \"WEBGL2\";\n})(ENV || (ENV = {}));\n/**\n * Constant to identify the Renderer Type.\n *\n * @static\n * @memberof PIXI\n * @name RENDERER_TYPE\n * @enum {number}\n * @property {number} UNKNOWN - Unknown render type.\n * @property {number} WEBGL - WebGL render type.\n * @property {number} CANVAS - Canvas render type.\n */\nvar RENDERER_TYPE;\n(function (RENDERER_TYPE) {\n    RENDERER_TYPE[RENDERER_TYPE[\"UNKNOWN\"] = 0] = \"UNKNOWN\";\n    RENDERER_TYPE[RENDERER_TYPE[\"WEBGL\"] = 1] = \"WEBGL\";\n    RENDERER_TYPE[RENDERER_TYPE[\"CANVAS\"] = 2] = \"CANVAS\";\n})(RENDERER_TYPE || (RENDERER_TYPE = {}));\n/**\n * Bitwise OR of masks that indicate the buffers to be cleared.\n *\n * @static\n * @memberof PIXI\n * @name BUFFER_BITS\n * @enum {number}\n * @property {number} COLOR - Indicates the buffers currently enabled for color writing.\n * @property {number} DEPTH - Indicates the depth buffer.\n * @property {number} STENCIL - Indicates the stencil buffer.\n */\nvar BUFFER_BITS;\n(function (BUFFER_BITS) {\n    BUFFER_BITS[BUFFER_BITS[\"COLOR\"] = 16384] = \"COLOR\";\n    BUFFER_BITS[BUFFER_BITS[\"DEPTH\"] = 256] = \"DEPTH\";\n    BUFFER_BITS[BUFFER_BITS[\"STENCIL\"] = 1024] = \"STENCIL\";\n})(BUFFER_BITS || (BUFFER_BITS = {}));\n/**\n * Various blend modes supported by PIXI.\n *\n * IMPORTANT - The WebGL renderer only supports the NORMAL, ADD, MULTIPLY and SCREEN blend modes.\n * Anything else will silently act like NORMAL.\n *\n * @memberof PIXI\n * @name BLEND_MODES\n * @enum {number}\n * @property {number} NORMAL\n * @property {number} ADD\n * @property {number} MULTIPLY\n * @property {number} SCREEN\n * @property {number} OVERLAY\n * @property {number} DARKEN\n * @property {number} LIGHTEN\n * @property {number} COLOR_DODGE\n * @property {number} COLOR_BURN\n * @property {number} HARD_LIGHT\n * @property {number} SOFT_LIGHT\n * @property {number} DIFFERENCE\n * @property {number} EXCLUSION\n * @property {number} HUE\n * @property {number} SATURATION\n * @property {number} COLOR\n * @property {number} LUMINOSITY\n * @property {number} NORMAL_NPM\n * @property {number} ADD_NPM\n * @property {number} SCREEN_NPM\n * @property {number} NONE\n * @property {number} SRC_IN\n * @property {number} SRC_OUT\n * @property {number} SRC_ATOP\n * @property {number} DST_OVER\n * @property {number} DST_IN\n * @property {number} DST_OUT\n * @property {number} DST_ATOP\n * @property {number} SUBTRACT\n * @property {number} SRC_OVER\n * @property {number} ERASE\n * @property {number} XOR\n */\nvar BLEND_MODES;\n(function (BLEND_MODES) {\n    BLEND_MODES[BLEND_MODES[\"NORMAL\"] = 0] = \"NORMAL\";\n    BLEND_MODES[BLEND_MODES[\"ADD\"] = 1] = \"ADD\";\n    BLEND_MODES[BLEND_MODES[\"MULTIPLY\"] = 2] = \"MULTIPLY\";\n    BLEND_MODES[BLEND_MODES[\"SCREEN\"] = 3] = \"SCREEN\";\n    BLEND_MODES[BLEND_MODES[\"OVERLAY\"] = 4] = \"OVERLAY\";\n    BLEND_MODES[BLEND_MODES[\"DARKEN\"] = 5] = \"DARKEN\";\n    BLEND_MODES[BLEND_MODES[\"LIGHTEN\"] = 6] = \"LIGHTEN\";\n    BLEND_MODES[BLEND_MODES[\"COLOR_DODGE\"] = 7] = \"COLOR_DODGE\";\n    BLEND_MODES[BLEND_MODES[\"COLOR_BURN\"] = 8] = \"COLOR_BURN\";\n    BLEND_MODES[BLEND_MODES[\"HARD_LIGHT\"] = 9] = \"HARD_LIGHT\";\n    BLEND_MODES[BLEND_MODES[\"SOFT_LIGHT\"] = 10] = \"SOFT_LIGHT\";\n    BLEND_MODES[BLEND_MODES[\"DIFFERENCE\"] = 11] = \"DIFFERENCE\";\n    BLEND_MODES[BLEND_MODES[\"EXCLUSION\"] = 12] = \"EXCLUSION\";\n    BLEND_MODES[BLEND_MODES[\"HUE\"] = 13] = \"HUE\";\n    BLEND_MODES[BLEND_MODES[\"SATURATION\"] = 14] = \"SATURATION\";\n    BLEND_MODES[BLEND_MODES[\"COLOR\"] = 15] = \"COLOR\";\n    BLEND_MODES[BLEND_MODES[\"LUMINOSITY\"] = 16] = \"LUMINOSITY\";\n    BLEND_MODES[BLEND_MODES[\"NORMAL_NPM\"] = 17] = \"NORMAL_NPM\";\n    BLEND_MODES[BLEND_MODES[\"ADD_NPM\"] = 18] = \"ADD_NPM\";\n    BLEND_MODES[BLEND_MODES[\"SCREEN_NPM\"] = 19] = \"SCREEN_NPM\";\n    BLEND_MODES[BLEND_MODES[\"NONE\"] = 20] = \"NONE\";\n    BLEND_MODES[BLEND_MODES[\"SRC_OVER\"] = 0] = \"SRC_OVER\";\n    BLEND_MODES[BLEND_MODES[\"SRC_IN\"] = 21] = \"SRC_IN\";\n    BLEND_MODES[BLEND_MODES[\"SRC_OUT\"] = 22] = \"SRC_OUT\";\n    BLEND_MODES[BLEND_MODES[\"SRC_ATOP\"] = 23] = \"SRC_ATOP\";\n    BLEND_MODES[BLEND_MODES[\"DST_OVER\"] = 24] = \"DST_OVER\";\n    BLEND_MODES[BLEND_MODES[\"DST_IN\"] = 25] = \"DST_IN\";\n    BLEND_MODES[BLEND_MODES[\"DST_OUT\"] = 26] = \"DST_OUT\";\n    BLEND_MODES[BLEND_MODES[\"DST_ATOP\"] = 27] = \"DST_ATOP\";\n    BLEND_MODES[BLEND_MODES[\"ERASE\"] = 26] = \"ERASE\";\n    BLEND_MODES[BLEND_MODES[\"SUBTRACT\"] = 28] = \"SUBTRACT\";\n    BLEND_MODES[BLEND_MODES[\"XOR\"] = 29] = \"XOR\";\n})(BLEND_MODES || (BLEND_MODES = {}));\n/**\n * Various webgl draw modes. These can be used to specify which GL drawMode to use\n * under certain situations and renderers.\n *\n * @memberof PIXI\n * @static\n * @name DRAW_MODES\n * @enum {number}\n * @property {number} POINTS\n * @property {number} LINES\n * @property {number} LINE_LOOP\n * @property {number} LINE_STRIP\n * @property {number} TRIANGLES\n * @property {number} TRIANGLE_STRIP\n * @property {number} TRIANGLE_FAN\n */\nvar DRAW_MODES;\n(function (DRAW_MODES) {\n    DRAW_MODES[DRAW_MODES[\"POINTS\"] = 0] = \"POINTS\";\n    DRAW_MODES[DRAW_MODES[\"LINES\"] = 1] = \"LINES\";\n    DRAW_MODES[DRAW_MODES[\"LINE_LOOP\"] = 2] = \"LINE_LOOP\";\n    DRAW_MODES[DRAW_MODES[\"LINE_STRIP\"] = 3] = \"LINE_STRIP\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLES\"] = 4] = \"TRIANGLES\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLE_STRIP\"] = 5] = \"TRIANGLE_STRIP\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLE_FAN\"] = 6] = \"TRIANGLE_FAN\";\n})(DRAW_MODES || (DRAW_MODES = {}));\n/**\n * Various GL texture/resources formats.\n *\n * @memberof PIXI\n * @static\n * @name FORMATS\n * @enum {number}\n * @property {number} RGBA=6408\n * @property {number} RGB=6407\n * @property {number} ALPHA=6406\n * @property {number} LUMINANCE=6409\n * @property {number} LUMINANCE_ALPHA=6410\n * @property {number} DEPTH_COMPONENT=6402\n * @property {number} DEPTH_STENCIL=34041\n */\nvar FORMATS;\n(function (FORMATS) {\n    FORMATS[FORMATS[\"RGBA\"] = 6408] = \"RGBA\";\n    FORMATS[FORMATS[\"RGB\"] = 6407] = \"RGB\";\n    FORMATS[FORMATS[\"ALPHA\"] = 6406] = \"ALPHA\";\n    FORMATS[FORMATS[\"LUMINANCE\"] = 6409] = \"LUMINANCE\";\n    FORMATS[FORMATS[\"LUMINANCE_ALPHA\"] = 6410] = \"LUMINANCE_ALPHA\";\n    FORMATS[FORMATS[\"DEPTH_COMPONENT\"] = 6402] = \"DEPTH_COMPONENT\";\n    FORMATS[FORMATS[\"DEPTH_STENCIL\"] = 34041] = \"DEPTH_STENCIL\";\n})(FORMATS || (FORMATS = {}));\n/**\n * Various GL target types.\n *\n * @memberof PIXI\n * @static\n * @name TARGETS\n * @enum {number}\n * @property {number} TEXTURE_2D=3553\n * @property {number} TEXTURE_CUBE_MAP=34067\n * @property {number} TEXTURE_2D_ARRAY=35866\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_X=34069\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_X=34070\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_Y=34071\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_Y=34072\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_Z=34073\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_Z=34074\n */\nvar TARGETS;\n(function (TARGETS) {\n    TARGETS[TARGETS[\"TEXTURE_2D\"] = 3553] = \"TEXTURE_2D\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP\"] = 34067] = \"TEXTURE_CUBE_MAP\";\n    TARGETS[TARGETS[\"TEXTURE_2D_ARRAY\"] = 35866] = \"TEXTURE_2D_ARRAY\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_X\"] = 34069] = \"TEXTURE_CUBE_MAP_POSITIVE_X\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_X\"] = 34070] = \"TEXTURE_CUBE_MAP_NEGATIVE_X\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_Y\"] = 34071] = \"TEXTURE_CUBE_MAP_POSITIVE_Y\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_Y\"] = 34072] = \"TEXTURE_CUBE_MAP_NEGATIVE_Y\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_Z\"] = 34073] = \"TEXTURE_CUBE_MAP_POSITIVE_Z\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_Z\"] = 34074] = \"TEXTURE_CUBE_MAP_NEGATIVE_Z\";\n})(TARGETS || (TARGETS = {}));\n/**\n * Various GL data format types.\n *\n * @memberof PIXI\n * @static\n * @name TYPES\n * @enum {number}\n * @property {number} UNSIGNED_BYTE=5121\n * @property {number} UNSIGNED_SHORT=5123\n * @property {number} UNSIGNED_SHORT_5_6_5=33635\n * @property {number} UNSIGNED_SHORT_4_4_4_4=32819\n * @property {number} UNSIGNED_SHORT_5_5_5_1=32820\n * @property {number} FLOAT=5126\n * @property {number} HALF_FLOAT=36193\n */\nvar TYPES;\n(function (TYPES) {\n    TYPES[TYPES[\"UNSIGNED_BYTE\"] = 5121] = \"UNSIGNED_BYTE\";\n    TYPES[TYPES[\"UNSIGNED_SHORT\"] = 5123] = \"UNSIGNED_SHORT\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_5_6_5\"] = 33635] = \"UNSIGNED_SHORT_5_6_5\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_4_4_4_4\"] = 32819] = \"UNSIGNED_SHORT_4_4_4_4\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_5_5_5_1\"] = 32820] = \"UNSIGNED_SHORT_5_5_5_1\";\n    TYPES[TYPES[\"FLOAT\"] = 5126] = \"FLOAT\";\n    TYPES[TYPES[\"HALF_FLOAT\"] = 36193] = \"HALF_FLOAT\";\n})(TYPES || (TYPES = {}));\n/**\n * The scale modes that are supported by pixi.\n *\n * The {@link PIXI.settings.SCALE_MODE} scale mode affects the default scaling mode of future operations.\n * It can be re-assigned to either LINEAR or NEAREST, depending upon suitability.\n *\n * @memberof PIXI\n * @static\n * @name SCALE_MODES\n * @enum {number}\n * @property {number} LINEAR Smooth scaling\n * @property {number} NEAREST Pixelating scaling\n */\nvar SCALE_MODES;\n(function (SCALE_MODES) {\n    SCALE_MODES[SCALE_MODES[\"NEAREST\"] = 0] = \"NEAREST\";\n    SCALE_MODES[SCALE_MODES[\"LINEAR\"] = 1] = \"LINEAR\";\n})(SCALE_MODES || (SCALE_MODES = {}));\n/**\n * The wrap modes that are supported by pixi.\n *\n * The {@link PIXI.settings.WRAP_MODE} wrap mode affects the default wrapping mode of future operations.\n * It can be re-assigned to either CLAMP or REPEAT, depending upon suitability.\n * If the texture is non power of two then clamp will be used regardless as WebGL can\n * only use REPEAT if the texture is po2.\n *\n * This property only affects WebGL.\n *\n * @name WRAP_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} CLAMP - The textures uvs are clamped\n * @property {number} REPEAT - The texture uvs tile and repeat\n * @property {number} MIRRORED_REPEAT - The texture uvs tile and repeat with mirroring\n */\nvar WRAP_MODES;\n(function (WRAP_MODES) {\n    WRAP_MODES[WRAP_MODES[\"CLAMP\"] = 33071] = \"CLAMP\";\n    WRAP_MODES[WRAP_MODES[\"REPEAT\"] = 10497] = \"REPEAT\";\n    WRAP_MODES[WRAP_MODES[\"MIRRORED_REPEAT\"] = 33648] = \"MIRRORED_REPEAT\";\n})(WRAP_MODES || (WRAP_MODES = {}));\n/**\n * Mipmap filtering modes that are supported by pixi.\n *\n * The {@link PIXI.settings.MIPMAP_TEXTURES} affects default texture filtering.\n * Mipmaps are generated for a baseTexture if its `mipmap` field is `ON`,\n * or its `POW2` and texture dimensions are powers of 2.\n * Due to platform restriction, `ON` option will work like `POW2` for webgl-1.\n *\n * This property only affects WebGL.\n *\n * @name MIPMAP_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} OFF - No mipmaps\n * @property {number} POW2 - Generate mipmaps if texture dimensions are pow2\n * @property {number} ON - Always generate mipmaps\n */\nvar MIPMAP_MODES;\n(function (MIPMAP_MODES) {\n    MIPMAP_MODES[MIPMAP_MODES[\"OFF\"] = 0] = \"OFF\";\n    MIPMAP_MODES[MIPMAP_MODES[\"POW2\"] = 1] = \"POW2\";\n    MIPMAP_MODES[MIPMAP_MODES[\"ON\"] = 2] = \"ON\";\n})(MIPMAP_MODES || (MIPMAP_MODES = {}));\n/**\n * How to treat textures with premultiplied alpha\n *\n * @name ALPHA_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NO_PREMULTIPLIED_ALPHA - Source is not premultiplied, leave it like that.\n *  Option for compressed and data textures that are created from typed arrays.\n * @property {number} PREMULTIPLY_ON_UPLOAD - Source is not premultiplied, premultiply on upload.\n *  Default option, used for all loaded images.\n * @property {number} PREMULTIPLIED_ALPHA - Source is already premultiplied\n *  Example: spine atlases with `_pma` suffix.\n * @property {number} NPM - Alias for NO_PREMULTIPLIED_ALPHA.\n * @property {number} UNPACK - Default option, alias for PREMULTIPLY_ON_UPLOAD.\n * @property {number} PMA - Alias for PREMULTIPLIED_ALPHA.\n */\nvar ALPHA_MODES;\n(function (ALPHA_MODES) {\n    ALPHA_MODES[ALPHA_MODES[\"NPM\"] = 0] = \"NPM\";\n    ALPHA_MODES[ALPHA_MODES[\"UNPACK\"] = 1] = \"UNPACK\";\n    ALPHA_MODES[ALPHA_MODES[\"PMA\"] = 2] = \"PMA\";\n    ALPHA_MODES[ALPHA_MODES[\"NO_PREMULTIPLIED_ALPHA\"] = 0] = \"NO_PREMULTIPLIED_ALPHA\";\n    ALPHA_MODES[ALPHA_MODES[\"PREMULTIPLY_ON_UPLOAD\"] = 1] = \"PREMULTIPLY_ON_UPLOAD\";\n    ALPHA_MODES[ALPHA_MODES[\"PREMULTIPLY_ALPHA\"] = 2] = \"PREMULTIPLY_ALPHA\";\n})(ALPHA_MODES || (ALPHA_MODES = {}));\n/**\n * How to clear renderTextures in filter\n *\n * @name CLEAR_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} BLEND - Preserve the information in the texture, blend above\n * @property {number} CLEAR - Must use `gl.clear` operation\n * @property {number} BLIT - Clear or blit it, depends on device and level of paranoia\n * @property {number} NO - Alias for BLEND, same as `false` in earlier versions\n * @property {number} YES - Alias for CLEAR, same as `true` in earlier versions\n * @property {number} AUTO - Alias for BLIT\n */\nvar CLEAR_MODES;\n(function (CLEAR_MODES) {\n    CLEAR_MODES[CLEAR_MODES[\"NO\"] = 0] = \"NO\";\n    CLEAR_MODES[CLEAR_MODES[\"YES\"] = 1] = \"YES\";\n    CLEAR_MODES[CLEAR_MODES[\"AUTO\"] = 2] = \"AUTO\";\n    CLEAR_MODES[CLEAR_MODES[\"BLEND\"] = 0] = \"BLEND\";\n    CLEAR_MODES[CLEAR_MODES[\"CLEAR\"] = 1] = \"CLEAR\";\n    CLEAR_MODES[CLEAR_MODES[\"BLIT\"] = 2] = \"BLIT\";\n})(CLEAR_MODES || (CLEAR_MODES = {}));\n/**\n * The gc modes that are supported by pixi.\n *\n * The {@link PIXI.settings.GC_MODE} Garbage Collection mode for PixiJS textures is AUTO\n * If set to GC_MODE, the renderer will occasionally check textures usage. If they are not\n * used for a specified period of time they will be removed from the GPU. They will of course\n * be uploaded again when they are required. This is a silent behind the scenes process that\n * should ensure that the GPU does not  get filled up.\n *\n * Handy for mobile devices!\n * This property only affects WebGL.\n *\n * @name GC_MODES\n * @enum {number}\n * @static\n * @memberof PIXI\n * @property {number} AUTO - Garbage collection will happen periodically automatically\n * @property {number} MANUAL - Garbage collection will need to be called manually\n */\nvar GC_MODES;\n(function (GC_MODES) {\n    GC_MODES[GC_MODES[\"AUTO\"] = 0] = \"AUTO\";\n    GC_MODES[GC_MODES[\"MANUAL\"] = 1] = \"MANUAL\";\n})(GC_MODES || (GC_MODES = {}));\n/**\n * Constants that specify float precision in shaders.\n *\n * @name PRECISION\n * @memberof PIXI\n * @constant\n * @static\n * @enum {string}\n * @property {string} LOW='lowp'\n * @property {string} MEDIUM='mediump'\n * @property {string} HIGH='highp'\n */\nvar PRECISION;\n(function (PRECISION) {\n    PRECISION[\"LOW\"] = \"lowp\";\n    PRECISION[\"MEDIUM\"] = \"mediump\";\n    PRECISION[\"HIGH\"] = \"highp\";\n})(PRECISION || (PRECISION = {}));\n/**\n * Constants for mask implementations.\n * We use `type` suffix because it leads to very different behaviours\n *\n * @name MASK_TYPES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NONE - Mask is ignored\n * @property {number} SCISSOR - Scissor mask, rectangle on screen, cheap\n * @property {number} STENCIL - Stencil mask, 1-bit, medium, works only if renderer supports stencil\n * @property {number} SPRITE - Mask that uses SpriteMaskFilter, uses temporary RenderTexture\n */\nvar MASK_TYPES;\n(function (MASK_TYPES) {\n    MASK_TYPES[MASK_TYPES[\"NONE\"] = 0] = \"NONE\";\n    MASK_TYPES[MASK_TYPES[\"SCISSOR\"] = 1] = \"SCISSOR\";\n    MASK_TYPES[MASK_TYPES[\"STENCIL\"] = 2] = \"STENCIL\";\n    MASK_TYPES[MASK_TYPES[\"SPRITE\"] = 3] = \"SPRITE\";\n})(MASK_TYPES || (MASK_TYPES = {}));\n/**\n * Constants for multi-sampling antialiasing.\n *\n * @see PIXI.Framebuffer#multisample\n *\n * @name MSAA_QUALITY\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NONE - No multisampling for this renderTexture\n * @property {number} LOW - Try 2 samples\n * @property {number} MEDIUM - Try 4 samples\n * @property {number} HIGH - Try 8 samples\n */\nvar MSAA_QUALITY;\n(function (MSAA_QUALITY) {\n    MSAA_QUALITY[MSAA_QUALITY[\"NONE\"] = 0] = \"NONE\";\n    MSAA_QUALITY[MSAA_QUALITY[\"LOW\"] = 2] = \"LOW\";\n    MSAA_QUALITY[MSAA_QUALITY[\"MEDIUM\"] = 4] = \"MEDIUM\";\n    MSAA_QUALITY[MSAA_QUALITY[\"HIGH\"] = 8] = \"HIGH\";\n})(MSAA_QUALITY || (MSAA_QUALITY = {}));\n\n\n//# sourceMappingURL=constants.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/constants/lib/constants.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/core/lib/core.es.js":
/*!************************************************!*\
  !*** ./node_modules/@pixi/core/lib/core.es.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AbstractBatchRenderer\": () => (/* binding */ AbstractBatchRenderer),\n/* harmony export */   \"AbstractRenderer\": () => (/* binding */ AbstractRenderer),\n/* harmony export */   \"Attribute\": () => (/* binding */ Attribute),\n/* harmony export */   \"BaseRenderTexture\": () => (/* binding */ BaseRenderTexture),\n/* harmony export */   \"BaseTexture\": () => (/* binding */ BaseTexture),\n/* harmony export */   \"BatchDrawCall\": () => (/* binding */ BatchDrawCall),\n/* harmony export */   \"BatchGeometry\": () => (/* binding */ BatchGeometry),\n/* harmony export */   \"BatchPluginFactory\": () => (/* binding */ BatchPluginFactory),\n/* harmony export */   \"BatchRenderer\": () => (/* binding */ BatchRenderer),\n/* harmony export */   \"BatchShaderGenerator\": () => (/* binding */ BatchShaderGenerator),\n/* harmony export */   \"BatchTextureArray\": () => (/* binding */ BatchTextureArray),\n/* harmony export */   \"Buffer\": () => (/* binding */ Buffer),\n/* harmony export */   \"Filter\": () => (/* binding */ Filter),\n/* harmony export */   \"FilterState\": () => (/* binding */ FilterState),\n/* harmony export */   \"Framebuffer\": () => (/* binding */ Framebuffer),\n/* harmony export */   \"GLFramebuffer\": () => (/* binding */ GLFramebuffer),\n/* harmony export */   \"GLProgram\": () => (/* binding */ GLProgram),\n/* harmony export */   \"GLTexture\": () => (/* binding */ GLTexture),\n/* harmony export */   \"Geometry\": () => (/* binding */ Geometry),\n/* harmony export */   \"IGLUniformData\": () => (/* binding */ IGLUniformData),\n/* harmony export */   \"MaskData\": () => (/* binding */ MaskData),\n/* harmony export */   \"ObjectRenderer\": () => (/* binding */ ObjectRenderer),\n/* harmony export */   \"Program\": () => (/* binding */ Program),\n/* harmony export */   \"Quad\": () => (/* binding */ Quad),\n/* harmony export */   \"QuadUv\": () => (/* binding */ QuadUv),\n/* harmony export */   \"RenderTexture\": () => (/* binding */ RenderTexture),\n/* harmony export */   \"RenderTexturePool\": () => (/* binding */ RenderTexturePool),\n/* harmony export */   \"Renderer\": () => (/* binding */ Renderer),\n/* harmony export */   \"Shader\": () => (/* binding */ Shader),\n/* harmony export */   \"SpriteMaskFilter\": () => (/* binding */ SpriteMaskFilter),\n/* harmony export */   \"State\": () => (/* binding */ State),\n/* harmony export */   \"System\": () => (/* binding */ System),\n/* harmony export */   \"Texture\": () => (/* binding */ Texture),\n/* harmony export */   \"TextureMatrix\": () => (/* binding */ TextureMatrix),\n/* harmony export */   \"TextureUvs\": () => (/* binding */ TextureUvs),\n/* harmony export */   \"UniformGroup\": () => (/* binding */ UniformGroup),\n/* harmony export */   \"ViewableBuffer\": () => (/* binding */ ViewableBuffer),\n/* harmony export */   \"autoDetectRenderer\": () => (/* binding */ autoDetectRenderer),\n/* harmony export */   \"checkMaxIfStatementsInShader\": () => (/* binding */ checkMaxIfStatementsInShader),\n/* harmony export */   \"defaultFilterVertex\": () => (/* binding */ defaultFilter),\n/* harmony export */   \"defaultVertex\": () => (/* binding */ _default),\n/* harmony export */   \"resources\": () => (/* binding */ index),\n/* harmony export */   \"systems\": () => (/* binding */ systems),\n/* harmony export */   \"uniformParsers\": () => (/* binding */ uniformParsers)\n/* harmony export */ });\n/* harmony import */ var _pixi_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/settings */ \"./node_modules/@pixi/settings/lib/settings.es.js\");\n/* harmony import */ var _pixi_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/constants */ \"./node_modules/@pixi/constants/lib/constants.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/* harmony import */ var _pixi_runner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @pixi/runner */ \"./node_modules/@pixi/runner/lib/runner.es.js\");\n/* harmony import */ var _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @pixi/ticker */ \"./node_modules/@pixi/ticker/lib/ticker.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/*!\n * @pixi/core - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/core is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n\n\n\n/**\n * The maximum support for using WebGL. If a device does not\n * support WebGL version, for instance WebGL 2, it will still\n * attempt to fallback support to WebGL 1. If you want to\n * explicitly remove feature support to target a more stable\n * baseline, prefer a lower environment.\n *\n * Due to {@link https://bugs.chromium.org/p/chromium/issues/detail?id=934823|bug in chromium}\n * we disable webgl2 by default for all non-apple mobile devices.\n *\n * @static\n * @name PREFER_ENV\n * @memberof PIXI.settings\n * @type {number}\n * @default PIXI.ENV.WEBGL2\n */\n_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.isMobile.any ? _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL : _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL2;\n/**\n * If set to `true`, *only* Textures and BaseTexture objects stored\n * in the caches ({@link PIXI.utils.TextureCache TextureCache} and\n * {@link PIXI.utils.BaseTextureCache BaseTextureCache}) can be\n * used when calling {@link PIXI.Texture.from Texture.from} or\n * {@link PIXI.BaseTexture.from BaseTexture.from}.\n * Otherwise, these `from` calls throw an exception. Using this property\n * can be useful if you want to enforce preloading all assets with\n * {@link PIXI.Loader Loader}.\n *\n * @static\n * @name STRICT_TEXTURE_CACHE\n * @memberof PIXI.settings\n * @type {boolean}\n * @default false\n */\n_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.STRICT_TEXTURE_CACHE = false;\n\n/**\n * Collection of installed resource types, class must extend {@link PIXI.resources.Resource}.\n * @example\n * class CustomResource extends PIXI.resources.Resource {\n *   // MUST have source, options constructor signature\n *   // for auto-detected resources to be created.\n *   constructor(source, options) {\n *     super();\n *   }\n *   upload(renderer, baseTexture, glTexture) {\n *     // upload with GL\n *     return true;\n *   }\n *   // used to auto-detect resource\n *   static test(source, extension) {\n *     return extension === 'xyz'|| source instanceof SomeClass;\n *   }\n * }\n * // Install the new resource type\n * PIXI.resources.INSTALLED.push(CustomResource);\n *\n * @name PIXI.resources.INSTALLED\n * @type {Array<*>}\n * @static\n * @readonly\n */\nvar INSTALLED = [];\n/**\n * Create a resource element from a single source element. This\n * auto-detects which type of resource to create. All resources that\n * are auto-detectable must have a static `test` method and a constructor\n * with the arguments `(source, options?)`. Currently, the supported\n * resources for auto-detection include:\n *  - {@link PIXI.resources.ImageResource}\n *  - {@link PIXI.resources.CanvasResource}\n *  - {@link PIXI.resources.VideoResource}\n *  - {@link PIXI.resources.SVGResource}\n *  - {@link PIXI.resources.BufferResource}\n * @static\n * @function PIXI.resources.autoDetectResource\n * @param {string|*} source - Resource source, this can be the URL to the resource,\n *        a typed-array (for BufferResource), HTMLVideoElement, SVG data-uri\n *        or any other resource that can be auto-detected. If not resource is\n *        detected, it's assumed to be an ImageResource.\n * @param {object} [options] - Pass-through options to use for Resource\n * @param {number} [options.width] - Width of BufferResource or SVG rasterization\n * @param {number} [options.height] - Height of BufferResource or SVG rasterization\n * @param {boolean} [options.autoLoad=true] - Image, SVG and Video flag to start loading\n * @param {number} [options.scale=1] - SVG source scale. Overridden by width, height\n * @param {boolean} [options.createBitmap=PIXI.settings.CREATE_IMAGE_BITMAP] - Image option to create Bitmap object\n * @param {boolean} [options.crossorigin=true] - Image and Video option to set crossOrigin\n * @param {boolean} [options.autoPlay=true] - Video option to start playing video immediately\n * @param {number} [options.updateFPS=0] - Video option to update how many times a second the\n *        texture should be updated from the video. Leave at 0 to update at every render\n * @return {PIXI.resources.Resource} The created resource.\n */\nfunction autoDetectResource(source, options) {\n    if (!source) {\n        return null;\n    }\n    var extension = '';\n    if (typeof source === 'string') {\n        // search for file extension: period, 3-4 chars, then ?, # or EOL\n        var result = (/\\.(\\w{3,4})(?:$|\\?|#)/i).exec(source);\n        if (result) {\n            extension = result[1].toLowerCase();\n        }\n    }\n    for (var i = INSTALLED.length - 1; i >= 0; --i) {\n        var ResourcePlugin = INSTALLED[i];\n        if (ResourcePlugin.test && ResourcePlugin.test(source, extension)) {\n            return new ResourcePlugin(source, options);\n        }\n    }\n    throw new Error('Unrecognized source type to auto-detect Resource');\n}\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * Base resource class for textures that manages validation and uploading, depending on its type.\n *\n * Uploading of a base texture to the GPU is required.\n *\n * @class\n * @memberof PIXI.resources\n */\nvar Resource = /** @class */ (function () {\n    /**\n     * @param {number} [width=0] - Width of the resource\n     * @param {number} [height=0] - Height of the resource\n     */\n    function Resource(width, height) {\n        if (width === void 0) { width = 0; }\n        if (height === void 0) { height = 0; }\n        /**\n         * Internal width of the resource\n         * @member {number}\n         * @protected\n         */\n        this._width = width;\n        /**\n         * Internal height of the resource\n         * @member {number}\n         * @protected\n         */\n        this._height = height;\n        /**\n         * If resource has been destroyed\n         * @member {boolean}\n         * @readonly\n         * @default false\n         */\n        this.destroyed = false;\n        /**\n         * `true` if resource is created by BaseTexture\n         * useful for doing cleanup with BaseTexture destroy\n         * and not cleaning up resources that were created\n         * externally.\n         * @member {boolean}\n         * @protected\n         */\n        this.internal = false;\n        /**\n         * Mini-runner for handling resize events\n         * accepts 2 parameters: width, height\n         *\n         * @member {Runner}\n         * @private\n         */\n        this.onResize = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('setRealSize');\n        /**\n         * Mini-runner for handling update events\n         *\n         * @member {Runner}\n         * @private\n         */\n        this.onUpdate = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('update');\n        /**\n         * Handle internal errors, such as loading errors\n         * accepts 1 param: error\n         *\n         * @member {Runner}\n         * @private\n         */\n        this.onError = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('onError');\n    }\n    /**\n     * Bind to a parent BaseTexture\n     *\n     * @param {PIXI.BaseTexture} baseTexture - Parent texture\n     */\n    Resource.prototype.bind = function (baseTexture) {\n        this.onResize.add(baseTexture);\n        this.onUpdate.add(baseTexture);\n        this.onError.add(baseTexture);\n        // Call a resize immediate if we already\n        // have the width and height of the resource\n        if (this._width || this._height) {\n            this.onResize.emit(this._width, this._height);\n        }\n    };\n    /**\n     * Unbind to a parent BaseTexture\n     *\n     * @param {PIXI.BaseTexture} baseTexture - Parent texture\n     */\n    Resource.prototype.unbind = function (baseTexture) {\n        this.onResize.remove(baseTexture);\n        this.onUpdate.remove(baseTexture);\n        this.onError.remove(baseTexture);\n    };\n    /**\n     * Trigger a resize event\n     * @param {number} width - X dimension\n     * @param {number} height - Y dimension\n     */\n    Resource.prototype.resize = function (width, height) {\n        if (width !== this._width || height !== this._height) {\n            this._width = width;\n            this._height = height;\n            this.onResize.emit(width, height);\n        }\n    };\n    Object.defineProperty(Resource.prototype, \"valid\", {\n        /**\n         * Has been validated\n         * @readonly\n         * @member {boolean}\n         */\n        get: function () {\n            return !!this._width && !!this._height;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Has been updated trigger event\n     */\n    Resource.prototype.update = function () {\n        if (!this.destroyed) {\n            this.onUpdate.emit();\n        }\n    };\n    /**\n     * This can be overridden to start preloading a resource\n     * or do any other prepare step.\n     * @protected\n     * @return {Promise<void>} Handle the validate event\n     */\n    Resource.prototype.load = function () {\n        return Promise.resolve(this);\n    };\n    Object.defineProperty(Resource.prototype, \"width\", {\n        /**\n         * The width of the resource.\n         *\n         * @member {number}\n         * @readonly\n         */\n        get: function () {\n            return this._width;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Resource.prototype, \"height\", {\n        /**\n         * The height of the resource.\n         *\n         * @member {number}\n         * @readonly\n         */\n        get: function () {\n            return this._height;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Set the style, optional to override\n     *\n     * @param {PIXI.Renderer} renderer - yeah, renderer!\n     * @param {PIXI.BaseTexture} baseTexture - the texture\n     * @param {PIXI.GLTexture} glTexture - texture instance for this webgl context\n     * @returns {boolean} `true` is success\n     */\n    Resource.prototype.style = function (_renderer, _baseTexture, _glTexture) {\n        return false;\n    };\n    /**\n     * Clean up anything, this happens when destroying is ready.\n     *\n     * @protected\n     */\n    Resource.prototype.dispose = function () {\n        // override\n    };\n    /**\n     * Call when destroying resource, unbind any BaseTexture object\n     * before calling this method, as reference counts are maintained\n     * internally.\n     */\n    Resource.prototype.destroy = function () {\n        if (!this.destroyed) {\n            this.destroyed = true;\n            this.dispose();\n            this.onError.removeAll();\n            this.onError = null;\n            this.onResize.removeAll();\n            this.onResize = null;\n            this.onUpdate.removeAll();\n            this.onUpdate = null;\n        }\n    };\n    /**\n     * Abstract, used to auto-detect resource type\n     *\n     * @static\n     * @param {*} source - The source object\n     * @param {string} extension - The extension of source, if set\n     */\n    Resource.test = function (_source, _extension) {\n        return false;\n    };\n    return Resource;\n}());\n\n/**\n * @interface SharedArrayBuffer\n */\n/**\n * Buffer resource with data of typed array.\n * @class\n * @extends PIXI.resources.Resource\n * @memberof PIXI.resources\n */\nvar BufferResource = /** @class */ (function (_super) {\n    __extends(BufferResource, _super);\n    /**\n     * @param {Float32Array|Uint8Array|Uint32Array} source - Source buffer\n     * @param {object} options - Options\n     * @param {number} options.width - Width of the texture\n     * @param {number} options.height - Height of the texture\n     */\n    function BufferResource(source, options) {\n        var _this = this;\n        var _a = options || {}, width = _a.width, height = _a.height;\n        if (!width || !height) {\n            throw new Error('BufferResource width or height invalid');\n        }\n        _this = _super.call(this, width, height) || this;\n        /**\n         * Source array\n         * Cannot be ClampedUint8Array because it cant be uploaded to WebGL\n         *\n         * @member {Float32Array|Uint8Array|Uint32Array}\n         */\n        _this.data = source;\n        return _this;\n    }\n    /**\n     * Upload the texture to the GPU.\n     * @param {PIXI.Renderer} renderer - Upload to the renderer\n     * @param {PIXI.BaseTexture} baseTexture - Reference to parent texture\n     * @param {PIXI.GLTexture} glTexture - glTexture\n     * @returns {boolean} true is success\n     */\n    BufferResource.prototype.upload = function (renderer, baseTexture, glTexture) {\n        var gl = renderer.gl;\n        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, baseTexture.alphaMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.UNPACK);\n        if (glTexture.width === baseTexture.width && glTexture.height === baseTexture.height) {\n            gl.texSubImage2D(baseTexture.target, 0, 0, 0, baseTexture.width, baseTexture.height, baseTexture.format, baseTexture.type, this.data);\n        }\n        else {\n            glTexture.width = baseTexture.width;\n            glTexture.height = baseTexture.height;\n            gl.texImage2D(baseTexture.target, 0, glTexture.internalFormat, baseTexture.width, baseTexture.height, 0, baseTexture.format, glTexture.type, this.data);\n        }\n        return true;\n    };\n    /**\n     * Destroy and don't use after this\n     * @override\n     */\n    BufferResource.prototype.dispose = function () {\n        this.data = null;\n    };\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {*} source - The source object\n     * @return {boolean} `true` if <canvas>\n     */\n    BufferResource.test = function (source) {\n        return source instanceof Float32Array\n            || source instanceof Uint8Array\n            || source instanceof Uint32Array;\n    };\n    return BufferResource;\n}(Resource));\n\nvar defaultBufferOptions = {\n    scaleMode: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.NEAREST,\n    format: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.FORMATS.RGBA,\n    alphaMode: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.NPM,\n};\n/**\n * A Texture stores the information that represents an image.\n * All textures have a base texture, which contains information about the source.\n * Therefore you can have many textures all using a single BaseTexture\n *\n * @class\n * @extends PIXI.utils.EventEmitter\n * @memberof PIXI\n * @param {PIXI.resources.Resource|string|HTMLImageElement|HTMLCanvasElement|HTMLVideoElement} [resource=null]\n *        The current resource to use, for things that aren't Resource objects, will be converted\n *        into a Resource.\n * @param {Object} [options] - Collection of options\n * @param {PIXI.MIPMAP_MODES} [options.mipmap=PIXI.settings.MIPMAP_TEXTURES] - If mipmapping is enabled for texture\n * @param {number} [options.anisotropicLevel=PIXI.settings.ANISOTROPIC_LEVEL] - Anisotropic filtering level of texture\n * @param {PIXI.WRAP_MODES} [options.wrapMode=PIXI.settings.WRAP_MODE] - Wrap mode for textures\n * @param {PIXI.SCALE_MODES} [options.scaleMode=PIXI.settings.SCALE_MODE] - Default scale mode, linear, nearest\n * @param {PIXI.FORMATS} [options.format=PIXI.FORMATS.RGBA] - GL format type\n * @param {PIXI.TYPES} [options.type=PIXI.TYPES.UNSIGNED_BYTE] - GL data type\n * @param {PIXI.TARGETS} [options.target=PIXI.TARGETS.TEXTURE_2D] - GL texture target\n * @param {PIXI.ALPHA_MODES} [options.alphaMode=PIXI.ALPHA_MODES.UNPACK] - Pre multiply the image alpha\n * @param {number} [options.width=0] - Width of the texture\n * @param {number} [options.height=0] - Height of the texture\n * @param {number} [options.resolution] - Resolution of the base texture\n * @param {object} [options.resourceOptions] - Optional resource options,\n *        see {@link PIXI.resources.autoDetectResource autoDetectResource}\n */\nvar BaseTexture = /** @class */ (function (_super) {\n    __extends(BaseTexture, _super);\n    function BaseTexture(resource, options) {\n        if (resource === void 0) { resource = null; }\n        if (options === void 0) { options = null; }\n        var _this = _super.call(this) || this;\n        options = options || {};\n        var alphaMode = options.alphaMode, mipmap = options.mipmap, anisotropicLevel = options.anisotropicLevel, scaleMode = options.scaleMode, width = options.width, height = options.height, wrapMode = options.wrapMode, format = options.format, type = options.type, target = options.target, resolution = options.resolution, resourceOptions = options.resourceOptions;\n        // Convert the resource to a Resource object\n        if (resource && !(resource instanceof Resource)) {\n            resource = autoDetectResource(resource, resourceOptions);\n            resource.internal = true;\n        }\n        /**\n         * The width of the base texture set when the image has loaded\n         *\n         * @readonly\n         * @member {number}\n         */\n        _this.width = width || 0;\n        /**\n         * The height of the base texture set when the image has loaded\n         *\n         * @readonly\n         * @member {number}\n         */\n        _this.height = height || 0;\n        /**\n         * The resolution / device pixel ratio of the texture\n         *\n         * @member {number}\n         * @default PIXI.settings.RESOLUTION\n         */\n        _this.resolution = resolution || _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.RESOLUTION;\n        /**\n         * Mipmap mode of the texture, affects downscaled images\n         *\n         * @member {PIXI.MIPMAP_MODES}\n         * @default PIXI.settings.MIPMAP_TEXTURES\n         */\n        _this.mipmap = mipmap !== undefined ? mipmap : _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.MIPMAP_TEXTURES;\n        /**\n         * Anisotropic filtering level of texture\n         *\n         * @member {number}\n         * @default PIXI.settings.ANISOTROPIC_LEVEL\n         */\n        _this.anisotropicLevel = anisotropicLevel !== undefined ? anisotropicLevel : _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.ANISOTROPIC_LEVEL;\n        /**\n         * How the texture wraps\n         * @member {number}\n         */\n        _this.wrapMode = wrapMode || _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.WRAP_MODE;\n        /**\n         * The scale mode to apply when scaling this texture\n         *\n         * @member {PIXI.SCALE_MODES}\n         * @default PIXI.settings.SCALE_MODE\n         */\n        _this.scaleMode = scaleMode !== undefined ? scaleMode : _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SCALE_MODE;\n        /**\n         * The pixel format of the texture\n         *\n         * @member {PIXI.FORMATS}\n         * @default PIXI.FORMATS.RGBA\n         */\n        _this.format = format || _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.FORMATS.RGBA;\n        /**\n         * The type of resource data\n         *\n         * @member {PIXI.TYPES}\n         * @default PIXI.TYPES.UNSIGNED_BYTE\n         */\n        _this.type = type || _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.UNSIGNED_BYTE;\n        /**\n         * The target type\n         *\n         * @member {PIXI.TARGETS}\n         * @default PIXI.TARGETS.TEXTURE_2D\n         */\n        _this.target = target || _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TARGETS.TEXTURE_2D;\n        /**\n         * How to treat premultiplied alpha, see {@link PIXI.ALPHA_MODES}.\n         *\n         * @member {PIXI.ALPHA_MODES}\n         * @default PIXI.ALPHA_MODES.UNPACK\n         */\n        _this.alphaMode = alphaMode !== undefined ? alphaMode : _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.UNPACK;\n        if (options.premultiplyAlpha !== undefined) {\n            // triggers deprecation\n            _this.premultiplyAlpha = options.premultiplyAlpha;\n        }\n        /**\n         * Global unique identifier for this BaseTexture\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.uid = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.uid)();\n        /**\n         * Used by automatic texture Garbage Collection, stores last GC tick when it was bound\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.touched = 0;\n        /**\n         * Whether or not the texture is a power of two, try to use power of two textures as much\n         * as you can\n         *\n         * @readonly\n         * @member {boolean}\n         * @default false\n         */\n        _this.isPowerOfTwo = false;\n        _this._refreshPOT();\n        /**\n         * The map of render context textures where this is bound\n         *\n         * @member {Object}\n         * @private\n         */\n        _this._glTextures = {};\n        /**\n         * Used by TextureSystem to only update texture to the GPU when needed.\n         * Please call `update()` to increment it.\n         *\n         * @readonly\n         * @member {number}\n         */\n        _this.dirtyId = 0;\n        /**\n         * Used by TextureSystem to only update texture style when needed.\n         *\n         * @protected\n         * @member {number}\n         */\n        _this.dirtyStyleId = 0;\n        /**\n         * Currently default cache ID.\n         *\n         * @member {string}\n         */\n        _this.cacheId = null;\n        /**\n         * Generally speaking means when resource is loaded.\n         * @readonly\n         * @member {boolean}\n         */\n        _this.valid = width > 0 && height > 0;\n        /**\n         * The collection of alternative cache ids, since some BaseTextures\n         * can have more than one ID, short name and longer full URL\n         *\n         * @member {Array<string>}\n         * @readonly\n         */\n        _this.textureCacheIds = [];\n        /**\n         * Flag if BaseTexture has been destroyed.\n         *\n         * @member {boolean}\n         * @readonly\n         */\n        _this.destroyed = false;\n        /**\n         * The resource used by this BaseTexture, there can only\n         * be one resource per BaseTexture, but textures can share\n         * resources.\n         *\n         * @member {PIXI.resources.Resource}\n         * @readonly\n         */\n        _this.resource = null;\n        /**\n         * Number of the texture batch, used by multi-texture renderers\n         *\n         * @member {number}\n         */\n        _this._batchEnabled = 0;\n        /**\n         * Location inside texture batch, used by multi-texture renderers\n         *\n         * @member {number}\n         */\n        _this._batchLocation = 0;\n        /**\n         * Whether its a part of another texture, handled by ArrayResource or CubeResource\n         *\n         * @member {PIXI.BaseTexture}\n         */\n        _this.parentTextureArray = null;\n        /**\n         * Fired when a not-immediately-available source finishes loading.\n         *\n         * @protected\n         * @event PIXI.BaseTexture#loaded\n         * @param {PIXI.BaseTexture} baseTexture - Resource loaded.\n         */\n        /**\n         * Fired when a not-immediately-available source fails to load.\n         *\n         * @protected\n         * @event PIXI.BaseTexture#error\n         * @param {PIXI.BaseTexture} baseTexture - Resource errored.\n         * @param {ErrorEvent} event - Load error event.\n         */\n        /**\n         * Fired when BaseTexture is updated.\n         *\n         * @protected\n         * @event PIXI.BaseTexture#loaded\n         * @param {PIXI.BaseTexture} baseTexture - Resource loaded.\n         */\n        /**\n         * Fired when BaseTexture is updated.\n         *\n         * @protected\n         * @event PIXI.BaseTexture#update\n         * @param {PIXI.BaseTexture} baseTexture - Instance of texture being updated.\n         */\n        /**\n         * Fired when BaseTexture is destroyed.\n         *\n         * @protected\n         * @event PIXI.BaseTexture#dispose\n         * @param {PIXI.BaseTexture} baseTexture - Instance of texture being destroyed.\n         */\n        // Set the resource\n        _this.setResource(resource);\n        return _this;\n    }\n    Object.defineProperty(BaseTexture.prototype, \"realWidth\", {\n        /**\n         * Pixel width of the source of this texture\n         *\n         * @readonly\n         * @member {number}\n         */\n        get: function () {\n            return Math.ceil((this.width * this.resolution) - 1e-4);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BaseTexture.prototype, \"realHeight\", {\n        /**\n         * Pixel height of the source of this texture\n         *\n         * @readonly\n         * @member {number}\n         */\n        get: function () {\n            return Math.ceil((this.height * this.resolution) - 1e-4);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Changes style options of BaseTexture\n     *\n     * @param {PIXI.SCALE_MODES} [scaleMode] - Pixi scalemode\n     * @param {PIXI.MIPMAP_MODES} [mipmap] - enable mipmaps\n     * @returns {PIXI.BaseTexture} this\n     */\n    BaseTexture.prototype.setStyle = function (scaleMode, mipmap) {\n        var dirty;\n        if (scaleMode !== undefined && scaleMode !== this.scaleMode) {\n            this.scaleMode = scaleMode;\n            dirty = true;\n        }\n        if (mipmap !== undefined && mipmap !== this.mipmap) {\n            this.mipmap = mipmap;\n            dirty = true;\n        }\n        if (dirty) {\n            this.dirtyStyleId++;\n        }\n        return this;\n    };\n    /**\n     * Changes w/h/resolution. Texture becomes valid if width and height are greater than zero.\n     *\n     * @param {number} width - Visual width\n     * @param {number} height - Visual height\n     * @param {number} [resolution] - Optionally set resolution\n     * @returns {PIXI.BaseTexture} this\n     */\n    BaseTexture.prototype.setSize = function (width, height, resolution) {\n        this.resolution = resolution || this.resolution;\n        this.width = width;\n        this.height = height;\n        this._refreshPOT();\n        this.update();\n        return this;\n    };\n    /**\n     * Sets real size of baseTexture, preserves current resolution.\n     *\n     * @param {number} realWidth - Full rendered width\n     * @param {number} realHeight - Full rendered height\n     * @param {number} [resolution] - Optionally set resolution\n     * @returns {PIXI.BaseTexture} this\n     */\n    BaseTexture.prototype.setRealSize = function (realWidth, realHeight, resolution) {\n        this.resolution = resolution || this.resolution;\n        this.width = realWidth / this.resolution;\n        this.height = realHeight / this.resolution;\n        this._refreshPOT();\n        this.update();\n        return this;\n    };\n    /**\n     * Refresh check for isPowerOfTwo texture based on size\n     *\n     * @private\n     */\n    BaseTexture.prototype._refreshPOT = function () {\n        this.isPowerOfTwo = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.isPow2)(this.realWidth) && (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.isPow2)(this.realHeight);\n    };\n    /**\n     * Changes resolution\n     *\n     * @param {number} resolution - res\n     * @returns {PIXI.BaseTexture} this\n     */\n    BaseTexture.prototype.setResolution = function (resolution) {\n        var oldResolution = this.resolution;\n        if (oldResolution === resolution) {\n            return this;\n        }\n        this.resolution = resolution;\n        if (this.valid) {\n            this.width = this.width * oldResolution / resolution;\n            this.height = this.height * oldResolution / resolution;\n            this.emit('update', this);\n        }\n        this._refreshPOT();\n        return this;\n    };\n    /**\n     * Sets the resource if it wasn't set. Throws error if resource already present\n     *\n     * @param {PIXI.resources.Resource} resource - that is managing this BaseTexture\n     * @returns {PIXI.BaseTexture} this\n     */\n    BaseTexture.prototype.setResource = function (resource) {\n        if (this.resource === resource) {\n            return this;\n        }\n        if (this.resource) {\n            throw new Error('Resource can be set only once');\n        }\n        resource.bind(this);\n        this.resource = resource;\n        return this;\n    };\n    /**\n     * Invalidates the object. Texture becomes valid if width and height are greater than zero.\n     */\n    BaseTexture.prototype.update = function () {\n        if (!this.valid) {\n            if (this.width > 0 && this.height > 0) {\n                this.valid = true;\n                this.emit('loaded', this);\n                this.emit('update', this);\n            }\n        }\n        else {\n            this.dirtyId++;\n            this.dirtyStyleId++;\n            this.emit('update', this);\n        }\n    };\n    /**\n     * Handle errors with resources.\n     * @private\n     * @param {ErrorEvent} event - Error event emitted.\n     */\n    BaseTexture.prototype.onError = function (event) {\n        this.emit('error', this, event);\n    };\n    /**\n     * Destroys this base texture.\n     * The method stops if resource doesn't want this texture to be destroyed.\n     * Removes texture from all caches.\n     */\n    BaseTexture.prototype.destroy = function () {\n        // remove and destroy the resource\n        if (this.resource) {\n            this.resource.unbind(this);\n            // only destroy resourced created internally\n            if (this.resource.internal) {\n                this.resource.destroy();\n            }\n            this.resource = null;\n        }\n        if (this.cacheId) {\n            delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[this.cacheId];\n            delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[this.cacheId];\n            this.cacheId = null;\n        }\n        // finally let the WebGL renderer know..\n        this.dispose();\n        BaseTexture.removeFromCache(this);\n        this.textureCacheIds = null;\n        this.destroyed = true;\n    };\n    /**\n     * Frees the texture from WebGL memory without destroying this texture object.\n     * This means you can still use the texture later which will upload it to GPU\n     * memory again.\n     *\n     * @fires PIXI.BaseTexture#dispose\n     */\n    BaseTexture.prototype.dispose = function () {\n        this.emit('dispose', this);\n    };\n    /**\n     * Utility function for BaseTexture|Texture cast\n     */\n    BaseTexture.prototype.castToBaseTexture = function () {\n        return this;\n    };\n    /**\n     * Helper function that creates a base texture based on the source you provide.\n     * The source can be - image url, image element, canvas element. If the\n     * source is an image url or an image element and not in the base texture\n     * cache, it will be created and loaded.\n     *\n     * @static\n     * @param {string|HTMLImageElement|HTMLCanvasElement|SVGElement|HTMLVideoElement} source - The\n     *        source to create base texture from.\n     * @param {object} [options] See {@link PIXI.BaseTexture}'s constructor for options.\n     * @param {boolean} [strict] - Enforce strict-mode, see {@link PIXI.settings.STRICT_TEXTURE_CACHE}.\n     * @returns {PIXI.BaseTexture} The new base texture.\n     */\n    BaseTexture.from = function (source, options, strict) {\n        if (strict === void 0) { strict = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.STRICT_TEXTURE_CACHE; }\n        var isFrame = typeof source === 'string';\n        var cacheId = null;\n        if (isFrame) {\n            cacheId = source;\n        }\n        else {\n            if (!source._pixiId) {\n                source._pixiId = \"pixiid_\" + (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.uid)();\n            }\n            cacheId = source._pixiId;\n        }\n        var baseTexture = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[cacheId];\n        // Strict-mode rejects invalid cacheIds\n        if (isFrame && strict && !baseTexture) {\n            throw new Error(\"The cacheId \\\"\" + cacheId + \"\\\" does not exist in BaseTextureCache.\");\n        }\n        if (!baseTexture) {\n            baseTexture = new BaseTexture(source, options);\n            baseTexture.cacheId = cacheId;\n            BaseTexture.addToCache(baseTexture, cacheId);\n        }\n        return baseTexture;\n    };\n    /**\n     * Create a new BaseTexture with a BufferResource from a Float32Array.\n     * RGBA values are floats from 0 to 1.\n     * @static\n     * @param {Float32Array|Uint8Array} buffer - The optional array to use, if no data\n     *        is provided, a new Float32Array is created.\n     * @param {number} width - Width of the resource\n     * @param {number} height - Height of the resource\n     * @param {object} [options] See {@link PIXI.BaseTexture}'s constructor for options.\n     * @return {PIXI.BaseTexture} The resulting new BaseTexture\n     */\n    BaseTexture.fromBuffer = function (buffer, width, height, options) {\n        buffer = buffer || new Float32Array(width * height * 4);\n        var resource = new BufferResource(buffer, { width: width, height: height });\n        var type = buffer instanceof Float32Array ? _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.FLOAT : _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.UNSIGNED_BYTE;\n        return new BaseTexture(resource, Object.assign(defaultBufferOptions, options || { width: width, height: height, type: type }));\n    };\n    /**\n     * Adds a BaseTexture to the global BaseTextureCache. This cache is shared across the whole PIXI object.\n     *\n     * @static\n     * @param {PIXI.BaseTexture} baseTexture - The BaseTexture to add to the cache.\n     * @param {string} id - The id that the BaseTexture will be stored against.\n     */\n    BaseTexture.addToCache = function (baseTexture, id) {\n        if (id) {\n            if (baseTexture.textureCacheIds.indexOf(id) === -1) {\n                baseTexture.textureCacheIds.push(id);\n            }\n            if (_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[id]) {\n                // eslint-disable-next-line no-console\n                console.warn(\"BaseTexture added to the cache with an id [\" + id + \"] that already had an entry\");\n            }\n            _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[id] = baseTexture;\n        }\n    };\n    /**\n     * Remove a BaseTexture from the global BaseTextureCache.\n     *\n     * @static\n     * @param {string|PIXI.BaseTexture} baseTexture - id of a BaseTexture to be removed, or a BaseTexture instance itself.\n     * @return {PIXI.BaseTexture|null} The BaseTexture that was removed.\n     */\n    BaseTexture.removeFromCache = function (baseTexture) {\n        if (typeof baseTexture === 'string') {\n            var baseTextureFromCache = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[baseTexture];\n            if (baseTextureFromCache) {\n                var index = baseTextureFromCache.textureCacheIds.indexOf(baseTexture);\n                if (index > -1) {\n                    baseTextureFromCache.textureCacheIds.splice(index, 1);\n                }\n                delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[baseTexture];\n                return baseTextureFromCache;\n            }\n        }\n        else if (baseTexture && baseTexture.textureCacheIds) {\n            for (var i = 0; i < baseTexture.textureCacheIds.length; ++i) {\n                delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.BaseTextureCache[baseTexture.textureCacheIds[i]];\n            }\n            baseTexture.textureCacheIds.length = 0;\n            return baseTexture;\n        }\n        return null;\n    };\n    /**\n     * Global number of the texture batch, used by multi-texture renderers\n     *\n     * @static\n     * @member {number}\n     */\n    BaseTexture._globalBatch = 0;\n    return BaseTexture;\n}(_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.EventEmitter));\n\n/**\n * Resource that can manage several resource (items) inside.\n * All resources need to have the same pixel size.\n * Parent class for CubeResource and ArrayResource\n *\n * @class\n * @extends PIXI.resources.Resource\n * @memberof PIXI.resources\n * @param {object} [options] Options to for Resource constructor\n * @param {number} [options.width] - Width of the resource\n * @param {number} [options.height] - Height of the resource\n */\nvar AbstractMultiResource = /** @class */ (function (_super) {\n    __extends(AbstractMultiResource, _super);\n    function AbstractMultiResource(length, options) {\n        var _this = this;\n        var _a = options || {}, width = _a.width, height = _a.height;\n        _this = _super.call(this, width, height) || this;\n        /**\n         * Collection of partial baseTextures that correspond to resources\n         * @member {Array<PIXI.BaseTexture>}\n         * @readonly\n         */\n        _this.items = [];\n        /**\n         * Dirty IDs for each part\n         * @member {Array<number>}\n         * @readonly\n         */\n        _this.itemDirtyIds = [];\n        for (var i = 0; i < length; i++) {\n            var partTexture = new BaseTexture();\n            _this.items.push(partTexture);\n            // -2 - first run of texture array upload\n            // -1 - texture item was allocated\n            // >=0 - texture item uploaded , in sync with items[i].dirtyId\n            _this.itemDirtyIds.push(-2);\n        }\n        /**\n         * Number of elements in array\n         *\n         * @member {number}\n         * @readonly\n         */\n        _this.length = length;\n        /**\n         * Promise when loading\n         * @member {Promise}\n         * @private\n         * @default null\n         */\n        _this._load = null;\n        /**\n         * Bound baseTexture, there can only be one\n         * @member {PIXI.BaseTexture}\n         */\n        _this.baseTexture = null;\n        return _this;\n    }\n    /**\n     * used from ArrayResource and CubeResource constructors\n     * @param {Array<*>} resources - Can be resources, image elements, canvas, etc. ,\n     *  length should be same as constructor length\n     * @param {object} [options] - detect options for resources\n     * @protected\n     */\n    AbstractMultiResource.prototype.initFromArray = function (resources, options) {\n        for (var i = 0; i < this.length; i++) {\n            if (!resources[i]) {\n                continue;\n            }\n            if (resources[i].castToBaseTexture) {\n                this.addBaseTextureAt(resources[i].castToBaseTexture(), i);\n            }\n            else if (resources[i] instanceof Resource) {\n                this.addResourceAt(resources[i], i);\n            }\n            else {\n                this.addResourceAt(autoDetectResource(resources[i], options), i);\n            }\n        }\n    };\n    /**\n     * Destroy this BaseImageResource\n     * @override\n     */\n    AbstractMultiResource.prototype.dispose = function () {\n        for (var i = 0, len = this.length; i < len; i++) {\n            this.items[i].destroy();\n        }\n        this.items = null;\n        this.itemDirtyIds = null;\n        this._load = null;\n    };\n    /**\n     * Set a resource by ID\n     *\n     * @param {PIXI.resources.Resource} resource\n     * @param {number} index - Zero-based index of resource to set\n     * @return {PIXI.resources.ArrayResource} Instance for chaining\n     */\n    AbstractMultiResource.prototype.addResourceAt = function (resource, index) {\n        if (!this.items[index]) {\n            throw new Error(\"Index \" + index + \" is out of bounds\");\n        }\n        // Inherit the first resource dimensions\n        if (resource.valid && !this.valid) {\n            this.resize(resource.width, resource.height);\n        }\n        this.items[index].setResource(resource);\n        return this;\n    };\n    /**\n     * Set the parent base texture\n     * @member {PIXI.BaseTexture}\n     * @override\n     */\n    AbstractMultiResource.prototype.bind = function (baseTexture) {\n        if (this.baseTexture !== null) {\n            throw new Error('Only one base texture per TextureArray is allowed');\n        }\n        _super.prototype.bind.call(this, baseTexture);\n        for (var i = 0; i < this.length; i++) {\n            this.items[i].parentTextureArray = baseTexture;\n            this.items[i].on('update', baseTexture.update, baseTexture);\n        }\n    };\n    /**\n     * Unset the parent base texture\n     * @member {PIXI.BaseTexture}\n     * @override\n     */\n    AbstractMultiResource.prototype.unbind = function (baseTexture) {\n        _super.prototype.unbind.call(this, baseTexture);\n        for (var i = 0; i < this.length; i++) {\n            this.items[i].parentTextureArray = null;\n            this.items[i].off('update', baseTexture.update, baseTexture);\n        }\n    };\n    /**\n     * Load all the resources simultaneously\n     * @override\n     * @return {Promise<void>} When load is resolved\n     */\n    AbstractMultiResource.prototype.load = function () {\n        var _this = this;\n        if (this._load) {\n            return this._load;\n        }\n        var resources = this.items.map(function (item) { return item.resource; }).filter(function (item) { return item; });\n        // TODO: also implement load part-by-part strategy\n        var promises = resources.map(function (item) { return item.load(); });\n        this._load = Promise.all(promises)\n            .then(function () {\n            var _a = _this.items[0], realWidth = _a.realWidth, realHeight = _a.realHeight;\n            _this.resize(realWidth, realHeight);\n            return Promise.resolve(_this);\n        });\n        return this._load;\n    };\n    return AbstractMultiResource;\n}(Resource));\n\n/**\n * A resource that contains a number of sources.\n *\n * @class\n * @extends PIXI.resources.Resource\n * @memberof PIXI.resources\n * @param {number|Array<*>} source - Number of items in array or the collection\n *        of image URLs to use. Can also be resources, image elements, canvas, etc.\n * @param {object} [options] - Options to apply to {@link PIXI.resources.autoDetectResource}\n * @param {number} [options.width] - Width of the resource\n * @param {number} [options.height] - Height of the resource\n */\nvar ArrayResource = /** @class */ (function (_super) {\n    __extends(ArrayResource, _super);\n    function ArrayResource(source, options) {\n        var _this = this;\n        var _a = options || {}, width = _a.width, height = _a.height;\n        var urls;\n        var length;\n        if (Array.isArray(source)) {\n            urls = source;\n            length = source.length;\n        }\n        else {\n            length = source;\n        }\n        _this = _super.call(this, length, { width: width, height: height }) || this;\n        if (urls) {\n            _this.initFromArray(urls, options);\n        }\n        return _this;\n    }\n    /**\n     * Set a baseTexture by ID,\n     * ArrayResource just takes resource from it, nothing more\n     *\n     * @param {PIXI.BaseTexture} baseTexture\n     * @param {number} index - Zero-based index of resource to set\n     * @return {PIXI.resources.ArrayResource} Instance for chaining\n     */\n    ArrayResource.prototype.addBaseTextureAt = function (baseTexture, index) {\n        if (baseTexture.resource) {\n            this.addResourceAt(baseTexture.resource, index);\n        }\n        else {\n            throw new Error('ArrayResource does not support RenderTexture');\n        }\n        return this;\n    };\n    /**\n     * Add binding\n     * @member {PIXI.BaseTexture}\n     * @override\n     */\n    ArrayResource.prototype.bind = function (baseTexture) {\n        _super.prototype.bind.call(this, baseTexture);\n        baseTexture.target = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TARGETS.TEXTURE_2D_ARRAY;\n    };\n    /**\n     * Upload the resources to the GPU.\n     * @param {PIXI.Renderer} renderer\n     * @param {PIXI.BaseTexture} texture\n     * @param {PIXI.GLTexture} glTexture\n     * @returns {boolean} whether texture was uploaded\n     */\n    ArrayResource.prototype.upload = function (renderer, texture, glTexture) {\n        var _a = this, length = _a.length, itemDirtyIds = _a.itemDirtyIds, items = _a.items;\n        var gl = renderer.gl;\n        if (glTexture.dirtyId < 0) {\n            gl.texImage3D(gl.TEXTURE_2D_ARRAY, 0, texture.format, this._width, this._height, length, 0, texture.format, texture.type, null);\n        }\n        for (var i = 0; i < length; i++) {\n            var item = items[i];\n            if (itemDirtyIds[i] < item.dirtyId) {\n                itemDirtyIds[i] = item.dirtyId;\n                if (item.valid) {\n                    gl.texSubImage3D(gl.TEXTURE_2D_ARRAY, 0, 0, // xoffset\n                    0, // yoffset\n                    i, // zoffset\n                    item.resource.width, item.resource.height, 1, texture.format, texture.type, item.resource.source);\n                }\n            }\n        }\n        return true;\n    };\n    return ArrayResource;\n}(AbstractMultiResource));\n\n/**\n * Base for all the image/canvas resources\n * @class\n * @extends PIXI.resources.Resource\n * @memberof PIXI.resources\n */\nvar BaseImageResource = /** @class */ (function (_super) {\n    __extends(BaseImageResource, _super);\n    /**\n     * @param {HTMLImageElement|HTMLCanvasElement|HTMLVideoElement|SVGElement} source\n     */\n    function BaseImageResource(source) {\n        var _this = this;\n        var sourceAny = source;\n        var width = sourceAny.naturalWidth || sourceAny.videoWidth || sourceAny.width;\n        var height = sourceAny.naturalHeight || sourceAny.videoHeight || sourceAny.height;\n        _this = _super.call(this, width, height) || this;\n        /**\n         * The source element\n         * @member {HTMLImageElement|HTMLCanvasElement|HTMLVideoElement|SVGElement}\n         * @readonly\n         */\n        _this.source = source;\n        /**\n         * If set to `true`, will force `texImage2D` over `texSubImage2D` for uploading.\n         * Certain types of media (e.g. video) using `texImage2D` is more performant.\n         * @member {boolean}\n         * @default false\n         * @private\n         */\n        _this.noSubImage = false;\n        return _this;\n    }\n    /**\n     * Set cross origin based detecting the url and the crossorigin\n     * @protected\n     * @param {HTMLElement} element - Element to apply crossOrigin\n     * @param {string} url - URL to check\n     * @param {boolean|string} [crossorigin=true] - Cross origin value to use\n     */\n    BaseImageResource.crossOrigin = function (element, url, crossorigin) {\n        if (crossorigin === undefined && url.indexOf('data:') !== 0) {\n            element.crossOrigin = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.determineCrossOrigin)(url);\n        }\n        else if (crossorigin !== false) {\n            element.crossOrigin = typeof crossorigin === 'string' ? crossorigin : 'anonymous';\n        }\n    };\n    /**\n     * Upload the texture to the GPU.\n     * @param {PIXI.Renderer} renderer - Upload to the renderer\n     * @param {PIXI.BaseTexture} baseTexture - Reference to parent texture\n     * @param {PIXI.GLTexture} glTexture\n     * @param {HTMLImageElement|HTMLCanvasElement|HTMLVideoElement|SVGElement} [source] (optional)\n     * @returns {boolean} true is success\n     */\n    BaseImageResource.prototype.upload = function (renderer, baseTexture, glTexture, source) {\n        var gl = renderer.gl;\n        var width = baseTexture.realWidth;\n        var height = baseTexture.realHeight;\n        source = source || this.source;\n        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, baseTexture.alphaMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.UNPACK);\n        if (!this.noSubImage\n            && baseTexture.target === gl.TEXTURE_2D\n            && glTexture.width === width\n            && glTexture.height === height) {\n            gl.texSubImage2D(gl.TEXTURE_2D, 0, 0, 0, baseTexture.format, baseTexture.type, source);\n        }\n        else {\n            glTexture.width = width;\n            glTexture.height = height;\n            gl.texImage2D(baseTexture.target, 0, baseTexture.format, baseTexture.format, baseTexture.type, source);\n        }\n        return true;\n    };\n    /**\n     * Checks if source width/height was changed, resize can cause extra baseTexture update.\n     * Triggers one update in any case.\n     */\n    BaseImageResource.prototype.update = function () {\n        if (this.destroyed) {\n            return;\n        }\n        var source = this.source;\n        var width = source.naturalWidth || source.videoWidth || source.width;\n        var height = source.naturalHeight || source.videoHeight || source.height;\n        this.resize(width, height);\n        _super.prototype.update.call(this);\n    };\n    /**\n     * Destroy this BaseImageResource\n     * @override\n     */\n    BaseImageResource.prototype.dispose = function () {\n        this.source = null;\n    };\n    return BaseImageResource;\n}(Resource));\n\n/**\n * @interface OffscreenCanvas\n */\n/**\n * Resource type for HTMLCanvasElement.\n * @class\n * @extends PIXI.resources.BaseImageResource\n * @memberof PIXI.resources\n * @param {HTMLCanvasElement} source - Canvas element to use\n */\nvar CanvasResource = /** @class */ (function (_super) {\n    __extends(CanvasResource, _super);\n    function CanvasResource() {\n        return _super !== null && _super.apply(this, arguments) || this;\n    }\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {HTMLCanvasElement|OffscreenCanvas} source - The source object\n     * @return {boolean} `true` if source is HTMLCanvasElement or OffscreenCanvas\n     */\n    CanvasResource.test = function (source) {\n        var OffscreenCanvas = window.OffscreenCanvas;\n        // Check for browsers that don't yet support OffscreenCanvas\n        if (OffscreenCanvas && source instanceof OffscreenCanvas) {\n            return true;\n        }\n        return source instanceof HTMLCanvasElement;\n    };\n    return CanvasResource;\n}(BaseImageResource));\n\n/**\n * Resource for a CubeTexture which contains six resources.\n *\n * @class\n * @extends PIXI.resources.ArrayResource\n * @memberof PIXI.resources\n * @param {Array<string|PIXI.resources.Resource>} [source] - Collection of URLs or resources\n *        to use as the sides of the cube.\n * @param {object} [options] - ImageResource options\n * @param {number} [options.width] - Width of resource\n * @param {number} [options.height] - Height of resource\n * @param {number} [options.autoLoad=true] - Whether to auto-load resources\n * @param {number} [options.linkBaseTexture=true] - In case BaseTextures are supplied,\n *   whether to copy them or use\n */\nvar CubeResource = /** @class */ (function (_super) {\n    __extends(CubeResource, _super);\n    function CubeResource(source, options) {\n        var _this = this;\n        var _a = options || {}, width = _a.width, height = _a.height, autoLoad = _a.autoLoad, linkBaseTexture = _a.linkBaseTexture;\n        if (source && source.length !== CubeResource.SIDES) {\n            throw new Error(\"Invalid length. Got \" + source.length + \", expected 6\");\n        }\n        _this = _super.call(this, 6, { width: width, height: height }) || this;\n        for (var i = 0; i < CubeResource.SIDES; i++) {\n            _this.items[i].target = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TARGETS.TEXTURE_CUBE_MAP_POSITIVE_X + i;\n        }\n        /**\n         * In case BaseTextures are supplied, whether to use same resource or bind baseTexture itself\n         * @member {boolean}\n         * @protected\n         */\n        _this.linkBaseTexture = linkBaseTexture !== false;\n        if (source) {\n            _this.initFromArray(source, options);\n        }\n        if (autoLoad !== false) {\n            _this.load();\n        }\n        return _this;\n    }\n    /**\n     * Add binding\n     *\n     * @override\n     * @param {PIXI.BaseTexture} baseTexture - parent base texture\n     */\n    CubeResource.prototype.bind = function (baseTexture) {\n        _super.prototype.bind.call(this, baseTexture);\n        baseTexture.target = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TARGETS.TEXTURE_CUBE_MAP;\n    };\n    CubeResource.prototype.addBaseTextureAt = function (baseTexture, index, linkBaseTexture) {\n        if (linkBaseTexture === undefined) {\n            linkBaseTexture = this.linkBaseTexture;\n        }\n        if (!this.items[index]) {\n            throw new Error(\"Index \" + index + \" is out of bounds\");\n        }\n        if (!this.linkBaseTexture\n            || baseTexture.parentTextureArray\n            || Object.keys(baseTexture._glTextures).length > 0) {\n            // copy mode\n            if (baseTexture.resource) {\n                this.addResourceAt(baseTexture.resource, index);\n            }\n            else {\n                throw new Error(\"CubeResource does not support copying of renderTexture.\");\n            }\n        }\n        else {\n            // link mode, the difficult one!\n            baseTexture.target = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TARGETS.TEXTURE_CUBE_MAP_POSITIVE_X + index;\n            baseTexture.parentTextureArray = this.baseTexture;\n            this.items[index] = baseTexture;\n        }\n        if (baseTexture.valid && !this.valid) {\n            this.resize(baseTexture.realWidth, baseTexture.realHeight);\n        }\n        this.items[index] = baseTexture;\n        return this;\n    };\n    /**\n     * Upload the resource\n     *\n     * @returns {boolean} true is success\n     */\n    CubeResource.prototype.upload = function (renderer, _baseTexture, glTexture) {\n        var dirty = this.itemDirtyIds;\n        for (var i = 0; i < CubeResource.SIDES; i++) {\n            var side = this.items[i];\n            if (dirty[i] < side.dirtyId) {\n                if (side.valid && side.resource) {\n                    side.resource.upload(renderer, side, glTexture);\n                    dirty[i] = side.dirtyId;\n                }\n                else if (dirty[i] < -1) {\n                    // either item is not valid yet, either its a renderTexture\n                    // allocate the memory\n                    renderer.gl.texImage2D(side.target, 0, glTexture.internalFormat, _baseTexture.realWidth, _baseTexture.realHeight, 0, _baseTexture.format, glTexture.type, null);\n                    dirty[i] = -1;\n                }\n            }\n        }\n        return true;\n    };\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {object} source - The source object\n     * @return {boolean} `true` if source is an array of 6 elements\n     */\n    CubeResource.test = function (source) {\n        return Array.isArray(source) && source.length === CubeResource.SIDES;\n    };\n    /**\n     * Number of texture sides to store for CubeResources\n     *\n     * @name PIXI.resources.CubeResource.SIDES\n     * @static\n     * @member {number}\n     * @default 6\n     */\n    CubeResource.SIDES = 6;\n    return CubeResource;\n}(AbstractMultiResource));\n\n/**\n * Resource type for HTMLImageElement.\n * @class\n * @extends PIXI.resources.BaseImageResource\n * @memberof PIXI.resources\n */\nvar ImageResource = /** @class */ (function (_super) {\n    __extends(ImageResource, _super);\n    /**\n     * @param {HTMLImageElement|string} source - image source or URL\n     * @param {object} [options]\n     * @param {boolean} [options.autoLoad=true] - start loading process\n     * @param {boolean} [options.createBitmap=PIXI.settings.CREATE_IMAGE_BITMAP] - whether its required to create\n     *        a bitmap before upload\n     * @param {boolean} [options.crossorigin=true] - Load image using cross origin\n     * @param {PIXI.ALPHA_MODES} [options.alphaMode=PIXI.ALPHA_MODES.UNPACK] - Premultiply image alpha in bitmap\n     */\n    function ImageResource(source, options) {\n        var _this = this;\n        options = options || {};\n        if (!(source instanceof HTMLImageElement)) {\n            var imageElement = new Image();\n            BaseImageResource.crossOrigin(imageElement, source, options.crossorigin);\n            imageElement.src = source;\n            source = imageElement;\n        }\n        _this = _super.call(this, source) || this;\n        // FireFox 68, and possibly other versions, seems like setting the HTMLImageElement#width and #height\n        // to non-zero values before its loading completes if images are in a cache.\n        // Because of this, need to set the `_width` and the `_height` to zero to avoid uploading incomplete images.\n        // Please refer to the issue #5968 (https://github.com/pixijs/pixi.js/issues/5968).\n        if (!source.complete && !!_this._width && !!_this._height) {\n            _this._width = 0;\n            _this._height = 0;\n        }\n        /**\n         * URL of the image source\n         * @member {string}\n         */\n        _this.url = source.src;\n        /**\n         * When process is completed\n         * @member {Promise<void>}\n         * @private\n         */\n        _this._process = null;\n        /**\n         * If the image should be disposed after upload\n         * @member {boolean}\n         * @default false\n         */\n        _this.preserveBitmap = false;\n        /**\n         * If capable, convert the image using createImageBitmap API\n         * @member {boolean}\n         * @default PIXI.settings.CREATE_IMAGE_BITMAP\n         */\n        _this.createBitmap = (options.createBitmap !== undefined\n            ? options.createBitmap : _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.CREATE_IMAGE_BITMAP) && !!window.createImageBitmap;\n        /**\n         * Controls texture alphaMode field\n         * Copies from options\n         * Default is `null`, copies option from baseTexture\n         *\n         * @member {PIXI.ALPHA_MODES|null}\n         * @readonly\n         */\n        _this.alphaMode = typeof options.alphaMode === 'number' ? options.alphaMode : null;\n        if (options.premultiplyAlpha !== undefined) {\n            // triggers deprecation\n            _this.premultiplyAlpha = options.premultiplyAlpha;\n        }\n        /**\n         * The ImageBitmap element created for HTMLImageElement\n         * @member {ImageBitmap}\n         * @default null\n         */\n        _this.bitmap = null;\n        /**\n         * Promise when loading\n         * @member {Promise<void>}\n         * @private\n         * @default null\n         */\n        _this._load = null;\n        if (options.autoLoad !== false) {\n            _this.load();\n        }\n        return _this;\n    }\n    /**\n     * returns a promise when image will be loaded and processed\n     *\n     * @param {boolean} [createBitmap] - whether process image into bitmap\n     * @returns {Promise<void>}\n     */\n    ImageResource.prototype.load = function (createBitmap) {\n        var _this = this;\n        if (this._load) {\n            return this._load;\n        }\n        if (createBitmap !== undefined) {\n            this.createBitmap = createBitmap;\n        }\n        this._load = new Promise(function (resolve, reject) {\n            var source = _this.source;\n            _this.url = source.src;\n            var completed = function () {\n                if (_this.destroyed) {\n                    return;\n                }\n                source.onload = null;\n                source.onerror = null;\n                _this.resize(source.width, source.height);\n                _this._load = null;\n                if (_this.createBitmap) {\n                    resolve(_this.process());\n                }\n                else {\n                    resolve(_this);\n                }\n            };\n            if (source.complete && source.src) {\n                completed();\n            }\n            else {\n                source.onload = completed;\n                source.onerror = function (event) {\n                    // Avoids Promise freezing when resource broken\n                    reject(event);\n                    _this.onError.emit(event);\n                };\n            }\n        });\n        return this._load;\n    };\n    /**\n     * Called when we need to convert image into BitmapImage.\n     * Can be called multiple times, real promise is cached inside.\n     *\n     * @returns {Promise<void>} cached promise to fill that bitmap\n     */\n    ImageResource.prototype.process = function () {\n        var _this = this;\n        var source = this.source;\n        if (this._process !== null) {\n            return this._process;\n        }\n        if (this.bitmap !== null || !window.createImageBitmap) {\n            return Promise.resolve(this);\n        }\n        this._process = window.createImageBitmap(source, 0, 0, source.width, source.height, {\n            premultiplyAlpha: this.alphaMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.UNPACK ? 'premultiply' : 'none',\n        })\n            .then(function (bitmap) {\n            if (_this.destroyed) {\n                return Promise.reject();\n            }\n            _this.bitmap = bitmap;\n            _this.update();\n            _this._process = null;\n            return Promise.resolve(_this);\n        });\n        return this._process;\n    };\n    /**\n     * Upload the image resource to GPU.\n     *\n     * @param {PIXI.Renderer} renderer - Renderer to upload to\n     * @param {PIXI.BaseTexture} baseTexture - BaseTexture for this resource\n     * @param {PIXI.GLTexture} glTexture - GLTexture to use\n     * @returns {boolean} true is success\n     */\n    ImageResource.prototype.upload = function (renderer, baseTexture, glTexture) {\n        if (typeof this.alphaMode === 'number') {\n            // bitmap stores unpack premultiply flag, we dont have to notify texImage2D about it\n            baseTexture.alphaMode = this.alphaMode;\n        }\n        if (!this.createBitmap) {\n            return _super.prototype.upload.call(this, renderer, baseTexture, glTexture);\n        }\n        if (!this.bitmap) {\n            // yeah, ignore the output\n            this.process();\n            if (!this.bitmap) {\n                return false;\n            }\n        }\n        _super.prototype.upload.call(this, renderer, baseTexture, glTexture, this.bitmap);\n        if (!this.preserveBitmap) {\n            // checks if there are other renderers that possibly need this bitmap\n            var flag = true;\n            var glTextures = baseTexture._glTextures;\n            for (var key in glTextures) {\n                var otherTex = glTextures[key];\n                if (otherTex !== glTexture && otherTex.dirtyId !== baseTexture.dirtyId) {\n                    flag = false;\n                    break;\n                }\n            }\n            if (flag) {\n                if (this.bitmap.close) {\n                    this.bitmap.close();\n                }\n                this.bitmap = null;\n            }\n        }\n        return true;\n    };\n    /**\n     * Destroys this texture\n     * @override\n     */\n    ImageResource.prototype.dispose = function () {\n        this.source.onload = null;\n        this.source.onerror = null;\n        _super.prototype.dispose.call(this);\n        if (this.bitmap) {\n            this.bitmap.close();\n            this.bitmap = null;\n        }\n        this._process = null;\n        this._load = null;\n    };\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {string|HTMLImageElement} source - The source object\n     * @return {boolean} `true` if source is string or HTMLImageElement\n     */\n    ImageResource.test = function (source) {\n        return typeof source === 'string' || source instanceof HTMLImageElement;\n    };\n    return ImageResource;\n}(BaseImageResource));\n\n/**\n * Resource type for SVG elements and graphics.\n * @class\n * @extends PIXI.resources.BaseImageResource\n * @memberof PIXI.resources\n * @param {string} source - Base64 encoded SVG element or URL for SVG file.\n * @param {object} [options] - Options to use\n * @param {number} [options.scale=1] - Scale to apply to SVG. Overridden by...\n * @param {number} [options.width] - Rasterize SVG this wide. Aspect ratio preserved if height not specified.\n * @param {number} [options.height] - Rasterize SVG this high. Aspect ratio preserved if width not specified.\n * @param {boolean} [options.autoLoad=true] - Start loading right away.\n */\nvar SVGResource = /** @class */ (function (_super) {\n    __extends(SVGResource, _super);\n    function SVGResource(sourceBase64, options) {\n        var _this = this;\n        options = options || {};\n        _this = _super.call(this, document.createElement('canvas')) || this;\n        _this._width = 0;\n        _this._height = 0;\n        /**\n         * Base64 encoded SVG element or URL for SVG file\n         * @readonly\n         * @member {string}\n         */\n        _this.svg = sourceBase64;\n        /**\n         * The source scale to apply when rasterizing on load\n         * @readonly\n         * @member {number}\n         */\n        _this.scale = options.scale || 1;\n        /**\n         * A width override for rasterization on load\n         * @readonly\n         * @member {number}\n         */\n        _this._overrideWidth = options.width;\n        /**\n         * A height override for rasterization on load\n         * @readonly\n         * @member {number}\n         */\n        _this._overrideHeight = options.height;\n        /**\n         * Call when completely loaded\n         * @private\n         * @member {function}\n         */\n        _this._resolve = null;\n        /**\n         * Cross origin value to use\n         * @private\n         * @member {boolean|string}\n         */\n        _this._crossorigin = options.crossorigin;\n        /**\n         * Promise when loading\n         * @member {Promise<void>}\n         * @private\n         * @default null\n         */\n        _this._load = null;\n        if (options.autoLoad !== false) {\n            _this.load();\n        }\n        return _this;\n    }\n    SVGResource.prototype.load = function () {\n        var _this = this;\n        if (this._load) {\n            return this._load;\n        }\n        this._load = new Promise(function (resolve) {\n            // Save this until after load is finished\n            _this._resolve = function () {\n                _this.resize(_this.source.width, _this.source.height);\n                resolve(_this);\n            };\n            // Convert SVG inline string to data-uri\n            if ((/^\\<svg/).test(_this.svg.trim())) {\n                if (!btoa) {\n                    throw new Error('Your browser doesn\\'t support base64 conversions.');\n                }\n                _this.svg = \"data:image/svg+xml;base64,\" + btoa(unescape(encodeURIComponent(_this.svg)));\n            }\n            _this._loadSvg();\n        });\n        return this._load;\n    };\n    /**\n     * Loads an SVG image from `imageUrl` or `data URL`.\n     *\n     * @private\n     */\n    SVGResource.prototype._loadSvg = function () {\n        var _this = this;\n        var tempImage = new Image();\n        BaseImageResource.crossOrigin(tempImage, this.svg, this._crossorigin);\n        tempImage.src = this.svg;\n        tempImage.onerror = function (event) {\n            if (!_this._resolve) {\n                return;\n            }\n            tempImage.onerror = null;\n            _this.onError.emit(event);\n        };\n        tempImage.onload = function () {\n            if (!_this._resolve) {\n                return;\n            }\n            var svgWidth = tempImage.width;\n            var svgHeight = tempImage.height;\n            if (!svgWidth || !svgHeight) {\n                throw new Error('The SVG image must have width and height defined (in pixels), canvas API needs them.');\n            }\n            // Set render size\n            var width = svgWidth * _this.scale;\n            var height = svgHeight * _this.scale;\n            if (_this._overrideWidth || _this._overrideHeight) {\n                width = _this._overrideWidth || _this._overrideHeight / svgHeight * svgWidth;\n                height = _this._overrideHeight || _this._overrideWidth / svgWidth * svgHeight;\n            }\n            width = Math.round(width);\n            height = Math.round(height);\n            // Create a canvas element\n            var canvas = _this.source;\n            canvas.width = width;\n            canvas.height = height;\n            canvas._pixiId = \"canvas_\" + (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.uid)();\n            // Draw the Svg to the canvas\n            canvas\n                .getContext('2d')\n                .drawImage(tempImage, 0, 0, svgWidth, svgHeight, 0, 0, width, height);\n            _this._resolve();\n            _this._resolve = null;\n        };\n    };\n    /**\n     * Get size from an svg string using regexp.\n     *\n     * @method\n     * @param {string} svgString - a serialized svg element\n     * @return {PIXI.ISize} image extension\n     */\n    SVGResource.getSize = function (svgString) {\n        var sizeMatch = SVGResource.SVG_SIZE.exec(svgString);\n        var size = {};\n        if (sizeMatch) {\n            size[sizeMatch[1]] = Math.round(parseFloat(sizeMatch[3]));\n            size[sizeMatch[5]] = Math.round(parseFloat(sizeMatch[7]));\n        }\n        return size;\n    };\n    /**\n     * Destroys this texture\n     * @override\n     */\n    SVGResource.prototype.dispose = function () {\n        _super.prototype.dispose.call(this);\n        this._resolve = null;\n        this._crossorigin = null;\n    };\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {*} source - The source object\n     * @param {string} extension - The extension of source, if set\n     */\n    SVGResource.test = function (source, extension) {\n        // url file extension is SVG\n        return extension === 'svg'\n            // source is SVG data-uri\n            || (typeof source === 'string' && (/^data:image\\/svg\\+xml(;(charset=utf8|utf8))?;base64/).test(source))\n            // source is SVG inline\n            || (typeof source === 'string' && source.indexOf('<svg') === 0);\n    };\n    /**\n     * RegExp for SVG size.\n     *\n     * @static\n     * @constant {RegExp|string} SVG_SIZE\n     * @memberof PIXI.resources.SVGResource\n     * @example &lt;svg width=\"100\" height=\"100\"&gt;&lt;/svg&gt;\n     */\n    SVGResource.SVG_SIZE = /<svg[^>]*(?:\\s(width|height)=('|\")(\\d*(?:\\.\\d+)?)(?:px)?('|\"))[^>]*(?:\\s(width|height)=('|\")(\\d*(?:\\.\\d+)?)(?:px)?('|\"))[^>]*>/i; // eslint-disable-line max-len\n    return SVGResource;\n}(BaseImageResource));\n\n/**\n * Resource type for HTMLVideoElement.\n * @class\n * @extends PIXI.resources.BaseImageResource\n * @memberof PIXI.resources\n * @param {HTMLVideoElement|object|string|Array<string|object>} source - Video element to use.\n * @param {object} [options] - Options to use\n * @param {boolean} [options.autoLoad=true] - Start loading the video immediately\n * @param {boolean} [options.autoPlay=true] - Start playing video immediately\n * @param {number} [options.updateFPS=0] - How many times a second to update the texture from the video.\n * Leave at 0 to update at every render.\n * @param {boolean} [options.crossorigin=true] - Load image using cross origin\n */\nvar VideoResource = /** @class */ (function (_super) {\n    __extends(VideoResource, _super);\n    function VideoResource(source, options) {\n        var _this = this;\n        options = options || {};\n        if (!(source instanceof HTMLVideoElement)) {\n            var videoElement = document.createElement('video');\n            // workaround for https://github.com/pixijs/pixi.js/issues/5996\n            videoElement.setAttribute('preload', 'auto');\n            videoElement.setAttribute('webkit-playsinline', '');\n            videoElement.setAttribute('playsinline', '');\n            if (typeof source === 'string') {\n                source = [source];\n            }\n            var firstSrc = source[0].src || source[0];\n            BaseImageResource.crossOrigin(videoElement, firstSrc, options.crossorigin);\n            // array of objects or strings\n            for (var i = 0; i < source.length; ++i) {\n                var sourceElement = document.createElement('source');\n                var _a = source[i], src = _a.src, mime = _a.mime;\n                src = src || source[i];\n                var baseSrc = src.split('?').shift().toLowerCase();\n                var ext = baseSrc.substr(baseSrc.lastIndexOf('.') + 1);\n                mime = mime || VideoResource.MIME_TYPES[ext] || \"video/\" + ext;\n                sourceElement.src = src;\n                sourceElement.type = mime;\n                videoElement.appendChild(sourceElement);\n            }\n            // Override the source\n            source = videoElement;\n        }\n        _this = _super.call(this, source) || this;\n        _this.noSubImage = true;\n        /**\n         * `true` to use PIXI.Ticker.shared to auto update the base texture.\n         *\n         * @type {boolean}\n         * @default true\n         * @private\n         */\n        _this._autoUpdate = true;\n        /**\n         * `true` if the instance is currently connected to PIXI.Ticker.shared to auto update the base texture.\n         *\n         * @type {boolean}\n         * @default false\n         * @private\n         */\n        _this._isConnectedToTicker = false;\n        _this._updateFPS = options.updateFPS || 0;\n        _this._msToNextUpdate = 0;\n        /**\n         * When set to true will automatically play videos used by this texture once\n         * they are loaded. If false, it will not modify the playing state.\n         *\n         * @member {boolean}\n         * @default true\n         */\n        _this.autoPlay = options.autoPlay !== false;\n        /**\n         * Promise when loading\n         * @member {Promise<void>}\n         * @private\n         * @default null\n         */\n        _this._load = null;\n        /**\n         * Callback when completed with load.\n         * @member {function}\n         * @private\n         */\n        _this._resolve = null;\n        // Bind for listeners\n        _this._onCanPlay = _this._onCanPlay.bind(_this);\n        _this._onError = _this._onError.bind(_this);\n        if (options.autoLoad !== false) {\n            _this.load();\n        }\n        return _this;\n    }\n    /**\n     * Trigger updating of the texture\n     *\n     * @param {number} [deltaTime=0] - time delta since last tick\n     */\n    VideoResource.prototype.update = function (_deltaTime) {\n        if (_deltaTime === void 0) { _deltaTime = 0; }\n        if (!this.destroyed) {\n            // account for if video has had its playbackRate changed\n            var elapsedMS = _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.elapsedMS * this.source.playbackRate;\n            this._msToNextUpdate = Math.floor(this._msToNextUpdate - elapsedMS);\n            if (!this._updateFPS || this._msToNextUpdate <= 0) {\n                _super.prototype.update.call(this);\n                this._msToNextUpdate = this._updateFPS ? Math.floor(1000 / this._updateFPS) : 0;\n            }\n        }\n    };\n    /**\n     * Start preloading the video resource.\n     *\n     * @protected\n     * @return {Promise<void>} Handle the validate event\n     */\n    VideoResource.prototype.load = function () {\n        var _this = this;\n        if (this._load) {\n            return this._load;\n        }\n        var source = this.source;\n        if ((source.readyState === source.HAVE_ENOUGH_DATA || source.readyState === source.HAVE_FUTURE_DATA)\n            && source.width && source.height) {\n            source.complete = true;\n        }\n        source.addEventListener('play', this._onPlayStart.bind(this));\n        source.addEventListener('pause', this._onPlayStop.bind(this));\n        if (!this._isSourceReady()) {\n            source.addEventListener('canplay', this._onCanPlay);\n            source.addEventListener('canplaythrough', this._onCanPlay);\n            source.addEventListener('error', this._onError, true);\n        }\n        else {\n            this._onCanPlay();\n        }\n        this._load = new Promise(function (resolve) {\n            if (_this.valid) {\n                resolve(_this);\n            }\n            else {\n                _this._resolve = resolve;\n                source.load();\n            }\n        });\n        return this._load;\n    };\n    /**\n     * Handle video error events.\n     *\n     * @private\n     */\n    VideoResource.prototype._onError = function (event) {\n        this.source.removeEventListener('error', this._onError, true);\n        this.onError.emit(event);\n    };\n    /**\n     * Returns true if the underlying source is playing.\n     *\n     * @private\n     * @return {boolean} True if playing.\n     */\n    VideoResource.prototype._isSourcePlaying = function () {\n        var source = this.source;\n        return (source.currentTime > 0 && source.paused === false && source.ended === false && source.readyState > 2);\n    };\n    /**\n     * Returns true if the underlying source is ready for playing.\n     *\n     * @private\n     * @return {boolean} True if ready.\n     */\n    VideoResource.prototype._isSourceReady = function () {\n        var source = this.source;\n        return source.readyState === 3 || source.readyState === 4;\n    };\n    /**\n     * Runs the update loop when the video is ready to play\n     *\n     * @private\n     */\n    VideoResource.prototype._onPlayStart = function () {\n        // Just in case the video has not received its can play even yet..\n        if (!this.valid) {\n            this._onCanPlay();\n        }\n        if (this.autoUpdate && !this._isConnectedToTicker) {\n            _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.add(this.update, this);\n            this._isConnectedToTicker = true;\n        }\n    };\n    /**\n     * Fired when a pause event is triggered, stops the update loop\n     *\n     * @private\n     */\n    VideoResource.prototype._onPlayStop = function () {\n        if (this._isConnectedToTicker) {\n            _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.remove(this.update, this);\n            this._isConnectedToTicker = false;\n        }\n    };\n    /**\n     * Fired when the video is loaded and ready to play\n     *\n     * @private\n     */\n    VideoResource.prototype._onCanPlay = function () {\n        var source = this.source;\n        source.removeEventListener('canplay', this._onCanPlay);\n        source.removeEventListener('canplaythrough', this._onCanPlay);\n        var valid = this.valid;\n        this.resize(source.videoWidth, source.videoHeight);\n        // prevent multiple loaded dispatches..\n        if (!valid && this._resolve) {\n            this._resolve(this);\n            this._resolve = null;\n        }\n        if (this._isSourcePlaying()) {\n            this._onPlayStart();\n        }\n        else if (this.autoPlay) {\n            source.play();\n        }\n    };\n    /**\n     * Destroys this texture\n     * @override\n     */\n    VideoResource.prototype.dispose = function () {\n        if (this._isConnectedToTicker) {\n            _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.remove(this.update, this);\n        }\n        var source = this.source;\n        if (source) {\n            source.removeEventListener('error', this._onError, true);\n            source.pause();\n            source.src = '';\n            source.load();\n        }\n        _super.prototype.dispose.call(this);\n    };\n    Object.defineProperty(VideoResource.prototype, \"autoUpdate\", {\n        /**\n         * Should the base texture automatically update itself, set to true by default\n         *\n         * @member {boolean}\n         */\n        get: function () {\n            return this._autoUpdate;\n        },\n        set: function (value) {\n            if (value !== this._autoUpdate) {\n                this._autoUpdate = value;\n                if (!this._autoUpdate && this._isConnectedToTicker) {\n                    _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.remove(this.update, this);\n                    this._isConnectedToTicker = false;\n                }\n                else if (this._autoUpdate && !this._isConnectedToTicker && this._isSourcePlaying()) {\n                    _pixi_ticker__WEBPACK_IMPORTED_MODULE_4__.Ticker.shared.add(this.update, this);\n                    this._isConnectedToTicker = true;\n                }\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(VideoResource.prototype, \"updateFPS\", {\n        /**\n         * How many times a second to update the texture from the video. Leave at 0 to update at every render.\n         * A lower fps can help performance, as updating the texture at 60fps on a 30ps video may not be efficient.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._updateFPS;\n        },\n        set: function (value) {\n            if (value !== this._updateFPS) {\n                this._updateFPS = value;\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {*} source - The source object\n     * @param {string} extension - The extension of source, if set\n     * @return {boolean} `true` if video source\n     */\n    VideoResource.test = function (source, extension) {\n        return (source instanceof HTMLVideoElement)\n            || VideoResource.TYPES.indexOf(extension) > -1;\n    };\n    /**\n     * List of common video file extensions supported by VideoResource.\n     * @constant\n     * @member {Array<string>}\n     * @static\n     * @readonly\n     */\n    VideoResource.TYPES = ['mp4', 'm4v', 'webm', 'ogg', 'ogv', 'h264', 'avi', 'mov'];\n    /**\n     * Map of video MIME types that can't be directly derived from file extensions.\n     * @constant\n     * @member {object}\n     * @static\n     * @readonly\n     */\n    VideoResource.MIME_TYPES = {\n        ogv: 'video/ogg',\n        mov: 'video/quicktime',\n        m4v: 'video/mp4',\n    };\n    return VideoResource;\n}(BaseImageResource));\n\n/**\n * Resource type for ImageBitmap.\n * @class\n * @extends PIXI.resources.BaseImageResource\n * @memberof PIXI.resources\n * @param {ImageBitmap} source - Image element to use\n */\nvar ImageBitmapResource = /** @class */ (function (_super) {\n    __extends(ImageBitmapResource, _super);\n    function ImageBitmapResource() {\n        return _super !== null && _super.apply(this, arguments) || this;\n    }\n    /**\n     * Used to auto-detect the type of resource.\n     *\n     * @static\n     * @param {ImageBitmap} source - The source object\n     * @return {boolean} `true` if source is an ImageBitmap\n     */\n    ImageBitmapResource.test = function (source) {\n        return !!window.createImageBitmap && source instanceof ImageBitmap;\n    };\n    return ImageBitmapResource;\n}(BaseImageResource));\n\nINSTALLED.push(ImageResource, ImageBitmapResource, CanvasResource, VideoResource, SVGResource, BufferResource, CubeResource, ArrayResource);\n\nvar index = ({\n    Resource: Resource,\n    BaseImageResource: BaseImageResource,\n    INSTALLED: INSTALLED,\n    autoDetectResource: autoDetectResource,\n    AbstractMultiResource: AbstractMultiResource,\n    ArrayResource: ArrayResource,\n    BufferResource: BufferResource,\n    CanvasResource: CanvasResource,\n    CubeResource: CubeResource,\n    ImageResource: ImageResource,\n    SVGResource: SVGResource,\n    VideoResource: VideoResource,\n    ImageBitmapResource: ImageBitmapResource\n});\n\n/**\n * System is a base class used for extending systems used by the {@link PIXI.Renderer}\n *\n * @see PIXI.Renderer#addSystem\n * @class\n * @memberof PIXI\n */\nvar System = /** @class */ (function () {\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this manager works for.\n     */\n    function System(renderer) {\n        /**\n         * The renderer this manager works for.\n         *\n         * @member {PIXI.Renderer}\n         */\n        this.renderer = renderer;\n    }\n    /**\n     * Generic destroy methods to be overridden by the subclass\n     */\n    System.prototype.destroy = function () {\n        this.renderer = null;\n    };\n    return System;\n}());\n\n/**\n * Resource type for DepthTexture.\n * @class\n * @extends PIXI.resources.BufferResource\n * @memberof PIXI.resources\n */\nvar DepthResource = /** @class */ (function (_super) {\n    __extends(DepthResource, _super);\n    function DepthResource() {\n        return _super !== null && _super.apply(this, arguments) || this;\n    }\n    /**\n     * Upload the texture to the GPU.\n     * @param {PIXI.Renderer} renderer - Upload to the renderer\n     * @param {PIXI.BaseTexture} baseTexture - Reference to parent texture\n     * @param {PIXI.GLTexture} glTexture - glTexture\n     * @returns {boolean} true is success\n     */\n    DepthResource.prototype.upload = function (renderer, baseTexture, glTexture) {\n        var gl = renderer.gl;\n        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, baseTexture.alphaMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ALPHA_MODES.UNPACK);\n        if (glTexture.width === baseTexture.width && glTexture.height === baseTexture.height) {\n            gl.texSubImage2D(baseTexture.target, 0, 0, 0, baseTexture.width, baseTexture.height, baseTexture.format, baseTexture.type, this.data);\n        }\n        else {\n            glTexture.width = baseTexture.width;\n            glTexture.height = baseTexture.height;\n            gl.texImage2D(baseTexture.target, 0, \n            //  gl.DEPTH_COMPONENT16 Needed for depth to render properly in webgl2.0\n            renderer.context.webGLVersion === 1 ? gl.DEPTH_COMPONENT : gl.DEPTH_COMPONENT16, baseTexture.width, baseTexture.height, 0, baseTexture.format, baseTexture.type, this.data);\n        }\n        return true;\n    };\n    return DepthResource;\n}(BufferResource));\n\n/**\n * Frame buffer used by the BaseRenderTexture\n *\n * @class\n * @memberof PIXI\n */\nvar Framebuffer = /** @class */ (function () {\n    /**\n     * @param {number} width - Width of the frame buffer\n     * @param {number} height - Height of the frame buffer\n     */\n    function Framebuffer(width, height) {\n        /**\n         * Width of framebuffer in pixels\n         * @member {number}\n         */\n        this.width = Math.ceil(width || 100);\n        /**\n         * Height of framebuffer in pixels\n         * @member {number}\n         */\n        this.height = Math.ceil(height || 100);\n        this.stencil = false;\n        this.depth = false;\n        this.dirtyId = 0;\n        this.dirtyFormat = 0;\n        this.dirtySize = 0;\n        this.depthTexture = null;\n        this.colorTextures = [];\n        this.glFramebuffers = {};\n        this.disposeRunner = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('disposeFramebuffer');\n        /**\n         * Desired number of samples for antialiasing. 0 means AA should not be used.\n         *\n         * Experimental WebGL2 feature, allows to use antialiasing in individual renderTextures.\n         * Antialiasing is the same as for main buffer with renderer `antialias:true` options.\n         * Seriously affects GPU memory consumption and GPU performance.\n         *\n         *```js\n         * renderTexture.framebuffer.multisample = PIXI.MSAA_QUALITY.HIGH;\n         * //...\n         * renderer.render(renderTexture, myContainer);\n         * renderer.framebuffer.blit(); // copies data from MSAA framebuffer to texture\n         *  ```\n         *\n         * @member {PIXI.MSAA_QUALITY}\n         * @default PIXI.MSAA_QUALITY.NONE\n         */\n        this.multisample = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MSAA_QUALITY.NONE;\n    }\n    Object.defineProperty(Framebuffer.prototype, \"colorTexture\", {\n        /**\n         * Reference to the colorTexture.\n         *\n         * @member {PIXI.BaseTexture[]}\n         * @readonly\n         */\n        get: function () {\n            return this.colorTextures[0];\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Add texture to the colorTexture array\n     *\n     * @param {number} [index=0] - Index of the array to add the texture to\n     * @param {PIXI.BaseTexture} [texture] - Texture to add to the array\n     */\n    Framebuffer.prototype.addColorTexture = function (index, texture) {\n        if (index === void 0) { index = 0; }\n        // TODO add some validation to the texture - same width / height etc?\n        this.colorTextures[index] = texture || new BaseTexture(null, {\n            scaleMode: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.NEAREST,\n            resolution: 1,\n            mipmap: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MIPMAP_MODES.OFF,\n            width: this.width,\n            height: this.height,\n        });\n        this.dirtyId++;\n        this.dirtyFormat++;\n        return this;\n    };\n    /**\n     * Add a depth texture to the frame buffer\n     *\n     * @param {PIXI.BaseTexture} [texture] - Texture to add\n     */\n    Framebuffer.prototype.addDepthTexture = function (texture) {\n        /* eslint-disable max-len */\n        this.depthTexture = texture || new BaseTexture(new DepthResource(null, { width: this.width, height: this.height }), {\n            scaleMode: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.NEAREST,\n            resolution: 1,\n            width: this.width,\n            height: this.height,\n            mipmap: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MIPMAP_MODES.OFF,\n            format: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.FORMATS.DEPTH_COMPONENT,\n            type: _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.UNSIGNED_SHORT,\n        });\n        this.dirtyId++;\n        this.dirtyFormat++;\n        return this;\n    };\n    /**\n     * Enable depth on the frame buffer\n     */\n    Framebuffer.prototype.enableDepth = function () {\n        this.depth = true;\n        this.dirtyId++;\n        this.dirtyFormat++;\n        return this;\n    };\n    /**\n     * Enable stencil on the frame buffer\n     */\n    Framebuffer.prototype.enableStencil = function () {\n        this.stencil = true;\n        this.dirtyId++;\n        this.dirtyFormat++;\n        return this;\n    };\n    /**\n     * Resize the frame buffer\n     *\n     * @param {number} width - Width of the frame buffer to resize to\n     * @param {number} height - Height of the frame buffer to resize to\n     */\n    Framebuffer.prototype.resize = function (width, height) {\n        width = Math.ceil(width);\n        height = Math.ceil(height);\n        if (width === this.width && height === this.height)\n            { return; }\n        this.width = width;\n        this.height = height;\n        this.dirtyId++;\n        this.dirtySize++;\n        for (var i = 0; i < this.colorTextures.length; i++) {\n            var texture = this.colorTextures[i];\n            var resolution = texture.resolution;\n            // take into acount the fact the texture may have a different resolution..\n            texture.setSize(width / resolution, height / resolution);\n        }\n        if (this.depthTexture) {\n            var resolution = this.depthTexture.resolution;\n            this.depthTexture.setSize(width / resolution, height / resolution);\n        }\n    };\n    /**\n     * Disposes WebGL resources that are connected to this geometry\n     */\n    Framebuffer.prototype.dispose = function () {\n        this.disposeRunner.emit(this, false);\n    };\n    /**\n     * Destroys and removes the depth texture added to this framebuffer.\n     */\n    Framebuffer.prototype.destroyDepthTexture = function () {\n        if (this.depthTexture) {\n            this.depthTexture.destroy();\n            this.depthTexture = null;\n            ++this.dirtyId;\n            ++this.dirtyFormat;\n        }\n    };\n    return Framebuffer;\n}());\n\n/**\n * A BaseRenderTexture is a special texture that allows any PixiJS display object to be rendered to it.\n *\n * __Hint__: All DisplayObjects (i.e. Sprites) that render to a BaseRenderTexture should be preloaded\n * otherwise black rectangles will be drawn instead.\n *\n * A BaseRenderTexture takes a snapshot of any Display Object given to its render method. The position\n * and rotation of the given Display Objects is ignored. For example:\n *\n * ```js\n * let renderer = PIXI.autoDetectRenderer();\n * let baseRenderTexture = new PIXI.BaseRenderTexture({ width: 800, height: 600 });\n * let renderTexture = new PIXI.RenderTexture(baseRenderTexture);\n * let sprite = PIXI.Sprite.from(\"spinObj_01.png\");\n *\n * sprite.position.x = 800/2;\n * sprite.position.y = 600/2;\n * sprite.anchor.x = 0.5;\n * sprite.anchor.y = 0.5;\n *\n * renderer.render(sprite, renderTexture);\n * ```\n *\n * The Sprite in this case will be rendered using its local transform. To render this sprite at 0,0\n * you can clear the transform\n *\n * ```js\n *\n * sprite.setTransform()\n *\n * let baseRenderTexture = new PIXI.BaseRenderTexture({ width: 100, height: 100 });\n * let renderTexture = new PIXI.RenderTexture(baseRenderTexture);\n *\n * renderer.render(sprite, renderTexture);  // Renders to center of RenderTexture\n * ```\n *\n * @class\n * @extends PIXI.BaseTexture\n * @memberof PIXI\n */\nvar BaseRenderTexture = /** @class */ (function (_super) {\n    __extends(BaseRenderTexture, _super);\n    /**\n     * @param {object} [options]\n     * @param {number} [options.width=100] - The width of the base render texture.\n     * @param {number} [options.height=100] - The height of the base render texture.\n     * @param {PIXI.SCALE_MODES} [options.scaleMode] - See {@link PIXI.SCALE_MODES} for possible values.\n     * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the texture being generated.\n     */\n    function BaseRenderTexture(options) {\n        var _this = this;\n        if (typeof options === 'number') {\n            /* eslint-disable prefer-rest-params */\n            // Backward compatibility of signature\n            var width_1 = arguments[0];\n            var height_1 = arguments[1];\n            var scaleMode = arguments[2];\n            var resolution = arguments[3];\n            options = { width: width_1, height: height_1, scaleMode: scaleMode, resolution: resolution };\n            /* eslint-enable prefer-rest-params */\n        }\n        _this = _super.call(this, null, options) || this;\n        var _a = options || {}, width = _a.width, height = _a.height;\n        // Set defaults\n        _this.mipmap = 0;\n        _this.width = Math.ceil(width) || 100;\n        _this.height = Math.ceil(height) || 100;\n        _this.valid = true;\n        _this.clearColor = [0, 0, 0, 0];\n        _this.framebuffer = new Framebuffer(_this.width * _this.resolution, _this.height * _this.resolution)\n            .addColorTexture(0, _this);\n        // TODO - could this be added the systems?\n        /**\n         * The data structure for the stencil masks.\n         *\n         * @member {PIXI.MaskData[]}\n         */\n        _this.maskStack = [];\n        /**\n         * The data structure for the filters.\n         *\n         * @member {Object[]}\n         */\n        _this.filterStack = [{}];\n        return _this;\n    }\n    /**\n     * Resizes the BaseRenderTexture.\n     *\n     * @param {number} width - The width to resize to.\n     * @param {number} height - The height to resize to.\n     */\n    BaseRenderTexture.prototype.resize = function (width, height) {\n        width = Math.ceil(width);\n        height = Math.ceil(height);\n        this.framebuffer.resize(width * this.resolution, height * this.resolution);\n    };\n    /**\n     * Frees the texture and framebuffer from WebGL memory without destroying this texture object.\n     * This means you can still use the texture later which will upload it to GPU\n     * memory again.\n     *\n     * @fires PIXI.BaseTexture#dispose\n     */\n    BaseRenderTexture.prototype.dispose = function () {\n        this.framebuffer.dispose();\n        _super.prototype.dispose.call(this);\n    };\n    /**\n     * Destroys this texture.\n     */\n    BaseRenderTexture.prototype.destroy = function () {\n        _super.prototype.destroy.call(this);\n        this.framebuffer.destroyDepthTexture();\n        this.framebuffer = null;\n    };\n    return BaseRenderTexture;\n}(BaseTexture));\n\n/**\n * Stores a texture's frame in UV coordinates, in\n * which everything lies in the rectangle `[(0,0), (1,0),\n * (1,1), (0,1)]`.\n *\n * | Corner       | Coordinates |\n * |--------------|-------------|\n * | Top-Left     | `(x0,y0)`   |\n * | Top-Right    | `(x1,y1)`   |\n * | Bottom-Right | `(x2,y2)`   |\n * | Bottom-Left  | `(x3,y3)`   |\n *\n * @class\n * @protected\n * @memberof PIXI\n */\nvar TextureUvs = /** @class */ (function () {\n    function TextureUvs() {\n        /**\n         * X-component of top-left corner `(x0,y0)`.\n         *\n         * @member {number}\n         */\n        this.x0 = 0;\n        /**\n         * Y-component of top-left corner `(x0,y0)`.\n         *\n         * @member {number}\n         */\n        this.y0 = 0;\n        /**\n         * X-component of top-right corner `(x1,y1)`.\n         *\n         * @member {number}\n         */\n        this.x1 = 1;\n        /**\n         * Y-component of top-right corner `(x1,y1)`.\n         *\n         * @member {number}\n         */\n        this.y1 = 0;\n        /**\n         * X-component of bottom-right corner `(x2,y2)`.\n         *\n         * @member {number}\n         */\n        this.x2 = 1;\n        /**\n         * Y-component of bottom-right corner `(x2,y2)`.\n         *\n         * @member {number}\n         */\n        this.y2 = 1;\n        /**\n         * X-component of bottom-left corner `(x3,y3)`.\n         *\n         * @member {number}\n         */\n        this.x3 = 0;\n        /**\n         * Y-component of bottom-right corner `(x3,y3)`.\n         *\n         * @member {number}\n         */\n        this.y3 = 1;\n        this.uvsFloat32 = new Float32Array(8);\n    }\n    /**\n     * Sets the texture Uvs based on the given frame information.\n     *\n     * @protected\n     * @param {PIXI.Rectangle} frame - The frame of the texture\n     * @param {PIXI.Rectangle} baseFrame - The base frame of the texture\n     * @param {number} rotate - Rotation of frame, see {@link PIXI.groupD8}\n     */\n    TextureUvs.prototype.set = function (frame, baseFrame, rotate) {\n        var tw = baseFrame.width;\n        var th = baseFrame.height;\n        if (rotate) {\n            // width and height div 2 div baseFrame size\n            var w2 = frame.width / 2 / tw;\n            var h2 = frame.height / 2 / th;\n            // coordinates of center\n            var cX = (frame.x / tw) + w2;\n            var cY = (frame.y / th) + h2;\n            rotate = _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.add(rotate, _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.NW); // NW is top-left corner\n            this.x0 = cX + (w2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uX(rotate));\n            this.y0 = cY + (h2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uY(rotate));\n            rotate = _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.add(rotate, 2); // rotate 90 degrees clockwise\n            this.x1 = cX + (w2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uX(rotate));\n            this.y1 = cY + (h2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uY(rotate));\n            rotate = _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.add(rotate, 2);\n            this.x2 = cX + (w2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uX(rotate));\n            this.y2 = cY + (h2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uY(rotate));\n            rotate = _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.add(rotate, 2);\n            this.x3 = cX + (w2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uX(rotate));\n            this.y3 = cY + (h2 * _pixi_math__WEBPACK_IMPORTED_MODULE_5__.groupD8.uY(rotate));\n        }\n        else {\n            this.x0 = frame.x / tw;\n            this.y0 = frame.y / th;\n            this.x1 = (frame.x + frame.width) / tw;\n            this.y1 = frame.y / th;\n            this.x2 = (frame.x + frame.width) / tw;\n            this.y2 = (frame.y + frame.height) / th;\n            this.x3 = frame.x / tw;\n            this.y3 = (frame.y + frame.height) / th;\n        }\n        this.uvsFloat32[0] = this.x0;\n        this.uvsFloat32[1] = this.y0;\n        this.uvsFloat32[2] = this.x1;\n        this.uvsFloat32[3] = this.y1;\n        this.uvsFloat32[4] = this.x2;\n        this.uvsFloat32[5] = this.y2;\n        this.uvsFloat32[6] = this.x3;\n        this.uvsFloat32[7] = this.y3;\n    };\n    return TextureUvs;\n}());\n\nvar DEFAULT_UVS = new TextureUvs();\n/**\n * A texture stores the information that represents an image or part of an image.\n *\n * It cannot be added to the display list directly; instead use it as the texture for a Sprite.\n * If no frame is provided for a texture, then the whole image is used.\n *\n * You can directly create a texture from an image and then reuse it multiple times like this :\n *\n * ```js\n * let texture = PIXI.Texture.from('assets/image.png');\n * let sprite1 = new PIXI.Sprite(texture);\n * let sprite2 = new PIXI.Sprite(texture);\n * ```\n *\n * If you didnt pass the texture frame to constructor, it enables `noFrame` mode:\n * it subscribes on baseTexture events, it automatically resizes at the same time as baseTexture.\n *\n * Textures made from SVGs, loaded or not, cannot be used before the file finishes processing.\n * You can check for this by checking the sprite's _textureID property.\n * ```js\n * var texture = PIXI.Texture.from('assets/image.svg');\n * var sprite1 = new PIXI.Sprite(texture);\n * //sprite1._textureID should not be undefined if the texture has finished processing the SVG file\n * ```\n * You can use a ticker or rAF to ensure your sprites load the finished textures after processing. See issue #3068.\n *\n * @class\n * @extends PIXI.utils.EventEmitter\n * @memberof PIXI\n */\nvar Texture = /** @class */ (function (_super) {\n    __extends(Texture, _super);\n    /**\n     * @param {PIXI.BaseTexture} baseTexture - The base texture source to create the texture from\n     * @param {PIXI.Rectangle} [frame] - The rectangle frame of the texture to show\n     * @param {PIXI.Rectangle} [orig] - The area of original texture\n     * @param {PIXI.Rectangle} [trim] - Trimmed rectangle of original texture\n     * @param {number} [rotate] - indicates how the texture was rotated by texture packer. See {@link PIXI.groupD8}\n     * @param {PIXI.IPointData} [anchor] - Default anchor point used for sprite placement / rotation\n     */\n    function Texture(baseTexture, frame, orig, trim, rotate, anchor) {\n        var _this = _super.call(this) || this;\n        /**\n         * Does this Texture have any frame data assigned to it?\n         *\n         * This mode is enabled automatically if no frame was passed inside constructor.\n         *\n         * In this mode texture is subscribed to baseTexture events, and fires `update` on any change.\n         *\n         * Beware, after loading or resize of baseTexture event can fired two times!\n         * If you want more control, subscribe on baseTexture itself.\n         *\n         * ```js\n         * texture.on('update', () => {});\n         * ```\n         *\n         * Any assignment of `frame` switches off `noFrame` mode.\n         *\n         * @member {boolean}\n         */\n        _this.noFrame = false;\n        if (!frame) {\n            _this.noFrame = true;\n            frame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle(0, 0, 1, 1);\n        }\n        if (baseTexture instanceof Texture) {\n            baseTexture = baseTexture.baseTexture;\n        }\n        /**\n         * The base texture that this texture uses.\n         *\n         * @member {PIXI.BaseTexture}\n         */\n        _this.baseTexture = baseTexture;\n        /**\n         * This is the area of the BaseTexture image to actually copy to the Canvas / WebGL when rendering,\n         * irrespective of the actual frame size or placement (which can be influenced by trimmed texture atlases)\n         *\n         * @member {PIXI.Rectangle}\n         */\n        _this._frame = frame;\n        /**\n         * This is the trimmed area of original texture, before it was put in atlas\n         * Please call `updateUvs()` after you change coordinates of `trim` manually.\n         *\n         * @member {PIXI.Rectangle}\n         */\n        _this.trim = trim;\n        /**\n         * This will let the renderer know if the texture is valid. If it's not then it cannot be rendered.\n         *\n         * @member {boolean}\n         */\n        _this.valid = false;\n        /**\n         * The WebGL UV data cache. Can be used as quad UV\n         *\n         * @member {PIXI.TextureUvs}\n         * @protected\n         */\n        _this._uvs = DEFAULT_UVS;\n        /**\n         * Default TextureMatrix instance for this texture\n         * By default that object is not created because its heavy\n         *\n         * @member {PIXI.TextureMatrix}\n         */\n        _this.uvMatrix = null;\n        /**\n         * This is the area of original texture, before it was put in atlas\n         *\n         * @member {PIXI.Rectangle}\n         */\n        _this.orig = orig || frame; // new Rectangle(0, 0, 1, 1);\n        _this._rotate = Number(rotate || 0);\n        if (rotate === true) {\n            // this is old texturepacker legacy, some games/libraries are passing \"true\" for rotated textures\n            _this._rotate = 2;\n        }\n        else if (_this._rotate % 2 !== 0) {\n            throw new Error('attempt to use diamond-shaped UVs. If you are sure, set rotation manually');\n        }\n        /**\n         * Anchor point that is used as default if sprite is created with this texture.\n         * Changing the `defaultAnchor` at a later point of time will not update Sprite's anchor point.\n         * @member {PIXI.Point}\n         * @default {0,0}\n         */\n        _this.defaultAnchor = anchor ? new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Point(anchor.x, anchor.y) : new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Point(0, 0);\n        /**\n         * Update ID is observed by sprites and TextureMatrix instances.\n         * Call updateUvs() to increment it.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this._updateID = 0;\n        /**\n         * The ids under which this Texture has been added to the texture cache. This is\n         * automatically set as long as Texture.addToCache is used, but may not be set if a\n         * Texture is added directly to the TextureCache array.\n         *\n         * @member {string[]}\n         */\n        _this.textureCacheIds = [];\n        if (!baseTexture.valid) {\n            baseTexture.once('loaded', _this.onBaseTextureUpdated, _this);\n        }\n        else if (_this.noFrame) {\n            // if there is no frame we should monitor for any base texture changes..\n            if (baseTexture.valid) {\n                _this.onBaseTextureUpdated(baseTexture);\n            }\n        }\n        else {\n            _this.frame = frame;\n        }\n        if (_this.noFrame) {\n            baseTexture.on('update', _this.onBaseTextureUpdated, _this);\n        }\n        return _this;\n    }\n    /**\n     * Updates this texture on the gpu.\n     *\n     * Calls the TextureResource update.\n     *\n     * If you adjusted `frame` manually, please call `updateUvs()` instead.\n     *\n     */\n    Texture.prototype.update = function () {\n        if (this.baseTexture.resource) {\n            this.baseTexture.resource.update();\n        }\n    };\n    /**\n     * Called when the base texture is updated\n     *\n     * @protected\n     * @param {PIXI.BaseTexture} baseTexture - The base texture.\n     */\n    Texture.prototype.onBaseTextureUpdated = function (baseTexture) {\n        if (this.noFrame) {\n            if (!this.baseTexture.valid) {\n                return;\n            }\n            this._frame.width = baseTexture.width;\n            this._frame.height = baseTexture.height;\n            this.valid = true;\n            this.updateUvs();\n        }\n        else {\n            // TODO this code looks confusing.. boo to abusing getters and setters!\n            // if user gave us frame that has bigger size than resized texture it can be a problem\n            this.frame = this._frame;\n        }\n        this.emit('update', this);\n    };\n    /**\n     * Destroys this texture\n     *\n     * @param {boolean} [destroyBase=false] - Whether to destroy the base texture as well\n     */\n    Texture.prototype.destroy = function (destroyBase) {\n        if (this.baseTexture) {\n            if (destroyBase) {\n                var resource = this.baseTexture;\n                // delete the texture if it exists in the texture cache..\n                // this only needs to be removed if the base texture is actually destroyed too..\n                if (resource && resource.url && _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[resource.url]) {\n                    Texture.removeFromCache(resource.url);\n                }\n                this.baseTexture.destroy();\n            }\n            this.baseTexture.off('loaded', this.onBaseTextureUpdated, this);\n            this.baseTexture.off('update', this.onBaseTextureUpdated, this);\n            this.baseTexture = null;\n        }\n        this._frame = null;\n        this._uvs = null;\n        this.trim = null;\n        this.orig = null;\n        this.valid = false;\n        Texture.removeFromCache(this);\n        this.textureCacheIds = null;\n    };\n    /**\n     * Creates a new texture object that acts the same as this one.\n     *\n     * @return {PIXI.Texture} The new texture\n     */\n    Texture.prototype.clone = function () {\n        return new Texture(this.baseTexture, this.frame.clone(), this.orig.clone(), this.trim && this.trim.clone(), this.rotate, this.defaultAnchor);\n    };\n    /**\n     * Updates the internal WebGL UV cache. Use it after you change `frame` or `trim` of the texture.\n     * Call it after changing the frame\n     */\n    Texture.prototype.updateUvs = function () {\n        if (this._uvs === DEFAULT_UVS) {\n            this._uvs = new TextureUvs();\n        }\n        this._uvs.set(this._frame, this.baseTexture, this.rotate);\n        this._updateID++;\n    };\n    /**\n     * Helper function that creates a new Texture based on the source you provide.\n     * The source can be - frame id, image url, video url, canvas element, video element, base texture\n     *\n     * @static\n     * @param {string|HTMLImageElement|HTMLCanvasElement|HTMLVideoElement|PIXI.BaseTexture} source\n     *        Source to create texture from\n     * @param {object} [options] See {@link PIXI.BaseTexture}'s constructor for options.\n     * @param {boolean} [strict] - Enforce strict-mode, see {@link PIXI.settings.STRICT_TEXTURE_CACHE}.\n     * @return {PIXI.Texture} The newly created texture\n     */\n    Texture.from = function (source, options, strict) {\n        if (options === void 0) { options = {}; }\n        if (strict === void 0) { strict = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.STRICT_TEXTURE_CACHE; }\n        var isFrame = typeof source === 'string';\n        var cacheId = null;\n        if (isFrame) {\n            cacheId = source;\n        }\n        else {\n            if (!source._pixiId) {\n                source._pixiId = \"pixiid_\" + (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.uid)();\n            }\n            cacheId = source._pixiId;\n        }\n        var texture = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[cacheId];\n        // Strict-mode rejects invalid cacheIds\n        if (isFrame && strict && !texture) {\n            throw new Error(\"The cacheId \\\"\" + cacheId + \"\\\" does not exist in TextureCache.\");\n        }\n        if (!texture) {\n            if (!options.resolution) {\n                options.resolution = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.getResolutionOfUrl)(source);\n            }\n            texture = new Texture(new BaseTexture(source, options));\n            texture.baseTexture.cacheId = cacheId;\n            BaseTexture.addToCache(texture.baseTexture, cacheId);\n            Texture.addToCache(texture, cacheId);\n        }\n        // lets assume its a base texture!\n        return texture;\n    };\n    /**\n     * Useful for loading textures via URLs. Use instead of `Texture.from` because\n     * it does a better job of handling failed URLs more effectively. This also ignores\n     * `PIXI.settings.STRICT_TEXTURE_CACHE`. Works for Videos, SVGs, Images.\n     * @param {string} url The remote URL to load.\n     * @param {object} [options] Optional options to include\n     * @return {Promise<PIXI.Texture>} A Promise that resolves to a Texture.\n     */\n    Texture.fromURL = function (url, options) {\n        var resourceOptions = Object.assign({ autoLoad: false }, options === null || options === void 0 ? void 0 : options.resourceOptions);\n        var texture = Texture.from(url, Object.assign({ resourceOptions: resourceOptions }, options), false);\n        var resource = texture.baseTexture.resource;\n        // The texture was already loaded\n        if (texture.baseTexture.valid) {\n            return Promise.resolve(texture);\n        }\n        // Manually load the texture, this should allow users to handle load errors\n        return resource.load().then(function () { return Promise.resolve(texture); });\n    };\n    /**\n     * Create a new Texture with a BufferResource from a Float32Array.\n     * RGBA values are floats from 0 to 1.\n     * @static\n     * @param {Float32Array|Uint8Array} buffer - The optional array to use, if no data\n     *        is provided, a new Float32Array is created.\n     * @param {number} width - Width of the resource\n     * @param {number} height - Height of the resource\n     * @param {object} [options] See {@link PIXI.BaseTexture}'s constructor for options.\n     * @return {PIXI.Texture} The resulting new BaseTexture\n     */\n    Texture.fromBuffer = function (buffer, width, height, options) {\n        return new Texture(BaseTexture.fromBuffer(buffer, width, height, options));\n    };\n    /**\n     * Create a texture from a source and add to the cache.\n     *\n     * @static\n     * @param {HTMLImageElement|HTMLCanvasElement} source - The input source.\n     * @param {String} imageUrl - File name of texture, for cache and resolving resolution.\n     * @param {String} [name] - Human readable name for the texture cache. If no name is\n     *        specified, only `imageUrl` will be used as the cache ID.\n     * @return {PIXI.Texture} Output texture\n     */\n    Texture.fromLoader = function (source, imageUrl, name) {\n        var resource = new ImageResource(source);\n        resource.url = imageUrl;\n        var baseTexture = new BaseTexture(resource, {\n            scaleMode: _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SCALE_MODE,\n            resolution: (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.getResolutionOfUrl)(imageUrl),\n        });\n        var texture = new Texture(baseTexture);\n        // No name, use imageUrl instead\n        if (!name) {\n            name = imageUrl;\n        }\n        // lets also add the frame to pixi's global cache for 'fromLoader' function\n        BaseTexture.addToCache(texture.baseTexture, name);\n        Texture.addToCache(texture, name);\n        // also add references by url if they are different.\n        if (name !== imageUrl) {\n            BaseTexture.addToCache(texture.baseTexture, imageUrl);\n            Texture.addToCache(texture, imageUrl);\n        }\n        return texture;\n    };\n    /**\n     * Adds a Texture to the global TextureCache. This cache is shared across the whole PIXI object.\n     *\n     * @static\n     * @param {PIXI.Texture} texture - The Texture to add to the cache.\n     * @param {string} id - The id that the Texture will be stored against.\n     */\n    Texture.addToCache = function (texture, id) {\n        if (id) {\n            if (texture.textureCacheIds.indexOf(id) === -1) {\n                texture.textureCacheIds.push(id);\n            }\n            if (_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[id]) {\n                // eslint-disable-next-line no-console\n                console.warn(\"Texture added to the cache with an id [\" + id + \"] that already had an entry\");\n            }\n            _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[id] = texture;\n        }\n    };\n    /**\n     * Remove a Texture from the global TextureCache.\n     *\n     * @static\n     * @param {string|PIXI.Texture} texture - id of a Texture to be removed, or a Texture instance itself\n     * @return {PIXI.Texture|null} The Texture that was removed\n     */\n    Texture.removeFromCache = function (texture) {\n        if (typeof texture === 'string') {\n            var textureFromCache = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[texture];\n            if (textureFromCache) {\n                var index = textureFromCache.textureCacheIds.indexOf(texture);\n                if (index > -1) {\n                    textureFromCache.textureCacheIds.splice(index, 1);\n                }\n                delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[texture];\n                return textureFromCache;\n            }\n        }\n        else if (texture && texture.textureCacheIds) {\n            for (var i = 0; i < texture.textureCacheIds.length; ++i) {\n                // Check that texture matches the one being passed in before deleting it from the cache.\n                if (_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[texture.textureCacheIds[i]] === texture) {\n                    delete _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.TextureCache[texture.textureCacheIds[i]];\n                }\n            }\n            texture.textureCacheIds.length = 0;\n            return texture;\n        }\n        return null;\n    };\n    Object.defineProperty(Texture.prototype, \"resolution\", {\n        /**\n         * Returns resolution of baseTexture\n         *\n         * @member {number}\n         * @readonly\n         */\n        get: function () {\n            return this.baseTexture.resolution;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Texture.prototype, \"frame\", {\n        /**\n         * The frame specifies the region of the base texture that this texture uses.\n         * Please call `updateUvs()` after you change coordinates of `frame` manually.\n         *\n         * @member {PIXI.Rectangle}\n         */\n        get: function () {\n            return this._frame;\n        },\n        set: function (frame) {\n            this._frame = frame;\n            this.noFrame = false;\n            var x = frame.x, y = frame.y, width = frame.width, height = frame.height;\n            var xNotFit = x + width > this.baseTexture.width;\n            var yNotFit = y + height > this.baseTexture.height;\n            if (xNotFit || yNotFit) {\n                var relationship = xNotFit && yNotFit ? 'and' : 'or';\n                var errorX = \"X: \" + x + \" + \" + width + \" = \" + (x + width) + \" > \" + this.baseTexture.width;\n                var errorY = \"Y: \" + y + \" + \" + height + \" = \" + (y + height) + \" > \" + this.baseTexture.height;\n                throw new Error('Texture Error: frame does not fit inside the base Texture dimensions: '\n                    + (errorX + \" \" + relationship + \" \" + errorY));\n            }\n            this.valid = width && height && this.baseTexture.valid;\n            if (!this.trim && !this.rotate) {\n                this.orig = frame;\n            }\n            if (this.valid) {\n                this.updateUvs();\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Texture.prototype, \"rotate\", {\n        /**\n         * Indicates whether the texture is rotated inside the atlas\n         * set to 2 to compensate for texture packer rotation\n         * set to 6 to compensate for spine packer rotation\n         * can be used to rotate or mirror sprites\n         * See {@link PIXI.groupD8} for explanation\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._rotate;\n        },\n        set: function (rotate) {\n            this._rotate = rotate;\n            if (this.valid) {\n                this.updateUvs();\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Texture.prototype, \"width\", {\n        /**\n         * The width of the Texture in pixels.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.orig.width;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Texture.prototype, \"height\", {\n        /**\n         * The height of the Texture in pixels.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.orig.height;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Utility function for BaseTexture|Texture cast\n     */\n    Texture.prototype.castToBaseTexture = function () {\n        return this.baseTexture;\n    };\n    return Texture;\n}(_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.EventEmitter));\nfunction createWhiteTexture() {\n    var canvas = document.createElement('canvas');\n    canvas.width = 16;\n    canvas.height = 16;\n    var context = canvas.getContext('2d');\n    context.fillStyle = 'white';\n    context.fillRect(0, 0, 16, 16);\n    return new Texture(new BaseTexture(new CanvasResource(canvas)));\n}\nfunction removeAllHandlers(tex) {\n    tex.destroy = function _emptyDestroy() { };\n    tex.on = function _emptyOn() { };\n    tex.once = function _emptyOnce() { };\n    tex.emit = function _emptyEmit() { };\n}\n/**\n * An empty texture, used often to not have to create multiple empty textures.\n * Can not be destroyed.\n *\n * @static\n * @constant\n * @member {PIXI.Texture}\n */\nTexture.EMPTY = new Texture(new BaseTexture());\nremoveAllHandlers(Texture.EMPTY);\nremoveAllHandlers(Texture.EMPTY.baseTexture);\n/**\n * A white texture of 16x16 size, used for graphics and other things\n * Can not be destroyed.\n *\n * @static\n * @constant\n * @member {PIXI.Texture}\n */\nTexture.WHITE = createWhiteTexture();\nremoveAllHandlers(Texture.WHITE);\nremoveAllHandlers(Texture.WHITE.baseTexture);\n\n/**\n * A RenderTexture is a special texture that allows any PixiJS display object to be rendered to it.\n *\n * __Hint__: All DisplayObjects (i.e. Sprites) that render to a RenderTexture should be preloaded\n * otherwise black rectangles will be drawn instead.\n *\n * __Hint-2__: The actual memory allocation will happen on first render.\n * You shouldn't create renderTextures each frame just to delete them after, try to reuse them.\n *\n * A RenderTexture takes a snapshot of any Display Object given to its render method. For example:\n *\n * ```js\n * let renderer = PIXI.autoDetectRenderer();\n * let renderTexture = PIXI.RenderTexture.create({ width: 800, height: 600 });\n * let sprite = PIXI.Sprite.from(\"spinObj_01.png\");\n *\n * sprite.position.x = 800/2;\n * sprite.position.y = 600/2;\n * sprite.anchor.x = 0.5;\n * sprite.anchor.y = 0.5;\n *\n * renderer.render(sprite, renderTexture);\n * ```\n *\n * The Sprite in this case will be rendered using its local transform. To render this sprite at 0,0\n * you can clear the transform\n *\n * ```js\n *\n * sprite.setTransform()\n *\n * let renderTexture = new PIXI.RenderTexture.create(100, 100);\n *\n * renderer.render(sprite, renderTexture);  // Renders to center of RenderTexture\n * ```\n *\n * @class\n * @extends PIXI.Texture\n * @memberof PIXI\n */\nvar RenderTexture = /** @class */ (function (_super) {\n    __extends(RenderTexture, _super);\n    /**\n     * @param {PIXI.BaseRenderTexture} baseRenderTexture - The base texture object that this texture uses\n     * @param {PIXI.Rectangle} [frame] - The rectangle frame of the texture to show\n     */\n    function RenderTexture(baseRenderTexture, frame) {\n        var _this = this;\n        // support for legacy..\n        var _legacyRenderer = null;\n        if (!(baseRenderTexture instanceof BaseRenderTexture)) {\n            /* eslint-disable prefer-rest-params, no-console */\n            var width = arguments[1];\n            var height = arguments[2];\n            var scaleMode = arguments[3];\n            var resolution = arguments[4];\n            // we have an old render texture..\n            console.warn(\"Please use RenderTexture.create(\" + width + \", \" + height + \") instead of the ctor directly.\");\n            _legacyRenderer = arguments[0];\n            /* eslint-enable prefer-rest-params, no-console */\n            frame = null;\n            baseRenderTexture = new BaseRenderTexture({\n                width: width,\n                height: height,\n                scaleMode: scaleMode,\n                resolution: resolution,\n            });\n        }\n        /**\n         * The base texture object that this texture uses\n         *\n         * @member {PIXI.BaseTexture}\n         */\n        _this = _super.call(this, baseRenderTexture, frame) || this;\n        _this.legacyRenderer = _legacyRenderer;\n        /**\n         * This will let the renderer know if the texture is valid. If it's not then it cannot be rendered.\n         *\n         * @member {boolean}\n         */\n        _this.valid = true;\n        /**\n         * Stores `sourceFrame` when this texture is inside current filter stack.\n         * You can read it inside filters.\n         *\n         * @readonly\n         * @member {PIXI.Rectangle}\n         */\n        _this.filterFrame = null;\n        /**\n         * The key for pooled texture of FilterSystem\n         * @protected\n         * @member {string}\n         */\n        _this.filterPoolKey = null;\n        _this.updateUvs();\n        return _this;\n    }\n    Object.defineProperty(RenderTexture.prototype, \"framebuffer\", {\n        /**\n         * Shortcut to `this.baseTexture.framebuffer`, saves baseTexture cast.\n         * @member {PIXI.Framebuffer}\n         * @readonly\n         */\n        get: function () {\n            return this.baseTexture.framebuffer;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Resizes the RenderTexture.\n     *\n     * @param {number} width - The width to resize to.\n     * @param {number} height - The height to resize to.\n     * @param {boolean} [resizeBaseTexture=true] - Should the baseTexture.width and height values be resized as well?\n     */\n    RenderTexture.prototype.resize = function (width, height, resizeBaseTexture) {\n        if (resizeBaseTexture === void 0) { resizeBaseTexture = true; }\n        width = Math.ceil(width);\n        height = Math.ceil(height);\n        // TODO - could be not required..\n        this.valid = (width > 0 && height > 0);\n        this._frame.width = this.orig.width = width;\n        this._frame.height = this.orig.height = height;\n        if (resizeBaseTexture) {\n            this.baseTexture.resize(width, height);\n        }\n        this.updateUvs();\n    };\n    /**\n     * Changes the resolution of baseTexture, but does not change framebuffer size.\n     *\n     * @param {number} resolution - The new resolution to apply to RenderTexture\n     */\n    RenderTexture.prototype.setResolution = function (resolution) {\n        var baseTexture = this.baseTexture;\n        if (baseTexture.resolution === resolution) {\n            return;\n        }\n        baseTexture.setResolution(resolution);\n        this.resize(baseTexture.width, baseTexture.height, false);\n    };\n    /**\n     * A short hand way of creating a render texture.\n     *\n     * @param {object} [options] - Options\n     * @param {number} [options.width=100] - The width of the render texture\n     * @param {number} [options.height=100] - The height of the render texture\n     * @param {number} [options.scaleMode=PIXI.settings.SCALE_MODE] - See {@link PIXI.SCALE_MODES} for possible values\n     * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the texture being generated\n     * @return {PIXI.RenderTexture} The new render texture\n     */\n    RenderTexture.create = function (options) {\n        // fallback, old-style: create(width, height, scaleMode, resolution)\n        if (typeof options === 'number') {\n            /* eslint-disable prefer-rest-params */\n            options = {\n                width: options,\n                height: arguments[1],\n                scaleMode: arguments[2],\n                resolution: arguments[3],\n            };\n            /* eslint-enable prefer-rest-params */\n        }\n        return new RenderTexture(new BaseRenderTexture(options));\n    };\n    return RenderTexture;\n}(Texture));\n\n/**\n * Experimental!\n *\n * Texture pool, used by FilterSystem and plugins\n * Stores collection of temporary pow2 or screen-sized renderTextures\n *\n * If you use custom RenderTexturePool for your filters, you can use methods\n * `getFilterTexture` and `returnFilterTexture` same as in\n *\n * @class\n * @memberof PIXI\n */\nvar RenderTexturePool = /** @class */ (function () {\n    /**\n     * @param {object} [textureOptions] - options that will be passed to BaseRenderTexture constructor\n     * @param {PIXI.SCALE_MODES} [textureOptions.scaleMode] - See {@link PIXI.SCALE_MODES} for possible values.\n     */\n    function RenderTexturePool(textureOptions) {\n        this.texturePool = {};\n        this.textureOptions = textureOptions || {};\n        /**\n         * Allow renderTextures of the same size as screen, not just pow2\n         *\n         * Automatically sets to true after `setScreenSize`\n         *\n         * @member {boolean}\n         * @default false\n         */\n        this.enableFullScreen = false;\n        this._pixelsWidth = 0;\n        this._pixelsHeight = 0;\n    }\n    /**\n     * creates of texture with params that were specified in pool constructor\n     *\n     * @param {number} realWidth - width of texture in pixels\n     * @param {number} realHeight - height of texture in pixels\n     * @returns {RenderTexture}\n     */\n    RenderTexturePool.prototype.createTexture = function (realWidth, realHeight) {\n        var baseRenderTexture = new BaseRenderTexture(Object.assign({\n            width: realWidth,\n            height: realHeight,\n            resolution: 1,\n        }, this.textureOptions));\n        return new RenderTexture(baseRenderTexture);\n    };\n    /**\n     * Gets a Power-of-Two render texture or fullScreen texture\n     *\n     * @protected\n     * @param {number} minWidth - The minimum width of the render texture in real pixels.\n     * @param {number} minHeight - The minimum height of the render texture in real pixels.\n     * @param {number} [resolution=1] - The resolution of the render texture.\n     * @return {PIXI.RenderTexture} The new render texture.\n     */\n    RenderTexturePool.prototype.getOptimalTexture = function (minWidth, minHeight, resolution) {\n        if (resolution === void 0) { resolution = 1; }\n        var key = RenderTexturePool.SCREEN_KEY;\n        minWidth *= resolution;\n        minHeight *= resolution;\n        if (!this.enableFullScreen || minWidth !== this._pixelsWidth || minHeight !== this._pixelsHeight) {\n            minWidth = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.nextPow2)(minWidth);\n            minHeight = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.nextPow2)(minHeight);\n            key = ((minWidth & 0xFFFF) << 16) | (minHeight & 0xFFFF);\n        }\n        if (!this.texturePool[key]) {\n            this.texturePool[key] = [];\n        }\n        var renderTexture = this.texturePool[key].pop();\n        if (!renderTexture) {\n            renderTexture = this.createTexture(minWidth, minHeight);\n        }\n        renderTexture.filterPoolKey = key;\n        renderTexture.setResolution(resolution);\n        return renderTexture;\n    };\n    /**\n     * Gets extra texture of the same size as input renderTexture\n     *\n     * `getFilterTexture(input, 0.5)` or `getFilterTexture(0.5, input)`\n     *\n     * @param {PIXI.RenderTexture} input - renderTexture from which size and resolution will be copied\n     * @param {number} [resolution] - override resolution of the renderTexture\n     *  It overrides, it does not multiply\n     * @returns {PIXI.RenderTexture}\n     */\n    RenderTexturePool.prototype.getFilterTexture = function (input, resolution) {\n        var filterTexture = this.getOptimalTexture(input.width, input.height, resolution || input.resolution);\n        filterTexture.filterFrame = input.filterFrame;\n        return filterTexture;\n    };\n    /**\n     * Place a render texture back into the pool.\n     * @param {PIXI.RenderTexture} renderTexture - The renderTexture to free\n     */\n    RenderTexturePool.prototype.returnTexture = function (renderTexture) {\n        var key = renderTexture.filterPoolKey;\n        renderTexture.filterFrame = null;\n        this.texturePool[key].push(renderTexture);\n    };\n    /**\n     * Alias for returnTexture, to be compliant with FilterSystem interface\n     * @param {PIXI.RenderTexture} renderTexture - The renderTexture to free\n     */\n    RenderTexturePool.prototype.returnFilterTexture = function (renderTexture) {\n        this.returnTexture(renderTexture);\n    };\n    /**\n     * Clears the pool\n     *\n     * @param {boolean} [destroyTextures=true] - destroy all stored textures\n     */\n    RenderTexturePool.prototype.clear = function (destroyTextures) {\n        destroyTextures = destroyTextures !== false;\n        if (destroyTextures) {\n            for (var i in this.texturePool) {\n                var textures = this.texturePool[i];\n                if (textures) {\n                    for (var j = 0; j < textures.length; j++) {\n                        textures[j].destroy(true);\n                    }\n                }\n            }\n        }\n        this.texturePool = {};\n    };\n    /**\n     * If screen size was changed, drops all screen-sized textures,\n     * sets new screen size, sets `enableFullScreen` to true\n     *\n     * Size is measured in pixels, `renderer.view` can be passed here, not `renderer.screen`\n     *\n     * @param {PIXI.ISize} size - Initial size of screen\n     */\n    RenderTexturePool.prototype.setScreenSize = function (size) {\n        if (size.width === this._pixelsWidth\n            && size.height === this._pixelsHeight) {\n            return;\n        }\n        var screenKey = RenderTexturePool.SCREEN_KEY;\n        var textures = this.texturePool[screenKey];\n        this.enableFullScreen = size.width > 0 && size.height > 0;\n        if (textures) {\n            for (var j = 0; j < textures.length; j++) {\n                textures[j].destroy(true);\n            }\n        }\n        this.texturePool[screenKey] = [];\n        this._pixelsWidth = size.width;\n        this._pixelsHeight = size.height;\n    };\n    /**\n     * Key that is used to store fullscreen renderTextures in a pool\n     *\n     * @static\n     * @const {string}\n     */\n    RenderTexturePool.SCREEN_KEY = 'screen';\n    return RenderTexturePool;\n}());\n\n/* eslint-disable max-len */\n/**\n * Holds the information for a single attribute structure required to render geometry.\n *\n * This does not contain the actual data, but instead has a buffer id that maps to a {@link PIXI.Buffer}\n * This can include anything from positions, uvs, normals, colors etc.\n *\n * @class\n * @memberof PIXI\n */\nvar Attribute = /** @class */ (function () {\n    /**\n     * @param {string} buffer - the id of the buffer that this attribute will look for\n     * @param {Number} [size=0] - the size of the attribute. If you have 2 floats per vertex (eg position x and y) this would be 2.\n     * @param {Boolean} [normalized=false] - should the data be normalized.\n     * @param {Number} [type=PIXI.TYPES.FLOAT] - what type of number is the attribute. Check {@link PIXI.TYPES} to see the ones available\n     * @param {Number} [stride=0] - How far apart (in floats) the start of each value is. (used for interleaving data)\n     * @param {Number} [start=0] - How far into the array to start reading values (used for interleaving data)\n     */\n    function Attribute(buffer, size, normalized, type, stride, start, instance) {\n        if (size === void 0) { size = 0; }\n        if (normalized === void 0) { normalized = false; }\n        if (type === void 0) { type = 5126; }\n        this.buffer = buffer;\n        this.size = size;\n        this.normalized = normalized;\n        this.type = type;\n        this.stride = stride;\n        this.start = start;\n        this.instance = instance;\n    }\n    /**\n     * Destroys the Attribute.\n     */\n    Attribute.prototype.destroy = function () {\n        this.buffer = null;\n    };\n    /**\n     * Helper function that creates an Attribute based on the information provided\n     *\n     * @static\n     * @param {string} buffer - the id of the buffer that this attribute will look for\n     * @param {Number} [size=0] - the size of the attribute. If you have 2 floats per vertex (eg position x and y) this would be 2\n     * @param {Boolean} [normalized=false] - should the data be normalized.\n     * @param {Number} [type=PIXI.TYPES.FLOAT] - what type of number is the attribute. Check {@link PIXI.TYPES} to see the ones available\n     * @param {Number} [stride=0] - How far apart (in floats) the start of each value is. (used for interleaving data)\n     *\n     * @returns {PIXI.Attribute} A new {@link PIXI.Attribute} based on the information provided\n     */\n    Attribute.from = function (buffer, size, normalized, type, stride) {\n        return new Attribute(buffer, size, normalized, type, stride);\n    };\n    return Attribute;\n}());\n\nvar UID = 0;\n/**\n * A wrapper for data so that it can be used and uploaded by WebGL\n *\n * @class\n * @memberof PIXI\n */\nvar Buffer = /** @class */ (function () {\n    /**\n     * @param {ArrayBuffer| SharedArrayBuffer|ArrayBufferView} data - the data to store in the buffer.\n     * @param {boolean} [_static=true] - `true` for static buffer\n     * @param {boolean} [index=false] - `true` for index buffer\n     */\n    function Buffer(data, _static, index) {\n        if (_static === void 0) { _static = true; }\n        if (index === void 0) { index = false; }\n        /**\n         * The data in the buffer, as a typed array\n         *\n         * @member {ArrayBuffer| SharedArrayBuffer | ArrayBufferView}\n         */\n        this.data = (data || new Float32Array(1));\n        /**\n         * A map of renderer IDs to webgl buffer\n         *\n         * @private\n         * @member {object<number, GLBuffer>}\n         */\n        this._glBuffers = {};\n        this._updateID = 0;\n        this.index = index;\n        this.static = _static;\n        this.id = UID++;\n        this.disposeRunner = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('disposeBuffer');\n    }\n    // TODO could explore flagging only a partial upload?\n    /**\n     * flags this buffer as requiring an upload to the GPU\n     * @param {ArrayBuffer|SharedArrayBuffer|ArrayBufferView} [data] - the data to update in the buffer.\n     */\n    Buffer.prototype.update = function (data) {\n        this.data = data || this.data;\n        this._updateID++;\n    };\n    /**\n     * disposes WebGL resources that are connected to this geometry\n     */\n    Buffer.prototype.dispose = function () {\n        this.disposeRunner.emit(this, false);\n    };\n    /**\n     * Destroys the buffer\n     */\n    Buffer.prototype.destroy = function () {\n        this.dispose();\n        this.data = null;\n    };\n    /**\n     * Helper function that creates a buffer based on an array or TypedArray\n     *\n     * @static\n     * @param {ArrayBufferView | number[]} data - the TypedArray that the buffer will store. If this is a regular Array it will be converted to a Float32Array.\n     * @return {PIXI.Buffer} A new Buffer based on the data provided.\n     */\n    Buffer.from = function (data) {\n        if (data instanceof Array) {\n            data = new Float32Array(data);\n        }\n        return new Buffer(data);\n    };\n    return Buffer;\n}());\n\nfunction getBufferType(array) {\n    if (array.BYTES_PER_ELEMENT === 4) {\n        if (array instanceof Float32Array) {\n            return 'Float32Array';\n        }\n        else if (array instanceof Uint32Array) {\n            return 'Uint32Array';\n        }\n        return 'Int32Array';\n    }\n    else if (array.BYTES_PER_ELEMENT === 2) {\n        if (array instanceof Uint16Array) {\n            return 'Uint16Array';\n        }\n    }\n    else if (array.BYTES_PER_ELEMENT === 1) {\n        if (array instanceof Uint8Array) {\n            return 'Uint8Array';\n        }\n    }\n    // TODO map out the rest of the array elements!\n    return null;\n}\n\n/* eslint-disable object-shorthand */\nvar map = {\n    Float32Array: Float32Array,\n    Uint32Array: Uint32Array,\n    Int32Array: Int32Array,\n    Uint8Array: Uint8Array,\n};\nfunction interleaveTypedArrays(arrays, sizes) {\n    var outSize = 0;\n    var stride = 0;\n    var views = {};\n    for (var i = 0; i < arrays.length; i++) {\n        stride += sizes[i];\n        outSize += arrays[i].length;\n    }\n    var buffer = new ArrayBuffer(outSize * 4);\n    var out = null;\n    var littleOffset = 0;\n    for (var i = 0; i < arrays.length; i++) {\n        var size = sizes[i];\n        var array = arrays[i];\n        var type = getBufferType(array);\n        if (!views[type]) {\n            views[type] = new map[type](buffer);\n        }\n        out = views[type];\n        for (var j = 0; j < array.length; j++) {\n            var indexStart = ((j / size | 0) * stride) + littleOffset;\n            var index = j % size;\n            out[indexStart + index] = array[j];\n        }\n        littleOffset += size;\n    }\n    return new Float32Array(buffer);\n}\n\nvar byteSizeMap = { 5126: 4, 5123: 2, 5121: 1 };\nvar UID$1 = 0;\n/* eslint-disable object-shorthand */\nvar map$1 = {\n    Float32Array: Float32Array,\n    Uint32Array: Uint32Array,\n    Int32Array: Int32Array,\n    Uint8Array: Uint8Array,\n    Uint16Array: Uint16Array,\n};\n/* eslint-disable max-len */\n/**\n * The Geometry represents a model. It consists of two components:\n * - GeometryStyle - The structure of the model such as the attributes layout\n * - GeometryData - the data of the model - this consists of buffers.\n * This can include anything from positions, uvs, normals, colors etc.\n *\n * Geometry can be defined without passing in a style or data if required (thats how I prefer!)\n *\n * ```js\n * let geometry = new PIXI.Geometry();\n *\n * geometry.addAttribute('positions', [0, 0, 100, 0, 100, 100, 0, 100], 2);\n * geometry.addAttribute('uvs', [0,0,1,0,1,1,0,1],2)\n * geometry.addIndex([0,1,2,1,3,2])\n *\n * ```\n * @class\n * @memberof PIXI\n */\nvar Geometry = /** @class */ (function () {\n    /**\n     * @param {PIXI.Buffer[]} [buffers] - an array of buffers. optional.\n     * @param {object} [attributes] - of the geometry, optional structure of the attributes layout\n     */\n    function Geometry(buffers, attributes) {\n        if (buffers === void 0) { buffers = []; }\n        if (attributes === void 0) { attributes = {}; }\n        this.buffers = buffers;\n        this.indexBuffer = null;\n        this.attributes = attributes;\n        /**\n         * A map of renderer IDs to webgl VAOs\n         *\n         * @protected\n         * @type {object}\n         */\n        this.glVertexArrayObjects = {};\n        this.id = UID$1++;\n        this.instanced = false;\n        /**\n         * Number of instances in this geometry, pass it to `GeometrySystem.draw()`\n         * @member {number}\n         * @default 1\n         */\n        this.instanceCount = 1;\n        this.disposeRunner = new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('disposeGeometry');\n        /**\n         * Count of existing (not destroyed) meshes that reference this geometry\n         * @member {number}\n         */\n        this.refCount = 0;\n    }\n    /**\n    *\n    * Adds an attribute to the geometry\n    * Note: `stride` and `start` should be `undefined` if you dont know them, not 0!\n    *\n    * @param {String} id - the name of the attribute (matching up to a shader)\n    * @param {PIXI.Buffer|number[]} [buffer] - the buffer that holds the data of the attribute . You can also provide an Array and a buffer will be created from it.\n    * @param {Number} [size=0] - the size of the attribute. If you have 2 floats per vertex (eg position x and y) this would be 2\n    * @param {Boolean} [normalized=false] - should the data be normalized.\n    * @param {Number} [type=PIXI.TYPES.FLOAT] - what type of number is the attribute. Check {PIXI.TYPES} to see the ones available\n    * @param {Number} [stride] - How far apart (in floats) the start of each value is. (used for interleaving data)\n    * @param {Number} [start] - How far into the array to start reading values (used for interleaving data)\n    * @param {boolean} [instance=false] - Instancing flag\n    *\n    * @return {PIXI.Geometry} returns self, useful for chaining.\n    */\n    Geometry.prototype.addAttribute = function (id, buffer, size, normalized, type, stride, start, instance) {\n        if (size === void 0) { size = 0; }\n        if (normalized === void 0) { normalized = false; }\n        if (instance === void 0) { instance = false; }\n        if (!buffer) {\n            throw new Error('You must pass a buffer when creating an attribute');\n        }\n        // check if this is a buffer!\n        if (!(buffer instanceof Buffer)) {\n            // its an array!\n            if (buffer instanceof Array) {\n                buffer = new Float32Array(buffer);\n            }\n            buffer = new Buffer(buffer);\n        }\n        var ids = id.split('|');\n        if (ids.length > 1) {\n            for (var i = 0; i < ids.length; i++) {\n                this.addAttribute(ids[i], buffer, size, normalized, type);\n            }\n            return this;\n        }\n        var bufferIndex = this.buffers.indexOf(buffer);\n        if (bufferIndex === -1) {\n            this.buffers.push(buffer);\n            bufferIndex = this.buffers.length - 1;\n        }\n        this.attributes[id] = new Attribute(bufferIndex, size, normalized, type, stride, start, instance);\n        // assuming that if there is instanced data then this will be drawn with instancing!\n        this.instanced = this.instanced || instance;\n        return this;\n    };\n    /**\n     * returns the requested attribute\n     *\n     * @param {String} id - the name of the attribute required\n     * @return {PIXI.Attribute} the attribute requested.\n     */\n    Geometry.prototype.getAttribute = function (id) {\n        return this.attributes[id];\n    };\n    /**\n     * returns the requested buffer\n     *\n     * @param {String} id - the name of the buffer required\n     * @return {PIXI.Buffer} the buffer requested.\n     */\n    Geometry.prototype.getBuffer = function (id) {\n        return this.buffers[this.getAttribute(id).buffer];\n    };\n    /**\n    *\n    * Adds an index buffer to the geometry\n    * The index buffer contains integers, three for each triangle in the geometry, which reference the various attribute buffers (position, colour, UV coordinates, other UV coordinates, normal, …). There is only ONE index buffer.\n    *\n    * @param {PIXI.Buffer|number[]} [buffer] - the buffer that holds the data of the index buffer. You can also provide an Array and a buffer will be created from it.\n    * @return {PIXI.Geometry} returns self, useful for chaining.\n    */\n    Geometry.prototype.addIndex = function (buffer) {\n        if (!(buffer instanceof Buffer)) {\n            // its an array!\n            if (buffer instanceof Array) {\n                buffer = new Uint16Array(buffer);\n            }\n            buffer = new Buffer(buffer);\n        }\n        buffer.index = true;\n        this.indexBuffer = buffer;\n        if (this.buffers.indexOf(buffer) === -1) {\n            this.buffers.push(buffer);\n        }\n        return this;\n    };\n    /**\n     * returns the index buffer\n     *\n     * @return {PIXI.Buffer} the index buffer.\n     */\n    Geometry.prototype.getIndex = function () {\n        return this.indexBuffer;\n    };\n    /**\n     * this function modifies the structure so that all current attributes become interleaved into a single buffer\n     * This can be useful if your model remains static as it offers a little performance boost\n     *\n     * @return {PIXI.Geometry} returns self, useful for chaining.\n     */\n    Geometry.prototype.interleave = function () {\n        // a simple check to see if buffers are already interleaved..\n        if (this.buffers.length === 1 || (this.buffers.length === 2 && this.indexBuffer))\n            { return this; }\n        // assume already that no buffers are interleaved\n        var arrays = [];\n        var sizes = [];\n        var interleavedBuffer = new Buffer();\n        var i;\n        for (i in this.attributes) {\n            var attribute = this.attributes[i];\n            var buffer = this.buffers[attribute.buffer];\n            arrays.push(buffer.data);\n            sizes.push((attribute.size * byteSizeMap[attribute.type]) / 4);\n            attribute.buffer = 0;\n        }\n        interleavedBuffer.data = interleaveTypedArrays(arrays, sizes);\n        for (i = 0; i < this.buffers.length; i++) {\n            if (this.buffers[i] !== this.indexBuffer) {\n                this.buffers[i].destroy();\n            }\n        }\n        this.buffers = [interleavedBuffer];\n        if (this.indexBuffer) {\n            this.buffers.push(this.indexBuffer);\n        }\n        return this;\n    };\n    Geometry.prototype.getSize = function () {\n        for (var i in this.attributes) {\n            var attribute = this.attributes[i];\n            var buffer = this.buffers[attribute.buffer];\n            return buffer.data.length / ((attribute.stride / 4) || attribute.size);\n        }\n        return 0;\n    };\n    /**\n     * disposes WebGL resources that are connected to this geometry\n     */\n    Geometry.prototype.dispose = function () {\n        this.disposeRunner.emit(this, false);\n    };\n    /**\n     * Destroys the geometry.\n     */\n    Geometry.prototype.destroy = function () {\n        this.dispose();\n        this.buffers = null;\n        this.indexBuffer = null;\n        this.attributes = null;\n    };\n    /**\n     * returns a clone of the geometry\n     *\n     * @returns {PIXI.Geometry} a new clone of this geometry\n     */\n    Geometry.prototype.clone = function () {\n        var geometry = new Geometry();\n        for (var i = 0; i < this.buffers.length; i++) {\n            geometry.buffers[i] = new Buffer(this.buffers[i].data.slice(0));\n        }\n        for (var i in this.attributes) {\n            var attrib = this.attributes[i];\n            geometry.attributes[i] = new Attribute(attrib.buffer, attrib.size, attrib.normalized, attrib.type, attrib.stride, attrib.start, attrib.instance);\n        }\n        if (this.indexBuffer) {\n            geometry.indexBuffer = geometry.buffers[this.buffers.indexOf(this.indexBuffer)];\n            geometry.indexBuffer.index = true;\n        }\n        return geometry;\n    };\n    /**\n     * merges an array of geometries into a new single one\n     * geometry attribute styles must match for this operation to work\n     *\n     * @param {PIXI.Geometry[]} geometries - array of geometries to merge\n     * @returns {PIXI.Geometry} shiny new geometry!\n     */\n    Geometry.merge = function (geometries) {\n        // todo add a geometry check!\n        // also a size check.. cant be too big!]\n        var geometryOut = new Geometry();\n        var arrays = [];\n        var sizes = [];\n        var offsets = [];\n        var geometry;\n        // pass one.. get sizes..\n        for (var i = 0; i < geometries.length; i++) {\n            geometry = geometries[i];\n            for (var j = 0; j < geometry.buffers.length; j++) {\n                sizes[j] = sizes[j] || 0;\n                sizes[j] += geometry.buffers[j].data.length;\n                offsets[j] = 0;\n            }\n        }\n        // build the correct size arrays..\n        for (var i = 0; i < geometry.buffers.length; i++) {\n            // TODO types!\n            arrays[i] = new map$1[getBufferType(geometry.buffers[i].data)](sizes[i]);\n            geometryOut.buffers[i] = new Buffer(arrays[i]);\n        }\n        // pass to set data..\n        for (var i = 0; i < geometries.length; i++) {\n            geometry = geometries[i];\n            for (var j = 0; j < geometry.buffers.length; j++) {\n                arrays[j].set(geometry.buffers[j].data, offsets[j]);\n                offsets[j] += geometry.buffers[j].data.length;\n            }\n        }\n        geometryOut.attributes = geometry.attributes;\n        if (geometry.indexBuffer) {\n            geometryOut.indexBuffer = geometryOut.buffers[geometry.buffers.indexOf(geometry.indexBuffer)];\n            geometryOut.indexBuffer.index = true;\n            var offset = 0;\n            var stride = 0;\n            var offset2 = 0;\n            var bufferIndexToCount = 0;\n            // get a buffer\n            for (var i = 0; i < geometry.buffers.length; i++) {\n                if (geometry.buffers[i] !== geometry.indexBuffer) {\n                    bufferIndexToCount = i;\n                    break;\n                }\n            }\n            // figure out the stride of one buffer..\n            for (var i in geometry.attributes) {\n                var attribute = geometry.attributes[i];\n                if ((attribute.buffer | 0) === bufferIndexToCount) {\n                    stride += ((attribute.size * byteSizeMap[attribute.type]) / 4);\n                }\n            }\n            // time to off set all indexes..\n            for (var i = 0; i < geometries.length; i++) {\n                var indexBufferData = geometries[i].indexBuffer.data;\n                for (var j = 0; j < indexBufferData.length; j++) {\n                    geometryOut.indexBuffer.data[j + offset2] += offset;\n                }\n                offset += geometry.buffers[bufferIndexToCount].data.length / (stride);\n                offset2 += indexBufferData.length;\n            }\n        }\n        return geometryOut;\n    };\n    return Geometry;\n}());\n\n/**\n * Helper class to create a quad\n *\n * @class\n * @memberof PIXI\n */\nvar Quad = /** @class */ (function (_super) {\n    __extends(Quad, _super);\n    function Quad() {\n        var _this = _super.call(this) || this;\n        _this.addAttribute('aVertexPosition', new Float32Array([\n            0, 0,\n            1, 0,\n            1, 1,\n            0, 1 ]))\n            .addIndex([0, 1, 3, 2]);\n        return _this;\n    }\n    return Quad;\n}(Geometry));\n\n/**\n * Helper class to create a quad with uvs like in v4\n *\n * @class\n * @memberof PIXI\n * @extends PIXI.Geometry\n */\nvar QuadUv = /** @class */ (function (_super) {\n    __extends(QuadUv, _super);\n    function QuadUv() {\n        var _this = _super.call(this) || this;\n        /**\n         * An array of vertices\n         *\n         * @member {Float32Array}\n         */\n        _this.vertices = new Float32Array([\n            -1, -1,\n            1, -1,\n            1, 1,\n            -1, 1 ]);\n        /**\n         * The Uvs of the quad\n         *\n         * @member {Float32Array}\n         */\n        _this.uvs = new Float32Array([\n            0, 0,\n            1, 0,\n            1, 1,\n            0, 1 ]);\n        _this.vertexBuffer = new Buffer(_this.vertices);\n        _this.uvBuffer = new Buffer(_this.uvs);\n        _this.addAttribute('aVertexPosition', _this.vertexBuffer)\n            .addAttribute('aTextureCoord', _this.uvBuffer)\n            .addIndex([0, 1, 2, 0, 2, 3]);\n        return _this;\n    }\n    /**\n     * Maps two Rectangle to the quad.\n     *\n     * @param {PIXI.Rectangle} targetTextureFrame - the first rectangle\n     * @param {PIXI.Rectangle} destinationFrame - the second rectangle\n     * @return {PIXI.Quad} Returns itself.\n     */\n    QuadUv.prototype.map = function (targetTextureFrame, destinationFrame) {\n        var x = 0; // destinationFrame.x / targetTextureFrame.width;\n        var y = 0; // destinationFrame.y / targetTextureFrame.height;\n        this.uvs[0] = x;\n        this.uvs[1] = y;\n        this.uvs[2] = x + (destinationFrame.width / targetTextureFrame.width);\n        this.uvs[3] = y;\n        this.uvs[4] = x + (destinationFrame.width / targetTextureFrame.width);\n        this.uvs[5] = y + (destinationFrame.height / targetTextureFrame.height);\n        this.uvs[6] = x;\n        this.uvs[7] = y + (destinationFrame.height / targetTextureFrame.height);\n        x = destinationFrame.x;\n        y = destinationFrame.y;\n        this.vertices[0] = x;\n        this.vertices[1] = y;\n        this.vertices[2] = x + destinationFrame.width;\n        this.vertices[3] = y;\n        this.vertices[4] = x + destinationFrame.width;\n        this.vertices[5] = y + destinationFrame.height;\n        this.vertices[6] = x;\n        this.vertices[7] = y + destinationFrame.height;\n        this.invalidate();\n        return this;\n    };\n    /**\n     * legacy upload method, just marks buffers dirty\n     * @returns {PIXI.QuadUv} Returns itself.\n     */\n    QuadUv.prototype.invalidate = function () {\n        this.vertexBuffer._updateID++;\n        this.uvBuffer._updateID++;\n        return this;\n    };\n    return QuadUv;\n}(Geometry));\n\nvar UID$2 = 0;\n/**\n * Uniform group holds uniform map and some ID's for work\n *\n * @class\n * @memberof PIXI\n */\nvar UniformGroup = /** @class */ (function () {\n    /**\n     * @param {object} [uniforms] - Custom uniforms to use to augment the built-in ones.\n     * @param {boolean} [_static] - Uniforms wont be changed after creation\n     */\n    function UniformGroup(uniforms, _static) {\n        /**\n         * uniform values\n         * @member {object}\n         * @readonly\n         */\n        this.uniforms = uniforms;\n        /**\n         * Its a group and not a single uniforms\n         * @member {boolean}\n         * @readonly\n         * @default true\n         */\n        this.group = true;\n        // lets generate this when the shader ?\n        this.syncUniforms = {};\n        /**\n         * dirty version\n         * @protected\n         * @member {number}\n         */\n        this.dirtyId = 0;\n        /**\n         * unique id\n         * @protected\n         * @member {number}\n         */\n        this.id = UID$2++;\n        /**\n         * Uniforms wont be changed after creation\n         * @member {boolean}\n         */\n        this.static = !!_static;\n    }\n    UniformGroup.prototype.update = function () {\n        this.dirtyId++;\n    };\n    UniformGroup.prototype.add = function (name, uniforms, _static) {\n        this.uniforms[name] = new UniformGroup(uniforms, _static);\n    };\n    UniformGroup.from = function (uniforms, _static) {\n        return new UniformGroup(uniforms, _static);\n    };\n    return UniformGroup;\n}());\n\n/**\n * System plugin to the renderer to manage filter states.\n *\n * @class\n * @private\n */\nvar FilterState = /** @class */ (function () {\n    function FilterState() {\n        this.renderTexture = null;\n        /**\n         * Target of the filters\n         * We store for case when custom filter wants to know the element it was applied on\n         * @member {PIXI.DisplayObject}\n         * @private\n         */\n        this.target = null;\n        /**\n         * Compatibility with PixiJS v4 filters\n         * @member {boolean}\n         * @default false\n         * @private\n         */\n        this.legacy = false;\n        /**\n         * Resolution of filters\n         * @member {number}\n         * @default 1\n         * @private\n         */\n        this.resolution = 1;\n        // next three fields are created only for root\n        // re-assigned for everything else\n        /**\n         * Source frame\n         * @member {PIXI.Rectangle}\n         * @private\n         */\n        this.sourceFrame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        /**\n         * Destination frame\n         * @member {PIXI.Rectangle}\n         * @private\n         */\n        this.destinationFrame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        /**\n         * Collection of filters\n         * @member {PIXI.Filter[]}\n         * @private\n         */\n        this.filters = [];\n    }\n    /**\n     * clears the state\n     * @private\n     */\n    FilterState.prototype.clear = function () {\n        this.target = null;\n        this.filters = null;\n        this.renderTexture = null;\n    };\n    return FilterState;\n}());\n\n/**\n * System plugin to the renderer to manage the filters.\n *\n * @class\n * @memberof PIXI.systems\n * @extends PIXI.System\n */\nvar FilterSystem = /** @class */ (function (_super) {\n    __extends(FilterSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function FilterSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * List of filters for the FilterSystem\n         * @member {Object[]}\n         * @readonly\n         */\n        _this.defaultFilterStack = [{}];\n        /**\n         * stores a bunch of PO2 textures used for filtering\n         * @member {Object}\n         */\n        _this.texturePool = new RenderTexturePool();\n        _this.texturePool.setScreenSize(renderer.view);\n        /**\n         * a pool for storing filter states, save us creating new ones each tick\n         * @member {Object[]}\n         */\n        _this.statePool = [];\n        /**\n         * A very simple geometry used when drawing a filter effect to the screen\n         * @member {PIXI.Quad}\n         */\n        _this.quad = new Quad();\n        /**\n         * Quad UVs\n         * @member {PIXI.QuadUv}\n         */\n        _this.quadUv = new QuadUv();\n        /**\n         * Temporary rect for maths\n         * @type {PIXI.Rectangle}\n         */\n        _this.tempRect = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        /**\n         * Active state\n         * @member {object}\n         */\n        _this.activeState = {};\n        /**\n         * This uniform group is attached to filter uniforms when used\n         * @member {PIXI.UniformGroup}\n         * @property {PIXI.Rectangle} outputFrame\n         * @property {Float32Array} inputSize\n         * @property {Float32Array} inputPixel\n         * @property {Float32Array} inputClamp\n         * @property {Number} resolution\n         * @property {Float32Array} filterArea\n         * @property {Fload32Array} filterClamp\n         */\n        _this.globalUniforms = new UniformGroup({\n            outputFrame: _this.tempRect,\n            inputSize: new Float32Array(4),\n            inputPixel: new Float32Array(4),\n            inputClamp: new Float32Array(4),\n            resolution: 1,\n            // legacy variables\n            filterArea: new Float32Array(4),\n            filterClamp: new Float32Array(4),\n        }, true);\n        /**\n         * Whether to clear output renderTexture in AUTO/BLIT mode. See {@link PIXI.CLEAR_MODES}\n         * @member {boolean}\n         */\n        _this.forceClear = false;\n        /**\n         * Old padding behavior is to use the max amount instead of sum padding.\n         * Use this flag if you need the old behavior.\n         * @member {boolean}\n         * @default false\n         */\n        _this.useMaxPadding = false;\n        return _this;\n    }\n    /**\n     * Adds a new filter to the System.\n     *\n     * @param {PIXI.DisplayObject} target - The target of the filter to render.\n     * @param {PIXI.Filter[]} filters - The filters to apply.\n     */\n    FilterSystem.prototype.push = function (target, filters) {\n        var renderer = this.renderer;\n        var filterStack = this.defaultFilterStack;\n        var state = this.statePool.pop() || new FilterState();\n        var resolution = filters[0].resolution;\n        var padding = filters[0].padding;\n        var autoFit = filters[0].autoFit;\n        var legacy = filters[0].legacy;\n        for (var i = 1; i < filters.length; i++) {\n            var filter = filters[i];\n            // lets use the lowest resolution..\n            resolution = Math.min(resolution, filter.resolution);\n            // figure out the padding required for filters\n            padding = this.useMaxPadding\n                // old behavior: use largest amount of padding!\n                ? Math.max(padding, filter.padding)\n                // new behavior: sum the padding\n                : padding + filter.padding;\n            // only auto fit if all filters are autofit\n            autoFit = autoFit && filter.autoFit;\n            legacy = legacy || filter.legacy;\n        }\n        if (filterStack.length === 1) {\n            this.defaultFilterStack[0].renderTexture = renderer.renderTexture.current;\n        }\n        filterStack.push(state);\n        state.resolution = resolution;\n        state.legacy = legacy;\n        state.target = target;\n        state.sourceFrame.copyFrom(target.filterArea || target.getBounds(true));\n        state.sourceFrame.pad(padding);\n        if (autoFit) {\n            state.sourceFrame.fit(this.renderer.renderTexture.sourceFrame);\n        }\n        // round to whole number based on resolution\n        state.sourceFrame.ceil(resolution);\n        state.renderTexture = this.getOptimalFilterTexture(state.sourceFrame.width, state.sourceFrame.height, resolution);\n        state.filters = filters;\n        state.destinationFrame.width = state.renderTexture.width;\n        state.destinationFrame.height = state.renderTexture.height;\n        var destinationFrame = this.tempRect;\n        destinationFrame.width = state.sourceFrame.width;\n        destinationFrame.height = state.sourceFrame.height;\n        state.renderTexture.filterFrame = state.sourceFrame;\n        renderer.renderTexture.bind(state.renderTexture, state.sourceFrame, destinationFrame);\n        renderer.renderTexture.clear();\n    };\n    /**\n     * Pops off the filter and applies it.\n     *\n     */\n    FilterSystem.prototype.pop = function () {\n        var filterStack = this.defaultFilterStack;\n        var state = filterStack.pop();\n        var filters = state.filters;\n        this.activeState = state;\n        var globalUniforms = this.globalUniforms.uniforms;\n        globalUniforms.outputFrame = state.sourceFrame;\n        globalUniforms.resolution = state.resolution;\n        var inputSize = globalUniforms.inputSize;\n        var inputPixel = globalUniforms.inputPixel;\n        var inputClamp = globalUniforms.inputClamp;\n        inputSize[0] = state.destinationFrame.width;\n        inputSize[1] = state.destinationFrame.height;\n        inputSize[2] = 1.0 / inputSize[0];\n        inputSize[3] = 1.0 / inputSize[1];\n        inputPixel[0] = inputSize[0] * state.resolution;\n        inputPixel[1] = inputSize[1] * state.resolution;\n        inputPixel[2] = 1.0 / inputPixel[0];\n        inputPixel[3] = 1.0 / inputPixel[1];\n        inputClamp[0] = 0.5 * inputPixel[2];\n        inputClamp[1] = 0.5 * inputPixel[3];\n        inputClamp[2] = (state.sourceFrame.width * inputSize[2]) - (0.5 * inputPixel[2]);\n        inputClamp[3] = (state.sourceFrame.height * inputSize[3]) - (0.5 * inputPixel[3]);\n        // only update the rect if its legacy..\n        if (state.legacy) {\n            var filterArea = globalUniforms.filterArea;\n            filterArea[0] = state.destinationFrame.width;\n            filterArea[1] = state.destinationFrame.height;\n            filterArea[2] = state.sourceFrame.x;\n            filterArea[3] = state.sourceFrame.y;\n            globalUniforms.filterClamp = globalUniforms.inputClamp;\n        }\n        this.globalUniforms.update();\n        var lastState = filterStack[filterStack.length - 1];\n        if (state.renderTexture.framebuffer.multisample > 1) {\n            this.renderer.framebuffer.blit();\n        }\n        if (filters.length === 1) {\n            filters[0].apply(this, state.renderTexture, lastState.renderTexture, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.BLEND, state);\n            this.returnFilterTexture(state.renderTexture);\n        }\n        else {\n            var flip = state.renderTexture;\n            var flop = this.getOptimalFilterTexture(flip.width, flip.height, state.resolution);\n            flop.filterFrame = flip.filterFrame;\n            var i = 0;\n            for (i = 0; i < filters.length - 1; ++i) {\n                filters[i].apply(this, flip, flop, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.CLEAR, state);\n                var t = flip;\n                flip = flop;\n                flop = t;\n            }\n            filters[i].apply(this, flip, lastState.renderTexture, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.BLEND, state);\n            this.returnFilterTexture(flip);\n            this.returnFilterTexture(flop);\n        }\n        state.clear();\n        this.statePool.push(state);\n    };\n    /**\n     * Binds a renderTexture with corresponding `filterFrame`, clears it if mode corresponds.\n     * @param {PIXI.RenderTexture} filterTexture - renderTexture to bind, should belong to filter pool or filter stack\n     * @param {PIXI.CLEAR_MODES} [clearMode] - clearMode, by default its CLEAR/YES. See {@link PIXI.CLEAR_MODES}\n     */\n    FilterSystem.prototype.bindAndClear = function (filterTexture, clearMode) {\n        if (clearMode === void 0) { clearMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.CLEAR; }\n        if (filterTexture && filterTexture.filterFrame) {\n            var destinationFrame = this.tempRect;\n            destinationFrame.width = filterTexture.filterFrame.width;\n            destinationFrame.height = filterTexture.filterFrame.height;\n            this.renderer.renderTexture.bind(filterTexture, filterTexture.filterFrame, destinationFrame);\n        }\n        else {\n            this.renderer.renderTexture.bind(filterTexture);\n        }\n        // TODO: remove in next major version\n        if (typeof clearMode === 'boolean') {\n            clearMode = clearMode ? _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.CLEAR : _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.BLEND;\n            // get deprecation function from utils\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.deprecation)('5.2.1', 'Use CLEAR_MODES when using clear applyFilter option');\n        }\n        if (clearMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.CLEAR\n            || (clearMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.CLEAR_MODES.BLIT && this.forceClear)) {\n            this.renderer.renderTexture.clear();\n        }\n    };\n    /**\n     * Draws a filter.\n     *\n     * @param {PIXI.Filter} filter - The filter to draw.\n     * @param {PIXI.RenderTexture} input - The input render target.\n     * @param {PIXI.RenderTexture} output - The target to output to.\n     * @param {PIXI.CLEAR_MODES} [clearMode] - Should the output be cleared before rendering to it\n     */\n    FilterSystem.prototype.applyFilter = function (filter, input, output, clearMode) {\n        var renderer = this.renderer;\n        this.bindAndClear(output, clearMode);\n        // set the uniforms..\n        filter.uniforms.uSampler = input;\n        filter.uniforms.filterGlobals = this.globalUniforms;\n        // TODO make it so that the order of this does not matter..\n        // because it does at the moment cos of global uniforms.\n        // they need to get resynced\n        renderer.state.set(filter.state);\n        renderer.shader.bind(filter);\n        if (filter.legacy) {\n            this.quadUv.map(input._frame, input.filterFrame);\n            renderer.geometry.bind(this.quadUv);\n            renderer.geometry.draw(_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.DRAW_MODES.TRIANGLES);\n        }\n        else {\n            renderer.geometry.bind(this.quad);\n            renderer.geometry.draw(_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.DRAW_MODES.TRIANGLE_STRIP);\n        }\n    };\n    /**\n     * Multiply _input normalized coordinates_ to this matrix to get _sprite texture normalized coordinates_.\n     *\n     * Use `outputMatrix * vTextureCoord` in the shader.\n     *\n     * @param {PIXI.Matrix} outputMatrix - The matrix to output to.\n     * @param {PIXI.Sprite} sprite - The sprite to map to.\n     * @return {PIXI.Matrix} The mapped matrix.\n     */\n    FilterSystem.prototype.calculateSpriteMatrix = function (outputMatrix, sprite) {\n        var _a = this.activeState, sourceFrame = _a.sourceFrame, destinationFrame = _a.destinationFrame;\n        var orig = sprite._texture.orig;\n        var mappedMatrix = outputMatrix.set(destinationFrame.width, 0, 0, destinationFrame.height, sourceFrame.x, sourceFrame.y);\n        var worldTransform = sprite.worldTransform.copyTo(_pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix.TEMP_MATRIX);\n        worldTransform.invert();\n        mappedMatrix.prepend(worldTransform);\n        mappedMatrix.scale(1.0 / orig.width, 1.0 / orig.height);\n        mappedMatrix.translate(sprite.anchor.x, sprite.anchor.y);\n        return mappedMatrix;\n    };\n    /**\n     * Destroys this Filter System.\n     */\n    FilterSystem.prototype.destroy = function () {\n        // Those textures has to be destroyed by RenderTextureSystem or FramebufferSystem\n        this.texturePool.clear(false);\n    };\n    /**\n     * Gets a Power-of-Two render texture or fullScreen texture\n     *\n     * @protected\n     * @param {number} minWidth - The minimum width of the render texture in real pixels.\n     * @param {number} minHeight - The minimum height of the render texture in real pixels.\n     * @param {number} [resolution=1] - The resolution of the render texture.\n     * @return {PIXI.RenderTexture} The new render texture.\n     */\n    FilterSystem.prototype.getOptimalFilterTexture = function (minWidth, minHeight, resolution) {\n        if (resolution === void 0) { resolution = 1; }\n        return this.texturePool.getOptimalTexture(minWidth, minHeight, resolution);\n    };\n    /**\n     * Gets extra render texture to use inside current filter\n     * To be compliant with older filters, you can use params in any order\n     *\n     * @param {PIXI.RenderTexture} [input] - renderTexture from which size and resolution will be copied\n     * @param {number} [resolution] - override resolution of the renderTexture\n     * @returns {PIXI.RenderTexture}\n     */\n    FilterSystem.prototype.getFilterTexture = function (input, resolution) {\n        if (typeof input === 'number') {\n            var swap = input;\n            input = resolution;\n            resolution = swap;\n        }\n        input = input || this.activeState.renderTexture;\n        var filterTexture = this.texturePool.getOptimalTexture(input.width, input.height, resolution || input.resolution);\n        filterTexture.filterFrame = input.filterFrame;\n        return filterTexture;\n    };\n    /**\n     * Frees a render texture back into the pool.\n     *\n     * @param {PIXI.RenderTexture} renderTexture - The renderTarget to free\n     */\n    FilterSystem.prototype.returnFilterTexture = function (renderTexture) {\n        this.texturePool.returnTexture(renderTexture);\n    };\n    /**\n     * Empties the texture pool.\n     */\n    FilterSystem.prototype.emptyPool = function () {\n        this.texturePool.clear(true);\n    };\n    /**\n     * calls `texturePool.resize()`, affects fullScreen renderTextures\n     */\n    FilterSystem.prototype.resize = function () {\n        this.texturePool.setScreenSize(this.renderer.view);\n    };\n    return FilterSystem;\n}(System));\n\n/**\n * Base for a common object renderer that can be used as a\n * system renderer plugin.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI\n */\nvar ObjectRenderer = /** @class */ (function () {\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this manager works for.\n     */\n    function ObjectRenderer(renderer) {\n        /**\n         * The renderer this manager works for.\n         *\n         * @member {PIXI.Renderer}\n         */\n        this.renderer = renderer;\n    }\n    /**\n     * Stub method that should be used to empty the current\n     * batch by rendering objects now.\n     */\n    ObjectRenderer.prototype.flush = function () {\n        // flush!\n    };\n    /**\n     * Generic destruction method that frees all resources. This\n     * should be called by subclasses.\n     */\n    ObjectRenderer.prototype.destroy = function () {\n        this.renderer = null;\n    };\n    /**\n     * Stub method that initializes any state required before\n     * rendering starts. It is different from the `prerender`\n     * signal, which occurs every frame, in that it is called\n     * whenever an object requests _this_ renderer specifically.\n     */\n    ObjectRenderer.prototype.start = function () {\n        // set the shader..\n    };\n    /**\n     * Stops the renderer. It should free up any state and\n     * become dormant.\n     */\n    ObjectRenderer.prototype.stop = function () {\n        this.flush();\n    };\n    /**\n     * Keeps the object to render. It doesn't have to be\n     * rendered immediately.\n     *\n     * @param {PIXI.DisplayObject} object - The object to render.\n     */\n    ObjectRenderer.prototype.render = function (_object) {\n        // render the object\n    };\n    return ObjectRenderer;\n}());\n\n/**\n * System plugin to the renderer to manage batching.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar BatchSystem = /** @class */ (function (_super) {\n    __extends(BatchSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function BatchSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * An empty renderer.\n         *\n         * @member {PIXI.ObjectRenderer}\n         */\n        _this.emptyRenderer = new ObjectRenderer(renderer);\n        /**\n         * The currently active ObjectRenderer.\n         *\n         * @member {PIXI.ObjectRenderer}\n         */\n        _this.currentRenderer = _this.emptyRenderer;\n        return _this;\n    }\n    /**\n     * Changes the current renderer to the one given in parameter\n     *\n     * @param {PIXI.ObjectRenderer} objectRenderer - The object renderer to use.\n     */\n    BatchSystem.prototype.setObjectRenderer = function (objectRenderer) {\n        if (this.currentRenderer === objectRenderer) {\n            return;\n        }\n        this.currentRenderer.stop();\n        this.currentRenderer = objectRenderer;\n        this.currentRenderer.start();\n    };\n    /**\n     * This should be called if you wish to do some custom rendering\n     * It will basically render anything that may be batched up such as sprites\n     */\n    BatchSystem.prototype.flush = function () {\n        this.setObjectRenderer(this.emptyRenderer);\n    };\n    /**\n     * Reset the system to an empty renderer\n     */\n    BatchSystem.prototype.reset = function () {\n        this.setObjectRenderer(this.emptyRenderer);\n    };\n    /**\n     * Handy function for batch renderers: copies bound textures in first maxTextures locations to array\n     * sets actual _batchLocation for them\n     *\n     * @param {PIXI.BaseTexture[]} - arr copy destination\n     * @param {number} maxTextures - number of copied elements\n     */\n    BatchSystem.prototype.copyBoundTextures = function (arr, maxTextures) {\n        var boundTextures = this.renderer.texture.boundTextures;\n        for (var i = maxTextures - 1; i >= 0; --i) {\n            arr[i] = boundTextures[i] || null;\n            if (arr[i]) {\n                arr[i]._batchLocation = i;\n            }\n        }\n    };\n    /**\n     * Assigns batch locations to textures in array based on boundTextures state.\n     * All textures in texArray should have `_batchEnabled = _batchId`,\n     * and their count should be less than `maxTextures`.\n     *\n     * @param {PIXI.BatchTextureArray} texArray - textures to bound\n     * @param {PIXI.BaseTexture[]} boundTextures - current state of bound textures\n     * @param {number} batchId - marker for _batchEnabled param of textures in texArray\n     * @param {number} maxTextures - number of texture locations to manipulate\n     */\n    BatchSystem.prototype.boundArray = function (texArray, boundTextures, batchId, maxTextures) {\n        var elements = texArray.elements, ids = texArray.ids, count = texArray.count;\n        var j = 0;\n        for (var i = 0; i < count; i++) {\n            var tex = elements[i];\n            var loc = tex._batchLocation;\n            if (loc >= 0 && loc < maxTextures\n                && boundTextures[loc] === tex) {\n                ids[i] = loc;\n                continue;\n            }\n            while (j < maxTextures) {\n                var bound = boundTextures[j];\n                if (bound && bound._batchEnabled === batchId\n                    && bound._batchLocation === j) {\n                    j++;\n                    continue;\n                }\n                ids[i] = j;\n                tex._batchLocation = j;\n                boundTextures[j] = tex;\n                break;\n            }\n        }\n    };\n    return BatchSystem;\n}(System));\n\nvar CONTEXT_UID_COUNTER = 0;\n/**\n * System plugin to the renderer to manage the context.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar ContextSystem = /** @class */ (function (_super) {\n    __extends(ContextSystem, _super);\n    /* eslint-enable camelcase */\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function ContextSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * Either 1 or 2 to reflect the WebGL version being used\n         * @member {number}\n         * @readonly\n         */\n        _this.webGLVersion = 1;\n        /**\n         * Extensions being used\n         * @member {object}\n         * @readonly\n         * @property {WEBGL_draw_buffers} drawBuffers - WebGL v1 extension\n         * @property {WEBGL_depth_texture} depthTexture - WebGL v1 extension\n         * @property {OES_texture_float} floatTexture - WebGL v1 extension\n         * @property {WEBGL_lose_context} loseContext - WebGL v1 extension\n         * @property {OES_vertex_array_object} vertexArrayObject - WebGL v1 extension\n         * @property {EXT_texture_filter_anisotropic} anisotropicFiltering - WebGL v1 and v2 extension\n         */\n        _this.extensions = {};\n        /**\n         * Features supported by current context\n         * @member {object}\n         * @private\n         * @readonly\n         * @property {boolean} uint32Indices - Supports of 32-bit indices buffer\n         */\n        _this.supports = {\n            uint32Indices: false,\n        };\n        // Bind functions\n        _this.handleContextLost = _this.handleContextLost.bind(_this);\n        _this.handleContextRestored = _this.handleContextRestored.bind(_this);\n        renderer.view.addEventListener('webglcontextlost', _this.handleContextLost, false);\n        renderer.view.addEventListener('webglcontextrestored', _this.handleContextRestored, false);\n        return _this;\n    }\n    Object.defineProperty(ContextSystem.prototype, \"isLost\", {\n        /**\n         * `true` if the context is lost\n         * @member {boolean}\n         * @readonly\n         */\n        get: function () {\n            return (!this.gl || this.gl.isContextLost());\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Handle the context change event\n     * @param {WebGLRenderingContext} gl - new webgl context\n     */\n    ContextSystem.prototype.contextChange = function (gl) {\n        this.gl = gl;\n        this.renderer.gl = gl;\n        this.renderer.CONTEXT_UID = CONTEXT_UID_COUNTER++;\n        // restore a context if it was previously lost\n        if (gl.isContextLost() && gl.getExtension('WEBGL_lose_context')) {\n            gl.getExtension('WEBGL_lose_context').restoreContext();\n        }\n    };\n    /**\n     * Initialize the context\n     *\n     * @protected\n     * @param {WebGLRenderingContext} gl - WebGL context\n     */\n    ContextSystem.prototype.initFromContext = function (gl) {\n        this.gl = gl;\n        this.validateContext(gl);\n        this.renderer.gl = gl;\n        this.renderer.CONTEXT_UID = CONTEXT_UID_COUNTER++;\n        this.renderer.runners.contextChange.emit(gl);\n    };\n    /**\n     * Initialize from context options\n     *\n     * @protected\n     * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/getContext\n     * @param {object} options - context attributes\n     */\n    ContextSystem.prototype.initFromOptions = function (options) {\n        var gl = this.createContext(this.renderer.view, options);\n        this.initFromContext(gl);\n    };\n    /**\n     * Helper class to create a WebGL Context\n     *\n     * @param canvas {HTMLCanvasElement} the canvas element that we will get the context from\n     * @param options {object} An options object that gets passed in to the canvas element containing the context attributes\n     * @see https://developer.mozilla.org/en/docs/Web/API/HTMLCanvasElement/getContext\n     * @return {WebGLRenderingContext} the WebGL context\n     */\n    ContextSystem.prototype.createContext = function (canvas, options) {\n        var gl;\n        if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV >= _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL2) {\n            gl = canvas.getContext('webgl2', options);\n        }\n        if (gl) {\n            this.webGLVersion = 2;\n        }\n        else {\n            this.webGLVersion = 1;\n            gl = canvas.getContext('webgl', options)\n                || canvas.getContext('experimental-webgl', options);\n            if (!gl) {\n                // fail, not able to get a context\n                throw new Error('This browser does not support WebGL. Try using the canvas renderer');\n            }\n        }\n        this.gl = gl;\n        this.getExtensions();\n        return this.gl;\n    };\n    /**\n     * Auto-populate the extensions\n     *\n     * @protected\n     */\n    ContextSystem.prototype.getExtensions = function () {\n        // time to set up default extensions that Pixi uses.\n        var gl = this.gl;\n        if (this.webGLVersion === 1) {\n            Object.assign(this.extensions, {\n                drawBuffers: gl.getExtension('WEBGL_draw_buffers'),\n                depthTexture: gl.getExtension('WEBGL_depth_texture'),\n                loseContext: gl.getExtension('WEBGL_lose_context'),\n                vertexArrayObject: gl.getExtension('OES_vertex_array_object')\n                    || gl.getExtension('MOZ_OES_vertex_array_object')\n                    || gl.getExtension('WEBKIT_OES_vertex_array_object'),\n                anisotropicFiltering: gl.getExtension('EXT_texture_filter_anisotropic'),\n                uint32ElementIndex: gl.getExtension('OES_element_index_uint'),\n                // Floats and half-floats\n                floatTexture: gl.getExtension('OES_texture_float'),\n                floatTextureLinear: gl.getExtension('OES_texture_float_linear'),\n                textureHalfFloat: gl.getExtension('OES_texture_half_float'),\n                textureHalfFloatLinear: gl.getExtension('OES_texture_half_float_linear'),\n            });\n        }\n        else if (this.webGLVersion === 2) {\n            Object.assign(this.extensions, {\n                anisotropicFiltering: gl.getExtension('EXT_texture_filter_anisotropic'),\n                // Floats and half-floats\n                colorBufferFloat: gl.getExtension('EXT_color_buffer_float'),\n                floatTextureLinear: gl.getExtension('OES_texture_float_linear'),\n            });\n        }\n    };\n    /**\n     * Handles a lost webgl context\n     *\n     * @protected\n     * @param {WebGLContextEvent} event - The context lost event.\n     */\n    ContextSystem.prototype.handleContextLost = function (event) {\n        event.preventDefault();\n    };\n    /**\n     * Handles a restored webgl context\n     *\n     * @protected\n     */\n    ContextSystem.prototype.handleContextRestored = function () {\n        this.renderer.runners.contextChange.emit(this.gl);\n    };\n    ContextSystem.prototype.destroy = function () {\n        var view = this.renderer.view;\n        // remove listeners\n        view.removeEventListener('webglcontextlost', this.handleContextLost);\n        view.removeEventListener('webglcontextrestored', this.handleContextRestored);\n        this.gl.useProgram(null);\n        if (this.extensions.loseContext) {\n            this.extensions.loseContext.loseContext();\n        }\n    };\n    /**\n     * Handle the post-render runner event\n     *\n     * @protected\n     */\n    ContextSystem.prototype.postrender = function () {\n        if (this.renderer.renderingToScreen) {\n            this.gl.flush();\n        }\n    };\n    /**\n     * Validate context\n     *\n     * @protected\n     * @param {WebGLRenderingContext} gl - Render context\n     */\n    ContextSystem.prototype.validateContext = function (gl) {\n        var attributes = gl.getContextAttributes();\n        var isWebGl2 = 'WebGL2RenderingContext' in window && gl instanceof window.WebGL2RenderingContext;\n        if (isWebGl2) {\n            this.webGLVersion = 2;\n        }\n        // this is going to be fairly simple for now.. but at least we have room to grow!\n        if (!attributes.stencil) {\n            /* eslint-disable max-len, no-console */\n            console.warn('Provided WebGL context does not have a stencil buffer, masks may not render correctly');\n            /* eslint-enable max-len, no-console */\n        }\n        var hasuint32 = isWebGl2 || !!gl.getExtension('OES_element_index_uint');\n        this.supports.uint32Indices = hasuint32;\n        if (!hasuint32) {\n            /* eslint-disable max-len, no-console */\n            console.warn('Provided WebGL context does not support 32 index buffer, complex graphics may not render correctly');\n            /* eslint-enable max-len, no-console */\n        }\n    };\n    return ContextSystem;\n}(System));\n\n/**\n * Internal framebuffer for WebGL context\n * @class\n * @memberof PIXI\n */\nvar GLFramebuffer = /** @class */ (function () {\n    function GLFramebuffer(framebuffer) {\n        /**\n         * The WebGL framebuffer\n         * @member {WebGLFramebuffer}\n         */\n        this.framebuffer = framebuffer;\n        /**\n         * stencil+depth , usually costs 32bits per pixel\n         * @member {WebGLRenderbuffer}\n         */\n        this.stencil = null;\n        /**\n         * latest known version of framebuffer\n         * @member {number}\n         * @protected\n         */\n        this.dirtyId = 0;\n        /**\n         * latest known version of framebuffer format\n         * @member {number}\n         * @protected\n         */\n        this.dirtyFormat = 0;\n        /**\n         * latest known version of framebuffer size\n         * @member {number}\n         * @protected\n         */\n        this.dirtySize = 0;\n        /**\n         * Detected AA samples number\n         * @member {PIXI.MSAA_QUALITY}\n         */\n        this.multisample = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MSAA_QUALITY.NONE;\n        /**\n         * In case MSAA, we use this Renderbuffer instead of colorTextures[0] when we write info\n         * @member {WebGLRenderbuffer}\n         */\n        this.msaaBuffer = null;\n        /**\n         * In case we use MSAA, this is actual framebuffer that has colorTextures[0]\n         * The contents of that framebuffer are read when we use that renderTexture in sprites\n         * @member {PIXI.Framebuffer}\n         */\n        this.blitFramebuffer = null;\n    }\n    return GLFramebuffer;\n}());\n\nvar tempRectangle = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n/**\n * System plugin to the renderer to manage framebuffers.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar FramebufferSystem = /** @class */ (function (_super) {\n    __extends(FramebufferSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function FramebufferSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * A list of managed framebuffers\n         * @member {PIXI.Framebuffer[]}\n         * @readonly\n         */\n        _this.managedFramebuffers = [];\n        /**\n         * Framebuffer value that shows that we don't know what is bound\n         * @member {Framebuffer}\n         * @readonly\n         */\n        _this.unknownFramebuffer = new Framebuffer(10, 10);\n        _this.msaaSamples = null;\n        return _this;\n    }\n    /**\n     * Sets up the renderer context and necessary buffers.\n     */\n    FramebufferSystem.prototype.contextChange = function () {\n        var gl = this.gl = this.renderer.gl;\n        this.CONTEXT_UID = this.renderer.CONTEXT_UID;\n        this.current = this.unknownFramebuffer;\n        this.viewport = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        this.hasMRT = true;\n        this.writeDepthTexture = true;\n        this.disposeAll(true);\n        // webgl2\n        if (this.renderer.context.webGLVersion === 1) {\n            // webgl 1!\n            var nativeDrawBuffersExtension_1 = this.renderer.context.extensions.drawBuffers;\n            var nativeDepthTextureExtension = this.renderer.context.extensions.depthTexture;\n            if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL_LEGACY) {\n                nativeDrawBuffersExtension_1 = null;\n                nativeDepthTextureExtension = null;\n            }\n            if (nativeDrawBuffersExtension_1) {\n                gl.drawBuffers = function (activeTextures) {\n                    return nativeDrawBuffersExtension_1.drawBuffersWEBGL(activeTextures);\n                };\n            }\n            else {\n                this.hasMRT = false;\n                gl.drawBuffers = function () {\n                    // empty\n                };\n            }\n            if (!nativeDepthTextureExtension) {\n                this.writeDepthTexture = false;\n            }\n        }\n        else {\n            // WebGL2\n            // cache possible MSAA samples\n            this.msaaSamples = gl.getInternalformatParameter(gl.RENDERBUFFER, gl.RGBA8, gl.SAMPLES);\n        }\n    };\n    /**\n     * Bind a framebuffer\n     *\n     * @param {PIXI.Framebuffer} framebuffer\n     * @param {PIXI.Rectangle} [frame] frame, default is framebuffer size\n     */\n    FramebufferSystem.prototype.bind = function (framebuffer, frame) {\n        var gl = this.gl;\n        if (framebuffer) {\n            // TODO caching layer!\n            var fbo = framebuffer.glFramebuffers[this.CONTEXT_UID] || this.initFramebuffer(framebuffer);\n            if (this.current !== framebuffer) {\n                this.current = framebuffer;\n                gl.bindFramebuffer(gl.FRAMEBUFFER, fbo.framebuffer);\n            }\n            // make sure all textures are unbound..\n            // now check for updates...\n            if (fbo.dirtyId !== framebuffer.dirtyId) {\n                fbo.dirtyId = framebuffer.dirtyId;\n                if (fbo.dirtyFormat !== framebuffer.dirtyFormat) {\n                    fbo.dirtyFormat = framebuffer.dirtyFormat;\n                    this.updateFramebuffer(framebuffer);\n                }\n                else if (fbo.dirtySize !== framebuffer.dirtySize) {\n                    fbo.dirtySize = framebuffer.dirtySize;\n                    this.resizeFramebuffer(framebuffer);\n                }\n            }\n            for (var i = 0; i < framebuffer.colorTextures.length; i++) {\n                var tex = framebuffer.colorTextures[i];\n                this.renderer.texture.unbind(tex.parentTextureArray || tex);\n            }\n            if (framebuffer.depthTexture) {\n                this.renderer.texture.unbind(framebuffer.depthTexture);\n            }\n            if (frame) {\n                this.setViewport(frame.x, frame.y, frame.width, frame.height);\n            }\n            else {\n                this.setViewport(0, 0, framebuffer.width, framebuffer.height);\n            }\n        }\n        else {\n            if (this.current) {\n                this.current = null;\n                gl.bindFramebuffer(gl.FRAMEBUFFER, null);\n            }\n            if (frame) {\n                this.setViewport(frame.x, frame.y, frame.width, frame.height);\n            }\n            else {\n                this.setViewport(0, 0, this.renderer.width, this.renderer.height);\n            }\n        }\n    };\n    /**\n     * Set the WebGLRenderingContext's viewport.\n     *\n     * @param {Number} x - X position of viewport\n     * @param {Number} y - Y position of viewport\n     * @param {Number} width - Width of viewport\n     * @param {Number} height - Height of viewport\n     */\n    FramebufferSystem.prototype.setViewport = function (x, y, width, height) {\n        var v = this.viewport;\n        if (v.width !== width || v.height !== height || v.x !== x || v.y !== y) {\n            v.x = x;\n            v.y = y;\n            v.width = width;\n            v.height = height;\n            this.gl.viewport(x, y, width, height);\n        }\n    };\n    Object.defineProperty(FramebufferSystem.prototype, \"size\", {\n        /**\n         * Get the size of the current width and height. Returns object with `width` and `height` values.\n         *\n         * @member {object}\n         * @readonly\n         */\n        get: function () {\n            if (this.current) {\n                // TODO store temp\n                return { x: 0, y: 0, width: this.current.width, height: this.current.height };\n            }\n            return { x: 0, y: 0, width: this.renderer.width, height: this.renderer.height };\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Clear the color of the context\n     *\n     * @param {Number} r - Red value from 0 to 1\n     * @param {Number} g - Green value from 0 to 1\n     * @param {Number} b - Blue value from 0 to 1\n     * @param {Number} a - Alpha value from 0 to 1\n     * @param {PIXI.BUFFER_BITS} [mask=BUFFER_BITS.COLOR | BUFFER_BITS.DEPTH] - Bitwise OR of masks\n     *  that indicate the buffers to be cleared, by default COLOR and DEPTH buffers.\n     */\n    FramebufferSystem.prototype.clear = function (r, g, b, a, mask) {\n        if (mask === void 0) { mask = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BUFFER_BITS.COLOR | _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BUFFER_BITS.DEPTH; }\n        var gl = this.gl;\n        // TODO clear color can be set only one right?\n        gl.clearColor(r, g, b, a);\n        gl.clear(mask);\n    };\n    /**\n     * Initialize framebuffer for this context\n     *\n     * @protected\n     * @param {PIXI.Framebuffer} framebuffer\n     * @returns {PIXI.GLFramebuffer} created GLFramebuffer\n     */\n    FramebufferSystem.prototype.initFramebuffer = function (framebuffer) {\n        var gl = this.gl;\n        var fbo = new GLFramebuffer(gl.createFramebuffer());\n        fbo.multisample = this.detectSamples(framebuffer.multisample);\n        framebuffer.glFramebuffers[this.CONTEXT_UID] = fbo;\n        this.managedFramebuffers.push(framebuffer);\n        framebuffer.disposeRunner.add(this);\n        return fbo;\n    };\n    /**\n     * Resize the framebuffer\n     *\n     * @protected\n     * @param {PIXI.Framebuffer} framebuffer\n     */\n    FramebufferSystem.prototype.resizeFramebuffer = function (framebuffer) {\n        var gl = this.gl;\n        var fbo = framebuffer.glFramebuffers[this.CONTEXT_UID];\n        if (fbo.stencil) {\n            gl.bindRenderbuffer(gl.RENDERBUFFER, fbo.stencil);\n            gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, framebuffer.width, framebuffer.height);\n        }\n        var colorTextures = framebuffer.colorTextures;\n        for (var i = 0; i < colorTextures.length; i++) {\n            this.renderer.texture.bind(colorTextures[i], 0);\n        }\n        if (framebuffer.depthTexture) {\n            this.renderer.texture.bind(framebuffer.depthTexture, 0);\n        }\n    };\n    /**\n     * Update the framebuffer\n     *\n     * @protected\n     * @param {PIXI.Framebuffer} framebuffer\n     */\n    FramebufferSystem.prototype.updateFramebuffer = function (framebuffer) {\n        var gl = this.gl;\n        var fbo = framebuffer.glFramebuffers[this.CONTEXT_UID];\n        // bind the color texture\n        var colorTextures = framebuffer.colorTextures;\n        var count = colorTextures.length;\n        if (!gl.drawBuffers) {\n            count = Math.min(count, 1);\n        }\n        if (fbo.multisample > 1) {\n            fbo.msaaBuffer = gl.createRenderbuffer();\n            gl.bindRenderbuffer(gl.RENDERBUFFER, fbo.msaaBuffer);\n            gl.renderbufferStorageMultisample(gl.RENDERBUFFER, fbo.multisample, gl.RGBA8, framebuffer.width, framebuffer.height);\n            gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, fbo.msaaBuffer);\n        }\n        var activeTextures = [];\n        for (var i = 0; i < count; i++) {\n            if (i === 0 && fbo.multisample > 1) {\n                continue;\n            }\n            var texture = framebuffer.colorTextures[i];\n            var parentTexture = texture.parentTextureArray || texture;\n            this.renderer.texture.bind(parentTexture, 0);\n            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0 + i, texture.target, parentTexture._glTextures[this.CONTEXT_UID].texture, 0);\n            activeTextures.push(gl.COLOR_ATTACHMENT0 + i);\n        }\n        if (activeTextures.length > 1) {\n            gl.drawBuffers(activeTextures);\n        }\n        if (framebuffer.depthTexture) {\n            var writeDepthTexture = this.writeDepthTexture;\n            if (writeDepthTexture) {\n                var depthTexture = framebuffer.depthTexture;\n                this.renderer.texture.bind(depthTexture, 0);\n                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, depthTexture._glTextures[this.CONTEXT_UID].texture, 0);\n            }\n        }\n        if (!fbo.stencil && (framebuffer.stencil || framebuffer.depth)) {\n            fbo.stencil = gl.createRenderbuffer();\n            gl.bindRenderbuffer(gl.RENDERBUFFER, fbo.stencil);\n            gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, framebuffer.width, framebuffer.height);\n            // TODO.. this is depth AND stencil?\n            if (!framebuffer.depthTexture) { // you can't have both, so one should take priority if enabled\n                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, fbo.stencil);\n            }\n        }\n    };\n    /**\n     * Detects number of samples that is not more than a param but as close to it as possible\n     *\n     * @param {PIXI.MSAA_QUALITY} samples - number of samples\n     * @returns {PIXI.MSAA_QUALITY} - recommended number of samples\n     */\n    FramebufferSystem.prototype.detectSamples = function (samples) {\n        var msaaSamples = this.msaaSamples;\n        var res = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MSAA_QUALITY.NONE;\n        if (samples <= 1 || msaaSamples === null) {\n            return res;\n        }\n        for (var i = 0; i < msaaSamples.length; i++) {\n            if (msaaSamples[i] <= samples) {\n                res = msaaSamples[i];\n                break;\n            }\n        }\n        if (res === 1) {\n            res = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MSAA_QUALITY.NONE;\n        }\n        return res;\n    };\n    /**\n     * Only works with WebGL2\n     *\n     * blits framebuffer to another of the same or bigger size\n     * after that target framebuffer is bound\n     *\n     * Fails with WebGL warning if blits multisample framebuffer to different size\n     *\n     * @param {PIXI.Framebuffer} [framebuffer] - by default it blits \"into itself\", from renderBuffer to texture.\n     * @param {PIXI.Rectangle} [sourcePixels] - source rectangle in pixels\n     * @param {PIXI.Rectangle} [destPixels] - dest rectangle in pixels, assumed to be the same as sourcePixels\n     */\n    FramebufferSystem.prototype.blit = function (framebuffer, sourcePixels, destPixels) {\n        var _a = this, current = _a.current, renderer = _a.renderer, gl = _a.gl, CONTEXT_UID = _a.CONTEXT_UID;\n        if (renderer.context.webGLVersion !== 2) {\n            return;\n        }\n        if (!current) {\n            return;\n        }\n        var fbo = current.glFramebuffers[CONTEXT_UID];\n        if (!fbo) {\n            return;\n        }\n        if (!framebuffer) {\n            if (fbo.multisample <= 1) {\n                return;\n            }\n            if (!fbo.blitFramebuffer) {\n                fbo.blitFramebuffer = new Framebuffer(current.width, current.height);\n                fbo.blitFramebuffer.addColorTexture(0, current.colorTextures[0]);\n            }\n            framebuffer = fbo.blitFramebuffer;\n            framebuffer.width = current.width;\n            framebuffer.height = current.height;\n        }\n        if (!sourcePixels) {\n            sourcePixels = tempRectangle;\n            sourcePixels.width = current.width;\n            sourcePixels.height = current.height;\n        }\n        if (!destPixels) {\n            destPixels = sourcePixels;\n        }\n        var sameSize = sourcePixels.width === destPixels.width && sourcePixels.height === destPixels.height;\n        this.bind(framebuffer);\n        gl.bindFramebuffer(gl.READ_FRAMEBUFFER, fbo.framebuffer);\n        gl.blitFramebuffer(sourcePixels.x, sourcePixels.y, sourcePixels.width, sourcePixels.height, destPixels.x, destPixels.y, destPixels.width, destPixels.height, gl.COLOR_BUFFER_BIT, sameSize ? gl.NEAREST : gl.LINEAR);\n    };\n    /**\n     * Disposes framebuffer\n     * @param {PIXI.Framebuffer} framebuffer - framebuffer that has to be disposed of\n     * @param {boolean} [contextLost=false] - If context was lost, we suppress all delete function calls\n     */\n    FramebufferSystem.prototype.disposeFramebuffer = function (framebuffer, contextLost) {\n        var fbo = framebuffer.glFramebuffers[this.CONTEXT_UID];\n        var gl = this.gl;\n        if (!fbo) {\n            return;\n        }\n        delete framebuffer.glFramebuffers[this.CONTEXT_UID];\n        var index = this.managedFramebuffers.indexOf(framebuffer);\n        if (index >= 0) {\n            this.managedFramebuffers.splice(index, 1);\n        }\n        framebuffer.disposeRunner.remove(this);\n        if (!contextLost) {\n            gl.deleteFramebuffer(fbo.framebuffer);\n            if (fbo.stencil) {\n                gl.deleteRenderbuffer(fbo.stencil);\n            }\n        }\n    };\n    /**\n     * Disposes all framebuffers, but not textures bound to them\n     * @param {boolean} [contextLost=false] - If context was lost, we suppress all delete function calls\n     */\n    FramebufferSystem.prototype.disposeAll = function (contextLost) {\n        var list = this.managedFramebuffers;\n        this.managedFramebuffers = [];\n        for (var i = 0; i < list.length; i++) {\n            this.disposeFramebuffer(list[i], contextLost);\n        }\n    };\n    /**\n     * Forcing creation of stencil buffer for current framebuffer, if it wasn't done before.\n     * Used by MaskSystem, when its time to use stencil mask for Graphics element.\n     *\n     * Its an alternative for public lazy `framebuffer.enableStencil`, in case we need stencil without rebind.\n     *\n     * @private\n     */\n    FramebufferSystem.prototype.forceStencil = function () {\n        var framebuffer = this.current;\n        if (!framebuffer) {\n            return;\n        }\n        var fbo = framebuffer.glFramebuffers[this.CONTEXT_UID];\n        if (!fbo || fbo.stencil) {\n            return;\n        }\n        framebuffer.enableStencil();\n        var w = framebuffer.width;\n        var h = framebuffer.height;\n        var gl = this.gl;\n        var stencil = gl.createRenderbuffer();\n        gl.bindRenderbuffer(gl.RENDERBUFFER, stencil);\n        gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, w, h);\n        fbo.stencil = stencil;\n        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, stencil);\n    };\n    /**\n     * resets framebuffer stored state, binds screen framebuffer\n     *\n     * should be called before renderTexture reset()\n     */\n    FramebufferSystem.prototype.reset = function () {\n        this.current = this.unknownFramebuffer;\n        this.viewport = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n    };\n    return FramebufferSystem;\n}(System));\n\nvar GLBuffer = /** @class */ (function () {\n    function GLBuffer(buffer) {\n        this.buffer = buffer || null;\n        this.updateID = -1;\n        this.byteLength = -1;\n        this.refCount = 0;\n    }\n    return GLBuffer;\n}());\n\nvar byteSizeMap$1 = { 5126: 4, 5123: 2, 5121: 1 };\n/**\n * System plugin to the renderer to manage geometry.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar GeometrySystem = /** @class */ (function (_super) {\n    __extends(GeometrySystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function GeometrySystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        _this._activeGeometry = null;\n        _this._activeVao = null;\n        /**\n         * `true` if we has `*_vertex_array_object` extension\n         * @member {boolean}\n         * @readonly\n         */\n        _this.hasVao = true;\n        /**\n         * `true` if has `ANGLE_instanced_arrays` extension\n         * @member {boolean}\n         * @readonly\n         */\n        _this.hasInstance = true;\n        /**\n         * `true` if support `gl.UNSIGNED_INT` in `gl.drawElements` or `gl.drawElementsInstanced`\n         * @member {boolean}\n         * @readonly\n         */\n        _this.canUseUInt32ElementIndex = false;\n        /**\n         * Cache for all geometries by id, used in case renderer gets destroyed or for profiling\n         * @member {object}\n         * @readonly\n         */\n        _this.managedGeometries = {};\n        /**\n         * Cache for all buffers by id, used in case renderer gets destroyed or for profiling\n         * @member {object}\n         * @readonly\n         */\n        _this.managedBuffers = {};\n        return _this;\n    }\n    /**\n     * Sets up the renderer context and necessary buffers.\n     */\n    GeometrySystem.prototype.contextChange = function () {\n        this.disposeAll(true);\n        var gl = this.gl = this.renderer.gl;\n        var context = this.renderer.context;\n        this.CONTEXT_UID = this.renderer.CONTEXT_UID;\n        // webgl2\n        if (context.webGLVersion !== 2) {\n            // webgl 1!\n            var nativeVaoExtension_1 = this.renderer.context.extensions.vertexArrayObject;\n            if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL_LEGACY) {\n                nativeVaoExtension_1 = null;\n            }\n            if (nativeVaoExtension_1) {\n                gl.createVertexArray = function () {\n                    return nativeVaoExtension_1.createVertexArrayOES();\n                };\n                gl.bindVertexArray = function (vao) {\n                    return nativeVaoExtension_1.bindVertexArrayOES(vao);\n                };\n                gl.deleteVertexArray = function (vao) {\n                    return nativeVaoExtension_1.deleteVertexArrayOES(vao);\n                };\n            }\n            else {\n                this.hasVao = false;\n                gl.createVertexArray = function () {\n                    return null;\n                };\n                gl.bindVertexArray = function () {\n                    return null;\n                };\n                gl.deleteVertexArray = function () {\n                    return null;\n                };\n            }\n        }\n        if (context.webGLVersion !== 2) {\n            var instanceExt_1 = gl.getExtension('ANGLE_instanced_arrays');\n            if (instanceExt_1) {\n                gl.vertexAttribDivisor = function (a, b) {\n                    return instanceExt_1.vertexAttribDivisorANGLE(a, b);\n                };\n                gl.drawElementsInstanced = function (a, b, c, d, e) {\n                    return instanceExt_1.drawElementsInstancedANGLE(a, b, c, d, e);\n                };\n                gl.drawArraysInstanced = function (a, b, c, d) {\n                    return instanceExt_1.drawArraysInstancedANGLE(a, b, c, d);\n                };\n            }\n            else {\n                this.hasInstance = false;\n            }\n        }\n        this.canUseUInt32ElementIndex = context.webGLVersion === 2 || !!context.extensions.uint32ElementIndex;\n    };\n    /**\n     * Binds geometry so that is can be drawn. Creating a Vao if required\n     *\n     * @param {PIXI.Geometry} geometry - instance of geometry to bind\n     * @param {PIXI.Shader} [shader] - instance of shader to use vao for\n     */\n    GeometrySystem.prototype.bind = function (geometry, shader) {\n        shader = shader || this.renderer.shader.shader;\n        var gl = this.gl;\n        // not sure the best way to address this..\n        // currently different shaders require different VAOs for the same geometry\n        // Still mulling over the best way to solve this one..\n        // will likely need to modify the shader attribute locations at run time!\n        var vaos = geometry.glVertexArrayObjects[this.CONTEXT_UID];\n        var incRefCount = false;\n        if (!vaos) {\n            this.managedGeometries[geometry.id] = geometry;\n            geometry.disposeRunner.add(this);\n            geometry.glVertexArrayObjects[this.CONTEXT_UID] = vaos = {};\n            incRefCount = true;\n        }\n        var vao = vaos[shader.program.id] || this.initGeometryVao(geometry, shader.program, incRefCount);\n        this._activeGeometry = geometry;\n        if (this._activeVao !== vao) {\n            this._activeVao = vao;\n            if (this.hasVao) {\n                gl.bindVertexArray(vao);\n            }\n            else {\n                this.activateVao(geometry, shader.program);\n            }\n        }\n        // TODO - optimise later!\n        // don't need to loop through if nothing changed!\n        // maybe look to add an 'autoupdate' to geometry?\n        this.updateBuffers();\n    };\n    /**\n     * Reset and unbind any active VAO and geometry\n     */\n    GeometrySystem.prototype.reset = function () {\n        this.unbind();\n    };\n    /**\n     * Update buffers\n     * @protected\n     */\n    GeometrySystem.prototype.updateBuffers = function () {\n        var geometry = this._activeGeometry;\n        var gl = this.gl;\n        for (var i = 0; i < geometry.buffers.length; i++) {\n            var buffer = geometry.buffers[i];\n            var glBuffer = buffer._glBuffers[this.CONTEXT_UID];\n            if (buffer._updateID !== glBuffer.updateID) {\n                glBuffer.updateID = buffer._updateID;\n                // TODO can cache this on buffer! maybe added a getter / setter?\n                var type = buffer.index ? gl.ELEMENT_ARRAY_BUFFER : gl.ARRAY_BUFFER;\n                // TODO this could change if the VAO changes...\n                // need to come up with a better way to cache..\n                // if (this.boundBuffers[type] !== glBuffer)\n                // {\n                // this.boundBuffers[type] = glBuffer;\n                gl.bindBuffer(type, glBuffer.buffer);\n                // }\n                this._boundBuffer = glBuffer;\n                if (glBuffer.byteLength >= buffer.data.byteLength) {\n                    // offset is always zero for now!\n                    gl.bufferSubData(type, 0, buffer.data);\n                }\n                else {\n                    var drawType = buffer.static ? gl.STATIC_DRAW : gl.DYNAMIC_DRAW;\n                    glBuffer.byteLength = buffer.data.byteLength;\n                    gl.bufferData(type, buffer.data, drawType);\n                }\n            }\n        }\n    };\n    /**\n     * Check compability between a geometry and a program\n     * @protected\n     * @param {PIXI.Geometry} geometry - Geometry instance\n     * @param {PIXI.Program} program - Program instance\n     */\n    GeometrySystem.prototype.checkCompatibility = function (geometry, program) {\n        // geometry must have at least all the attributes that the shader requires.\n        var geometryAttributes = geometry.attributes;\n        var shaderAttributes = program.attributeData;\n        for (var j in shaderAttributes) {\n            if (!geometryAttributes[j]) {\n                throw new Error(\"shader and geometry incompatible, geometry missing the \\\"\" + j + \"\\\" attribute\");\n            }\n        }\n    };\n    /**\n     * Takes a geometry and program and generates a unique signature for them.\n     *\n     * @param {PIXI.Geometry} geometry - to get signature from\n     * @param {PIXI.Program} program - to test geometry against\n     * @returns {String} Unique signature of the geometry and program\n     * @protected\n     */\n    GeometrySystem.prototype.getSignature = function (geometry, program) {\n        var attribs = geometry.attributes;\n        var shaderAttributes = program.attributeData;\n        var strings = ['g', geometry.id];\n        for (var i in attribs) {\n            if (shaderAttributes[i]) {\n                strings.push(i);\n            }\n        }\n        return strings.join('-');\n    };\n    /**\n     * Creates or gets Vao with the same structure as the geometry and stores it on the geometry.\n     * If vao is created, it is bound automatically.\n     *\n     * @protected\n     * @param {PIXI.Geometry} geometry - Instance of geometry to to generate Vao for\n     * @param {PIXI.Program} program - Instance of program\n     * @param {boolean} [incRefCount=false] - Increment refCount of all geometry buffers\n     */\n    GeometrySystem.prototype.initGeometryVao = function (geometry, program, incRefCount) {\n        if (incRefCount === void 0) { incRefCount = true; }\n        this.checkCompatibility(geometry, program);\n        var gl = this.gl;\n        var CONTEXT_UID = this.CONTEXT_UID;\n        var signature = this.getSignature(geometry, program);\n        var vaoObjectHash = geometry.glVertexArrayObjects[this.CONTEXT_UID];\n        var vao = vaoObjectHash[signature];\n        if (vao) {\n            // this will give us easy access to the vao\n            vaoObjectHash[program.id] = vao;\n            return vao;\n        }\n        var buffers = geometry.buffers;\n        var attributes = geometry.attributes;\n        var tempStride = {};\n        var tempStart = {};\n        for (var j in buffers) {\n            tempStride[j] = 0;\n            tempStart[j] = 0;\n        }\n        for (var j in attributes) {\n            if (!attributes[j].size && program.attributeData[j]) {\n                attributes[j].size = program.attributeData[j].size;\n            }\n            else if (!attributes[j].size) {\n                console.warn(\"PIXI Geometry attribute '\" + j + \"' size cannot be determined (likely the bound shader does not have the attribute)\"); // eslint-disable-line\n            }\n            tempStride[attributes[j].buffer] += attributes[j].size * byteSizeMap$1[attributes[j].type];\n        }\n        for (var j in attributes) {\n            var attribute = attributes[j];\n            var attribSize = attribute.size;\n            if (attribute.stride === undefined) {\n                if (tempStride[attribute.buffer] === attribSize * byteSizeMap$1[attribute.type]) {\n                    attribute.stride = 0;\n                }\n                else {\n                    attribute.stride = tempStride[attribute.buffer];\n                }\n            }\n            if (attribute.start === undefined) {\n                attribute.start = tempStart[attribute.buffer];\n                tempStart[attribute.buffer] += attribSize * byteSizeMap$1[attribute.type];\n            }\n        }\n        vao = gl.createVertexArray();\n        gl.bindVertexArray(vao);\n        // first update - and create the buffers!\n        // only create a gl buffer if it actually gets\n        for (var i = 0; i < buffers.length; i++) {\n            var buffer = buffers[i];\n            if (!buffer._glBuffers[CONTEXT_UID]) {\n                buffer._glBuffers[CONTEXT_UID] = new GLBuffer(gl.createBuffer());\n                this.managedBuffers[buffer.id] = buffer;\n                buffer.disposeRunner.add(this);\n            }\n            if (incRefCount) {\n                buffer._glBuffers[CONTEXT_UID].refCount++;\n            }\n        }\n        // TODO - maybe make this a data object?\n        // lets wait to see if we need to first!\n        this.activateVao(geometry, program);\n        this._activeVao = vao;\n        // add it to the cache!\n        vaoObjectHash[program.id] = vao;\n        vaoObjectHash[signature] = vao;\n        return vao;\n    };\n    /**\n     * Disposes buffer\n     * @param {PIXI.Buffer} buffer - buffer with data\n     * @param {boolean} [contextLost=false] - If context was lost, we suppress deleteVertexArray\n     */\n    GeometrySystem.prototype.disposeBuffer = function (buffer, contextLost) {\n        if (!this.managedBuffers[buffer.id]) {\n            return;\n        }\n        delete this.managedBuffers[buffer.id];\n        var glBuffer = buffer._glBuffers[this.CONTEXT_UID];\n        var gl = this.gl;\n        buffer.disposeRunner.remove(this);\n        if (!glBuffer) {\n            return;\n        }\n        if (!contextLost) {\n            gl.deleteBuffer(glBuffer.buffer);\n        }\n        delete buffer._glBuffers[this.CONTEXT_UID];\n    };\n    /**\n     * Disposes geometry\n     * @param {PIXI.Geometry} geometry - Geometry with buffers. Only VAO will be disposed\n     * @param {boolean} [contextLost=false] - If context was lost, we suppress deleteVertexArray\n     */\n    GeometrySystem.prototype.disposeGeometry = function (geometry, contextLost) {\n        if (!this.managedGeometries[geometry.id]) {\n            return;\n        }\n        delete this.managedGeometries[geometry.id];\n        var vaos = geometry.glVertexArrayObjects[this.CONTEXT_UID];\n        var gl = this.gl;\n        var buffers = geometry.buffers;\n        geometry.disposeRunner.remove(this);\n        if (!vaos) {\n            return;\n        }\n        for (var i = 0; i < buffers.length; i++) {\n            var buf = buffers[i]._glBuffers[this.CONTEXT_UID];\n            buf.refCount--;\n            if (buf.refCount === 0 && !contextLost) {\n                this.disposeBuffer(buffers[i], contextLost);\n            }\n        }\n        if (!contextLost) {\n            for (var vaoId in vaos) {\n                // delete only signatures, everything else are copies\n                if (vaoId[0] === 'g') {\n                    var vao = vaos[vaoId];\n                    if (this._activeVao === vao) {\n                        this.unbind();\n                    }\n                    gl.deleteVertexArray(vao);\n                }\n            }\n        }\n        delete geometry.glVertexArrayObjects[this.CONTEXT_UID];\n    };\n    /**\n     * dispose all WebGL resources of all managed geometries and buffers\n     * @param {boolean} [contextLost=false] - If context was lost, we suppress `gl.delete` calls\n     */\n    GeometrySystem.prototype.disposeAll = function (contextLost) {\n        var all = Object.keys(this.managedGeometries);\n        for (var i = 0; i < all.length; i++) {\n            this.disposeGeometry(this.managedGeometries[all[i]], contextLost);\n        }\n        all = Object.keys(this.managedBuffers);\n        for (var i = 0; i < all.length; i++) {\n            this.disposeBuffer(this.managedBuffers[all[i]], contextLost);\n        }\n    };\n    /**\n     * Activate vertex array object\n     *\n     * @protected\n     * @param {PIXI.Geometry} geometry - Geometry instance\n     * @param {PIXI.Program} program - Shader program instance\n     */\n    GeometrySystem.prototype.activateVao = function (geometry, program) {\n        var gl = this.gl;\n        var CONTEXT_UID = this.CONTEXT_UID;\n        var buffers = geometry.buffers;\n        var attributes = geometry.attributes;\n        if (geometry.indexBuffer) {\n            // first update the index buffer if we have one..\n            gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, geometry.indexBuffer._glBuffers[CONTEXT_UID].buffer);\n        }\n        var lastBuffer = null;\n        // add a new one!\n        for (var j in attributes) {\n            var attribute = attributes[j];\n            var buffer = buffers[attribute.buffer];\n            var glBuffer = buffer._glBuffers[CONTEXT_UID];\n            if (program.attributeData[j]) {\n                if (lastBuffer !== glBuffer) {\n                    gl.bindBuffer(gl.ARRAY_BUFFER, glBuffer.buffer);\n                    lastBuffer = glBuffer;\n                }\n                var location = program.attributeData[j].location;\n                // TODO introduce state again\n                // we can optimise this for older devices that have no VAOs\n                gl.enableVertexAttribArray(location);\n                gl.vertexAttribPointer(location, attribute.size, attribute.type || gl.FLOAT, attribute.normalized, attribute.stride, attribute.start);\n                if (attribute.instance) {\n                    // TODO calculate instance count based of this...\n                    if (this.hasInstance) {\n                        gl.vertexAttribDivisor(location, 1);\n                    }\n                    else {\n                        throw new Error('geometry error, GPU Instancing is not supported on this device');\n                    }\n                }\n            }\n        }\n    };\n    /**\n     * Draw the geometry\n     *\n     * @param {Number} type - the type primitive to render\n     * @param {Number} [size] - the number of elements to be rendered\n     * @param {Number} [start] - Starting index\n     * @param {Number} [instanceCount] - the number of instances of the set of elements to execute\n     */\n    GeometrySystem.prototype.draw = function (type, size, start, instanceCount) {\n        var gl = this.gl;\n        var geometry = this._activeGeometry;\n        // TODO.. this should not change so maybe cache the function?\n        if (geometry.indexBuffer) {\n            var byteSize = geometry.indexBuffer.data.BYTES_PER_ELEMENT;\n            var glType = byteSize === 2 ? gl.UNSIGNED_SHORT : gl.UNSIGNED_INT;\n            if (byteSize === 2 || (byteSize === 4 && this.canUseUInt32ElementIndex)) {\n                if (geometry.instanced) {\n                    /* eslint-disable max-len */\n                    gl.drawElementsInstanced(type, size || geometry.indexBuffer.data.length, glType, (start || 0) * byteSize, instanceCount || 1);\n                    /* eslint-enable max-len */\n                }\n                else {\n                    /* eslint-disable max-len */\n                    gl.drawElements(type, size || geometry.indexBuffer.data.length, glType, (start || 0) * byteSize);\n                    /* eslint-enable max-len */\n                }\n            }\n            else {\n                console.warn('unsupported index buffer type: uint32');\n            }\n        }\n        else if (geometry.instanced) {\n            // TODO need a better way to calculate size..\n            gl.drawArraysInstanced(type, start, size || geometry.getSize(), instanceCount || 1);\n        }\n        else {\n            gl.drawArrays(type, start, size || geometry.getSize());\n        }\n        return this;\n    };\n    /**\n     * Unbind/reset everything\n     * @protected\n     */\n    GeometrySystem.prototype.unbind = function () {\n        this.gl.bindVertexArray(null);\n        this._activeVao = null;\n        this._activeGeometry = null;\n    };\n    return GeometrySystem;\n}(System));\n\n/**\n * Component for masked elements\n *\n * Holds mask mode and temporary data about current mask\n *\n * @class\n * @memberof PIXI\n */\nvar MaskData = /** @class */ (function () {\n    /**\n     * Create MaskData\n     *\n     * @param {PIXI.DisplayObject} [maskObject=null] - object that describes the mask\n     */\n    function MaskData(maskObject) {\n        if (maskObject === void 0) { maskObject = null; }\n        /**\n         * Mask type\n         * @member {PIXI.MASK_TYPES}\n         */\n        this.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.NONE;\n        /**\n         * Whether we know the mask type beforehand\n         * @member {boolean}\n         * @default true\n         */\n        this.autoDetect = true;\n        /**\n         * Which element we use to mask\n         * @member {PIXI.DisplayObject}\n         */\n        this.maskObject = maskObject || null;\n        /**\n         * Whether it belongs to MaskSystem pool\n         * @member {boolean}\n         */\n        this.pooled = false;\n        /**\n         * Indicator of the type\n         * @member {boolean}\n         */\n        this.isMaskData = true;\n        /**\n         * Stencil counter above the mask in stack\n         * @member {number}\n         * @private\n         */\n        this._stencilCounter = 0;\n        /**\n         * Scissor counter above the mask in stack\n         * @member {number}\n         * @private\n         */\n        this._scissorCounter = 0;\n        /**\n         * Scissor operation above the mask in stack.\n         * Null if _scissorCounter is zero, rectangle instance if positive.\n         * @member {PIXI.Rectangle}\n         */\n        this._scissorRect = null;\n        /**\n         * Targeted element. Temporary variable set by MaskSystem\n         * @member {PIXI.DisplayObject}\n         * @private\n         */\n        this._target = null;\n    }\n    /**\n     * resets the mask data after popMask()\n     */\n    MaskData.prototype.reset = function () {\n        if (this.pooled) {\n            this.maskObject = null;\n            this.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.NONE;\n            this.autoDetect = true;\n        }\n        this._target = null;\n    };\n    /**\n     * copies counters from maskData above, called from pushMask()\n     * @param {PIXI.MaskData|null} maskAbove\n     */\n    MaskData.prototype.copyCountersOrReset = function (maskAbove) {\n        if (maskAbove) {\n            this._stencilCounter = maskAbove._stencilCounter;\n            this._scissorCounter = maskAbove._scissorCounter;\n            this._scissorRect = maskAbove._scissorRect;\n        }\n        else {\n            this._stencilCounter = 0;\n            this._scissorCounter = 0;\n            this._scissorRect = null;\n        }\n    };\n    return MaskData;\n}());\n\n/**\n * @private\n * @param gl {WebGLRenderingContext} The current WebGL context {WebGLProgram}\n * @param type {Number} the type, can be either VERTEX_SHADER or FRAGMENT_SHADER\n * @param src {string} The vertex shader source as an array of strings.\n * @return {WebGLShader} the shader\n */\nfunction compileShader(gl, type, src) {\n    var shader = gl.createShader(type);\n    gl.shaderSource(shader, src);\n    gl.compileShader(shader);\n    return shader;\n}\n/**\n * @method compileProgram\n * @private\n * @memberof PIXI.glCore.shader\n * @param gl {WebGLRenderingContext} The current WebGL context {WebGLProgram}\n * @param vertexSrc {string|string[]} The vertex shader source as an array of strings.\n * @param fragmentSrc {string|string[]} The fragment shader source as an array of strings.\n * @param attributeLocations {Object} An attribute location map that lets you manually set the attribute locations\n * @return {WebGLProgram} the shader program\n */\nfunction compileProgram(gl, vertexSrc, fragmentSrc, attributeLocations) {\n    var glVertShader = compileShader(gl, gl.VERTEX_SHADER, vertexSrc);\n    var glFragShader = compileShader(gl, gl.FRAGMENT_SHADER, fragmentSrc);\n    var program = gl.createProgram();\n    gl.attachShader(program, glVertShader);\n    gl.attachShader(program, glFragShader);\n    // optionally, set the attributes manually for the program rather than letting WebGL decide..\n    if (attributeLocations) {\n        for (var i in attributeLocations) {\n            gl.bindAttribLocation(program, attributeLocations[i], i);\n        }\n    }\n    gl.linkProgram(program);\n    // if linking fails, then log and cleanup\n    if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {\n        if (!gl.getShaderParameter(glVertShader, gl.COMPILE_STATUS)) {\n            console.warn(vertexSrc);\n            console.error(gl.getShaderInfoLog(glVertShader));\n        }\n        if (!gl.getShaderParameter(glFragShader, gl.COMPILE_STATUS)) {\n            console.warn(fragmentSrc);\n            console.error(gl.getShaderInfoLog(glFragShader));\n        }\n        console.error('Pixi.js Error: Could not initialize shader.');\n        console.error('gl.VALIDATE_STATUS', gl.getProgramParameter(program, gl.VALIDATE_STATUS));\n        console.error('gl.getError()', gl.getError());\n        // if there is a program info log, log it\n        if (gl.getProgramInfoLog(program) !== '') {\n            console.warn('Pixi.js Warning: gl.getProgramInfoLog()', gl.getProgramInfoLog(program));\n        }\n        gl.deleteProgram(program);\n        program = null;\n    }\n    // clean up some shaders\n    gl.deleteShader(glVertShader);\n    gl.deleteShader(glFragShader);\n    return program;\n}\n\nfunction booleanArray(size) {\n    var array = new Array(size);\n    for (var i = 0; i < array.length; i++) {\n        array[i] = false;\n    }\n    return array;\n}\n/**\n * @method defaultValue\n * @memberof PIXI.glCore.shader\n * @param type {String} Type of value\n * @param size {Number}\n * @private\n */\nfunction defaultValue(type, size) {\n    switch (type) {\n        case 'float':\n            return 0;\n        case 'vec2':\n            return new Float32Array(2 * size);\n        case 'vec3':\n            return new Float32Array(3 * size);\n        case 'vec4':\n            return new Float32Array(4 * size);\n        case 'int':\n        case 'sampler2D':\n        case 'sampler2DArray':\n            return 0;\n        case 'ivec2':\n            return new Int32Array(2 * size);\n        case 'ivec3':\n            return new Int32Array(3 * size);\n        case 'ivec4':\n            return new Int32Array(4 * size);\n        case 'bool':\n            return false;\n        case 'bvec2':\n            return booleanArray(2 * size);\n        case 'bvec3':\n            return booleanArray(3 * size);\n        case 'bvec4':\n            return booleanArray(4 * size);\n        case 'mat2':\n            return new Float32Array([1, 0,\n                0, 1]);\n        case 'mat3':\n            return new Float32Array([1, 0, 0,\n                0, 1, 0,\n                0, 0, 1]);\n        case 'mat4':\n            return new Float32Array([1, 0, 0, 0,\n                0, 1, 0, 0,\n                0, 0, 1, 0,\n                0, 0, 0, 1]);\n    }\n    return null;\n}\n\nvar unknownContext = {};\nvar context = unknownContext;\n/**\n * returns a little WebGL context to use for program inspection.\n *\n * @static\n * @private\n * @returns {WebGLRenderingContext} a gl context to test with\n */\nfunction getTestContext() {\n    if (context === unknownContext || (context && context.isContextLost())) {\n        var canvas = document.createElement('canvas');\n        var gl = void 0;\n        if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV >= _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL2) {\n            gl = canvas.getContext('webgl2', {});\n        }\n        if (!gl) {\n            gl = canvas.getContext('webgl', {})\n                || canvas.getContext('experimental-webgl', {});\n            if (!gl) {\n                // fail, not able to get a context\n                gl = null;\n            }\n            else {\n                // for shader testing..\n                gl.getExtension('WEBGL_draw_buffers');\n            }\n        }\n        context = gl;\n    }\n    return context;\n}\n\nvar maxFragmentPrecision;\nfunction getMaxFragmentPrecision() {\n    if (!maxFragmentPrecision) {\n        maxFragmentPrecision = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.MEDIUM;\n        var gl = getTestContext();\n        if (gl) {\n            if (gl.getShaderPrecisionFormat) {\n                var shaderFragment = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT);\n                maxFragmentPrecision = shaderFragment.precision ? _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.HIGH : _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.MEDIUM;\n            }\n        }\n    }\n    return maxFragmentPrecision;\n}\n\n/**\n * Sets the float precision on the shader, ensuring the device supports the request precision.\n * If the precision is already present, it just ensures that the device is able to handle it.\n *\n * @private\n * @param {string} src - The shader source\n * @param {string} requestedPrecision - The request float precision of the shader. Options are 'lowp', 'mediump' or 'highp'.\n * @param {string} maxSupportedPrecision - The maximum precision the shader supports.\n *\n * @return {string} modified shader source\n */\nfunction setPrecision(src, requestedPrecision, maxSupportedPrecision) {\n    if (src.substring(0, 9) !== 'precision') {\n        // no precision supplied, so PixiJS will add the requested level.\n        var precision = requestedPrecision;\n        // If highp is requested but not supported, downgrade precision to a level all devices support.\n        if (requestedPrecision === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.HIGH && maxSupportedPrecision !== _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.HIGH) {\n            precision = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.MEDIUM;\n        }\n        return \"precision \" + precision + \" float;\\n\" + src;\n    }\n    else if (maxSupportedPrecision !== _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.HIGH && src.substring(0, 15) === 'precision highp') {\n        // precision was supplied, but at a level this device does not support, so downgrading to mediump.\n        return src.replace('precision highp', 'precision mediump');\n    }\n    return src;\n}\n\nvar GLSL_TO_SIZE = {\n    float: 1,\n    vec2: 2,\n    vec3: 3,\n    vec4: 4,\n    int: 1,\n    ivec2: 2,\n    ivec3: 3,\n    ivec4: 4,\n    bool: 1,\n    bvec2: 2,\n    bvec3: 3,\n    bvec4: 4,\n    mat2: 4,\n    mat3: 9,\n    mat4: 16,\n    sampler2D: 1,\n};\n/**\n * @private\n * @method mapSize\n * @memberof PIXI.glCore.shader\n * @param type {String}\n * @return {Number}\n */\nfunction mapSize(type) {\n    return GLSL_TO_SIZE[type];\n}\n\nvar GL_TABLE = null;\nvar GL_TO_GLSL_TYPES = {\n    FLOAT: 'float',\n    FLOAT_VEC2: 'vec2',\n    FLOAT_VEC3: 'vec3',\n    FLOAT_VEC4: 'vec4',\n    INT: 'int',\n    INT_VEC2: 'ivec2',\n    INT_VEC3: 'ivec3',\n    INT_VEC4: 'ivec4',\n    BOOL: 'bool',\n    BOOL_VEC2: 'bvec2',\n    BOOL_VEC3: 'bvec3',\n    BOOL_VEC4: 'bvec4',\n    FLOAT_MAT2: 'mat2',\n    FLOAT_MAT3: 'mat3',\n    FLOAT_MAT4: 'mat4',\n    SAMPLER_2D: 'sampler2D',\n    INT_SAMPLER_2D: 'sampler2D',\n    UNSIGNED_INT_SAMPLER_2D: 'sampler2D',\n    SAMPLER_CUBE: 'samplerCube',\n    INT_SAMPLER_CUBE: 'samplerCube',\n    UNSIGNED_INT_SAMPLER_CUBE: 'samplerCube',\n    SAMPLER_2D_ARRAY: 'sampler2DArray',\n    INT_SAMPLER_2D_ARRAY: 'sampler2DArray',\n    UNSIGNED_INT_SAMPLER_2D_ARRAY: 'sampler2DArray',\n};\n// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types\nfunction mapType(gl, type) {\n    if (!GL_TABLE) {\n        var typeNames = Object.keys(GL_TO_GLSL_TYPES);\n        GL_TABLE = {};\n        for (var i = 0; i < typeNames.length; ++i) {\n            var tn = typeNames[i];\n            GL_TABLE[gl[tn]] = GL_TO_GLSL_TYPES[tn];\n        }\n    }\n    return GL_TABLE[type];\n}\n\n/* eslint-disable @typescript-eslint/explicit-module-boundary-types */\n// Parsers, each one of these will take a look at the type of shader property and uniform.\n// if they pass the test function then the code function is called that returns a the shader upload code for that uniform.\n// Shader upload code is automagically generated with these parsers.\n// If no parser is valid then the default upload functions are used.\n// exposing Parsers means that custom upload logic can be added to pixi's shaders.\n// A good example would be a pixi rectangle can be directly set on a uniform.\n// If the shader sees it it knows how to upload the rectangle structure as a vec4\n// format is as follows:\n//\n// {\n//     test: (data, uniform) => {} <--- test is this code should be used for this uniform\n//     code: (name, uniform) => {} <--- returns the string of the piece of code that uploads the uniform\n// }\nvar uniformParsers = [\n    // a float cache layer\n    {\n        test: function (data) {\n            return data.type === 'float' && data.size === 1;\n        },\n        code: function (name) {\n            return \"\\n            if(uv[\\\"\" + name + \"\\\"] !== ud[\\\"\" + name + \"\\\"].value)\\n            {\\n                ud[\\\"\" + name + \"\\\"].value = uv[\\\"\" + name + \"\\\"]\\n                gl.uniform1f(ud[\\\"\" + name + \"\\\"].location, uv[\\\"\" + name + \"\\\"])\\n            }\\n            \";\n        },\n    },\n    // handling samplers\n    {\n        test: function (data) {\n            // eslint-disable-next-line max-len\n            return (data.type === 'sampler2D' || data.type === 'samplerCube' || data.type === 'sampler2DArray') && data.size === 1 && !data.isArray;\n        },\n        code: function (name) { return \"t = syncData.textureCount++;\\n\\n            renderer.texture.bind(uv[\\\"\" + name + \"\\\"], t);\\n\\n            if(ud[\\\"\" + name + \"\\\"].value !== t)\\n            {\\n                ud[\\\"\" + name + \"\\\"].value = t;\\n                gl.uniform1i(ud[\\\"\" + name + \"\\\"].location, t);\\n; // eslint-disable-line max-len\\n            }\"; },\n    },\n    // uploading pixi matrix object to mat3\n    {\n        test: function (data, uniform) {\n            return data.type === 'mat3' && data.size === 1 && uniform.a !== undefined;\n        },\n        code: function (name) {\n            // TODO and some smart caching dirty ids here!\n            return \"\\n            gl.uniformMatrix3fv(ud[\\\"\" + name + \"\\\"].location, false, uv[\\\"\" + name + \"\\\"].toArray(true));\\n            \";\n        },\n    },\n    // uploading a pixi point as a vec2 with caching layer\n    {\n        test: function (data, uniform) {\n            return data.type === 'vec2' && data.size === 1 && uniform.x !== undefined;\n        },\n        code: function (name) {\n            return \"\\n                cv = ud[\\\"\" + name + \"\\\"].value;\\n                v = uv[\\\"\" + name + \"\\\"];\\n\\n                if(cv[0] !== v.x || cv[1] !== v.y)\\n                {\\n                    cv[0] = v.x;\\n                    cv[1] = v.y;\\n                    gl.uniform2f(ud[\\\"\" + name + \"\\\"].location, v.x, v.y);\\n                }\";\n        },\n    },\n    // caching layer for a vec2\n    {\n        test: function (data) {\n            return data.type === 'vec2' && data.size === 1;\n        },\n        code: function (name) {\n            return \"\\n                cv = ud[\\\"\" + name + \"\\\"].value;\\n                v = uv[\\\"\" + name + \"\\\"];\\n\\n                if(cv[0] !== v[0] || cv[1] !== v[1])\\n                {\\n                    cv[0] = v[0];\\n                    cv[1] = v[1];\\n                    gl.uniform2f(ud[\\\"\" + name + \"\\\"].location, v[0], v[1]);\\n                }\\n            \";\n        },\n    },\n    // upload a pixi rectangle as a vec4 with caching layer\n    {\n        test: function (data, uniform) {\n            return data.type === 'vec4' && data.size === 1 && uniform.width !== undefined;\n        },\n        code: function (name) {\n            return \"\\n                cv = ud[\\\"\" + name + \"\\\"].value;\\n                v = uv[\\\"\" + name + \"\\\"];\\n\\n                if(cv[0] !== v.x || cv[1] !== v.y || cv[2] !== v.width || cv[3] !== v.height)\\n                {\\n                    cv[0] = v.x;\\n                    cv[1] = v.y;\\n                    cv[2] = v.width;\\n                    cv[3] = v.height;\\n                    gl.uniform4f(ud[\\\"\" + name + \"\\\"].location, v.x, v.y, v.width, v.height)\\n                }\";\n        },\n    },\n    // a caching layer for vec4 uploading\n    {\n        test: function (data) {\n            return data.type === 'vec4' && data.size === 1;\n        },\n        code: function (name) {\n            return \"\\n                cv = ud[\\\"\" + name + \"\\\"].value;\\n                v = uv[\\\"\" + name + \"\\\"];\\n\\n                if(cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\\n                {\\n                    cv[0] = v[0];\\n                    cv[1] = v[1];\\n                    cv[2] = v[2];\\n                    cv[3] = v[3];\\n\\n                    gl.uniform4f(ud[\\\"\" + name + \"\\\"].location, v[0], v[1], v[2], v[3])\\n                }\";\n        },\n    } ];\n\n// cv = CachedValue\n// v = value\n// ud = uniformData\n// uv = uniformValue\n// l = location\nvar GLSL_TO_SINGLE_SETTERS_CACHED = {\n    float: \"\\n    if(cv !== v)\\n    {\\n        cv.v = v;\\n        gl.uniform1f(location, v)\\n    }\",\n    vec2: \"\\n    if(cv[0] !== v[0] || cv[1] !== v[1])\\n    {\\n        cv[0] = v[0];\\n        cv[1] = v[1];\\n        gl.uniform2f(location, v[0], v[1])\\n    }\",\n    vec3: \"\\n    if(cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2])\\n    {\\n        cv[0] = v[0];\\n        cv[1] = v[1];\\n        cv[2] = v[2];\\n\\n        gl.uniform3f(location, v[0], v[1], v[2])\\n    }\",\n    vec4: 'gl.uniform4f(location, v[0], v[1], v[2], v[3])',\n    int: 'gl.uniform1i(location, v)',\n    ivec2: 'gl.uniform2i(location, v[0], v[1])',\n    ivec3: 'gl.uniform3i(location, v[0], v[1], v[2])',\n    ivec4: 'gl.uniform4i(location, v[0], v[1], v[2], v[3])',\n    bool: 'gl.uniform1i(location, v)',\n    bvec2: 'gl.uniform2i(location, v[0], v[1])',\n    bvec3: 'gl.uniform3i(location, v[0], v[1], v[2])',\n    bvec4: 'gl.uniform4i(location, v[0], v[1], v[2], v[3])',\n    mat2: 'gl.uniformMatrix2fv(location, false, v)',\n    mat3: 'gl.uniformMatrix3fv(location, false, v)',\n    mat4: 'gl.uniformMatrix4fv(location, false, v)',\n    sampler2D: 'gl.uniform1i(location, v)',\n    samplerCube: 'gl.uniform1i(location, v)',\n    sampler2DArray: 'gl.uniform1i(location, v)',\n};\nvar GLSL_TO_ARRAY_SETTERS = {\n    float: \"gl.uniform1fv(location, v)\",\n    vec2: \"gl.uniform2fv(location, v)\",\n    vec3: \"gl.uniform3fv(location, v)\",\n    vec4: 'gl.uniform4fv(location, v)',\n    mat4: 'gl.uniformMatrix4fv(location, false, v)',\n    mat3: 'gl.uniformMatrix3fv(location, false, v)',\n    mat2: 'gl.uniformMatrix2fv(location, false, v)',\n    int: 'gl.uniform1iv(location, v)',\n    ivec2: 'gl.uniform2iv(location, v)',\n    ivec3: 'gl.uniform3iv(location, v)',\n    ivec4: 'gl.uniform4iv(location, v)',\n    bool: 'gl.uniform1iv(location, v)',\n    bvec2: 'gl.uniform2iv(location, v)',\n    bvec3: 'gl.uniform3iv(location, v)',\n    bvec4: 'gl.uniform4iv(location, v)',\n    sampler2D: 'gl.uniform1iv(location, v)',\n    samplerCube: 'gl.uniform1iv(location, v)',\n    sampler2DArray: 'gl.uniform1iv(location, v)',\n};\nfunction generateUniformsSync(group, uniformData) {\n    var funcFragments = [\"\\n        var v = null;\\n        var cv = null\\n        var t = 0;\\n        var gl = renderer.gl\\n    \"];\n    for (var i in group.uniforms) {\n        var data = uniformData[i];\n        if (!data) {\n            if (group.uniforms[i].group) {\n                funcFragments.push(\"\\n                    renderer.shader.syncUniformGroup(uv[\\\"\" + i + \"\\\"], syncData);\\n                \");\n            }\n            continue;\n        }\n        var uniform = group.uniforms[i];\n        var parsed = false;\n        for (var j = 0; j < uniformParsers.length; j++) {\n            if (uniformParsers[j].test(data, uniform)) {\n                funcFragments.push(uniformParsers[j].code(i, uniform));\n                parsed = true;\n                break;\n            }\n        }\n        if (!parsed) {\n            var templateType = (data.size === 1) ? GLSL_TO_SINGLE_SETTERS_CACHED : GLSL_TO_ARRAY_SETTERS;\n            var template = templateType[data.type].replace('location', \"ud[\\\"\" + i + \"\\\"].location\");\n            funcFragments.push(\"\\n            cv = ud[\\\"\" + i + \"\\\"].value;\\n            v = uv[\\\"\" + i + \"\\\"];\\n            \" + template + \";\");\n        }\n    }\n    /**\n     * the introduction of syncData is to solve an issue where textures in uniform groups are not set correctly\n     * the texture count was always starting from 0 in each group. This needs to increment each time a texture is used\n     * no matter which group is being used\n     *\n     */\n    // eslint-disable-next-line no-new-func\n    return new Function('ud', 'uv', 'renderer', 'syncData', funcFragments.join('\\n'));\n}\n\nvar fragTemplate = [\n    'precision mediump float;',\n    'void main(void){',\n    'float test = 0.1;',\n    '%forloop%',\n    'gl_FragColor = vec4(0.0);',\n    '}' ].join('\\n');\nfunction generateIfTestSrc(maxIfs) {\n    var src = '';\n    for (var i = 0; i < maxIfs; ++i) {\n        if (i > 0) {\n            src += '\\nelse ';\n        }\n        if (i < maxIfs - 1) {\n            src += \"if(test == \" + i + \".0){}\";\n        }\n    }\n    return src;\n}\nfunction checkMaxIfStatementsInShader(maxIfs, gl) {\n    if (maxIfs === 0) {\n        throw new Error('Invalid value of `0` passed to `checkMaxIfStatementsInShader`');\n    }\n    var shader = gl.createShader(gl.FRAGMENT_SHADER);\n    while (true) // eslint-disable-line no-constant-condition\n     {\n        var fragmentSrc = fragTemplate.replace(/%forloop%/gi, generateIfTestSrc(maxIfs));\n        gl.shaderSource(shader, fragmentSrc);\n        gl.compileShader(shader);\n        if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {\n            maxIfs = (maxIfs / 2) | 0;\n        }\n        else {\n            // valid!\n            break;\n        }\n    }\n    return maxIfs;\n}\n\n// Cache the result to prevent running this over and over\nvar unsafeEval;\n/**\n * Not all platforms allow to generate function code (e.g., `new Function`).\n * this provides the platform-level detection.\n *\n * @private\n * @returns {boolean}\n */\nfunction unsafeEvalSupported() {\n    if (typeof unsafeEval === 'boolean') {\n        return unsafeEval;\n    }\n    try {\n        /* eslint-disable no-new-func */\n        var func = new Function('param1', 'param2', 'param3', 'return param1[param2] === param3;');\n        /* eslint-enable no-new-func */\n        unsafeEval = func({ a: 'b' }, 'a', 'b') === true;\n    }\n    catch (e) {\n        unsafeEval = false;\n    }\n    return unsafeEval;\n}\n\nvar defaultFragment = \"varying vec2 vTextureCoord;\\n\\nuniform sampler2D uSampler;\\n\\nvoid main(void){\\n   gl_FragColor *= texture2D(uSampler, vTextureCoord);\\n}\";\n\nvar defaultVertex = \"attribute vec2 aVertexPosition;\\nattribute vec2 aTextureCoord;\\n\\nuniform mat3 projectionMatrix;\\n\\nvarying vec2 vTextureCoord;\\n\\nvoid main(void){\\n   gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\\n   vTextureCoord = aTextureCoord;\\n}\\n\";\n\nvar UID$3 = 0;\nvar nameCache = {};\n/**\n * Helper class to create a shader program.\n *\n * @class\n * @memberof PIXI\n */\nvar Program = /** @class */ (function () {\n    /**\n     * @param {string} [vertexSrc] - The source of the vertex shader.\n     * @param {string} [fragmentSrc] - The source of the fragment shader.\n     * @param {string} [name] - Name for shader\n     */\n    function Program(vertexSrc, fragmentSrc, name) {\n        if (name === void 0) { name = 'pixi-shader'; }\n        this.id = UID$3++;\n        /**\n         * The vertex shader.\n         *\n         * @member {string}\n         */\n        this.vertexSrc = vertexSrc || Program.defaultVertexSrc;\n        /**\n         * The fragment shader.\n         *\n         * @member {string}\n         */\n        this.fragmentSrc = fragmentSrc || Program.defaultFragmentSrc;\n        this.vertexSrc = this.vertexSrc.trim();\n        this.fragmentSrc = this.fragmentSrc.trim();\n        if (this.vertexSrc.substring(0, 8) !== '#version') {\n            name = name.replace(/\\s+/g, '-');\n            if (nameCache[name]) {\n                nameCache[name]++;\n                name += \"-\" + nameCache[name];\n            }\n            else {\n                nameCache[name] = 1;\n            }\n            this.vertexSrc = \"#define SHADER_NAME \" + name + \"\\n\" + this.vertexSrc;\n            this.fragmentSrc = \"#define SHADER_NAME \" + name + \"\\n\" + this.fragmentSrc;\n            this.vertexSrc = setPrecision(this.vertexSrc, _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PRECISION_VERTEX, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.PRECISION.HIGH);\n            this.fragmentSrc = setPrecision(this.fragmentSrc, _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PRECISION_FRAGMENT, getMaxFragmentPrecision());\n        }\n        // currently this does not extract structs only default types\n        this.extractData(this.vertexSrc, this.fragmentSrc);\n        // this is where we store shader references..\n        this.glPrograms = {};\n        this.syncUniforms = null;\n    }\n    /**\n     * Extracts the data for a buy creating a small test program\n     * or reading the src directly.\n     * @protected\n     *\n     * @param {string} [vertexSrc] - The source of the vertex shader.\n     * @param {string} [fragmentSrc] - The source of the fragment shader.\n     */\n    Program.prototype.extractData = function (vertexSrc, fragmentSrc) {\n        var gl = getTestContext();\n        if (gl) {\n            var program = compileProgram(gl, vertexSrc, fragmentSrc);\n            this.attributeData = this.getAttributeData(program, gl);\n            this.uniformData = this.getUniformData(program, gl);\n            gl.deleteProgram(program);\n        }\n        else {\n            this.uniformData = {};\n            this.attributeData = {};\n        }\n    };\n    /**\n     * returns the attribute data from the program\n     * @private\n     *\n     * @param {WebGLProgram} [program] - the WebGL program\n     * @param {WebGLRenderingContext} [gl] - the WebGL context\n     *\n     * @returns {object} the attribute data for this program\n     */\n    Program.prototype.getAttributeData = function (program, gl) {\n        var attributes = {};\n        var attributesArray = [];\n        var totalAttributes = gl.getProgramParameter(program, gl.ACTIVE_ATTRIBUTES);\n        for (var i = 0; i < totalAttributes; i++) {\n            var attribData = gl.getActiveAttrib(program, i);\n            var type = mapType(gl, attribData.type);\n            /*eslint-disable */\n            var data = {\n                type: type,\n                name: attribData.name,\n                size: mapSize(type),\n                location: 0,\n            };\n            /* eslint-enable */\n            attributes[attribData.name] = data;\n            attributesArray.push(data);\n        }\n        attributesArray.sort(function (a, b) { return (a.name > b.name) ? 1 : -1; }); // eslint-disable-line no-confusing-arrow\n        for (var i = 0; i < attributesArray.length; i++) {\n            attributesArray[i].location = i;\n        }\n        return attributes;\n    };\n    /**\n     * returns the uniform data from the program\n     * @private\n     *\n     * @param {webGL-program} [program] - the webgl program\n     * @param {context} [gl] - the WebGL context\n     *\n     * @returns {object} the uniform data for this program\n     */\n    Program.prototype.getUniformData = function (program, gl) {\n        var uniforms = {};\n        var totalUniforms = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);\n        // TODO expose this as a prop?\n        // const maskRegex = new RegExp('^(projectionMatrix|uSampler|translationMatrix)$');\n        // const maskRegex = new RegExp('^(projectionMatrix|uSampler|translationMatrix)$');\n        for (var i = 0; i < totalUniforms; i++) {\n            var uniformData = gl.getActiveUniform(program, i);\n            var name = uniformData.name.replace(/\\[.*?\\]$/, '');\n            var isArray = uniformData.name.match(/\\[.*?\\]$/);\n            var type = mapType(gl, uniformData.type);\n            /*eslint-disable */\n            uniforms[name] = {\n                type: type,\n                size: uniformData.size,\n                isArray: isArray,\n                value: defaultValue(type, uniformData.size),\n            };\n            /* eslint-enable */\n        }\n        return uniforms;\n    };\n    Object.defineProperty(Program, \"defaultVertexSrc\", {\n        /**\n         * The default vertex shader source\n         *\n         * @static\n         * @constant\n         * @member {string}\n         */\n        get: function () {\n            return defaultVertex;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Program, \"defaultFragmentSrc\", {\n        /**\n         * The default fragment shader source\n         *\n         * @static\n         * @constant\n         * @member {string}\n         */\n        get: function () {\n            return defaultFragment;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * A short hand function to create a program based of a vertex and fragment shader\n     * this method will also check to see if there is a cached program.\n     *\n     * @param {string} [vertexSrc] - The source of the vertex shader.\n     * @param {string} [fragmentSrc] - The source of the fragment shader.\n     * @param {string} [name=pixi-shader] - Name for shader\n     *\n     * @returns {PIXI.Program} an shiny new Pixi shader!\n     */\n    Program.from = function (vertexSrc, fragmentSrc, name) {\n        var key = vertexSrc + fragmentSrc;\n        var program = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.ProgramCache[key];\n        if (!program) {\n            _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.ProgramCache[key] = program = new Program(vertexSrc, fragmentSrc, name);\n        }\n        return program;\n    };\n    return Program;\n}());\n\n/**\n * A helper class for shaders\n *\n * @class\n * @memberof PIXI\n */\nvar Shader = /** @class */ (function () {\n    /**\n     * @param {PIXI.Program} [program] - The program the shader will use.\n     * @param {object} [uniforms] - Custom uniforms to use to augment the built-in ones.\n     */\n    function Shader(program, uniforms) {\n        /**\n         * Program that the shader uses\n         *\n         * @member {PIXI.Program}\n         */\n        this.program = program;\n        // lets see whats been passed in\n        // uniforms should be converted to a uniform group\n        if (uniforms) {\n            if (uniforms instanceof UniformGroup) {\n                this.uniformGroup = uniforms;\n            }\n            else {\n                this.uniformGroup = new UniformGroup(uniforms);\n            }\n        }\n        else {\n            this.uniformGroup = new UniformGroup({});\n        }\n        // time to build some getters and setters!\n        // I guess down the line this could sort of generate an instruction list rather than use dirty ids?\n        // does the trick for now though!\n        for (var i in program.uniformData) {\n            if (this.uniformGroup.uniforms[i] instanceof Array) {\n                this.uniformGroup.uniforms[i] = new Float32Array(this.uniformGroup.uniforms[i]);\n            }\n        }\n    }\n    // TODO move to shader system..\n    Shader.prototype.checkUniformExists = function (name, group) {\n        if (group.uniforms[name]) {\n            return true;\n        }\n        for (var i in group.uniforms) {\n            var uniform = group.uniforms[i];\n            if (uniform.group) {\n                if (this.checkUniformExists(name, uniform)) {\n                    return true;\n                }\n            }\n        }\n        return false;\n    };\n    Shader.prototype.destroy = function () {\n        // usage count on programs?\n        // remove if not used!\n        this.uniformGroup = null;\n    };\n    Object.defineProperty(Shader.prototype, \"uniforms\", {\n        /**\n         * Shader uniform values, shortcut for `uniformGroup.uniforms`\n         * @readonly\n         * @member {object}\n         */\n        get: function () {\n            return this.uniformGroup.uniforms;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * A short hand function to create a shader based of a vertex and fragment shader\n     *\n     * @param {string} [vertexSrc] - The source of the vertex shader.\n     * @param {string} [fragmentSrc] - The source of the fragment shader.\n     * @param {object} [uniforms] - Custom uniforms to use to augment the built-in ones.\n     *\n     * @returns {PIXI.Shader} an shiny new Pixi shader!\n     */\n    Shader.from = function (vertexSrc, fragmentSrc, uniforms) {\n        var program = Program.from(vertexSrc, fragmentSrc);\n        return new Shader(program, uniforms);\n    };\n    return Shader;\n}());\n\n/* eslint-disable max-len */\nvar BLEND = 0;\nvar OFFSET = 1;\nvar CULLING = 2;\nvar DEPTH_TEST = 3;\nvar WINDING = 4;\n/**\n * This is a WebGL state, and is is passed The WebGL StateManager.\n *\n * Each mesh rendered may require WebGL to be in a different state.\n * For example you may want different blend mode or to enable polygon offsets\n *\n * @class\n * @memberof PIXI\n */\nvar State = /** @class */ (function () {\n    function State() {\n        this.data = 0;\n        this.blendMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NORMAL;\n        this.polygonOffset = 0;\n        this.blend = true;\n        //  this.depthTest = true;\n    }\n    Object.defineProperty(State.prototype, \"blend\", {\n        /**\n         * Activates blending of the computed fragment color values\n         *\n         * @member {boolean}\n         */\n        get: function () {\n            return !!(this.data & (1 << BLEND));\n        },\n        set: function (value) {\n            if (!!(this.data & (1 << BLEND)) !== value) {\n                this.data ^= (1 << BLEND);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"offsets\", {\n        /**\n         * Activates adding an offset to depth values of polygon's fragments\n         *\n         * @member {boolean}\n         * @default false\n         */\n        get: function () {\n            return !!(this.data & (1 << OFFSET));\n        },\n        set: function (value) {\n            if (!!(this.data & (1 << OFFSET)) !== value) {\n                this.data ^= (1 << OFFSET);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"culling\", {\n        /**\n         * Activates culling of polygons.\n         *\n         * @member {boolean}\n         * @default false\n         */\n        get: function () {\n            return !!(this.data & (1 << CULLING));\n        },\n        set: function (value) {\n            if (!!(this.data & (1 << CULLING)) !== value) {\n                this.data ^= (1 << CULLING);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"depthTest\", {\n        /**\n         * Activates depth comparisons and updates to the depth buffer.\n         *\n         * @member {boolean}\n         * @default false\n         */\n        get: function () {\n            return !!(this.data & (1 << DEPTH_TEST));\n        },\n        set: function (value) {\n            if (!!(this.data & (1 << DEPTH_TEST)) !== value) {\n                this.data ^= (1 << DEPTH_TEST);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"clockwiseFrontFace\", {\n        /**\n         * Specifies whether or not front or back-facing polygons can be culled.\n         * @member {boolean}\n         * @default false\n         */\n        get: function () {\n            return !!(this.data & (1 << WINDING));\n        },\n        set: function (value) {\n            if (!!(this.data & (1 << WINDING)) !== value) {\n                this.data ^= (1 << WINDING);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"blendMode\", {\n        /**\n         * The blend mode to be applied when this state is set. Apply a value of `PIXI.BLEND_MODES.NORMAL` to reset the blend mode.\n         * Setting this mode to anything other than NO_BLEND will automatically switch blending on.\n         *\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NORMAL\n         * @see PIXI.BLEND_MODES\n         */\n        get: function () {\n            return this._blendMode;\n        },\n        set: function (value) {\n            this.blend = (value !== _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NONE);\n            this._blendMode = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(State.prototype, \"polygonOffset\", {\n        /**\n         * The polygon offset. Setting this property to anything other than 0 will automatically enable polygon offset fill.\n         *\n         * @member {number}\n         * @default 0\n         */\n        get: function () {\n            return this._polygonOffset;\n        },\n        set: function (value) {\n            this.offsets = !!value;\n            this._polygonOffset = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    State.for2d = function () {\n        var state = new State();\n        state.depthTest = false;\n        state.blend = true;\n        return state;\n    };\n    return State;\n}());\n\nvar defaultVertex$1 = \"attribute vec2 aVertexPosition;\\n\\nuniform mat3 projectionMatrix;\\n\\nvarying vec2 vTextureCoord;\\n\\nuniform vec4 inputSize;\\nuniform vec4 outputFrame;\\n\\nvec4 filterVertexPosition( void )\\n{\\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\\n\\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\\n}\\n\\nvec2 filterTextureCoord( void )\\n{\\n    return aVertexPosition * (outputFrame.zw * inputSize.zw);\\n}\\n\\nvoid main(void)\\n{\\n    gl_Position = filterVertexPosition();\\n    vTextureCoord = filterTextureCoord();\\n}\\n\";\n\nvar defaultFragment$1 = \"varying vec2 vTextureCoord;\\n\\nuniform sampler2D uSampler;\\n\\nvoid main(void){\\n   gl_FragColor = texture2D(uSampler, vTextureCoord);\\n}\\n\";\n\n/**\n * Filter is a special type of WebGL shader that is applied to the screen.\n *\n * {@link http://pixijs.io/examples/#/filters/blur-filter.js Example} of the\n * {@link PIXI.filters.BlurFilter BlurFilter}.\n *\n * ### Usage\n * Filters can be applied to any DisplayObject or Container.\n * PixiJS' `FilterSystem` renders the container into temporary Framebuffer,\n * then filter renders it to the screen.\n * Multiple filters can be added to the `filters` array property and stacked on each other.\n *\n * ```\n * const filter = new PIXI.Filter(myShaderVert, myShaderFrag, { myUniform: 0.5 });\n * const container = new PIXI.Container();\n * container.filters = [filter];\n * ```\n *\n * ### Previous Version Differences\n *\n * In PixiJS **v3**, a filter was always applied to _whole screen_.\n *\n * In PixiJS **v4**, a filter can be applied _only part of the screen_.\n * Developers had to create a set of uniforms to deal with coordinates.\n *\n * In PixiJS **v5** combines _both approaches_.\n * Developers can use normal coordinates of v3 and then allow filter to use partial Framebuffers,\n * bringing those extra uniforms into account.\n *\n * Also be aware that we have changed default vertex shader, please consult\n * {@link https://github.com/pixijs/pixi.js/wiki/v5-Creating-filters Wiki}.\n *\n * ### Built-in Uniforms\n *\n * PixiJS viewport uses screen (CSS) coordinates, `(0, 0, renderer.screen.width, renderer.screen.height)`,\n * and `projectionMatrix` uniform maps it to the gl viewport.\n *\n * **uSampler**\n *\n * The most important uniform is the input texture that container was rendered into.\n * _Important note: as with all Framebuffers in PixiJS, both input and output are\n * premultiplied by alpha._\n *\n * By default, input normalized coordinates are passed to fragment shader with `vTextureCoord`.\n * Use it to sample the input.\n *\n * ```\n * const fragment = `\n * varying vec2 vTextureCoord;\n * uniform sampler2D uSampler;\n * void main(void)\n * {\n *    gl_FragColor = texture2D(uSampler, vTextureCoord);\n * }\n * `;\n *\n * const myFilter = new PIXI.Filter(null, fragment);\n * ```\n *\n * This filter is just one uniform less than {@link PIXI.filters.AlphaFilter AlphaFilter}.\n *\n * **outputFrame**\n *\n * The `outputFrame` holds the rectangle where filter is applied in screen (CSS) coordinates.\n * It's the same as `renderer.screen` for a fullscreen filter.\n * Only a part of  `outputFrame.zw` size of temporary Framebuffer is used,\n * `(0, 0, outputFrame.width, outputFrame.height)`,\n *\n * Filters uses this quad to normalized (0-1) space, its passed into `aVertexPosition` attribute.\n * To calculate vertex position in screen space using normalized (0-1) space:\n *\n * ```\n * vec4 filterVertexPosition( void )\n * {\n *     vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\n *     return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\n * }\n * ```\n *\n * **inputSize**\n *\n * Temporary framebuffer is different, it can be either the size of screen, either power-of-two.\n * The `inputSize.xy` are size of temporary framebuffer that holds input.\n * The `inputSize.zw` is inverted, it's a shortcut to evade division inside the shader.\n *\n * Set `inputSize.xy = outputFrame.zw` for a fullscreen filter.\n *\n * To calculate input normalized coordinate, you have to map it to filter normalized space.\n * Multiply by `outputFrame.zw` to get input coordinate.\n * Divide by `inputSize.xy` to get input normalized coordinate.\n *\n * ```\n * vec2 filterTextureCoord( void )\n * {\n *     return aVertexPosition * (outputFrame.zw * inputSize.zw); // same as /inputSize.xy\n * }\n * ```\n * **resolution**\n *\n * The `resolution` is the ratio of screen (CSS) pixels to real pixels.\n *\n * **inputPixel**\n *\n * `inputPixel.xy` is the size of framebuffer in real pixels, same as `inputSize.xy * resolution`\n * `inputPixel.zw` is inverted `inputPixel.xy`.\n *\n * It's handy for filters that use neighbour pixels, like {@link PIXI.filters.FXAAFilter FXAAFilter}.\n *\n * **inputClamp**\n *\n * If you try to get info from outside of used part of Framebuffer - you'll get undefined behaviour.\n * For displacements, coordinates has to be clamped.\n *\n * The `inputClamp.xy` is left-top pixel center, you may ignore it, because we use left-top part of Framebuffer\n * `inputClamp.zw` is bottom-right pixel center.\n *\n * ```\n * vec4 color = texture2D(uSampler, clamp(modifigedTextureCoord, inputClamp.xy, inputClamp.zw))\n * ```\n * OR\n * ```\n * vec4 color = texture2D(uSampler, min(modifigedTextureCoord, inputClamp.zw))\n * ```\n *\n * ### Additional Information\n *\n * Complete documentation on Filter usage is located in the\n * {@link https://github.com/pixijs/pixi.js/wiki/v5-Creating-filters Wiki}.\n *\n * Since PixiJS only had a handful of built-in filters, additional filters can be downloaded\n * {@link https://github.com/pixijs/pixi-filters here} from the PixiJS Filters repository.\n *\n * @class\n * @memberof PIXI\n * @extends PIXI.Shader\n */\nvar Filter = /** @class */ (function (_super) {\n    __extends(Filter, _super);\n    /**\n     * @param {string} [vertexSrc] - The source of the vertex shader.\n     * @param {string} [fragmentSrc] - The source of the fragment shader.\n     * @param {object} [uniforms] - Custom uniforms to use to augment the built-in ones.\n     */\n    function Filter(vertexSrc, fragmentSrc, uniforms) {\n        var _this = this;\n        var program = Program.from(vertexSrc || Filter.defaultVertexSrc, fragmentSrc || Filter.defaultFragmentSrc);\n        _this = _super.call(this, program, uniforms) || this;\n        /**\n         * The padding of the filter. Some filters require extra space to breath such as a blur.\n         * Increasing this will add extra width and height to the bounds of the object that the\n         * filter is applied to.\n         *\n         * @member {number}\n         */\n        _this.padding = 0;\n        /**\n         * The resolution of the filter. Setting this to be lower will lower the quality but\n         * increase the performance of the filter.\n         *\n         * @member {number}\n         */\n        _this.resolution = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.FILTER_RESOLUTION;\n        /**\n         * If enabled is true the filter is applied, if false it will not.\n         *\n         * @member {boolean}\n         */\n        _this.enabled = true;\n        /**\n         * If enabled, PixiJS will fit the filter area into boundaries for better performance.\n         * Switch it off if it does not work for specific shader.\n         *\n         * @member {boolean}\n         */\n        _this.autoFit = true;\n        /**\n         * Legacy filters use position and uvs from attributes\n         * @member {boolean}\n         * @readonly\n         */\n        _this.legacy = !!_this.program.attributeData.aTextureCoord;\n        /**\n         * The WebGL state the filter requires to render\n         * @member {PIXI.State}\n         */\n        _this.state = new State();\n        return _this;\n    }\n    /**\n     * Applies the filter\n     *\n     * @param {PIXI.systems.FilterSystem} filterManager - The renderer to retrieve the filter from\n     * @param {PIXI.RenderTexture} input - The input render target.\n     * @param {PIXI.RenderTexture} output - The target to output to.\n     * @param {PIXI.CLEAR_MODES} clearMode - Should the output be cleared before rendering to it.\n     * @param {object} [currentState] - It's current state of filter.\n     *        There are some useful properties in the currentState :\n     *        target, filters, sourceFrame, destinationFrame, renderTarget, resolution\n     */\n    Filter.prototype.apply = function (filterManager, input, output, clearMode, _currentState) {\n        // do as you please!\n        filterManager.applyFilter(this, input, output, clearMode);\n        // or just do a regular render..\n    };\n    Object.defineProperty(Filter.prototype, \"blendMode\", {\n        /**\n         * Sets the blendmode of the filter\n         *\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NORMAL\n         */\n        get: function () {\n            return this.state.blendMode;\n        },\n        set: function (value) {\n            this.state.blendMode = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Filter, \"defaultVertexSrc\", {\n        /**\n         * The default vertex shader source\n         *\n         * @static\n         * @type {string}\n         * @constant\n         */\n        get: function () {\n            return defaultVertex$1;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Filter, \"defaultFragmentSrc\", {\n        /**\n         * The default fragment shader source\n         *\n         * @static\n         * @type {string}\n         * @constant\n         */\n        get: function () {\n            return defaultFragment$1;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return Filter;\n}(Shader));\n\nvar vertex = \"attribute vec2 aVertexPosition;\\nattribute vec2 aTextureCoord;\\n\\nuniform mat3 projectionMatrix;\\nuniform mat3 otherMatrix;\\n\\nvarying vec2 vMaskCoord;\\nvarying vec2 vTextureCoord;\\n\\nvoid main(void)\\n{\\n    gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\\n\\n    vTextureCoord = aTextureCoord;\\n    vMaskCoord = ( otherMatrix * vec3( aTextureCoord, 1.0)  ).xy;\\n}\\n\";\n\nvar fragment = \"varying vec2 vMaskCoord;\\nvarying vec2 vTextureCoord;\\n\\nuniform sampler2D uSampler;\\nuniform sampler2D mask;\\nuniform float alpha;\\nuniform float npmAlpha;\\nuniform vec4 maskClamp;\\n\\nvoid main(void)\\n{\\n    float clip = step(3.5,\\n        step(maskClamp.x, vMaskCoord.x) +\\n        step(maskClamp.y, vMaskCoord.y) +\\n        step(vMaskCoord.x, maskClamp.z) +\\n        step(vMaskCoord.y, maskClamp.w));\\n\\n    vec4 original = texture2D(uSampler, vTextureCoord);\\n    vec4 masky = texture2D(mask, vMaskCoord);\\n    float alphaMul = 1.0 - npmAlpha * (1.0 - masky.a);\\n\\n    original *= (alphaMul * masky.r * alpha * clip);\\n\\n    gl_FragColor = original;\\n}\\n\";\n\nvar tempMat = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix();\n/**\n * Class controls uv mapping from Texture normal space to BaseTexture normal space.\n *\n * Takes `trim` and `rotate` into account. May contain clamp settings for Meshes and TilingSprite.\n *\n * Can be used in Texture `uvMatrix` field, or separately, you can use different clamp settings on the same texture.\n * If you want to add support for texture region of certain feature or filter, that's what you're looking for.\n *\n * Takes track of Texture changes through `_lastTextureID` private field.\n * Use `update()` method call to track it from outside.\n *\n * @see PIXI.Texture\n * @see PIXI.Mesh\n * @see PIXI.TilingSprite\n * @class\n * @memberof PIXI\n */\nvar TextureMatrix = /** @class */ (function () {\n    /**\n     *\n     * @param {PIXI.Texture} texture - observed texture\n     * @param {number} [clampMargin] - Changes frame clamping, 0.5 by default. Use -0.5 for extra border.\n     * @constructor\n     */\n    function TextureMatrix(texture, clampMargin) {\n        this._texture = texture;\n        /**\n         * Matrix operation that converts texture region coords to texture coords\n         * @member {PIXI.Matrix}\n         * @readonly\n         */\n        this.mapCoord = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix();\n        /**\n         * Clamp region for normalized coords, left-top pixel center in xy , bottom-right in zw.\n         * Calculated based on clampOffset.\n         * @member {Float32Array}\n         * @readonly\n         */\n        this.uClampFrame = new Float32Array(4);\n        /**\n         * Normalized clamp offset.\n         * Calculated based on clampOffset.\n         * @member {Float32Array}\n         * @readonly\n         */\n        this.uClampOffset = new Float32Array(2);\n        /**\n         * Tracks Texture frame changes\n         * @member {number}\n         * @protected\n         */\n        this._textureID = -1;\n        /**\n         * Tracks Texture frame changes\n         * @member {number}\n         * @protected\n         */\n        this._updateID = 0;\n        /**\n         * Changes frame clamping\n         * Works with TilingSprite and Mesh\n         * Change to 1.5 if you texture has repeated right and bottom lines, that leads to smoother borders\n         *\n         * @default 0\n         * @member {number}\n         */\n        this.clampOffset = 0;\n        /**\n         * Changes frame clamping\n         * Works with TilingSprite and Mesh\n         * Change to -0.5 to add a pixel to the edge, recommended for transparent trimmed textures in atlas\n         *\n         * @default 0.5\n         * @member {number}\n         */\n        this.clampMargin = (typeof clampMargin === 'undefined') ? 0.5 : clampMargin;\n        /**\n         * If texture size is the same as baseTexture\n         * @member {boolean}\n         * @default false\n         * @readonly\n         */\n        this.isSimple = false;\n    }\n    Object.defineProperty(TextureMatrix.prototype, \"texture\", {\n        /**\n         * texture property\n         * @member {PIXI.Texture}\n         */\n        get: function () {\n            return this._texture;\n        },\n        set: function (value) {\n            this._texture = value;\n            this._textureID = -1;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Multiplies uvs array to transform\n     * @param {Float32Array} uvs - mesh uvs\n     * @param {Float32Array} [out=uvs] output\n     * @returns {Float32Array} output\n     */\n    TextureMatrix.prototype.multiplyUvs = function (uvs, out) {\n        if (out === undefined) {\n            out = uvs;\n        }\n        var mat = this.mapCoord;\n        for (var i = 0; i < uvs.length; i += 2) {\n            var x = uvs[i];\n            var y = uvs[i + 1];\n            out[i] = (x * mat.a) + (y * mat.c) + mat.tx;\n            out[i + 1] = (x * mat.b) + (y * mat.d) + mat.ty;\n        }\n        return out;\n    };\n    /**\n     * updates matrices if texture was changed\n     * @param {boolean} [forceUpdate=false] - if true, matrices will be updated any case\n     * @returns {boolean} whether or not it was updated\n     */\n    TextureMatrix.prototype.update = function (forceUpdate) {\n        var tex = this._texture;\n        if (!tex || !tex.valid) {\n            return false;\n        }\n        if (!forceUpdate\n            && this._textureID === tex._updateID) {\n            return false;\n        }\n        this._textureID = tex._updateID;\n        this._updateID++;\n        var uvs = tex._uvs;\n        this.mapCoord.set(uvs.x1 - uvs.x0, uvs.y1 - uvs.y0, uvs.x3 - uvs.x0, uvs.y3 - uvs.y0, uvs.x0, uvs.y0);\n        var orig = tex.orig;\n        var trim = tex.trim;\n        if (trim) {\n            tempMat.set(orig.width / trim.width, 0, 0, orig.height / trim.height, -trim.x / trim.width, -trim.y / trim.height);\n            this.mapCoord.append(tempMat);\n        }\n        var texBase = tex.baseTexture;\n        var frame = this.uClampFrame;\n        var margin = this.clampMargin / texBase.resolution;\n        var offset = this.clampOffset;\n        frame[0] = (tex._frame.x + margin + offset) / texBase.width;\n        frame[1] = (tex._frame.y + margin + offset) / texBase.height;\n        frame[2] = (tex._frame.x + tex._frame.width - margin + offset) / texBase.width;\n        frame[3] = (tex._frame.y + tex._frame.height - margin + offset) / texBase.height;\n        this.uClampOffset[0] = offset / texBase.realWidth;\n        this.uClampOffset[1] = offset / texBase.realHeight;\n        this.isSimple = tex._frame.width === texBase.width\n            && tex._frame.height === texBase.height\n            && tex.rotate === 0;\n        return true;\n    };\n    return TextureMatrix;\n}());\n\n/**\n * This handles a Sprite acting as a mask, as opposed to a Graphic.\n *\n * WebGL only.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI\n */\nvar SpriteMaskFilter = /** @class */ (function (_super) {\n    __extends(SpriteMaskFilter, _super);\n    /**\n     * @param {PIXI.Sprite} sprite - the target sprite\n     */\n    function SpriteMaskFilter(sprite) {\n        var _this = this;\n        var maskMatrix = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix();\n        _this = _super.call(this, vertex, fragment) || this;\n        sprite.renderable = false;\n        /**\n         * Sprite mask\n         * @member {PIXI.Sprite}\n         */\n        _this.maskSprite = sprite;\n        /**\n         * Mask matrix\n         * @member {PIXI.Matrix}\n         */\n        _this.maskMatrix = maskMatrix;\n        return _this;\n    }\n    /**\n     * Applies the filter\n     *\n     * @param {PIXI.systems.FilterSystem} filterManager - The renderer to retrieve the filter from\n     * @param {PIXI.RenderTexture} input - The input render target.\n     * @param {PIXI.RenderTexture} output - The target to output to.\n     * @param {PIXI.CLEAR_MODES} clearMode - Should the output be cleared before rendering to it.\n     */\n    SpriteMaskFilter.prototype.apply = function (filterManager, input, output, clearMode) {\n        var maskSprite = this.maskSprite;\n        var tex = maskSprite._texture;\n        if (!tex.valid) {\n            return;\n        }\n        if (!tex.uvMatrix) {\n            // margin = 0.0, let it bleed a bit, shader code becomes easier\n            // assuming that atlas textures were made with 1-pixel padding\n            tex.uvMatrix = new TextureMatrix(tex, 0.0);\n        }\n        tex.uvMatrix.update();\n        this.uniforms.npmAlpha = tex.baseTexture.alphaMode ? 0.0 : 1.0;\n        this.uniforms.mask = tex;\n        // get _normalized sprite texture coords_ and convert them to _normalized atlas texture coords_ with `prepend`\n        this.uniforms.otherMatrix = filterManager.calculateSpriteMatrix(this.maskMatrix, maskSprite)\n            .prepend(tex.uvMatrix.mapCoord);\n        this.uniforms.alpha = maskSprite.worldAlpha;\n        this.uniforms.maskClamp = tex.uvMatrix.uClampFrame;\n        filterManager.applyFilter(this, input, output, clearMode);\n    };\n    return SpriteMaskFilter;\n}(Filter));\n\n/**\n * System plugin to the renderer to manage masks.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar MaskSystem = /** @class */ (function (_super) {\n    __extends(MaskSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function MaskSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * Enable scissor\n         * @member {boolean}\n         * @readonly\n         */\n        _this.enableScissor = false;\n        /**\n         * Pool of used sprite mask filters\n         * @member {PIXI.SpriteMaskFilter[]}\n         * @readonly\n         */\n        _this.alphaMaskPool = [];\n        /**\n         * Pool of mask data\n         * @member {PIXI.MaskData[]}\n         * @readonly\n         */\n        _this.maskDataPool = [];\n        _this.maskStack = [];\n        /**\n         * Current index of alpha mask pool\n         * @member {number}\n         * @default 0\n         * @readonly\n         */\n        _this.alphaMaskIndex = 0;\n        return _this;\n    }\n    /**\n     * Changes the mask stack that is used by this System.\n     *\n     * @param {PIXI.MaskData[]} maskStack - The mask stack\n     */\n    MaskSystem.prototype.setMaskStack = function (maskStack) {\n        this.maskStack = maskStack;\n        this.renderer.scissor.setMaskStack(maskStack);\n        this.renderer.stencil.setMaskStack(maskStack);\n    };\n    /**\n     * Applies the Mask and adds it to the current filter stack.\n     * Renderer batch must be flushed beforehand.\n     *\n     * @param {PIXI.DisplayObject} target - Display Object to push the mask to\n     * @param {PIXI.MaskData|PIXI.Sprite|PIXI.Graphics|PIXI.DisplayObject} maskData - The masking data.\n     */\n    MaskSystem.prototype.push = function (target, maskDataOrTarget) {\n        var maskData = maskDataOrTarget;\n        if (!maskData.isMaskData) {\n            var d = this.maskDataPool.pop() || new MaskData();\n            d.pooled = true;\n            d.maskObject = maskDataOrTarget;\n            maskData = d;\n        }\n        if (maskData.autoDetect) {\n            this.detect(maskData);\n        }\n        maskData.copyCountersOrReset(this.maskStack[this.maskStack.length - 1]);\n        maskData._target = target;\n        switch (maskData.type) {\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SCISSOR:\n                this.maskStack.push(maskData);\n                this.renderer.scissor.push(maskData);\n                break;\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.STENCIL:\n                this.maskStack.push(maskData);\n                this.renderer.stencil.push(maskData);\n                break;\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SPRITE:\n                maskData.copyCountersOrReset(null);\n                this.pushSpriteMask(maskData);\n                this.maskStack.push(maskData);\n                break;\n            default:\n                break;\n        }\n    };\n    /**\n     * Removes the last mask from the mask stack and doesn't return it.\n     * Renderer batch must be flushed beforehand.\n     *\n     * @param {PIXI.DisplayObject} target - Display Object to pop the mask from\n     */\n    MaskSystem.prototype.pop = function (target) {\n        var maskData = this.maskStack.pop();\n        if (!maskData || maskData._target !== target) {\n            // TODO: add an assert when we have it\n            return;\n        }\n        switch (maskData.type) {\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SCISSOR:\n                this.renderer.scissor.pop();\n                break;\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.STENCIL:\n                this.renderer.stencil.pop(maskData.maskObject);\n                break;\n            case _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SPRITE:\n                this.popSpriteMask();\n                break;\n            default:\n                break;\n        }\n        maskData.reset();\n        if (maskData.pooled) {\n            this.maskDataPool.push(maskData);\n        }\n    };\n    /**\n     * Sets type of MaskData based on its maskObject\n     * @param {PIXI.MaskData} maskData\n     */\n    MaskSystem.prototype.detect = function (maskData) {\n        var maskObject = maskData.maskObject;\n        if (maskObject.isSprite) {\n            maskData.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SPRITE;\n            return;\n        }\n        maskData.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.STENCIL;\n        // detect scissor in graphics\n        if (this.enableScissor\n            && maskObject.isFastRect\n            && maskObject.isFastRect()) {\n            var matrix = maskObject.worldTransform;\n            // TODO: move the check to the matrix itself\n            // we are checking that its orthogonal and x rotation is 0 90 180 or 270\n            var rotX = Math.atan2(matrix.b, matrix.a);\n            var rotXY = Math.atan2(matrix.d, matrix.c);\n            // use the nearest degree to 0.01\n            rotX = Math.round(rotX * (180 / Math.PI) * 100);\n            rotXY = Math.round(rotXY * (180 / Math.PI) * 100) - rotX;\n            rotX = ((rotX % 9000) + 9000) % 9000;\n            rotXY = ((rotXY % 18000) + 18000) % 18000;\n            if (rotX === 0 && rotXY === 9000) {\n                maskData.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MASK_TYPES.SCISSOR;\n            }\n        }\n    };\n    /**\n     * Applies the Mask and adds it to the current filter stack.\n     *\n     * @param {PIXI.MaskData} maskData - Sprite to be used as the mask\n     */\n    MaskSystem.prototype.pushSpriteMask = function (maskData) {\n        var maskObject = maskData.maskObject;\n        var target = maskData._target;\n        var alphaMaskFilter = this.alphaMaskPool[this.alphaMaskIndex];\n        if (!alphaMaskFilter) {\n            alphaMaskFilter = this.alphaMaskPool[this.alphaMaskIndex] = [new SpriteMaskFilter(maskObject)];\n        }\n        alphaMaskFilter[0].resolution = this.renderer.resolution;\n        alphaMaskFilter[0].maskSprite = maskObject;\n        var stashFilterArea = target.filterArea;\n        target.filterArea = maskObject.getBounds(true);\n        this.renderer.filter.push(target, alphaMaskFilter);\n        target.filterArea = stashFilterArea;\n        this.alphaMaskIndex++;\n    };\n    /**\n     * Removes the last filter from the filter stack and doesn't return it.\n     */\n    MaskSystem.prototype.popSpriteMask = function () {\n        this.renderer.filter.pop();\n        this.alphaMaskIndex--;\n    };\n    return MaskSystem;\n}(System));\n\n/**\n * System plugin to the renderer to manage masks of certain type\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar AbstractMaskSystem = /** @class */ (function (_super) {\n    __extends(AbstractMaskSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function AbstractMaskSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * The mask stack\n         * @member {PIXI.MaskData[]}\n         */\n        _this.maskStack = [];\n        /**\n         * Constant for gl.enable\n         * @member {number}\n         * @private\n         */\n        _this.glConst = 0;\n        return _this;\n    }\n    /**\n     * gets count of masks of certain type\n     * @returns {number}\n     */\n    AbstractMaskSystem.prototype.getStackLength = function () {\n        return this.maskStack.length;\n    };\n    /**\n     * Changes the mask stack that is used by this System.\n     *\n     * @param {PIXI.MaskData[]} maskStack - The mask stack\n     */\n    AbstractMaskSystem.prototype.setMaskStack = function (maskStack) {\n        var gl = this.renderer.gl;\n        var curStackLen = this.getStackLength();\n        this.maskStack = maskStack;\n        var newStackLen = this.getStackLength();\n        if (newStackLen !== curStackLen) {\n            if (newStackLen === 0) {\n                gl.disable(this.glConst);\n            }\n            else {\n                gl.enable(this.glConst);\n                this._useCurrent();\n            }\n        }\n    };\n    /**\n     * Setup renderer to use the current mask data.\n     * @private\n     */\n    AbstractMaskSystem.prototype._useCurrent = function () {\n        // OVERWRITE;\n    };\n    /**\n     * Destroys the mask stack.\n     *\n     */\n    AbstractMaskSystem.prototype.destroy = function () {\n        _super.prototype.destroy.call(this);\n        this.maskStack = null;\n    };\n    return AbstractMaskSystem;\n}(System));\n\n/**\n * System plugin to the renderer to manage scissor rects (used for masks).\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar ScissorSystem = /** @class */ (function (_super) {\n    __extends(ScissorSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function ScissorSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        _this.glConst = WebGLRenderingContext.SCISSOR_TEST;\n        return _this;\n    }\n    ScissorSystem.prototype.getStackLength = function () {\n        var maskData = this.maskStack[this.maskStack.length - 1];\n        if (maskData) {\n            return maskData._scissorCounter;\n        }\n        return 0;\n    };\n    /**\n     * Applies the Mask and adds it to the current stencil stack. @alvin\n     *\n     * @param {PIXI.MaskData} maskData - The mask data\n     */\n    ScissorSystem.prototype.push = function (maskData) {\n        var maskObject = maskData.maskObject;\n        maskObject.renderable = true;\n        var prevData = maskData._scissorRect;\n        var bounds = maskObject.getBounds(true);\n        var gl = this.renderer.gl;\n        maskObject.renderable = false;\n        if (prevData) {\n            bounds.fit(prevData);\n        }\n        else {\n            gl.enable(gl.SCISSOR_TEST);\n        }\n        maskData._scissorCounter++;\n        maskData._scissorRect = bounds;\n        this._useCurrent();\n    };\n    /**\n     * Pops scissor mask. MaskData is already removed from stack\n     */\n    ScissorSystem.prototype.pop = function () {\n        var gl = this.renderer.gl;\n        if (this.getStackLength() > 0) {\n            this._useCurrent();\n        }\n        else {\n            gl.disable(gl.SCISSOR_TEST);\n        }\n    };\n    /**\n     * Setup renderer to use the current scissor data.\n     * @private\n     */\n    ScissorSystem.prototype._useCurrent = function () {\n        var rect = this.maskStack[this.maskStack.length - 1]._scissorRect;\n        var rt = this.renderer.renderTexture.current;\n        var _a = this.renderer.projection, transform = _a.transform, sourceFrame = _a.sourceFrame, destinationFrame = _a.destinationFrame;\n        var resolution = rt ? rt.resolution : this.renderer.resolution;\n        var x = ((rect.x - sourceFrame.x) * resolution) + destinationFrame.x;\n        var y = ((rect.y - sourceFrame.y) * resolution) + destinationFrame.y;\n        var width = rect.width * resolution;\n        var height = rect.height * resolution;\n        if (transform) {\n            x += transform.tx * resolution;\n            y += transform.ty * resolution;\n        }\n        if (!rt) {\n            // flipY. In future we'll have it over renderTextures as an option\n            y = this.renderer.height - height - y;\n        }\n        this.renderer.gl.scissor(x, y, width, height);\n    };\n    return ScissorSystem;\n}(AbstractMaskSystem));\n\n/**\n * System plugin to the renderer to manage stencils (used for masks).\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar StencilSystem = /** @class */ (function (_super) {\n    __extends(StencilSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function StencilSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        _this.glConst = WebGLRenderingContext.STENCIL_TEST;\n        return _this;\n    }\n    StencilSystem.prototype.getStackLength = function () {\n        var maskData = this.maskStack[this.maskStack.length - 1];\n        if (maskData) {\n            return maskData._stencilCounter;\n        }\n        return 0;\n    };\n    /**\n     * Applies the Mask and adds it to the current stencil stack.\n     *\n     * @param {PIXI.MaskData} maskData - The mask data\n     */\n    StencilSystem.prototype.push = function (maskData) {\n        var maskObject = maskData.maskObject;\n        var gl = this.renderer.gl;\n        var prevMaskCount = maskData._stencilCounter;\n        if (prevMaskCount === 0) {\n            // force use stencil texture in current framebuffer\n            this.renderer.framebuffer.forceStencil();\n            gl.enable(gl.STENCIL_TEST);\n        }\n        maskData._stencilCounter++;\n        // Increment the reference stencil value where the new mask overlaps with the old ones.\n        gl.colorMask(false, false, false, false);\n        gl.stencilFunc(gl.EQUAL, prevMaskCount, this._getBitwiseMask());\n        gl.stencilOp(gl.KEEP, gl.KEEP, gl.INCR);\n        maskObject.renderable = true;\n        maskObject.render(this.renderer);\n        this.renderer.batch.flush();\n        maskObject.renderable = false;\n        this._useCurrent();\n    };\n    /**\n     * Pops stencil mask. MaskData is already removed from stack\n     *\n     * @param {PIXI.DisplayObject} maskObject - object of popped mask data\n     */\n    StencilSystem.prototype.pop = function (maskObject) {\n        var gl = this.renderer.gl;\n        if (this.getStackLength() === 0) {\n            // the stack is empty!\n            gl.disable(gl.STENCIL_TEST);\n            gl.clear(gl.STENCIL_BUFFER_BIT);\n            gl.clearStencil(0);\n        }\n        else {\n            // Decrement the reference stencil value where the popped mask overlaps with the other ones\n            gl.colorMask(false, false, false, false);\n            gl.stencilOp(gl.KEEP, gl.KEEP, gl.DECR);\n            maskObject.renderable = true;\n            maskObject.render(this.renderer);\n            this.renderer.batch.flush();\n            maskObject.renderable = false;\n            this._useCurrent();\n        }\n    };\n    /**\n     * Setup renderer to use the current stencil data.\n     * @private\n     */\n    StencilSystem.prototype._useCurrent = function () {\n        var gl = this.renderer.gl;\n        gl.colorMask(true, true, true, true);\n        gl.stencilFunc(gl.EQUAL, this.getStackLength(), this._getBitwiseMask());\n        gl.stencilOp(gl.KEEP, gl.KEEP, gl.KEEP);\n    };\n    /**\n     * Fill 1s equal to the number of acitve stencil masks.\n     * @private\n     * @return {number} The bitwise mask.\n     */\n    StencilSystem.prototype._getBitwiseMask = function () {\n        return (1 << this.getStackLength()) - 1;\n    };\n    return StencilSystem;\n}(AbstractMaskSystem));\n\n/**\n * System plugin to the renderer to manage the projection matrix.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar ProjectionSystem = /** @class */ (function (_super) {\n    __extends(ProjectionSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function ProjectionSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * Destination frame\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        _this.destinationFrame = null;\n        /**\n         * Source frame\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        _this.sourceFrame = null;\n        /**\n         * Default destination frame\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        _this.defaultFrame = null;\n        /**\n         * Project matrix\n         * @member {PIXI.Matrix}\n         * @readonly\n         */\n        _this.projectionMatrix = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix();\n        /**\n         * A transform that will be appended to the projection matrix\n         * if null, nothing will be applied\n         * @member {PIXI.Matrix}\n         */\n        _this.transform = null;\n        return _this;\n    }\n    /**\n     * Updates the projection matrix based on a projection frame (which is a rectangle).\n     *\n     * Make sure to run `renderer.framebuffer.setViewport(destinationFrame)` after calling this.\n     *\n     * @param {PIXI.Rectangle} destinationFrame - The destination frame.\n     * @param {PIXI.Rectangle} sourceFrame - The source frame.\n     * @param {Number} resolution - Resolution\n     * @param {boolean} root - If is root\n     */\n    ProjectionSystem.prototype.update = function (destinationFrame, sourceFrame, resolution, root) {\n        this.destinationFrame = destinationFrame || this.destinationFrame || this.defaultFrame;\n        this.sourceFrame = sourceFrame || this.sourceFrame || destinationFrame;\n        // Calculate object-space to clip-space projection\n        this.calculateProjection(this.destinationFrame, this.sourceFrame, resolution, root);\n        if (this.transform) {\n            this.projectionMatrix.append(this.transform);\n        }\n        var renderer = this.renderer;\n        renderer.globalUniforms.uniforms.projectionMatrix = this.projectionMatrix;\n        renderer.globalUniforms.update();\n        // this will work for now\n        // but would be sweet to stick and even on the global uniforms..\n        if (renderer.shader.shader) {\n            renderer.shader.syncUniformGroup(renderer.shader.shader.uniforms.globals);\n        }\n    };\n    /**\n     * Updates the projection matrix based on a projection frame (which is a rectangle)\n     *\n     * @param {PIXI.Rectangle} destinationFrame - The destination frame.\n     * @param {PIXI.Rectangle} sourceFrame - The source frame.\n     * @param {Number} resolution - Resolution\n     * @param {boolean} root - If is root\n     */\n    ProjectionSystem.prototype.calculateProjection = function (_destinationFrame, sourceFrame, _resolution, root) {\n        var pm = this.projectionMatrix;\n        var sign = !root ? 1 : -1;\n        pm.identity();\n        pm.a = (1 / sourceFrame.width * 2);\n        pm.d = sign * (1 / sourceFrame.height * 2);\n        pm.tx = -1 - (sourceFrame.x * pm.a);\n        pm.ty = -sign - (sourceFrame.y * pm.d);\n    };\n    /**\n     * Sets the transform of the active render target to the given matrix\n     *\n     * @param {PIXI.Matrix} matrix - The transformation matrix\n     */\n    ProjectionSystem.prototype.setTransform = function (_matrix) {\n        // this._activeRenderTarget.transform = matrix;\n    };\n    return ProjectionSystem;\n}(System));\n\n// Temporary rectangle for assigned sourceFrame or destinationFrame\nvar tempRect = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n// Temporary rectangle for renderTexture destinationFrame\nvar tempRect2 = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n// Temporary rectangle for passing the framebuffer viewport\nvar viewportFrame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n/**\n * System plugin to the renderer to manage render textures.\n *\n * Should be added after FramebufferSystem\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar RenderTextureSystem = /** @class */ (function (_super) {\n    __extends(RenderTextureSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function RenderTextureSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * The clear background color as rgba\n         * @member {number[]}\n         */\n        _this.clearColor = renderer._backgroundColorRgba;\n        // TODO move this property somewhere else!\n        /**\n         * List of masks for the StencilSystem\n         * @member {PIXI.Graphics[]}\n         * @readonly\n         */\n        _this.defaultMaskStack = [];\n        // empty render texture?\n        /**\n         * Render texture\n         * @member {PIXI.RenderTexture}\n         * @readonly\n         */\n        _this.current = null;\n        /**\n         * Source frame\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        _this.sourceFrame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        /**\n         * Destination frame\n         * @member {PIXI.Rectangle}\n         * @readonly\n         */\n        _this.destinationFrame = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle();\n        return _this;\n    }\n    /**\n     * Bind the current render texture\n     *\n     * @param {PIXI.RenderTexture} [renderTexture] - RenderTexture to bind, by default its `null`, the screen\n     * @param {PIXI.Rectangle} [sourceFrame] - part of screen that is mapped to the renderTexture\n     * @param {PIXI.Rectangle} [destinationFrame] - part of renderTexture, by default it has the same size as sourceFrame\n     */\n    RenderTextureSystem.prototype.bind = function (renderTexture, sourceFrame, destinationFrame) {\n        if (renderTexture === void 0) { renderTexture = null; }\n        var renderer = this.renderer;\n        this.current = renderTexture;\n        var baseTexture;\n        var framebuffer;\n        var resolution;\n        if (renderTexture) {\n            baseTexture = renderTexture.baseTexture;\n            resolution = baseTexture.resolution;\n            if (!sourceFrame) {\n                tempRect.width = renderTexture.frame.width;\n                tempRect.height = renderTexture.frame.height;\n                sourceFrame = tempRect;\n            }\n            if (!destinationFrame) {\n                tempRect2.x = renderTexture.frame.x;\n                tempRect2.y = renderTexture.frame.y;\n                tempRect2.width = sourceFrame.width;\n                tempRect2.height = sourceFrame.height;\n                destinationFrame = tempRect2;\n            }\n            framebuffer = baseTexture.framebuffer;\n        }\n        else {\n            resolution = renderer.resolution;\n            if (!sourceFrame) {\n                tempRect.width = renderer.screen.width;\n                tempRect.height = renderer.screen.height;\n                sourceFrame = tempRect;\n            }\n            if (!destinationFrame) {\n                destinationFrame = tempRect;\n                destinationFrame.width = sourceFrame.width;\n                destinationFrame.height = sourceFrame.height;\n            }\n        }\n        viewportFrame.x = destinationFrame.x * resolution;\n        viewportFrame.y = destinationFrame.y * resolution;\n        viewportFrame.width = destinationFrame.width * resolution;\n        viewportFrame.height = destinationFrame.height * resolution;\n        this.renderer.framebuffer.bind(framebuffer, viewportFrame);\n        this.renderer.projection.update(destinationFrame, sourceFrame, resolution, !framebuffer);\n        if (renderTexture) {\n            this.renderer.mask.setMaskStack(baseTexture.maskStack);\n        }\n        else {\n            this.renderer.mask.setMaskStack(this.defaultMaskStack);\n        }\n        this.sourceFrame.copyFrom(sourceFrame);\n        this.destinationFrame.copyFrom(destinationFrame);\n    };\n    /**\n     * Erases the render texture and fills the drawing area with a colour\n     *\n     * @param {number[]} [clearColor] - The color as rgba, default to use the renderer backgroundColor\n     * @param {PIXI.BUFFER_BITS} [mask=BUFFER_BITS.COLOR | BUFFER_BITS.DEPTH] - Bitwise OR of masks\n     *  that indicate the buffers to be cleared, by default COLOR and DEPTH buffers.\n     * @return {PIXI.Renderer} Returns itself.\n     */\n    RenderTextureSystem.prototype.clear = function (clearColor, mask) {\n        if (this.current) {\n            clearColor = clearColor || this.current.baseTexture.clearColor;\n        }\n        else {\n            clearColor = clearColor || this.clearColor;\n        }\n        this.renderer.framebuffer.clear(clearColor[0], clearColor[1], clearColor[2], clearColor[3], mask);\n    };\n    RenderTextureSystem.prototype.resize = function () {\n        // resize the root only!\n        this.bind(null);\n    };\n    /**\n     * Resets renderTexture state\n     */\n    RenderTextureSystem.prototype.reset = function () {\n        this.bind(null);\n    };\n    return RenderTextureSystem;\n}(System));\n\nvar IGLUniformData = /** @class */ (function () {\n    function IGLUniformData() {\n    }\n    return IGLUniformData;\n}());\n/**\n * Helper class to create a WebGL Program\n *\n * @class\n * @memberof PIXI\n */\nvar GLProgram = /** @class */ (function () {\n    /**\n     * Makes a new Pixi program\n     *\n     * @param program {WebGLProgram} webgl program\n     * @param uniformData {Object} uniforms\n     */\n    function GLProgram(program, uniformData) {\n        /**\n         * The shader program\n         *\n         * @member {WebGLProgram}\n         */\n        this.program = program;\n        /**\n         * holds the uniform data which contains uniform locations\n         * and current uniform values used for caching and preventing unneeded GPU commands\n         * @member {Object}\n         */\n        this.uniformData = uniformData;\n        /**\n         * uniformGroups holds the various upload functions for the shader. Each uniform group\n         * and program have a unique upload function generated.\n         * @member {Object}\n         */\n        this.uniformGroups = {};\n    }\n    /**\n     * Destroys this program\n     */\n    GLProgram.prototype.destroy = function () {\n        this.uniformData = null;\n        this.uniformGroups = null;\n        this.program = null;\n    };\n    return GLProgram;\n}());\n\nvar UID$4 = 0;\n// defualt sync data so we don't create a new one each time!\nvar defaultSyncData = { textureCount: 0 };\n/**\n * System plugin to the renderer to manage shaders.\n *\n * @class\n * @memberof PIXI.systems\n * @extends PIXI.System\n */\nvar ShaderSystem = /** @class */ (function (_super) {\n    __extends(ShaderSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function ShaderSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        _this.destroyed = false;\n        // Validation check that this environment support `new Function`\n        _this.systemCheck();\n        /**\n         * The current WebGL rendering context\n         *\n         * @member {WebGLRenderingContext}\n         */\n        _this.gl = null;\n        _this.shader = null;\n        _this.program = null;\n        /**\n         * Cache to holds the generated functions. Stored against UniformObjects unique signature\n         * @type {Object}\n         * @private\n         */\n        _this.cache = {};\n        _this.id = UID$4++;\n        return _this;\n    }\n    /**\n     * Overrideable function by `@pixi/unsafe-eval` to silence\n     * throwing an error if platform doesn't support unsafe-evals.\n     *\n     * @private\n     */\n    ShaderSystem.prototype.systemCheck = function () {\n        if (!unsafeEvalSupported()) {\n            throw new Error('Current environment does not allow unsafe-eval, '\n                + 'please use @pixi/unsafe-eval module to enable support.');\n        }\n    };\n    ShaderSystem.prototype.contextChange = function (gl) {\n        this.gl = gl;\n        this.reset();\n    };\n    /**\n     * Changes the current shader to the one given in parameter\n     *\n     * @param {PIXI.Shader} shader - the new shader\n     * @param {boolean} [dontSync] - false if the shader should automatically sync its uniforms.\n     * @returns {PIXI.GLProgram} the glProgram that belongs to the shader.\n     */\n    ShaderSystem.prototype.bind = function (shader, dontSync) {\n        shader.uniforms.globals = this.renderer.globalUniforms;\n        var program = shader.program;\n        var glProgram = program.glPrograms[this.renderer.CONTEXT_UID] || this.generateShader(shader);\n        this.shader = shader;\n        // TODO - some current Pixi plugins bypass this.. so it not safe to use yet..\n        if (this.program !== program) {\n            this.program = program;\n            this.gl.useProgram(glProgram.program);\n        }\n        if (!dontSync) {\n            defaultSyncData.textureCount = 0;\n            this.syncUniformGroup(shader.uniformGroup, defaultSyncData);\n        }\n        return glProgram;\n    };\n    /**\n     * Uploads the uniforms values to the currently bound shader.\n     *\n     * @param {object} uniforms - the uniforms values that be applied to the current shader\n     */\n    ShaderSystem.prototype.setUniforms = function (uniforms) {\n        var shader = this.shader.program;\n        var glProgram = shader.glPrograms[this.renderer.CONTEXT_UID];\n        shader.syncUniforms(glProgram.uniformData, uniforms, this.renderer);\n    };\n    /* eslint-disable @typescript-eslint/explicit-module-boundary-types */\n    /**\n     *\n     * syncs uniforms on the group\n     * @param {*} group - the uniform group to sync\n     * @param {*} [syncData] - this is data that is passed to the sync function and any nested sync functions\n     */\n    ShaderSystem.prototype.syncUniformGroup = function (group, syncData) {\n        var glProgram = this.getglProgram();\n        if (!group.static || group.dirtyId !== glProgram.uniformGroups[group.id]) {\n            glProgram.uniformGroups[group.id] = group.dirtyId;\n            this.syncUniforms(group, glProgram, syncData);\n        }\n    };\n    /**\n     * Overrideable by the @pixi/unsafe-eval package to use static\n     * syncUnforms instead.\n     *\n     * @private\n     */\n    ShaderSystem.prototype.syncUniforms = function (group, glProgram, syncData) {\n        var syncFunc = group.syncUniforms[this.shader.program.id] || this.createSyncGroups(group);\n        syncFunc(glProgram.uniformData, group.uniforms, this.renderer, syncData);\n    };\n    /* eslint-enable @typescript-eslint/explicit-module-boundary-types */\n    ShaderSystem.prototype.createSyncGroups = function (group) {\n        var id = this.getSignature(group, this.shader.program.uniformData);\n        if (!this.cache[id]) {\n            this.cache[id] = generateUniformsSync(group, this.shader.program.uniformData);\n        }\n        group.syncUniforms[this.shader.program.id] = this.cache[id];\n        return group.syncUniforms[this.shader.program.id];\n    };\n    /**\n     * Takes a uniform group and data and generates a unique signature for them.\n     *\n     * @param {PIXI.UniformGroup} group - the uniform group to get signature of\n     * @param {Object} uniformData - uniform information generated by the shader\n     * @returns {String} Unique signature of the uniform group\n     * @private\n     */\n    ShaderSystem.prototype.getSignature = function (group, uniformData) {\n        var uniforms = group.uniforms;\n        var strings = [];\n        for (var i in uniforms) {\n            strings.push(i);\n            if (uniformData[i]) {\n                strings.push(uniformData[i].type);\n            }\n        }\n        return strings.join('-');\n    };\n    /**\n     * Returns the underlying GLShade rof the currently bound shader.\n     * This can be handy for when you to have a little more control over the setting of your uniforms.\n     *\n     * @return {PIXI.GLProgram} the glProgram for the currently bound Shader for this context\n     */\n    ShaderSystem.prototype.getglProgram = function () {\n        if (this.shader) {\n            return this.shader.program.glPrograms[this.renderer.CONTEXT_UID];\n        }\n        return null;\n    };\n    /**\n     * Generates a glProgram version of the Shader provided.\n     *\n     * @private\n     * @param {PIXI.Shader} shader - the shader that the glProgram will be based on.\n     * @return {PIXI.GLProgram} A shiny new glProgram!\n     */\n    ShaderSystem.prototype.generateShader = function (shader) {\n        var gl = this.gl;\n        var program = shader.program;\n        var attribMap = {};\n        for (var i in program.attributeData) {\n            attribMap[i] = program.attributeData[i].location;\n        }\n        var shaderProgram = compileProgram(gl, program.vertexSrc, program.fragmentSrc, attribMap);\n        var uniformData = {};\n        for (var i in program.uniformData) {\n            var data = program.uniformData[i];\n            uniformData[i] = {\n                location: gl.getUniformLocation(shaderProgram, i),\n                value: defaultValue(data.type, data.size),\n            };\n        }\n        var glProgram = new GLProgram(shaderProgram, uniformData);\n        program.glPrograms[this.renderer.CONTEXT_UID] = glProgram;\n        return glProgram;\n    };\n    /**\n     * Resets ShaderSystem state, does not affect WebGL state\n     */\n    ShaderSystem.prototype.reset = function () {\n        this.program = null;\n        this.shader = null;\n    };\n    /**\n     * Destroys this System and removes all its textures\n     */\n    ShaderSystem.prototype.destroy = function () {\n        // TODO implement destroy method for ShaderSystem\n        this.destroyed = true;\n    };\n    return ShaderSystem;\n}(System));\n\n/**\n * Maps gl blend combinations to WebGL.\n *\n * @memberof PIXI\n * @function mapWebGLBlendModesToPixi\n * @private\n * @param {WebGLRenderingContext} gl - The rendering context.\n * @param {number[][]} [array=[]] - The array to output into.\n * @return {number[][]} Mapped modes.\n */\nfunction mapWebGLBlendModesToPixi(gl, array) {\n    if (array === void 0) { array = []; }\n    // TODO - premultiply alpha would be different.\n    // add a boolean for that!\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NORMAL] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.ADD] = [gl.ONE, gl.ONE];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.MULTIPLY] = [gl.DST_COLOR, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SCREEN] = [gl.ONE, gl.ONE_MINUS_SRC_COLOR, gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.OVERLAY] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DARKEN] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.LIGHTEN] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.COLOR_DODGE] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.COLOR_BURN] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.HARD_LIGHT] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SOFT_LIGHT] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DIFFERENCE] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.EXCLUSION] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.HUE] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SATURATION] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.COLOR] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.LUMINOSITY] = [gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NONE] = [0, 0];\n    // not-premultiplied blend modes\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NORMAL_NPM] = [gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.ADD_NPM] = [gl.SRC_ALPHA, gl.ONE, gl.ONE, gl.ONE];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SCREEN_NPM] = [gl.SRC_ALPHA, gl.ONE_MINUS_SRC_COLOR, gl.ONE, gl.ONE_MINUS_SRC_ALPHA];\n    // composite operations\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SRC_IN] = [gl.DST_ALPHA, gl.ZERO];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SRC_OUT] = [gl.ONE_MINUS_DST_ALPHA, gl.ZERO];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SRC_ATOP] = [gl.DST_ALPHA, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DST_OVER] = [gl.ONE_MINUS_DST_ALPHA, gl.ONE];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DST_IN] = [gl.ZERO, gl.SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DST_OUT] = [gl.ZERO, gl.ONE_MINUS_SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.DST_ATOP] = [gl.ONE_MINUS_DST_ALPHA, gl.SRC_ALPHA];\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.XOR] = [gl.ONE_MINUS_DST_ALPHA, gl.ONE_MINUS_SRC_ALPHA];\n    // SUBTRACT from flash\n    array[_pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.SUBTRACT] = [gl.ONE, gl.ONE, gl.ONE, gl.ONE, gl.FUNC_REVERSE_SUBTRACT, gl.FUNC_ADD];\n    return array;\n}\n\nvar BLEND$1 = 0;\nvar OFFSET$1 = 1;\nvar CULLING$1 = 2;\nvar DEPTH_TEST$1 = 3;\nvar WINDING$1 = 4;\n/**\n * System plugin to the renderer to manage WebGL state machines.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar StateSystem = /** @class */ (function (_super) {\n    __extends(StateSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function StateSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * GL context\n         * @member {WebGLRenderingContext}\n         * @readonly\n         */\n        _this.gl = null;\n        /**\n         * State ID\n         * @member {number}\n         * @readonly\n         */\n        _this.stateId = 0;\n        /**\n         * Polygon offset\n         * @member {number}\n         * @readonly\n         */\n        _this.polygonOffset = 0;\n        /**\n         * Blend mode\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NONE\n         * @readonly\n         */\n        _this.blendMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.BLEND_MODES.NONE;\n        /**\n         * Whether current blend equation is different\n         * @member {boolean}\n         * @protected\n         */\n        _this._blendEq = false;\n        /**\n         * Collection of calls\n         * @member {function[]}\n         * @readonly\n         */\n        _this.map = [];\n        // map functions for when we set state..\n        _this.map[BLEND$1] = _this.setBlend;\n        _this.map[OFFSET$1] = _this.setOffset;\n        _this.map[CULLING$1] = _this.setCullFace;\n        _this.map[DEPTH_TEST$1] = _this.setDepthTest;\n        _this.map[WINDING$1] = _this.setFrontFace;\n        /**\n         * Collection of check calls\n         * @member {function[]}\n         * @readonly\n         */\n        _this.checks = [];\n        /**\n         * Default WebGL State\n         * @member {PIXI.State}\n         * @readonly\n         */\n        _this.defaultState = new State();\n        _this.defaultState.blend = true;\n        return _this;\n    }\n    StateSystem.prototype.contextChange = function (gl) {\n        this.gl = gl;\n        this.blendModes = mapWebGLBlendModesToPixi(gl);\n        this.set(this.defaultState);\n        this.reset();\n    };\n    /**\n     * Sets the current state\n     *\n     * @param {*} state - The state to set.\n     */\n    StateSystem.prototype.set = function (state) {\n        state = state || this.defaultState;\n        // TODO maybe to an object check? ( this.state === state )?\n        if (this.stateId !== state.data) {\n            var diff = this.stateId ^ state.data;\n            var i = 0;\n            // order from least to most common\n            while (diff) {\n                if (diff & 1) {\n                    // state change!\n                    this.map[i].call(this, !!(state.data & (1 << i)));\n                }\n                diff = diff >> 1;\n                i++;\n            }\n            this.stateId = state.data;\n        }\n        // based on the above settings we check for specific modes..\n        // for example if blend is active we check and set the blend modes\n        // or of polygon offset is active we check the poly depth.\n        for (var i = 0; i < this.checks.length; i++) {\n            this.checks[i](this, state);\n        }\n    };\n    /**\n     * Sets the state, when previous state is unknown\n     *\n     * @param {*} state - The state to set\n     */\n    StateSystem.prototype.forceState = function (state) {\n        state = state || this.defaultState;\n        for (var i = 0; i < this.map.length; i++) {\n            this.map[i].call(this, !!(state.data & (1 << i)));\n        }\n        for (var i = 0; i < this.checks.length; i++) {\n            this.checks[i](this, state);\n        }\n        this.stateId = state.data;\n    };\n    /**\n     * Enables or disabled blending.\n     *\n     * @param {boolean} value - Turn on or off webgl blending.\n     */\n    StateSystem.prototype.setBlend = function (value) {\n        this.updateCheck(StateSystem.checkBlendMode, value);\n        this.gl[value ? 'enable' : 'disable'](this.gl.BLEND);\n    };\n    /**\n     * Enables or disable polygon offset fill\n     *\n     * @param {boolean} value - Turn on or off webgl polygon offset testing.\n     */\n    StateSystem.prototype.setOffset = function (value) {\n        this.updateCheck(StateSystem.checkPolygonOffset, value);\n        this.gl[value ? 'enable' : 'disable'](this.gl.POLYGON_OFFSET_FILL);\n    };\n    /**\n     * Sets whether to enable or disable depth test.\n     *\n     * @param {boolean} value - Turn on or off webgl depth testing.\n     */\n    StateSystem.prototype.setDepthTest = function (value) {\n        this.gl[value ? 'enable' : 'disable'](this.gl.DEPTH_TEST);\n    };\n    /**\n     * Sets whether to enable or disable cull face.\n     *\n     * @param {boolean} value - Turn on or off webgl cull face.\n     */\n    StateSystem.prototype.setCullFace = function (value) {\n        this.gl[value ? 'enable' : 'disable'](this.gl.CULL_FACE);\n    };\n    /**\n     * Sets the gl front face.\n     *\n     * @param {boolean} value - true is clockwise and false is counter-clockwise\n     */\n    StateSystem.prototype.setFrontFace = function (value) {\n        this.gl.frontFace(this.gl[value ? 'CW' : 'CCW']);\n    };\n    /**\n     * Sets the blend mode.\n     *\n     * @param {number} value - The blend mode to set to.\n     */\n    StateSystem.prototype.setBlendMode = function (value) {\n        if (value === this.blendMode) {\n            return;\n        }\n        this.blendMode = value;\n        var mode = this.blendModes[value];\n        var gl = this.gl;\n        if (mode.length === 2) {\n            gl.blendFunc(mode[0], mode[1]);\n        }\n        else {\n            gl.blendFuncSeparate(mode[0], mode[1], mode[2], mode[3]);\n        }\n        if (mode.length === 6) {\n            this._blendEq = true;\n            gl.blendEquationSeparate(mode[4], mode[5]);\n        }\n        else if (this._blendEq) {\n            this._blendEq = false;\n            gl.blendEquationSeparate(gl.FUNC_ADD, gl.FUNC_ADD);\n        }\n    };\n    /**\n     * Sets the polygon offset.\n     *\n     * @param {number} value - the polygon offset\n     * @param {number} scale - the polygon offset scale\n     */\n    StateSystem.prototype.setPolygonOffset = function (value, scale) {\n        this.gl.polygonOffset(value, scale);\n    };\n    // used\n    /**\n     * Resets all the logic and disables the vaos\n     */\n    StateSystem.prototype.reset = function () {\n        this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL, false);\n        this.forceState(this.defaultState);\n        this._blendEq = true;\n        this.blendMode = -1;\n        this.setBlendMode(0);\n    };\n    /**\n     * checks to see which updates should be checked based on which settings have been activated.\n     * For example, if blend is enabled then we should check the blend modes each time the state is changed\n     * or if polygon fill is activated then we need to check if the polygon offset changes.\n     * The idea is that we only check what we have too.\n     *\n     * @param {Function} func - the checking function to add or remove\n     * @param {boolean} value - should the check function be added or removed.\n     */\n    StateSystem.prototype.updateCheck = function (func, value) {\n        var index = this.checks.indexOf(func);\n        if (value && index === -1) {\n            this.checks.push(func);\n        }\n        else if (!value && index !== -1) {\n            this.checks.splice(index, 1);\n        }\n    };\n    /**\n     * A private little wrapper function that we call to check the blend mode.\n     *\n     * @static\n     * @private\n     * @param {PIXI.StateSystem} System - the System to perform the state check on\n     * @param {PIXI.State} state - the state that the blendMode will pulled from\n     */\n    StateSystem.checkBlendMode = function (system, state) {\n        system.setBlendMode(state.blendMode);\n    };\n    /**\n     * A private little wrapper function that we call to check the polygon offset.\n     *\n     * @static\n     * @private\n     * @param {PIXI.StateSystem} System - the System to perform the state check on\n     * @param {PIXI.State} state - the state that the blendMode will pulled from\n     */\n    StateSystem.checkPolygonOffset = function (system, state) {\n        system.setPolygonOffset(1, state.polygonOffset);\n    };\n    return StateSystem;\n}(System));\n\n/**\n * System plugin to the renderer to manage texture garbage collection on the GPU,\n * ensuring that it does not get clogged up with textures that are no longer being used.\n *\n * @class\n * @memberof PIXI.systems\n * @extends PIXI.System\n */\nvar TextureGCSystem = /** @class */ (function (_super) {\n    __extends(TextureGCSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function TextureGCSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * Count\n         * @member {number}\n         * @readonly\n         */\n        _this.count = 0;\n        /**\n         * Check count\n         * @member {number}\n         * @readonly\n         */\n        _this.checkCount = 0;\n        /**\n         * Maximum idle time, in seconds\n         * @member {number}\n         * @see PIXI.settings.GC_MAX_IDLE\n         */\n        _this.maxIdle = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.GC_MAX_IDLE;\n        /**\n         * Maximum number of item to check\n         * @member {number}\n         * @see PIXI.settings.GC_MAX_CHECK_COUNT\n         */\n        _this.checkCountMax = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.GC_MAX_CHECK_COUNT;\n        /**\n         * Current garabage collection mode\n         * @member {PIXI.GC_MODES}\n         * @see PIXI.settings.GC_MODE\n         */\n        _this.mode = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.GC_MODE;\n        return _this;\n    }\n    /**\n     * Checks to see when the last time a texture was used\n     * if the texture has not been used for a specified amount of time it will be removed from the GPU\n     */\n    TextureGCSystem.prototype.postrender = function () {\n        if (!this.renderer.renderingToScreen) {\n            return;\n        }\n        this.count++;\n        if (this.mode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.GC_MODES.MANUAL) {\n            return;\n        }\n        this.checkCount++;\n        if (this.checkCount > this.checkCountMax) {\n            this.checkCount = 0;\n            this.run();\n        }\n    };\n    /**\n     * Checks to see when the last time a texture was used\n     * if the texture has not been used for a specified amount of time it will be removed from the GPU\n     */\n    TextureGCSystem.prototype.run = function () {\n        var tm = this.renderer.texture;\n        var managedTextures = tm.managedTextures;\n        var wasRemoved = false;\n        for (var i = 0; i < managedTextures.length; i++) {\n            var texture = managedTextures[i];\n            // only supports non generated textures at the moment!\n            if (!texture.framebuffer && this.count - texture.touched > this.maxIdle) {\n                tm.destroyTexture(texture, true);\n                managedTextures[i] = null;\n                wasRemoved = true;\n            }\n        }\n        if (wasRemoved) {\n            var j = 0;\n            for (var i = 0; i < managedTextures.length; i++) {\n                if (managedTextures[i] !== null) {\n                    managedTextures[j++] = managedTextures[i];\n                }\n            }\n            managedTextures.length = j;\n        }\n    };\n    /**\n     * Removes all the textures within the specified displayObject and its children from the GPU\n     *\n     * @param {PIXI.DisplayObject} displayObject - the displayObject to remove the textures from.\n     */\n    TextureGCSystem.prototype.unload = function (displayObject) {\n        var tm = this.renderer.texture;\n        var texture = displayObject._texture;\n        // only destroy non generated textures\n        if (texture && !texture.framebuffer) {\n            tm.destroyTexture(texture);\n        }\n        for (var i = displayObject.children.length - 1; i >= 0; i--) {\n            this.unload(displayObject.children[i]);\n        }\n    };\n    return TextureGCSystem;\n}(System));\n\n/**\n * Internal texture for WebGL context\n * @class\n * @memberof PIXI\n */\nvar GLTexture = /** @class */ (function () {\n    function GLTexture(texture) {\n        /**\n         * The WebGL texture\n         * @member {WebGLTexture}\n         */\n        this.texture = texture;\n        /**\n         * Width of texture that was used in texImage2D\n         * @member {number}\n         */\n        this.width = -1;\n        /**\n         * Height of texture that was used in texImage2D\n         * @member {number}\n         */\n        this.height = -1;\n        /**\n         * Texture contents dirty flag\n         * @member {number}\n         */\n        this.dirtyId = -1;\n        /**\n         * Texture style dirty flag\n         * @member {number}\n         */\n        this.dirtyStyleId = -1;\n        /**\n         * Whether mip levels has to be generated\n         * @member {boolean}\n         */\n        this.mipmap = false;\n        /**\n         * WrapMode copied from baseTexture\n         * @member {number}\n         */\n        this.wrapMode = 33071;\n        /**\n         * Type copied from baseTexture\n         * @member {number}\n         */\n        this.type = 6408;\n        /**\n         * Type copied from baseTexture\n         * @member {number}\n         */\n        this.internalFormat = 5121;\n    }\n    return GLTexture;\n}());\n\n/**\n * System plugin to the renderer to manage textures.\n *\n * @class\n * @extends PIXI.System\n * @memberof PIXI.systems\n */\nvar TextureSystem = /** @class */ (function (_super) {\n    __extends(TextureSystem, _super);\n    /**\n     * @param {PIXI.Renderer} renderer - The renderer this System works for.\n     */\n    function TextureSystem(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        // TODO set to max textures...\n        /**\n         * Bound textures\n         * @member {PIXI.BaseTexture[]}\n         * @readonly\n         */\n        _this.boundTextures = [];\n        /**\n         * Current location\n         * @member {number}\n         * @readonly\n         */\n        _this.currentLocation = -1;\n        /**\n         * List of managed textures\n         * @member {PIXI.BaseTexture[]}\n         * @readonly\n         */\n        _this.managedTextures = [];\n        /**\n         * Did someone temper with textures state? We'll overwrite them when we need to unbind something.\n         * @member {boolean}\n         * @private\n         */\n        _this._unknownBoundTextures = false;\n        /**\n         * BaseTexture value that shows that we don't know what is bound\n         * @member {PIXI.BaseTexture}\n         * @readonly\n         */\n        _this.unknownTexture = new BaseTexture();\n        return _this;\n    }\n    /**\n     * Sets up the renderer context and necessary buffers.\n     */\n    TextureSystem.prototype.contextChange = function () {\n        var gl = this.gl = this.renderer.gl;\n        this.CONTEXT_UID = this.renderer.CONTEXT_UID;\n        this.webGLVersion = this.renderer.context.webGLVersion;\n        var maxTextures = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);\n        this.boundTextures.length = maxTextures;\n        for (var i = 0; i < maxTextures; i++) {\n            this.boundTextures[i] = null;\n        }\n        // TODO move this.. to a nice make empty textures class..\n        this.emptyTextures = {};\n        var emptyTexture2D = new GLTexture(gl.createTexture());\n        gl.bindTexture(gl.TEXTURE_2D, emptyTexture2D.texture);\n        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, 1, 1, 0, gl.RGBA, gl.UNSIGNED_BYTE, new Uint8Array(4));\n        this.emptyTextures[gl.TEXTURE_2D] = emptyTexture2D;\n        this.emptyTextures[gl.TEXTURE_CUBE_MAP] = new GLTexture(gl.createTexture());\n        gl.bindTexture(gl.TEXTURE_CUBE_MAP, this.emptyTextures[gl.TEXTURE_CUBE_MAP].texture);\n        for (var i = 0; i < 6; i++) {\n            gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, gl.RGBA, 1, 1, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);\n        }\n        gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.LINEAR);\n        gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n        for (var i = 0; i < this.boundTextures.length; i++) {\n            this.bind(null, i);\n        }\n    };\n    /**\n     * Bind a texture to a specific location\n     *\n     * If you want to unbind something, please use `unbind(texture)` instead of `bind(null, textureLocation)`\n     *\n     * @param {PIXI.Texture|PIXI.BaseTexture} texture_ - Texture to bind\n     * @param {number} [location=0] - Location to bind at\n     */\n    TextureSystem.prototype.bind = function (texture, location) {\n        if (location === void 0) { location = 0; }\n        var gl = this.gl;\n        if (texture) {\n            texture = texture.castToBaseTexture();\n            if (texture.parentTextureArray) {\n                // cannot bind partial texture\n                // TODO: report a warning\n                return;\n            }\n            if (texture.valid) {\n                texture.touched = this.renderer.textureGC.count;\n                var glTexture = texture._glTextures[this.CONTEXT_UID] || this.initTexture(texture);\n                if (this.boundTextures[location] !== texture) {\n                    if (this.currentLocation !== location) {\n                        this.currentLocation = location;\n                        gl.activeTexture(gl.TEXTURE0 + location);\n                    }\n                    gl.bindTexture(texture.target, glTexture.texture);\n                }\n                if (glTexture.dirtyId !== texture.dirtyId) {\n                    if (this.currentLocation !== location) {\n                        this.currentLocation = location;\n                        gl.activeTexture(gl.TEXTURE0 + location);\n                    }\n                    this.updateTexture(texture);\n                }\n                this.boundTextures[location] = texture;\n            }\n        }\n        else {\n            if (this.currentLocation !== location) {\n                this.currentLocation = location;\n                gl.activeTexture(gl.TEXTURE0 + location);\n            }\n            gl.bindTexture(gl.TEXTURE_2D, this.emptyTextures[gl.TEXTURE_2D].texture);\n            this.boundTextures[location] = null;\n        }\n    };\n    /**\n     * Resets texture location and bound textures\n     *\n     * Actual `bind(null, i)` calls will be performed at next `unbind()` call\n     */\n    TextureSystem.prototype.reset = function () {\n        this._unknownBoundTextures = true;\n        this.currentLocation = -1;\n        for (var i = 0; i < this.boundTextures.length; i++) {\n            this.boundTextures[i] = this.unknownTexture;\n        }\n    };\n    /**\n     * Unbind a texture\n     * @param {PIXI.BaseTexture} texture - Texture to bind\n     */\n    TextureSystem.prototype.unbind = function (texture) {\n        var _a = this, gl = _a.gl, boundTextures = _a.boundTextures;\n        if (this._unknownBoundTextures) {\n            this._unknownBoundTextures = false;\n            // someone changed webGL state,\n            // we have to be sure that our texture does not appear in multi-texture renderer samplers\n            for (var i = 0; i < boundTextures.length; i++) {\n                if (boundTextures[i] === this.unknownTexture) {\n                    this.bind(null, i);\n                }\n            }\n        }\n        for (var i = 0; i < boundTextures.length; i++) {\n            if (boundTextures[i] === texture) {\n                if (this.currentLocation !== i) {\n                    gl.activeTexture(gl.TEXTURE0 + i);\n                    this.currentLocation = i;\n                }\n                gl.bindTexture(texture.target, this.emptyTextures[texture.target].texture);\n                boundTextures[i] = null;\n            }\n        }\n    };\n    /**\n     * Initialize a texture\n     *\n     * @private\n     * @param {PIXI.BaseTexture} texture - Texture to initialize\n     */\n    TextureSystem.prototype.initTexture = function (texture) {\n        var glTexture = new GLTexture(this.gl.createTexture());\n        // guarantee an update..\n        glTexture.dirtyId = -1;\n        texture._glTextures[this.CONTEXT_UID] = glTexture;\n        this.managedTextures.push(texture);\n        texture.on('dispose', this.destroyTexture, this);\n        return glTexture;\n    };\n    TextureSystem.prototype.initTextureType = function (texture, glTexture) {\n        glTexture.internalFormat = texture.format;\n        glTexture.type = texture.type;\n        if (this.webGLVersion !== 2) {\n            return;\n        }\n        var gl = this.renderer.gl;\n        if (texture.type === gl.FLOAT\n            && texture.format === gl.RGBA) {\n            glTexture.internalFormat = gl.RGBA32F;\n        }\n        // that's WebGL1 HALF_FLOAT_OES\n        // we have to convert it to WebGL HALF_FLOAT\n        if (texture.type === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.HALF_FLOAT) {\n            glTexture.type = gl.HALF_FLOAT;\n        }\n        if (glTexture.type === gl.HALF_FLOAT\n            && texture.format === gl.RGBA) {\n            glTexture.internalFormat = gl.RGBA16F;\n        }\n    };\n    /**\n     * Update a texture\n     *\n     * @private\n     * @param {PIXI.BaseTexture} texture - Texture to initialize\n     */\n    TextureSystem.prototype.updateTexture = function (texture) {\n        var glTexture = texture._glTextures[this.CONTEXT_UID];\n        if (!glTexture) {\n            return;\n        }\n        var renderer = this.renderer;\n        this.initTextureType(texture, glTexture);\n        if (texture.resource && texture.resource.upload(renderer, texture, glTexture)) ;\n        else {\n            // default, renderTexture-like logic\n            var width = texture.realWidth;\n            var height = texture.realHeight;\n            var gl = renderer.gl;\n            if (glTexture.width !== width\n                || glTexture.height !== height\n                || glTexture.dirtyId < 0) {\n                glTexture.width = width;\n                glTexture.height = height;\n                gl.texImage2D(texture.target, 0, glTexture.internalFormat, width, height, 0, texture.format, glTexture.type, null);\n            }\n        }\n        // lets only update what changes..\n        if (texture.dirtyStyleId !== glTexture.dirtyStyleId) {\n            this.updateTextureStyle(texture);\n        }\n        glTexture.dirtyId = texture.dirtyId;\n    };\n    /**\n     * Deletes the texture from WebGL\n     *\n     * @private\n     * @param {PIXI.BaseTexture|PIXI.Texture} texture_ - the texture to destroy\n     * @param {boolean} [skipRemove=false] - Whether to skip removing the texture from the TextureManager.\n     */\n    TextureSystem.prototype.destroyTexture = function (texture, skipRemove) {\n        var gl = this.gl;\n        texture = texture.castToBaseTexture();\n        if (texture._glTextures[this.CONTEXT_UID]) {\n            this.unbind(texture);\n            gl.deleteTexture(texture._glTextures[this.CONTEXT_UID].texture);\n            texture.off('dispose', this.destroyTexture, this);\n            delete texture._glTextures[this.CONTEXT_UID];\n            if (!skipRemove) {\n                var i = this.managedTextures.indexOf(texture);\n                if (i !== -1) {\n                    (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.removeItems)(this.managedTextures, i, 1);\n                }\n            }\n        }\n    };\n    /**\n     * Update texture style such as mipmap flag\n     *\n     * @private\n     * @param {PIXI.BaseTexture} texture - Texture to update\n     */\n    TextureSystem.prototype.updateTextureStyle = function (texture) {\n        var glTexture = texture._glTextures[this.CONTEXT_UID];\n        if (!glTexture) {\n            return;\n        }\n        if ((texture.mipmap === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.MIPMAP_MODES.POW2 || this.webGLVersion !== 2) && !texture.isPowerOfTwo) {\n            glTexture.mipmap = false;\n        }\n        else {\n            glTexture.mipmap = texture.mipmap >= 1;\n        }\n        if (this.webGLVersion !== 2 && !texture.isPowerOfTwo) {\n            glTexture.wrapMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.WRAP_MODES.CLAMP;\n        }\n        else {\n            glTexture.wrapMode = texture.wrapMode;\n        }\n        if (texture.resource && texture.resource.style(this.renderer, texture, glTexture)) ;\n        else {\n            this.setStyle(texture, glTexture);\n        }\n        glTexture.dirtyStyleId = texture.dirtyStyleId;\n    };\n    /**\n     * Set style for texture\n     *\n     * @private\n     * @param {PIXI.BaseTexture} texture - Texture to update\n     * @param {PIXI.GLTexture} glTexture\n     */\n    TextureSystem.prototype.setStyle = function (texture, glTexture) {\n        var gl = this.gl;\n        if (glTexture.mipmap) {\n            gl.generateMipmap(texture.target);\n        }\n        gl.texParameteri(texture.target, gl.TEXTURE_WRAP_S, glTexture.wrapMode);\n        gl.texParameteri(texture.target, gl.TEXTURE_WRAP_T, glTexture.wrapMode);\n        if (glTexture.mipmap) {\n            /* eslint-disable max-len */\n            gl.texParameteri(texture.target, gl.TEXTURE_MIN_FILTER, texture.scaleMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.LINEAR ? gl.LINEAR_MIPMAP_LINEAR : gl.NEAREST_MIPMAP_NEAREST);\n            /* eslint-disable max-len */\n            var anisotropicExt = this.renderer.context.extensions.anisotropicFiltering;\n            if (anisotropicExt && texture.anisotropicLevel > 0 && texture.scaleMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.LINEAR) {\n                var level = Math.min(texture.anisotropicLevel, gl.getParameter(anisotropicExt.MAX_TEXTURE_MAX_ANISOTROPY_EXT));\n                gl.texParameterf(texture.target, anisotropicExt.TEXTURE_MAX_ANISOTROPY_EXT, level);\n            }\n        }\n        else {\n            gl.texParameteri(texture.target, gl.TEXTURE_MIN_FILTER, texture.scaleMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.LINEAR ? gl.LINEAR : gl.NEAREST);\n        }\n        gl.texParameteri(texture.target, gl.TEXTURE_MAG_FILTER, texture.scaleMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.SCALE_MODES.LINEAR ? gl.LINEAR : gl.NEAREST);\n    };\n    return TextureSystem;\n}(System));\n\n/**\n * Systems are individual components to the Renderer pipeline.\n * @namespace PIXI.systems\n */\n\nvar systems = ({\n    FilterSystem: FilterSystem,\n    BatchSystem: BatchSystem,\n    ContextSystem: ContextSystem,\n    FramebufferSystem: FramebufferSystem,\n    GeometrySystem: GeometrySystem,\n    MaskSystem: MaskSystem,\n    ScissorSystem: ScissorSystem,\n    StencilSystem: StencilSystem,\n    ProjectionSystem: ProjectionSystem,\n    RenderTextureSystem: RenderTextureSystem,\n    ShaderSystem: ShaderSystem,\n    StateSystem: StateSystem,\n    TextureGCSystem: TextureGCSystem,\n    TextureSystem: TextureSystem\n});\n\nvar tempMatrix = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix();\n/**\n * The AbstractRenderer is the base for a PixiJS Renderer. It is extended by the {@link PIXI.CanvasRenderer}\n * and {@link PIXI.Renderer} which can be used for rendering a PixiJS scene.\n *\n * @abstract\n * @class\n * @extends PIXI.utils.EventEmitter\n * @memberof PIXI\n */\nvar AbstractRenderer = /** @class */ (function (_super) {\n    __extends(AbstractRenderer, _super);\n    /**\n     * @param {string} system - The name of the system this renderer is for.\n     * @param {object} [options] - The optional renderer parameters.\n     * @param {number} [options.width=800] - The width of the screen.\n     * @param {number} [options.height=600] - The height of the screen.\n     * @param {HTMLCanvasElement} [options.view] - The canvas to use as a view, optional.\n     * @param {boolean} [options.transparent=false] - If the render view is transparent.\n     * @param {boolean} [options.autoDensity=false] - Resizes renderer view in CSS pixels to allow for\n     *   resolutions other than 1.\n     * @param {boolean} [options.antialias=false] - Sets antialias\n     * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the renderer. The\n     *  resolution of the renderer retina would be 2.\n     * @param {boolean} [options.preserveDrawingBuffer=false] - Enables drawing buffer preservation,\n     *  enable this if you need to call toDataUrl on the WebGL context.\n     * @param {boolean} [options.clearBeforeRender=true] - This sets if the renderer will clear the canvas or\n     *      not before the new render pass.\n     * @param {number} [options.backgroundColor=0x000000] - The background color of the rendered area\n     *  (shown if not transparent).\n     */\n    function AbstractRenderer(type, options) {\n        if (type === void 0) { type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.RENDERER_TYPE.UNKNOWN; }\n        var _this = _super.call(this) || this;\n        // Add the default render options\n        options = Object.assign({}, _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.RENDER_OPTIONS, options);\n        // Deprecation notice for renderer roundPixels option\n        if (options.roundPixels) {\n            _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.ROUND_PIXELS = options.roundPixels;\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.deprecation)('5.0.0', 'Renderer roundPixels option is deprecated, please use PIXI.settings.ROUND_PIXELS', 2);\n        }\n        /**\n         * The supplied constructor options.\n         *\n         * @member {Object}\n         * @readOnly\n         */\n        _this.options = options;\n        /**\n         * The type of the renderer.\n         *\n         * @member {number}\n         * @default PIXI.RENDERER_TYPE.UNKNOWN\n         * @see PIXI.RENDERER_TYPE\n         */\n        _this.type = type;\n        /**\n         * Measurements of the screen. (0, 0, screenWidth, screenHeight).\n         *\n         * Its safe to use as filterArea or hitArea for the whole stage.\n         *\n         * @member {PIXI.Rectangle}\n         */\n        _this.screen = new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Rectangle(0, 0, options.width, options.height);\n        /**\n         * The canvas element that everything is drawn to.\n         *\n         * @member {HTMLCanvasElement}\n         */\n        _this.view = options.view || document.createElement('canvas');\n        /**\n         * The resolution / device pixel ratio of the renderer.\n         *\n         * @member {number}\n         * @default 1\n         */\n        _this.resolution = options.resolution || _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.RESOLUTION;\n        /**\n         * Whether the render view is transparent.\n         *\n         * @member {boolean}\n         */\n        _this.transparent = options.transparent;\n        /**\n         * Whether CSS dimensions of canvas view should be resized to screen dimensions automatically.\n         *\n         * @member {boolean}\n         */\n        _this.autoDensity = options.autoDensity || options.autoResize || false;\n        // autoResize is deprecated, provides fallback support\n        /**\n         * The value of the preserveDrawingBuffer flag affects whether or not the contents of\n         * the stencil buffer is retained after rendering.\n         *\n         * @member {boolean}\n         */\n        _this.preserveDrawingBuffer = options.preserveDrawingBuffer;\n        /**\n         * This sets if the CanvasRenderer will clear the canvas or not before the new render pass.\n         * If the scene is NOT transparent PixiJS will use a canvas sized fillRect operation every\n         * frame to set the canvas background color. If the scene is transparent PixiJS will use clearRect\n         * to clear the canvas every frame. Disable this by setting this to false. For example, if\n         * your game has a canvas filling background image you often don't need this set.\n         *\n         * @member {boolean}\n         * @default\n         */\n        _this.clearBeforeRender = options.clearBeforeRender;\n        /**\n         * The background color as a number.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this._backgroundColor = 0x000000;\n        /**\n         * The background color as an [R, G, B] array.\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this._backgroundColorRgba = [0, 0, 0, 0];\n        /**\n         * The background color as a string.\n         *\n         * @member {string}\n         * @protected\n         */\n        _this._backgroundColorString = '#000000';\n        _this.backgroundColor = options.backgroundColor || _this._backgroundColor; // run bg color setter\n        /**\n         * The last root object that the renderer tried to render.\n         *\n         * @member {PIXI.DisplayObject}\n         * @protected\n         */\n        _this._lastObjectRendered = null;\n        /**\n         * Collection of plugins.\n         * @readonly\n         * @member {object}\n         */\n        _this.plugins = {};\n        return _this;\n    }\n    /**\n     * Initialize the plugins.\n     *\n     * @protected\n     * @param {object} staticMap - The dictionary of statically saved plugins.\n     */\n    AbstractRenderer.prototype.initPlugins = function (staticMap) {\n        for (var o in staticMap) {\n            this.plugins[o] = new (staticMap[o])(this);\n        }\n    };\n    Object.defineProperty(AbstractRenderer.prototype, \"width\", {\n        /**\n         * Same as view.width, actual number of pixels in the canvas by horizontal.\n         *\n         * @member {number}\n         * @readonly\n         * @default 800\n         */\n        get: function () {\n            return this.view.width;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(AbstractRenderer.prototype, \"height\", {\n        /**\n         * Same as view.height, actual number of pixels in the canvas by vertical.\n         *\n         * @member {number}\n         * @readonly\n         * @default 600\n         */\n        get: function () {\n            return this.view.height;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Resizes the screen and canvas to the specified width and height.\n     * Canvas dimensions are multiplied by resolution.\n     *\n     * @param {number} screenWidth - The new width of the screen.\n     * @param {number} screenHeight - The new height of the screen.\n     */\n    AbstractRenderer.prototype.resize = function (screenWidth, screenHeight) {\n        this.screen.width = screenWidth;\n        this.screen.height = screenHeight;\n        this.view.width = screenWidth * this.resolution;\n        this.view.height = screenHeight * this.resolution;\n        if (this.autoDensity) {\n            this.view.style.width = screenWidth + \"px\";\n            this.view.style.height = screenHeight + \"px\";\n        }\n        /**\n         * Fired after view has been resized.\n         *\n         * @event PIXI.Renderer#resize\n         * @param {number} screenWidth - The new width of the screen.\n         * @param {number} screenHeight - The new height of the screen.\n         */\n        this.emit('resize', screenWidth, screenHeight);\n    };\n    /**\n     * Useful function that returns a texture of the display object that can then be used to create sprites\n     * This can be quite useful if your displayObject is complicated and needs to be reused multiple times.\n     *\n     * @param {PIXI.DisplayObject} displayObject - The displayObject the object will be generated from.\n     * @param {PIXI.SCALE_MODES} scaleMode - The scale mode of the texture.\n     * @param {number} resolution - The resolution / device pixel ratio of the texture being generated.\n     * @param {PIXI.Rectangle} [region] - The region of the displayObject, that shall be rendered,\n     *        if no region is specified, defaults to the local bounds of the displayObject.\n     * @return {PIXI.RenderTexture} A texture of the graphics object.\n     */\n    AbstractRenderer.prototype.generateTexture = function (displayObject, scaleMode, resolution, region) {\n        region = region || displayObject.getLocalBounds(null, true);\n        // minimum texture size is 1x1, 0x0 will throw an error\n        if (region.width === 0)\n            { region.width = 1; }\n        if (region.height === 0)\n            { region.height = 1; }\n        var renderTexture = RenderTexture.create({\n            width: region.width | 0,\n            height: region.height | 0,\n            scaleMode: scaleMode,\n            resolution: resolution,\n        });\n        tempMatrix.tx = -region.x;\n        tempMatrix.ty = -region.y;\n        this.render(displayObject, renderTexture, false, tempMatrix, !!displayObject.parent);\n        return renderTexture;\n    };\n    /**\n     * Removes everything from the renderer and optionally removes the Canvas DOM element.\n     *\n     * @param {boolean} [removeView=false] - Removes the Canvas element from the DOM.\n     */\n    AbstractRenderer.prototype.destroy = function (removeView) {\n        for (var o in this.plugins) {\n            this.plugins[o].destroy();\n            this.plugins[o] = null;\n        }\n        if (removeView && this.view.parentNode) {\n            this.view.parentNode.removeChild(this.view);\n        }\n        var thisAny = this;\n        // null-ing all objects, that's a tradition!\n        thisAny.plugins = null;\n        thisAny.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.RENDERER_TYPE.UNKNOWN;\n        thisAny.view = null;\n        thisAny.screen = null;\n        thisAny._tempDisplayObjectParent = null;\n        thisAny.options = null;\n        this._backgroundColorRgba = null;\n        this._backgroundColorString = null;\n        this._lastObjectRendered = null;\n    };\n    Object.defineProperty(AbstractRenderer.prototype, \"backgroundColor\", {\n        /**\n         * The background color to fill if not transparent\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._backgroundColor;\n        },\n        set: function (value) {\n            this._backgroundColor = value;\n            this._backgroundColorString = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.hex2string)(value);\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.hex2rgb)(value, this._backgroundColorRgba);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return AbstractRenderer;\n}(_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.EventEmitter));\n\n/**\n * The Renderer draws the scene and all its content onto a WebGL enabled canvas.\n *\n * This renderer should be used for browsers that support WebGL.\n *\n * This renderer works by automatically managing WebGLBatchesm, so no need for Sprite Batches or Sprite Clouds.\n * Don't forget to add the view to your DOM or you will not see anything!\n *\n * @class\n * @memberof PIXI\n * @extends PIXI.AbstractRenderer\n */\nvar Renderer = /** @class */ (function (_super) {\n    __extends(Renderer, _super);\n    /**\n     * @param {object} [options] - The optional renderer parameters.\n     * @param {number} [options.width=800] - The width of the screen.\n     * @param {number} [options.height=600] - The height of the screen.\n     * @param {HTMLCanvasElement} [options.view] - The canvas to use as a view, optional.\n     * @param {boolean} [options.transparent=false] - If the render view is transparent.\n     * @param {boolean} [options.autoDensity=false] - Resizes renderer view in CSS pixels to allow for\n     *   resolutions other than 1.\n     * @param {boolean} [options.antialias=false] - Sets antialias. If not available natively then FXAA\n     *  antialiasing is used.\n     * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the renderer.\n     *  The resolution of the renderer retina would be 2.\n     * @param {boolean} [options.clearBeforeRender=true] - This sets if the renderer will clear\n     *  the canvas or not before the new render pass. If you wish to set this to false, you *must* set\n     *  preserveDrawingBuffer to `true`.\n     * @param {boolean} [options.preserveDrawingBuffer=false] - Enables drawing buffer preservation,\n     *  enable this if you need to call toDataUrl on the WebGL context.\n     * @param {number} [options.backgroundColor=0x000000] - The background color of the rendered area\n     *  (shown if not transparent).\n     * @param {string} [options.powerPreference] - Parameter passed to WebGL context, set to \"high-performance\"\n     *  for devices with dual graphics card.\n     * @param {object} [options.context] - If WebGL context already exists, all parameters must be taken from it.\n     * @public\n     */\n    function Renderer(options) {\n        var _this = _super.call(this, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.RENDERER_TYPE.WEBGL, options) || this;\n        // the options will have been modified here in the super constructor with pixi's default settings..\n        options = _this.options;\n        /**\n         * WebGL context, set by the contextSystem (this.context)\n         *\n         * @readonly\n         * @member {WebGLRenderingContext}\n         */\n        _this.gl = null;\n        _this.CONTEXT_UID = 0;\n        // TODO legacy!\n        /**\n         * Internal signal instances of **runner**, these\n         * are assigned to each system created.\n         * @see PIXI.Runner\n         * @name PIXI.Renderer#runners\n         * @private\n         * @type {object}\n         * @readonly\n         * @property {PIXI.Runner} destroy - Destroy runner\n         * @property {PIXI.Runner} contextChange - Context change runner\n         * @property {PIXI.Runner} reset - Reset runner\n         * @property {PIXI.Runner} update - Update runner\n         * @property {PIXI.Runner} postrender - Post-render runner\n         * @property {PIXI.Runner} prerender - Pre-render runner\n         * @property {PIXI.Runner} resize - Resize runner\n         */\n        _this.runners = {\n            destroy: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('destroy'),\n            contextChange: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('contextChange'),\n            reset: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('reset'),\n            update: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('update'),\n            postrender: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('postrender'),\n            prerender: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('prerender'),\n            resize: new _pixi_runner__WEBPACK_IMPORTED_MODULE_3__.Runner('resize'),\n        };\n        /**\n         * Global uniforms\n         * @member {PIXI.UniformGroup}\n         */\n        _this.globalUniforms = new UniformGroup({\n            projectionMatrix: new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix(),\n        }, true);\n        /**\n         * Mask system instance\n         * @member {PIXI.systems.MaskSystem} mask\n         * @memberof PIXI.Renderer#\n         * @readonly\n         */\n        _this.addSystem(MaskSystem, 'mask')\n            /**\n             * Context system instance\n             * @member {PIXI.systems.ContextSystem} context\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(ContextSystem, 'context')\n            /**\n             * State system instance\n             * @member {PIXI.systems.StateSystem} state\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(StateSystem, 'state')\n            /**\n             * Shader system instance\n             * @member {PIXI.systems.ShaderSystem} shader\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(ShaderSystem, 'shader')\n            /**\n             * Texture system instance\n             * @member {PIXI.systems.TextureSystem} texture\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(TextureSystem, 'texture')\n            /**\n             * Geometry system instance\n             * @member {PIXI.systems.GeometrySystem} geometry\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(GeometrySystem, 'geometry')\n            /**\n             * Framebuffer system instance\n             * @member {PIXI.systems.FramebufferSystem} framebuffer\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(FramebufferSystem, 'framebuffer')\n            /**\n             * Scissor system instance\n             * @member {PIXI.systems.ScissorSystem} scissor\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(ScissorSystem, 'scissor')\n            /**\n             * Stencil system instance\n             * @member {PIXI.systems.StencilSystem} stencil\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(StencilSystem, 'stencil')\n            /**\n             * Projection system instance\n             * @member {PIXI.systems.ProjectionSystem} projection\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(ProjectionSystem, 'projection')\n            /**\n             * Texture garbage collector system instance\n             * @member {PIXI.systems.TextureGCSystem} textureGC\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(TextureGCSystem, 'textureGC')\n            /**\n             * Filter system instance\n             * @member {PIXI.systems.FilterSystem} filter\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(FilterSystem, 'filter')\n            /**\n             * RenderTexture system instance\n             * @member {PIXI.systems.RenderTextureSystem} renderTexture\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(RenderTextureSystem, 'renderTexture')\n            /**\n             * Batch system instance\n             * @member {PIXI.systems.BatchSystem} batch\n             * @memberof PIXI.Renderer#\n             * @readonly\n             */\n            .addSystem(BatchSystem, 'batch');\n        _this.initPlugins(Renderer.__plugins);\n        /**\n         * The options passed in to create a new WebGL context.\n         */\n        if (options.context) {\n            _this.context.initFromContext(options.context);\n        }\n        else {\n            _this.context.initFromOptions({\n                alpha: !!_this.transparent,\n                antialias: options.antialias,\n                premultipliedAlpha: _this.transparent && _this.transparent !== 'notMultiplied',\n                stencil: true,\n                preserveDrawingBuffer: options.preserveDrawingBuffer,\n                powerPreference: _this.options.powerPreference,\n            });\n        }\n        /**\n         * Flag if we are rendering to the screen vs renderTexture\n         * @member {boolean}\n         * @readonly\n         * @default true\n         */\n        _this.renderingToScreen = true;\n        (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.sayHello)(_this.context.webGLVersion === 2 ? 'WebGL 2' : 'WebGL 1');\n        _this.resize(_this.options.width, _this.options.height);\n        return _this;\n    }\n    /**\n     * Create renderer if WebGL is available. Overrideable\n     * by the **@pixi/canvas-renderer** package to allow fallback.\n     * throws error if WebGL is not available.\n     * @static\n     * @private\n     */\n    Renderer.create = function (options) {\n        if ((0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.isWebGLSupported)()) {\n            return new Renderer(options);\n        }\n        throw new Error('WebGL unsupported in this browser, use \"pixi.js-legacy\" for fallback canvas2d support.');\n    };\n    /**\n     * Add a new system to the renderer.\n     * @param {Function} ClassRef - Class reference\n     * @param {string} [name] - Property name for system, if not specified\n     *        will use a static `name` property on the class itself. This\n     *        name will be assigned as s property on the Renderer so make\n     *        sure it doesn't collide with properties on Renderer.\n     * @return {PIXI.Renderer} Return instance of renderer\n     */\n    Renderer.prototype.addSystem = function (ClassRef, name) {\n        if (!name) {\n            name = ClassRef.name;\n        }\n        var system = new ClassRef(this);\n        if (this[name]) {\n            throw new Error(\"Whoops! The name \\\"\" + name + \"\\\" is already in use\");\n        }\n        this[name] = system;\n        for (var i in this.runners) {\n            this.runners[i].add(system);\n        }\n        /**\n         * Fired after rendering finishes.\n         *\n         * @event PIXI.Renderer#postrender\n         */\n        /**\n         * Fired before rendering starts.\n         *\n         * @event PIXI.Renderer#prerender\n         */\n        /**\n         * Fired when the WebGL context is set.\n         *\n         * @event PIXI.Renderer#context\n         * @param {WebGLRenderingContext} gl - WebGL context.\n         */\n        return this;\n    };\n    /**\n     * Renders the object to its WebGL view\n     *\n     * @param {PIXI.DisplayObject} displayObject - The object to be rendered.\n     * @param {PIXI.RenderTexture} [renderTexture] - The render texture to render to.\n     * @param {boolean} [clear=true] - Should the canvas be cleared before the new render.\n     * @param {PIXI.Matrix} [transform] - A transform to apply to the render texture before rendering.\n     * @param {boolean} [skipUpdateTransform=false] - Should we skip the update transform pass?\n     */\n    Renderer.prototype.render = function (displayObject, renderTexture, clear, transform, skipUpdateTransform) {\n        // can be handy to know!\n        this.renderingToScreen = !renderTexture;\n        this.runners.prerender.emit();\n        this.emit('prerender');\n        // apply a transform at a GPU level\n        this.projection.transform = transform;\n        // no point rendering if our context has been blown up!\n        if (this.context.isLost) {\n            return;\n        }\n        if (!renderTexture) {\n            this._lastObjectRendered = displayObject;\n        }\n        if (!skipUpdateTransform) {\n            // update the scene graph\n            var cacheParent = displayObject.enableTempParent();\n            displayObject.updateTransform();\n            displayObject.disableTempParent(cacheParent);\n            // displayObject.hitArea = //TODO add a temp hit area\n        }\n        this.renderTexture.bind(renderTexture);\n        this.batch.currentRenderer.start();\n        if (clear !== undefined ? clear : this.clearBeforeRender) {\n            this.renderTexture.clear();\n        }\n        displayObject.render(this);\n        // apply transform..\n        this.batch.currentRenderer.flush();\n        if (renderTexture) {\n            renderTexture.baseTexture.update();\n        }\n        this.runners.postrender.emit();\n        // reset transform after render\n        this.projection.transform = null;\n        this.emit('postrender');\n    };\n    /**\n     * Resizes the WebGL view to the specified width and height.\n     *\n     * @param {number} screenWidth - The new width of the screen.\n     * @param {number} screenHeight - The new height of the screen.\n     */\n    Renderer.prototype.resize = function (screenWidth, screenHeight) {\n        _super.prototype.resize.call(this, screenWidth, screenHeight);\n        this.runners.resize.emit(screenWidth, screenHeight);\n    };\n    /**\n     * Resets the WebGL state so you can render things however you fancy!\n     *\n     * @return {PIXI.Renderer} Returns itself.\n     */\n    Renderer.prototype.reset = function () {\n        this.runners.reset.emit();\n        return this;\n    };\n    /**\n     * Clear the frame buffer\n     */\n    Renderer.prototype.clear = function () {\n        this.renderTexture.bind();\n        this.renderTexture.clear();\n    };\n    /**\n     * Removes everything from the renderer (event listeners, spritebatch, etc...)\n     *\n     * @param {boolean} [removeView=false] - Removes the Canvas element from the DOM.\n     *  See: https://github.com/pixijs/pixi.js/issues/2233\n     */\n    Renderer.prototype.destroy = function (removeView) {\n        this.runners.destroy.emit();\n        for (var r in this.runners) {\n            this.runners[r].destroy();\n        }\n        // call base destroy\n        _super.prototype.destroy.call(this, removeView);\n        // TODO nullify all the managers..\n        this.gl = null;\n    };\n    /**\n     * Adds a plugin to the renderer.\n     *\n     * @method\n     * @param {string} pluginName - The name of the plugin.\n     * @param {Function} ctor - The constructor function or class for the plugin.\n     */\n    Renderer.registerPlugin = function (pluginName, ctor) {\n        Renderer.__plugins = Renderer.__plugins || {};\n        Renderer.__plugins[pluginName] = ctor;\n    };\n    return Renderer;\n}(AbstractRenderer));\n\n/**\n * This helper function will automatically detect which renderer you should be using.\n * WebGL is the preferred renderer as it is a lot faster. If WebGL is not supported by\n * the browser then this function will return a canvas renderer\n *\n * @memberof PIXI\n * @function autoDetectRenderer\n * @param {object} [options] - The optional renderer parameters\n * @param {number} [options.width=800] - the width of the renderers view\n * @param {number} [options.height=600] - the height of the renderers view\n * @param {HTMLCanvasElement} [options.view] - the canvas to use as a view, optional\n * @param {boolean} [options.transparent=false] - If the render view is transparent, default false\n * @param {boolean} [options.autoDensity=false] - Resizes renderer view in CSS pixels to allow for\n *   resolutions other than 1\n * @param {boolean} [options.antialias=false] - sets antialias\n * @param {boolean} [options.preserveDrawingBuffer=false] - enables drawing buffer preservation, enable this if you\n *  need to call toDataUrl on the webgl context\n * @param {number} [options.backgroundColor=0x000000] - The background color of the rendered area\n *  (shown if not transparent).\n * @param {boolean} [options.clearBeforeRender=true] - This sets if the renderer will clear the canvas or\n *   not before the new render pass.\n * @param {number} [options.resolution=1] - The resolution / device pixel ratio of the renderer, retina would be 2\n * @param {boolean} [options.forceCanvas=false] - prevents selection of WebGL renderer, even if such is present, this\n *   option only is available when using **pixi.js-legacy** or **@pixi/canvas-renderer** modules, otherwise\n *   it is ignored.\n * @param {string} [options.powerPreference] - Parameter passed to webgl context, set to \"high-performance\"\n *  for devices with dual graphics card **webgl only**\n * @return {PIXI.Renderer|PIXI.CanvasRenderer} Returns WebGL renderer if available, otherwise CanvasRenderer\n */\nfunction autoDetectRenderer(options) {\n    return Renderer.create(options);\n}\n\nvar _default = \"attribute vec2 aVertexPosition;\\nattribute vec2 aTextureCoord;\\n\\nuniform mat3 projectionMatrix;\\n\\nvarying vec2 vTextureCoord;\\n\\nvoid main(void)\\n{\\n    gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\\n    vTextureCoord = aTextureCoord;\\n}\";\n\nvar defaultFilter = \"attribute vec2 aVertexPosition;\\n\\nuniform mat3 projectionMatrix;\\n\\nvarying vec2 vTextureCoord;\\n\\nuniform vec4 inputSize;\\nuniform vec4 outputFrame;\\n\\nvec4 filterVertexPosition( void )\\n{\\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\\n\\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\\n}\\n\\nvec2 filterTextureCoord( void )\\n{\\n    return aVertexPosition * (outputFrame.zw * inputSize.zw);\\n}\\n\\nvoid main(void)\\n{\\n    gl_Position = filterVertexPosition();\\n    vTextureCoord = filterTextureCoord();\\n}\\n\";\n\n/**\n * Used by the batcher to draw batches.\n * Each one of these contains all information required to draw a bound geometry.\n *\n * @class\n * @memberof PIXI\n */\nvar BatchDrawCall = /** @class */ (function () {\n    function BatchDrawCall() {\n        this.texArray = null;\n        this.blend = 0;\n        this.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.DRAW_MODES.TRIANGLES;\n        this.start = 0;\n        this.size = 0;\n        /**\n         * data for uniforms or custom webgl state\n         * @member {object}\n         */\n        this.data = null;\n    }\n    return BatchDrawCall;\n}());\n\n/**\n * Used by the batcher to build texture batches.\n * Holds list of textures and their respective locations.\n *\n * @class\n * @memberof PIXI\n */\nvar BatchTextureArray = /** @class */ (function () {\n    function BatchTextureArray() {\n        /**\n         * inside textures array\n         * @member {PIXI.BaseTexture[]}\n         */\n        this.elements = [];\n        /**\n         * Respective locations for textures\n         * @member {number[]}\n         */\n        this.ids = [];\n        /**\n         * number of filled elements\n         * @member {number}\n         */\n        this.count = 0;\n    }\n    BatchTextureArray.prototype.clear = function () {\n        for (var i = 0; i < this.count; i++) {\n            this.elements[i] = null;\n        }\n        this.count = 0;\n    };\n    return BatchTextureArray;\n}());\n\n/**\n * Flexible wrapper around `ArrayBuffer` that also provides\n * typed array views on demand.\n *\n * @class\n * @memberof PIXI\n */\nvar ViewableBuffer = /** @class */ (function () {\n    /**\n     * @param {number} size - The size of the buffer in bytes.\n     */\n    function ViewableBuffer(size) {\n        /**\n         * Underlying `ArrayBuffer` that holds all the data\n         * and is of capacity `size`.\n         *\n         * @member {ArrayBuffer}\n         */\n        this.rawBinaryData = new ArrayBuffer(size);\n        /**\n         * View on the raw binary data as a `Uint32Array`.\n         *\n         * @member {Uint32Array}\n         */\n        this.uint32View = new Uint32Array(this.rawBinaryData);\n        /**\n         * View on the raw binary data as a `Float32Array`.\n         *\n         * @member {Float32Array}\n         */\n        this.float32View = new Float32Array(this.rawBinaryData);\n    }\n    Object.defineProperty(ViewableBuffer.prototype, \"int8View\", {\n        /**\n         * View on the raw binary data as a `Int8Array`.\n         *\n         * @member {Int8Array}\n         */\n        get: function () {\n            if (!this._int8View) {\n                this._int8View = new Int8Array(this.rawBinaryData);\n            }\n            return this._int8View;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ViewableBuffer.prototype, \"uint8View\", {\n        /**\n         * View on the raw binary data as a `Uint8Array`.\n         *\n         * @member {Uint8Array}\n         */\n        get: function () {\n            if (!this._uint8View) {\n                this._uint8View = new Uint8Array(this.rawBinaryData);\n            }\n            return this._uint8View;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ViewableBuffer.prototype, \"int16View\", {\n        /**\n         * View on the raw binary data as a `Int16Array`.\n         *\n         * @member {Int16Array}\n         */\n        get: function () {\n            if (!this._int16View) {\n                this._int16View = new Int16Array(this.rawBinaryData);\n            }\n            return this._int16View;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ViewableBuffer.prototype, \"uint16View\", {\n        /**\n         * View on the raw binary data as a `Uint16Array`.\n         *\n         * @member {Uint16Array}\n         */\n        get: function () {\n            if (!this._uint16View) {\n                this._uint16View = new Uint16Array(this.rawBinaryData);\n            }\n            return this._uint16View;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ViewableBuffer.prototype, \"int32View\", {\n        /**\n         * View on the raw binary data as a `Int32Array`.\n         *\n         * @member {Int32Array}\n         */\n        get: function () {\n            if (!this._int32View) {\n                this._int32View = new Int32Array(this.rawBinaryData);\n            }\n            return this._int32View;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Returns the view of the given type.\n     *\n     * @param {string} type - One of `int8`, `uint8`, `int16`,\n     *    `uint16`, `int32`, `uint32`, and `float32`.\n     * @return {object} typed array of given type\n     */\n    ViewableBuffer.prototype.view = function (type) {\n        return this[type + \"View\"];\n    };\n    /**\n     * Destroys all buffer references. Do not use after calling\n     * this.\n     */\n    ViewableBuffer.prototype.destroy = function () {\n        this.rawBinaryData = null;\n        this._int8View = null;\n        this._uint8View = null;\n        this._int16View = null;\n        this._uint16View = null;\n        this._int32View = null;\n        this.uint32View = null;\n        this.float32View = null;\n    };\n    ViewableBuffer.sizeOf = function (type) {\n        switch (type) {\n            case 'int8':\n            case 'uint8':\n                return 1;\n            case 'int16':\n            case 'uint16':\n                return 2;\n            case 'int32':\n            case 'uint32':\n            case 'float32':\n                return 4;\n            default:\n                throw new Error(type + \" isn't a valid view type\");\n        }\n    };\n    return ViewableBuffer;\n}());\n\n/**\n * Renderer dedicated to drawing and batching sprites.\n *\n * This is the default batch renderer. It buffers objects\n * with texture-based geometries and renders them in\n * batches. It uploads multiple textures to the GPU to\n * reduce to the number of draw calls.\n *\n * @class\n * @protected\n * @memberof PIXI\n * @extends PIXI.ObjectRenderer\n */\nvar AbstractBatchRenderer = /** @class */ (function (_super) {\n    __extends(AbstractBatchRenderer, _super);\n    /**\n     * This will hook onto the renderer's `contextChange`\n     * and `prerender` signals.\n     *\n     * @param {PIXI.Renderer} renderer - The renderer this works for.\n     */\n    function AbstractBatchRenderer(renderer) {\n        var _this = _super.call(this, renderer) || this;\n        /**\n         * This is used to generate a shader that can\n         * color each vertex based on a `aTextureId`\n         * attribute that points to an texture in `uSampler`.\n         *\n         * This enables the objects with different textures\n         * to be drawn in the same draw call.\n         *\n         * You can customize your shader by creating your\n         * custom shader generator.\n         *\n         * @member {PIXI.BatchShaderGenerator}\n         * @protected\n         */\n        _this.shaderGenerator = null;\n        /**\n         * The class that represents the geometry of objects\n         * that are going to be batched with this.\n         *\n         * @member {object}\n         * @default PIXI.BatchGeometry\n         * @protected\n         */\n        _this.geometryClass = null;\n        /**\n         * Size of data being buffered per vertex in the\n         * attribute buffers (in floats). By default, the\n         * batch-renderer plugin uses 6:\n         *\n         * | aVertexPosition | 2 |\n         * |-----------------|---|\n         * | aTextureCoords  | 2 |\n         * | aColor          | 1 |\n         * | aTextureId      | 1 |\n         *\n         * @member {number}\n         * @readonly\n         */\n        _this.vertexSize = null;\n        /**\n         * The WebGL state in which this renderer will work.\n         *\n         * @member {PIXI.State}\n         * @readonly\n         */\n        _this.state = State.for2d();\n        /**\n         * The number of bufferable objects before a flush\n         * occurs automatically.\n         *\n         * @member {number}\n         * @default settings.SPRITE_BATCH_SIZE * 4\n         */\n        _this.size = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SPRITE_BATCH_SIZE * 4;\n        /**\n         * Total count of all vertices used by the currently\n         * buffered objects.\n         *\n         * @member {number}\n         * @private\n         */\n        _this._vertexCount = 0;\n        /**\n         * Total count of all indices used by the currently\n         * buffered objects.\n         *\n         * @member {number}\n         * @private\n         */\n        _this._indexCount = 0;\n        /**\n         * Buffer of objects that are yet to be rendered.\n         *\n         * @member {PIXI.DisplayObject[]}\n         * @private\n         */\n        _this._bufferedElements = [];\n        /**\n         * Data for texture batch builder, helps to save a bit of CPU on a pass.\n         * @type {PIXI.BaseTexture[]}\n         * @private\n         */\n        _this._bufferedTextures = [];\n        /**\n         * Number of elements that are buffered and are\n         * waiting to be flushed.\n         *\n         * @member {number}\n         * @private\n         */\n        _this._bufferSize = 0;\n        /**\n         * This shader is generated by `this.shaderGenerator`.\n         *\n         * It is generated specifically to handle the required\n         * number of textures being batched together.\n         *\n         * @member {PIXI.Shader}\n         * @protected\n         */\n        _this._shader = null;\n        /**\n         * Pool of `this.geometryClass` geometry objects\n         * that store buffers. They are used to pass data\n         * to the shader on each draw call.\n         *\n         * These are never re-allocated again, unless a\n         * context change occurs; however, the pool may\n         * be expanded if required.\n         *\n         * @member {PIXI.Geometry[]}\n         * @private\n         * @see PIXI.AbstractBatchRenderer.contextChange\n         */\n        _this._packedGeometries = [];\n        /**\n         * Size of `this._packedGeometries`. It can be expanded\n         * if more than `this._packedGeometryPoolSize` flushes\n         * occur in a single frame.\n         *\n         * @member {number}\n         * @private\n         */\n        _this._packedGeometryPoolSize = 2;\n        /**\n         * A flush may occur multiple times in a single\n         * frame. On iOS devices or when\n         * `settings.CAN_UPLOAD_SAME_BUFFER` is false, the\n         * batch renderer does not upload data to the same\n         * `WebGLBuffer` for performance reasons.\n         *\n         * This is the index into `packedGeometries` that points to\n         * geometry holding the most recent buffers.\n         *\n         * @member {number}\n         * @private\n         */\n        _this._flushId = 0;\n        /**\n         * Pool of `ViewableBuffer` objects that are sorted in\n         * order of increasing size. The flush method uses\n         * the buffer with the least size above the amount\n         * it requires. These are used for passing attributes.\n         *\n         * The first buffer has a size of 8; each subsequent\n         * buffer has double capacity of its previous.\n         *\n         * @member {PIXI.ViewableBuffer[]}\n         * @private\n         * @see PIXI.AbstractBatchRenderer#getAttributeBuffer\n         */\n        _this._aBuffers = {};\n        /**\n         * Pool of `Uint16Array` objects that are sorted in\n         * order of increasing size. The flush method uses\n         * the buffer with the least size above the amount\n         * it requires. These are used for passing indices.\n         *\n         * The first buffer has a size of 12; each subsequent\n         * buffer has double capacity of its previous.\n         *\n         * @member {Uint16Array[]}\n         * @private\n         * @see PIXI.AbstractBatchRenderer#getIndexBuffer\n         */\n        _this._iBuffers = {};\n        /**\n         * Maximum number of textures that can be uploaded to\n         * the GPU under the current context. It is initialized\n         * properly in `this.contextChange`.\n         *\n         * @member {number}\n         * @see PIXI.AbstractBatchRenderer#contextChange\n         * @readonly\n         */\n        _this.MAX_TEXTURES = 1;\n        _this.renderer.on('prerender', _this.onPrerender, _this);\n        renderer.runners.contextChange.add(_this);\n        _this._dcIndex = 0;\n        _this._aIndex = 0;\n        _this._iIndex = 0;\n        _this._attributeBuffer = null;\n        _this._indexBuffer = null;\n        _this._tempBoundTextures = [];\n        return _this;\n    }\n    /**\n     * Handles the `contextChange` signal.\n     *\n     * It calculates `this.MAX_TEXTURES` and allocating the\n     * packed-geometry object pool.\n     */\n    AbstractBatchRenderer.prototype.contextChange = function () {\n        var gl = this.renderer.gl;\n        if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.PREFER_ENV === _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.ENV.WEBGL_LEGACY) {\n            this.MAX_TEXTURES = 1;\n        }\n        else {\n            // step 1: first check max textures the GPU can handle.\n            this.MAX_TEXTURES = Math.min(gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS), _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SPRITE_MAX_TEXTURES);\n            // step 2: check the maximum number of if statements the shader can have too..\n            this.MAX_TEXTURES = checkMaxIfStatementsInShader(this.MAX_TEXTURES, gl);\n        }\n        this._shader = this.shaderGenerator.generateShader(this.MAX_TEXTURES);\n        // we use the second shader as the first one depending on your browser\n        // may omit aTextureId as it is not used by the shader so is optimized out.\n        for (var i = 0; i < this._packedGeometryPoolSize; i++) {\n            /* eslint-disable max-len */\n            this._packedGeometries[i] = new (this.geometryClass)();\n        }\n        this.initFlushBuffers();\n    };\n    /**\n     * Makes sure that static and dynamic flush pooled objects have correct dimensions\n     */\n    AbstractBatchRenderer.prototype.initFlushBuffers = function () {\n        var _drawCallPool = AbstractBatchRenderer._drawCallPool, _textureArrayPool = AbstractBatchRenderer._textureArrayPool;\n        // max draw calls\n        var MAX_SPRITES = this.size / 4;\n        // max texture arrays\n        var MAX_TA = Math.floor(MAX_SPRITES / this.MAX_TEXTURES) + 1;\n        while (_drawCallPool.length < MAX_SPRITES) {\n            _drawCallPool.push(new BatchDrawCall());\n        }\n        while (_textureArrayPool.length < MAX_TA) {\n            _textureArrayPool.push(new BatchTextureArray());\n        }\n        for (var i = 0; i < this.MAX_TEXTURES; i++) {\n            this._tempBoundTextures[i] = null;\n        }\n    };\n    /**\n     * Handles the `prerender` signal.\n     *\n     * It ensures that flushes start from the first geometry\n     * object again.\n     */\n    AbstractBatchRenderer.prototype.onPrerender = function () {\n        this._flushId = 0;\n    };\n    /**\n     * Buffers the \"batchable\" object. It need not be rendered\n     * immediately.\n     *\n     * @param {PIXI.DisplayObject} element - the element to render when\n     *    using this renderer\n     */\n    AbstractBatchRenderer.prototype.render = function (element) {\n        if (!element._texture.valid) {\n            return;\n        }\n        if (this._vertexCount + (element.vertexData.length / 2) > this.size) {\n            this.flush();\n        }\n        this._vertexCount += element.vertexData.length / 2;\n        this._indexCount += element.indices.length;\n        this._bufferedTextures[this._bufferSize] = element._texture.baseTexture;\n        this._bufferedElements[this._bufferSize++] = element;\n    };\n    AbstractBatchRenderer.prototype.buildTexturesAndDrawCalls = function () {\n        var _a = this, textures = _a._bufferedTextures, MAX_TEXTURES = _a.MAX_TEXTURES;\n        var textureArrays = AbstractBatchRenderer._textureArrayPool;\n        var batch = this.renderer.batch;\n        var boundTextures = this._tempBoundTextures;\n        var touch = this.renderer.textureGC.count;\n        var TICK = ++BaseTexture._globalBatch;\n        var countTexArrays = 0;\n        var texArray = textureArrays[0];\n        var start = 0;\n        batch.copyBoundTextures(boundTextures, MAX_TEXTURES);\n        for (var i = 0; i < this._bufferSize; ++i) {\n            var tex = textures[i];\n            textures[i] = null;\n            if (tex._batchEnabled === TICK) {\n                continue;\n            }\n            if (texArray.count >= MAX_TEXTURES) {\n                batch.boundArray(texArray, boundTextures, TICK, MAX_TEXTURES);\n                this.buildDrawCalls(texArray, start, i);\n                start = i;\n                texArray = textureArrays[++countTexArrays];\n                ++TICK;\n            }\n            tex._batchEnabled = TICK;\n            tex.touched = touch;\n            texArray.elements[texArray.count++] = tex;\n        }\n        if (texArray.count > 0) {\n            batch.boundArray(texArray, boundTextures, TICK, MAX_TEXTURES);\n            this.buildDrawCalls(texArray, start, this._bufferSize);\n            ++countTexArrays;\n            ++TICK;\n        }\n        // Clean-up\n        for (var i = 0; i < boundTextures.length; i++) {\n            boundTextures[i] = null;\n        }\n        BaseTexture._globalBatch = TICK;\n    };\n    /**\n     * Populating drawcalls for rendering\n     *\n     * @param {PIXI.BatchTextureArray} texArray\n     * @param {number} start\n     * @param {number} finish\n     */\n    AbstractBatchRenderer.prototype.buildDrawCalls = function (texArray, start, finish) {\n        var _a = this, elements = _a._bufferedElements, _attributeBuffer = _a._attributeBuffer, _indexBuffer = _a._indexBuffer, vertexSize = _a.vertexSize;\n        var drawCalls = AbstractBatchRenderer._drawCallPool;\n        var dcIndex = this._dcIndex;\n        var aIndex = this._aIndex;\n        var iIndex = this._iIndex;\n        var drawCall = drawCalls[dcIndex];\n        drawCall.start = this._iIndex;\n        drawCall.texArray = texArray;\n        for (var i = start; i < finish; ++i) {\n            var sprite = elements[i];\n            var tex = sprite._texture.baseTexture;\n            var spriteBlendMode = _pixi_utils__WEBPACK_IMPORTED_MODULE_2__.premultiplyBlendMode[tex.alphaMode ? 1 : 0][sprite.blendMode];\n            elements[i] = null;\n            if (start < i && drawCall.blend !== spriteBlendMode) {\n                drawCall.size = iIndex - drawCall.start;\n                start = i;\n                drawCall = drawCalls[++dcIndex];\n                drawCall.texArray = texArray;\n                drawCall.start = iIndex;\n            }\n            this.packInterleavedGeometry(sprite, _attributeBuffer, _indexBuffer, aIndex, iIndex);\n            aIndex += sprite.vertexData.length / 2 * vertexSize;\n            iIndex += sprite.indices.length;\n            drawCall.blend = spriteBlendMode;\n        }\n        if (start < finish) {\n            drawCall.size = iIndex - drawCall.start;\n            ++dcIndex;\n        }\n        this._dcIndex = dcIndex;\n        this._aIndex = aIndex;\n        this._iIndex = iIndex;\n    };\n    /**\n     * Bind textures for current rendering\n     *\n     * @param {PIXI.BatchTextureArray} texArray\n     */\n    AbstractBatchRenderer.prototype.bindAndClearTexArray = function (texArray) {\n        var textureSystem = this.renderer.texture;\n        for (var j = 0; j < texArray.count; j++) {\n            textureSystem.bind(texArray.elements[j], texArray.ids[j]);\n            texArray.elements[j] = null;\n        }\n        texArray.count = 0;\n    };\n    AbstractBatchRenderer.prototype.updateGeometry = function () {\n        var _a = this, packedGeometries = _a._packedGeometries, attributeBuffer = _a._attributeBuffer, indexBuffer = _a._indexBuffer;\n        if (!_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.CAN_UPLOAD_SAME_BUFFER) { /* Usually on iOS devices, where the browser doesn't\n            like uploads to the same buffer in a single frame. */\n            if (this._packedGeometryPoolSize <= this._flushId) {\n                this._packedGeometryPoolSize++;\n                packedGeometries[this._flushId] = new (this.geometryClass)();\n            }\n            packedGeometries[this._flushId]._buffer.update(attributeBuffer.rawBinaryData);\n            packedGeometries[this._flushId]._indexBuffer.update(indexBuffer);\n            this.renderer.geometry.bind(packedGeometries[this._flushId]);\n            this.renderer.geometry.updateBuffers();\n            this._flushId++;\n        }\n        else {\n            // lets use the faster option, always use buffer number 0\n            packedGeometries[this._flushId]._buffer.update(attributeBuffer.rawBinaryData);\n            packedGeometries[this._flushId]._indexBuffer.update(indexBuffer);\n            this.renderer.geometry.updateBuffers();\n        }\n    };\n    AbstractBatchRenderer.prototype.drawBatches = function () {\n        var dcCount = this._dcIndex;\n        var _a = this.renderer, gl = _a.gl, stateSystem = _a.state;\n        var drawCalls = AbstractBatchRenderer._drawCallPool;\n        var curTexArray = null;\n        // Upload textures and do the draw calls\n        for (var i = 0; i < dcCount; i++) {\n            var _b = drawCalls[i], texArray = _b.texArray, type = _b.type, size = _b.size, start = _b.start, blend = _b.blend;\n            if (curTexArray !== texArray) {\n                curTexArray = texArray;\n                this.bindAndClearTexArray(texArray);\n            }\n            this.state.blendMode = blend;\n            stateSystem.set(this.state);\n            gl.drawElements(type, size, gl.UNSIGNED_SHORT, start * 2);\n        }\n    };\n    /**\n     * Renders the content _now_ and empties the current batch.\n     */\n    AbstractBatchRenderer.prototype.flush = function () {\n        if (this._vertexCount === 0) {\n            return;\n        }\n        this._attributeBuffer = this.getAttributeBuffer(this._vertexCount);\n        this._indexBuffer = this.getIndexBuffer(this._indexCount);\n        this._aIndex = 0;\n        this._iIndex = 0;\n        this._dcIndex = 0;\n        this.buildTexturesAndDrawCalls();\n        this.updateGeometry();\n        this.drawBatches();\n        // reset elements buffer for the next flush\n        this._bufferSize = 0;\n        this._vertexCount = 0;\n        this._indexCount = 0;\n    };\n    /**\n     * Starts a new sprite batch.\n     */\n    AbstractBatchRenderer.prototype.start = function () {\n        this.renderer.state.set(this.state);\n        this.renderer.shader.bind(this._shader);\n        if (_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.CAN_UPLOAD_SAME_BUFFER) {\n            // bind buffer #0, we don't need others\n            this.renderer.geometry.bind(this._packedGeometries[this._flushId]);\n        }\n    };\n    /**\n     * Stops and flushes the current batch.\n     */\n    AbstractBatchRenderer.prototype.stop = function () {\n        this.flush();\n    };\n    /**\n     * Destroys this `AbstractBatchRenderer`. It cannot be used again.\n     */\n    AbstractBatchRenderer.prototype.destroy = function () {\n        for (var i = 0; i < this._packedGeometryPoolSize; i++) {\n            if (this._packedGeometries[i]) {\n                this._packedGeometries[i].destroy();\n            }\n        }\n        this.renderer.off('prerender', this.onPrerender, this);\n        this._aBuffers = null;\n        this._iBuffers = null;\n        this._packedGeometries = null;\n        this._attributeBuffer = null;\n        this._indexBuffer = null;\n        if (this._shader) {\n            this._shader.destroy();\n            this._shader = null;\n        }\n        _super.prototype.destroy.call(this);\n    };\n    /**\n     * Fetches an attribute buffer from `this._aBuffers` that\n     * can hold atleast `size` floats.\n     *\n     * @param {number} size - minimum capacity required\n     * @return {ViewableBuffer} - buffer than can hold atleast `size` floats\n     * @private\n     */\n    AbstractBatchRenderer.prototype.getAttributeBuffer = function (size) {\n        // 8 vertices is enough for 2 quads\n        var roundedP2 = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.nextPow2)(Math.ceil(size / 8));\n        var roundedSizeIndex = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.log2)(roundedP2);\n        var roundedSize = roundedP2 * 8;\n        if (this._aBuffers.length <= roundedSizeIndex) {\n            this._iBuffers.length = roundedSizeIndex + 1;\n        }\n        var buffer = this._aBuffers[roundedSize];\n        if (!buffer) {\n            this._aBuffers[roundedSize] = buffer = new ViewableBuffer(roundedSize * this.vertexSize * 4);\n        }\n        return buffer;\n    };\n    /**\n     * Fetches an index buffer from `this._iBuffers` that can\n     * have at least `size` capacity.\n     *\n     * @param {number} size - minimum required capacity\n     * @return {Uint16Array} - buffer that can fit `size`\n     *    indices.\n     * @private\n     */\n    AbstractBatchRenderer.prototype.getIndexBuffer = function (size) {\n        // 12 indices is enough for 2 quads\n        var roundedP2 = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.nextPow2)(Math.ceil(size / 12));\n        var roundedSizeIndex = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.log2)(roundedP2);\n        var roundedSize = roundedP2 * 12;\n        if (this._iBuffers.length <= roundedSizeIndex) {\n            this._iBuffers.length = roundedSizeIndex + 1;\n        }\n        var buffer = this._iBuffers[roundedSizeIndex];\n        if (!buffer) {\n            this._iBuffers[roundedSizeIndex] = buffer = new Uint16Array(roundedSize);\n        }\n        return buffer;\n    };\n    /**\n     * Takes the four batching parameters of `element`, interleaves\n     * and pushes them into the batching attribute/index buffers given.\n     *\n     * It uses these properties: `vertexData` `uvs`, `textureId` and\n     * `indicies`. It also uses the \"tint\" of the base-texture, if\n     * present.\n     *\n     * @param {PIXI.Sprite} element - element being rendered\n     * @param {PIXI.ViewableBuffer} attributeBuffer - attribute buffer.\n     * @param {Uint16Array} indexBuffer - index buffer\n     * @param {number} aIndex - number of floats already in the attribute buffer\n     * @param {number} iIndex - number of indices already in `indexBuffer`\n     */\n    AbstractBatchRenderer.prototype.packInterleavedGeometry = function (element, attributeBuffer, indexBuffer, aIndex, iIndex) {\n        var uint32View = attributeBuffer.uint32View, float32View = attributeBuffer.float32View;\n        var packedVertices = aIndex / this.vertexSize;\n        var uvs = element.uvs;\n        var indicies = element.indices;\n        var vertexData = element.vertexData;\n        var textureId = element._texture.baseTexture._batchLocation;\n        var alpha = Math.min(element.worldAlpha, 1.0);\n        var argb = (alpha < 1.0\n            && element._texture.baseTexture.alphaMode)\n            ? (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.premultiplyTint)(element._tintRGB, alpha)\n            : element._tintRGB + (alpha * 255 << 24);\n        // lets not worry about tint! for now..\n        for (var i = 0; i < vertexData.length; i += 2) {\n            float32View[aIndex++] = vertexData[i];\n            float32View[aIndex++] = vertexData[i + 1];\n            float32View[aIndex++] = uvs[i];\n            float32View[aIndex++] = uvs[i + 1];\n            uint32View[aIndex++] = argb;\n            float32View[aIndex++] = textureId;\n        }\n        for (var i = 0; i < indicies.length; i++) {\n            indexBuffer[iIndex++] = packedVertices + indicies[i];\n        }\n    };\n    /**\n     * Pool of `BatchDrawCall` objects that `flush` used\n     * to create \"batches\" of the objects being rendered.\n     *\n     * These are never re-allocated again.\n     * Shared between all batch renderers because it can be only one \"flush\" working at the moment.\n     *\n     * @static\n     * @member {PIXI.BatchDrawCall[]}\n     */\n    AbstractBatchRenderer._drawCallPool = [];\n    /**\n     * Pool of `BatchDrawCall` objects that `flush` used\n     * to create \"batches\" of the objects being rendered.\n     *\n     * These are never re-allocated again.\n     * Shared between all batch renderers because it can be only one \"flush\" working at the moment.\n     *\n     * @static\n     * @member {PIXI.BatchTextureArray[]}\n     */\n    AbstractBatchRenderer._textureArrayPool = [];\n    return AbstractBatchRenderer;\n}(ObjectRenderer));\n\n/**\n * Helper that generates batching multi-texture shader. Use it with your new BatchRenderer\n *\n * @class\n * @memberof PIXI\n */\nvar BatchShaderGenerator = /** @class */ (function () {\n    /**\n     * @param {string} vertexSrc - Vertex shader\n     * @param {string} fragTemplate - Fragment shader template\n     */\n    function BatchShaderGenerator(vertexSrc, fragTemplate) {\n        /**\n         * Reference to the vertex shader source.\n         *\n         * @member {string}\n         */\n        this.vertexSrc = vertexSrc;\n        /**\n         * Reference to the fragement shader template. Must contain \"%count%\" and \"%forloop%\".\n         *\n         * @member {string}\n         */\n        this.fragTemplate = fragTemplate;\n        this.programCache = {};\n        this.defaultGroupCache = {};\n        if (fragTemplate.indexOf('%count%') < 0) {\n            throw new Error('Fragment template must contain \"%count%\".');\n        }\n        if (fragTemplate.indexOf('%forloop%') < 0) {\n            throw new Error('Fragment template must contain \"%forloop%\".');\n        }\n    }\n    BatchShaderGenerator.prototype.generateShader = function (maxTextures) {\n        if (!this.programCache[maxTextures]) {\n            var sampleValues = new Int32Array(maxTextures);\n            for (var i = 0; i < maxTextures; i++) {\n                sampleValues[i] = i;\n            }\n            this.defaultGroupCache[maxTextures] = UniformGroup.from({ uSamplers: sampleValues }, true);\n            var fragmentSrc = this.fragTemplate;\n            fragmentSrc = fragmentSrc.replace(/%count%/gi, \"\" + maxTextures);\n            fragmentSrc = fragmentSrc.replace(/%forloop%/gi, this.generateSampleSrc(maxTextures));\n            this.programCache[maxTextures] = new Program(this.vertexSrc, fragmentSrc);\n        }\n        var uniforms = {\n            tint: new Float32Array([1, 1, 1, 1]),\n            translationMatrix: new _pixi_math__WEBPACK_IMPORTED_MODULE_5__.Matrix(),\n            default: this.defaultGroupCache[maxTextures],\n        };\n        return new Shader(this.programCache[maxTextures], uniforms);\n    };\n    BatchShaderGenerator.prototype.generateSampleSrc = function (maxTextures) {\n        var src = '';\n        src += '\\n';\n        src += '\\n';\n        for (var i = 0; i < maxTextures; i++) {\n            if (i > 0) {\n                src += '\\nelse ';\n            }\n            if (i < maxTextures - 1) {\n                src += \"if(vTextureId < \" + i + \".5)\";\n            }\n            src += '\\n{';\n            src += \"\\n\\tcolor = texture2D(uSamplers[\" + i + \"], vTextureCoord);\";\n            src += '\\n}';\n        }\n        src += '\\n';\n        src += '\\n';\n        return src;\n    };\n    return BatchShaderGenerator;\n}());\n\n/**\n * Geometry used to batch standard PIXI content (e.g. Mesh, Sprite, Graphics objects).\n *\n * @class\n * @memberof PIXI\n */\nvar BatchGeometry = /** @class */ (function (_super) {\n    __extends(BatchGeometry, _super);\n    /**\n     * @param {boolean} [_static=false] - Optimization flag, where `false`\n     *        is updated every frame, `true` doesn't change frame-to-frame.\n     */\n    function BatchGeometry(_static) {\n        if (_static === void 0) { _static = false; }\n        var _this = _super.call(this) || this;\n        /**\n         * Buffer used for position, color, texture IDs\n         *\n         * @member {PIXI.Buffer}\n         * @protected\n         */\n        _this._buffer = new Buffer(null, _static, false);\n        /**\n         * Index buffer data\n         *\n         * @member {PIXI.Buffer}\n         * @protected\n         */\n        _this._indexBuffer = new Buffer(null, _static, true);\n        _this.addAttribute('aVertexPosition', _this._buffer, 2, false, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.FLOAT)\n            .addAttribute('aTextureCoord', _this._buffer, 2, false, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.FLOAT)\n            .addAttribute('aColor', _this._buffer, 4, true, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.UNSIGNED_BYTE)\n            .addAttribute('aTextureId', _this._buffer, 1, true, _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.FLOAT)\n            .addIndex(_this._indexBuffer);\n        return _this;\n    }\n    return BatchGeometry;\n}(Geometry));\n\nvar defaultVertex$2 = \"precision highp float;\\nattribute vec2 aVertexPosition;\\nattribute vec2 aTextureCoord;\\nattribute vec4 aColor;\\nattribute float aTextureId;\\n\\nuniform mat3 projectionMatrix;\\nuniform mat3 translationMatrix;\\nuniform vec4 tint;\\n\\nvarying vec2 vTextureCoord;\\nvarying vec4 vColor;\\nvarying float vTextureId;\\n\\nvoid main(void){\\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\\n\\n    vTextureCoord = aTextureCoord;\\n    vTextureId = aTextureId;\\n    vColor = aColor * tint;\\n}\\n\";\n\nvar defaultFragment$2 = \"varying vec2 vTextureCoord;\\nvarying vec4 vColor;\\nvarying float vTextureId;\\nuniform sampler2D uSamplers[%count%];\\n\\nvoid main(void){\\n    vec4 color;\\n    %forloop%\\n    gl_FragColor = color * vColor;\\n}\\n\";\n\n/**\n * @class\n * @memberof PIXI\n * @hideconstructor\n */\nvar BatchPluginFactory = /** @class */ (function () {\n    function BatchPluginFactory() {\n    }\n    /**\n     * Create a new BatchRenderer plugin for Renderer. this convenience can provide an easy way\n     * to extend BatchRenderer with all the necessary pieces.\n     * @example\n     * const fragment = `\n     * varying vec2 vTextureCoord;\n     * varying vec4 vColor;\n     * varying float vTextureId;\n     * uniform sampler2D uSamplers[%count%];\n     *\n     * void main(void){\n     *     vec4 color;\n     *     %forloop%\n     *     gl_FragColor = vColor * vec4(color.a - color.rgb, color.a);\n     * }\n     * `;\n     * const InvertBatchRenderer = PIXI.BatchPluginFactory.create({ fragment });\n     * PIXI.Renderer.registerPlugin('invert', InvertBatchRenderer);\n     * const sprite = new PIXI.Sprite();\n     * sprite.pluginName = 'invert';\n     *\n     * @static\n     * @param {object} [options]\n     * @param {string} [options.vertex=PIXI.BatchPluginFactory.defaultVertexSrc] - Vertex shader source\n     * @param {string} [options.fragment=PIXI.BatchPluginFactory.defaultFragmentTemplate] - Fragment shader template\n     * @param {number} [options.vertexSize=6] - Vertex size\n     * @param {object} [options.geometryClass=PIXI.BatchGeometry]\n     * @return {*} New batch renderer plugin\n     */\n    BatchPluginFactory.create = function (options) {\n        var _a = Object.assign({\n            vertex: defaultVertex$2,\n            fragment: defaultFragment$2,\n            geometryClass: BatchGeometry,\n            vertexSize: 6,\n        }, options), vertex = _a.vertex, fragment = _a.fragment, vertexSize = _a.vertexSize, geometryClass = _a.geometryClass;\n        return /** @class */ (function (_super) {\n            __extends(BatchPlugin, _super);\n            function BatchPlugin(renderer) {\n                var _this = _super.call(this, renderer) || this;\n                _this.shaderGenerator = new BatchShaderGenerator(vertex, fragment);\n                _this.geometryClass = geometryClass;\n                _this.vertexSize = vertexSize;\n                return _this;\n            }\n            return BatchPlugin;\n        }(AbstractBatchRenderer));\n    };\n    Object.defineProperty(BatchPluginFactory, \"defaultVertexSrc\", {\n        /**\n         * The default vertex shader source\n         *\n         * @static\n         * @type {string}\n         * @constant\n         */\n        get: function () {\n            return defaultVertex$2;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BatchPluginFactory, \"defaultFragmentTemplate\", {\n        /**\n         * The default fragment shader source\n         *\n         * @static\n         * @type {string}\n         * @constant\n         */\n        get: function () {\n            return defaultFragment$2;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return BatchPluginFactory;\n}());\n// Setup the default BatchRenderer plugin, this is what\n// we'll actually export at the root level\nvar BatchRenderer = BatchPluginFactory.create();\n\n\n//# sourceMappingURL=core.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/core/lib/core.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/display/lib/display.es.js":
/*!******************************************************!*\
  !*** ./node_modules/@pixi/display/lib/display.es.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Bounds\": () => (/* binding */ Bounds),\n/* harmony export */   \"Container\": () => (/* binding */ Container),\n/* harmony export */   \"DisplayObject\": () => (/* binding */ DisplayObject),\n/* harmony export */   \"TemporaryDisplayObject\": () => (/* binding */ TemporaryDisplayObject)\n/* harmony export */ });\n/* harmony import */ var _pixi_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/settings */ \"./node_modules/@pixi/settings/lib/settings.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/*!\n * @pixi/display - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/display is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n/**\n * Sets the default value for the container property 'sortableChildren'.\n * If set to true, the container will sort its children by zIndex value\n * when updateTransform() is called, or manually if sortChildren() is called.\n *\n * This actually changes the order of elements in the array, so should be treated\n * as a basic solution that is not performant compared to other solutions,\n * such as @link https://github.com/pixijs/pixi-display\n *\n * Also be aware of that this may not work nicely with the addChildAt() function,\n * as the zIndex sorting may cause the child to automatically sorted to another position.\n *\n * @static\n * @constant\n * @name SORTABLE_CHILDREN\n * @memberof PIXI.settings\n * @type {boolean}\n * @default false\n */\n_pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SORTABLE_CHILDREN = false;\n\n/**\n * 'Builder' pattern for bounds rectangles.\n *\n * This could be called an Axis-Aligned Bounding Box.\n * It is not an actual shape. It is a mutable thing; no 'EMPTY' or those kind of problems.\n *\n * @class\n * @memberof PIXI\n */\nvar Bounds = /** @class */ (function () {\n    function Bounds() {\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.minX = Infinity;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.minY = Infinity;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.maxX = -Infinity;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.maxY = -Infinity;\n        this.rect = null;\n        /**\n         * It is updated to _boundsID of corresponding object to keep bounds in sync with content.\n         * Updated from outside, thus public modifier.\n         *\n         * @member {number}\n         * @public\n         */\n        this.updateID = -1;\n    }\n    /**\n     * Checks if bounds are empty.\n     *\n     * @return {boolean} True if empty.\n     */\n    Bounds.prototype.isEmpty = function () {\n        return this.minX > this.maxX || this.minY > this.maxY;\n    };\n    /**\n     * Clears the bounds and resets.\n     *\n     */\n    Bounds.prototype.clear = function () {\n        this.minX = Infinity;\n        this.minY = Infinity;\n        this.maxX = -Infinity;\n        this.maxY = -Infinity;\n    };\n    /**\n     * Can return Rectangle.EMPTY constant, either construct new rectangle, either use your rectangle\n     * It is not guaranteed that it will return tempRect\n     *\n     * @param {PIXI.Rectangle} rect - temporary object will be used if AABB is not empty\n     * @returns {PIXI.Rectangle} A rectangle of the bounds\n     */\n    Bounds.prototype.getRectangle = function (rect) {\n        if (this.minX > this.maxX || this.minY > this.maxY) {\n            return _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle.EMPTY;\n        }\n        rect = rect || new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle(0, 0, 1, 1);\n        rect.x = this.minX;\n        rect.y = this.minY;\n        rect.width = this.maxX - this.minX;\n        rect.height = this.maxY - this.minY;\n        return rect;\n    };\n    /**\n     * This function should be inlined when its possible.\n     *\n     * @param {PIXI.IPointData} point - The point to add.\n     */\n    Bounds.prototype.addPoint = function (point) {\n        this.minX = Math.min(this.minX, point.x);\n        this.maxX = Math.max(this.maxX, point.x);\n        this.minY = Math.min(this.minY, point.y);\n        this.maxY = Math.max(this.maxY, point.y);\n    };\n    /**\n     * Adds a quad, not transformed\n     *\n     * @param {Float32Array} vertices - The verts to add.\n     */\n    Bounds.prototype.addQuad = function (vertices) {\n        var minX = this.minX;\n        var minY = this.minY;\n        var maxX = this.maxX;\n        var maxY = this.maxY;\n        var x = vertices[0];\n        var y = vertices[1];\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = vertices[2];\n        y = vertices[3];\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = vertices[4];\n        y = vertices[5];\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = vertices[6];\n        y = vertices[7];\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        this.minX = minX;\n        this.minY = minY;\n        this.maxX = maxX;\n        this.maxY = maxY;\n    };\n    /**\n     * Adds sprite frame, transformed.\n     *\n     * @param {PIXI.Transform} transform - transform to apply\n     * @param {number} x0 - left X of frame\n     * @param {number} y0 - top Y of frame\n     * @param {number} x1 - right X of frame\n     * @param {number} y1 - bottom Y of frame\n     */\n    Bounds.prototype.addFrame = function (transform, x0, y0, x1, y1) {\n        this.addFrameMatrix(transform.worldTransform, x0, y0, x1, y1);\n    };\n    /**\n     * Adds sprite frame, multiplied by matrix\n     *\n     * @param {PIXI.Matrix} matrix - matrix to apply\n     * @param {number} x0 - left X of frame\n     * @param {number} y0 - top Y of frame\n     * @param {number} x1 - right X of frame\n     * @param {number} y1 - bottom Y of frame\n     */\n    Bounds.prototype.addFrameMatrix = function (matrix, x0, y0, x1, y1) {\n        var a = matrix.a;\n        var b = matrix.b;\n        var c = matrix.c;\n        var d = matrix.d;\n        var tx = matrix.tx;\n        var ty = matrix.ty;\n        var minX = this.minX;\n        var minY = this.minY;\n        var maxX = this.maxX;\n        var maxY = this.maxY;\n        var x = (a * x0) + (c * y0) + tx;\n        var y = (b * x0) + (d * y0) + ty;\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = (a * x1) + (c * y0) + tx;\n        y = (b * x1) + (d * y0) + ty;\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = (a * x0) + (c * y1) + tx;\n        y = (b * x0) + (d * y1) + ty;\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        x = (a * x1) + (c * y1) + tx;\n        y = (b * x1) + (d * y1) + ty;\n        minX = x < minX ? x : minX;\n        minY = y < minY ? y : minY;\n        maxX = x > maxX ? x : maxX;\n        maxY = y > maxY ? y : maxY;\n        this.minX = minX;\n        this.minY = minY;\n        this.maxX = maxX;\n        this.maxY = maxY;\n    };\n    /**\n     * Adds screen vertices from array\n     *\n     * @param {Float32Array} vertexData - calculated vertices\n     * @param {number} beginOffset - begin offset\n     * @param {number} endOffset - end offset, excluded\n     */\n    Bounds.prototype.addVertexData = function (vertexData, beginOffset, endOffset) {\n        var minX = this.minX;\n        var minY = this.minY;\n        var maxX = this.maxX;\n        var maxY = this.maxY;\n        for (var i = beginOffset; i < endOffset; i += 2) {\n            var x = vertexData[i];\n            var y = vertexData[i + 1];\n            minX = x < minX ? x : minX;\n            minY = y < minY ? y : minY;\n            maxX = x > maxX ? x : maxX;\n            maxY = y > maxY ? y : maxY;\n        }\n        this.minX = minX;\n        this.minY = minY;\n        this.maxX = maxX;\n        this.maxY = maxY;\n    };\n    /**\n     * Add an array of mesh vertices\n     *\n     * @param {PIXI.Transform} transform - mesh transform\n     * @param {Float32Array} vertices - mesh coordinates in array\n     * @param {number} beginOffset - begin offset\n     * @param {number} endOffset - end offset, excluded\n     */\n    Bounds.prototype.addVertices = function (transform, vertices, beginOffset, endOffset) {\n        this.addVerticesMatrix(transform.worldTransform, vertices, beginOffset, endOffset);\n    };\n    /**\n     * Add an array of mesh vertices.\n     *\n     * @param {PIXI.Matrix} matrix - mesh matrix\n     * @param {Float32Array} vertices - mesh coordinates in array\n     * @param {number} beginOffset - begin offset\n     * @param {number} endOffset - end offset, excluded\n     * @param {number} [padX=0] - x padding\n     * @param {number} [padY=0] - y padding\n     */\n    Bounds.prototype.addVerticesMatrix = function (matrix, vertices, beginOffset, endOffset, padX, padY) {\n        if (padX === void 0) { padX = 0; }\n        if (padY === void 0) { padY = padX; }\n        var a = matrix.a;\n        var b = matrix.b;\n        var c = matrix.c;\n        var d = matrix.d;\n        var tx = matrix.tx;\n        var ty = matrix.ty;\n        var minX = this.minX;\n        var minY = this.minY;\n        var maxX = this.maxX;\n        var maxY = this.maxY;\n        for (var i = beginOffset; i < endOffset; i += 2) {\n            var rawX = vertices[i];\n            var rawY = vertices[i + 1];\n            var x = (a * rawX) + (c * rawY) + tx;\n            var y = (d * rawY) + (b * rawX) + ty;\n            minX = Math.min(minX, x - padX);\n            maxX = Math.max(maxX, x + padX);\n            minY = Math.min(minY, y - padY);\n            maxY = Math.max(maxY, y + padY);\n        }\n        this.minX = minX;\n        this.minY = minY;\n        this.maxX = maxX;\n        this.maxY = maxY;\n    };\n    /**\n     * Adds other Bounds.\n     *\n     * @param {PIXI.Bounds} bounds - The Bounds to be added\n     */\n    Bounds.prototype.addBounds = function (bounds) {\n        var minX = this.minX;\n        var minY = this.minY;\n        var maxX = this.maxX;\n        var maxY = this.maxY;\n        this.minX = bounds.minX < minX ? bounds.minX : minX;\n        this.minY = bounds.minY < minY ? bounds.minY : minY;\n        this.maxX = bounds.maxX > maxX ? bounds.maxX : maxX;\n        this.maxY = bounds.maxY > maxY ? bounds.maxY : maxY;\n    };\n    /**\n     * Adds other Bounds, masked with Bounds.\n     *\n     * @param {PIXI.Bounds} bounds - The Bounds to be added.\n     * @param {PIXI.Bounds} mask - TODO\n     */\n    Bounds.prototype.addBoundsMask = function (bounds, mask) {\n        var _minX = bounds.minX > mask.minX ? bounds.minX : mask.minX;\n        var _minY = bounds.minY > mask.minY ? bounds.minY : mask.minY;\n        var _maxX = bounds.maxX < mask.maxX ? bounds.maxX : mask.maxX;\n        var _maxY = bounds.maxY < mask.maxY ? bounds.maxY : mask.maxY;\n        if (_minX <= _maxX && _minY <= _maxY) {\n            var minX = this.minX;\n            var minY = this.minY;\n            var maxX = this.maxX;\n            var maxY = this.maxY;\n            this.minX = _minX < minX ? _minX : minX;\n            this.minY = _minY < minY ? _minY : minY;\n            this.maxX = _maxX > maxX ? _maxX : maxX;\n            this.maxY = _maxY > maxY ? _maxY : maxY;\n        }\n    };\n    /**\n     * Adds other Bounds, multiplied by matrix. Bounds shouldn't be empty.\n     *\n     * @param {PIXI.Bounds} bounds - other bounds\n     * @param {PIXI.Matrix} matrix - multiplicator\n     */\n    Bounds.prototype.addBoundsMatrix = function (bounds, matrix) {\n        this.addFrameMatrix(matrix, bounds.minX, bounds.minY, bounds.maxX, bounds.maxY);\n    };\n    /**\n     * Adds other Bounds, masked with Rectangle.\n     *\n     * @param {PIXI.Bounds} bounds - TODO\n     * @param {PIXI.Rectangle} area - TODO\n     */\n    Bounds.prototype.addBoundsArea = function (bounds, area) {\n        var _minX = bounds.minX > area.x ? bounds.minX : area.x;\n        var _minY = bounds.minY > area.y ? bounds.minY : area.y;\n        var _maxX = bounds.maxX < area.x + area.width ? bounds.maxX : (area.x + area.width);\n        var _maxY = bounds.maxY < area.y + area.height ? bounds.maxY : (area.y + area.height);\n        if (_minX <= _maxX && _minY <= _maxY) {\n            var minX = this.minX;\n            var minY = this.minY;\n            var maxX = this.maxX;\n            var maxY = this.maxY;\n            this.minX = _minX < minX ? _minX : minX;\n            this.minY = _minY < minY ? _minY : minY;\n            this.maxX = _maxX > maxX ? _maxX : maxX;\n            this.maxY = _maxY > maxY ? _maxY : maxY;\n        }\n    };\n    /**\n     * Pads bounds object, making it grow in all directions.\n     * If paddingY is omitted, both paddingX and paddingY will be set to paddingX.\n     *\n     * @param {number} [paddingX=0] - The horizontal padding amount.\n     * @param {number} [paddingY=0] - The vertical padding amount.\n     */\n    Bounds.prototype.pad = function (paddingX, paddingY) {\n        if (paddingX === void 0) { paddingX = 0; }\n        if (paddingY === void 0) { paddingY = paddingX; }\n        if (!this.isEmpty()) {\n            this.minX -= paddingX;\n            this.maxX += paddingX;\n            this.minY -= paddingY;\n            this.maxY += paddingY;\n        }\n    };\n    /**\n     * Adds padded frame. (x0, y0) should be strictly less than (x1, y1)\n     *\n     * @param {number} x0 - left X of frame\n     * @param {number} y0 - top Y of frame\n     * @param {number} x1 - right X of frame\n     * @param {number} y1 - bottom Y of frame\n     * @param {number} padX - padding X\n     * @param {number} padY - padding Y\n     */\n    Bounds.prototype.addFramePad = function (x0, y0, x1, y1, padX, padY) {\n        x0 -= padX;\n        y0 -= padY;\n        x1 += padX;\n        y1 += padY;\n        this.minX = this.minX < x0 ? this.minX : x0;\n        this.maxX = this.maxX > x1 ? this.maxX : x1;\n        this.minY = this.minY < y0 ? this.minY : y0;\n        this.maxY = this.maxY > y1 ? this.maxY : y1;\n    };\n    return Bounds;\n}());\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * The base class for all objects that are rendered on the screen.\n *\n * This is an abstract class and should not be used on its own; rather it should b e extended.\n *\n * @class\n * @extends PIXI.utils.EventEmitter\n * @memberof PIXI\n */\nvar DisplayObject = /** @class */ (function (_super) {\n    __extends(DisplayObject, _super);\n    function DisplayObject() {\n        var _this = _super.call(this) || this;\n        _this.tempDisplayObjectParent = null;\n        // TODO: need to create Transform from factory\n        /**\n         * World transform and local transform of this object.\n         * This will become read-only later, please do not assign anything there unless you know what are you doing.\n         *\n         * @member {PIXI.Transform}\n         */\n        _this.transform = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Transform();\n        /**\n         * The opacity of the object.\n         *\n         * @member {number}\n         */\n        _this.alpha = 1;\n        /**\n         * The visibility of the object. If false the object will not be drawn, and\n         * the updateTransform function will not be called.\n         *\n         * Only affects recursive calls from parent. You can ask for bounds or call updateTransform manually.\n         *\n         * @member {boolean}\n         */\n        _this.visible = true;\n        /**\n         * Can this object be rendered, if false the object will not be drawn but the updateTransform\n         * methods will still be called.\n         *\n         * Only affects recursive calls from parent. You can ask for bounds manually.\n         *\n         * @member {boolean}\n         */\n        _this.renderable = true;\n        /**\n         * The display object container that contains this display object.\n         *\n         * @member {PIXI.Container}\n         */\n        _this.parent = null;\n        /**\n         * The multiplied alpha of the displayObject.\n         *\n         * @member {number}\n         * @readonly\n         */\n        _this.worldAlpha = 1;\n        /**\n         * Which index in the children array the display component was before the previous zIndex sort.\n         * Used by containers to help sort objects with the same zIndex, by using previous array index as the decider.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this._lastSortedIndex = 0;\n        /**\n         * The zIndex of the displayObject.\n         * A higher value will mean it will be rendered on top of other displayObjects within the same container.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this._zIndex = 0;\n        /**\n         * The area the filter is applied to. This is used as more of an optimization\n         * rather than figuring out the dimensions of the displayObject each frame you can set this rectangle.\n         *\n         * Also works as an interaction mask.\n         *\n         * @member {?PIXI.Rectangle}\n         */\n        _this.filterArea = null;\n        /**\n         * Sets the filters for the displayObject.\n         * * IMPORTANT: This is a WebGL only feature and will be ignored by the canvas renderer.\n         * To remove filters simply set this property to `'null'`.\n         *\n         * @member {?PIXI.Filter[]}\n         */\n        _this.filters = null;\n        /**\n         * Currently enabled filters\n         * @member {PIXI.Filter[]}\n         * @protected\n         */\n        _this._enabledFilters = null;\n        /**\n         * The bounds object, this is used to calculate and store the bounds of the displayObject.\n         *\n         * @member {PIXI.Bounds}\n         */\n        _this._bounds = new Bounds();\n        /**\n         * Local bounds object, swapped with `_bounds` when using `getLocalBounds()`.\n         *\n         * @member {PIXI.Bounds}\n         */\n        _this._localBounds = null;\n        /**\n         * Flags the cached bounds as dirty.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this._boundsID = 0;\n        /**\n         * Cache of this display-object's bounds-rectangle.\n         *\n         * @member {PIXI.Bounds}\n         * @protected\n         */\n        _this._boundsRect = null;\n        /**\n         * Cache of this display-object's local-bounds rectangle.\n         *\n         * @member {PIXI.Bounds}\n         * @protected\n         */\n        _this._localBoundsRect = null;\n        /**\n         * The original, cached mask of the object.\n         *\n         * @member {PIXI.Container|PIXI.MaskData|null}\n         * @protected\n         */\n        _this._mask = null;\n        /**\n         * Fired when this DisplayObject is added to a Container.\n         *\n         * @event PIXI.DisplayObject#added\n         * @param {PIXI.Container} container - The container added to.\n         */\n        /**\n         * Fired when this DisplayObject is removed from a Container.\n         *\n         * @event PIXI.DisplayObject#removed\n         * @param {PIXI.Container} container - The container removed from.\n         */\n        /**\n         * If the object has been destroyed via destroy(). If true, it should not be used.\n         *\n         * @member {boolean}\n         * @protected\n         */\n        _this._destroyed = false;\n        /**\n         * used to fast check if a sprite is.. a sprite!\n         * @member {boolean}\n         */\n        _this.isSprite = false;\n        /**\n         * Does any other displayObject use this object as a mask?\n         * @member {boolean}\n         */\n        _this.isMask = false;\n        return _this;\n    }\n    /**\n     * Mixes all enumerable properties and methods from a source object to DisplayObject.\n     *\n     * @param {object} source - The source of properties and methods to mix in.\n     */\n    DisplayObject.mixin = function (source) {\n        // in ES8/ES2017, this would be really easy:\n        // Object.defineProperties(DisplayObject.prototype, Object.getOwnPropertyDescriptors(source));\n        // get all the enumerable property keys\n        var keys = Object.keys(source);\n        // loop through properties\n        for (var i = 0; i < keys.length; ++i) {\n            var propertyName = keys[i];\n            // Set the property using the property descriptor - this works for accessors and normal value properties\n            Object.defineProperty(DisplayObject.prototype, propertyName, Object.getOwnPropertyDescriptor(source, propertyName));\n        }\n    };\n    /**\n     * Recursively updates transform of all objects from the root to this one\n     * internal function for toLocal()\n     */\n    DisplayObject.prototype._recursivePostUpdateTransform = function () {\n        if (this.parent) {\n            this.parent._recursivePostUpdateTransform();\n            this.transform.updateTransform(this.parent.transform);\n        }\n        else {\n            this.transform.updateTransform(this._tempDisplayObjectParent.transform);\n        }\n    };\n    /**\n     * Updates the object transform for rendering.\n     *\n     * TODO - Optimization pass!\n     */\n    DisplayObject.prototype.updateTransform = function () {\n        this._boundsID++;\n        this.transform.updateTransform(this.parent.transform);\n        // multiply the alphas..\n        this.worldAlpha = this.alpha * this.parent.worldAlpha;\n    };\n    /**\n     * Retrieves the bounds of the displayObject as a rectangle object.\n     *\n     * @param {boolean} [skipUpdate] - Setting to `true` will stop the transforms of the scene graph from\n     *  being updated. This means the calculation returned MAY be out of date BUT will give you a\n     *  nice performance boost.\n     * @param {PIXI.Rectangle} [rect] - Optional rectangle to store the result of the bounds calculation.\n     * @return {PIXI.Rectangle} The rectangular bounding area.\n     */\n    DisplayObject.prototype.getBounds = function (skipUpdate, rect) {\n        if (!skipUpdate) {\n            if (!this.parent) {\n                this.parent = this._tempDisplayObjectParent;\n                this.updateTransform();\n                this.parent = null;\n            }\n            else {\n                this._recursivePostUpdateTransform();\n                this.updateTransform();\n            }\n        }\n        if (this._bounds.updateID !== this._boundsID) {\n            this.calculateBounds();\n            this._bounds.updateID = this._boundsID;\n        }\n        if (!rect) {\n            if (!this._boundsRect) {\n                this._boundsRect = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle();\n            }\n            rect = this._boundsRect;\n        }\n        return this._bounds.getRectangle(rect);\n    };\n    /**\n     * Retrieves the local bounds of the displayObject as a rectangle object.\n     *\n     * @param {PIXI.Rectangle} [rect] - Optional rectangle to store the result of the bounds calculation.\n     * @return {PIXI.Rectangle} The rectangular bounding area.\n     */\n    DisplayObject.prototype.getLocalBounds = function (rect) {\n        if (!rect) {\n            if (!this._localBoundsRect) {\n                this._localBoundsRect = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle();\n            }\n            rect = this._localBoundsRect;\n        }\n        if (!this._localBounds) {\n            this._localBounds = new Bounds();\n        }\n        var transformRef = this.transform;\n        var parentRef = this.parent;\n        this.parent = null;\n        this.transform = this._tempDisplayObjectParent.transform;\n        var worldBounds = this._bounds;\n        var worldBoundsID = this._boundsID;\n        this._bounds = this._localBounds;\n        var bounds = this.getBounds(false, rect);\n        this.parent = parentRef;\n        this.transform = transformRef;\n        this._bounds = worldBounds;\n        this._bounds.updateID += this._boundsID - worldBoundsID; // reflect side-effects\n        return bounds;\n    };\n    /**\n     * Calculates the global position of the display object.\n     *\n     * @param {PIXI.IPointData} position - The world origin to calculate from.\n     * @param {PIXI.Point} [point] - A Point object in which to store the value, optional\n     *  (otherwise will create a new Point).\n     * @param {boolean} [skipUpdate=false] - Should we skip the update transform.\n     * @return {PIXI.Point} A point object representing the position of this object.\n     */\n    DisplayObject.prototype.toGlobal = function (position, point, skipUpdate) {\n        if (skipUpdate === void 0) { skipUpdate = false; }\n        if (!skipUpdate) {\n            this._recursivePostUpdateTransform();\n            // this parent check is for just in case the item is a root object.\n            // If it is we need to give it a temporary parent so that displayObjectUpdateTransform works correctly\n            // this is mainly to avoid a parent check in the main loop. Every little helps for performance :)\n            if (!this.parent) {\n                this.parent = this._tempDisplayObjectParent;\n                this.displayObjectUpdateTransform();\n                this.parent = null;\n            }\n            else {\n                this.displayObjectUpdateTransform();\n            }\n        }\n        // don't need to update the lot\n        return this.worldTransform.apply(position, point);\n    };\n    /**\n     * Calculates the local position of the display object relative to another point.\n     *\n     * @param {PIXI.IPointData} position - The world origin to calculate from.\n     * @param {PIXI.DisplayObject} [from] - The DisplayObject to calculate the global position from.\n     * @param {PIXI.Point} [point] - A Point object in which to store the value, optional\n     *  (otherwise will create a new Point).\n     * @param {boolean} [skipUpdate=false] - Should we skip the update transform\n     * @return {PIXI.Point} A point object representing the position of this object\n     */\n    DisplayObject.prototype.toLocal = function (position, from, point, skipUpdate) {\n        if (from) {\n            position = from.toGlobal(position, point, skipUpdate);\n        }\n        if (!skipUpdate) {\n            this._recursivePostUpdateTransform();\n            // this parent check is for just in case the item is a root object.\n            // If it is we need to give it a temporary parent so that displayObjectUpdateTransform works correctly\n            // this is mainly to avoid a parent check in the main loop. Every little helps for performance :)\n            if (!this.parent) {\n                this.parent = this._tempDisplayObjectParent;\n                this.displayObjectUpdateTransform();\n                this.parent = null;\n            }\n            else {\n                this.displayObjectUpdateTransform();\n            }\n        }\n        // simply apply the matrix..\n        return this.worldTransform.applyInverse(position, point);\n    };\n    /**\n     * Set the parent Container of this DisplayObject.\n     *\n     * @param {PIXI.Container} container - The Container to add this DisplayObject to.\n     * @return {PIXI.Container} The Container that this DisplayObject was added to.\n     */\n    DisplayObject.prototype.setParent = function (container) {\n        if (!container || !container.addChild) {\n            throw new Error('setParent: Argument must be a Container');\n        }\n        container.addChild(this);\n        return container;\n    };\n    /**\n     * Convenience function to set the position, scale, skew and pivot at once.\n     *\n     * @param {number} [x=0] - The X position\n     * @param {number} [y=0] - The Y position\n     * @param {number} [scaleX=1] - The X scale value\n     * @param {number} [scaleY=1] - The Y scale value\n     * @param {number} [rotation=0] - The rotation\n     * @param {number} [skewX=0] - The X skew value\n     * @param {number} [skewY=0] - The Y skew value\n     * @param {number} [pivotX=0] - The X pivot value\n     * @param {number} [pivotY=0] - The Y pivot value\n     * @return {PIXI.DisplayObject} The DisplayObject instance\n     */\n    DisplayObject.prototype.setTransform = function (x, y, scaleX, scaleY, rotation, skewX, skewY, pivotX, pivotY) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (scaleX === void 0) { scaleX = 1; }\n        if (scaleY === void 0) { scaleY = 1; }\n        if (rotation === void 0) { rotation = 0; }\n        if (skewX === void 0) { skewX = 0; }\n        if (skewY === void 0) { skewY = 0; }\n        if (pivotX === void 0) { pivotX = 0; }\n        if (pivotY === void 0) { pivotY = 0; }\n        this.position.x = x;\n        this.position.y = y;\n        this.scale.x = !scaleX ? 1 : scaleX;\n        this.scale.y = !scaleY ? 1 : scaleY;\n        this.rotation = rotation;\n        this.skew.x = skewX;\n        this.skew.y = skewY;\n        this.pivot.x = pivotX;\n        this.pivot.y = pivotY;\n        return this;\n    };\n    /**\n     * Base destroy method for generic display objects. This will automatically\n     * remove the display object from its parent Container as well as remove\n     * all current event listeners and internal references. Do not use a DisplayObject\n     * after calling `destroy()`.\n     *\n     */\n    DisplayObject.prototype.destroy = function (_options) {\n        if (this.parent) {\n            this.parent.removeChild(this);\n        }\n        this.removeAllListeners();\n        this.transform = null;\n        this.parent = null;\n        this._bounds = null;\n        this._mask = null;\n        this.filters = null;\n        this.filterArea = null;\n        this.hitArea = null;\n        this.interactive = false;\n        this.interactiveChildren = false;\n        this._destroyed = true;\n    };\n    Object.defineProperty(DisplayObject.prototype, \"_tempDisplayObjectParent\", {\n        /**\n         * @protected\n         * @member {PIXI.Container}\n         */\n        get: function () {\n            if (this.tempDisplayObjectParent === null) {\n                // eslint-disable-next-line no-use-before-define\n                this.tempDisplayObjectParent = new TemporaryDisplayObject();\n            }\n            return this.tempDisplayObjectParent;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Used in Renderer, cacheAsBitmap and other places where you call an `updateTransform` on root\n     *\n     * ```\n     * const cacheParent = elem.enableTempParent();\n     * elem.updateTransform();\n     * elem.disableTempParent(cacheParent);\n     * ```\n     *\n     * @returns {PIXI.DisplayObject} current parent\n     */\n    DisplayObject.prototype.enableTempParent = function () {\n        var myParent = this.parent;\n        this.parent = this._tempDisplayObjectParent;\n        return myParent;\n    };\n    /**\n     * Pair method for `enableTempParent`\n     * @param {PIXI.DisplayObject} cacheParent actual parent of element\n     */\n    DisplayObject.prototype.disableTempParent = function (cacheParent) {\n        this.parent = cacheParent;\n    };\n    Object.defineProperty(DisplayObject.prototype, \"x\", {\n        /**\n         * The position of the displayObject on the x axis relative to the local coordinates of the parent.\n         * An alias to position.x\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.position.x;\n        },\n        set: function (value) {\n            this.transform.position.x = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"y\", {\n        /**\n         * The position of the displayObject on the y axis relative to the local coordinates of the parent.\n         * An alias to position.y\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.position.y;\n        },\n        set: function (value) {\n            this.transform.position.y = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"worldTransform\", {\n        /**\n         * Current transform of the object based on world (parent) factors.\n         *\n         * @member {PIXI.Matrix}\n         * @readonly\n         */\n        get: function () {\n            return this.transform.worldTransform;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"localTransform\", {\n        /**\n         * Current transform of the object based on local factors: position, scale, other stuff.\n         *\n         * @member {PIXI.Matrix}\n         * @readonly\n         */\n        get: function () {\n            return this.transform.localTransform;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"position\", {\n        /**\n         * The coordinate of the object relative to the local coordinates of the parent.\n         * Assignment by value since pixi-v4.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        get: function () {\n            return this.transform.position;\n        },\n        set: function (value) {\n            this.transform.position.copyFrom(value);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"scale\", {\n        /**\n         * The scale factor of the object.\n         * Assignment by value since pixi-v4.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        get: function () {\n            return this.transform.scale;\n        },\n        set: function (value) {\n            this.transform.scale.copyFrom(value);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"pivot\", {\n        /**\n         * The pivot point of the displayObject that it rotates around.\n         * Assignment by value since pixi-v4.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        get: function () {\n            return this.transform.pivot;\n        },\n        set: function (value) {\n            this.transform.pivot.copyFrom(value);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"skew\", {\n        /**\n         * The skew factor for the object in radians.\n         * Assignment by value since pixi-v4.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        get: function () {\n            return this.transform.skew;\n        },\n        set: function (value) {\n            this.transform.skew.copyFrom(value);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"rotation\", {\n        /**\n         * The rotation of the object in radians.\n         * 'rotation' and 'angle' have the same effect on a display object; rotation is in radians, angle is in degrees.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.transform.rotation;\n        },\n        set: function (value) {\n            this.transform.rotation = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"angle\", {\n        /**\n         * The angle of the object in degrees.\n         * 'rotation' and 'angle' have the same effect on a display object; rotation is in radians, angle is in degrees.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.transform.rotation * _pixi_math__WEBPACK_IMPORTED_MODULE_1__.RAD_TO_DEG;\n        },\n        set: function (value) {\n            this.transform.rotation = value * _pixi_math__WEBPACK_IMPORTED_MODULE_1__.DEG_TO_RAD;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"zIndex\", {\n        /**\n         * The zIndex of the displayObject.\n         * If a container has the sortableChildren property set to true, children will be automatically\n         * sorted by zIndex value; a higher value will mean it will be moved towards the end of the array,\n         * and thus rendered on top of other displayObjects within the same container.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._zIndex;\n        },\n        set: function (value) {\n            this._zIndex = value;\n            if (this.parent) {\n                this.parent.sortDirty = true;\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"worldVisible\", {\n        /**\n         * Indicates if the object is globally visible.\n         *\n         * @member {boolean}\n         * @readonly\n         */\n        get: function () {\n            var item = this;\n            do {\n                if (!item.visible) {\n                    return false;\n                }\n                item = item.parent;\n            } while (item);\n            return true;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(DisplayObject.prototype, \"mask\", {\n        /**\n         * Sets a mask for the displayObject. A mask is an object that limits the visibility of an\n         * object to the shape of the mask applied to it. In PixiJS a regular mask must be a\n         * {@link PIXI.Graphics} or a {@link PIXI.Sprite} object. This allows for much faster masking in canvas as it\n         * utilities shape clipping. To remove a mask, set this property to `null`.\n         *\n         * For sprite mask both alpha and red channel are used. Black mask is the same as transparent mask.\n         * @example\n         * const graphics = new PIXI.Graphics();\n         * graphics.beginFill(0xFF3300);\n         * graphics.drawRect(50, 250, 100, 100);\n         * graphics.endFill();\n         *\n         * const sprite = new PIXI.Sprite(texture);\n         * sprite.mask = graphics;\n         * @todo At the moment, PIXI.CanvasRenderer doesn't support PIXI.Sprite as mask.\n         *\n         * @member {PIXI.Container|PIXI.MaskData|null}\n         */\n        get: function () {\n            return this._mask;\n        },\n        set: function (value) {\n            if (this._mask) {\n                var maskObject = (this._mask.maskObject || this._mask);\n                maskObject.renderable = true;\n                maskObject.isMask = false;\n            }\n            this._mask = value;\n            if (this._mask) {\n                var maskObject = (this._mask.maskObject || this._mask);\n                maskObject.renderable = false;\n                maskObject.isMask = true;\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return DisplayObject;\n}(_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.EventEmitter));\nvar TemporaryDisplayObject = /** @class */ (function (_super) {\n    __extends(TemporaryDisplayObject, _super);\n    function TemporaryDisplayObject() {\n        var _this = _super !== null && _super.apply(this, arguments) || this;\n        _this.sortDirty = null;\n        return _this;\n    }\n    return TemporaryDisplayObject;\n}(DisplayObject));\n/**\n * DisplayObject default updateTransform, does not update children of container.\n * Will crash if there's no parent element.\n *\n * @memberof PIXI.DisplayObject#\n * @function displayObjectUpdateTransform\n */\nDisplayObject.prototype.displayObjectUpdateTransform = DisplayObject.prototype.updateTransform;\n\nfunction sortChildren(a, b) {\n    if (a.zIndex === b.zIndex) {\n        return a._lastSortedIndex - b._lastSortedIndex;\n    }\n    return a.zIndex - b.zIndex;\n}\n/**\n * A Container represents a collection of display objects.\n *\n * It is the base class of all display objects that act as a container for other objects (like Sprites).\n *\n *```js\n * let container = new PIXI.Container();\n * container.addChild(sprite);\n * ```\n *\n * @class\n * @extends PIXI.DisplayObject\n * @memberof PIXI\n */\nvar Container = /** @class */ (function (_super) {\n    __extends(Container, _super);\n    function Container() {\n        var _this = _super.call(this) || this;\n        /**\n         * The array of children of this container.\n         *\n         * @member {PIXI.DisplayObject[]}\n         * @readonly\n         */\n        _this.children = [];\n        /**\n         * If set to true, the container will sort its children by zIndex value\n         * when updateTransform() is called, or manually if sortChildren() is called.\n         *\n         * This actually changes the order of elements in the array, so should be treated\n         * as a basic solution that is not performant compared to other solutions,\n         * such as @link https://github.com/pixijs/pixi-display\n         *\n         * Also be aware of that this may not work nicely with the addChildAt() function,\n         * as the zIndex sorting may cause the child to automatically sorted to another position.\n         *\n         * @see PIXI.settings.SORTABLE_CHILDREN\n         *\n         * @member {boolean}\n         */\n        _this.sortableChildren = _pixi_settings__WEBPACK_IMPORTED_MODULE_0__.settings.SORTABLE_CHILDREN;\n        /**\n         * Should children be sorted by zIndex at the next updateTransform call.\n         * Will get automatically set to true if a new child is added, or if a child's zIndex changes.\n         *\n         * @member {boolean}\n         */\n        _this.sortDirty = false;\n        return _this;\n        /**\n         * Fired when a DisplayObject is added to this Container.\n         *\n         * @event PIXI.Container#childAdded\n         * @param {PIXI.DisplayObject} child - The child added to the Container.\n         * @param {PIXI.Container} container - The container that added the child.\n         * @param {number} index - The children's index of the added child.\n         */\n        /**\n         * Fired when a DisplayObject is removed from this Container.\n         *\n         * @event PIXI.DisplayObject#removedFrom\n         * @param {PIXI.DisplayObject} child - The child removed from the Container.\n         * @param {PIXI.Container} container - The container that removed removed the child.\n         * @param {number} index - The former children's index of the removed child\n         */\n    }\n    /**\n     * Overridable method that can be used by Container subclasses whenever the children array is modified\n     *\n     * @protected\n     */\n    Container.prototype.onChildrenChange = function (_length) {\n        /* empty */\n    };\n    /**\n     * Adds one or more children to the container.\n     *\n     * Multiple items can be added like so: `myContainer.addChild(thingOne, thingTwo, thingThree)`\n     *\n     * @param {...PIXI.DisplayObject} children - The DisplayObject(s) to add to the container\n     * @return {PIXI.DisplayObject} The first child that was added.\n     */\n    Container.prototype.addChild = function () {\n        var arguments$1 = arguments;\n\n        var children = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            children[_i] = arguments$1[_i];\n        }\n        // if there is only one argument we can bypass looping through the them\n        if (children.length > 1) {\n            // loop through the array and add all children\n            for (var i = 0; i < children.length; i++) {\n                // eslint-disable-next-line prefer-rest-params\n                this.addChild(children[i]);\n            }\n        }\n        else {\n            var child = children[0];\n            // if the child has a parent then lets remove it as PixiJS objects can only exist in one place\n            if (child.parent) {\n                child.parent.removeChild(child);\n            }\n            child.parent = this;\n            this.sortDirty = true;\n            // ensure child transform will be recalculated\n            child.transform._parentID = -1;\n            this.children.push(child);\n            // ensure bounds will be recalculated\n            this._boundsID++;\n            // TODO - lets either do all callbacks or all events.. not both!\n            this.onChildrenChange(this.children.length - 1);\n            this.emit('childAdded', child, this, this.children.length - 1);\n            child.emit('added', this);\n        }\n        return children[0];\n    };\n    /**\n     * Adds a child to the container at a specified index. If the index is out of bounds an error will be thrown\n     *\n     * @param {PIXI.DisplayObject} child - The child to add\n     * @param {number} index - The index to place the child in\n     * @return {PIXI.DisplayObject} The child that was added.\n     */\n    Container.prototype.addChildAt = function (child, index) {\n        if (index < 0 || index > this.children.length) {\n            throw new Error(child + \"addChildAt: The index \" + index + \" supplied is out of bounds \" + this.children.length);\n        }\n        if (child.parent) {\n            child.parent.removeChild(child);\n        }\n        child.parent = this;\n        this.sortDirty = true;\n        // ensure child transform will be recalculated\n        child.transform._parentID = -1;\n        this.children.splice(index, 0, child);\n        // ensure bounds will be recalculated\n        this._boundsID++;\n        // TODO - lets either do all callbacks or all events.. not both!\n        this.onChildrenChange(index);\n        child.emit('added', this);\n        this.emit('childAdded', child, this, index);\n        return child;\n    };\n    /**\n     * Swaps the position of 2 Display Objects within this container.\n     *\n     * @param {PIXI.DisplayObject} child - First display object to swap\n     * @param {PIXI.DisplayObject} child2 - Second display object to swap\n     */\n    Container.prototype.swapChildren = function (child, child2) {\n        if (child === child2) {\n            return;\n        }\n        var index1 = this.getChildIndex(child);\n        var index2 = this.getChildIndex(child2);\n        this.children[index1] = child2;\n        this.children[index2] = child;\n        this.onChildrenChange(index1 < index2 ? index1 : index2);\n    };\n    /**\n     * Returns the index position of a child DisplayObject instance\n     *\n     * @param {PIXI.DisplayObject} child - The DisplayObject instance to identify\n     * @return {number} The index position of the child display object to identify\n     */\n    Container.prototype.getChildIndex = function (child) {\n        var index = this.children.indexOf(child);\n        if (index === -1) {\n            throw new Error('The supplied DisplayObject must be a child of the caller');\n        }\n        return index;\n    };\n    /**\n     * Changes the position of an existing child in the display object container\n     *\n     * @param {PIXI.DisplayObject} child - The child DisplayObject instance for which you want to change the index number\n     * @param {number} index - The resulting index number for the child display object\n     */\n    Container.prototype.setChildIndex = function (child, index) {\n        if (index < 0 || index >= this.children.length) {\n            throw new Error(\"The index \" + index + \" supplied is out of bounds \" + this.children.length);\n        }\n        var currentIndex = this.getChildIndex(child);\n        (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.removeItems)(this.children, currentIndex, 1); // remove from old position\n        this.children.splice(index, 0, child); // add at new position\n        this.onChildrenChange(index);\n    };\n    /**\n     * Returns the child at the specified index\n     *\n     * @param {number} index - The index to get the child at\n     * @return {PIXI.DisplayObject} The child at the given index, if any.\n     */\n    Container.prototype.getChildAt = function (index) {\n        if (index < 0 || index >= this.children.length) {\n            throw new Error(\"getChildAt: Index (\" + index + \") does not exist.\");\n        }\n        return this.children[index];\n    };\n    /**\n     * Removes one or more children from the container.\n     *\n     * @param {...PIXI.DisplayObject} children - The DisplayObject(s) to remove\n     * @return {PIXI.DisplayObject} The first child that was removed.\n     */\n    Container.prototype.removeChild = function () {\n        var arguments$1 = arguments;\n\n        var children = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            children[_i] = arguments$1[_i];\n        }\n        // if there is only one argument we can bypass looping through the them\n        if (children.length > 1) {\n            // loop through the arguments property and remove all children\n            for (var i = 0; i < children.length; i++) {\n                this.removeChild(children[i]);\n            }\n        }\n        else {\n            var child = children[0];\n            var index = this.children.indexOf(child);\n            if (index === -1)\n                { return null; }\n            child.parent = null;\n            // ensure child transform will be recalculated\n            child.transform._parentID = -1;\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.removeItems)(this.children, index, 1);\n            // ensure bounds will be recalculated\n            this._boundsID++;\n            // TODO - lets either do all callbacks or all events.. not both!\n            this.onChildrenChange(index);\n            child.emit('removed', this);\n            this.emit('childRemoved', child, this, index);\n        }\n        return children[0];\n    };\n    /**\n     * Removes a child from the specified index position.\n     *\n     * @param {number} index - The index to get the child from\n     * @return {PIXI.DisplayObject} The child that was removed.\n     */\n    Container.prototype.removeChildAt = function (index) {\n        var child = this.getChildAt(index);\n        // ensure child transform will be recalculated..\n        child.parent = null;\n        child.transform._parentID = -1;\n        (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.removeItems)(this.children, index, 1);\n        // ensure bounds will be recalculated\n        this._boundsID++;\n        // TODO - lets either do all callbacks or all events.. not both!\n        this.onChildrenChange(index);\n        child.emit('removed', this);\n        this.emit('childRemoved', child, this, index);\n        return child;\n    };\n    /**\n     * Removes all children from this container that are within the begin and end indexes.\n     *\n     * @param {number} [beginIndex=0] - The beginning position.\n     * @param {number} [endIndex=this.children.length] - The ending position. Default value is size of the container.\n     * @returns {PIXI.DisplayObject[]} List of removed children\n     */\n    Container.prototype.removeChildren = function (beginIndex, endIndex) {\n        if (beginIndex === void 0) { beginIndex = 0; }\n        if (endIndex === void 0) { endIndex = this.children.length; }\n        var begin = beginIndex;\n        var end = endIndex;\n        var range = end - begin;\n        var removed;\n        if (range > 0 && range <= end) {\n            removed = this.children.splice(begin, range);\n            for (var i = 0; i < removed.length; ++i) {\n                removed[i].parent = null;\n                if (removed[i].transform) {\n                    removed[i].transform._parentID = -1;\n                }\n            }\n            this._boundsID++;\n            this.onChildrenChange(beginIndex);\n            for (var i = 0; i < removed.length; ++i) {\n                removed[i].emit('removed', this);\n                this.emit('childRemoved', removed[i], this, i);\n            }\n            return removed;\n        }\n        else if (range === 0 && this.children.length === 0) {\n            return [];\n        }\n        throw new RangeError('removeChildren: numeric values are outside the acceptable range.');\n    };\n    /**\n     * Sorts children by zIndex. Previous order is mantained for 2 children with the same zIndex.\n     */\n    Container.prototype.sortChildren = function () {\n        var sortRequired = false;\n        for (var i = 0, j = this.children.length; i < j; ++i) {\n            var child = this.children[i];\n            child._lastSortedIndex = i;\n            if (!sortRequired && child.zIndex !== 0) {\n                sortRequired = true;\n            }\n        }\n        if (sortRequired && this.children.length > 1) {\n            this.children.sort(sortChildren);\n        }\n        this.sortDirty = false;\n    };\n    /**\n     * Updates the transform on all children of this container for rendering\n     */\n    Container.prototype.updateTransform = function () {\n        if (this.sortableChildren && this.sortDirty) {\n            this.sortChildren();\n        }\n        this._boundsID++;\n        this.transform.updateTransform(this.parent.transform);\n        // TODO: check render flags, how to process stuff here\n        this.worldAlpha = this.alpha * this.parent.worldAlpha;\n        for (var i = 0, j = this.children.length; i < j; ++i) {\n            var child = this.children[i];\n            if (child.visible) {\n                child.updateTransform();\n            }\n        }\n    };\n    /**\n     * Recalculates the bounds of the container.\n     *\n     */\n    Container.prototype.calculateBounds = function () {\n        this._bounds.clear();\n        this._calculateBounds();\n        for (var i = 0; i < this.children.length; i++) {\n            var child = this.children[i];\n            if (!child.visible || !child.renderable) {\n                continue;\n            }\n            child.calculateBounds();\n            // TODO: filter+mask, need to mask both somehow\n            if (child._mask) {\n                var maskObject = (child._mask.maskObject || child._mask);\n                maskObject.calculateBounds();\n                this._bounds.addBoundsMask(child._bounds, maskObject._bounds);\n            }\n            else if (child.filterArea) {\n                this._bounds.addBoundsArea(child._bounds, child.filterArea);\n            }\n            else {\n                this._bounds.addBounds(child._bounds);\n            }\n        }\n        this._bounds.updateID = this._boundsID;\n    };\n    /**\n     * Retrieves the local bounds of the displayObject as a rectangle object.\n     *\n     * @param {PIXI.Rectangle} [rect] - Optional rectangle to store the result of the bounds calculation.\n     * @param {boolean} [skipChildrenUpdate=false] - Setting to `true` will stop re-calculation of children transforms,\n     *  it was default behaviour of pixi 4.0-5.2 and caused many problems to users.\n     * @return {PIXI.Rectangle} The rectangular bounding area.\n     */\n    Container.prototype.getLocalBounds = function (rect, skipChildrenUpdate) {\n        if (skipChildrenUpdate === void 0) { skipChildrenUpdate = false; }\n        var result = _super.prototype.getLocalBounds.call(this, rect);\n        if (!skipChildrenUpdate) {\n            for (var i = 0, j = this.children.length; i < j; ++i) {\n                var child = this.children[i];\n                if (child.visible) {\n                    child.updateTransform();\n                }\n            }\n        }\n        return result;\n    };\n    /**\n     * Recalculates the bounds of the object. Override this to\n     * calculate the bounds of the specific object (not including children).\n     *\n     * @protected\n     */\n    Container.prototype._calculateBounds = function () {\n        // FILL IN//\n    };\n    /**\n     * Renders the object using the WebGL renderer\n     *\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Container.prototype.render = function (renderer) {\n        // if the object is not visible or the alpha is 0 then no need to render this element\n        if (!this.visible || this.worldAlpha <= 0 || !this.renderable) {\n            return;\n        }\n        // do a quick check to see if this element has a mask or a filter.\n        if (this._mask || (this.filters && this.filters.length)) {\n            this.renderAdvanced(renderer);\n        }\n        else {\n            this._render(renderer);\n            // simple render children!\n            for (var i = 0, j = this.children.length; i < j; ++i) {\n                this.children[i].render(renderer);\n            }\n        }\n    };\n    /**\n     * Render the object using the WebGL renderer and advanced features.\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Container.prototype.renderAdvanced = function (renderer) {\n        renderer.batch.flush();\n        var filters = this.filters;\n        var mask = this._mask;\n        // push filter first as we need to ensure the stencil buffer is correct for any masking\n        if (filters) {\n            if (!this._enabledFilters) {\n                this._enabledFilters = [];\n            }\n            this._enabledFilters.length = 0;\n            for (var i = 0; i < filters.length; i++) {\n                if (filters[i].enabled) {\n                    this._enabledFilters.push(filters[i]);\n                }\n            }\n            if (this._enabledFilters.length) {\n                renderer.filter.push(this, this._enabledFilters);\n            }\n        }\n        if (mask) {\n            renderer.mask.push(this, this._mask);\n        }\n        // add this object to the batch, only rendered if it has a texture.\n        this._render(renderer);\n        // now loop through the children and make sure they get rendered\n        for (var i = 0, j = this.children.length; i < j; i++) {\n            this.children[i].render(renderer);\n        }\n        renderer.batch.flush();\n        if (mask) {\n            renderer.mask.pop(this);\n        }\n        if (filters && this._enabledFilters && this._enabledFilters.length) {\n            renderer.filter.pop();\n        }\n    };\n    /**\n     * To be overridden by the subclasses.\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Container.prototype._render = function (_renderer) {\n        // this is where content itself gets rendered...\n    };\n    /**\n     * Removes all internal references and listeners as well as removes children from the display list.\n     * Do not use a Container after calling `destroy`.\n     *\n     * @param {object|boolean} [options] - Options parameter. A boolean will act as if all options\n     *  have been set to that value\n     * @param {boolean} [options.children=false] - if set to true, all the children will have their destroy\n     *  method called as well. 'options' will be passed on to those calls.\n     * @param {boolean} [options.texture=false] - Only used for child Sprites if options.children is set to true\n     *  Should it destroy the texture of the child sprite\n     * @param {boolean} [options.baseTexture=false] - Only used for child Sprites if options.children is set to true\n     *  Should it destroy the base texture of the child sprite\n     */\n    Container.prototype.destroy = function (options) {\n        _super.prototype.destroy.call(this);\n        this.sortDirty = false;\n        var destroyChildren = typeof options === 'boolean' ? options : options && options.children;\n        var oldChildren = this.removeChildren(0, this.children.length);\n        if (destroyChildren) {\n            for (var i = 0; i < oldChildren.length; ++i) {\n                oldChildren[i].destroy(options);\n            }\n        }\n    };\n    Object.defineProperty(Container.prototype, \"width\", {\n        /**\n         * The width of the Container, setting this will actually modify the scale to achieve the value set\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.scale.x * this.getLocalBounds().width;\n        },\n        set: function (value) {\n            var width = this.getLocalBounds().width;\n            if (width !== 0) {\n                this.scale.x = value / width;\n            }\n            else {\n                this.scale.x = 1;\n            }\n            this._width = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Container.prototype, \"height\", {\n        /**\n         * The height of the Container, setting this will actually modify the scale to achieve the value set\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.scale.y * this.getLocalBounds().height;\n        },\n        set: function (value) {\n            var height = this.getLocalBounds().height;\n            if (height !== 0) {\n                this.scale.y = value / height;\n            }\n            else {\n                this.scale.y = 1;\n            }\n            this._height = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return Container;\n}(DisplayObject));\n/**\n * Container default updateTransform, does update children of container.\n * Will crash if there's no parent element.\n *\n * @memberof PIXI.Container#\n * @function containerUpdateTransform\n */\nContainer.prototype.containerUpdateTransform = Container.prototype.updateTransform;\n\n\n//# sourceMappingURL=display.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/display/lib/display.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/extract/lib/extract.es.js":
/*!******************************************************!*\
  !*** ./node_modules/@pixi/extract/lib/extract.es.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Extract\": () => (/* binding */ Extract)\n/* harmony export */ });\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/extract - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/extract is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\nvar TEMP_RECT = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle();\nvar BYTES_PER_PIXEL = 4;\n/**\n * This class provides renderer-specific plugins for exporting content from a renderer.\n * For instance, these plugins can be used for saving an Image, Canvas element or for exporting the raw image data (pixels).\n *\n * Do not instantiate these plugins directly. It is available from the `renderer.plugins` property.\n * See {@link PIXI.CanvasRenderer#plugins} or {@link PIXI.Renderer#plugins}.\n * @example\n * // Create a new app (will auto-add extract plugin to renderer)\n * const app = new PIXI.Application();\n *\n * // Draw a red circle\n * const graphics = new PIXI.Graphics()\n *     .beginFill(0xFF0000)\n *     .drawCircle(0, 0, 50);\n *\n * // Render the graphics as an HTMLImageElement\n * const image = app.renderer.plugins.extract.image(graphics);\n * document.body.appendChild(image);\n * @class\n * @memberof PIXI\n */\nvar Extract = /** @class */ (function () {\n    /**\n     * @param {PIXI.Renderer} renderer - A reference to the current renderer\n     */\n    function Extract(renderer) {\n        this.renderer = renderer;\n        /**\n         * Collection of methods for extracting data (image, pixels, etc.) from a display object or render texture\n         *\n         * @member {PIXI.Extract} extract\n         * @memberof PIXI.Renderer#\n         * @see PIXI.Extract\n         */\n        renderer.extract = this;\n    }\n    /**\n     * Will return a HTML Image of the target\n     *\n     * @param {PIXI.DisplayObject|PIXI.RenderTexture} target - A displayObject or renderTexture\n     *  to convert. If left empty will use the main renderer\n     * @param {string} [format] - Image format, e.g. \"image/jpeg\" or \"image/webp\".\n     * @param {number} [quality] - JPEG or Webp compression from 0 to 1. Default is 0.92.\n     * @return {HTMLImageElement} HTML Image of the target\n     */\n    Extract.prototype.image = function (target, format, quality) {\n        var image = new Image();\n        image.src = this.base64(target, format, quality);\n        return image;\n    };\n    /**\n     * Will return a a base64 encoded string of this target. It works by calling\n     *  `Extract.getCanvas` and then running toDataURL on that.\n     *\n     * @param {PIXI.DisplayObject|PIXI.RenderTexture} target - A displayObject or renderTexture\n     *  to convert. If left empty will use the main renderer\n     * @param {string} [format] - Image format, e.g. \"image/jpeg\" or \"image/webp\".\n     * @param {number} [quality] - JPEG or Webp compression from 0 to 1. Default is 0.92.\n     * @return {string} A base64 encoded string of the texture.\n     */\n    Extract.prototype.base64 = function (target, format, quality) {\n        return this.canvas(target).toDataURL(format, quality);\n    };\n    /**\n     * Creates a Canvas element, renders this target to it and then returns it.\n     *\n     * @param {PIXI.DisplayObject|PIXI.RenderTexture} target - A displayObject or renderTexture\n     *  to convert. If left empty will use the main renderer\n     * @return {HTMLCanvasElement} A Canvas element with the texture rendered on.\n     */\n    Extract.prototype.canvas = function (target) {\n        var renderer = this.renderer;\n        var resolution;\n        var frame;\n        var flipY = false;\n        var renderTexture;\n        var generated = false;\n        if (target) {\n            if (target instanceof _pixi_core__WEBPACK_IMPORTED_MODULE_2__.RenderTexture) {\n                renderTexture = target;\n            }\n            else {\n                renderTexture = this.renderer.generateTexture(target);\n                generated = true;\n            }\n        }\n        if (renderTexture) {\n            resolution = renderTexture.baseTexture.resolution;\n            frame = renderTexture.frame;\n            flipY = false;\n            renderer.renderTexture.bind(renderTexture);\n        }\n        else {\n            resolution = this.renderer.resolution;\n            flipY = true;\n            frame = TEMP_RECT;\n            frame.width = this.renderer.width;\n            frame.height = this.renderer.height;\n            renderer.renderTexture.bind(null);\n        }\n        var width = Math.floor((frame.width * resolution) + 1e-4);\n        var height = Math.floor((frame.height * resolution) + 1e-4);\n        var canvasBuffer = new _pixi_utils__WEBPACK_IMPORTED_MODULE_0__.CanvasRenderTarget(width, height, 1);\n        var webglPixels = new Uint8Array(BYTES_PER_PIXEL * width * height);\n        // read pixels to the array\n        var gl = renderer.gl;\n        gl.readPixels(frame.x * resolution, frame.y * resolution, width, height, gl.RGBA, gl.UNSIGNED_BYTE, webglPixels);\n        // add the pixels to the canvas\n        var canvasData = canvasBuffer.context.getImageData(0, 0, width, height);\n        Extract.arrayPostDivide(webglPixels, canvasData.data);\n        canvasBuffer.context.putImageData(canvasData, 0, 0);\n        // pulling pixels\n        if (flipY) {\n            var target_1 = new _pixi_utils__WEBPACK_IMPORTED_MODULE_0__.CanvasRenderTarget(canvasBuffer.width, canvasBuffer.height, 1);\n            target_1.context.scale(1, -1);\n            // we can't render to itself because we should be empty before render.\n            target_1.context.drawImage(canvasBuffer.canvas, 0, -height);\n            canvasBuffer.destroy();\n            canvasBuffer = target_1;\n        }\n        if (generated) {\n            renderTexture.destroy(true);\n        }\n        // send the canvas back..\n        return canvasBuffer.canvas;\n    };\n    /**\n     * Will return a one-dimensional array containing the pixel data of the entire texture in RGBA\n     * order, with integer values between 0 and 255 (included).\n     *\n     * @param {PIXI.DisplayObject|PIXI.RenderTexture} target - A displayObject or renderTexture\n     *  to convert. If left empty will use the main renderer\n     * @return {Uint8Array} One-dimensional array containing the pixel data of the entire texture\n     */\n    Extract.prototype.pixels = function (target) {\n        var renderer = this.renderer;\n        var resolution;\n        var frame;\n        var renderTexture;\n        var generated = false;\n        if (target) {\n            if (target instanceof _pixi_core__WEBPACK_IMPORTED_MODULE_2__.RenderTexture) {\n                renderTexture = target;\n            }\n            else {\n                renderTexture = this.renderer.generateTexture(target);\n                generated = true;\n            }\n        }\n        if (renderTexture) {\n            resolution = renderTexture.baseTexture.resolution;\n            frame = renderTexture.frame;\n            // bind the buffer\n            renderer.renderTexture.bind(renderTexture);\n        }\n        else {\n            resolution = renderer.resolution;\n            frame = TEMP_RECT;\n            frame.width = renderer.width;\n            frame.height = renderer.height;\n            renderer.renderTexture.bind(null);\n        }\n        var width = frame.width * resolution;\n        var height = frame.height * resolution;\n        var webglPixels = new Uint8Array(BYTES_PER_PIXEL * width * height);\n        // read pixels to the array\n        var gl = renderer.gl;\n        gl.readPixels(frame.x * resolution, frame.y * resolution, width, height, gl.RGBA, gl.UNSIGNED_BYTE, webglPixels);\n        if (generated) {\n            renderTexture.destroy(true);\n        }\n        Extract.arrayPostDivide(webglPixels, webglPixels);\n        return webglPixels;\n    };\n    /**\n     * Destroys the extract\n     *\n     */\n    Extract.prototype.destroy = function () {\n        this.renderer.extract = null;\n        this.renderer = null;\n    };\n    /**\n     * Takes premultiplied pixel data and produces regular pixel data\n     *\n     * @private\n     * @param pixels {number[] | Uint8Array | Uint8ClampedArray} array of pixel data\n     * @param out {number[] | Uint8Array | Uint8ClampedArray} output array\n     */\n    Extract.arrayPostDivide = function (pixels, out) {\n        for (var i = 0; i < pixels.length; i += 4) {\n            var alpha = out[i + 3] = pixels[i + 3];\n            if (alpha !== 0) {\n                out[i] = Math.round(Math.min(pixels[i] * 255.0 / alpha, 255.0));\n                out[i + 1] = Math.round(Math.min(pixels[i + 1] * 255.0 / alpha, 255.0));\n                out[i + 2] = Math.round(Math.min(pixels[i + 2] * 255.0 / alpha, 255.0));\n            }\n            else {\n                out[i] = pixels[i];\n                out[i + 1] = pixels[i + 1];\n                out[i + 2] = pixels[i + 2];\n            }\n        }\n    };\n    return Extract;\n}());\n\n\n//# sourceMappingURL=extract.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/extract/lib/extract.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-alpha/lib/filter-alpha.es.js":
/*!****************************************************************!*\
  !*** ./node_modules/@pixi/filter-alpha/lib/filter-alpha.es.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AlphaFilter\": () => (/* binding */ AlphaFilter)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/filter-alpha - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-alpha is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar fragment = \"varying vec2 vTextureCoord;\\n\\nuniform sampler2D uSampler;\\nuniform float uAlpha;\\n\\nvoid main(void)\\n{\\n   gl_FragColor = texture2D(uSampler, vTextureCoord) * uAlpha;\\n}\\n\";\n\n/**\n * Simplest filter - applies alpha.\n *\n * Use this instead of Container's alpha property to avoid visual layering of individual elements.\n * AlphaFilter applies alpha evenly across the entire display object and any opaque elements it contains.\n * If elements are not opaque, they will blend with each other anyway.\n *\n * Very handy if you want to use common features of all filters:\n *\n * 1. Assign a blendMode to this filter, blend all elements inside display object with background.\n *\n * 2. To use clipping in display coordinates, assign a filterArea to the same container that has this filter.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar AlphaFilter = /** @class */ (function (_super) {\n    __extends(AlphaFilter, _super);\n    /**\n     * @param {number} [alpha=1] - Amount of alpha from 0 to 1, where 0 is transparent\n     */\n    function AlphaFilter(alpha) {\n        if (alpha === void 0) { alpha = 1.0; }\n        var _this = _super.call(this, _pixi_core__WEBPACK_IMPORTED_MODULE_0__.defaultVertex, fragment, { uAlpha: 1 }) || this;\n        _this.alpha = alpha;\n        return _this;\n    }\n    Object.defineProperty(AlphaFilter.prototype, \"alpha\", {\n        /**\n         * Coefficient for alpha multiplication\n         *\n         * @member {number}\n         * @default 1\n         */\n        get: function () {\n            return this.uniforms.uAlpha;\n        },\n        set: function (value) {\n            this.uniforms.uAlpha = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return AlphaFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n\n//# sourceMappingURL=filter-alpha.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-alpha/lib/filter-alpha.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-blur/lib/filter-blur.es.js":
/*!**************************************************************!*\
  !*** ./node_modules/@pixi/filter-blur/lib/filter-blur.es.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BlurFilter\": () => (/* binding */ BlurFilter),\n/* harmony export */   \"BlurFilterPass\": () => (/* binding */ BlurFilterPass)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/* harmony import */ var _pixi_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/settings */ \"./node_modules/@pixi/settings/lib/settings.es.js\");\n/*!\n * @pixi/filter-blur - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-blur is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar vertTemplate = \"\\n    attribute vec2 aVertexPosition;\\n\\n    uniform mat3 projectionMatrix;\\n\\n    uniform float strength;\\n\\n    varying vec2 vBlurTexCoords[%size%];\\n\\n    uniform vec4 inputSize;\\n    uniform vec4 outputFrame;\\n\\n    vec4 filterVertexPosition( void )\\n    {\\n        vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\\n\\n        return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\\n    }\\n\\n    vec2 filterTextureCoord( void )\\n    {\\n        return aVertexPosition * (outputFrame.zw * inputSize.zw);\\n    }\\n\\n    void main(void)\\n    {\\n        gl_Position = filterVertexPosition();\\n\\n        vec2 textureCoord = filterTextureCoord();\\n        %blur%\\n    }\";\nfunction generateBlurVertSource(kernelSize, x) {\n    var halfLength = Math.ceil(kernelSize / 2);\n    var vertSource = vertTemplate;\n    var blurLoop = '';\n    var template;\n    if (x) {\n        template = 'vBlurTexCoords[%index%] =  textureCoord + vec2(%sampleIndex% * strength, 0.0);';\n    }\n    else {\n        template = 'vBlurTexCoords[%index%] =  textureCoord + vec2(0.0, %sampleIndex% * strength);';\n    }\n    for (var i = 0; i < kernelSize; i++) {\n        var blur = template.replace('%index%', i.toString());\n        blur = blur.replace('%sampleIndex%', i - (halfLength - 1) + \".0\");\n        blurLoop += blur;\n        blurLoop += '\\n';\n    }\n    vertSource = vertSource.replace('%blur%', blurLoop);\n    vertSource = vertSource.replace('%size%', kernelSize.toString());\n    return vertSource;\n}\n\nvar GAUSSIAN_VALUES = {\n    5: [0.153388, 0.221461, 0.250301],\n    7: [0.071303, 0.131514, 0.189879, 0.214607],\n    9: [0.028532, 0.067234, 0.124009, 0.179044, 0.20236],\n    11: [0.0093, 0.028002, 0.065984, 0.121703, 0.175713, 0.198596],\n    13: [0.002406, 0.009255, 0.027867, 0.065666, 0.121117, 0.174868, 0.197641],\n    15: [0.000489, 0.002403, 0.009246, 0.02784, 0.065602, 0.120999, 0.174697, 0.197448],\n};\nvar fragTemplate = [\n    'varying vec2 vBlurTexCoords[%size%];',\n    'uniform sampler2D uSampler;',\n    'void main(void)',\n    '{',\n    '    gl_FragColor = vec4(0.0);',\n    '    %blur%',\n    '}' ].join('\\n');\nfunction generateBlurFragSource(kernelSize) {\n    var kernel = GAUSSIAN_VALUES[kernelSize];\n    var halfLength = kernel.length;\n    var fragSource = fragTemplate;\n    var blurLoop = '';\n    var template = 'gl_FragColor += texture2D(uSampler, vBlurTexCoords[%index%]) * %value%;';\n    var value;\n    for (var i = 0; i < kernelSize; i++) {\n        var blur = template.replace('%index%', i.toString());\n        value = i;\n        if (i >= halfLength) {\n            value = kernelSize - i - 1;\n        }\n        blur = blur.replace('%value%', kernel[value].toString());\n        blurLoop += blur;\n        blurLoop += '\\n';\n    }\n    fragSource = fragSource.replace('%blur%', blurLoop);\n    fragSource = fragSource.replace('%size%', kernelSize.toString());\n    return fragSource;\n}\n\n/**\n * Different types of environments for WebGL.\n *\n * @static\n * @memberof PIXI\n * @name ENV\n * @enum {number}\n * @property {number} WEBGL_LEGACY - Used for older v1 WebGL devices. PixiJS will aim to ensure compatibility\n *  with older / less advanced devices. If you experience unexplained flickering prefer this environment.\n * @property {number} WEBGL - Version 1 of WebGL\n * @property {number} WEBGL2 - Version 2 of WebGL\n */\nvar ENV;\n(function (ENV) {\n    ENV[ENV[\"WEBGL_LEGACY\"] = 0] = \"WEBGL_LEGACY\";\n    ENV[ENV[\"WEBGL\"] = 1] = \"WEBGL\";\n    ENV[ENV[\"WEBGL2\"] = 2] = \"WEBGL2\";\n})(ENV || (ENV = {}));\n/**\n * Constant to identify the Renderer Type.\n *\n * @static\n * @memberof PIXI\n * @name RENDERER_TYPE\n * @enum {number}\n * @property {number} UNKNOWN - Unknown render type.\n * @property {number} WEBGL - WebGL render type.\n * @property {number} CANVAS - Canvas render type.\n */\nvar RENDERER_TYPE;\n(function (RENDERER_TYPE) {\n    RENDERER_TYPE[RENDERER_TYPE[\"UNKNOWN\"] = 0] = \"UNKNOWN\";\n    RENDERER_TYPE[RENDERER_TYPE[\"WEBGL\"] = 1] = \"WEBGL\";\n    RENDERER_TYPE[RENDERER_TYPE[\"CANVAS\"] = 2] = \"CANVAS\";\n})(RENDERER_TYPE || (RENDERER_TYPE = {}));\n/**\n * Bitwise OR of masks that indicate the buffers to be cleared.\n *\n * @static\n * @memberof PIXI\n * @name BUFFER_BITS\n * @enum {number}\n * @property {number} COLOR - Indicates the buffers currently enabled for color writing.\n * @property {number} DEPTH - Indicates the depth buffer.\n * @property {number} STENCIL - Indicates the stencil buffer.\n */\nvar BUFFER_BITS;\n(function (BUFFER_BITS) {\n    BUFFER_BITS[BUFFER_BITS[\"COLOR\"] = 16384] = \"COLOR\";\n    BUFFER_BITS[BUFFER_BITS[\"DEPTH\"] = 256] = \"DEPTH\";\n    BUFFER_BITS[BUFFER_BITS[\"STENCIL\"] = 1024] = \"STENCIL\";\n})(BUFFER_BITS || (BUFFER_BITS = {}));\n/**\n * Various blend modes supported by PIXI.\n *\n * IMPORTANT - The WebGL renderer only supports the NORMAL, ADD, MULTIPLY and SCREEN blend modes.\n * Anything else will silently act like NORMAL.\n *\n * @memberof PIXI\n * @name BLEND_MODES\n * @enum {number}\n * @property {number} NORMAL\n * @property {number} ADD\n * @property {number} MULTIPLY\n * @property {number} SCREEN\n * @property {number} OVERLAY\n * @property {number} DARKEN\n * @property {number} LIGHTEN\n * @property {number} COLOR_DODGE\n * @property {number} COLOR_BURN\n * @property {number} HARD_LIGHT\n * @property {number} SOFT_LIGHT\n * @property {number} DIFFERENCE\n * @property {number} EXCLUSION\n * @property {number} HUE\n * @property {number} SATURATION\n * @property {number} COLOR\n * @property {number} LUMINOSITY\n * @property {number} NORMAL_NPM\n * @property {number} ADD_NPM\n * @property {number} SCREEN_NPM\n * @property {number} NONE\n * @property {number} SRC_IN\n * @property {number} SRC_OUT\n * @property {number} SRC_ATOP\n * @property {number} DST_OVER\n * @property {number} DST_IN\n * @property {number} DST_OUT\n * @property {number} DST_ATOP\n * @property {number} SUBTRACT\n * @property {number} SRC_OVER\n * @property {number} ERASE\n * @property {number} XOR\n */\nvar BLEND_MODES;\n(function (BLEND_MODES) {\n    BLEND_MODES[BLEND_MODES[\"NORMAL\"] = 0] = \"NORMAL\";\n    BLEND_MODES[BLEND_MODES[\"ADD\"] = 1] = \"ADD\";\n    BLEND_MODES[BLEND_MODES[\"MULTIPLY\"] = 2] = \"MULTIPLY\";\n    BLEND_MODES[BLEND_MODES[\"SCREEN\"] = 3] = \"SCREEN\";\n    BLEND_MODES[BLEND_MODES[\"OVERLAY\"] = 4] = \"OVERLAY\";\n    BLEND_MODES[BLEND_MODES[\"DARKEN\"] = 5] = \"DARKEN\";\n    BLEND_MODES[BLEND_MODES[\"LIGHTEN\"] = 6] = \"LIGHTEN\";\n    BLEND_MODES[BLEND_MODES[\"COLOR_DODGE\"] = 7] = \"COLOR_DODGE\";\n    BLEND_MODES[BLEND_MODES[\"COLOR_BURN\"] = 8] = \"COLOR_BURN\";\n    BLEND_MODES[BLEND_MODES[\"HARD_LIGHT\"] = 9] = \"HARD_LIGHT\";\n    BLEND_MODES[BLEND_MODES[\"SOFT_LIGHT\"] = 10] = \"SOFT_LIGHT\";\n    BLEND_MODES[BLEND_MODES[\"DIFFERENCE\"] = 11] = \"DIFFERENCE\";\n    BLEND_MODES[BLEND_MODES[\"EXCLUSION\"] = 12] = \"EXCLUSION\";\n    BLEND_MODES[BLEND_MODES[\"HUE\"] = 13] = \"HUE\";\n    BLEND_MODES[BLEND_MODES[\"SATURATION\"] = 14] = \"SATURATION\";\n    BLEND_MODES[BLEND_MODES[\"COLOR\"] = 15] = \"COLOR\";\n    BLEND_MODES[BLEND_MODES[\"LUMINOSITY\"] = 16] = \"LUMINOSITY\";\n    BLEND_MODES[BLEND_MODES[\"NORMAL_NPM\"] = 17] = \"NORMAL_NPM\";\n    BLEND_MODES[BLEND_MODES[\"ADD_NPM\"] = 18] = \"ADD_NPM\";\n    BLEND_MODES[BLEND_MODES[\"SCREEN_NPM\"] = 19] = \"SCREEN_NPM\";\n    BLEND_MODES[BLEND_MODES[\"NONE\"] = 20] = \"NONE\";\n    BLEND_MODES[BLEND_MODES[\"SRC_OVER\"] = 0] = \"SRC_OVER\";\n    BLEND_MODES[BLEND_MODES[\"SRC_IN\"] = 21] = \"SRC_IN\";\n    BLEND_MODES[BLEND_MODES[\"SRC_OUT\"] = 22] = \"SRC_OUT\";\n    BLEND_MODES[BLEND_MODES[\"SRC_ATOP\"] = 23] = \"SRC_ATOP\";\n    BLEND_MODES[BLEND_MODES[\"DST_OVER\"] = 24] = \"DST_OVER\";\n    BLEND_MODES[BLEND_MODES[\"DST_IN\"] = 25] = \"DST_IN\";\n    BLEND_MODES[BLEND_MODES[\"DST_OUT\"] = 26] = \"DST_OUT\";\n    BLEND_MODES[BLEND_MODES[\"DST_ATOP\"] = 27] = \"DST_ATOP\";\n    BLEND_MODES[BLEND_MODES[\"ERASE\"] = 26] = \"ERASE\";\n    BLEND_MODES[BLEND_MODES[\"SUBTRACT\"] = 28] = \"SUBTRACT\";\n    BLEND_MODES[BLEND_MODES[\"XOR\"] = 29] = \"XOR\";\n})(BLEND_MODES || (BLEND_MODES = {}));\n/**\n * Various webgl draw modes. These can be used to specify which GL drawMode to use\n * under certain situations and renderers.\n *\n * @memberof PIXI\n * @static\n * @name DRAW_MODES\n * @enum {number}\n * @property {number} POINTS\n * @property {number} LINES\n * @property {number} LINE_LOOP\n * @property {number} LINE_STRIP\n * @property {number} TRIANGLES\n * @property {number} TRIANGLE_STRIP\n * @property {number} TRIANGLE_FAN\n */\nvar DRAW_MODES;\n(function (DRAW_MODES) {\n    DRAW_MODES[DRAW_MODES[\"POINTS\"] = 0] = \"POINTS\";\n    DRAW_MODES[DRAW_MODES[\"LINES\"] = 1] = \"LINES\";\n    DRAW_MODES[DRAW_MODES[\"LINE_LOOP\"] = 2] = \"LINE_LOOP\";\n    DRAW_MODES[DRAW_MODES[\"LINE_STRIP\"] = 3] = \"LINE_STRIP\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLES\"] = 4] = \"TRIANGLES\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLE_STRIP\"] = 5] = \"TRIANGLE_STRIP\";\n    DRAW_MODES[DRAW_MODES[\"TRIANGLE_FAN\"] = 6] = \"TRIANGLE_FAN\";\n})(DRAW_MODES || (DRAW_MODES = {}));\n/**\n * Various GL texture/resources formats.\n *\n * @memberof PIXI\n * @static\n * @name FORMATS\n * @enum {number}\n * @property {number} RGBA=6408\n * @property {number} RGB=6407\n * @property {number} ALPHA=6406\n * @property {number} LUMINANCE=6409\n * @property {number} LUMINANCE_ALPHA=6410\n * @property {number} DEPTH_COMPONENT=6402\n * @property {number} DEPTH_STENCIL=34041\n */\nvar FORMATS;\n(function (FORMATS) {\n    FORMATS[FORMATS[\"RGBA\"] = 6408] = \"RGBA\";\n    FORMATS[FORMATS[\"RGB\"] = 6407] = \"RGB\";\n    FORMATS[FORMATS[\"ALPHA\"] = 6406] = \"ALPHA\";\n    FORMATS[FORMATS[\"LUMINANCE\"] = 6409] = \"LUMINANCE\";\n    FORMATS[FORMATS[\"LUMINANCE_ALPHA\"] = 6410] = \"LUMINANCE_ALPHA\";\n    FORMATS[FORMATS[\"DEPTH_COMPONENT\"] = 6402] = \"DEPTH_COMPONENT\";\n    FORMATS[FORMATS[\"DEPTH_STENCIL\"] = 34041] = \"DEPTH_STENCIL\";\n})(FORMATS || (FORMATS = {}));\n/**\n * Various GL target types.\n *\n * @memberof PIXI\n * @static\n * @name TARGETS\n * @enum {number}\n * @property {number} TEXTURE_2D=3553\n * @property {number} TEXTURE_CUBE_MAP=34067\n * @property {number} TEXTURE_2D_ARRAY=35866\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_X=34069\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_X=34070\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_Y=34071\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_Y=34072\n * @property {number} TEXTURE_CUBE_MAP_POSITIVE_Z=34073\n * @property {number} TEXTURE_CUBE_MAP_NEGATIVE_Z=34074\n */\nvar TARGETS;\n(function (TARGETS) {\n    TARGETS[TARGETS[\"TEXTURE_2D\"] = 3553] = \"TEXTURE_2D\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP\"] = 34067] = \"TEXTURE_CUBE_MAP\";\n    TARGETS[TARGETS[\"TEXTURE_2D_ARRAY\"] = 35866] = \"TEXTURE_2D_ARRAY\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_X\"] = 34069] = \"TEXTURE_CUBE_MAP_POSITIVE_X\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_X\"] = 34070] = \"TEXTURE_CUBE_MAP_NEGATIVE_X\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_Y\"] = 34071] = \"TEXTURE_CUBE_MAP_POSITIVE_Y\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_Y\"] = 34072] = \"TEXTURE_CUBE_MAP_NEGATIVE_Y\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_POSITIVE_Z\"] = 34073] = \"TEXTURE_CUBE_MAP_POSITIVE_Z\";\n    TARGETS[TARGETS[\"TEXTURE_CUBE_MAP_NEGATIVE_Z\"] = 34074] = \"TEXTURE_CUBE_MAP_NEGATIVE_Z\";\n})(TARGETS || (TARGETS = {}));\n/**\n * Various GL data format types.\n *\n * @memberof PIXI\n * @static\n * @name TYPES\n * @enum {number}\n * @property {number} UNSIGNED_BYTE=5121\n * @property {number} UNSIGNED_SHORT=5123\n * @property {number} UNSIGNED_SHORT_5_6_5=33635\n * @property {number} UNSIGNED_SHORT_4_4_4_4=32819\n * @property {number} UNSIGNED_SHORT_5_5_5_1=32820\n * @property {number} FLOAT=5126\n * @property {number} HALF_FLOAT=36193\n */\nvar TYPES;\n(function (TYPES) {\n    TYPES[TYPES[\"UNSIGNED_BYTE\"] = 5121] = \"UNSIGNED_BYTE\";\n    TYPES[TYPES[\"UNSIGNED_SHORT\"] = 5123] = \"UNSIGNED_SHORT\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_5_6_5\"] = 33635] = \"UNSIGNED_SHORT_5_6_5\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_4_4_4_4\"] = 32819] = \"UNSIGNED_SHORT_4_4_4_4\";\n    TYPES[TYPES[\"UNSIGNED_SHORT_5_5_5_1\"] = 32820] = \"UNSIGNED_SHORT_5_5_5_1\";\n    TYPES[TYPES[\"FLOAT\"] = 5126] = \"FLOAT\";\n    TYPES[TYPES[\"HALF_FLOAT\"] = 36193] = \"HALF_FLOAT\";\n})(TYPES || (TYPES = {}));\n/**\n * The scale modes that are supported by pixi.\n *\n * The {@link PIXI.settings.SCALE_MODE} scale mode affects the default scaling mode of future operations.\n * It can be re-assigned to either LINEAR or NEAREST, depending upon suitability.\n *\n * @memberof PIXI\n * @static\n * @name SCALE_MODES\n * @enum {number}\n * @property {number} LINEAR Smooth scaling\n * @property {number} NEAREST Pixelating scaling\n */\nvar SCALE_MODES;\n(function (SCALE_MODES) {\n    SCALE_MODES[SCALE_MODES[\"NEAREST\"] = 0] = \"NEAREST\";\n    SCALE_MODES[SCALE_MODES[\"LINEAR\"] = 1] = \"LINEAR\";\n})(SCALE_MODES || (SCALE_MODES = {}));\n/**\n * The wrap modes that are supported by pixi.\n *\n * The {@link PIXI.settings.WRAP_MODE} wrap mode affects the default wrapping mode of future operations.\n * It can be re-assigned to either CLAMP or REPEAT, depending upon suitability.\n * If the texture is non power of two then clamp will be used regardless as WebGL can\n * only use REPEAT if the texture is po2.\n *\n * This property only affects WebGL.\n *\n * @name WRAP_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} CLAMP - The textures uvs are clamped\n * @property {number} REPEAT - The texture uvs tile and repeat\n * @property {number} MIRRORED_REPEAT - The texture uvs tile and repeat with mirroring\n */\nvar WRAP_MODES;\n(function (WRAP_MODES) {\n    WRAP_MODES[WRAP_MODES[\"CLAMP\"] = 33071] = \"CLAMP\";\n    WRAP_MODES[WRAP_MODES[\"REPEAT\"] = 10497] = \"REPEAT\";\n    WRAP_MODES[WRAP_MODES[\"MIRRORED_REPEAT\"] = 33648] = \"MIRRORED_REPEAT\";\n})(WRAP_MODES || (WRAP_MODES = {}));\n/**\n * Mipmap filtering modes that are supported by pixi.\n *\n * The {@link PIXI.settings.MIPMAP_TEXTURES} affects default texture filtering.\n * Mipmaps are generated for a baseTexture if its `mipmap` field is `ON`,\n * or its `POW2` and texture dimensions are powers of 2.\n * Due to platform restriction, `ON` option will work like `POW2` for webgl-1.\n *\n * This property only affects WebGL.\n *\n * @name MIPMAP_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} OFF - No mipmaps\n * @property {number} POW2 - Generate mipmaps if texture dimensions are pow2\n * @property {number} ON - Always generate mipmaps\n */\nvar MIPMAP_MODES;\n(function (MIPMAP_MODES) {\n    MIPMAP_MODES[MIPMAP_MODES[\"OFF\"] = 0] = \"OFF\";\n    MIPMAP_MODES[MIPMAP_MODES[\"POW2\"] = 1] = \"POW2\";\n    MIPMAP_MODES[MIPMAP_MODES[\"ON\"] = 2] = \"ON\";\n})(MIPMAP_MODES || (MIPMAP_MODES = {}));\n/**\n * How to treat textures with premultiplied alpha\n *\n * @name ALPHA_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NO_PREMULTIPLIED_ALPHA - Source is not premultiplied, leave it like that.\n *  Option for compressed and data textures that are created from typed arrays.\n * @property {number} PREMULTIPLY_ON_UPLOAD - Source is not premultiplied, premultiply on upload.\n *  Default option, used for all loaded images.\n * @property {number} PREMULTIPLIED_ALPHA - Source is already premultiplied\n *  Example: spine atlases with `_pma` suffix.\n * @property {number} NPM - Alias for NO_PREMULTIPLIED_ALPHA.\n * @property {number} UNPACK - Default option, alias for PREMULTIPLY_ON_UPLOAD.\n * @property {number} PMA - Alias for PREMULTIPLIED_ALPHA.\n */\nvar ALPHA_MODES;\n(function (ALPHA_MODES) {\n    ALPHA_MODES[ALPHA_MODES[\"NPM\"] = 0] = \"NPM\";\n    ALPHA_MODES[ALPHA_MODES[\"UNPACK\"] = 1] = \"UNPACK\";\n    ALPHA_MODES[ALPHA_MODES[\"PMA\"] = 2] = \"PMA\";\n    ALPHA_MODES[ALPHA_MODES[\"NO_PREMULTIPLIED_ALPHA\"] = 0] = \"NO_PREMULTIPLIED_ALPHA\";\n    ALPHA_MODES[ALPHA_MODES[\"PREMULTIPLY_ON_UPLOAD\"] = 1] = \"PREMULTIPLY_ON_UPLOAD\";\n    ALPHA_MODES[ALPHA_MODES[\"PREMULTIPLY_ALPHA\"] = 2] = \"PREMULTIPLY_ALPHA\";\n})(ALPHA_MODES || (ALPHA_MODES = {}));\n/**\n * How to clear renderTextures in filter\n *\n * @name CLEAR_MODES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} BLEND - Preserve the information in the texture, blend above\n * @property {number} CLEAR - Must use `gl.clear` operation\n * @property {number} BLIT - Clear or blit it, depends on device and level of paranoia\n * @property {number} NO - Alias for BLEND, same as `false` in earlier versions\n * @property {number} YES - Alias for CLEAR, same as `true` in earlier versions\n * @property {number} AUTO - Alias for BLIT\n */\nvar CLEAR_MODES;\n(function (CLEAR_MODES) {\n    CLEAR_MODES[CLEAR_MODES[\"NO\"] = 0] = \"NO\";\n    CLEAR_MODES[CLEAR_MODES[\"YES\"] = 1] = \"YES\";\n    CLEAR_MODES[CLEAR_MODES[\"AUTO\"] = 2] = \"AUTO\";\n    CLEAR_MODES[CLEAR_MODES[\"BLEND\"] = 0] = \"BLEND\";\n    CLEAR_MODES[CLEAR_MODES[\"CLEAR\"] = 1] = \"CLEAR\";\n    CLEAR_MODES[CLEAR_MODES[\"BLIT\"] = 2] = \"BLIT\";\n})(CLEAR_MODES || (CLEAR_MODES = {}));\n/**\n * The gc modes that are supported by pixi.\n *\n * The {@link PIXI.settings.GC_MODE} Garbage Collection mode for PixiJS textures is AUTO\n * If set to GC_MODE, the renderer will occasionally check textures usage. If they are not\n * used for a specified period of time they will be removed from the GPU. They will of course\n * be uploaded again when they are required. This is a silent behind the scenes process that\n * should ensure that the GPU does not  get filled up.\n *\n * Handy for mobile devices!\n * This property only affects WebGL.\n *\n * @name GC_MODES\n * @enum {number}\n * @static\n * @memberof PIXI\n * @property {number} AUTO - Garbage collection will happen periodically automatically\n * @property {number} MANUAL - Garbage collection will need to be called manually\n */\nvar GC_MODES;\n(function (GC_MODES) {\n    GC_MODES[GC_MODES[\"AUTO\"] = 0] = \"AUTO\";\n    GC_MODES[GC_MODES[\"MANUAL\"] = 1] = \"MANUAL\";\n})(GC_MODES || (GC_MODES = {}));\n/**\n * Constants that specify float precision in shaders.\n *\n * @name PRECISION\n * @memberof PIXI\n * @constant\n * @static\n * @enum {string}\n * @property {string} LOW='lowp'\n * @property {string} MEDIUM='mediump'\n * @property {string} HIGH='highp'\n */\nvar PRECISION;\n(function (PRECISION) {\n    PRECISION[\"LOW\"] = \"lowp\";\n    PRECISION[\"MEDIUM\"] = \"mediump\";\n    PRECISION[\"HIGH\"] = \"highp\";\n})(PRECISION || (PRECISION = {}));\n/**\n * Constants for mask implementations.\n * We use `type` suffix because it leads to very different behaviours\n *\n * @name MASK_TYPES\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NONE - Mask is ignored\n * @property {number} SCISSOR - Scissor mask, rectangle on screen, cheap\n * @property {number} STENCIL - Stencil mask, 1-bit, medium, works only if renderer supports stencil\n * @property {number} SPRITE - Mask that uses SpriteMaskFilter, uses temporary RenderTexture\n */\nvar MASK_TYPES;\n(function (MASK_TYPES) {\n    MASK_TYPES[MASK_TYPES[\"NONE\"] = 0] = \"NONE\";\n    MASK_TYPES[MASK_TYPES[\"SCISSOR\"] = 1] = \"SCISSOR\";\n    MASK_TYPES[MASK_TYPES[\"STENCIL\"] = 2] = \"STENCIL\";\n    MASK_TYPES[MASK_TYPES[\"SPRITE\"] = 3] = \"SPRITE\";\n})(MASK_TYPES || (MASK_TYPES = {}));\n/**\n * Constants for multi-sampling antialiasing.\n *\n * @see PIXI.Framebuffer#multisample\n *\n * @name MSAA_QUALITY\n * @memberof PIXI\n * @static\n * @enum {number}\n * @property {number} NONE - No multisampling for this renderTexture\n * @property {number} LOW - Try 2 samples\n * @property {number} MEDIUM - Try 4 samples\n * @property {number} HIGH - Try 8 samples\n */\nvar MSAA_QUALITY;\n(function (MSAA_QUALITY) {\n    MSAA_QUALITY[MSAA_QUALITY[\"NONE\"] = 0] = \"NONE\";\n    MSAA_QUALITY[MSAA_QUALITY[\"LOW\"] = 2] = \"LOW\";\n    MSAA_QUALITY[MSAA_QUALITY[\"MEDIUM\"] = 4] = \"MEDIUM\";\n    MSAA_QUALITY[MSAA_QUALITY[\"HIGH\"] = 8] = \"HIGH\";\n})(MSAA_QUALITY || (MSAA_QUALITY = {}));\n\n/**\n * The BlurFilterPass applies a horizontal or vertical Gaussian blur to an object.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar BlurFilterPass = /** @class */ (function (_super) {\n    __extends(BlurFilterPass, _super);\n    /**\n     * @param {boolean} horizontal - Do pass along the x-axis (`true`) or y-axis (`false`).\n     * @param {number} [strength=8] - The strength of the blur filter.\n     * @param {number} [quality=4] - The quality of the blur filter.\n     * @param {number} [resolution=PIXI.settings.FILTER_RESOLUTION] - The resolution of the blur filter.\n     * @param {number} [kernelSize=5] - The kernelSize of the blur filter.Options: 5, 7, 9, 11, 13, 15.\n     */\n    function BlurFilterPass(horizontal, strength, quality, resolution, kernelSize) {\n        if (strength === void 0) { strength = 8; }\n        if (quality === void 0) { quality = 4; }\n        if (resolution === void 0) { resolution = _pixi_settings__WEBPACK_IMPORTED_MODULE_1__.settings.FILTER_RESOLUTION; }\n        if (kernelSize === void 0) { kernelSize = 5; }\n        var _this = this;\n        var vertSrc = generateBlurVertSource(kernelSize, horizontal);\n        var fragSrc = generateBlurFragSource(kernelSize);\n        _this = _super.call(this, \n        // vertex shader\n        vertSrc, \n        // fragment shader\n        fragSrc) || this;\n        _this.horizontal = horizontal;\n        _this.resolution = resolution;\n        _this._quality = 0;\n        _this.quality = quality;\n        _this.blur = strength;\n        return _this;\n    }\n    /**\n     * Applies the filter.\n     *\n     * @param {PIXI.systems.FilterSystem} filterManager - The manager.\n     * @param {PIXI.RenderTexture} input - The input target.\n     * @param {PIXI.RenderTexture} output - The output target.\n     * @param {PIXI.CLEAR_MODES} clearMode - How to clear\n     */\n    BlurFilterPass.prototype.apply = function (filterManager, input, output, clearMode) {\n        if (output) {\n            if (this.horizontal) {\n                this.uniforms.strength = (1 / output.width) * (output.width / input.width);\n            }\n            else {\n                this.uniforms.strength = (1 / output.height) * (output.height / input.height);\n            }\n        }\n        else {\n            if (this.horizontal) // eslint-disable-line\n             {\n                this.uniforms.strength = (1 / filterManager.renderer.width) * (filterManager.renderer.width / input.width);\n            }\n            else {\n                this.uniforms.strength = (1 / filterManager.renderer.height) * (filterManager.renderer.height / input.height); // eslint-disable-line\n            }\n        }\n        // screen space!\n        this.uniforms.strength *= this.strength;\n        this.uniforms.strength /= this.passes;\n        if (this.passes === 1) {\n            filterManager.applyFilter(this, input, output, clearMode);\n        }\n        else {\n            var renderTarget = filterManager.getFilterTexture();\n            var renderer = filterManager.renderer;\n            var flip = input;\n            var flop = renderTarget;\n            this.state.blend = false;\n            filterManager.applyFilter(this, flip, flop, CLEAR_MODES.CLEAR);\n            for (var i = 1; i < this.passes - 1; i++) {\n                filterManager.bindAndClear(flip, CLEAR_MODES.BLIT);\n                this.uniforms.uSampler = flop;\n                var temp = flop;\n                flop = flip;\n                flip = temp;\n                renderer.shader.bind(this);\n                renderer.geometry.draw(5);\n            }\n            this.state.blend = true;\n            filterManager.applyFilter(this, flop, output, clearMode);\n            filterManager.returnFilterTexture(renderTarget);\n        }\n    };\n    Object.defineProperty(BlurFilterPass.prototype, \"blur\", {\n        /**\n         * Sets the strength of both the blur.\n         *\n         * @member {number}\n         * @default 16\n         */\n        get: function () {\n            return this.strength;\n        },\n        set: function (value) {\n            this.padding = 1 + (Math.abs(value) * 2);\n            this.strength = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilterPass.prototype, \"quality\", {\n        /**\n         * Sets the quality of the blur by modifying the number of passes. More passes means higher\n         * quaility bluring but the lower the performance.\n         *\n         * @member {number}\n         * @default 4\n         */\n        get: function () {\n            return this._quality;\n        },\n        set: function (value) {\n            this._quality = value;\n            this.passes = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return BlurFilterPass;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n/**\n * The BlurFilter applies a Gaussian blur to an object.\n *\n * The strength of the blur can be set for the x-axis and y-axis separately.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar BlurFilter = /** @class */ (function (_super) {\n    __extends(BlurFilter, _super);\n    /**\n     * @param {number} [strength=8] - The strength of the blur filter.\n     * @param {number} [quality=4] - The quality of the blur filter.\n     * @param {number} [resolution=PIXI.settings.FILTER_RESOLUTION] - The resolution of the blur filter.\n     * @param {number} [kernelSize=5] - The kernelSize of the blur filter.Options: 5, 7, 9, 11, 13, 15.\n     */\n    function BlurFilter(strength, quality, resolution, kernelSize) {\n        if (strength === void 0) { strength = 8; }\n        if (quality === void 0) { quality = 4; }\n        if (resolution === void 0) { resolution = _pixi_settings__WEBPACK_IMPORTED_MODULE_1__.settings.FILTER_RESOLUTION; }\n        if (kernelSize === void 0) { kernelSize = 5; }\n        var _this = _super.call(this) || this;\n        _this.blurXFilter = new BlurFilterPass(true, strength, quality, resolution, kernelSize);\n        _this.blurYFilter = new BlurFilterPass(false, strength, quality, resolution, kernelSize);\n        _this.resolution = resolution;\n        _this.quality = quality;\n        _this.blur = strength;\n        _this.repeatEdgePixels = false;\n        return _this;\n    }\n    /**\n     * Applies the filter.\n     *\n     * @param {PIXI.systems.FilterSystem} filterManager - The manager.\n     * @param {PIXI.RenderTexture} input - The input target.\n     * @param {PIXI.RenderTexture} output - The output target.\n     * @param {PIXI.CLEAR_MODES} clearMode - How to clear\n     */\n    BlurFilter.prototype.apply = function (filterManager, input, output, clearMode) {\n        var xStrength = Math.abs(this.blurXFilter.strength);\n        var yStrength = Math.abs(this.blurYFilter.strength);\n        if (xStrength && yStrength) {\n            var renderTarget = filterManager.getFilterTexture();\n            this.blurXFilter.apply(filterManager, input, renderTarget, CLEAR_MODES.CLEAR);\n            this.blurYFilter.apply(filterManager, renderTarget, output, clearMode);\n            filterManager.returnFilterTexture(renderTarget);\n        }\n        else if (yStrength) {\n            this.blurYFilter.apply(filterManager, input, output, clearMode);\n        }\n        else {\n            this.blurXFilter.apply(filterManager, input, output, clearMode);\n        }\n    };\n    BlurFilter.prototype.updatePadding = function () {\n        if (this._repeatEdgePixels) {\n            this.padding = 0;\n        }\n        else {\n            this.padding = Math.max(Math.abs(this.blurXFilter.strength), Math.abs(this.blurYFilter.strength)) * 2;\n        }\n    };\n    Object.defineProperty(BlurFilter.prototype, \"blur\", {\n        /**\n         * Sets the strength of both the blurX and blurY properties simultaneously\n         *\n         * @member {number}\n         * @default 2\n         */\n        get: function () {\n            return this.blurXFilter.blur;\n        },\n        set: function (value) {\n            this.blurXFilter.blur = this.blurYFilter.blur = value;\n            this.updatePadding();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilter.prototype, \"quality\", {\n        /**\n         * Sets the number of passes for blur. More passes means higher quaility bluring.\n         *\n         * @member {number}\n         * @default 1\n         */\n        get: function () {\n            return this.blurXFilter.quality;\n        },\n        set: function (value) {\n            this.blurXFilter.quality = this.blurYFilter.quality = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilter.prototype, \"blurX\", {\n        /**\n         * Sets the strength of the blurX property\n         *\n         * @member {number}\n         * @default 2\n         */\n        get: function () {\n            return this.blurXFilter.blur;\n        },\n        set: function (value) {\n            this.blurXFilter.blur = value;\n            this.updatePadding();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilter.prototype, \"blurY\", {\n        /**\n         * Sets the strength of the blurY property\n         *\n         * @member {number}\n         * @default 2\n         */\n        get: function () {\n            return this.blurYFilter.blur;\n        },\n        set: function (value) {\n            this.blurYFilter.blur = value;\n            this.updatePadding();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilter.prototype, \"blendMode\", {\n        /**\n         * Sets the blendmode of the filter\n         *\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NORMAL\n         */\n        get: function () {\n            return this.blurYFilter.blendMode;\n        },\n        set: function (value) {\n            this.blurYFilter.blendMode = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(BlurFilter.prototype, \"repeatEdgePixels\", {\n        /**\n         * If set to true the edge of the target will be clamped\n         *\n         * @member {boolean}\n         * @default false\n         */\n        get: function () {\n            return this._repeatEdgePixels;\n        },\n        set: function (value) {\n            this._repeatEdgePixels = value;\n            this.updatePadding();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return BlurFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n\n//# sourceMappingURL=filter-blur.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-blur/lib/filter-blur.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-color-matrix/lib/filter-color-matrix.es.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@pixi/filter-color-matrix/lib/filter-color-matrix.es.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ColorMatrixFilter\": () => (/* binding */ ColorMatrixFilter)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/filter-color-matrix - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-color-matrix is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar fragment = \"varying vec2 vTextureCoord;\\nuniform sampler2D uSampler;\\nuniform float m[20];\\nuniform float uAlpha;\\n\\nvoid main(void)\\n{\\n    vec4 c = texture2D(uSampler, vTextureCoord);\\n\\n    if (uAlpha == 0.0) {\\n        gl_FragColor = c;\\n        return;\\n    }\\n\\n    // Un-premultiply alpha before applying the color matrix. See issue #3539.\\n    if (c.a > 0.0) {\\n      c.rgb /= c.a;\\n    }\\n\\n    vec4 result;\\n\\n    result.r = (m[0] * c.r);\\n        result.r += (m[1] * c.g);\\n        result.r += (m[2] * c.b);\\n        result.r += (m[3] * c.a);\\n        result.r += m[4];\\n\\n    result.g = (m[5] * c.r);\\n        result.g += (m[6] * c.g);\\n        result.g += (m[7] * c.b);\\n        result.g += (m[8] * c.a);\\n        result.g += m[9];\\n\\n    result.b = (m[10] * c.r);\\n       result.b += (m[11] * c.g);\\n       result.b += (m[12] * c.b);\\n       result.b += (m[13] * c.a);\\n       result.b += m[14];\\n\\n    result.a = (m[15] * c.r);\\n       result.a += (m[16] * c.g);\\n       result.a += (m[17] * c.b);\\n       result.a += (m[18] * c.a);\\n       result.a += m[19];\\n\\n    vec3 rgb = mix(c.rgb, result.rgb, uAlpha);\\n\\n    // Premultiply alpha again.\\n    rgb *= result.a;\\n\\n    gl_FragColor = vec4(rgb, result.a);\\n}\\n\";\n\n/**\n * The ColorMatrixFilter class lets you apply a 5x4 matrix transformation on the RGBA\n * color and alpha values of every pixel on your displayObject to produce a result\n * with a new set of RGBA color and alpha values. It's pretty powerful!\n *\n * ```js\n *  let colorMatrix = new PIXI.filters.ColorMatrixFilter();\n *  container.filters = [colorMatrix];\n *  colorMatrix.contrast(2);\n * ```\n * @author Clément Chenebault <clement@goodboydigital.com>\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar ColorMatrixFilter = /** @class */ (function (_super) {\n    __extends(ColorMatrixFilter, _super);\n    function ColorMatrixFilter() {\n        var _this = this;\n        var uniforms = {\n            m: new Float32Array([1, 0, 0, 0, 0,\n                0, 1, 0, 0, 0,\n                0, 0, 1, 0, 0,\n                0, 0, 0, 1, 0]),\n            uAlpha: 1,\n        };\n        _this = _super.call(this, _pixi_core__WEBPACK_IMPORTED_MODULE_0__.defaultFilterVertex, fragment, uniforms) || this;\n        _this.alpha = 1;\n        return _this;\n    }\n    /**\n     * Transforms current matrix and set the new one\n     *\n     * @param {number[]} matrix - 5x4 matrix\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype._loadMatrix = function (matrix, multiply) {\n        if (multiply === void 0) { multiply = false; }\n        var newMatrix = matrix;\n        if (multiply) {\n            this._multiply(newMatrix, this.uniforms.m, matrix);\n            newMatrix = this._colorMatrix(newMatrix);\n        }\n        // set the new matrix\n        this.uniforms.m = newMatrix;\n    };\n    /**\n     * Multiplies two mat5's\n     *\n     * @private\n     * @param {number[]} out - 5x4 matrix the receiving matrix\n     * @param {number[]} a - 5x4 matrix the first operand\n     * @param {number[]} b - 5x4 matrix the second operand\n     * @returns {number[]} 5x4 matrix\n     */\n    ColorMatrixFilter.prototype._multiply = function (out, a, b) {\n        // Red Channel\n        out[0] = (a[0] * b[0]) + (a[1] * b[5]) + (a[2] * b[10]) + (a[3] * b[15]);\n        out[1] = (a[0] * b[1]) + (a[1] * b[6]) + (a[2] * b[11]) + (a[3] * b[16]);\n        out[2] = (a[0] * b[2]) + (a[1] * b[7]) + (a[2] * b[12]) + (a[3] * b[17]);\n        out[3] = (a[0] * b[3]) + (a[1] * b[8]) + (a[2] * b[13]) + (a[3] * b[18]);\n        out[4] = (a[0] * b[4]) + (a[1] * b[9]) + (a[2] * b[14]) + (a[3] * b[19]) + a[4];\n        // Green Channel\n        out[5] = (a[5] * b[0]) + (a[6] * b[5]) + (a[7] * b[10]) + (a[8] * b[15]);\n        out[6] = (a[5] * b[1]) + (a[6] * b[6]) + (a[7] * b[11]) + (a[8] * b[16]);\n        out[7] = (a[5] * b[2]) + (a[6] * b[7]) + (a[7] * b[12]) + (a[8] * b[17]);\n        out[8] = (a[5] * b[3]) + (a[6] * b[8]) + (a[7] * b[13]) + (a[8] * b[18]);\n        out[9] = (a[5] * b[4]) + (a[6] * b[9]) + (a[7] * b[14]) + (a[8] * b[19]) + a[9];\n        // Blue Channel\n        out[10] = (a[10] * b[0]) + (a[11] * b[5]) + (a[12] * b[10]) + (a[13] * b[15]);\n        out[11] = (a[10] * b[1]) + (a[11] * b[6]) + (a[12] * b[11]) + (a[13] * b[16]);\n        out[12] = (a[10] * b[2]) + (a[11] * b[7]) + (a[12] * b[12]) + (a[13] * b[17]);\n        out[13] = (a[10] * b[3]) + (a[11] * b[8]) + (a[12] * b[13]) + (a[13] * b[18]);\n        out[14] = (a[10] * b[4]) + (a[11] * b[9]) + (a[12] * b[14]) + (a[13] * b[19]) + a[14];\n        // Alpha Channel\n        out[15] = (a[15] * b[0]) + (a[16] * b[5]) + (a[17] * b[10]) + (a[18] * b[15]);\n        out[16] = (a[15] * b[1]) + (a[16] * b[6]) + (a[17] * b[11]) + (a[18] * b[16]);\n        out[17] = (a[15] * b[2]) + (a[16] * b[7]) + (a[17] * b[12]) + (a[18] * b[17]);\n        out[18] = (a[15] * b[3]) + (a[16] * b[8]) + (a[17] * b[13]) + (a[18] * b[18]);\n        out[19] = (a[15] * b[4]) + (a[16] * b[9]) + (a[17] * b[14]) + (a[18] * b[19]) + a[19];\n        return out;\n    };\n    /**\n     * Create a Float32 Array and normalize the offset component to 0-1\n     *\n     * @private\n     * @param {number[]} matrix - 5x4 matrix\n     * @return {number[]} 5x4 matrix with all values between 0-1\n     */\n    ColorMatrixFilter.prototype._colorMatrix = function (matrix) {\n        // Create a Float32 Array and normalize the offset component to 0-1\n        var m = new Float32Array(matrix);\n        m[4] /= 255;\n        m[9] /= 255;\n        m[14] /= 255;\n        m[19] /= 255;\n        return m;\n    };\n    /**\n     * Adjusts brightness\n     *\n     * @param {number} b - value of the brigthness (0-1, where 0 is black)\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.brightness = function (b, multiply) {\n        var matrix = [\n            b, 0, 0, 0, 0,\n            0, b, 0, 0, 0,\n            0, 0, b, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Set the matrices in grey scales\n     *\n     * @param {number} scale - value of the grey (0-1, where 0 is black)\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.greyscale = function (scale, multiply) {\n        var matrix = [\n            scale, scale, scale, 0, 0,\n            scale, scale, scale, 0, 0,\n            scale, scale, scale, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Set the black and white matrice.\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.blackAndWhite = function (multiply) {\n        var matrix = [\n            0.3, 0.6, 0.1, 0, 0,\n            0.3, 0.6, 0.1, 0, 0,\n            0.3, 0.6, 0.1, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Set the hue property of the color\n     *\n     * @param {number} rotation - in degrees\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.hue = function (rotation, multiply) {\n        rotation = (rotation || 0) / 180 * Math.PI;\n        var cosR = Math.cos(rotation);\n        var sinR = Math.sin(rotation);\n        var sqrt = Math.sqrt;\n        /* a good approximation for hue rotation\n         This matrix is far better than the versions with magic luminance constants\n         formerly used here, but also used in the starling framework (flash) and known from this\n         old part of the internet: quasimondo.com/archives/000565.php\n\n         This new matrix is based on rgb cube rotation in space. Look here for a more descriptive\n         implementation as a shader not a general matrix:\n         https://github.com/evanw/glfx.js/blob/58841c23919bd59787effc0333a4897b43835412/src/filters/adjust/huesaturation.js\n\n         This is the source for the code:\n         see http://stackoverflow.com/questions/8507885/shift-hue-of-an-rgb-color/8510751#8510751\n         */\n        var w = 1 / 3;\n        var sqrW = sqrt(w); // weight is\n        var a00 = cosR + ((1.0 - cosR) * w);\n        var a01 = (w * (1.0 - cosR)) - (sqrW * sinR);\n        var a02 = (w * (1.0 - cosR)) + (sqrW * sinR);\n        var a10 = (w * (1.0 - cosR)) + (sqrW * sinR);\n        var a11 = cosR + (w * (1.0 - cosR));\n        var a12 = (w * (1.0 - cosR)) - (sqrW * sinR);\n        var a20 = (w * (1.0 - cosR)) - (sqrW * sinR);\n        var a21 = (w * (1.0 - cosR)) + (sqrW * sinR);\n        var a22 = cosR + (w * (1.0 - cosR));\n        var matrix = [\n            a00, a01, a02, 0, 0,\n            a10, a11, a12, 0, 0,\n            a20, a21, a22, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Set the contrast matrix, increase the separation between dark and bright\n     * Increase contrast : shadows darker and highlights brighter\n     * Decrease contrast : bring the shadows up and the highlights down\n     *\n     * @param {number} amount - value of the contrast (0-1)\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.contrast = function (amount, multiply) {\n        var v = (amount || 0) + 1;\n        var o = -0.5 * (v - 1);\n        var matrix = [\n            v, 0, 0, 0, o,\n            0, v, 0, 0, o,\n            0, 0, v, 0, o,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Set the saturation matrix, increase the separation between colors\n     * Increase saturation : increase contrast, brightness, and sharpness\n     *\n     * @param {number} amount - The saturation amount (0-1)\n     * @param {boolean} [multiply] - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.saturate = function (amount, multiply) {\n        if (amount === void 0) { amount = 0; }\n        var x = (amount * 2 / 3) + 1;\n        var y = ((x - 1) * -0.5);\n        var matrix = [\n            x, y, y, 0, 0,\n            y, x, y, 0, 0,\n            y, y, x, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Desaturate image (remove color)\n     *\n     * Call the saturate function\n     *\n     */\n    ColorMatrixFilter.prototype.desaturate = function () {\n        this.saturate(-1);\n    };\n    /**\n     * Negative image (inverse of classic rgb matrix)\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.negative = function (multiply) {\n        var matrix = [\n            -1, 0, 0, 1, 0,\n            0, -1, 0, 1, 0,\n            0, 0, -1, 1, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Sepia image\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.sepia = function (multiply) {\n        var matrix = [\n            0.393, 0.7689999, 0.18899999, 0, 0,\n            0.349, 0.6859999, 0.16799999, 0, 0,\n            0.272, 0.5339999, 0.13099999, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Color motion picture process invented in 1916 (thanks Dominic Szablewski)\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.technicolor = function (multiply) {\n        var matrix = [\n            1.9125277891456083, -0.8545344976951645, -0.09155508482755585, 0, 11.793603434377337,\n            -0.3087833385928097, 1.7658908555458428, -0.10601743074722245, 0, -70.35205161461398,\n            -0.231103377548616, -0.7501899197440212, 1.847597816108189, 0, 30.950940869491138,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Polaroid filter\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.polaroid = function (multiply) {\n        var matrix = [\n            1.438, -0.062, -0.062, 0, 0,\n            -0.122, 1.378, -0.122, 0, 0,\n            -0.016, -0.016, 1.483, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Filter who transforms : Red -> Blue and Blue -> Red\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.toBGR = function (multiply) {\n        var matrix = [\n            0, 0, 1, 0, 0,\n            0, 1, 0, 0, 0,\n            1, 0, 0, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Color reversal film introduced by Eastman Kodak in 1935. (thanks Dominic Szablewski)\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.kodachrome = function (multiply) {\n        var matrix = [\n            1.1285582396593525, -0.3967382283601348, -0.03992559172921793, 0, 63.72958762196502,\n            -0.16404339962244616, 1.0835251566291304, -0.05498805115633132, 0, 24.732407896706203,\n            -0.16786010706155763, -0.5603416277695248, 1.6014850761964943, 0, 35.62982807460946,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Brown delicious browni filter (thanks Dominic Szablewski)\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.browni = function (multiply) {\n        var matrix = [\n            0.5997023498159715, 0.34553243048391263, -0.2708298674538042, 0, 47.43192855600873,\n            -0.037703249837783157, 0.8609577587992641, 0.15059552388459913, 0, -36.96841498319127,\n            0.24113635128153335, -0.07441037908422492, 0.44972182064877153, 0, -7.562075277591283,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Vintage filter (thanks Dominic Szablewski)\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.vintage = function (multiply) {\n        var matrix = [\n            0.6279345635605994, 0.3202183420819367, -0.03965408211312453, 0, 9.651285835294123,\n            0.02578397704808868, 0.6441188644374771, 0.03259127616149294, 0, 7.462829176470591,\n            0.0466055556782719, -0.0851232987247891, 0.5241648018700465, 0, 5.159190588235296,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * We don't know exactly what it does, kind of gradient map, but funny to play with!\n     *\n     * @param {number} desaturation - Tone values.\n     * @param {number} toned - Tone values.\n     * @param {number} lightColor - Tone values, example: `0xFFE580`\n     * @param {number} darkColor - Tone values, example: `0xFFE580`\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.colorTone = function (desaturation, toned, lightColor, darkColor, multiply) {\n        desaturation = desaturation || 0.2;\n        toned = toned || 0.15;\n        lightColor = lightColor || 0xFFE580;\n        darkColor = darkColor || 0x338000;\n        var lR = ((lightColor >> 16) & 0xFF) / 255;\n        var lG = ((lightColor >> 8) & 0xFF) / 255;\n        var lB = (lightColor & 0xFF) / 255;\n        var dR = ((darkColor >> 16) & 0xFF) / 255;\n        var dG = ((darkColor >> 8) & 0xFF) / 255;\n        var dB = (darkColor & 0xFF) / 255;\n        var matrix = [\n            0.3, 0.59, 0.11, 0, 0,\n            lR, lG, lB, desaturation, 0,\n            dR, dG, dB, toned, 0,\n            lR - dR, lG - dG, lB - dB, 0, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Night effect\n     *\n     * @param {number} intensity - The intensity of the night effect.\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.night = function (intensity, multiply) {\n        intensity = intensity || 0.1;\n        var matrix = [\n            intensity * (-2.0), -intensity, 0, 0, 0,\n            -intensity, 0, intensity, 0, 0,\n            0, intensity, intensity * 2.0, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Predator effect\n     *\n     * Erase the current matrix by setting a new indepent one\n     *\n     * @param {number} amount - how much the predator feels his future victim\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.predator = function (amount, multiply) {\n        var matrix = [\n            // row 1\n            11.224130630493164 * amount,\n            -4.794486999511719 * amount,\n            -2.8746118545532227 * amount,\n            0 * amount,\n            0.40342438220977783 * amount,\n            // row 2\n            -3.6330697536468506 * amount,\n            9.193157196044922 * amount,\n            -2.951810836791992 * amount,\n            0 * amount,\n            -1.316135048866272 * amount,\n            // row 3\n            -3.2184197902679443 * amount,\n            -4.2375030517578125 * amount,\n            7.476448059082031 * amount,\n            0 * amount,\n            0.8044459223747253 * amount,\n            // row 4\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * LSD effect\n     *\n     * Multiply the current matrix\n     *\n     * @param {boolean} multiply - if true, current matrix and matrix are multiplied. If false,\n     *  just set the current matrix with @param matrix\n     */\n    ColorMatrixFilter.prototype.lsd = function (multiply) {\n        var matrix = [\n            2, -0.4, 0.5, 0, 0,\n            -0.5, 2, -0.4, 0, 0,\n            -0.4, -0.5, 3, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, multiply);\n    };\n    /**\n     * Erase the current matrix by setting the default one\n     *\n     */\n    ColorMatrixFilter.prototype.reset = function () {\n        var matrix = [\n            1, 0, 0, 0, 0,\n            0, 1, 0, 0, 0,\n            0, 0, 1, 0, 0,\n            0, 0, 0, 1, 0 ];\n        this._loadMatrix(matrix, false);\n    };\n    Object.defineProperty(ColorMatrixFilter.prototype, \"matrix\", {\n        /**\n         * The matrix of the color matrix filter\n         *\n         * @member {number[]}\n         * @default [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0]\n         */\n        get: function () {\n            return this.uniforms.m;\n        },\n        set: function (value) {\n            this.uniforms.m = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ColorMatrixFilter.prototype, \"alpha\", {\n        /**\n         * The opacity value to use when mixing the original and resultant colors.\n         *\n         * When the value is 0, the original color is used without modification.\n         * When the value is 1, the result color is used.\n         * When in the range (0, 1) the color is interpolated between the original and result by this amount.\n         *\n         * @member {number}\n         * @default 1\n         */\n        get: function () {\n            return this.uniforms.uAlpha;\n        },\n        set: function (value) {\n            this.uniforms.uAlpha = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return ColorMatrixFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n// Americanized alias\nColorMatrixFilter.prototype.grayscale = ColorMatrixFilter.prototype.greyscale;\n\n\n//# sourceMappingURL=filter-color-matrix.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-color-matrix/lib/filter-color-matrix.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-displacement/lib/filter-displacement.es.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@pixi/filter-displacement/lib/filter-displacement.es.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DisplacementFilter\": () => (/* binding */ DisplacementFilter)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/*!\n * @pixi/filter-displacement - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-displacement is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar fragment = \"varying vec2 vFilterCoord;\\nvarying vec2 vTextureCoord;\\n\\nuniform vec2 scale;\\nuniform mat2 rotation;\\nuniform sampler2D uSampler;\\nuniform sampler2D mapSampler;\\n\\nuniform highp vec4 inputSize;\\nuniform vec4 inputClamp;\\n\\nvoid main(void)\\n{\\n  vec4 map =  texture2D(mapSampler, vFilterCoord);\\n\\n  map -= 0.5;\\n  map.xy = scale * inputSize.zw * (rotation * map.xy);\\n\\n  gl_FragColor = texture2D(uSampler, clamp(vec2(vTextureCoord.x + map.x, vTextureCoord.y + map.y), inputClamp.xy, inputClamp.zw));\\n}\\n\";\n\nvar vertex = \"attribute vec2 aVertexPosition;\\n\\nuniform mat3 projectionMatrix;\\nuniform mat3 filterMatrix;\\n\\nvarying vec2 vTextureCoord;\\nvarying vec2 vFilterCoord;\\n\\nuniform vec4 inputSize;\\nuniform vec4 outputFrame;\\n\\nvec4 filterVertexPosition( void )\\n{\\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\\n\\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\\n}\\n\\nvec2 filterTextureCoord( void )\\n{\\n    return aVertexPosition * (outputFrame.zw * inputSize.zw);\\n}\\n\\nvoid main(void)\\n{\\n\\tgl_Position = filterVertexPosition();\\n\\tvTextureCoord = filterTextureCoord();\\n\\tvFilterCoord = ( filterMatrix * vec3( vTextureCoord, 1.0)  ).xy;\\n}\\n\";\n\n/**\n * The DisplacementFilter class uses the pixel values from the specified texture\n * (called the displacement map) to perform a displacement of an object.\n *\n * You can use this filter to apply all manor of crazy warping effects.\n * Currently the `r` property of the texture is used to offset the `x`\n * and the `g` property of the texture is used to offset the `y`.\n *\n * The way it works is it uses the values of the displacement map to look up the\n * correct pixels to output. This means it's not technically moving the original.\n * Instead, it's starting at the output and asking \"which pixel from the original goes here\".\n * For example, if a displacement map pixel has `red = 1` and the filter scale is `20`,\n * this filter will output the pixel approximately 20 pixels to the right of the original.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar DisplacementFilter = /** @class */ (function (_super) {\n    __extends(DisplacementFilter, _super);\n    /**\n     * @param {PIXI.Sprite} sprite - The sprite used for the displacement map. (make sure its added to the scene!)\n     * @param {number} [scale] - The scale of the displacement\n     */\n    function DisplacementFilter(sprite, scale) {\n        var _this = this;\n        var maskMatrix = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Matrix();\n        sprite.renderable = false;\n        _this = _super.call(this, vertex, fragment, {\n            mapSampler: sprite._texture,\n            filterMatrix: maskMatrix,\n            scale: { x: 1, y: 1 },\n            rotation: new Float32Array([1, 0, 0, 1]),\n        }) || this;\n        _this.maskSprite = sprite;\n        _this.maskMatrix = maskMatrix;\n        if (scale === null || scale === undefined) {\n            scale = 20;\n        }\n        /**\n         * scaleX, scaleY for displacements\n         * @member {PIXI.Point}\n         */\n        _this.scale = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point(scale, scale);\n        return _this;\n    }\n    /**\n     * Applies the filter.\n     *\n     * @param {PIXI.systems.FilterSystem} filterManager - The manager.\n     * @param {PIXI.RenderTexture} input - The input target.\n     * @param {PIXI.RenderTexture} output - The output target.\n     * @param {PIXI.CLEAR_MODES} clearMode - clearMode.\n     */\n    DisplacementFilter.prototype.apply = function (filterManager, input, output, clearMode) {\n        // fill maskMatrix with _normalized sprite texture coords_\n        this.uniforms.filterMatrix = filterManager.calculateSpriteMatrix(this.maskMatrix, this.maskSprite);\n        this.uniforms.scale.x = this.scale.x;\n        this.uniforms.scale.y = this.scale.y;\n        // Extract rotation from world transform\n        var wt = this.maskSprite.worldTransform;\n        var lenX = Math.sqrt((wt.a * wt.a) + (wt.b * wt.b));\n        var lenY = Math.sqrt((wt.c * wt.c) + (wt.d * wt.d));\n        if (lenX !== 0 && lenY !== 0) {\n            this.uniforms.rotation[0] = wt.a / lenX;\n            this.uniforms.rotation[1] = wt.b / lenX;\n            this.uniforms.rotation[2] = wt.c / lenY;\n            this.uniforms.rotation[3] = wt.d / lenY;\n        }\n        // draw the filter...\n        filterManager.applyFilter(this, input, output, clearMode);\n    };\n    Object.defineProperty(DisplacementFilter.prototype, \"map\", {\n        /**\n         * The texture used for the displacement map. Must be power of 2 sized texture.\n         *\n         * @member {PIXI.Texture}\n         */\n        get: function () {\n            return this.uniforms.mapSampler;\n        },\n        set: function (value) {\n            this.uniforms.mapSampler = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return DisplacementFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n\n//# sourceMappingURL=filter-displacement.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-displacement/lib/filter-displacement.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-fxaa/lib/filter-fxaa.es.js":
/*!**************************************************************!*\
  !*** ./node_modules/@pixi/filter-fxaa/lib/filter-fxaa.es.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FXAAFilter\": () => (/* binding */ FXAAFilter)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/filter-fxaa - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-fxaa is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar vertex = \"\\nattribute vec2 aVertexPosition;\\n\\nuniform mat3 projectionMatrix;\\n\\nvarying vec2 v_rgbNW;\\nvarying vec2 v_rgbNE;\\nvarying vec2 v_rgbSW;\\nvarying vec2 v_rgbSE;\\nvarying vec2 v_rgbM;\\n\\nvarying vec2 vFragCoord;\\n\\nuniform vec4 inputPixel;\\nuniform vec4 outputFrame;\\n\\nvec4 filterVertexPosition( void )\\n{\\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\\n\\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\\n}\\n\\nvoid texcoords(vec2 fragCoord, vec2 inverseVP,\\n               out vec2 v_rgbNW, out vec2 v_rgbNE,\\n               out vec2 v_rgbSW, out vec2 v_rgbSE,\\n               out vec2 v_rgbM) {\\n    v_rgbNW = (fragCoord + vec2(-1.0, -1.0)) * inverseVP;\\n    v_rgbNE = (fragCoord + vec2(1.0, -1.0)) * inverseVP;\\n    v_rgbSW = (fragCoord + vec2(-1.0, 1.0)) * inverseVP;\\n    v_rgbSE = (fragCoord + vec2(1.0, 1.0)) * inverseVP;\\n    v_rgbM = vec2(fragCoord * inverseVP);\\n}\\n\\nvoid main(void) {\\n\\n   gl_Position = filterVertexPosition();\\n\\n   vFragCoord = aVertexPosition * outputFrame.zw;\\n\\n   texcoords(vFragCoord, inputPixel.zw, v_rgbNW, v_rgbNE, v_rgbSW, v_rgbSE, v_rgbM);\\n}\\n\";\n\nvar fragment = \"varying vec2 v_rgbNW;\\nvarying vec2 v_rgbNE;\\nvarying vec2 v_rgbSW;\\nvarying vec2 v_rgbSE;\\nvarying vec2 v_rgbM;\\n\\nvarying vec2 vFragCoord;\\nuniform sampler2D uSampler;\\nuniform highp vec4 inputPixel;\\n\\n\\n/**\\n Basic FXAA implementation based on the code on geeks3d.com with the\\n modification that the texture2DLod stuff was removed since it's\\n unsupported by WebGL.\\n\\n --\\n\\n From:\\n https://github.com/mitsuhiko/webgl-meincraft\\n\\n Copyright (c) 2011 by Armin Ronacher.\\n\\n Some rights reserved.\\n\\n Redistribution and use in source and binary forms, with or without\\n modification, are permitted provided that the following conditions are\\n met:\\n\\n * Redistributions of source code must retain the above copyright\\n notice, this list of conditions and the following disclaimer.\\n\\n * Redistributions in binary form must reproduce the above\\n copyright notice, this list of conditions and the following\\n disclaimer in the documentation and/or other materials provided\\n with the distribution.\\n\\n * The names of the contributors may not be used to endorse or\\n promote products derived from this software without specific\\n prior written permission.\\n\\n THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\\n \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\\n LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\\n A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\\n OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\\n SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\\n LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\\n DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\\n THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\\n (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\\n OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\\n */\\n\\n#ifndef FXAA_REDUCE_MIN\\n#define FXAA_REDUCE_MIN   (1.0/ 128.0)\\n#endif\\n#ifndef FXAA_REDUCE_MUL\\n#define FXAA_REDUCE_MUL   (1.0 / 8.0)\\n#endif\\n#ifndef FXAA_SPAN_MAX\\n#define FXAA_SPAN_MAX     8.0\\n#endif\\n\\n//optimized version for mobile, where dependent\\n//texture reads can be a bottleneck\\nvec4 fxaa(sampler2D tex, vec2 fragCoord, vec2 inverseVP,\\n          vec2 v_rgbNW, vec2 v_rgbNE,\\n          vec2 v_rgbSW, vec2 v_rgbSE,\\n          vec2 v_rgbM) {\\n    vec4 color;\\n    vec3 rgbNW = texture2D(tex, v_rgbNW).xyz;\\n    vec3 rgbNE = texture2D(tex, v_rgbNE).xyz;\\n    vec3 rgbSW = texture2D(tex, v_rgbSW).xyz;\\n    vec3 rgbSE = texture2D(tex, v_rgbSE).xyz;\\n    vec4 texColor = texture2D(tex, v_rgbM);\\n    vec3 rgbM  = texColor.xyz;\\n    vec3 luma = vec3(0.299, 0.587, 0.114);\\n    float lumaNW = dot(rgbNW, luma);\\n    float lumaNE = dot(rgbNE, luma);\\n    float lumaSW = dot(rgbSW, luma);\\n    float lumaSE = dot(rgbSE, luma);\\n    float lumaM  = dot(rgbM,  luma);\\n    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));\\n    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));\\n\\n    mediump vec2 dir;\\n    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));\\n    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));\\n\\n    float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *\\n                          (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);\\n\\n    float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);\\n    dir = min(vec2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),\\n              max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),\\n                  dir * rcpDirMin)) * inverseVP;\\n\\n    vec3 rgbA = 0.5 * (\\n                       texture2D(tex, fragCoord * inverseVP + dir * (1.0 / 3.0 - 0.5)).xyz +\\n                       texture2D(tex, fragCoord * inverseVP + dir * (2.0 / 3.0 - 0.5)).xyz);\\n    vec3 rgbB = rgbA * 0.5 + 0.25 * (\\n                                     texture2D(tex, fragCoord * inverseVP + dir * -0.5).xyz +\\n                                     texture2D(tex, fragCoord * inverseVP + dir * 0.5).xyz);\\n\\n    float lumaB = dot(rgbB, luma);\\n    if ((lumaB < lumaMin) || (lumaB > lumaMax))\\n        color = vec4(rgbA, texColor.a);\\n    else\\n        color = vec4(rgbB, texColor.a);\\n    return color;\\n}\\n\\nvoid main() {\\n\\n      vec4 color;\\n\\n      color = fxaa(uSampler, vFragCoord, inputPixel.zw, v_rgbNW, v_rgbNE, v_rgbSW, v_rgbSE, v_rgbM);\\n\\n      gl_FragColor = color;\\n}\\n\";\n\n/**\n * Basic FXAA (Fast Approximate Anti-Aliasing) implementation based on the code on geeks3d.com\n * with the modification that the texture2DLod stuff was removed since it is unsupported by WebGL.\n *\n * @see https://github.com/mitsuhiko/webgl-meincraft\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n *\n */\nvar FXAAFilter = /** @class */ (function (_super) {\n    __extends(FXAAFilter, _super);\n    function FXAAFilter() {\n        // TODO - needs work\n        return _super.call(this, vertex, fragment) || this;\n    }\n    return FXAAFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n\n//# sourceMappingURL=filter-fxaa.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-fxaa/lib/filter-fxaa.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/filter-noise/lib/filter-noise.es.js":
/*!****************************************************************!*\
  !*** ./node_modules/@pixi/filter-noise/lib/filter-noise.es.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"NoiseFilter\": () => (/* binding */ NoiseFilter)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/filter-noise - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/filter-noise is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar fragment = \"precision highp float;\\n\\nvarying vec2 vTextureCoord;\\nvarying vec4 vColor;\\n\\nuniform float uNoise;\\nuniform float uSeed;\\nuniform sampler2D uSampler;\\n\\nfloat rand(vec2 co)\\n{\\n    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);\\n}\\n\\nvoid main()\\n{\\n    vec4 color = texture2D(uSampler, vTextureCoord);\\n    float randomValue = rand(gl_FragCoord.xy * uSeed);\\n    float diff = (randomValue - 0.5) * uNoise;\\n\\n    // Un-premultiply alpha before applying the color matrix. See issue #3539.\\n    if (color.a > 0.0) {\\n        color.rgb /= color.a;\\n    }\\n\\n    color.r += diff;\\n    color.g += diff;\\n    color.b += diff;\\n\\n    // Premultiply alpha again.\\n    color.rgb *= color.a;\\n\\n    gl_FragColor = color;\\n}\\n\";\n\n/**\n * @author Vico @vicocotea\n * original filter: https://github.com/evanw/glfx.js/blob/master/src/filters/adjust/noise.js\n */\n/**\n * A Noise effect filter.\n *\n * @class\n * @extends PIXI.Filter\n * @memberof PIXI.filters\n */\nvar NoiseFilter = /** @class */ (function (_super) {\n    __extends(NoiseFilter, _super);\n    /**\n     * @param {number} [noise=0.5] - The noise intensity, should be a normalized value in the range [0, 1].\n     * @param {number} [seed] - A random seed for the noise generation. Default is `Math.random()`.\n     */\n    function NoiseFilter(noise, seed) {\n        if (noise === void 0) { noise = 0.5; }\n        if (seed === void 0) { seed = Math.random(); }\n        var _this = _super.call(this, _pixi_core__WEBPACK_IMPORTED_MODULE_0__.defaultFilterVertex, fragment, {\n            uNoise: 0,\n            uSeed: 0,\n        }) || this;\n        _this.noise = noise;\n        _this.seed = seed;\n        return _this;\n    }\n    Object.defineProperty(NoiseFilter.prototype, \"noise\", {\n        /**\n         * The amount of noise to apply, this value should be in the range (0, 1].\n         *\n         * @member {number}\n         * @default 0.5\n         */\n        get: function () {\n            return this.uniforms.uNoise;\n        },\n        set: function (value) {\n            this.uniforms.uNoise = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NoiseFilter.prototype, \"seed\", {\n        /**\n         * A seed value to apply to the random noise generation. `Math.random()` is a good value to use.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.uniforms.uSeed;\n        },\n        set: function (value) {\n            this.uniforms.uSeed = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return NoiseFilter;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.Filter));\n\n\n//# sourceMappingURL=filter-noise.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/filter-noise/lib/filter-noise.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/graphics/lib/graphics.es.js":
/*!********************************************************!*\
  !*** ./node_modules/@pixi/graphics/lib/graphics.es.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FillStyle\": () => (/* binding */ FillStyle),\n/* harmony export */   \"GRAPHICS_CURVES\": () => (/* binding */ GRAPHICS_CURVES),\n/* harmony export */   \"Graphics\": () => (/* binding */ Graphics),\n/* harmony export */   \"GraphicsData\": () => (/* binding */ GraphicsData),\n/* harmony export */   \"GraphicsGeometry\": () => (/* binding */ GraphicsGeometry),\n/* harmony export */   \"LINE_CAP\": () => (/* binding */ LINE_CAP),\n/* harmony export */   \"LINE_JOIN\": () => (/* binding */ LINE_JOIN),\n/* harmony export */   \"LineStyle\": () => (/* binding */ LineStyle),\n/* harmony export */   \"graphicsUtils\": () => (/* binding */ index)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/* harmony import */ var _pixi_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @pixi/constants */ \"./node_modules/@pixi/constants/lib/constants.es.js\");\n/* harmony import */ var _pixi_display__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @pixi/display */ \"./node_modules/@pixi/display/lib/display.es.js\");\n/*!\n * @pixi/graphics - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/graphics is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n\n\n/**\n * Supported line joints in `PIXI.LineStyle` for graphics.\n *\n * @see PIXI.Graphics#lineStyle\n * @see https://graphicdesign.stackexchange.com/questions/59018/what-is-a-bevel-join-of-two-lines-exactly-illustrator\n *\n * @name LINE_JOIN\n * @memberof PIXI\n * @static\n * @enum {string}\n * @property {string} MITER - 'miter': make a sharp corner where outer part of lines meet\n * @property {string} BEVEL - 'bevel': add a square butt at each end of line segment and fill the triangle at turn\n * @property {string} ROUND - 'round': add an arc at the joint\n */\nvar LINE_JOIN;\n(function (LINE_JOIN) {\n    LINE_JOIN[\"MITER\"] = \"miter\";\n    LINE_JOIN[\"BEVEL\"] = \"bevel\";\n    LINE_JOIN[\"ROUND\"] = \"round\";\n})(LINE_JOIN || (LINE_JOIN = {}));\n/**\n * Support line caps in `PIXI.LineStyle` for graphics.\n *\n * @see PIXI.Graphics#lineStyle\n *\n * @name LINE_CAP\n * @memberof PIXI\n * @static\n * @enum {string}\n * @property {string} BUTT - 'butt': don't add any cap at line ends (leaves orthogonal edges)\n * @property {string} ROUND - 'round': add semicircle at ends\n * @property {string} SQUARE - 'square': add square at end (like `BUTT` except more length at end)\n */\nvar LINE_CAP;\n(function (LINE_CAP) {\n    LINE_CAP[\"BUTT\"] = \"butt\";\n    LINE_CAP[\"ROUND\"] = \"round\";\n    LINE_CAP[\"SQUARE\"] = \"square\";\n})(LINE_CAP || (LINE_CAP = {}));\n/**\n * Graphics curves resolution settings. If `adaptive` flag is set to `true`,\n * the resolution is calculated based on the curve's length to ensure better visual quality.\n * Adaptive draw works with `bezierCurveTo` and `quadraticCurveTo`.\n *\n * @static\n * @constant\n * @memberof PIXI\n * @name GRAPHICS_CURVES\n * @type {object}\n * @property {boolean} adaptive=false - flag indicating if the resolution should be adaptive\n * @property {number} maxLength=10 - maximal length of a single segment of the curve (if adaptive = false, ignored)\n * @property {number} minSegments=8 - minimal number of segments in the curve (if adaptive = false, ignored)\n * @property {number} maxSegments=2048 - maximal number of segments in the curve (if adaptive = false, ignored)\n */\nvar GRAPHICS_CURVES = {\n    adaptive: true,\n    maxLength: 10,\n    minSegments: 8,\n    maxSegments: 2048,\n    epsilon: 0.0001,\n    _segmentsCount: function (length, defaultSegments) {\n        if (defaultSegments === void 0) { defaultSegments = 20; }\n        if (!this.adaptive || !length || isNaN(length)) {\n            return defaultSegments;\n        }\n        var result = Math.ceil(length / this.maxLength);\n        if (result < this.minSegments) {\n            result = this.minSegments;\n        }\n        else if (result > this.maxSegments) {\n            result = this.maxSegments;\n        }\n        return result;\n    },\n};\n\n/**\n * Fill style object for Graphics.\n *\n * @class\n * @memberof PIXI\n */\nvar FillStyle = /** @class */ (function () {\n    function FillStyle() {\n        /**\n         * The hex color value used when coloring the Graphics object.\n         *\n         * @member {number}\n         * @default 0xFFFFFF\n         */\n        this.color = 0xFFFFFF;\n        /**\n         * The alpha value used when filling the Graphics object.\n         *\n         * @member {number}\n         * @default 1\n         */\n        this.alpha = 1.0;\n        /**\n         * The texture to be used for the fill.\n         *\n         * @member {PIXI.Texture}\n         * @default 0\n         */\n        this.texture = _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture.WHITE;\n        /**\n         * The transform aplpied to the texture.\n         *\n         * @member {PIXI.Matrix}\n         * @default null\n         */\n        this.matrix = null;\n        /**\n         * If the current fill is visible.\n         *\n         * @member {boolean}\n         * @default false\n         */\n        this.visible = false;\n        this.reset();\n    }\n    /**\n     * Clones the object\n     *\n     * @return {PIXI.FillStyle}\n     */\n    FillStyle.prototype.clone = function () {\n        var obj = new FillStyle();\n        obj.color = this.color;\n        obj.alpha = this.alpha;\n        obj.texture = this.texture;\n        obj.matrix = this.matrix;\n        obj.visible = this.visible;\n        return obj;\n    };\n    /**\n     * Reset\n     */\n    FillStyle.prototype.reset = function () {\n        this.color = 0xFFFFFF;\n        this.alpha = 1;\n        this.texture = _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture.WHITE;\n        this.matrix = null;\n        this.visible = false;\n    };\n    /**\n     * Destroy and don't use after this\n     */\n    FillStyle.prototype.destroy = function () {\n        this.texture = null;\n        this.matrix = null;\n    };\n    return FillStyle;\n}());\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * Builds a polygon to draw\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.WebGLGraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape\n * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines\n */\nvar buildPoly = {\n    build: function (graphicsData) {\n        graphicsData.points = graphicsData.shape.points.slice();\n    },\n    triangulate: function (graphicsData, graphicsGeometry) {\n        var points = graphicsData.points;\n        var holes = graphicsData.holes;\n        var verts = graphicsGeometry.points;\n        var indices = graphicsGeometry.indices;\n        if (points.length >= 6) {\n            var holeArray = [];\n            // Process holes..\n            for (var i = 0; i < holes.length; i++) {\n                var hole = holes[i];\n                holeArray.push(points.length / 2);\n                points = points.concat(hole.points);\n            }\n            // sort color\n            var triangles = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.earcut)(points, holeArray, 2);\n            if (!triangles) {\n                return;\n            }\n            var vertPos = verts.length / 2;\n            for (var i = 0; i < triangles.length; i += 3) {\n                indices.push(triangles[i] + vertPos);\n                indices.push(triangles[i + 1] + vertPos);\n                indices.push(triangles[i + 2] + vertPos);\n            }\n            for (var i = 0; i < points.length; i++) {\n                verts.push(points[i]);\n            }\n        }\n    },\n};\n\n// for type only\n/**\n * Builds a circle to draw\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.WebGLGraphicsData} graphicsData - The graphics object to draw\n * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape\n * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines\n */\nvar buildCircle = {\n    build: function (graphicsData) {\n        // need to convert points to a nice regular data\n        var circleData = graphicsData.shape;\n        var points = graphicsData.points;\n        var x = circleData.x;\n        var y = circleData.y;\n        var width;\n        var height;\n        points.length = 0;\n        // TODO - bit hacky??\n        if (graphicsData.type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.CIRC) {\n            width = circleData.radius;\n            height = circleData.radius;\n        }\n        else {\n            var ellipseData = graphicsData.shape;\n            width = ellipseData.width;\n            height = ellipseData.height;\n        }\n        if (width === 0 || height === 0) {\n            return;\n        }\n        var totalSegs = Math.floor(30 * Math.sqrt(circleData.radius))\n            || Math.floor(15 * Math.sqrt(width + height));\n        totalSegs /= 2.3;\n        var seg = (Math.PI * 2) / totalSegs;\n        for (var i = 0; i < totalSegs - 0.5; i++) {\n            points.push(x + (Math.sin(-seg * i) * width), y + (Math.cos(-seg * i) * height));\n        }\n        points.push(points[0], points[1]);\n    },\n    triangulate: function (graphicsData, graphicsGeometry) {\n        var points = graphicsData.points;\n        var verts = graphicsGeometry.points;\n        var indices = graphicsGeometry.indices;\n        var vertPos = verts.length / 2;\n        var center = vertPos;\n        var circle = (graphicsData.shape);\n        var matrix = graphicsData.matrix;\n        var x = circle.x;\n        var y = circle.y;\n        // Push center (special point)\n        verts.push(graphicsData.matrix ? (matrix.a * x) + (matrix.c * y) + matrix.tx : x, graphicsData.matrix ? (matrix.b * x) + (matrix.d * y) + matrix.ty : y);\n        for (var i = 0; i < points.length; i += 2) {\n            verts.push(points[i], points[i + 1]);\n            // add some uvs\n            indices.push(vertPos++, center, vertPos);\n        }\n    },\n};\n\n/**\n * Builds a rectangle to draw\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.WebGLGraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape\n * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines\n */\nvar buildRectangle = {\n    build: function (graphicsData) {\n        // --- //\n        // need to convert points to a nice regular data\n        //\n        var rectData = graphicsData.shape;\n        var x = rectData.x;\n        var y = rectData.y;\n        var width = rectData.width;\n        var height = rectData.height;\n        var points = graphicsData.points;\n        points.length = 0;\n        points.push(x, y, x + width, y, x + width, y + height, x, y + height);\n    },\n    triangulate: function (graphicsData, graphicsGeometry) {\n        var points = graphicsData.points;\n        var verts = graphicsGeometry.points;\n        var vertPos = verts.length / 2;\n        verts.push(points[0], points[1], points[2], points[3], points[6], points[7], points[4], points[5]);\n        graphicsGeometry.indices.push(vertPos, vertPos + 1, vertPos + 2, vertPos + 1, vertPos + 2, vertPos + 3);\n    },\n};\n\n/**\n * Calculate a single point for a quadratic bezier curve.\n * Utility function used by quadraticBezierCurve.\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {number} n1 - first number\n * @param {number} n2 - second number\n * @param {number} perc - percentage\n * @return {number} the result\n *\n */\nfunction getPt(n1, n2, perc) {\n    var diff = n2 - n1;\n    return n1 + (diff * perc);\n}\n/**\n * Calculate the points for a quadratic bezier curve. (helper function..)\n * Based on: https://stackoverflow.com/questions/785097/how-do-i-implement-a-bezier-curve-in-c\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {number} fromX - Origin point x\n * @param {number} fromY - Origin point x\n * @param {number} cpX - Control point x\n * @param {number} cpY - Control point y\n * @param {number} toX - Destination point x\n * @param {number} toY - Destination point y\n * @param {number[]} [out=[]] - The output array to add points into. If not passed, a new array is created.\n * @return {number[]} an array of points\n */\nfunction quadraticBezierCurve(fromX, fromY, cpX, cpY, toX, toY, out) {\n    if (out === void 0) { out = []; }\n    var n = 20;\n    var points = out;\n    var xa = 0;\n    var ya = 0;\n    var xb = 0;\n    var yb = 0;\n    var x = 0;\n    var y = 0;\n    for (var i = 0, j = 0; i <= n; ++i) {\n        j = i / n;\n        // The Green Line\n        xa = getPt(fromX, cpX, j);\n        ya = getPt(fromY, cpY, j);\n        xb = getPt(cpX, toX, j);\n        yb = getPt(cpY, toY, j);\n        // The Black Dot\n        x = getPt(xa, xb, j);\n        y = getPt(ya, yb, j);\n        points.push(x, y);\n    }\n    return points;\n}\n/**\n * Builds a rounded rectangle to draw\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.WebGLGraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape\n * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines\n */\nvar buildRoundedRectangle = {\n    build: function (graphicsData) {\n        var rrectData = graphicsData.shape;\n        var points = graphicsData.points;\n        var x = rrectData.x;\n        var y = rrectData.y;\n        var width = rrectData.width;\n        var height = rrectData.height;\n        // Don't allow negative radius or greater than half the smallest width\n        var radius = Math.max(0, Math.min(rrectData.radius, Math.min(width, height) / 2));\n        points.length = 0;\n        // No radius, do a simple rectangle\n        if (!radius) {\n            points.push(x, y, x + width, y, x + width, y + height, x, y + height);\n        }\n        else {\n            quadraticBezierCurve(x, y + radius, x, y, x + radius, y, points);\n            quadraticBezierCurve(x + width - radius, y, x + width, y, x + width, y + radius, points);\n            quadraticBezierCurve(x + width, y + height - radius, x + width, y + height, x + width - radius, y + height, points);\n            quadraticBezierCurve(x + radius, y + height, x, y + height, x, y + height - radius, points);\n        }\n        // this tiny number deals with the issue that occurs when points overlap and earcut fails to triangulate the item.\n        // TODO - fix this properly, this is not very elegant.. but it works for now.\n    },\n    triangulate: function (graphicsData, graphicsGeometry) {\n        var points = graphicsData.points;\n        var verts = graphicsGeometry.points;\n        var indices = graphicsGeometry.indices;\n        var vecPos = verts.length / 2;\n        var triangles = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.earcut)(points, null, 2);\n        for (var i = 0, j = triangles.length; i < j; i += 3) {\n            indices.push(triangles[i] + vecPos);\n            //     indices.push(triangles[i] + vecPos);\n            indices.push(triangles[i + 1] + vecPos);\n            //   indices.push(triangles[i + 2] + vecPos);\n            indices.push(triangles[i + 2] + vecPos);\n        }\n        for (var i = 0, j = points.length; i < j; i++) {\n            verts.push(points[i], points[++i]);\n        }\n    },\n};\n\n/**\n * Buffers vertices to draw a square cap.\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {number} x - X-coord of end point\n * @param {number} y - Y-coord of end point\n * @param {number} nx - X-coord of line normal pointing inside\n * @param {number} ny - Y-coord of line normal pointing inside\n * @param {Array<number>} verts - vertex buffer\n * @returns {}\n */\nfunction square(x, y, nx, ny, innerWeight, outerWeight, clockwise, /* rotation for square (true at left end, false at right end) */ verts) {\n    var ix = x - (nx * innerWeight);\n    var iy = y - (ny * innerWeight);\n    var ox = x + (nx * outerWeight);\n    var oy = y + (ny * outerWeight);\n    /* Rotate nx,ny for extension vector */\n    var exx;\n    var eyy;\n    if (clockwise) {\n        exx = ny;\n        eyy = -nx;\n    }\n    else {\n        exx = -ny;\n        eyy = nx;\n    }\n    /* [i|0]x,y extended at cap */\n    var eix = ix + exx;\n    var eiy = iy + eyy;\n    var eox = ox + exx;\n    var eoy = oy + eyy;\n    /* Square itself must be inserted clockwise*/\n    verts.push(eix, eiy);\n    verts.push(eox, eoy);\n    return 2;\n}\n/**\n * Buffers vertices to draw an arc at the line joint or cap.\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {number} cx - X-coord of center\n * @param {number} cy - Y-coord of center\n * @param {number} sx - X-coord of arc start\n * @param {number} sy - Y-coord of arc start\n * @param {number} ex - X-coord of arc end\n * @param {number} ey - Y-coord of arc end\n * @param {Array<number>} verts - buffer of vertices\n * @param {boolean} clockwise - orientation of vertices\n * @returns {number} - no. of vertices pushed\n */\nfunction round(cx, cy, sx, sy, ex, ey, verts, clockwise) {\n    var cx2p0x = sx - cx;\n    var cy2p0y = sy - cy;\n    var angle0 = Math.atan2(cx2p0x, cy2p0y);\n    var angle1 = Math.atan2(ex - cx, ey - cy);\n    if (clockwise && angle0 < angle1) {\n        angle0 += Math.PI * 2;\n    }\n    else if (!clockwise && angle0 > angle1) {\n        angle1 += Math.PI * 2;\n    }\n    var startAngle = angle0;\n    var angleDiff = angle1 - angle0;\n    var absAngleDiff = Math.abs(angleDiff);\n    /* if (absAngleDiff >= PI_LBOUND && absAngleDiff <= PI_UBOUND)\n    {\n        const r1x = cx - nxtPx;\n        const r1y = cy - nxtPy;\n\n        if (r1x === 0)\n        {\n            if (r1y > 0)\n            {\n                angleDiff = -angleDiff;\n            }\n        }\n        else if (r1x >= -GRAPHICS_CURVES.epsilon)\n        {\n            angleDiff = -angleDiff;\n        }\n    }*/\n    var radius = Math.sqrt((cx2p0x * cx2p0x) + (cy2p0y * cy2p0y));\n    var segCount = ((15 * absAngleDiff * Math.sqrt(radius) / Math.PI) >> 0) + 1;\n    var angleInc = angleDiff / segCount;\n    startAngle += angleInc;\n    if (clockwise) {\n        verts.push(cx, cy);\n        verts.push(sx, sy);\n        for (var i = 1, angle = startAngle; i < segCount; i++, angle += angleInc) {\n            verts.push(cx, cy);\n            verts.push(cx + ((Math.sin(angle) * radius)), cy + ((Math.cos(angle) * radius)));\n        }\n        verts.push(cx, cy);\n        verts.push(ex, ey);\n    }\n    else {\n        verts.push(sx, sy);\n        verts.push(cx, cy);\n        for (var i = 1, angle = startAngle; i < segCount; i++, angle += angleInc) {\n            verts.push(cx + ((Math.sin(angle) * radius)), cy + ((Math.cos(angle) * radius)));\n            verts.push(cx, cy);\n        }\n        verts.push(ex, ey);\n        verts.push(cx, cy);\n    }\n    return segCount * 2;\n}\n/**\n * Builds a line to draw using the polygon method.\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.GraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {PIXI.GraphicsGeometry} graphicsGeometry - Geometry where to append output\n */\nfunction buildNonNativeLine(graphicsData, graphicsGeometry) {\n    var shape = graphicsData.shape;\n    var points = graphicsData.points || shape.points.slice();\n    var eps = graphicsGeometry.closePointEps;\n    if (points.length === 0) {\n        return;\n    }\n    // if the line width is an odd number add 0.5 to align to a whole pixel\n    // commenting this out fixes #711 and #1620\n    // if (graphicsData.lineWidth%2)\n    // {\n    //     for (i = 0; i < points.length; i++)\n    //     {\n    //         points[i] += 0.5;\n    //     }\n    // }\n    var style = graphicsData.lineStyle;\n    // get first and last point.. figure out the middle!\n    var firstPoint = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point(points[0], points[1]);\n    var lastPoint = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point(points[points.length - 2], points[points.length - 1]);\n    var closedShape = shape.type !== _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.POLY || shape.closeStroke;\n    var closedPath = Math.abs(firstPoint.x - lastPoint.x) < eps\n        && Math.abs(firstPoint.y - lastPoint.y) < eps;\n    // if the first point is the last point - gonna have issues :)\n    if (closedShape) {\n        // need to clone as we are going to slightly modify the shape..\n        points = points.slice();\n        if (closedPath) {\n            points.pop();\n            points.pop();\n            lastPoint.set(points[points.length - 2], points[points.length - 1]);\n        }\n        var midPointX = (firstPoint.x + lastPoint.x) * 0.5;\n        var midPointY = (lastPoint.y + firstPoint.y) * 0.5;\n        points.unshift(midPointX, midPointY);\n        points.push(midPointX, midPointY);\n    }\n    var verts = graphicsGeometry.points;\n    var length = points.length / 2;\n    var indexCount = points.length;\n    var indexStart = verts.length / 2;\n    // Max. inner and outer width\n    var width = style.width / 2;\n    var widthSquared = width * width;\n    var miterLimitSquared = style.miterLimit * style.miterLimit;\n    /* Line segments of interest where (x1,y1) forms the corner. */\n    var x0 = points[0];\n    var y0 = points[1];\n    var x1 = points[2];\n    var y1 = points[3];\n    var x2 = 0;\n    var y2 = 0;\n    /* perp[?](x|y) = the line normal with magnitude lineWidth. */\n    var perpx = -(y0 - y1);\n    var perpy = x0 - x1;\n    var perp1x = 0;\n    var perp1y = 0;\n    var dist = Math.sqrt((perpx * perpx) + (perpy * perpy));\n    perpx /= dist;\n    perpy /= dist;\n    perpx *= width;\n    perpy *= width;\n    var ratio = style.alignment; // 0.5;\n    var innerWeight = (1 - ratio) * 2;\n    var outerWeight = ratio * 2;\n    if (!closedShape) {\n        if (style.cap === LINE_CAP.ROUND) {\n            indexCount += round(x0 - (perpx * (innerWeight - outerWeight) * 0.5), y0 - (perpy * (innerWeight - outerWeight) * 0.5), x0 - (perpx * innerWeight), y0 - (perpy * innerWeight), x0 + (perpx * outerWeight), y0 + (perpy * outerWeight), verts, true) + 2;\n        }\n        else if (style.cap === LINE_CAP.SQUARE) {\n            indexCount += square(x0, y0, perpx, perpy, innerWeight, outerWeight, true, verts);\n        }\n    }\n    // Push first point (below & above vertices)\n    verts.push(x0 - (perpx * innerWeight), y0 - (perpy * innerWeight));\n    verts.push(x0 + (perpx * outerWeight), y0 + (perpy * outerWeight));\n    for (var i = 1; i < length - 1; ++i) {\n        x0 = points[(i - 1) * 2];\n        y0 = points[((i - 1) * 2) + 1];\n        x1 = points[i * 2];\n        y1 = points[(i * 2) + 1];\n        x2 = points[(i + 1) * 2];\n        y2 = points[((i + 1) * 2) + 1];\n        perpx = -(y0 - y1);\n        perpy = x0 - x1;\n        dist = Math.sqrt((perpx * perpx) + (perpy * perpy));\n        perpx /= dist;\n        perpy /= dist;\n        perpx *= width;\n        perpy *= width;\n        perp1x = -(y1 - y2);\n        perp1y = x1 - x2;\n        dist = Math.sqrt((perp1x * perp1x) + (perp1y * perp1y));\n        perp1x /= dist;\n        perp1y /= dist;\n        perp1x *= width;\n        perp1y *= width;\n        /* d[x|y](0|1) = the component displacment between points p(0,1|1,2) */\n        var dx0 = x1 - x0;\n        var dy0 = y0 - y1;\n        var dx1 = x1 - x2;\n        var dy1 = y2 - y1;\n        /* +ve if internal angle counterclockwise, -ve if internal angle clockwise. */\n        var cross = (dy0 * dx1) - (dy1 * dx0);\n        var clockwise = (cross < 0);\n        /* Going nearly straight? */\n        if (Math.abs(cross) < 0.1) {\n            verts.push(x1 - (perpx * innerWeight), y1 - (perpy * innerWeight));\n            verts.push(x1 + (perpx * outerWeight), y1 + (perpy * outerWeight));\n            continue;\n        }\n        /* p[x|y] is the miter point. pdist is the distance between miter point and p1. */\n        var c1 = ((-perpx + x0) * (-perpy + y1)) - ((-perpx + x1) * (-perpy + y0));\n        var c2 = ((-perp1x + x2) * (-perp1y + y1)) - ((-perp1x + x1) * (-perp1y + y2));\n        var px = ((dx0 * c2) - (dx1 * c1)) / cross;\n        var py = ((dy1 * c1) - (dy0 * c2)) / cross;\n        var pdist = ((px - x1) * (px - x1)) + ((py - y1) * (py - y1));\n        /* Inner miter point */\n        var imx = x1 + ((px - x1) * innerWeight);\n        var imy = y1 + ((py - y1) * innerWeight);\n        /* Outer miter point */\n        var omx = x1 - ((px - x1) * outerWeight);\n        var omy = y1 - ((py - y1) * outerWeight);\n        /* Is the inside miter point too far away, creating a spike? */\n        var smallerInsideSegmentSq = Math.min((dx0 * dx0) + (dy0 * dy0), (dx1 * dx1) + (dy1 * dy1));\n        var insideWeight = clockwise ? innerWeight : outerWeight;\n        var smallerInsideDiagonalSq = smallerInsideSegmentSq + (insideWeight * insideWeight * widthSquared);\n        var insideMiterOk = pdist <= smallerInsideDiagonalSq;\n        if (insideMiterOk) {\n            if (style.join === LINE_JOIN.BEVEL || pdist / widthSquared > miterLimitSquared) {\n                if (clockwise) /* rotating at inner angle */ {\n                    verts.push(imx, imy); // inner miter point\n                    verts.push(x1 + (perpx * outerWeight), y1 + (perpy * outerWeight)); // first segment's outer vertex\n                    verts.push(imx, imy); // inner miter point\n                    verts.push(x1 + (perp1x * outerWeight), y1 + (perp1y * outerWeight)); // second segment's outer vertex\n                }\n                else /* rotating at outer angle */ {\n                    verts.push(x1 - (perpx * innerWeight), y1 - (perpy * innerWeight)); // first segment's inner vertex\n                    verts.push(omx, omy); // outer miter point\n                    verts.push(x1 - (perp1x * innerWeight), y1 - (perp1y * innerWeight)); // second segment's outer vertex\n                    verts.push(omx, omy); // outer miter point\n                }\n                indexCount += 2;\n            }\n            else if (style.join === LINE_JOIN.ROUND) {\n                if (clockwise) /* arc is outside */ {\n                    verts.push(imx, imy);\n                    verts.push(x1 + (perpx * outerWeight), y1 + (perpy * outerWeight));\n                    indexCount += round(x1, y1, x1 + (perpx * outerWeight), y1 + (perpy * outerWeight), x1 + (perp1x * outerWeight), y1 + (perp1y * outerWeight), verts, true) + 4;\n                    verts.push(imx, imy);\n                    verts.push(x1 + (perp1x * outerWeight), y1 + (perp1y * outerWeight));\n                }\n                else /* arc is inside */ {\n                    verts.push(x1 - (perpx * innerWeight), y1 - (perpy * innerWeight));\n                    verts.push(omx, omy);\n                    indexCount += round(x1, y1, x1 - (perpx * innerWeight), y1 - (perpy * innerWeight), x1 - (perp1x * innerWeight), y1 - (perp1y * innerWeight), verts, false) + 4;\n                    verts.push(x1 - (perp1x * innerWeight), y1 - (perp1y * innerWeight));\n                    verts.push(omx, omy);\n                }\n            }\n            else {\n                verts.push(imx, imy);\n                verts.push(omx, omy);\n            }\n        }\n        else // inside miter is NOT ok\n         {\n            verts.push(x1 - (perpx * innerWeight), y1 - (perpy * innerWeight)); // first segment's inner vertex\n            verts.push(x1 + (perpx * outerWeight), y1 + (perpy * outerWeight)); // first segment's outer vertex\n            if (style.join === LINE_JOIN.BEVEL || pdist / widthSquared > miterLimitSquared) ;\n            else if (style.join === LINE_JOIN.ROUND) {\n                if (clockwise) /* arc is outside */ {\n                    indexCount += round(x1, y1, x1 + (perpx * outerWeight), y1 + (perpy * outerWeight), x1 + (perp1x * outerWeight), y1 + (perp1y * outerWeight), verts, true) + 2;\n                }\n                else /* arc is inside */ {\n                    indexCount += round(x1, y1, x1 - (perpx * innerWeight), y1 - (perpy * innerWeight), x1 - (perp1x * innerWeight), y1 - (perp1y * innerWeight), verts, false) + 2;\n                }\n            }\n            else {\n                if (clockwise) {\n                    verts.push(omx, omy); // inner miter point\n                    verts.push(omx, omy); // inner miter point\n                }\n                else {\n                    verts.push(imx, imy); // outer miter point\n                    verts.push(imx, imy); // outer miter point\n                }\n                indexCount += 2;\n            }\n            verts.push(x1 - (perp1x * innerWeight), y1 - (perp1y * innerWeight)); // second segment's inner vertex\n            verts.push(x1 + (perp1x * outerWeight), y1 + (perp1y * outerWeight)); // second segment's outer vertex\n            indexCount += 2;\n        }\n    }\n    x0 = points[(length - 2) * 2];\n    y0 = points[((length - 2) * 2) + 1];\n    x1 = points[(length - 1) * 2];\n    y1 = points[((length - 1) * 2) + 1];\n    perpx = -(y0 - y1);\n    perpy = x0 - x1;\n    dist = Math.sqrt((perpx * perpx) + (perpy * perpy));\n    perpx /= dist;\n    perpy /= dist;\n    perpx *= width;\n    perpy *= width;\n    verts.push(x1 - (perpx * innerWeight), y1 - (perpy * innerWeight));\n    verts.push(x1 + (perpx * outerWeight), y1 + (perpy * outerWeight));\n    if (!closedShape) {\n        if (style.cap === LINE_CAP.ROUND) {\n            indexCount += round(x1 - (perpx * (innerWeight - outerWeight) * 0.5), y1 - (perpy * (innerWeight - outerWeight) * 0.5), x1 - (perpx * innerWeight), y1 - (perpy * innerWeight), x1 + (perpx * outerWeight), y1 + (perpy * outerWeight), verts, false) + 2;\n        }\n        else if (style.cap === LINE_CAP.SQUARE) {\n            indexCount += square(x1, y1, perpx, perpy, innerWeight, outerWeight, false, verts);\n        }\n    }\n    var indices = graphicsGeometry.indices;\n    var eps2 = GRAPHICS_CURVES.epsilon * GRAPHICS_CURVES.epsilon;\n    // indices.push(indexStart);\n    for (var i = indexStart; i < indexCount + indexStart - 2; ++i) {\n        x0 = verts[(i * 2)];\n        y0 = verts[(i * 2) + 1];\n        x1 = verts[(i + 1) * 2];\n        y1 = verts[((i + 1) * 2) + 1];\n        x2 = verts[(i + 2) * 2];\n        y2 = verts[((i + 2) * 2) + 1];\n        /* Skip zero area triangles */\n        if (Math.abs((x0 * (y1 - y2)) + (x1 * (y2 - y0)) + (x2 * (y0 - y1))) < eps2) {\n            continue;\n        }\n        indices.push(i, i + 1, i + 2);\n    }\n}\n/**\n * Builds a line to draw using the gl.drawArrays(gl.LINES) method\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.GraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {PIXI.GraphicsGeometry} graphicsGeometry - Geometry where to append output\n */\nfunction buildNativeLine(graphicsData, graphicsGeometry) {\n    var i = 0;\n    var shape = graphicsData.shape;\n    var points = graphicsData.points || shape.points;\n    var closedShape = shape.type !== _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.POLY || shape.closeStroke;\n    if (points.length === 0)\n        { return; }\n    var verts = graphicsGeometry.points;\n    var indices = graphicsGeometry.indices;\n    var length = points.length / 2;\n    var startIndex = verts.length / 2;\n    var currentIndex = startIndex;\n    verts.push(points[0], points[1]);\n    for (i = 1; i < length; i++) {\n        verts.push(points[i * 2], points[(i * 2) + 1]);\n        indices.push(currentIndex, currentIndex + 1);\n        currentIndex++;\n    }\n    if (closedShape) {\n        indices.push(currentIndex, startIndex);\n    }\n}\n/**\n * Builds a line to draw\n *\n * Ignored from docs since it is not directly exposed.\n *\n * @ignore\n * @private\n * @param {PIXI.GraphicsData} graphicsData - The graphics object containing all the necessary properties\n * @param {PIXI.GraphicsGeometry} graphicsGeometry - Geometry where to append output\n */\nfunction buildLine(graphicsData, graphicsGeometry) {\n    if (graphicsData.lineStyle.native) {\n        buildNativeLine(graphicsData, graphicsGeometry);\n    }\n    else {\n        buildNonNativeLine(graphicsData, graphicsGeometry);\n    }\n}\n\n/**\n * Draw a star shape with an arbitrary number of points.\n *\n * @class\n * @extends PIXI.Polygon\n * @memberof PIXI.graphicsUtils\n * @param {number} x - Center X position of the star\n * @param {number} y - Center Y position of the star\n * @param {number} points - The number of points of the star, must be > 1\n * @param {number} radius - The outer radius of the star\n * @param {number} [innerRadius] - The inner radius between points, default half `radius`\n * @param {number} [rotation=0] - The rotation of the star in radians, where 0 is vertical\n * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n */\nvar Star = /** @class */ (function (_super) {\n    __extends(Star, _super);\n    function Star(x, y, points, radius, innerRadius, rotation) {\n        if (rotation === void 0) { rotation = 0; }\n        var _this = this;\n        innerRadius = innerRadius || radius / 2;\n        var startAngle = (-1 * Math.PI / 2) + rotation;\n        var len = points * 2;\n        var delta = _pixi_math__WEBPACK_IMPORTED_MODULE_1__.PI_2 / len;\n        var polygon = [];\n        for (var i = 0; i < len; i++) {\n            var r = i % 2 ? innerRadius : radius;\n            var angle = (i * delta) + startAngle;\n            polygon.push(x + (r * Math.cos(angle)), y + (r * Math.sin(angle)));\n        }\n        _this = _super.call(this, polygon) || this;\n        return _this;\n    }\n    return Star;\n}(_pixi_math__WEBPACK_IMPORTED_MODULE_1__.Polygon));\n\n/**\n * Utilities for arc curves\n * @class\n * @private\n */\nvar ArcUtils = /** @class */ (function () {\n    function ArcUtils() {\n    }\n    /**\n     * The arcTo() method creates an arc/curve between two tangents on the canvas.\n     *\n     * \"borrowed\" from https://code.google.com/p/fxcanvas/ - thanks google!\n     *\n     * @private\n     * @param {number} x1 - The x-coordinate of the beginning of the arc\n     * @param {number} y1 - The y-coordinate of the beginning of the arc\n     * @param {number} x2 - The x-coordinate of the end of the arc\n     * @param {number} y2 - The y-coordinate of the end of the arc\n     * @param {number} radius - The radius of the arc\n     * @return {object} If the arc length is valid, return center of circle, radius and other info otherwise `null`.\n     */\n    ArcUtils.curveTo = function (x1, y1, x2, y2, radius, points) {\n        var fromX = points[points.length - 2];\n        var fromY = points[points.length - 1];\n        var a1 = fromY - y1;\n        var b1 = fromX - x1;\n        var a2 = y2 - y1;\n        var b2 = x2 - x1;\n        var mm = Math.abs((a1 * b2) - (b1 * a2));\n        if (mm < 1.0e-8 || radius === 0) {\n            if (points[points.length - 2] !== x1 || points[points.length - 1] !== y1) {\n                points.push(x1, y1);\n            }\n            return null;\n        }\n        var dd = (a1 * a1) + (b1 * b1);\n        var cc = (a2 * a2) + (b2 * b2);\n        var tt = (a1 * a2) + (b1 * b2);\n        var k1 = radius * Math.sqrt(dd) / mm;\n        var k2 = radius * Math.sqrt(cc) / mm;\n        var j1 = k1 * tt / dd;\n        var j2 = k2 * tt / cc;\n        var cx = (k1 * b2) + (k2 * b1);\n        var cy = (k1 * a2) + (k2 * a1);\n        var px = b1 * (k2 + j1);\n        var py = a1 * (k2 + j1);\n        var qx = b2 * (k1 + j2);\n        var qy = a2 * (k1 + j2);\n        var startAngle = Math.atan2(py - cy, px - cx);\n        var endAngle = Math.atan2(qy - cy, qx - cx);\n        return {\n            cx: (cx + x1),\n            cy: (cy + y1),\n            radius: radius,\n            startAngle: startAngle,\n            endAngle: endAngle,\n            anticlockwise: (b1 * a2 > b2 * a1),\n        };\n    };\n    /* eslint-disable max-len */\n    /**\n     * The arc method creates an arc/curve (used to create circles, or parts of circles).\n     *\n     * @private\n     * @param {number} startX - Start x location of arc\n     * @param {number} startY - Start y location of arc\n     * @param {number} cx - The x-coordinate of the center of the circle\n     * @param {number} cy - The y-coordinate of the center of the circle\n     * @param {number} radius - The radius of the circle\n     * @param {number} startAngle - The starting angle, in radians (0 is at the 3 o'clock position\n     *  of the arc's circle)\n     * @param {number} endAngle - The ending angle, in radians\n     * @param {boolean} anticlockwise - Specifies whether the drawing should be\n     *  counter-clockwise or clockwise. False is default, and indicates clockwise, while true\n     *  indicates counter-clockwise.\n     * @param {number[]} points - Collection of points to add to\n     */\n    ArcUtils.arc = function (_startX, _startY, cx, cy, radius, startAngle, endAngle, _anticlockwise, points) {\n        var sweep = endAngle - startAngle;\n        var n = GRAPHICS_CURVES._segmentsCount(Math.abs(sweep) * radius, Math.ceil(Math.abs(sweep) / _pixi_math__WEBPACK_IMPORTED_MODULE_1__.PI_2) * 40);\n        var theta = (sweep) / (n * 2);\n        var theta2 = theta * 2;\n        var cTheta = Math.cos(theta);\n        var sTheta = Math.sin(theta);\n        var segMinus = n - 1;\n        var remainder = (segMinus % 1) / segMinus;\n        for (var i = 0; i <= segMinus; ++i) {\n            var real = i + (remainder * i);\n            var angle = ((theta) + startAngle + (theta2 * real));\n            var c = Math.cos(angle);\n            var s = -Math.sin(angle);\n            points.push((((cTheta * c) + (sTheta * s)) * radius) + cx, (((cTheta * -s) + (sTheta * c)) * radius) + cy);\n        }\n    };\n    return ArcUtils;\n}());\n\n/**\n * Utilities for bezier curves\n * @class\n * @private\n */\nvar BezierUtils = /** @class */ (function () {\n    function BezierUtils() {\n    }\n    /**\n     * Calculate length of bezier curve.\n     * Analytical solution is impossible, since it involves an integral that does not integrate in general.\n     * Therefore numerical solution is used.\n     *\n     * @private\n     * @param {number} fromX - Starting point x\n     * @param {number} fromY - Starting point y\n     * @param {number} cpX - Control point x\n     * @param {number} cpY - Control point y\n     * @param {number} cpX2 - Second Control point x\n     * @param {number} cpY2 - Second Control point y\n     * @param {number} toX - Destination point x\n     * @param {number} toY - Destination point y\n     * @return {number} Length of bezier curve\n     */\n    BezierUtils.curveLength = function (fromX, fromY, cpX, cpY, cpX2, cpY2, toX, toY) {\n        var n = 10;\n        var result = 0.0;\n        var t = 0.0;\n        var t2 = 0.0;\n        var t3 = 0.0;\n        var nt = 0.0;\n        var nt2 = 0.0;\n        var nt3 = 0.0;\n        var x = 0.0;\n        var y = 0.0;\n        var dx = 0.0;\n        var dy = 0.0;\n        var prevX = fromX;\n        var prevY = fromY;\n        for (var i = 1; i <= n; ++i) {\n            t = i / n;\n            t2 = t * t;\n            t3 = t2 * t;\n            nt = (1.0 - t);\n            nt2 = nt * nt;\n            nt3 = nt2 * nt;\n            x = (nt3 * fromX) + (3.0 * nt2 * t * cpX) + (3.0 * nt * t2 * cpX2) + (t3 * toX);\n            y = (nt3 * fromY) + (3.0 * nt2 * t * cpY) + (3 * nt * t2 * cpY2) + (t3 * toY);\n            dx = prevX - x;\n            dy = prevY - y;\n            prevX = x;\n            prevY = y;\n            result += Math.sqrt((dx * dx) + (dy * dy));\n        }\n        return result;\n    };\n    /**\n     * Calculate the points for a bezier curve and then draws it.\n     *\n     * Ignored from docs since it is not directly exposed.\n     *\n     * @ignore\n     * @param {number} cpX - Control point x\n     * @param {number} cpY - Control point y\n     * @param {number} cpX2 - Second Control point x\n     * @param {number} cpY2 - Second Control point y\n     * @param {number} toX - Destination point x\n     * @param {number} toY - Destination point y\n     * @param {number[]} points - Path array to push points into\n     */\n    BezierUtils.curveTo = function (cpX, cpY, cpX2, cpY2, toX, toY, points) {\n        var fromX = points[points.length - 2];\n        var fromY = points[points.length - 1];\n        points.length -= 2;\n        var n = GRAPHICS_CURVES._segmentsCount(BezierUtils.curveLength(fromX, fromY, cpX, cpY, cpX2, cpY2, toX, toY));\n        var dt = 0;\n        var dt2 = 0;\n        var dt3 = 0;\n        var t2 = 0;\n        var t3 = 0;\n        points.push(fromX, fromY);\n        for (var i = 1, j = 0; i <= n; ++i) {\n            j = i / n;\n            dt = (1 - j);\n            dt2 = dt * dt;\n            dt3 = dt2 * dt;\n            t2 = j * j;\n            t3 = t2 * j;\n            points.push((dt3 * fromX) + (3 * dt2 * j * cpX) + (3 * dt * t2 * cpX2) + (t3 * toX), (dt3 * fromY) + (3 * dt2 * j * cpY) + (3 * dt * t2 * cpY2) + (t3 * toY));\n        }\n    };\n    return BezierUtils;\n}());\n\n/**\n * Utilities for quadratic curves\n * @class\n * @private\n */\nvar QuadraticUtils = /** @class */ (function () {\n    function QuadraticUtils() {\n    }\n    /**\n     * Calculate length of quadratic curve\n     * @see {@link http://www.malczak.linuxpl.com/blog/quadratic-bezier-curve-length/}\n     * for the detailed explanation of math behind this.\n     *\n     * @private\n     * @param {number} fromX - x-coordinate of curve start point\n     * @param {number} fromY - y-coordinate of curve start point\n     * @param {number} cpX - x-coordinate of curve control point\n     * @param {number} cpY - y-coordinate of curve control point\n     * @param {number} toX - x-coordinate of curve end point\n     * @param {number} toY - y-coordinate of curve end point\n     * @return {number} Length of quadratic curve\n     */\n    QuadraticUtils.curveLength = function (fromX, fromY, cpX, cpY, toX, toY) {\n        var ax = fromX - (2.0 * cpX) + toX;\n        var ay = fromY - (2.0 * cpY) + toY;\n        var bx = (2.0 * cpX) - (2.0 * fromX);\n        var by = (2.0 * cpY) - (2.0 * fromY);\n        var a = 4.0 * ((ax * ax) + (ay * ay));\n        var b = 4.0 * ((ax * bx) + (ay * by));\n        var c = (bx * bx) + (by * by);\n        var s = 2.0 * Math.sqrt(a + b + c);\n        var a2 = Math.sqrt(a);\n        var a32 = 2.0 * a * a2;\n        var c2 = 2.0 * Math.sqrt(c);\n        var ba = b / a2;\n        return ((a32 * s)\n            + (a2 * b * (s - c2))\n            + (((4.0 * c * a) - (b * b))\n                * Math.log(((2.0 * a2) + ba + s) / (ba + c2)))) / (4.0 * a32);\n    };\n    /**\n     * Calculate the points for a quadratic bezier curve and then draws it.\n     * Based on: https://stackoverflow.com/questions/785097/how-do-i-implement-a-bezier-curve-in-c\n     *\n     * @private\n     * @param {number} cpX - Control point x\n     * @param {number} cpY - Control point y\n     * @param {number} toX - Destination point x\n     * @param {number} toY - Destination point y\n     * @param {number[]} points - Points to add segments to.\n     */\n    QuadraticUtils.curveTo = function (cpX, cpY, toX, toY, points) {\n        var fromX = points[points.length - 2];\n        var fromY = points[points.length - 1];\n        var n = GRAPHICS_CURVES._segmentsCount(QuadraticUtils.curveLength(fromX, fromY, cpX, cpY, toX, toY));\n        var xa = 0;\n        var ya = 0;\n        for (var i = 1; i <= n; ++i) {\n            var j = i / n;\n            xa = fromX + ((cpX - fromX) * j);\n            ya = fromY + ((cpY - fromY) * j);\n            points.push(xa + (((cpX + ((toX - cpX) * j)) - xa) * j), ya + (((cpY + ((toY - cpY) * j)) - ya) * j));\n        }\n    };\n    return QuadraticUtils;\n}());\n\n/**\n * A structure to hold interim batch objects for Graphics.\n * @class\n * @memberof PIXI.graphicsUtils\n */\nvar BatchPart = /** @class */ (function () {\n    function BatchPart() {\n        this.reset();\n    }\n    /**\n     * Begin batch part\n     *\n     * @param {PIXI.FillStyle | PIXI.LineStyle} style\n     * @param {number} startIndex\n     * @param {number} attribStart\n     */\n    BatchPart.prototype.begin = function (style, startIndex, attribStart) {\n        this.reset();\n        this.style = style;\n        this.start = startIndex;\n        this.attribStart = attribStart;\n    };\n    /**\n     * End batch part\n     *\n     * @param {number} endIndex\n     * @param {number} endAttrib\n     */\n    BatchPart.prototype.end = function (endIndex, endAttrib) {\n        this.attribSize = endAttrib - this.attribStart;\n        this.size = endIndex - this.start;\n    };\n    BatchPart.prototype.reset = function () {\n        this.style = null;\n        this.size = 0;\n        this.start = 0;\n        this.attribStart = 0;\n        this.attribSize = 0;\n    };\n    return BatchPart;\n}());\n\n/**\n * Generalized convenience utilities for Graphics.\n *\n * @namespace graphicsUtils\n * @memberof PIXI\n */\nvar _a;\n/**\n * Map of fill commands for each shape type.\n *\n * @memberof PIXI.graphicsUtils\n * @member {Object} FILL_COMMANDS\n */\nvar FILL_COMMANDS = (_a = {},\n    _a[_pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.POLY] = buildPoly,\n    _a[_pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.CIRC] = buildCircle,\n    _a[_pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.ELIP] = buildCircle,\n    _a[_pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.RECT] = buildRectangle,\n    _a[_pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.RREC] = buildRoundedRectangle,\n    _a);\n/**\n * Batch pool, stores unused batches for preventing allocations.\n *\n * @memberof PIXI.graphicsUtils\n * @member {Array<PIXI.graphicsUtils.BatchPart>} BATCH_POOL\n */\nvar BATCH_POOL = [];\n/**\n * Draw call pool, stores unused draw calls for preventing allocations.\n *\n * @memberof PIXI.graphicsUtils\n * @member {Array<PIXI.BatchDrawCall>} DRAW_CALL_POOL\n */\nvar DRAW_CALL_POOL = [];\n\nvar index = ({\n    buildPoly: buildPoly,\n    buildCircle: buildCircle,\n    buildRectangle: buildRectangle,\n    buildRoundedRectangle: buildRoundedRectangle,\n    FILL_COMMANDS: FILL_COMMANDS,\n    BATCH_POOL: BATCH_POOL,\n    DRAW_CALL_POOL: DRAW_CALL_POOL,\n    buildLine: buildLine,\n    Star: Star,\n    ArcUtils: ArcUtils,\n    BezierUtils: BezierUtils,\n    QuadraticUtils: QuadraticUtils,\n    BatchPart: BatchPart\n});\n\n/**\n * A class to contain data useful for Graphics objects\n *\n * @class\n * @memberof PIXI\n */\nvar GraphicsData = /** @class */ (function () {\n    /**\n     *\n     * @param {PIXI.Circle|PIXI.Ellipse|PIXI.Polygon|PIXI.Rectangle|PIXI.RoundedRectangle} shape - The shape object to draw.\n     * @param {PIXI.FillStyle} [fillStyle] - the width of the line to draw\n     * @param {PIXI.LineStyle} [lineStyle] - the color of the line to draw\n     * @param {PIXI.Matrix} [matrix] - Transform matrix\n     */\n    function GraphicsData(shape, fillStyle, lineStyle, matrix) {\n        if (fillStyle === void 0) { fillStyle = null; }\n        if (lineStyle === void 0) { lineStyle = null; }\n        if (matrix === void 0) { matrix = null; }\n        /**\n         * The shape object to draw.\n         * @member {PIXI.Circle|PIXI.Ellipse|PIXI.Polygon|PIXI.Rectangle|PIXI.RoundedRectangle}\n         */\n        this.shape = shape;\n        /**\n         * The style of the line.\n         * @member {PIXI.LineStyle}\n         */\n        this.lineStyle = lineStyle;\n        /**\n         * The style of the fill.\n         * @member {PIXI.FillStyle}\n         */\n        this.fillStyle = fillStyle;\n        /**\n         * The transform matrix.\n         * @member {PIXI.Matrix}\n         */\n        this.matrix = matrix;\n        /**\n         * The type of the shape, see the Const.Shapes file for all the existing types,\n         * @member {number}\n         */\n        this.type = shape.type;\n        /**\n         * The collection of points.\n         * @member {number[]}\n         */\n        this.points = [];\n        /**\n         * The collection of holes.\n         * @member {PIXI.GraphicsData[]}\n         */\n        this.holes = [];\n    }\n    /**\n     * Creates a new GraphicsData object with the same values as this one.\n     *\n     * @return {PIXI.GraphicsData} Cloned GraphicsData object\n     */\n    GraphicsData.prototype.clone = function () {\n        return new GraphicsData(this.shape, this.fillStyle, this.lineStyle, this.matrix);\n    };\n    /**\n     * Destroys the Graphics data.\n     *\n     */\n    GraphicsData.prototype.destroy = function () {\n        this.shape = null;\n        this.holes.length = 0;\n        this.holes = null;\n        this.points.length = 0;\n        this.points = null;\n        this.lineStyle = null;\n        this.fillStyle = null;\n    };\n    return GraphicsData;\n}());\n\nvar tmpPoint = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point();\nvar tmpBounds = new _pixi_display__WEBPACK_IMPORTED_MODULE_4__.Bounds();\n/**\n * The Graphics class contains methods used to draw primitive shapes such as lines, circles and\n * rectangles to the display, and to color and fill them.\n *\n * GraphicsGeometry is designed to not be continually updating the geometry since it's expensive\n * to re-tesselate using **earcut**. Consider using {@link PIXI.Mesh} for this use-case, it's much faster.\n *\n * @class\n * @extends PIXI.BatchGeometry\n * @memberof PIXI\n */\nvar GraphicsGeometry = /** @class */ (function (_super) {\n    __extends(GraphicsGeometry, _super);\n    function GraphicsGeometry() {\n        var _this = _super.call(this) || this;\n        _this.uvsFloat32 = null;\n        _this.indicesUint16 = null;\n        /**\n         * An array of points to draw, 2 numbers per point\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this.points = [];\n        /**\n         * The collection of colors\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this.colors = [];\n        /**\n         * The UVs collection\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this.uvs = [];\n        /**\n         * The indices of the vertices\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this.indices = [];\n        /**\n         * Reference to the texture IDs.\n         *\n         * @member {number[]}\n         * @protected\n         */\n        _this.textureIds = [];\n        /**\n         * The collection of drawn shapes.\n         *\n         * @member {PIXI.GraphicsData[]}\n         * @protected\n         */\n        _this.graphicsData = [];\n        /**\n         * Used to detect if the graphics object has changed.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.dirty = 0;\n        /**\n         * Batches need to regenerated if the geometry is updated.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.batchDirty = -1;\n        /**\n         * Used to check if the cache is dirty.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.cacheDirty = -1;\n        /**\n         * Used to detect if we cleared the graphicsData.\n         *\n         * @member {number}\n         * @default 0\n         * @protected\n         */\n        _this.clearDirty = 0;\n        /**\n         * List of current draw calls drived from the batches.\n         *\n         * @member {object[]}\n         * @protected\n         */\n        _this.drawCalls = [];\n        /**\n         * Intermediate abstract format sent to batch system.\n         * Can be converted to drawCalls or to batchable objects.\n         *\n         * @member {PIXI.graphicsUtils.BatchPart[]}\n         * @protected\n         */\n        _this.batches = [];\n        /**\n         * Index of the last batched shape in the stack of calls.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.shapeIndex = 0;\n        /**\n         * Cached bounds.\n         *\n         * @member {PIXI.Bounds}\n         * @protected\n         */\n        _this._bounds = new _pixi_display__WEBPACK_IMPORTED_MODULE_4__.Bounds();\n        /**\n         * The bounds dirty flag.\n         *\n         * @member {number}\n         * @protected\n         */\n        _this.boundsDirty = -1;\n        /**\n         * Padding to add to the bounds.\n         *\n         * @member {number}\n         * @default 0\n         */\n        _this.boundsPadding = 0;\n        _this.batchable = false;\n        _this.indicesUint16 = null;\n        _this.uvsFloat32 = null;\n        /**\n         * Minimal distance between points that are considered different.\n         * Affects line tesselation.\n         *\n         * @member {number}\n         */\n        _this.closePointEps = 1e-4;\n        return _this;\n    }\n    Object.defineProperty(GraphicsGeometry.prototype, \"bounds\", {\n        /**\n         * Get the current bounds of the graphic geometry.\n         *\n         * @member {PIXI.Bounds}\n         * @readonly\n         */\n        get: function () {\n            if (this.boundsDirty !== this.dirty) {\n                this.boundsDirty = this.dirty;\n                this.calculateBounds();\n            }\n            return this._bounds;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Call if you changed graphicsData manually.\n     * Empties all batch buffers.\n     */\n    GraphicsGeometry.prototype.invalidate = function () {\n        this.boundsDirty = -1;\n        this.dirty++;\n        this.batchDirty++;\n        this.shapeIndex = 0;\n        this.points.length = 0;\n        this.colors.length = 0;\n        this.uvs.length = 0;\n        this.indices.length = 0;\n        this.textureIds.length = 0;\n        for (var i = 0; i < this.drawCalls.length; i++) {\n            this.drawCalls[i].texArray.clear();\n            DRAW_CALL_POOL.push(this.drawCalls[i]);\n        }\n        this.drawCalls.length = 0;\n        for (var i = 0; i < this.batches.length; i++) {\n            var batchPart = this.batches[i];\n            batchPart.reset();\n            BATCH_POOL.push(batchPart);\n        }\n        this.batches.length = 0;\n    };\n    /**\n     * Clears the graphics that were drawn to this Graphics object, and resets fill and line style settings.\n     *\n     * @return {PIXI.GraphicsGeometry} This GraphicsGeometry object. Good for chaining method calls\n     */\n    GraphicsGeometry.prototype.clear = function () {\n        if (this.graphicsData.length > 0) {\n            this.invalidate();\n            this.clearDirty++;\n            this.graphicsData.length = 0;\n        }\n        return this;\n    };\n    /**\n     * Draws the given shape to this Graphics object. Can be any of Circle, Rectangle, Ellipse, Line or Polygon.\n     *\n     * @param {PIXI.Circle|PIXI.Ellipse|PIXI.Polygon|PIXI.Rectangle|PIXI.RoundedRectangle} shape - The shape object to draw.\n     * @param {PIXI.FillStyle} fillStyle - Defines style of the fill.\n     * @param {PIXI.LineStyle} lineStyle - Defines style of the lines.\n     * @param {PIXI.Matrix} matrix - Transform applied to the points of the shape.\n     * @return {PIXI.GraphicsGeometry} Returns geometry for chaining.\n     */\n    GraphicsGeometry.prototype.drawShape = function (shape, fillStyle, lineStyle, matrix) {\n        if (fillStyle === void 0) { fillStyle = null; }\n        if (lineStyle === void 0) { lineStyle = null; }\n        if (matrix === void 0) { matrix = null; }\n        var data = new GraphicsData(shape, fillStyle, lineStyle, matrix);\n        this.graphicsData.push(data);\n        this.dirty++;\n        return this;\n    };\n    /**\n     * Draws the given shape to this Graphics object. Can be any of Circle, Rectangle, Ellipse, Line or Polygon.\n     *\n     * @param {PIXI.Circle|PIXI.Ellipse|PIXI.Polygon|PIXI.Rectangle|PIXI.RoundedRectangle} shape - The shape object to draw.\n     * @param {PIXI.Matrix} matrix - Transform applied to the points of the shape.\n     * @return {PIXI.GraphicsGeometry} Returns geometry for chaining.\n     */\n    GraphicsGeometry.prototype.drawHole = function (shape, matrix) {\n        if (matrix === void 0) { matrix = null; }\n        if (!this.graphicsData.length) {\n            return null;\n        }\n        var data = new GraphicsData(shape, null, null, matrix);\n        var lastShape = this.graphicsData[this.graphicsData.length - 1];\n        data.lineStyle = lastShape.lineStyle;\n        lastShape.holes.push(data);\n        this.dirty++;\n        return this;\n    };\n    /**\n     * Destroys the GraphicsGeometry object.\n     *\n     */\n    GraphicsGeometry.prototype.destroy = function () {\n        _super.prototype.destroy.call(this);\n        // destroy each of the GraphicsData objects\n        for (var i = 0; i < this.graphicsData.length; ++i) {\n            this.graphicsData[i].destroy();\n        }\n        this.points.length = 0;\n        this.points = null;\n        this.colors.length = 0;\n        this.colors = null;\n        this.uvs.length = 0;\n        this.uvs = null;\n        this.indices.length = 0;\n        this.indices = null;\n        this.indexBuffer.destroy();\n        this.indexBuffer = null;\n        this.graphicsData.length = 0;\n        this.graphicsData = null;\n        this.drawCalls.length = 0;\n        this.drawCalls = null;\n        this.batches.length = 0;\n        this.batches = null;\n        this._bounds = null;\n    };\n    /**\n     * Check to see if a point is contained within this geometry.\n     *\n     * @param {PIXI.IPointData} point - Point to check if it's contained.\n     * @return {Boolean} `true` if the point is contained within geometry.\n     */\n    GraphicsGeometry.prototype.containsPoint = function (point) {\n        var graphicsData = this.graphicsData;\n        for (var i = 0; i < graphicsData.length; ++i) {\n            var data = graphicsData[i];\n            if (!data.fillStyle.visible) {\n                continue;\n            }\n            // only deal with fills..\n            if (data.shape) {\n                if (data.matrix) {\n                    data.matrix.applyInverse(point, tmpPoint);\n                }\n                else {\n                    tmpPoint.copyFrom(point);\n                }\n                if (data.shape.contains(tmpPoint.x, tmpPoint.y)) {\n                    var hitHole = false;\n                    if (data.holes) {\n                        for (var i_1 = 0; i_1 < data.holes.length; i_1++) {\n                            var hole = data.holes[i_1];\n                            if (hole.shape.contains(tmpPoint.x, tmpPoint.y)) {\n                                hitHole = true;\n                                break;\n                            }\n                        }\n                    }\n                    if (!hitHole) {\n                        return true;\n                    }\n                }\n            }\n        }\n        return false;\n    };\n    /**\n     * Generates intermediate batch data. Either gets converted to drawCalls\n     * or used to convert to batch objects directly by the Graphics object.\n     *\n     * @param {boolean} [aloow32Indices] - Allow using 32-bit indices for preventings artefacts when more that 65535 vertices\n     */\n    GraphicsGeometry.prototype.updateBatches = function (allow32Indices) {\n        if (!this.graphicsData.length) {\n            this.batchable = true;\n            return;\n        }\n        if (!this.validateBatching()) {\n            return;\n        }\n        this.cacheDirty = this.dirty;\n        var uvs = this.uvs;\n        var graphicsData = this.graphicsData;\n        var batchPart = null;\n        var currentStyle = null;\n        if (this.batches.length > 0) {\n            batchPart = this.batches[this.batches.length - 1];\n            currentStyle = batchPart.style;\n        }\n        for (var i = this.shapeIndex; i < graphicsData.length; i++) {\n            this.shapeIndex++;\n            var data = graphicsData[i];\n            var fillStyle = data.fillStyle;\n            var lineStyle = data.lineStyle;\n            var command = FILL_COMMANDS[data.type];\n            // build out the shapes points..\n            command.build(data);\n            if (data.matrix) {\n                this.transformPoints(data.points, data.matrix);\n            }\n            for (var j = 0; j < 2; j++) {\n                var style = (j === 0) ? fillStyle : lineStyle;\n                if (!style.visible)\n                    { continue; }\n                var nextTexture = style.texture.baseTexture;\n                var index_1 = this.indices.length;\n                var attribIndex = this.points.length / 2;\n                nextTexture.wrapMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.WRAP_MODES.REPEAT;\n                if (j === 0) {\n                    this.processFill(data);\n                }\n                else {\n                    this.processLine(data);\n                }\n                var size = (this.points.length / 2) - attribIndex;\n                if (size === 0)\n                    { continue; }\n                // close batch if style is different\n                if (batchPart && !this._compareStyles(currentStyle, style)) {\n                    batchPart.end(index_1, attribIndex);\n                    batchPart = null;\n                }\n                // spawn new batch if its first batch or previous was closed\n                if (!batchPart) {\n                    batchPart = BATCH_POOL.pop() || new BatchPart();\n                    batchPart.begin(style, index_1, attribIndex);\n                    this.batches.push(batchPart);\n                    currentStyle = style;\n                }\n                this.addUvs(this.points, uvs, style.texture, attribIndex, size, style.matrix);\n            }\n        }\n        var index = this.indices.length;\n        var attrib = this.points.length / 2;\n        if (batchPart) {\n            batchPart.end(index, attrib);\n        }\n        if (this.batches.length === 0) {\n            // there are no visible styles in GraphicsData\n            // its possible that someone wants Graphics just for the bounds\n            this.batchable = true;\n            return;\n        }\n        // prevent allocation when length is same as buffer\n        if (this.indicesUint16 && this.indices.length === this.indicesUint16.length) {\n            this.indicesUint16.set(this.indices);\n        }\n        else {\n            var need32 = attrib > 0xffff && allow32Indices;\n            this.indicesUint16 = need32 ? new Uint32Array(this.indices) : new Uint16Array(this.indices);\n        }\n        // TODO make this a const..\n        this.batchable = this.isBatchable();\n        if (this.batchable) {\n            this.packBatches();\n        }\n        else {\n            this.buildDrawCalls();\n        }\n    };\n    /**\n     * Affinity check\n     *\n     * @param {PIXI.FillStyle | PIXI.LineStyle} styleA\n     * @param {PIXI.FillStyle | PIXI.LineStyle} styleB\n     */\n    GraphicsGeometry.prototype._compareStyles = function (styleA, styleB) {\n        if (!styleA || !styleB) {\n            return false;\n        }\n        if (styleA.texture.baseTexture !== styleB.texture.baseTexture) {\n            return false;\n        }\n        if (styleA.color + styleA.alpha !== styleB.color + styleB.alpha) {\n            return false;\n        }\n        if (!!styleA.native !== !!styleB.native) {\n            return false;\n        }\n        return true;\n    };\n    /**\n     * Test geometry for batching process.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.validateBatching = function () {\n        if (this.dirty === this.cacheDirty || !this.graphicsData.length) {\n            return false;\n        }\n        for (var i = 0, l = this.graphicsData.length; i < l; i++) {\n            var data = this.graphicsData[i];\n            var fill = data.fillStyle;\n            var line = data.lineStyle;\n            if (fill && !fill.texture.baseTexture.valid)\n                { return false; }\n            if (line && !line.texture.baseTexture.valid)\n                { return false; }\n        }\n        return true;\n    };\n    /**\n     * Offset the indices so that it works with the batcher.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.packBatches = function () {\n        this.batchDirty++;\n        this.uvsFloat32 = new Float32Array(this.uvs);\n        var batches = this.batches;\n        for (var i = 0, l = batches.length; i < l; i++) {\n            var batch = batches[i];\n            for (var j = 0; j < batch.size; j++) {\n                var index = batch.start + j;\n                this.indicesUint16[index] = this.indicesUint16[index] - batch.attribStart;\n            }\n        }\n    };\n    /**\n     * Checks to see if this graphics geometry can be batched.\n     * Currently it needs to be small enough and not contain any native lines.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.isBatchable = function () {\n        // prevent heavy mesh batching\n        if (this.points.length > 0xffff * 2) {\n            return false;\n        }\n        var batches = this.batches;\n        for (var i = 0; i < batches.length; i++) {\n            if (batches[i].style.native) {\n                return false;\n            }\n        }\n        return (this.points.length < GraphicsGeometry.BATCHABLE_SIZE * 2);\n    };\n    /**\n     * Converts intermediate batches data to drawCalls.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.buildDrawCalls = function () {\n        var TICK = ++_pixi_core__WEBPACK_IMPORTED_MODULE_0__.BaseTexture._globalBatch;\n        for (var i = 0; i < this.drawCalls.length; i++) {\n            this.drawCalls[i].texArray.clear();\n            DRAW_CALL_POOL.push(this.drawCalls[i]);\n        }\n        this.drawCalls.length = 0;\n        var colors = this.colors;\n        var textureIds = this.textureIds;\n        var currentGroup = DRAW_CALL_POOL.pop();\n        if (!currentGroup) {\n            currentGroup = new _pixi_core__WEBPACK_IMPORTED_MODULE_0__.BatchDrawCall();\n            currentGroup.texArray = new _pixi_core__WEBPACK_IMPORTED_MODULE_0__.BatchTextureArray();\n        }\n        currentGroup.texArray.count = 0;\n        currentGroup.start = 0;\n        currentGroup.size = 0;\n        currentGroup.type = _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.DRAW_MODES.TRIANGLES;\n        var textureCount = 0;\n        var currentTexture = null;\n        var textureId = 0;\n        var native = false;\n        var drawMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.DRAW_MODES.TRIANGLES;\n        var index = 0;\n        this.drawCalls.push(currentGroup);\n        // TODO - this can be simplified\n        for (var i = 0; i < this.batches.length; i++) {\n            var data = this.batches[i];\n            // TODO add some full on MAX_TEXTURE CODE..\n            var MAX_TEXTURES = 8;\n            // Forced cast for checking `native` without errors\n            var style = data.style;\n            var nextTexture = style.texture.baseTexture;\n            if (native !== !!style.native) {\n                native = !!style.native;\n                drawMode = native ? _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.DRAW_MODES.LINES : _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.DRAW_MODES.TRIANGLES;\n                // force the batch to break!\n                currentTexture = null;\n                textureCount = MAX_TEXTURES;\n                TICK++;\n            }\n            if (currentTexture !== nextTexture) {\n                currentTexture = nextTexture;\n                if (nextTexture._batchEnabled !== TICK) {\n                    if (textureCount === MAX_TEXTURES) {\n                        TICK++;\n                        textureCount = 0;\n                        if (currentGroup.size > 0) {\n                            currentGroup = DRAW_CALL_POOL.pop();\n                            if (!currentGroup) {\n                                currentGroup = new _pixi_core__WEBPACK_IMPORTED_MODULE_0__.BatchDrawCall();\n                                currentGroup.texArray = new _pixi_core__WEBPACK_IMPORTED_MODULE_0__.BatchTextureArray();\n                            }\n                            this.drawCalls.push(currentGroup);\n                        }\n                        currentGroup.start = index;\n                        currentGroup.size = 0;\n                        currentGroup.texArray.count = 0;\n                        currentGroup.type = drawMode;\n                    }\n                    // TODO add this to the render part..\n                    // Hack! Because texture has protected `touched`\n                    nextTexture.touched = 1; // touch;\n                    nextTexture._batchEnabled = TICK;\n                    nextTexture._batchLocation = textureCount;\n                    nextTexture.wrapMode = 10497;\n                    currentGroup.texArray.elements[currentGroup.texArray.count++] = nextTexture;\n                    textureCount++;\n                }\n            }\n            currentGroup.size += data.size;\n            index += data.size;\n            textureId = nextTexture._batchLocation;\n            this.addColors(colors, style.color, style.alpha, data.attribSize, data.attribStart);\n            this.addTextureIds(textureIds, textureId, data.attribSize, data.attribStart);\n        }\n        _pixi_core__WEBPACK_IMPORTED_MODULE_0__.BaseTexture._globalBatch = TICK;\n        // upload..\n        // merge for now!\n        this.packAttributes();\n    };\n    /**\n     * Packs attributes to single buffer.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.packAttributes = function () {\n        var verts = this.points;\n        var uvs = this.uvs;\n        var colors = this.colors;\n        var textureIds = this.textureIds;\n        // verts are 2 positions.. so we * by 3 as there are 6 properties.. then 4 cos its bytes\n        var glPoints = new ArrayBuffer(verts.length * 3 * 4);\n        var f32 = new Float32Array(glPoints);\n        var u32 = new Uint32Array(glPoints);\n        var p = 0;\n        for (var i = 0; i < verts.length / 2; i++) {\n            f32[p++] = verts[i * 2];\n            f32[p++] = verts[(i * 2) + 1];\n            f32[p++] = uvs[i * 2];\n            f32[p++] = uvs[(i * 2) + 1];\n            u32[p++] = colors[i];\n            f32[p++] = textureIds[i];\n        }\n        this._buffer.update(glPoints);\n        this._indexBuffer.update(this.indicesUint16);\n    };\n    /**\n     * Process fill part of Graphics.\n     *\n     * @param {PIXI.GraphicsData} data\n     * @protected\n     */\n    GraphicsGeometry.prototype.processFill = function (data) {\n        if (data.holes.length) {\n            this.processHoles(data.holes);\n            buildPoly.triangulate(data, this);\n        }\n        else {\n            var command = FILL_COMMANDS[data.type];\n            command.triangulate(data, this);\n        }\n    };\n    /**\n     * Process line part of Graphics.\n     *\n     * @param {PIXI.GraphicsData} data\n     * @protected\n     */\n    GraphicsGeometry.prototype.processLine = function (data) {\n        buildLine(data, this);\n        for (var i = 0; i < data.holes.length; i++) {\n            buildLine(data.holes[i], this);\n        }\n    };\n    /**\n     * Process the holes data.\n     *\n     * @param {PIXI.GraphicsData[]} holes - Holes to render\n     * @protected\n     */\n    GraphicsGeometry.prototype.processHoles = function (holes) {\n        for (var i = 0; i < holes.length; i++) {\n            var hole = holes[i];\n            var command = FILL_COMMANDS[hole.type];\n            command.build(hole);\n            if (hole.matrix) {\n                this.transformPoints(hole.points, hole.matrix);\n            }\n        }\n    };\n    /**\n     * Update the local bounds of the object. Expensive to use performance-wise.\n     *\n     * @protected\n     */\n    GraphicsGeometry.prototype.calculateBounds = function () {\n        var bounds = this._bounds;\n        var sequenceBounds = tmpBounds;\n        var curMatrix = _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Matrix.IDENTITY;\n        this._bounds.clear();\n        sequenceBounds.clear();\n        for (var i = 0; i < this.graphicsData.length; i++) {\n            var data = this.graphicsData[i];\n            var shape = data.shape;\n            var type = data.type;\n            var lineStyle = data.lineStyle;\n            var nextMatrix = data.matrix || _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Matrix.IDENTITY;\n            var lineWidth = 0.0;\n            if (lineStyle && lineStyle.visible) {\n                var alignment = lineStyle.alignment;\n                lineWidth = lineStyle.width;\n                if (type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.POLY) {\n                    lineWidth = lineWidth * (0.5 + Math.abs(0.5 - alignment));\n                }\n                else {\n                    lineWidth = lineWidth * Math.max(0, alignment);\n                }\n            }\n            if (curMatrix !== nextMatrix) {\n                if (!sequenceBounds.isEmpty()) {\n                    bounds.addBoundsMatrix(sequenceBounds, curMatrix);\n                    sequenceBounds.clear();\n                }\n                curMatrix = nextMatrix;\n            }\n            if (type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.RECT || type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.RREC) {\n                var rect = shape;\n                sequenceBounds.addFramePad(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, lineWidth, lineWidth);\n            }\n            else if (type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.CIRC) {\n                var circle = shape;\n                sequenceBounds.addFramePad(circle.x, circle.y, circle.x, circle.y, circle.radius + lineWidth, circle.radius + lineWidth);\n            }\n            else if (type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.ELIP) {\n                var ellipse = shape;\n                sequenceBounds.addFramePad(ellipse.x, ellipse.y, ellipse.x, ellipse.y, ellipse.width + lineWidth, ellipse.height + lineWidth);\n            }\n            else {\n                var poly = shape;\n                // adding directly to the bounds\n                bounds.addVerticesMatrix(curMatrix, poly.points, 0, poly.points.length, lineWidth, lineWidth);\n            }\n        }\n        if (!sequenceBounds.isEmpty()) {\n            bounds.addBoundsMatrix(sequenceBounds, curMatrix);\n        }\n        bounds.pad(this.boundsPadding, this.boundsPadding);\n    };\n    /**\n     * Transform points using matrix.\n     *\n     * @protected\n     * @param {number[]} points - Points to transform\n     * @param {PIXI.Matrix} matrix - Transform matrix\n     */\n    GraphicsGeometry.prototype.transformPoints = function (points, matrix) {\n        for (var i = 0; i < points.length / 2; i++) {\n            var x = points[(i * 2)];\n            var y = points[(i * 2) + 1];\n            points[(i * 2)] = (matrix.a * x) + (matrix.c * y) + matrix.tx;\n            points[(i * 2) + 1] = (matrix.b * x) + (matrix.d * y) + matrix.ty;\n        }\n    };\n    /**\n     * Add colors.\n     *\n     * @protected\n     * @param {number[]} colors - List of colors to add to\n     * @param {number} color - Color to add\n     * @param {number} alpha - Alpha to use\n     * @param {number} size - Number of colors to add\n     * @param {number} offset\n     */\n    GraphicsGeometry.prototype.addColors = function (colors, color, alpha, size, offset) {\n        if (offset === void 0) { offset = 0; }\n        // TODO use the premultiply bits Ivan added\n        var rgb = (color >> 16) + (color & 0xff00) + ((color & 0xff) << 16);\n        var rgba = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.premultiplyTint)(rgb, alpha);\n        colors.length = Math.max(colors.length, offset + size);\n        for (var i = 0; i < size; i++) {\n            colors[offset + i] = rgba;\n        }\n    };\n    /**\n     * Add texture id that the shader/fragment wants to use.\n     *\n     * @protected\n     * @param {number[]} textureIds\n     * @param {number} id\n     * @param {number} size\n     * @param {number} offset\n     */\n    GraphicsGeometry.prototype.addTextureIds = function (textureIds, id, size, offset) {\n        if (offset === void 0) { offset = 0; }\n        textureIds.length = Math.max(textureIds.length, offset + size);\n        for (var i = 0; i < size; i++) {\n            textureIds[offset + i] = id;\n        }\n    };\n    /**\n     * Generates the UVs for a shape.\n     *\n     * @protected\n     * @param {number[]} verts - Vertices\n     * @param {number[]} uvs - UVs\n     * @param {PIXI.Texture} texture - Reference to Texture\n     * @param {number} start - Index buffer start index.\n     * @param {number} size - The size/length for index buffer.\n     * @param {PIXI.Matrix} [matrix] - Optional transform for all points.\n     */\n    GraphicsGeometry.prototype.addUvs = function (verts, uvs, texture, start, size, matrix) {\n        if (matrix === void 0) { matrix = null; }\n        var index = 0;\n        var uvsStart = uvs.length;\n        var frame = texture.frame;\n        while (index < size) {\n            var x = verts[(start + index) * 2];\n            var y = verts[((start + index) * 2) + 1];\n            if (matrix) {\n                var nx = (matrix.a * x) + (matrix.c * y) + matrix.tx;\n                y = (matrix.b * x) + (matrix.d * y) + matrix.ty;\n                x = nx;\n            }\n            index++;\n            uvs.push(x / frame.width, y / frame.height);\n        }\n        var baseTexture = texture.baseTexture;\n        if (frame.width < baseTexture.width\n            || frame.height < baseTexture.height) {\n            this.adjustUvs(uvs, texture, uvsStart, size);\n        }\n    };\n    /**\n     * Modify uvs array according to position of texture region\n     * Does not work with rotated or trimmed textures\n     *\n     * @param {number[]} uvs - array\n     * @param {PIXI.Texture} texture - region\n     * @param {number} start - starting index for uvs\n     * @param {number} size - how many points to adjust\n     */\n    GraphicsGeometry.prototype.adjustUvs = function (uvs, texture, start, size) {\n        var baseTexture = texture.baseTexture;\n        var eps = 1e-6;\n        var finish = start + (size * 2);\n        var frame = texture.frame;\n        var scaleX = frame.width / baseTexture.width;\n        var scaleY = frame.height / baseTexture.height;\n        var offsetX = frame.x / frame.width;\n        var offsetY = frame.y / frame.height;\n        var minX = Math.floor(uvs[start] + eps);\n        var minY = Math.floor(uvs[start + 1] + eps);\n        for (var i = start + 2; i < finish; i += 2) {\n            minX = Math.min(minX, Math.floor(uvs[i] + eps));\n            minY = Math.min(minY, Math.floor(uvs[i + 1] + eps));\n        }\n        offsetX -= minX;\n        offsetY -= minY;\n        for (var i = start; i < finish; i += 2) {\n            uvs[i] = (uvs[i] + offsetX) * scaleX;\n            uvs[i + 1] = (uvs[i + 1] + offsetY) * scaleY;\n        }\n    };\n    /**\n     * The maximum number of points to consider an object \"batchable\",\n     * able to be batched by the renderer's batch system.\n     *\n     * @memberof PIXI.GraphicsGeometry\n     * @static\n     * @member {number} BATCHABLE_SIZE\n     * @default 100\n     */\n    GraphicsGeometry.BATCHABLE_SIZE = 100;\n    return GraphicsGeometry;\n}(_pixi_core__WEBPACK_IMPORTED_MODULE_0__.BatchGeometry));\n\n/**\n * Represents the line style for Graphics.\n * @memberof PIXI\n * @class\n * @extends PIXI.FillStyle\n */\nvar LineStyle = /** @class */ (function (_super) {\n    __extends(LineStyle, _super);\n    function LineStyle() {\n        var _this = _super !== null && _super.apply(this, arguments) || this;\n        /**\n         * The width (thickness) of any lines drawn.\n         *\n         * @member {number}\n         * @default 0\n         */\n        _this.width = 0;\n        /**\n         * The alignment of any lines drawn (0.5 = middle, 1 = outer, 0 = inner).\n         *\n         * @member {number}\n         * @default 0.5\n         */\n        _this.alignment = 0.5;\n        /**\n         * If true the lines will be draw using LINES instead of TRIANGLE_STRIP\n         *\n         * @member {boolean}\n         * @default false\n         */\n        _this.native = false;\n        /**\n         * Line cap style.\n         *\n         * @member {PIXI.LINE_CAP}\n         * @default PIXI.LINE_CAP.BUTT\n         */\n        _this.cap = LINE_CAP.BUTT;\n        /**\n         * Line join style.\n         *\n         * @member {PIXI.LINE_JOIN}\n         * @default PIXI.LINE_JOIN.MITER\n         */\n        _this.join = LINE_JOIN.MITER;\n        /**\n         * Miter limit.\n         *\n         * @member {number}\n         * @default 10\n         */\n        _this.miterLimit = 10;\n        return _this;\n    }\n    /**\n     * Clones the object\n     *\n     * @return {PIXI.LineStyle}\n     */\n    LineStyle.prototype.clone = function () {\n        var obj = new LineStyle();\n        obj.color = this.color;\n        obj.alpha = this.alpha;\n        obj.texture = this.texture;\n        obj.matrix = this.matrix;\n        obj.visible = this.visible;\n        obj.width = this.width;\n        obj.alignment = this.alignment;\n        obj.native = this.native;\n        obj.cap = this.cap;\n        obj.join = this.join;\n        obj.miterLimit = this.miterLimit;\n        return obj;\n    };\n    /**\n     * Reset the line style to default.\n     */\n    LineStyle.prototype.reset = function () {\n        _super.prototype.reset.call(this);\n        // Override default line style color\n        this.color = 0x0;\n        this.alignment = 0.5;\n        this.width = 0;\n        this.native = false;\n    };\n    return LineStyle;\n}(FillStyle));\n\nvar temp = new Float32Array(3);\n// a default shaders map used by graphics..\nvar DEFAULT_SHADERS = {};\n/**\n * The Graphics class contains methods used to draw primitive shapes such as lines, circles and\n * rectangles to the display, and to color and fill them.\n *\n * Note that because Graphics can share a GraphicsGeometry with other instances,\n * it is necessary to call `destroy()` to properly dereference the underlying\n * GraphicsGeometry and avoid a memory leak. Alternatively, keep using the same\n * Graphics instance and call `clear()` between redraws.\n *\n * @class\n * @extends PIXI.Container\n * @memberof PIXI\n */\nvar Graphics = /** @class */ (function (_super) {\n    __extends(Graphics, _super);\n    /**\n     * @param {PIXI.GraphicsGeometry} [geometry=null] - Geometry to use, if omitted\n     *        will create a new GraphicsGeometry instance.\n     */\n    function Graphics(geometry) {\n        if (geometry === void 0) { geometry = null; }\n        var _this = _super.call(this) || this;\n        _this._geometry = geometry || new GraphicsGeometry();\n        _this._geometry.refCount++;\n        /**\n         * Represents the vertex and fragment shaders that processes the geometry and runs on the GPU.\n         * Can be shared between multiple Graphics objects.\n         *\n         * @member {PIXI.Shader}\n         */\n        _this.shader = null;\n        /**\n         * Represents the WebGL state the Graphics required to render, excludes shader and geometry. E.g.,\n         * blend mode, culling, depth testing, direction of rendering triangles, backface, etc.\n         *\n         * @member {PIXI.State}\n         */\n        _this.state = _pixi_core__WEBPACK_IMPORTED_MODULE_0__.State.for2d();\n        /**\n         * Current fill style\n         *\n         * @member {PIXI.FillStyle}\n         * @protected\n         */\n        _this._fillStyle = new FillStyle();\n        /**\n         * Current line style\n         *\n         * @member {PIXI.LineStyle}\n         * @protected\n         */\n        _this._lineStyle = new LineStyle();\n        /**\n         * Current shape transform matrix.\n         *\n         * @member {PIXI.Matrix}\n         * @protected\n         */\n        _this._matrix = null;\n        /**\n         * Current hole mode is enabled.\n         *\n         * @member {boolean}\n         * @default false\n         * @protected\n         */\n        _this._holeMode = false;\n        /**\n         * Current path\n         *\n         * @member {PIXI.Polygon}\n         * @protected\n         */\n        _this.currentPath = null;\n        /**\n         * When cacheAsBitmap is set to true the graphics object will be rendered as if it was a sprite.\n         * This is useful if your graphics element does not change often, as it will speed up the rendering\n         * of the object in exchange for taking up texture memory. It is also useful if you need the graphics\n         * object to be anti-aliased, because it will be rendered using canvas. This is not recommended if\n         * you are constantly redrawing the graphics element.\n         *\n         * @name cacheAsBitmap\n         * @member {boolean}\n         * @memberof PIXI.Graphics#\n         * @default false\n         */\n        /**\n         * A collections of batches! These can be drawn by the renderer batch system.\n         *\n         * @protected\n         * @member {object[]}\n         */\n        _this.batches = [];\n        /**\n         * Update dirty for limiting calculating tints for batches.\n         *\n         * @protected\n         * @member {number}\n         * @default -1\n         */\n        _this.batchTint = -1;\n        /**\n         * Update dirty for limiting calculating batches.\n         *\n         * @protected\n         * @member {number}\n         * @default -1\n         */\n        _this.batchDirty = -1;\n        /**\n         * Copy of the object vertex data.\n         *\n         * @protected\n         * @member {Float32Array}\n         */\n        _this.vertexData = null;\n        /**\n         * Renderer plugin for batching\n         *\n         * @member {string}\n         * @default 'batch'\n         */\n        _this.pluginName = 'batch';\n        _this._transformID = -1;\n        // Set default\n        _this.tint = 0xFFFFFF;\n        _this.blendMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_3__.BLEND_MODES.NORMAL;\n        return _this;\n    }\n    Object.defineProperty(Graphics.prototype, \"geometry\", {\n        /**\n         * Includes vertex positions, face indices, normals, colors, UVs, and\n         * custom attributes within buffers, reducing the cost of passing all\n         * this data to the GPU. Can be shared between multiple Mesh or Graphics objects.\n         *\n         * @member {PIXI.GraphicsGeometry}\n         * @readonly\n         */\n        get: function () {\n            return this._geometry;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Creates a new Graphics object with the same values as this one.\n     * Note that only the geometry of the object is cloned, not its transform (position,scale,etc)\n     *\n     * @return {PIXI.Graphics} A clone of the graphics object\n     */\n    Graphics.prototype.clone = function () {\n        this.finishPoly();\n        return new Graphics(this._geometry);\n    };\n    Object.defineProperty(Graphics.prototype, \"blendMode\", {\n        get: function () {\n            return this.state.blendMode;\n        },\n        /**\n         * The blend mode to be applied to the graphic shape. Apply a value of\n         * `PIXI.BLEND_MODES.NORMAL` to reset the blend mode.\n         *\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NORMAL;\n         * @see PIXI.BLEND_MODES\n         */\n        set: function (value) {\n            this.state.blendMode = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Graphics.prototype, \"tint\", {\n        /**\n         * The tint applied to the graphic shape. This is a hex value. A value of\n         * 0xFFFFFF will remove any tint effect.\n         *\n         * @member {number}\n         * @default 0xFFFFFF\n         */\n        get: function () {\n            return this._tint;\n        },\n        set: function (value) {\n            this._tint = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Graphics.prototype, \"fill\", {\n        /**\n         * The current fill style.\n         *\n         * @member {PIXI.FillStyle}\n         * @readonly\n         */\n        get: function () {\n            return this._fillStyle;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Graphics.prototype, \"line\", {\n        /**\n         * The current line style.\n         *\n         * @member {PIXI.LineStyle}\n         * @readonly\n         */\n        get: function () {\n            return this._lineStyle;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Specifies the line style used for subsequent calls to Graphics methods such as the lineTo()\n     * method or the drawCircle() method.\n     *\n     * @method PIXI.Graphics#lineStyle\n     * @param {number} [width=0] - width of the line to draw, will update the objects stored style\n     * @param {number} [color=0x0] - color of the line to draw, will update the objects stored style\n     * @param {number} [alpha=1] - alpha of the line to draw, will update the objects stored style\n     * @param {number} [alignment=0.5] - alignment of the line to draw, (0 = inner, 0.5 = middle, 1 = outter)\n     * @param {boolean} [native=false] - If true the lines will be draw using LINES instead of TRIANGLE_STRIP\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    /**\n     * Specifies the line style used for subsequent calls to Graphics methods such as the lineTo()\n     * method or the drawCircle() method.\n     *\n     * @param {object} [options] - Line style options\n     * @param {number} [options.width=0] - width of the line to draw, will update the objects stored style\n     * @param {number} [options.color=0x0] - color of the line to draw, will update the objects stored style\n     * @param {number} [options.alpha=1] - alpha of the line to draw, will update the objects stored style\n     * @param {number} [options.alignment=0.5] - alignment of the line to draw, (0 = inner, 0.5 = middle, 1 = outter)\n     * @param {boolean} [options.native=false] - If true the lines will be draw using LINES instead of TRIANGLE_STRIP\n     * @param {PIXI.LINE_CAP}[options.cap=PIXI.LINE_CAP.BUTT] - line cap style\n     * @param {PIXI.LINE_JOIN}[options.join=PIXI.LINE_JOIN.MITER] - line join style\n     * @param {number}[options.miterLimit=10] - miter limit ratio\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.lineStyle = function (options) {\n        if (options === void 0) { options = null; }\n        // Support non-object params: (width, color, alpha, alignment, native)\n        if (typeof options === 'number') {\n            // eslint-disable-next-line\n            var args = arguments;\n            options = {\n                width: args[0] || 0,\n                color: args[1] || 0x0,\n                alpha: args[2] !== undefined ? args[2] : 1,\n                alignment: args[3] !== undefined ? args[3] : 0.5,\n                native: !!args[4],\n            };\n        }\n        return this.lineTextureStyle(options);\n    };\n    /**\n     * Like line style but support texture for line fill.\n     *\n     * @param {object} [options] - Collection of options for setting line style.\n     * @param {number} [options.width=0] - width of the line to draw, will update the objects stored style\n     * @param {PIXI.Texture} [options.texture=PIXI.Texture.WHITE] - Texture to use\n     * @param {number} [options.color=0x0] - color of the line to draw, will update the objects stored style.\n     *  Default 0xFFFFFF if texture present.\n     * @param {number} [options.alpha=1] - alpha of the line to draw, will update the objects stored style\n     * @param {PIXI.Matrix} [options.matrix=null] - Texture matrix to transform texture\n     * @param {number} [options.alignment=0.5] - alignment of the line to draw, (0 = inner, 0.5 = middle, 1 = outter)\n     * @param {boolean} [options.native=false] - If true the lines will be draw using LINES instead of TRIANGLE_STRIP\n     * @param {PIXI.LINE_CAP}[options.cap=PIXI.LINE_CAP.BUTT] - line cap style\n     * @param {PIXI.LINE_JOIN}[options.join=PIXI.LINE_JOIN.MITER] - line join style\n     * @param {number}[options.miterLimit=10] - miter limit ratio\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.lineTextureStyle = function (options) {\n        // backward compatibility with params: (width, texture,\n        // color, alpha, matrix, alignment, native)\n        if (typeof options === 'number') {\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.deprecation)('v5.2.0', 'Please use object-based options for Graphics#lineTextureStyle');\n            // eslint-disable-next-line\n            var _a = arguments, width = _a[0], texture = _a[1], color = _a[2], alpha = _a[3], matrix = _a[4], alignment = _a[5], native = _a[6];\n            options = { width: width, texture: texture, color: color, alpha: alpha, matrix: matrix, alignment: alignment, native: native };\n            // Remove undefined keys\n            Object.keys(options).forEach(function (key) { return options[key] === undefined && delete options[key]; });\n        }\n        // Apply defaults\n        options = Object.assign({\n            width: 0,\n            texture: _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture.WHITE,\n            color: (options && options.texture) ? 0xFFFFFF : 0x0,\n            alpha: 1,\n            matrix: null,\n            alignment: 0.5,\n            native: false,\n            cap: LINE_CAP.BUTT,\n            join: LINE_JOIN.MITER,\n            miterLimit: 10,\n        }, options);\n        if (this.currentPath) {\n            this.startPoly();\n        }\n        var visible = options.width > 0 && options.alpha > 0;\n        if (!visible) {\n            this._lineStyle.reset();\n        }\n        else {\n            if (options.matrix) {\n                options.matrix = options.matrix.clone();\n                options.matrix.invert();\n            }\n            Object.assign(this._lineStyle, { visible: visible }, options);\n        }\n        return this;\n    };\n    /**\n     * Start a polygon object internally\n     * @protected\n     */\n    Graphics.prototype.startPoly = function () {\n        if (this.currentPath) {\n            var points = this.currentPath.points;\n            var len = this.currentPath.points.length;\n            if (len > 2) {\n                this.drawShape(this.currentPath);\n                this.currentPath = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Polygon();\n                this.currentPath.closeStroke = false;\n                this.currentPath.points.push(points[len - 2], points[len - 1]);\n            }\n        }\n        else {\n            this.currentPath = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Polygon();\n            this.currentPath.closeStroke = false;\n        }\n    };\n    /**\n     * Finish the polygon object.\n     * @protected\n     */\n    Graphics.prototype.finishPoly = function () {\n        if (this.currentPath) {\n            if (this.currentPath.points.length > 2) {\n                this.drawShape(this.currentPath);\n                this.currentPath = null;\n            }\n            else {\n                this.currentPath.points.length = 0;\n            }\n        }\n    };\n    /**\n     * Moves the current drawing position to x, y.\n     *\n     * @param {number} x - the X coordinate to move to\n     * @param {number} y - the Y coordinate to move to\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.moveTo = function (x, y) {\n        this.startPoly();\n        this.currentPath.points[0] = x;\n        this.currentPath.points[1] = y;\n        return this;\n    };\n    /**\n     * Draws a line using the current line style from the current drawing position to (x, y);\n     * The current drawing position is then set to (x, y).\n     *\n     * @param {number} x - the X coordinate to draw to\n     * @param {number} y - the Y coordinate to draw to\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.lineTo = function (x, y) {\n        if (!this.currentPath) {\n            this.moveTo(0, 0);\n        }\n        // remove duplicates..\n        var points = this.currentPath.points;\n        var fromX = points[points.length - 2];\n        var fromY = points[points.length - 1];\n        if (fromX !== x || fromY !== y) {\n            points.push(x, y);\n        }\n        return this;\n    };\n    /**\n     * Initialize the curve\n     *\n     * @protected\n     * @param {number} [x=0]\n     * @param {number} [y=0]\n     */\n    Graphics.prototype._initCurve = function (x, y) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (this.currentPath) {\n            if (this.currentPath.points.length === 0) {\n                this.currentPath.points = [x, y];\n            }\n        }\n        else {\n            this.moveTo(x, y);\n        }\n    };\n    /**\n     * Calculate the points for a quadratic bezier curve and then draws it.\n     * Based on: https://stackoverflow.com/questions/785097/how-do-i-implement-a-bezier-curve-in-c\n     *\n     * @param {number} cpX - Control point x\n     * @param {number} cpY - Control point y\n     * @param {number} toX - Destination point x\n     * @param {number} toY - Destination point y\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.quadraticCurveTo = function (cpX, cpY, toX, toY) {\n        this._initCurve();\n        var points = this.currentPath.points;\n        if (points.length === 0) {\n            this.moveTo(0, 0);\n        }\n        QuadraticUtils.curveTo(cpX, cpY, toX, toY, points);\n        return this;\n    };\n    /**\n     * Calculate the points for a bezier curve and then draws it.\n     *\n     * @param {number} cpX - Control point x\n     * @param {number} cpY - Control point y\n     * @param {number} cpX2 - Second Control point x\n     * @param {number} cpY2 - Second Control point y\n     * @param {number} toX - Destination point x\n     * @param {number} toY - Destination point y\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.bezierCurveTo = function (cpX, cpY, cpX2, cpY2, toX, toY) {\n        this._initCurve();\n        BezierUtils.curveTo(cpX, cpY, cpX2, cpY2, toX, toY, this.currentPath.points);\n        return this;\n    };\n    /**\n     * The arcTo() method creates an arc/curve between two tangents on the canvas.\n     *\n     * \"borrowed\" from https://code.google.com/p/fxcanvas/ - thanks google!\n     *\n     * @param {number} x1 - The x-coordinate of the first tangent point of the arc\n     * @param {number} y1 - The y-coordinate of the first tangent point of the arc\n     * @param {number} x2 - The x-coordinate of the end of the arc\n     * @param {number} y2 - The y-coordinate of the end of the arc\n     * @param {number} radius - The radius of the arc\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.arcTo = function (x1, y1, x2, y2, radius) {\n        this._initCurve(x1, y1);\n        var points = this.currentPath.points;\n        var result = ArcUtils.curveTo(x1, y1, x2, y2, radius, points);\n        if (result) {\n            var cx = result.cx, cy = result.cy, radius_1 = result.radius, startAngle = result.startAngle, endAngle = result.endAngle, anticlockwise = result.anticlockwise;\n            this.arc(cx, cy, radius_1, startAngle, endAngle, anticlockwise);\n        }\n        return this;\n    };\n    /**\n     * The arc method creates an arc/curve (used to create circles, or parts of circles).\n     *\n     * @param {number} cx - The x-coordinate of the center of the circle\n     * @param {number} cy - The y-coordinate of the center of the circle\n     * @param {number} radius - The radius of the circle\n     * @param {number} startAngle - The starting angle, in radians (0 is at the 3 o'clock position\n     *  of the arc's circle)\n     * @param {number} endAngle - The ending angle, in radians\n     * @param {boolean} [anticlockwise=false] - Specifies whether the drawing should be\n     *  counter-clockwise or clockwise. False is default, and indicates clockwise, while true\n     *  indicates counter-clockwise.\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.arc = function (cx, cy, radius, startAngle, endAngle, anticlockwise) {\n        if (anticlockwise === void 0) { anticlockwise = false; }\n        if (startAngle === endAngle) {\n            return this;\n        }\n        if (!anticlockwise && endAngle <= startAngle) {\n            endAngle += _pixi_math__WEBPACK_IMPORTED_MODULE_1__.PI_2;\n        }\n        else if (anticlockwise && startAngle <= endAngle) {\n            startAngle += _pixi_math__WEBPACK_IMPORTED_MODULE_1__.PI_2;\n        }\n        var sweep = endAngle - startAngle;\n        if (sweep === 0) {\n            return this;\n        }\n        var startX = cx + (Math.cos(startAngle) * radius);\n        var startY = cy + (Math.sin(startAngle) * radius);\n        var eps = this._geometry.closePointEps;\n        // If the currentPath exists, take its points. Otherwise call `moveTo` to start a path.\n        var points = this.currentPath ? this.currentPath.points : null;\n        if (points) {\n            // TODO: make a better fix.\n            // We check how far our start is from the last existing point\n            var xDiff = Math.abs(points[points.length - 2] - startX);\n            var yDiff = Math.abs(points[points.length - 1] - startY);\n            if (xDiff < eps && yDiff < eps) ;\n            else {\n                points.push(startX, startY);\n            }\n        }\n        else {\n            this.moveTo(startX, startY);\n            points = this.currentPath.points;\n        }\n        ArcUtils.arc(startX, startY, cx, cy, radius, startAngle, endAngle, anticlockwise, points);\n        return this;\n    };\n    /**\n     * Specifies a simple one-color fill that subsequent calls to other Graphics methods\n     * (such as lineTo() or drawCircle()) use when drawing.\n     *\n     * @param {number} [color=0] - the color of the fill\n     * @param {number} [alpha=1] - the alpha of the fill\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.beginFill = function (color, alpha) {\n        if (color === void 0) { color = 0; }\n        if (alpha === void 0) { alpha = 1; }\n        return this.beginTextureFill({ texture: _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture.WHITE, color: color, alpha: alpha });\n    };\n    /**\n     * Begin the texture fill\n     *\n     * @param {object} [options] - Object object.\n     * @param {PIXI.Texture} [options.texture=PIXI.Texture.WHITE] - Texture to fill\n     * @param {number} [options.color=0xffffff] - Background to fill behind texture\n     * @param {number} [options.alpha=1] - Alpha of fill\n     * @param {PIXI.Matrix} [options.matrix=null] - Transform matrix\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.beginTextureFill = function (options) {\n        // backward compatibility with params: (texture, color, alpha, matrix)\n        if (options instanceof _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture) {\n            (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.deprecation)('v5.2.0', 'Please use object-based options for Graphics#beginTextureFill');\n            // eslint-disable-next-line\n            var _a = arguments, texture = _a[0], color = _a[1], alpha = _a[2], matrix = _a[3];\n            options = { texture: texture, color: color, alpha: alpha, matrix: matrix };\n            // Remove undefined keys\n            Object.keys(options).forEach(function (key) { return options[key] === undefined && delete options[key]; });\n        }\n        // Apply defaults\n        options = Object.assign({\n            texture: _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Texture.WHITE,\n            color: 0xFFFFFF,\n            alpha: 1,\n            matrix: null,\n        }, options);\n        if (this.currentPath) {\n            this.startPoly();\n        }\n        var visible = options.alpha > 0;\n        if (!visible) {\n            this._fillStyle.reset();\n        }\n        else {\n            if (options.matrix) {\n                options.matrix = options.matrix.clone();\n                options.matrix.invert();\n            }\n            Object.assign(this._fillStyle, { visible: visible }, options);\n        }\n        return this;\n    };\n    /**\n     * Applies a fill to the lines and shapes that were added since the last call to the beginFill() method.\n     *\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.endFill = function () {\n        this.finishPoly();\n        this._fillStyle.reset();\n        return this;\n    };\n    /**\n     * Draws a rectangle shape.\n     *\n     * @param {number} x - The X coord of the top-left of the rectangle\n     * @param {number} y - The Y coord of the top-left of the rectangle\n     * @param {number} width - The width of the rectangle\n     * @param {number} height - The height of the rectangle\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawRect = function (x, y, width, height) {\n        return this.drawShape(new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Rectangle(x, y, width, height));\n    };\n    /**\n     * Draw a rectangle shape with rounded/beveled corners.\n     *\n     * @param {number} x - The X coord of the top-left of the rectangle\n     * @param {number} y - The Y coord of the top-left of the rectangle\n     * @param {number} width - The width of the rectangle\n     * @param {number} height - The height of the rectangle\n     * @param {number} radius - Radius of the rectangle corners\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawRoundedRect = function (x, y, width, height, radius) {\n        return this.drawShape(new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.RoundedRectangle(x, y, width, height, radius));\n    };\n    /**\n     * Draws a circle.\n     *\n     * @param {number} x - The X coordinate of the center of the circle\n     * @param {number} y - The Y coordinate of the center of the circle\n     * @param {number} radius - The radius of the circle\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawCircle = function (x, y, radius) {\n        return this.drawShape(new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Circle(x, y, radius));\n    };\n    /**\n     * Draws an ellipse.\n     *\n     * @param {number} x - The X coordinate of the center of the ellipse\n     * @param {number} y - The Y coordinate of the center of the ellipse\n     * @param {number} width - The half width of the ellipse\n     * @param {number} height - The half height of the ellipse\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawEllipse = function (x, y, width, height) {\n        return this.drawShape(new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Ellipse(x, y, width, height));\n    };\n    /**\n     * Draws a polygon using the given path.\n     *\n     * @param {number[]|PIXI.Point[]|PIXI.Polygon} path - The path data used to construct the polygon.\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawPolygon = function () {\n        var arguments$1 = arguments;\n\n        var path = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            path[_i] = arguments$1[_i];\n        }\n        var points;\n        var closeStroke = true; // !!this._fillStyle;\n        var poly = path[0];\n        // check if data has points..\n        if (poly.points) {\n            closeStroke = poly.closeStroke;\n            points = poly.points;\n        }\n        else if (Array.isArray(path[0])) {\n            points = path[0];\n        }\n        else {\n            points = path;\n        }\n        var shape = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Polygon(points);\n        shape.closeStroke = closeStroke;\n        this.drawShape(shape);\n        return this;\n    };\n    /**\n     * Draw any shape.\n     *\n     * @param {PIXI.Circle|PIXI.Ellipse|PIXI.Polygon|PIXI.Rectangle|PIXI.RoundedRectangle} shape - Shape to draw\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawShape = function (shape) {\n        if (!this._holeMode) {\n            this._geometry.drawShape(shape, this._fillStyle.clone(), this._lineStyle.clone(), this._matrix);\n        }\n        else {\n            this._geometry.drawHole(shape, this._matrix);\n        }\n        return this;\n    };\n    /**\n     * Draw a star shape with an arbitrary number of points.\n     *\n     * @param {number} x - Center X position of the star\n     * @param {number} y - Center Y position of the star\n     * @param {number} points - The number of points of the star, must be > 1\n     * @param {number} radius - The outer radius of the star\n     * @param {number} [innerRadius] - The inner radius between points, default half `radius`\n     * @param {number} [rotation=0] - The rotation of the star in radians, where 0 is vertical\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.drawStar = function (x, y, points, radius, innerRadius, rotation) {\n        if (rotation === void 0) { rotation = 0; }\n        return this.drawPolygon(new Star(x, y, points, radius, innerRadius, rotation));\n    };\n    /**\n     * Clears the graphics that were drawn to this Graphics object, and resets fill and line style settings.\n     *\n     * @return {PIXI.Graphics} This Graphics object. Good for chaining method calls\n     */\n    Graphics.prototype.clear = function () {\n        this._geometry.clear();\n        this._lineStyle.reset();\n        this._fillStyle.reset();\n        this._boundsID++;\n        this._matrix = null;\n        this._holeMode = false;\n        this.currentPath = null;\n        return this;\n    };\n    /**\n     * True if graphics consists of one rectangle, and thus, can be drawn like a Sprite and\n     * masked with gl.scissor.\n     *\n     * @returns {boolean} True if only 1 rect.\n     */\n    Graphics.prototype.isFastRect = function () {\n        var data = this._geometry.graphicsData;\n        return data.length === 1\n            && data[0].shape.type === _pixi_math__WEBPACK_IMPORTED_MODULE_1__.SHAPES.RECT\n            && !(data[0].lineStyle.visible && data[0].lineStyle.width);\n    };\n    /**\n     * Renders the object using the WebGL renderer\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Graphics.prototype._render = function (renderer) {\n        this.finishPoly();\n        var geometry = this._geometry;\n        var hasuint32 = renderer.context.supports.uint32Indices;\n        // batch part..\n        // batch it!\n        geometry.updateBatches(hasuint32);\n        if (geometry.batchable) {\n            if (this.batchDirty !== geometry.batchDirty) {\n                this._populateBatches();\n            }\n            this._renderBatched(renderer);\n        }\n        else {\n            // no batching...\n            renderer.batch.flush();\n            this._renderDirect(renderer);\n        }\n    };\n    /**\n     * Populating batches for rendering\n     *\n     * @protected\n     */\n    Graphics.prototype._populateBatches = function () {\n        var geometry = this._geometry;\n        var blendMode = this.blendMode;\n        var len = geometry.batches.length;\n        this.batchTint = -1;\n        this._transformID = -1;\n        this.batchDirty = geometry.batchDirty;\n        this.batches.length = len;\n        this.vertexData = new Float32Array(geometry.points);\n        for (var i = 0; i < len; i++) {\n            var gI = geometry.batches[i];\n            var color = gI.style.color;\n            var vertexData = new Float32Array(this.vertexData.buffer, gI.attribStart * 4 * 2, gI.attribSize * 2);\n            var uvs = new Float32Array(geometry.uvsFloat32.buffer, gI.attribStart * 4 * 2, gI.attribSize * 2);\n            var indices = new Uint16Array(geometry.indicesUint16.buffer, gI.start * 2, gI.size);\n            var batch = {\n                vertexData: vertexData,\n                blendMode: blendMode,\n                indices: indices,\n                uvs: uvs,\n                _batchRGB: (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.hex2rgb)(color),\n                _tintRGB: color,\n                _texture: gI.style.texture,\n                alpha: gI.style.alpha,\n                worldAlpha: 1\n            };\n            this.batches[i] = batch;\n        }\n    };\n    /**\n     * Renders the batches using the BathedRenderer plugin\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Graphics.prototype._renderBatched = function (renderer) {\n        if (!this.batches.length) {\n            return;\n        }\n        renderer.batch.setObjectRenderer(renderer.plugins[this.pluginName]);\n        this.calculateVertices();\n        this.calculateTints();\n        for (var i = 0, l = this.batches.length; i < l; i++) {\n            var batch = this.batches[i];\n            batch.worldAlpha = this.worldAlpha * batch.alpha;\n            renderer.plugins[this.pluginName].render(batch);\n        }\n    };\n    /**\n     * Renders the graphics direct\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Graphics.prototype._renderDirect = function (renderer) {\n        var shader = this._resolveDirectShader(renderer);\n        var geometry = this._geometry;\n        var tint = this.tint;\n        var worldAlpha = this.worldAlpha;\n        var uniforms = shader.uniforms;\n        var drawCalls = geometry.drawCalls;\n        // lets set the transfomr\n        uniforms.translationMatrix = this.transform.worldTransform;\n        // and then lets set the tint..\n        uniforms.tint[0] = (((tint >> 16) & 0xFF) / 255) * worldAlpha;\n        uniforms.tint[1] = (((tint >> 8) & 0xFF) / 255) * worldAlpha;\n        uniforms.tint[2] = ((tint & 0xFF) / 255) * worldAlpha;\n        uniforms.tint[3] = worldAlpha;\n        // the first draw call, we can set the uniforms of the shader directly here.\n        // this means that we can tack advantage of the sync function of pixi!\n        // bind and sync uniforms..\n        // there is a way to optimise this..\n        renderer.shader.bind(shader);\n        renderer.geometry.bind(geometry, shader);\n        // set state..\n        renderer.state.set(this.state);\n        // then render the rest of them...\n        for (var i = 0, l = drawCalls.length; i < l; i++) {\n            this._renderDrawCallDirect(renderer, geometry.drawCalls[i]);\n        }\n    };\n    /**\n     * Renders specific DrawCall\n     *\n     * @param {PIXI.Renderer} renderer\n     * @param {PIXI.BatchDrawCall} drawCall\n     */\n    Graphics.prototype._renderDrawCallDirect = function (renderer, drawCall) {\n        var texArray = drawCall.texArray, type = drawCall.type, size = drawCall.size, start = drawCall.start;\n        var groupTextureCount = texArray.count;\n        for (var j = 0; j < groupTextureCount; j++) {\n            renderer.texture.bind(texArray.elements[j], j);\n        }\n        renderer.geometry.draw(type, size, start);\n    };\n    /**\n     * Resolves shader for direct rendering\n     *\n     * @protected\n     * @param {PIXI.Renderer} renderer - The renderer\n     */\n    Graphics.prototype._resolveDirectShader = function (renderer) {\n        var shader = this.shader;\n        var pluginName = this.pluginName;\n        if (!shader) {\n            // if there is no shader here, we can use the default shader.\n            // and that only gets created if we actually need it..\n            // but may be more than one plugins for graphics\n            if (!DEFAULT_SHADERS[pluginName]) {\n                var MAX_TEXTURES = renderer.plugins.batch.MAX_TEXTURES;\n                var sampleValues = new Int32Array(MAX_TEXTURES);\n                for (var i = 0; i < MAX_TEXTURES; i++) {\n                    sampleValues[i] = i;\n                }\n                var uniforms = {\n                    tint: new Float32Array([1, 1, 1, 1]),\n                    translationMatrix: new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Matrix(),\n                    default: _pixi_core__WEBPACK_IMPORTED_MODULE_0__.UniformGroup.from({ uSamplers: sampleValues }, true),\n                };\n                var program = renderer.plugins[pluginName]._shader.program;\n                DEFAULT_SHADERS[pluginName] = new _pixi_core__WEBPACK_IMPORTED_MODULE_0__.Shader(program, uniforms);\n            }\n            shader = DEFAULT_SHADERS[pluginName];\n        }\n        return shader;\n    };\n    /**\n     * Retrieves the bounds of the graphic shape as a rectangle object\n     *\n     * @protected\n     */\n    Graphics.prototype._calculateBounds = function () {\n        this.finishPoly();\n        var geometry = this._geometry;\n        // skipping when graphics is empty, like a container\n        if (!geometry.graphicsData.length) {\n            return;\n        }\n        var _a = geometry.bounds, minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;\n        this._bounds.addFrame(this.transform, minX, minY, maxX, maxY);\n    };\n    /**\n     * Tests if a point is inside this graphics object\n     *\n     * @param {PIXI.IPointData} point - the point to test\n     * @return {boolean} the result of the test\n     */\n    Graphics.prototype.containsPoint = function (point) {\n        this.worldTransform.applyInverse(point, Graphics._TEMP_POINT);\n        return this._geometry.containsPoint(Graphics._TEMP_POINT);\n    };\n    /**\n     * Recalcuate the tint by applying tin to batches using Graphics tint.\n     * @protected\n     */\n    Graphics.prototype.calculateTints = function () {\n        if (this.batchTint !== this.tint) {\n            this.batchTint = this.tint;\n            var tintRGB = (0,_pixi_utils__WEBPACK_IMPORTED_MODULE_2__.hex2rgb)(this.tint, temp);\n            for (var i = 0; i < this.batches.length; i++) {\n                var batch = this.batches[i];\n                var batchTint = batch._batchRGB;\n                var r = (tintRGB[0] * batchTint[0]) * 255;\n                var g = (tintRGB[1] * batchTint[1]) * 255;\n                var b = (tintRGB[2] * batchTint[2]) * 255;\n                // TODO Ivan, can this be done in one go?\n                var color = (r << 16) + (g << 8) + (b | 0);\n                batch._tintRGB = (color >> 16)\n                    + (color & 0xff00)\n                    + ((color & 0xff) << 16);\n            }\n        }\n    };\n    /**\n     * If there's a transform update or a change to the shape of the\n     * geometry, recaculate the vertices.\n     * @protected\n     */\n    Graphics.prototype.calculateVertices = function () {\n        var wtID = this.transform._worldID;\n        if (this._transformID === wtID) {\n            return;\n        }\n        this._transformID = wtID;\n        var wt = this.transform.worldTransform;\n        var a = wt.a;\n        var b = wt.b;\n        var c = wt.c;\n        var d = wt.d;\n        var tx = wt.tx;\n        var ty = wt.ty;\n        var data = this._geometry.points; // batch.vertexDataOriginal;\n        var vertexData = this.vertexData;\n        var count = 0;\n        for (var i = 0; i < data.length; i += 2) {\n            var x = data[i];\n            var y = data[i + 1];\n            vertexData[count++] = (a * x) + (c * y) + tx;\n            vertexData[count++] = (d * y) + (b * x) + ty;\n        }\n    };\n    /**\n     * Closes the current path.\n     *\n     * @return {PIXI.Graphics} Returns itself.\n     */\n    Graphics.prototype.closePath = function () {\n        var currentPath = this.currentPath;\n        if (currentPath) {\n            // we don't need to add extra point in the end because buildLine will take care of that\n            currentPath.closeStroke = true;\n        }\n        return this;\n    };\n    /**\n     * Apply a matrix to the positional data.\n     *\n     * @param {PIXI.Matrix} matrix - Matrix to use for transform current shape.\n     * @return {PIXI.Graphics} Returns itself.\n     */\n    Graphics.prototype.setMatrix = function (matrix) {\n        this._matrix = matrix;\n        return this;\n    };\n    /**\n     * Begin adding holes to the last draw shape\n     * IMPORTANT: holes must be fully inside a shape to work\n     * Also weirdness ensues if holes overlap!\n     * Ellipses, Circles, Rectangles and Rounded Rectangles cannot be holes or host for holes in CanvasRenderer,\n     * please use `moveTo` `lineTo`, `quadraticCurveTo` if you rely on pixi-legacy bundle.\n     * @return {PIXI.Graphics} Returns itself.\n     */\n    Graphics.prototype.beginHole = function () {\n        this.finishPoly();\n        this._holeMode = true;\n        return this;\n    };\n    /**\n     * End adding holes to the last draw shape\n     * @return {PIXI.Graphics} Returns itself.\n     */\n    Graphics.prototype.endHole = function () {\n        this.finishPoly();\n        this._holeMode = false;\n        return this;\n    };\n    /**\n     * Destroys the Graphics object.\n     *\n     * @param {object|boolean} [options] - Options parameter. A boolean will act as if all\n     *  options have been set to that value\n     * @param {boolean} [options.children=false] - if set to true, all the children will have\n     *  their destroy method called as well. 'options' will be passed on to those calls.\n     * @param {boolean} [options.texture=false] - Only used for child Sprites if options.children is set to true\n     *  Should it destroy the texture of the child sprite\n     * @param {boolean} [options.baseTexture=false] - Only used for child Sprites if options.children is set to true\n     *  Should it destroy the base texture of the child sprite\n     */\n    Graphics.prototype.destroy = function (options) {\n        this._geometry.refCount--;\n        if (this._geometry.refCount === 0) {\n            this._geometry.dispose();\n        }\n        this._matrix = null;\n        this.currentPath = null;\n        this._lineStyle.destroy();\n        this._lineStyle = null;\n        this._fillStyle.destroy();\n        this._fillStyle = null;\n        this._geometry = null;\n        this.shader = null;\n        this.vertexData = null;\n        this.batches.length = 0;\n        this.batches = null;\n        _super.prototype.destroy.call(this, options);\n    };\n    /**\n     * Temporary point to use for containsPoint\n     *\n     * @static\n     * @private\n     * @member {PIXI.Point}\n     */\n    Graphics._TEMP_POINT = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point();\n    return Graphics;\n}(_pixi_display__WEBPACK_IMPORTED_MODULE_4__.Container));\n\n\n//# sourceMappingURL=graphics.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/graphics/lib/graphics.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/interaction/lib/interaction.es.js":
/*!**************************************************************!*\
  !*** ./node_modules/@pixi/interaction/lib/interaction.es.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"InteractionData\": () => (/* binding */ InteractionData),\n/* harmony export */   \"InteractionEvent\": () => (/* binding */ InteractionEvent),\n/* harmony export */   \"InteractionManager\": () => (/* binding */ InteractionManager),\n/* harmony export */   \"InteractionTrackingData\": () => (/* binding */ InteractionTrackingData),\n/* harmony export */   \"interactiveTarget\": () => (/* binding */ interactiveTarget)\n/* harmony export */ });\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/* harmony import */ var _pixi_ticker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/ticker */ \"./node_modules/@pixi/ticker/lib/ticker.es.js\");\n/* harmony import */ var _pixi_display__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/display */ \"./node_modules/@pixi/display/lib/display.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/*!\n * @pixi/interaction - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/interaction is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n\n/**\n * Holds all information related to an Interaction event\n *\n * @class\n * @memberof PIXI\n */\nvar InteractionData = /** @class */ (function () {\n    function InteractionData() {\n        this.pressure = 0;\n        this.rotationAngle = 0;\n        this.twist = 0;\n        this.tangentialPressure = 0;\n        /**\n         * This point stores the global coords of where the touch/mouse event happened\n         *\n         * @member {PIXI.Point}\n         */\n        this.global = new _pixi_math__WEBPACK_IMPORTED_MODULE_0__.Point();\n        /**\n         * The target Sprite that was interacted with\n         *\n         * @member {PIXI.Sprite}\n         */\n        this.target = null;\n        /**\n         * When passed to an event handler, this will be the original DOM Event that was captured\n         *\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent\n         * @member {MouseEvent|TouchEvent|PointerEvent}\n         */\n        this.originalEvent = null;\n        /**\n         * Unique identifier for this interaction\n         *\n         * @member {number}\n         */\n        this.identifier = null;\n        /**\n         * Indicates whether or not the pointer device that created the event is the primary pointer.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/isPrimary\n         * @type {Boolean}\n         */\n        this.isPrimary = false;\n        /**\n         * Indicates which button was pressed on the mouse or pointer device to trigger the event.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/button\n         * @type {number}\n         */\n        this.button = 0;\n        /**\n         * Indicates which buttons are pressed on the mouse or pointer device when the event is triggered.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/buttons\n         * @type {number}\n         */\n        this.buttons = 0;\n        /**\n         * The width of the pointer's contact along the x-axis, measured in CSS pixels.\n         * radiusX of TouchEvents will be represented by this value.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/width\n         * @type {number}\n         */\n        this.width = 0;\n        /**\n         * The height of the pointer's contact along the y-axis, measured in CSS pixels.\n         * radiusY of TouchEvents will be represented by this value.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/height\n         * @type {number}\n         */\n        this.height = 0;\n        /**\n         * The angle, in degrees, between the pointer device and the screen.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/tiltX\n         * @type {number}\n         */\n        this.tiltX = 0;\n        /**\n         * The angle, in degrees, between the pointer device and the screen.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/tiltY\n         * @type {number}\n         */\n        this.tiltY = 0;\n        /**\n         * The type of pointer that triggered the event.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/pointerType\n         * @type {string}\n         */\n        this.pointerType = null;\n        /**\n         * Pressure applied by the pointing device during the event. A Touch's force property\n         * will be represented by this value.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/pressure\n         * @type {number}\n         */\n        this.pressure = 0;\n        /**\n         * From TouchEvents (not PointerEvents triggered by touches), the rotationAngle of the Touch.\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/Touch/rotationAngle\n         * @type {number}\n         */\n        this.rotationAngle = 0;\n        /**\n         * Twist of a stylus pointer.\n         * @see https://w3c.github.io/pointerevents/#pointerevent-interface\n         * @type {number}\n         */\n        this.twist = 0;\n        /**\n         * Barrel pressure on a stylus pointer.\n         * @see https://w3c.github.io/pointerevents/#pointerevent-interface\n         * @type {number}\n         */\n        this.tangentialPressure = 0;\n    }\n    Object.defineProperty(InteractionData.prototype, \"pointerId\", {\n        /**\n         * The unique identifier of the pointer. It will be the same as `identifier`.\n         * @readonly\n         * @member {number}\n         * @see https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/pointerId\n         */\n        get: function () {\n            return this.identifier;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * This will return the local coordinates of the specified displayObject for this InteractionData\n     *\n     * @param {PIXI.DisplayObject} displayObject - The DisplayObject that you would like the local\n     *  coords off\n     * @param {PIXI.Point} [point] - A Point object in which to store the value, optional (otherwise\n     *  will create a new point)\n     * @param {PIXI.Point} [globalPos] - A Point object containing your custom global coords, optional\n     *  (otherwise will use the current global coords)\n     * @return {PIXI.Point} A point containing the coordinates of the InteractionData position relative\n     *  to the DisplayObject\n     */\n    InteractionData.prototype.getLocalPosition = function (displayObject, point, globalPos) {\n        return displayObject.worldTransform.applyInverse(globalPos || this.global, point);\n    };\n    /**\n     * Copies properties from normalized event data.\n     *\n     * @param {Touch|MouseEvent|PointerEvent} event - The normalized event data\n     */\n    InteractionData.prototype.copyEvent = function (event) {\n        // isPrimary should only change on touchstart/pointerdown, so we don't want to overwrite\n        // it with \"false\" on later events when our shim for it on touch events might not be\n        // accurate\n        if ('isPrimary' in event && event.isPrimary) {\n            this.isPrimary = true;\n        }\n        this.button = 'button' in event && event.button;\n        // event.buttons is not available in all browsers (ie. Safari), but it does have a non-standard\n        // event.which property instead, which conveys the same information.\n        var buttons = 'buttons' in event && event.buttons;\n        this.buttons = Number.isInteger(buttons) ? buttons : 'which' in event && event.which;\n        this.width = 'width' in event && event.width;\n        this.height = 'height' in event && event.height;\n        this.tiltX = 'tiltX' in event && event.tiltX;\n        this.tiltY = 'tiltY' in event && event.tiltY;\n        this.pointerType = 'pointerType' in event && event.pointerType;\n        this.pressure = 'pressure' in event && event.pressure;\n        this.rotationAngle = 'rotationAngle' in event && event.rotationAngle;\n        this.twist = ('twist' in event && event.twist) || 0;\n        this.tangentialPressure = ('tangentialPressure' in event && event.tangentialPressure) || 0;\n    };\n    /**\n     * Resets the data for pooling.\n     */\n    InteractionData.prototype.reset = function () {\n        // isPrimary is the only property that we really need to reset - everything else is\n        // guaranteed to be overwritten\n        this.isPrimary = false;\n    };\n    return InteractionData;\n}());\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * Event class that mimics native DOM events.\n *\n * @class\n * @memberof PIXI\n */\nvar InteractionEvent = /** @class */ (function () {\n    function InteractionEvent() {\n        /**\n         * Whether this event will continue propagating in the tree.\n         *\n         * Remaining events for the {@link stopsPropagatingAt} object\n         * will still be dispatched.\n         *\n         * @member {boolean}\n         */\n        this.stopped = false;\n        /**\n         * At which object this event stops propagating.\n         *\n         * @private\n         * @member {PIXI.DisplayObject}\n         */\n        this.stopsPropagatingAt = null;\n        /**\n         * Whether we already reached the element we want to\n         * stop propagating at. This is important for delayed events,\n         * where we start over deeper in the tree again.\n         *\n         * @private\n         * @member {boolean}\n         */\n        this.stopPropagationHint = false;\n        /**\n         * The object which caused this event to be dispatched.\n         * For listener callback see {@link PIXI.InteractionEvent.currentTarget}.\n         *\n         * @member {PIXI.DisplayObject}\n         */\n        this.target = null;\n        /**\n         * The object whose event listener’s callback is currently being invoked.\n         *\n         * @member {PIXI.DisplayObject}\n         */\n        this.currentTarget = null;\n        /**\n         * Type of the event\n         *\n         * @member {string}\n         */\n        this.type = null;\n        /**\n         * InteractionData related to this event\n         *\n         * @member {PIXI.InteractionData}\n         */\n        this.data = null;\n    }\n    /**\n     * Prevents event from reaching any objects other than the current object.\n     *\n     */\n    InteractionEvent.prototype.stopPropagation = function () {\n        this.stopped = true;\n        this.stopPropagationHint = true;\n        this.stopsPropagatingAt = this.currentTarget;\n    };\n    /**\n     * Resets the event.\n     */\n    InteractionEvent.prototype.reset = function () {\n        this.stopped = false;\n        this.stopsPropagatingAt = null;\n        this.stopPropagationHint = false;\n        this.currentTarget = null;\n        this.target = null;\n    };\n    return InteractionEvent;\n}());\n\n/**\n * DisplayObjects with the {@link PIXI.interactiveTarget} mixin use this class to track interactions\n *\n * @class\n * @private\n * @memberof PIXI\n */\nvar InteractionTrackingData = /** @class */ (function () {\n    /**\n     * @param {number} pointerId - Unique pointer id of the event\n     * @private\n     */\n    function InteractionTrackingData(pointerId) {\n        this._pointerId = pointerId;\n        this._flags = InteractionTrackingData.FLAGS.NONE;\n    }\n    /**\n     *\n     * @private\n     * @param {number} flag - The interaction flag to set\n     * @param {boolean} yn - Should the flag be set or unset\n     */\n    InteractionTrackingData.prototype._doSet = function (flag, yn) {\n        if (yn) {\n            this._flags = this._flags | flag;\n        }\n        else {\n            this._flags = this._flags & (~flag);\n        }\n    };\n    Object.defineProperty(InteractionTrackingData.prototype, \"pointerId\", {\n        /**\n         * Unique pointer id of the event\n         *\n         * @readonly\n         * @private\n         * @member {number}\n         */\n        get: function () {\n            return this._pointerId;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionTrackingData.prototype, \"flags\", {\n        /**\n         * State of the tracking data, expressed as bit flags\n         *\n         * @private\n         * @member {number}\n         */\n        get: function () {\n            return this._flags;\n        },\n        set: function (flags) {\n            this._flags = flags;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionTrackingData.prototype, \"none\", {\n        /**\n         * Is the tracked event inactive (not over or down)?\n         *\n         * @private\n         * @member {number}\n         */\n        get: function () {\n            return this._flags === InteractionTrackingData.FLAGS.NONE;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionTrackingData.prototype, \"over\", {\n        /**\n         * Is the tracked event over the DisplayObject?\n         *\n         * @private\n         * @member {boolean}\n         */\n        get: function () {\n            return (this._flags & InteractionTrackingData.FLAGS.OVER) !== 0;\n        },\n        set: function (yn) {\n            this._doSet(InteractionTrackingData.FLAGS.OVER, yn);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionTrackingData.prototype, \"rightDown\", {\n        /**\n         * Did the right mouse button come down in the DisplayObject?\n         *\n         * @private\n         * @member {boolean}\n         */\n        get: function () {\n            return (this._flags & InteractionTrackingData.FLAGS.RIGHT_DOWN) !== 0;\n        },\n        set: function (yn) {\n            this._doSet(InteractionTrackingData.FLAGS.RIGHT_DOWN, yn);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionTrackingData.prototype, \"leftDown\", {\n        /**\n         * Did the left mouse button come down in the DisplayObject?\n         *\n         * @private\n         * @member {boolean}\n         */\n        get: function () {\n            return (this._flags & InteractionTrackingData.FLAGS.LEFT_DOWN) !== 0;\n        },\n        set: function (yn) {\n            this._doSet(InteractionTrackingData.FLAGS.LEFT_DOWN, yn);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    InteractionTrackingData.FLAGS = Object.freeze({\n        NONE: 0,\n        OVER: 1 << 0,\n        LEFT_DOWN: 1 << 1,\n        RIGHT_DOWN: 1 << 2,\n    });\n    return InteractionTrackingData;\n}());\n\n/**\n * Strategy how to search through stage tree for interactive objects\n *\n * @private\n * @class\n * @memberof PIXI\n */\nvar TreeSearch = /** @class */ (function () {\n    function TreeSearch() {\n        this._tempPoint = new _pixi_math__WEBPACK_IMPORTED_MODULE_0__.Point();\n    }\n    /**\n     * Recursive implementation for findHit\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - event containing the point that\n     *  is tested for collision\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - the displayObject\n     *  that will be hit test (recursively crawls its children)\n     * @param {Function} [func] - the function that will be called on each interactive object. The\n     *  interactionEvent, displayObject and hit will be passed to the function\n     * @param {boolean} [hitTest] - this indicates if the objects inside should be hit test against the point\n     * @param {boolean} [interactive] - Whether the displayObject is interactive\n     * @return {boolean} returns true if the displayObject hit the point\n     */\n    TreeSearch.prototype.recursiveFindHit = function (interactionEvent, displayObject, func, hitTest, interactive) {\n        if (!displayObject || !displayObject.visible) {\n            return false;\n        }\n        var point = interactionEvent.data.global;\n        // Took a little while to rework this function correctly! But now it is done and nice and optimized! ^_^\n        //\n        // This function will now loop through all objects and then only hit test the objects it HAS\n        // to, not all of them. MUCH faster..\n        // An object will be hit test if the following is true:\n        //\n        // 1: It is interactive.\n        // 2: It belongs to a parent that is interactive AND one of the parents children have not already been hit.\n        //\n        // As another little optimization once an interactive object has been hit we can carry on\n        // through the scenegraph, but we know that there will be no more hits! So we can avoid extra hit tests\n        // A final optimization is that an object is not hit test directly if a child has already been hit.\n        interactive = displayObject.interactive || interactive;\n        var hit = false;\n        var interactiveParent = interactive;\n        // Flag here can set to false if the event is outside the parents hitArea or mask\n        var hitTestChildren = true;\n        // If there is a hitArea, no need to test against anything else if the pointer is not within the hitArea\n        // There is also no longer a need to hitTest children.\n        if (displayObject.hitArea) {\n            if (hitTest) {\n                displayObject.worldTransform.applyInverse(point, this._tempPoint);\n                if (!displayObject.hitArea.contains(this._tempPoint.x, this._tempPoint.y)) {\n                    hitTest = false;\n                    hitTestChildren = false;\n                }\n                else {\n                    hit = true;\n                }\n            }\n            interactiveParent = false;\n        }\n        // If there is a mask, no need to hitTest against anything else if the pointer is not within the mask.\n        // We still want to hitTestChildren, however, to ensure a mouseout can still be generated.\n        // https://github.com/pixijs/pixi.js/issues/5135\n        else if (displayObject._mask) {\n            if (hitTest) {\n                if (!(displayObject._mask.containsPoint && displayObject._mask.containsPoint(point))) {\n                    hitTest = false;\n                }\n            }\n        }\n        // ** FREE TIP **! If an object is not interactive or has no buttons in it\n        // (such as a game scene!) set interactiveChildren to false for that displayObject.\n        // This will allow PixiJS to completely ignore and bypass checking the displayObjects children.\n        if (hitTestChildren && displayObject.interactiveChildren && displayObject.children) {\n            var children = displayObject.children;\n            for (var i = children.length - 1; i >= 0; i--) {\n                var child = children[i];\n                // time to get recursive.. if this function will return if something is hit..\n                var childHit = this.recursiveFindHit(interactionEvent, child, func, hitTest, interactiveParent);\n                if (childHit) {\n                    // its a good idea to check if a child has lost its parent.\n                    // this means it has been removed whilst looping so its best\n                    if (!child.parent) {\n                        continue;\n                    }\n                    // we no longer need to hit test any more objects in this container as we we\n                    // now know the parent has been hit\n                    interactiveParent = false;\n                    // If the child is interactive , that means that the object hit was actually\n                    // interactive and not just the child of an interactive object.\n                    // This means we no longer need to hit test anything else. We still need to run\n                    // through all objects, but we don't need to perform any hit tests.\n                    if (childHit) {\n                        if (interactionEvent.target) {\n                            hitTest = false;\n                        }\n                        hit = true;\n                    }\n                }\n            }\n        }\n        // no point running this if the item is not interactive or does not have an interactive parent.\n        if (interactive) {\n            // if we are hit testing (as in we have no hit any objects yet)\n            // We also don't need to worry about hit testing if once of the displayObjects children\n            // has already been hit - but only if it was interactive, otherwise we need to keep\n            // looking for an interactive child, just in case we hit one\n            if (hitTest && !interactionEvent.target) {\n                // already tested against hitArea if it is defined\n                if (!displayObject.hitArea && displayObject.containsPoint) {\n                    if (displayObject.containsPoint(point)) {\n                        hit = true;\n                    }\n                }\n            }\n            if (displayObject.interactive) {\n                if (hit && !interactionEvent.target) {\n                    interactionEvent.target = displayObject;\n                }\n                if (func) {\n                    func(interactionEvent, displayObject, !!hit);\n                }\n            }\n        }\n        return hit;\n    };\n    /**\n     * This function is provides a neat way of crawling through the scene graph and running a\n     * specified function on all interactive objects it finds. It will also take care of hit\n     * testing the interactive objects and passes the hit across in the function.\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - event containing the point that\n     *  is tested for collision\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - the displayObject\n     *  that will be hit test (recursively crawls its children)\n     * @param {Function} [func] - the function that will be called on each interactive object. The\n     *  interactionEvent, displayObject and hit will be passed to the function\n     * @param {boolean} [hitTest] - this indicates if the objects inside should be hit test against the point\n     * @return {boolean} returns true if the displayObject hit the point\n     */\n    TreeSearch.prototype.findHit = function (interactionEvent, displayObject, func, hitTest) {\n        this.recursiveFindHit(interactionEvent, displayObject, func, hitTest, false);\n    };\n    return TreeSearch;\n}());\n\n/**\n * Interface for classes that represent a hit area.\n *\n * It is implemented by the following classes:\n * - {@link PIXI.Circle}\n * - {@link PIXI.Ellipse}\n * - {@link PIXI.Polygon}\n * - {@link PIXI.RoundedRectangle}\n *\n * @interface IHitArea\n * @memberof PIXI\n */\n/**\n * Checks whether the x and y coordinates given are contained within this area\n *\n * @method\n * @name contains\n * @memberof PIXI.IHitArea#\n * @param {number} x - The X coordinate of the point to test\n * @param {number} y - The Y coordinate of the point to test\n * @return {boolean} Whether the x/y coordinates are within this area\n */\n/**\n * Default property values of interactive objects\n * Used by {@link PIXI.InteractionManager} to automatically give all DisplayObjects these properties\n *\n * @private\n * @name interactiveTarget\n * @type {Object}\n * @memberof PIXI\n * @example\n *      function MyObject() {}\n *\n *      Object.assign(\n *          DisplayObject.prototype,\n *          PIXI.interactiveTarget\n *      );\n */\nvar interactiveTarget = {\n    /**\n     * Enable interaction events for the DisplayObject. Touch, pointer and mouse\n     * events will not be emitted unless `interactive` is set to `true`.\n     *\n     * @example\n     * const sprite = new PIXI.Sprite(texture);\n     * sprite.interactive = true;\n     * sprite.on('tap', (event) => {\n     *    //handle event\n     * });\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     */\n    interactive: false,\n    /**\n     * Determines if the children to the displayObject can be clicked/touched\n     * Setting this to false allows PixiJS to bypass a recursive `hitTest` function\n     *\n     * @member {boolean}\n     * @memberof PIXI.Container#\n     */\n    interactiveChildren: true,\n    /**\n     * Interaction shape. Children will be hit first, then this shape will be checked.\n     * Setting this will cause this shape to be checked in hit tests rather than the displayObject's bounds.\n     *\n     * @example\n     * const sprite = new PIXI.Sprite(texture);\n     * sprite.interactive = true;\n     * sprite.hitArea = new PIXI.Rectangle(0, 0, 100, 100);\n     * @member {PIXI.IHitArea}\n     * @memberof PIXI.DisplayObject#\n     */\n    hitArea: null,\n    /**\n     * If enabled, the mouse cursor use the pointer behavior when hovered over the displayObject if it is interactive\n     * Setting this changes the 'cursor' property to `'pointer'`.\n     *\n     * @example\n     * const sprite = new PIXI.Sprite(texture);\n     * sprite.interactive = true;\n     * sprite.buttonMode = true;\n     * @member {boolean}\n     * @memberof PIXI.DisplayObject#\n     */\n    get buttonMode() {\n        return this.cursor === 'pointer';\n    },\n    set buttonMode(value) {\n        if (value) {\n            this.cursor = 'pointer';\n        }\n        else if (this.cursor === 'pointer') {\n            this.cursor = null;\n        }\n    },\n    /**\n     * This defines what cursor mode is used when the mouse cursor\n     * is hovered over the displayObject.\n     *\n     * @example\n     * const sprite = new PIXI.Sprite(texture);\n     * sprite.interactive = true;\n     * sprite.cursor = 'wait';\n     * @see https://developer.mozilla.org/en/docs/Web/CSS/cursor\n     *\n     * @member {string}\n     * @memberof PIXI.DisplayObject#\n     */\n    cursor: null,\n    /**\n     * Internal set of all active pointers, by identifier\n     *\n     * @member {Map<number, InteractionTrackingData>}\n     * @memberof PIXI.DisplayObject#\n     * @private\n     */\n    get trackedPointers() {\n        if (this._trackedPointers === undefined)\n            { this._trackedPointers = {}; }\n        return this._trackedPointers;\n    },\n    /**\n     * Map of all tracked pointers, by identifier. Use trackedPointers to access.\n     *\n     * @private\n     * @type {Map<number, InteractionTrackingData>}\n     */\n    _trackedPointers: undefined,\n};\n\n// Mix interactiveTarget into DisplayObject.prototype,\n// after deprecation has been handled\n_pixi_display__WEBPACK_IMPORTED_MODULE_2__.DisplayObject.mixin(interactiveTarget);\nvar MOUSE_POINTER_ID = 1;\n// helpers for hitTest() - only used inside hitTest()\nvar hitTestEvent = {\n    target: null,\n    data: {\n        global: null,\n    },\n};\n/**\n * The interaction manager deals with mouse, touch and pointer events.\n *\n * Any DisplayObject can be interactive if its `interactive` property is set to true.\n *\n * This manager also supports multitouch.\n *\n * An instance of this class is automatically created by default, and can be found at `renderer.plugins.interaction`\n *\n * @class\n * @extends PIXI.utils.EventEmitter\n * @memberof PIXI\n */\nvar InteractionManager = /** @class */ (function (_super) {\n    __extends(InteractionManager, _super);\n    /**\n     * @param {PIXI.CanvasRenderer|PIXI.Renderer} renderer - A reference to the current renderer\n     * @param {object} [options] - The options for the manager.\n     * @param {boolean} [options.autoPreventDefault=true] - Should the manager automatically prevent default browser actions.\n     * @param {number} [options.interactionFrequency=10] - Maximum requency (ms) at pointer over/out states will be checked.\n     * @param {number} [options.useSystemTicker=true] - Whether to add {@link tickerUpdate} to {@link PIXI.Ticker.system}.\n     */\n    function InteractionManager(renderer, options) {\n        var _this = _super.call(this) || this;\n        options = options || {};\n        /**\n         * The renderer this interaction manager works for.\n         *\n         * @member {PIXI.AbstractRenderer}\n         */\n        _this.renderer = renderer;\n        /**\n         * Should default browser actions automatically be prevented.\n         * Does not apply to pointer events for backwards compatibility\n         * preventDefault on pointer events stops mouse events from firing\n         * Thus, for every pointer event, there will always be either a mouse of touch event alongside it.\n         *\n         * @member {boolean}\n         * @default true\n         */\n        _this.autoPreventDefault = options.autoPreventDefault !== undefined ? options.autoPreventDefault : true;\n        /**\n         * Maximum requency in milliseconds at which pointer over/out states will be checked by {@link tickerUpdate}.\n         *\n         * @member {number}\n         * @default 10\n         */\n        _this.interactionFrequency = options.interactionFrequency || 10;\n        /**\n         * The mouse data\n         *\n         * @member {PIXI.InteractionData}\n         */\n        _this.mouse = new InteractionData();\n        _this.mouse.identifier = MOUSE_POINTER_ID;\n        // setting the mouse to start off far off screen will mean that mouse over does\n        //  not get called before we even move the mouse.\n        _this.mouse.global.set(-999999);\n        /**\n         * Actively tracked InteractionData\n         *\n         * @private\n         * @member {Object.<number,PIXI.InteractionData>}\n         */\n        _this.activeInteractionData = {};\n        _this.activeInteractionData[MOUSE_POINTER_ID] = _this.mouse;\n        /**\n         * Pool of unused InteractionData\n         *\n         * @private\n         * @member {PIXI.InteractionData[]}\n         */\n        _this.interactionDataPool = [];\n        /**\n         * An event data object to handle all the event tracking/dispatching\n         *\n         * @member {object}\n         */\n        _this.eventData = new InteractionEvent();\n        /**\n         * The DOM element to bind to.\n         *\n         * @protected\n         * @member {HTMLElement}\n         */\n        _this.interactionDOMElement = null;\n        /**\n         * This property determines if mousemove and touchmove events are fired only when the cursor\n         * is over the object.\n         * Setting to true will make things work more in line with how the DOM version works.\n         * Setting to false can make things easier for things like dragging\n         * It is currently set to false as this is how PixiJS used to work. This will be set to true in\n         * future versions of pixi.\n         *\n         * @member {boolean}\n         * @default false\n         */\n        _this.moveWhenInside = false;\n        /**\n         * Have events been attached to the dom element?\n         *\n         * @protected\n         * @member {boolean}\n         */\n        _this.eventsAdded = false;\n        /**\n         * Has the system ticker been added?\n         *\n         * @protected\n         * @member {boolean}\n         */\n        _this.tickerAdded = false;\n        /**\n         * Is the mouse hovering over the renderer?\n         *\n         * @protected\n         * @member {boolean}\n         */\n        _this.mouseOverRenderer = false;\n        /**\n         * Does the device support touch events\n         * https://www.w3.org/TR/touch-events/\n         *\n         * @readonly\n         * @member {boolean}\n         */\n        _this.supportsTouchEvents = 'ontouchstart' in window;\n        /**\n         * Does the device support pointer events\n         * https://www.w3.org/Submission/pointer-events/\n         *\n         * @readonly\n         * @member {boolean}\n         */\n        _this.supportsPointerEvents = !!window.PointerEvent;\n        // this will make it so that you don't have to call bind all the time\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerUp = _this.onPointerUp.bind(_this);\n        _this.processPointerUp = _this.processPointerUp.bind(_this);\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerCancel = _this.onPointerCancel.bind(_this);\n        _this.processPointerCancel = _this.processPointerCancel.bind(_this);\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerDown = _this.onPointerDown.bind(_this);\n        _this.processPointerDown = _this.processPointerDown.bind(_this);\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerMove = _this.onPointerMove.bind(_this);\n        _this.processPointerMove = _this.processPointerMove.bind(_this);\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerOut = _this.onPointerOut.bind(_this);\n        _this.processPointerOverOut = _this.processPointerOverOut.bind(_this);\n        /**\n         * @private\n         * @member {Function}\n         */\n        _this.onPointerOver = _this.onPointerOver.bind(_this);\n        /**\n         * Dictionary of how different cursor modes are handled. Strings are handled as CSS cursor\n         * values, objects are handled as dictionaries of CSS values for interactionDOMElement,\n         * and functions are called instead of changing the CSS.\n         * Default CSS cursor values are provided for 'default' and 'pointer' modes.\n         * @member {Object.<string, Object>}\n         */\n        _this.cursorStyles = {\n            default: 'inherit',\n            pointer: 'pointer',\n        };\n        /**\n         * The mode of the cursor that is being used.\n         * The value of this is a key from the cursorStyles dictionary.\n         *\n         * @member {string}\n         */\n        _this.currentCursorMode = null;\n        /**\n         * Internal cached let.\n         *\n         * @private\n         * @member {string}\n         */\n        _this.cursor = null;\n        /**\n         * The current resolution / device pixel ratio.\n         *\n         * @member {number}\n         * @default 1\n         */\n        _this.resolution = 1;\n        /**\n         * Delayed pointer events. Used to guarantee correct ordering of over/out events.\n         *\n         * @private\n         * @member {Array}\n         */\n        _this.delayedEvents = [];\n        /**\n         * TreeSearch component that is used to hitTest stage tree\n         *\n         * @private\n         * @member {PIXI.TreeSearch}\n         */\n        _this.search = new TreeSearch();\n        /**\n         * Used as a last rendered object in case renderer doesnt have _lastObjectRendered\n         * @member {DisplayObject}\n         * @private\n         */\n        _this._tempDisplayObject = new _pixi_display__WEBPACK_IMPORTED_MODULE_2__.TemporaryDisplayObject();\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is pressed on the display\n         * object.\n         *\n         * @event PIXI.InteractionManager#mousedown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is pressed\n         * on the display object.\n         *\n         * @event PIXI.InteractionManager#rightdown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is released over the display\n         * object.\n         *\n         * @event PIXI.InteractionManager#mouseup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is released\n         * over the display object.\n         *\n         * @event PIXI.InteractionManager#rightup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is pressed and released on\n         * the display object.\n         *\n         * @event PIXI.InteractionManager#click\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is pressed\n         * and released on the display object.\n         *\n         * @event PIXI.InteractionManager#rightclick\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is released outside the\n         * display object that initially registered a\n         * [mousedown]{@link PIXI.InteractionManager#event:mousedown}.\n         *\n         * @event PIXI.InteractionManager#mouseupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is released\n         * outside the display object that initially registered a\n         * [rightdown]{@link PIXI.InteractionManager#event:rightdown}.\n         *\n         * @event PIXI.InteractionManager#rightupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved while over the display object\n         *\n         * @event PIXI.InteractionManager#mousemove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved onto the display object\n         *\n         * @event PIXI.InteractionManager#mouseover\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved off the display object\n         *\n         * @event PIXI.InteractionManager#mouseout\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is pressed on the display object.\n         *\n         * @event PIXI.InteractionManager#pointerdown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is released over the display object.\n         * Not always fired when some buttons are held down while others are released. In those cases,\n         * use [mousedown]{@link PIXI.InteractionManager#event:mousedown} and\n         * [mouseup]{@link PIXI.InteractionManager#event:mouseup} instead.\n         *\n         * @event PIXI.InteractionManager#pointerup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when the operating system cancels a pointer event\n         *\n         * @event PIXI.InteractionManager#pointercancel\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is pressed and released on the display object.\n         *\n         * @event PIXI.InteractionManager#pointertap\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is released outside the display object that initially\n         * registered a [pointerdown]{@link PIXI.InteractionManager#event:pointerdown}.\n         *\n         * @event PIXI.InteractionManager#pointerupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved while over the display object\n         *\n         * @event PIXI.InteractionManager#pointermove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved onto the display object\n         *\n         * @event PIXI.InteractionManager#pointerover\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved off the display object\n         *\n         * @event PIXI.InteractionManager#pointerout\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is placed on the display object.\n         *\n         * @event PIXI.InteractionManager#touchstart\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is removed from the display object.\n         *\n         * @event PIXI.InteractionManager#touchend\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when the operating system cancels a touch\n         *\n         * @event PIXI.InteractionManager#touchcancel\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is placed and removed from the display object.\n         *\n         * @event PIXI.InteractionManager#tap\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is removed outside of the display object that initially\n         * registered a [touchstart]{@link PIXI.InteractionManager#event:touchstart}.\n         *\n         * @event PIXI.InteractionManager#touchendoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is moved along the display object.\n         *\n         * @event PIXI.InteractionManager#touchmove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is pressed on the display.\n         * object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mousedown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is pressed\n         * on the display object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#rightdown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is released over the display\n         * object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mouseup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is released\n         * over the display object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#rightup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is pressed and released on\n         * the display object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#click\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is pressed\n         * and released on the display object. DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#rightclick\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button (usually a mouse left-button) is released outside the\n         * display object that initially registered a\n         * [mousedown]{@link PIXI.DisplayObject#event:mousedown}.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mouseupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device secondary button (usually a mouse right-button) is released\n         * outside the display object that initially registered a\n         * [rightdown]{@link PIXI.DisplayObject#event:rightdown}.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#rightupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved while over the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mousemove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved onto the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mouseover\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device (usually a mouse) is moved off the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#mouseout\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is pressed on the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointerdown\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is released over the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointerup\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when the operating system cancels a pointer event.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointercancel\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is pressed and released on the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointertap\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device button is released outside the display object that initially\n         * registered a [pointerdown]{@link PIXI.DisplayObject#event:pointerdown}.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointerupoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved while over the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointermove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved onto the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointerover\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a pointer device is moved off the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#pointerout\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is placed on the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#touchstart\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is removed from the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#touchend\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when the operating system cancels a touch.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#touchcancel\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is placed and removed from the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#tap\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is removed outside of the display object that initially\n         * registered a [touchstart]{@link PIXI.DisplayObject#event:touchstart}.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#touchendoutside\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        /**\n         * Fired when a touch point is moved along the display object.\n         * DisplayObject's `interactive` property must be set to `true` to fire event.\n         *\n         * @event PIXI.DisplayObject#touchmove\n         * @param {PIXI.InteractionEvent} event - Interaction event\n         */\n        _this._useSystemTicker = options.useSystemTicker !== undefined ? options.useSystemTicker : true;\n        _this.setTargetElement(_this.renderer.view, _this.renderer.resolution);\n        return _this;\n    }\n    Object.defineProperty(InteractionManager.prototype, \"useSystemTicker\", {\n        /**\n         * Should the InteractionManager automatically add {@link tickerUpdate} to {@link PIXI.Ticker.system}.\n         *\n         * @member {boolean}\n         * @default true\n         */\n        get: function () {\n            return this._useSystemTicker;\n        },\n        set: function (useSystemTicker) {\n            this._useSystemTicker = useSystemTicker;\n            if (useSystemTicker) {\n                this.addTickerListener();\n            }\n            else {\n                this.removeTickerListener();\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(InteractionManager.prototype, \"lastObjectRendered\", {\n        /**\n         * Last rendered object or temp object\n         * @readonly\n         * @protected\n         * @member {PIXI.DisplayObject}\n         */\n        get: function () {\n            return this.renderer._lastObjectRendered || this._tempDisplayObject;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Hit tests a point against the display tree, returning the first interactive object that is hit.\n     *\n     * @param {PIXI.Point} globalPoint - A point to hit test with, in global space.\n     * @param {PIXI.Container} [root] - The root display object to start from. If omitted, defaults\n     * to the last rendered root of the associated renderer.\n     * @return {PIXI.DisplayObject} The hit display object, if any.\n     */\n    InteractionManager.prototype.hitTest = function (globalPoint, root) {\n        // clear the target for our hit test\n        hitTestEvent.target = null;\n        // assign the global point\n        hitTestEvent.data.global = globalPoint;\n        // ensure safety of the root\n        if (!root) {\n            root = this.lastObjectRendered;\n        }\n        // run the hit test\n        this.processInteractive(hitTestEvent, root, null, true);\n        // return our found object - it'll be null if we didn't hit anything\n        return hitTestEvent.target;\n    };\n    /**\n     * Sets the DOM element which will receive mouse/touch events. This is useful for when you have\n     * other DOM elements on top of the renderers Canvas element. With this you'll be bale to delegate\n     * another DOM element to receive those events.\n     *\n     * @param {HTMLElement} element - the DOM element which will receive mouse and touch events.\n     * @param {number} [resolution=1] - The resolution / device pixel ratio of the new element (relative to the canvas).\n     */\n    InteractionManager.prototype.setTargetElement = function (element, resolution) {\n        if (resolution === void 0) { resolution = 1; }\n        this.removeTickerListener();\n        this.removeEvents();\n        this.interactionDOMElement = element;\n        this.resolution = resolution;\n        this.addEvents();\n        this.addTickerListener();\n    };\n    /**\n     * Add the ticker listener\n     *\n     * @private\n     */\n    InteractionManager.prototype.addTickerListener = function () {\n        if (this.tickerAdded || !this.interactionDOMElement || !this._useSystemTicker) {\n            return;\n        }\n        _pixi_ticker__WEBPACK_IMPORTED_MODULE_1__.Ticker.system.add(this.tickerUpdate, this, _pixi_ticker__WEBPACK_IMPORTED_MODULE_1__.UPDATE_PRIORITY.INTERACTION);\n        this.tickerAdded = true;\n    };\n    /**\n     * Remove the ticker listener\n     *\n     * @private\n     */\n    InteractionManager.prototype.removeTickerListener = function () {\n        if (!this.tickerAdded) {\n            return;\n        }\n        _pixi_ticker__WEBPACK_IMPORTED_MODULE_1__.Ticker.system.remove(this.tickerUpdate, this);\n        this.tickerAdded = false;\n    };\n    /**\n     * Registers all the DOM events\n     *\n     * @private\n     */\n    InteractionManager.prototype.addEvents = function () {\n        if (this.eventsAdded || !this.interactionDOMElement) {\n            return;\n        }\n        var style = this.interactionDOMElement.style;\n        if (window.navigator.msPointerEnabled) {\n            style.msContentZooming = 'none';\n            style.msTouchAction = 'none';\n        }\n        else if (this.supportsPointerEvents) {\n            style.touchAction = 'none';\n        }\n        /**\n         * These events are added first, so that if pointer events are normalized, they are fired\n         * in the same order as non-normalized events. ie. pointer event 1st, mouse / touch 2nd\n         */\n        if (this.supportsPointerEvents) {\n            window.document.addEventListener('pointermove', this.onPointerMove, true);\n            this.interactionDOMElement.addEventListener('pointerdown', this.onPointerDown, true);\n            // pointerout is fired in addition to pointerup (for touch events) and pointercancel\n            // we already handle those, so for the purposes of what we do in onPointerOut, we only\n            // care about the pointerleave event\n            this.interactionDOMElement.addEventListener('pointerleave', this.onPointerOut, true);\n            this.interactionDOMElement.addEventListener('pointerover', this.onPointerOver, true);\n            window.addEventListener('pointercancel', this.onPointerCancel, true);\n            window.addEventListener('pointerup', this.onPointerUp, true);\n        }\n        else {\n            window.document.addEventListener('mousemove', this.onPointerMove, true);\n            this.interactionDOMElement.addEventListener('mousedown', this.onPointerDown, true);\n            this.interactionDOMElement.addEventListener('mouseout', this.onPointerOut, true);\n            this.interactionDOMElement.addEventListener('mouseover', this.onPointerOver, true);\n            window.addEventListener('mouseup', this.onPointerUp, true);\n        }\n        // always look directly for touch events so that we can provide original data\n        // In a future version we should change this to being just a fallback and rely solely on\n        // PointerEvents whenever available\n        if (this.supportsTouchEvents) {\n            this.interactionDOMElement.addEventListener('touchstart', this.onPointerDown, true);\n            this.interactionDOMElement.addEventListener('touchcancel', this.onPointerCancel, true);\n            this.interactionDOMElement.addEventListener('touchend', this.onPointerUp, true);\n            this.interactionDOMElement.addEventListener('touchmove', this.onPointerMove, true);\n        }\n        this.eventsAdded = true;\n    };\n    /**\n     * Removes all the DOM events that were previously registered\n     *\n     * @private\n     */\n    InteractionManager.prototype.removeEvents = function () {\n        if (!this.eventsAdded || !this.interactionDOMElement) {\n            return;\n        }\n        var style = this.interactionDOMElement.style;\n        if (window.navigator.msPointerEnabled) {\n            style.msContentZooming = '';\n            style.msTouchAction = '';\n        }\n        else if (this.supportsPointerEvents) {\n            style.touchAction = '';\n        }\n        if (this.supportsPointerEvents) {\n            window.document.removeEventListener('pointermove', this.onPointerMove, true);\n            this.interactionDOMElement.removeEventListener('pointerdown', this.onPointerDown, true);\n            this.interactionDOMElement.removeEventListener('pointerleave', this.onPointerOut, true);\n            this.interactionDOMElement.removeEventListener('pointerover', this.onPointerOver, true);\n            window.removeEventListener('pointercancel', this.onPointerCancel, true);\n            window.removeEventListener('pointerup', this.onPointerUp, true);\n        }\n        else {\n            window.document.removeEventListener('mousemove', this.onPointerMove, true);\n            this.interactionDOMElement.removeEventListener('mousedown', this.onPointerDown, true);\n            this.interactionDOMElement.removeEventListener('mouseout', this.onPointerOut, true);\n            this.interactionDOMElement.removeEventListener('mouseover', this.onPointerOver, true);\n            window.removeEventListener('mouseup', this.onPointerUp, true);\n        }\n        if (this.supportsTouchEvents) {\n            this.interactionDOMElement.removeEventListener('touchstart', this.onPointerDown, true);\n            this.interactionDOMElement.removeEventListener('touchcancel', this.onPointerCancel, true);\n            this.interactionDOMElement.removeEventListener('touchend', this.onPointerUp, true);\n            this.interactionDOMElement.removeEventListener('touchmove', this.onPointerMove, true);\n        }\n        this.interactionDOMElement = null;\n        this.eventsAdded = false;\n    };\n    /**\n     * Updates the state of interactive objects if at least {@link interactionFrequency}\n     * milliseconds have passed since the last invocation.\n     *\n     * Invoked by a throttled ticker update from {@link PIXI.Ticker.system}.\n     *\n     * @param {number} deltaTime - time delta since the last call\n     */\n    InteractionManager.prototype.tickerUpdate = function (deltaTime) {\n        this._deltaTime += deltaTime;\n        if (this._deltaTime < this.interactionFrequency) {\n            return;\n        }\n        this._deltaTime = 0;\n        this.update();\n    };\n    /**\n     * Updates the state of interactive objects.\n     */\n    InteractionManager.prototype.update = function () {\n        if (!this.interactionDOMElement) {\n            return;\n        }\n        // if the user move the mouse this check has already been done using the mouse move!\n        if (this._didMove) {\n            this._didMove = false;\n            return;\n        }\n        this.cursor = null;\n        // Resets the flag as set by a stopPropagation call. This flag is usually reset by a user interaction of any kind,\n        // but there was a scenario of a display object moving under a static mouse cursor.\n        // In this case, mouseover and mouseevents would not pass the flag test in dispatchEvent function\n        for (var k in this.activeInteractionData) {\n            // eslint-disable-next-line no-prototype-builtins\n            if (this.activeInteractionData.hasOwnProperty(k)) {\n                var interactionData = this.activeInteractionData[k];\n                if (interactionData.originalEvent && interactionData.pointerType !== 'touch') {\n                    var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, interactionData.originalEvent, interactionData);\n                    this.processInteractive(interactionEvent, this.lastObjectRendered, this.processPointerOverOut, true);\n                }\n            }\n        }\n        this.setCursorMode(this.cursor);\n    };\n    /**\n     * Sets the current cursor mode, handling any callbacks or CSS style changes.\n     *\n     * @param {string} mode - cursor mode, a key from the cursorStyles dictionary\n     */\n    InteractionManager.prototype.setCursorMode = function (mode) {\n        mode = mode || 'default';\n        // if the mode didn't actually change, bail early\n        if (this.currentCursorMode === mode) {\n            return;\n        }\n        this.currentCursorMode = mode;\n        var style = this.cursorStyles[mode];\n        // only do things if there is a cursor style for it\n        if (style) {\n            switch (typeof style) {\n                case 'string':\n                    // string styles are handled as cursor CSS\n                    this.interactionDOMElement.style.cursor = style;\n                    break;\n                case 'function':\n                    // functions are just called, and passed the cursor mode\n                    style(mode);\n                    break;\n                case 'object':\n                    // if it is an object, assume that it is a dictionary of CSS styles,\n                    // apply it to the interactionDOMElement\n                    Object.assign(this.interactionDOMElement.style, style);\n                    break;\n            }\n        }\n        else if (typeof mode === 'string' && !Object.prototype.hasOwnProperty.call(this.cursorStyles, mode)) {\n            // if it mode is a string (not a Symbol) and cursorStyles doesn't have any entry\n            // for the mode, then assume that the dev wants it to be CSS for the cursor.\n            this.interactionDOMElement.style.cursor = mode;\n        }\n    };\n    /**\n     * Dispatches an event on the display object that was interacted with\n     *\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - the display object in question\n     * @param {string} eventString - the name of the event (e.g, mousedown)\n     * @param {PIXI.InteractionEvent} eventData - the event data object\n     * @private\n     */\n    InteractionManager.prototype.dispatchEvent = function (displayObject, eventString, eventData) {\n        // Even if the event was stopped, at least dispatch any remaining events\n        // for the same display object.\n        if (!eventData.stopPropagationHint || displayObject === eventData.stopsPropagatingAt) {\n            eventData.currentTarget = displayObject;\n            eventData.type = eventString;\n            displayObject.emit(eventString, eventData);\n            if (displayObject[eventString]) {\n                displayObject[eventString](eventData);\n            }\n        }\n    };\n    /**\n     * Puts a event on a queue to be dispatched later. This is used to guarantee correct\n     * ordering of over/out events.\n     *\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - the display object in question\n     * @param {string} eventString - the name of the event (e.g, mousedown)\n     * @param {object} eventData - the event data object\n     * @private\n     */\n    InteractionManager.prototype.delayDispatchEvent = function (displayObject, eventString, eventData) {\n        this.delayedEvents.push({ displayObject: displayObject, eventString: eventString, eventData: eventData });\n    };\n    /**\n     * Maps x and y coords from a DOM object and maps them correctly to the PixiJS view. The\n     * resulting value is stored in the point. This takes into account the fact that the DOM\n     * element could be scaled and positioned anywhere on the screen.\n     *\n     * @param  {PIXI.IPointData} point - the point that the result will be stored in\n     * @param  {number} x - the x coord of the position to map\n     * @param  {number} y - the y coord of the position to map\n     */\n    InteractionManager.prototype.mapPositionToPoint = function (point, x, y) {\n        var rect;\n        // IE 11 fix\n        if (!this.interactionDOMElement.parentElement) {\n            rect = { x: 0, y: 0, width: 0, height: 0 };\n        }\n        else {\n            rect = this.interactionDOMElement.getBoundingClientRect();\n        }\n        var resolutionMultiplier = 1.0 / this.resolution;\n        point.x = ((x - rect.left) * (this.interactionDOMElement.width / rect.width)) * resolutionMultiplier;\n        point.y = ((y - rect.top) * (this.interactionDOMElement.height / rect.height)) * resolutionMultiplier;\n    };\n    /**\n     * This function is provides a neat way of crawling through the scene graph and running a\n     * specified function on all interactive objects it finds. It will also take care of hit\n     * testing the interactive objects and passes the hit across in the function.\n     *\n     * @protected\n     * @param {PIXI.InteractionEvent} interactionEvent - event containing the point that\n     *  is tested for collision\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - the displayObject\n     *  that will be hit test (recursively crawls its children)\n     * @param {Function} [func] - the function that will be called on each interactive object. The\n     *  interactionEvent, displayObject and hit will be passed to the function\n     * @param {boolean} [hitTest] - indicates whether we want to calculate hits\n     *  or just iterate through all interactive objects\n     */\n    InteractionManager.prototype.processInteractive = function (interactionEvent, displayObject, func, hitTest) {\n        var hit = this.search.findHit(interactionEvent, displayObject, func, hitTest);\n        var delayedEvents = this.delayedEvents;\n        if (!delayedEvents.length) {\n            return hit;\n        }\n        // Reset the propagation hint, because we start deeper in the tree again.\n        interactionEvent.stopPropagationHint = false;\n        var delayedLen = delayedEvents.length;\n        this.delayedEvents = [];\n        for (var i = 0; i < delayedLen; i++) {\n            var _a = delayedEvents[i], displayObject_1 = _a.displayObject, eventString = _a.eventString, eventData = _a.eventData;\n            // When we reach the object we wanted to stop propagating at,\n            // set the propagation hint.\n            if (eventData.stopsPropagatingAt === displayObject_1) {\n                eventData.stopPropagationHint = true;\n            }\n            this.dispatchEvent(displayObject_1, eventString, eventData);\n        }\n        return hit;\n    };\n    /**\n     * Is called when the pointer button is pressed down on the renderer element\n     *\n     * @private\n     * @param {PointerEvent} originalEvent - The DOM event of a pointer button being pressed down\n     */\n    InteractionManager.prototype.onPointerDown = function (originalEvent) {\n        // if we support touch events, then only use those for touch events, not pointer events\n        if (this.supportsTouchEvents && originalEvent.pointerType === 'touch')\n            { return; }\n        var events = this.normalizeToPointerData(originalEvent);\n        /**\n         * No need to prevent default on natural pointer events, as there are no side effects\n         * Normalized events, however, may have the double mousedown/touchstart issue on the native android browser,\n         * so still need to be prevented.\n         */\n        // Guaranteed that there will be at least one event in events, and all events must have the same pointer type\n        if (this.autoPreventDefault && events[0].isNormalized) {\n            var cancelable = originalEvent.cancelable || !('cancelable' in originalEvent);\n            if (cancelable) {\n                originalEvent.preventDefault();\n            }\n        }\n        var eventLen = events.length;\n        for (var i = 0; i < eventLen; i++) {\n            var event = events[i];\n            var interactionData = this.getInteractionDataForPointerId(event);\n            var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, event, interactionData);\n            interactionEvent.data.originalEvent = originalEvent;\n            this.processInteractive(interactionEvent, this.lastObjectRendered, this.processPointerDown, true);\n            this.emit('pointerdown', interactionEvent);\n            if (event.pointerType === 'touch') {\n                this.emit('touchstart', interactionEvent);\n            }\n            // emit a mouse event for \"pen\" pointers, the way a browser would emit a fallback event\n            else if (event.pointerType === 'mouse' || event.pointerType === 'pen') {\n                var isRightButton = event.button === 2;\n                this.emit(isRightButton ? 'rightdown' : 'mousedown', this.eventData);\n            }\n        }\n    };\n    /**\n     * Processes the result of the pointer down check and dispatches the event if need be\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The interaction event wrapping the DOM event\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - The display object that was tested\n     * @param {boolean} hit - the result of the hit test on the display object\n     */\n    InteractionManager.prototype.processPointerDown = function (interactionEvent, displayObject, hit) {\n        var data = interactionEvent.data;\n        var id = interactionEvent.data.identifier;\n        if (hit) {\n            if (!displayObject.trackedPointers[id]) {\n                displayObject.trackedPointers[id] = new InteractionTrackingData(id);\n            }\n            this.dispatchEvent(displayObject, 'pointerdown', interactionEvent);\n            if (data.pointerType === 'touch') {\n                this.dispatchEvent(displayObject, 'touchstart', interactionEvent);\n            }\n            else if (data.pointerType === 'mouse' || data.pointerType === 'pen') {\n                var isRightButton = data.button === 2;\n                if (isRightButton) {\n                    displayObject.trackedPointers[id].rightDown = true;\n                }\n                else {\n                    displayObject.trackedPointers[id].leftDown = true;\n                }\n                this.dispatchEvent(displayObject, isRightButton ? 'rightdown' : 'mousedown', interactionEvent);\n            }\n        }\n    };\n    /**\n     * Is called when the pointer button is released on the renderer element\n     *\n     * @private\n     * @param {PointerEvent} originalEvent - The DOM event of a pointer button being released\n     * @param {boolean} cancelled - true if the pointer is cancelled\n     * @param {Function} func - Function passed to {@link processInteractive}\n     */\n    InteractionManager.prototype.onPointerComplete = function (originalEvent, cancelled, func) {\n        var events = this.normalizeToPointerData(originalEvent);\n        var eventLen = events.length;\n        // if the event wasn't targeting our canvas, then consider it to be pointerupoutside\n        // in all cases (unless it was a pointercancel)\n        var eventAppend = originalEvent.target !== this.interactionDOMElement ? 'outside' : '';\n        for (var i = 0; i < eventLen; i++) {\n            var event = events[i];\n            var interactionData = this.getInteractionDataForPointerId(event);\n            var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, event, interactionData);\n            interactionEvent.data.originalEvent = originalEvent;\n            // perform hit testing for events targeting our canvas or cancel events\n            this.processInteractive(interactionEvent, this.lastObjectRendered, func, cancelled || !eventAppend);\n            this.emit(cancelled ? 'pointercancel' : \"pointerup\" + eventAppend, interactionEvent);\n            if (event.pointerType === 'mouse' || event.pointerType === 'pen') {\n                var isRightButton = event.button === 2;\n                this.emit(isRightButton ? \"rightup\" + eventAppend : \"mouseup\" + eventAppend, interactionEvent);\n            }\n            else if (event.pointerType === 'touch') {\n                this.emit(cancelled ? 'touchcancel' : \"touchend\" + eventAppend, interactionEvent);\n                this.releaseInteractionDataForPointerId(event.pointerId);\n            }\n        }\n    };\n    /**\n     * Is called when the pointer button is cancelled\n     *\n     * @private\n     * @param {PointerEvent} event - The DOM event of a pointer button being released\n     */\n    InteractionManager.prototype.onPointerCancel = function (event) {\n        // if we support touch events, then only use those for touch events, not pointer events\n        if (this.supportsTouchEvents && event.pointerType === 'touch')\n            { return; }\n        this.onPointerComplete(event, true, this.processPointerCancel);\n    };\n    /**\n     * Processes the result of the pointer cancel check and dispatches the event if need be\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The interaction event wrapping the DOM event\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - The display object that was tested\n     */\n    InteractionManager.prototype.processPointerCancel = function (interactionEvent, displayObject) {\n        var data = interactionEvent.data;\n        var id = interactionEvent.data.identifier;\n        if (displayObject.trackedPointers[id] !== undefined) {\n            delete displayObject.trackedPointers[id];\n            this.dispatchEvent(displayObject, 'pointercancel', interactionEvent);\n            if (data.pointerType === 'touch') {\n                this.dispatchEvent(displayObject, 'touchcancel', interactionEvent);\n            }\n        }\n    };\n    /**\n     * Is called when the pointer button is released on the renderer element\n     *\n     * @private\n     * @param {PointerEvent} event - The DOM event of a pointer button being released\n     */\n    InteractionManager.prototype.onPointerUp = function (event) {\n        // if we support touch events, then only use those for touch events, not pointer events\n        if (this.supportsTouchEvents && event.pointerType === 'touch')\n            { return; }\n        this.onPointerComplete(event, false, this.processPointerUp);\n    };\n    /**\n     * Processes the result of the pointer up check and dispatches the event if need be\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The interaction event wrapping the DOM event\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - The display object that was tested\n     * @param {boolean} hit - the result of the hit test on the display object\n     */\n    InteractionManager.prototype.processPointerUp = function (interactionEvent, displayObject, hit) {\n        var data = interactionEvent.data;\n        var id = interactionEvent.data.identifier;\n        var trackingData = displayObject.trackedPointers[id];\n        var isTouch = data.pointerType === 'touch';\n        var isMouse = (data.pointerType === 'mouse' || data.pointerType === 'pen');\n        // need to track mouse down status in the mouse block so that we can emit\n        // event in a later block\n        var isMouseTap = false;\n        // Mouse only\n        if (isMouse) {\n            var isRightButton = data.button === 2;\n            var flags = InteractionTrackingData.FLAGS;\n            var test = isRightButton ? flags.RIGHT_DOWN : flags.LEFT_DOWN;\n            var isDown = trackingData !== undefined && (trackingData.flags & test);\n            if (hit) {\n                this.dispatchEvent(displayObject, isRightButton ? 'rightup' : 'mouseup', interactionEvent);\n                if (isDown) {\n                    this.dispatchEvent(displayObject, isRightButton ? 'rightclick' : 'click', interactionEvent);\n                    // because we can confirm that the mousedown happened on this object, flag for later emit of pointertap\n                    isMouseTap = true;\n                }\n            }\n            else if (isDown) {\n                this.dispatchEvent(displayObject, isRightButton ? 'rightupoutside' : 'mouseupoutside', interactionEvent);\n            }\n            // update the down state of the tracking data\n            if (trackingData) {\n                if (isRightButton) {\n                    trackingData.rightDown = false;\n                }\n                else {\n                    trackingData.leftDown = false;\n                }\n            }\n        }\n        // Pointers and Touches, and Mouse\n        if (hit) {\n            this.dispatchEvent(displayObject, 'pointerup', interactionEvent);\n            if (isTouch)\n                { this.dispatchEvent(displayObject, 'touchend', interactionEvent); }\n            if (trackingData) {\n                // emit pointertap if not a mouse, or if the mouse block decided it was a tap\n                if (!isMouse || isMouseTap) {\n                    this.dispatchEvent(displayObject, 'pointertap', interactionEvent);\n                }\n                if (isTouch) {\n                    this.dispatchEvent(displayObject, 'tap', interactionEvent);\n                    // touches are no longer over (if they ever were) when we get the touchend\n                    // so we should ensure that we don't keep pretending that they are\n                    trackingData.over = false;\n                }\n            }\n        }\n        else if (trackingData) {\n            this.dispatchEvent(displayObject, 'pointerupoutside', interactionEvent);\n            if (isTouch)\n                { this.dispatchEvent(displayObject, 'touchendoutside', interactionEvent); }\n        }\n        // Only remove the tracking data if there is no over/down state still associated with it\n        if (trackingData && trackingData.none) {\n            delete displayObject.trackedPointers[id];\n        }\n    };\n    /**\n     * Is called when the pointer moves across the renderer element\n     *\n     * @private\n     * @param {PointerEvent} originalEvent - The DOM event of a pointer moving\n     */\n    InteractionManager.prototype.onPointerMove = function (originalEvent) {\n        // if we support touch events, then only use those for touch events, not pointer events\n        if (this.supportsTouchEvents && originalEvent.pointerType === 'touch')\n            { return; }\n        var events = this.normalizeToPointerData(originalEvent);\n        if (events[0].pointerType === 'mouse' || events[0].pointerType === 'pen') {\n            this._didMove = true;\n            this.cursor = null;\n        }\n        var eventLen = events.length;\n        for (var i = 0; i < eventLen; i++) {\n            var event = events[i];\n            var interactionData = this.getInteractionDataForPointerId(event);\n            var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, event, interactionData);\n            interactionEvent.data.originalEvent = originalEvent;\n            this.processInteractive(interactionEvent, this.lastObjectRendered, this.processPointerMove, true);\n            this.emit('pointermove', interactionEvent);\n            if (event.pointerType === 'touch')\n                { this.emit('touchmove', interactionEvent); }\n            if (event.pointerType === 'mouse' || event.pointerType === 'pen')\n                { this.emit('mousemove', interactionEvent); }\n        }\n        if (events[0].pointerType === 'mouse') {\n            this.setCursorMode(this.cursor);\n            // TODO BUG for parents interactive object (border order issue)\n        }\n    };\n    /**\n     * Processes the result of the pointer move check and dispatches the event if need be\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The interaction event wrapping the DOM event\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - The display object that was tested\n     * @param {boolean} hit - the result of the hit test on the display object\n     */\n    InteractionManager.prototype.processPointerMove = function (interactionEvent, displayObject, hit) {\n        var data = interactionEvent.data;\n        var isTouch = data.pointerType === 'touch';\n        var isMouse = (data.pointerType === 'mouse' || data.pointerType === 'pen');\n        if (isMouse) {\n            this.processPointerOverOut(interactionEvent, displayObject, hit);\n        }\n        if (!this.moveWhenInside || hit) {\n            this.dispatchEvent(displayObject, 'pointermove', interactionEvent);\n            if (isTouch)\n                { this.dispatchEvent(displayObject, 'touchmove', interactionEvent); }\n            if (isMouse)\n                { this.dispatchEvent(displayObject, 'mousemove', interactionEvent); }\n        }\n    };\n    /**\n     * Is called when the pointer is moved out of the renderer element\n     *\n     * @private\n     * @param {PointerEvent} originalEvent - The DOM event of a pointer being moved out\n     */\n    InteractionManager.prototype.onPointerOut = function (originalEvent) {\n        // if we support touch events, then only use those for touch events, not pointer events\n        if (this.supportsTouchEvents && originalEvent.pointerType === 'touch')\n            { return; }\n        var events = this.normalizeToPointerData(originalEvent);\n        // Only mouse and pointer can call onPointerOut, so events will always be length 1\n        var event = events[0];\n        if (event.pointerType === 'mouse') {\n            this.mouseOverRenderer = false;\n            this.setCursorMode(null);\n        }\n        var interactionData = this.getInteractionDataForPointerId(event);\n        var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, event, interactionData);\n        interactionEvent.data.originalEvent = event;\n        this.processInteractive(interactionEvent, this.lastObjectRendered, this.processPointerOverOut, false);\n        this.emit('pointerout', interactionEvent);\n        if (event.pointerType === 'mouse' || event.pointerType === 'pen') {\n            this.emit('mouseout', interactionEvent);\n        }\n        else {\n            // we can get touchleave events after touchend, so we want to make sure we don't\n            // introduce memory leaks\n            this.releaseInteractionDataForPointerId(interactionData.identifier);\n        }\n    };\n    /**\n     * Processes the result of the pointer over/out check and dispatches the event if need be\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The interaction event wrapping the DOM event\n     * @param {PIXI.Container|PIXI.Sprite|PIXI.TilingSprite} displayObject - The display object that was tested\n     * @param {boolean} hit - the result of the hit test on the display object\n     */\n    InteractionManager.prototype.processPointerOverOut = function (interactionEvent, displayObject, hit) {\n        var data = interactionEvent.data;\n        var id = interactionEvent.data.identifier;\n        var isMouse = (data.pointerType === 'mouse' || data.pointerType === 'pen');\n        var trackingData = displayObject.trackedPointers[id];\n        // if we just moused over the display object, then we need to track that state\n        if (hit && !trackingData) {\n            trackingData = displayObject.trackedPointers[id] = new InteractionTrackingData(id);\n        }\n        if (trackingData === undefined)\n            { return; }\n        if (hit && this.mouseOverRenderer) {\n            if (!trackingData.over) {\n                trackingData.over = true;\n                this.delayDispatchEvent(displayObject, 'pointerover', interactionEvent);\n                if (isMouse) {\n                    this.delayDispatchEvent(displayObject, 'mouseover', interactionEvent);\n                }\n            }\n            // only change the cursor if it has not already been changed (by something deeper in the\n            // display tree)\n            if (isMouse && this.cursor === null) {\n                this.cursor = displayObject.cursor;\n            }\n        }\n        else if (trackingData.over) {\n            trackingData.over = false;\n            this.dispatchEvent(displayObject, 'pointerout', this.eventData);\n            if (isMouse) {\n                this.dispatchEvent(displayObject, 'mouseout', interactionEvent);\n            }\n            // if there is no mouse down information for the pointer, then it is safe to delete\n            if (trackingData.none) {\n                delete displayObject.trackedPointers[id];\n            }\n        }\n    };\n    /**\n     * Is called when the pointer is moved into the renderer element\n     *\n     * @private\n     * @param {PointerEvent} originalEvent - The DOM event of a pointer button being moved into the renderer view\n     */\n    InteractionManager.prototype.onPointerOver = function (originalEvent) {\n        var events = this.normalizeToPointerData(originalEvent);\n        // Only mouse and pointer can call onPointerOver, so events will always be length 1\n        var event = events[0];\n        var interactionData = this.getInteractionDataForPointerId(event);\n        var interactionEvent = this.configureInteractionEventForDOMEvent(this.eventData, event, interactionData);\n        interactionEvent.data.originalEvent = event;\n        if (event.pointerType === 'mouse') {\n            this.mouseOverRenderer = true;\n        }\n        this.emit('pointerover', interactionEvent);\n        if (event.pointerType === 'mouse' || event.pointerType === 'pen') {\n            this.emit('mouseover', interactionEvent);\n        }\n    };\n    /**\n     * Get InteractionData for a given pointerId. Store that data as well\n     *\n     * @private\n     * @param {PointerEvent} event - Normalized pointer event, output from normalizeToPointerData\n     * @return {PIXI.InteractionData} - Interaction data for the given pointer identifier\n     */\n    InteractionManager.prototype.getInteractionDataForPointerId = function (event) {\n        var pointerId = event.pointerId;\n        var interactionData;\n        if (pointerId === MOUSE_POINTER_ID || event.pointerType === 'mouse') {\n            interactionData = this.mouse;\n        }\n        else if (this.activeInteractionData[pointerId]) {\n            interactionData = this.activeInteractionData[pointerId];\n        }\n        else {\n            interactionData = this.interactionDataPool.pop() || new InteractionData();\n            interactionData.identifier = pointerId;\n            this.activeInteractionData[pointerId] = interactionData;\n        }\n        // copy properties from the event, so that we can make sure that touch/pointer specific\n        // data is available\n        interactionData.copyEvent(event);\n        return interactionData;\n    };\n    /**\n     * Return unused InteractionData to the pool, for a given pointerId\n     *\n     * @private\n     * @param {number} pointerId - Identifier from a pointer event\n     */\n    InteractionManager.prototype.releaseInteractionDataForPointerId = function (pointerId) {\n        var interactionData = this.activeInteractionData[pointerId];\n        if (interactionData) {\n            delete this.activeInteractionData[pointerId];\n            interactionData.reset();\n            this.interactionDataPool.push(interactionData);\n        }\n    };\n    /**\n     * Configure an InteractionEvent to wrap a DOM PointerEvent and InteractionData\n     *\n     * @private\n     * @param {PIXI.InteractionEvent} interactionEvent - The event to be configured\n     * @param {PointerEvent} pointerEvent - The DOM event that will be paired with the InteractionEvent\n     * @param {PIXI.InteractionData} interactionData - The InteractionData that will be paired\n     *        with the InteractionEvent\n     * @return {PIXI.InteractionEvent} the interaction event that was passed in\n     */\n    InteractionManager.prototype.configureInteractionEventForDOMEvent = function (interactionEvent, pointerEvent, interactionData) {\n        interactionEvent.data = interactionData;\n        this.mapPositionToPoint(interactionData.global, pointerEvent.clientX, pointerEvent.clientY);\n        // Not really sure why this is happening, but it's how a previous version handled things\n        if (pointerEvent.pointerType === 'touch') {\n            pointerEvent.globalX = interactionData.global.x;\n            pointerEvent.globalY = interactionData.global.y;\n        }\n        interactionData.originalEvent = pointerEvent;\n        interactionEvent.reset();\n        return interactionEvent;\n    };\n    /**\n     * Ensures that the original event object contains all data that a regular pointer event would have\n     *\n     * @private\n     * @param {TouchEvent|MouseEvent|PointerEvent} event - The original event data from a touch or mouse event\n     * @return {PointerEvent[]} An array containing a single normalized pointer event, in the case of a pointer\n     *  or mouse event, or a multiple normalized pointer events if there are multiple changed touches\n     */\n    InteractionManager.prototype.normalizeToPointerData = function (event) {\n        var normalizedEvents = [];\n        if (this.supportsTouchEvents && event instanceof TouchEvent) {\n            for (var i = 0, li = event.changedTouches.length; i < li; i++) {\n                var touch = event.changedTouches[i];\n                if (typeof touch.button === 'undefined')\n                    { touch.button = event.touches.length ? 1 : 0; }\n                if (typeof touch.buttons === 'undefined')\n                    { touch.buttons = event.touches.length ? 1 : 0; }\n                if (typeof touch.isPrimary === 'undefined') {\n                    touch.isPrimary = event.touches.length === 1 && event.type === 'touchstart';\n                }\n                if (typeof touch.width === 'undefined')\n                    { touch.width = touch.radiusX || 1; }\n                if (typeof touch.height === 'undefined')\n                    { touch.height = touch.radiusY || 1; }\n                if (typeof touch.tiltX === 'undefined')\n                    { touch.tiltX = 0; }\n                if (typeof touch.tiltY === 'undefined')\n                    { touch.tiltY = 0; }\n                if (typeof touch.pointerType === 'undefined')\n                    { touch.pointerType = 'touch'; }\n                if (typeof touch.pointerId === 'undefined')\n                    { touch.pointerId = touch.identifier || 0; }\n                if (typeof touch.pressure === 'undefined')\n                    { touch.pressure = touch.force || 0.5; }\n                if (typeof touch.twist === 'undefined')\n                    { touch.twist = 0; }\n                if (typeof touch.tangentialPressure === 'undefined')\n                    { touch.tangentialPressure = 0; }\n                // TODO: Remove these, as layerX/Y is not a standard, is deprecated, has uneven\n                // support, and the fill ins are not quite the same\n                // offsetX/Y might be okay, but is not the same as clientX/Y when the canvas's top\n                // left is not 0,0 on the page\n                if (typeof touch.layerX === 'undefined')\n                    { touch.layerX = touch.offsetX = touch.clientX; }\n                if (typeof touch.layerY === 'undefined')\n                    { touch.layerY = touch.offsetY = touch.clientY; }\n                // mark the touch as normalized, just so that we know we did it\n                touch.isNormalized = true;\n                normalizedEvents.push(touch);\n            }\n        }\n        // apparently PointerEvent subclasses MouseEvent, so yay\n        else if (event instanceof MouseEvent && (!this.supportsPointerEvents || !(event instanceof window.PointerEvent))) {\n            var tempEvent = event;\n            if (typeof tempEvent.isPrimary === 'undefined')\n                { tempEvent.isPrimary = true; }\n            if (typeof tempEvent.width === 'undefined')\n                { tempEvent.width = 1; }\n            if (typeof tempEvent.height === 'undefined')\n                { tempEvent.height = 1; }\n            if (typeof tempEvent.tiltX === 'undefined')\n                { tempEvent.tiltX = 0; }\n            if (typeof tempEvent.tiltY === 'undefined')\n                { tempEvent.tiltY = 0; }\n            if (typeof tempEvent.pointerType === 'undefined')\n                { tempEvent.pointerType = 'mouse'; }\n            if (typeof tempEvent.pointerId === 'undefined')\n                { tempEvent.pointerId = MOUSE_POINTER_ID; }\n            if (typeof tempEvent.pressure === 'undefined')\n                { tempEvent.pressure = 0.5; }\n            if (typeof tempEvent.twist === 'undefined')\n                { tempEvent.twist = 0; }\n            if (typeof tempEvent.tangentialPressure === 'undefined')\n                { tempEvent.tangentialPressure = 0; }\n            // mark the mouse event as normalized, just so that we know we did it\n            tempEvent.isNormalized = true;\n            normalizedEvents.push(tempEvent);\n        }\n        else {\n            normalizedEvents.push(event);\n        }\n        return normalizedEvents;\n    };\n    /**\n     * Destroys the interaction manager\n     *\n     */\n    InteractionManager.prototype.destroy = function () {\n        this.removeEvents();\n        this.removeTickerListener();\n        this.removeAllListeners();\n        this.renderer = null;\n        this.mouse = null;\n        this.eventData = null;\n        this.interactionDOMElement = null;\n        this.onPointerDown = null;\n        this.processPointerDown = null;\n        this.onPointerUp = null;\n        this.processPointerUp = null;\n        this.onPointerCancel = null;\n        this.processPointerCancel = null;\n        this.onPointerMove = null;\n        this.processPointerMove = null;\n        this.onPointerOut = null;\n        this.processPointerOverOut = null;\n        this.onPointerOver = null;\n        this.search = null;\n    };\n    return InteractionManager;\n}(_pixi_utils__WEBPACK_IMPORTED_MODULE_3__.EventEmitter));\n\n\n//# sourceMappingURL=interaction.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/interaction/lib/interaction.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/loaders/lib/loaders.es.js":
/*!******************************************************!*\
  !*** ./node_modules/@pixi/loaders/lib/loaders.es.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AppLoaderPlugin\": () => (/* binding */ AppLoaderPlugin),\n/* harmony export */   \"Loader\": () => (/* binding */ Loader),\n/* harmony export */   \"LoaderResource\": () => (/* binding */ LoaderResource),\n/* harmony export */   \"TextureLoader\": () => (/* binding */ TextureLoader)\n/* harmony export */ });\n/* harmony import */ var resource_loader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! resource-loader */ \"./node_modules/resource-loader/dist/resource-loader.esm.js\");\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/loaders - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/loaders is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n/**\n* Reference to **{@link https://github.com/englercj/resource-loader\n* resource-loader}**'s Resource class.\n* @see http://englercj.github.io/resource-loader/Resource.html\n* @class LoaderResource\n* @memberof PIXI\n*/\nvar LoaderResource = resource_loader__WEBPACK_IMPORTED_MODULE_0__.Resource;\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * Loader plugin for handling Texture resources.\n * @class\n * @memberof PIXI\n * @implements PIXI.ILoaderPlugin\n */\nvar TextureLoader = /** @class */ (function () {\n    function TextureLoader() {\n    }\n    /**\n     * Called after a resource is loaded.\n     * @see PIXI.Loader.loaderMiddleware\n     * @param {PIXI.LoaderResource} resource\n     * @param {function} next\n     */\n    TextureLoader.use = function (resource, next) {\n        // create a new texture if the data is an Image object\n        if (resource.data && resource.type === resource_loader__WEBPACK_IMPORTED_MODULE_0__.Resource.TYPE.IMAGE) {\n            resource.texture = _pixi_core__WEBPACK_IMPORTED_MODULE_1__.Texture.fromLoader(resource.data, resource.url, resource.name);\n        }\n        next();\n    };\n    return TextureLoader;\n}());\n\n/**\n * The new loader, extends Resource Loader by Chad Engler: https://github.com/englercj/resource-loader\n *\n * ```js\n * const loader = PIXI.Loader.shared; // PixiJS exposes a premade instance for you to use.\n * //or\n * const loader = new PIXI.Loader(); // you can also create your own if you want\n *\n * const sprites = {};\n *\n * // Chainable `add` to enqueue a resource\n * loader.add('bunny', 'data/bunny.png')\n *       .add('spaceship', 'assets/spritesheet.json');\n * loader.add('scoreFont', 'assets/score.fnt');\n *\n * // Chainable `pre` to add a middleware that runs for each resource, *before* loading that resource.\n * // This is useful to implement custom caching modules (using filesystem, indexeddb, memory, etc).\n * loader.pre(cachingMiddleware);\n *\n * // Chainable `use` to add a middleware that runs for each resource, *after* loading that resource.\n * // This is useful to implement custom parsing modules (like spritesheet parsers, spine parser, etc).\n * loader.use(parsingMiddleware);\n *\n * // The `load` method loads the queue of resources, and calls the passed in callback called once all\n * // resources have loaded.\n * loader.load((loader, resources) => {\n *     // resources is an object where the key is the name of the resource loaded and the value is the resource object.\n *     // They have a couple default properties:\n *     // - `url`: The URL that the resource was loaded from\n *     // - `error`: The error that happened when trying to load (if any)\n *     // - `data`: The raw data that was loaded\n *     // also may contain other properties based on the middleware that runs.\n *     sprites.bunny = new PIXI.TilingSprite(resources.bunny.texture);\n *     sprites.spaceship = new PIXI.TilingSprite(resources.spaceship.texture);\n *     sprites.scoreFont = new PIXI.TilingSprite(resources.scoreFont.texture);\n * });\n *\n * // throughout the process multiple signals can be dispatched.\n * loader.onProgress.add(() => {}); // called once per loaded/errored file\n * loader.onError.add(() => {}); // called once per errored file\n * loader.onLoad.add(() => {}); // called once per loaded file\n * loader.onComplete.add(() => {}); // called once when the queued resources all load.\n * ```\n *\n * @see https://github.com/englercj/resource-loader\n *\n * @class Loader\n * @memberof PIXI\n * @param {string} [baseUrl=''] - The base url for all resources loaded by this loader.\n * @param {number} [concurrency=10] - The number of resources to load concurrently.\n */\nvar Loader = /** @class */ (function (_super) {\n    __extends(Loader, _super);\n    function Loader(baseUrl, concurrency) {\n        var _this = _super.call(this, baseUrl, concurrency) || this;\n        for (var i = 0; i < Loader._plugins.length; ++i) {\n            var plugin = Loader._plugins[i];\n            var pre = plugin.pre, use = plugin.use;\n            if (pre) {\n                _this.pre(pre);\n            }\n            if (use) {\n                _this.use(use);\n            }\n        }\n        /**\n         * If this loader cannot be destroyed.\n         * @member {boolean}\n         * @default false\n         * @private\n         */\n        _this._protected = false;\n        return _this;\n    }\n    /**\n     * Destroy the loader, removes references.\n     * @memberof PIXI.Loader#\n     * @method destroy\n     * @public\n     */\n    Loader.prototype.destroy = function () {\n        if (!this._protected) {\n            this.reset();\n        }\n    };\n    Object.defineProperty(Loader, \"shared\", {\n        /**\n         * A premade instance of the loader that can be used to load resources.\n         * @name shared\n         * @type {PIXI.Loader}\n         * @static\n         * @memberof PIXI.Loader\n         */\n        get: function () {\n            var shared = Loader._shared;\n            if (!shared) {\n                shared = new Loader();\n                shared._protected = true;\n                Loader._shared = shared;\n            }\n            return shared;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Adds a Loader plugin for the global shared loader and all\n     * new Loader instances created.\n     *\n     * @static\n     * @method registerPlugin\n     * @memberof PIXI.Loader\n     * @param {PIXI.ILoaderPlugin} plugin - The plugin to add\n     * @return {PIXI.Loader} Reference to PIXI.Loader for chaining\n     */\n    Loader.registerPlugin = function (plugin) {\n        Loader._plugins.push(plugin);\n        if (plugin.add) {\n            plugin.add();\n        }\n        return Loader;\n    };\n    /**\n     * Collection of all installed `use` middleware for Loader.\n     *\n     * @static\n     * @member {Array<PIXI.ILoaderPlugin>} _plugins\n     * @memberof PIXI.Loader\n     * @private\n     */\n    Loader._plugins = [];\n    return Loader;\n}(resource_loader__WEBPACK_IMPORTED_MODULE_0__.Loader));\n// parse any blob into more usable objects (e.g. Image)\nLoader.registerPlugin({ use: resource_loader__WEBPACK_IMPORTED_MODULE_0__.middleware.parsing });\n// parse any Image objects into textures\nLoader.registerPlugin(TextureLoader);\n/**\n * Plugin to be installed for handling specific Loader resources.\n *\n * @memberof PIXI\n * @typedef {object} ILoaderPlugin\n * @property {function} [add] - Function to call immediate after registering plugin.\n * @property {PIXI.Loader.loaderMiddleware} [pre] - Middleware function to run before load, the\n *           arguments for this are `(resource, next)`\n * @property {PIXI.Loader.loaderMiddleware} [use] - Middleware function to run after load, the\n *           arguments for this are `(resource, next)`\n */\n/**\n * @memberof PIXI.Loader\n * @typedef {object} ICallbackID\n */\n/**\n * @memberof PIXI.Loader\n * @typedef {function} ISignalCallback\n * @param {function} callback - Callback function\n * @param {object} [context] - Context\n * @returns {ICallbackID} - CallbackID\n */\n/**\n * @memberof PIXI.Loader\n * @typedef {function} ISignalDetach\n * @param {ICallbackID} id - CallbackID returned by `add`/`once` methods\n */\n/**\n * @memberof PIXI.Loader\n * @typedef ILoaderSignal\n * @property {ISignalCallback} add - Register callback\n * @property {ISignalCallback} once - Register oneshot callback\n * @property {ISignalDetach} detach - Detach specific callback by ID\n */\n/**\n * @memberof PIXI.Loader\n * @callback loaderMiddleware\n * @param {PIXI.LoaderResource} resource\n * @param {function} next\n */\n/**\n * @memberof PIXI.Loader#\n * @description Dispatched when the loader begins to loading process.\n * @member {PIXI.Loader.ILoaderSignal} onStart\n */\n/**\n * @memberof PIXI.Loader#\n * @description Dispatched once per loaded or errored resource.\n * @member {PIXI.Loader.ILoaderSignal} onProgress\n */\n/**\n * @memberof PIXI.Loader#\n * @description Dispatched once per errored resource.\n * @member {PIXI.Loader.ILoaderSignal} onError\n */\n/**\n * @memberof PIXI.Loader#\n * @description Dispatched once per loaded resource.\n * @member {PIXI.Loader.ILoaderSignal} onLoad\n */\n/**\n * @memberof PIXI.Loader#\n * @description Dispatched when completely loaded all resources.\n * @member {PIXI.Loader.ILoaderSignal} onComplete\n */\n\n/**\n * Application plugin for supporting loader option. Installing the LoaderPlugin\n * is not necessary if using **pixi.js** or **pixi.js-legacy**.\n * @example\n * import {AppLoaderPlugin} from '@pixi/loaders';\n * import {Application} from '@pixi/app';\n * Application.registerPlugin(AppLoaderPlugin);\n * @class\n * @memberof PIXI\n */\nvar AppLoaderPlugin = /** @class */ (function () {\n    function AppLoaderPlugin() {\n    }\n    /**\n     * Called on application constructor\n     * @param {object} options\n     * @private\n     */\n    AppLoaderPlugin.init = function (options) {\n        options = Object.assign({\n            sharedLoader: false,\n        }, options);\n        /**\n         * Loader instance to help with asset loading.\n         * @name PIXI.Application#loader\n         * @type {PIXI.Loader}\n         * @readonly\n         */\n        this.loader = options.sharedLoader ? Loader.shared : new Loader();\n    };\n    /**\n     * Called when application destroyed\n     * @private\n     */\n    AppLoaderPlugin.destroy = function () {\n        if (this.loader) {\n            this.loader.destroy();\n            this.loader = null;\n        }\n    };\n    return AppLoaderPlugin;\n}());\n\n\n//# sourceMappingURL=loaders.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/loaders/lib/loaders.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/math/lib/math.es.js":
/*!************************************************!*\
  !*** ./node_modules/@pixi/math/lib/math.es.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Circle\": () => (/* binding */ Circle),\n/* harmony export */   \"DEG_TO_RAD\": () => (/* binding */ DEG_TO_RAD),\n/* harmony export */   \"Ellipse\": () => (/* binding */ Ellipse),\n/* harmony export */   \"Matrix\": () => (/* binding */ Matrix),\n/* harmony export */   \"ObservablePoint\": () => (/* binding */ ObservablePoint),\n/* harmony export */   \"PI_2\": () => (/* binding */ PI_2),\n/* harmony export */   \"Point\": () => (/* binding */ Point),\n/* harmony export */   \"Polygon\": () => (/* binding */ Polygon),\n/* harmony export */   \"RAD_TO_DEG\": () => (/* binding */ RAD_TO_DEG),\n/* harmony export */   \"Rectangle\": () => (/* binding */ Rectangle),\n/* harmony export */   \"RoundedRectangle\": () => (/* binding */ RoundedRectangle),\n/* harmony export */   \"SHAPES\": () => (/* binding */ SHAPES),\n/* harmony export */   \"Transform\": () => (/* binding */ Transform),\n/* harmony export */   \"groupD8\": () => (/* binding */ groupD8)\n/* harmony export */ });\n/*!\n * @pixi/math - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/math is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n/**\n * Two Pi.\n *\n * @static\n * @constant {number} PI_2\n * @memberof PIXI\n */\nvar PI_2 = Math.PI * 2;\n/**\n * Conversion factor for converting radians to degrees.\n *\n * @static\n * @constant {number} RAD_TO_DEG\n * @memberof PIXI\n */\nvar RAD_TO_DEG = 180 / Math.PI;\n/**\n * Conversion factor for converting degrees to radians.\n *\n * @static\n * @constant {number} DEG_TO_RAD\n * @memberof PIXI\n */\nvar DEG_TO_RAD = Math.PI / 180;\nvar SHAPES;\n(function (SHAPES) {\n    SHAPES[SHAPES[\"POLY\"] = 0] = \"POLY\";\n    SHAPES[SHAPES[\"RECT\"] = 1] = \"RECT\";\n    SHAPES[SHAPES[\"CIRC\"] = 2] = \"CIRC\";\n    SHAPES[SHAPES[\"ELIP\"] = 3] = \"ELIP\";\n    SHAPES[SHAPES[\"RREC\"] = 4] = \"RREC\";\n})(SHAPES || (SHAPES = {}));\n/**\n * Constants that identify shapes, mainly to prevent `instanceof` calls.\n *\n * @static\n * @constant\n * @name SHAPES\n * @memberof PIXI\n * @type {enum}\n * @property {number} POLY Polygon\n * @property {number} RECT Rectangle\n * @property {number} CIRC Circle\n * @property {number} ELIP Ellipse\n * @property {number} RREC Rounded Rectangle\n * @enum {number}\n */\n\n/**\n * Size object, contains width and height\n *\n * @memberof PIXI\n * @typedef {object} ISize\n * @property {number} width - Width component\n * @property {number} height - Height component\n */\n/**\n * Rectangle object is an area defined by its position, as indicated by its top-left corner\n * point (x, y) and by its width and its height.\n *\n * @class\n * @memberof PIXI\n */\nvar Rectangle = /** @class */ (function () {\n    /**\n     * @param {number} [x=0] - The X coordinate of the upper-left corner of the rectangle\n     * @param {number} [y=0] - The Y coordinate of the upper-left corner of the rectangle\n     * @param {number} [width=0] - The overall width of this rectangle\n     * @param {number} [height=0] - The overall height of this rectangle\n     */\n    function Rectangle(x, y, width, height) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (width === void 0) { width = 0; }\n        if (height === void 0) { height = 0; }\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.x = Number(x);\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.y = Number(y);\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.width = Number(width);\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.height = Number(height);\n        /**\n         * The type of the object, mainly used to avoid `instanceof` checks\n         *\n         * @member {number}\n         * @readOnly\n         * @default PIXI.SHAPES.RECT\n         * @see PIXI.SHAPES\n         */\n        this.type = SHAPES.RECT;\n    }\n    Object.defineProperty(Rectangle.prototype, \"left\", {\n        /**\n         * returns the left edge of the rectangle\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.x;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Rectangle.prototype, \"right\", {\n        /**\n         * returns the right edge of the rectangle\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.x + this.width;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Rectangle.prototype, \"top\", {\n        /**\n         * returns the top edge of the rectangle\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.y;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Rectangle.prototype, \"bottom\", {\n        /**\n         * returns the bottom edge of the rectangle\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this.y + this.height;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Rectangle, \"EMPTY\", {\n        /**\n         * A constant empty rectangle.\n         *\n         * @static\n         * @constant\n         * @member {PIXI.Rectangle}\n         * @return {PIXI.Rectangle} An empty rectangle\n         */\n        get: function () {\n            return new Rectangle(0, 0, 0, 0);\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Creates a clone of this Rectangle\n     *\n     * @return {PIXI.Rectangle} a copy of the rectangle\n     */\n    Rectangle.prototype.clone = function () {\n        return new Rectangle(this.x, this.y, this.width, this.height);\n    };\n    /**\n     * Copies another rectangle to this one.\n     *\n     * @param {PIXI.Rectangle} rectangle - The rectangle to copy from.\n     * @return {PIXI.Rectangle} Returns itself.\n     */\n    Rectangle.prototype.copyFrom = function (rectangle) {\n        this.x = rectangle.x;\n        this.y = rectangle.y;\n        this.width = rectangle.width;\n        this.height = rectangle.height;\n        return this;\n    };\n    /**\n     * Copies this rectangle to another one.\n     *\n     * @param {PIXI.Rectangle} rectangle - The rectangle to copy to.\n     * @return {PIXI.Rectangle} Returns given parameter.\n     */\n    Rectangle.prototype.copyTo = function (rectangle) {\n        rectangle.x = this.x;\n        rectangle.y = this.y;\n        rectangle.width = this.width;\n        rectangle.height = this.height;\n        return rectangle;\n    };\n    /**\n     * Checks whether the x and y coordinates given are contained within this Rectangle\n     *\n     * @param {number} x - The X coordinate of the point to test\n     * @param {number} y - The Y coordinate of the point to test\n     * @return {boolean} Whether the x/y coordinates are within this Rectangle\n     */\n    Rectangle.prototype.contains = function (x, y) {\n        if (this.width <= 0 || this.height <= 0) {\n            return false;\n        }\n        if (x >= this.x && x < this.x + this.width) {\n            if (y >= this.y && y < this.y + this.height) {\n                return true;\n            }\n        }\n        return false;\n    };\n    /**\n     * Pads the rectangle making it grow in all directions.\n     * If paddingY is omitted, both paddingX and paddingY will be set to paddingX.\n     *\n     * @param {number} [paddingX=0] - The horizontal padding amount.\n     * @param {number} [paddingY=0] - The vertical padding amount.\n     * @return {PIXI.Rectangle} Returns itself.\n     */\n    Rectangle.prototype.pad = function (paddingX, paddingY) {\n        if (paddingX === void 0) { paddingX = 0; }\n        if (paddingY === void 0) { paddingY = paddingX; }\n        this.x -= paddingX;\n        this.y -= paddingY;\n        this.width += paddingX * 2;\n        this.height += paddingY * 2;\n        return this;\n    };\n    /**\n     * Fits this rectangle around the passed one.\n     *\n     * @param {PIXI.Rectangle} rectangle - The rectangle to fit.\n     * @return {PIXI.Rectangle} Returns itself.\n     */\n    Rectangle.prototype.fit = function (rectangle) {\n        var x1 = Math.max(this.x, rectangle.x);\n        var x2 = Math.min(this.x + this.width, rectangle.x + rectangle.width);\n        var y1 = Math.max(this.y, rectangle.y);\n        var y2 = Math.min(this.y + this.height, rectangle.y + rectangle.height);\n        this.x = x1;\n        this.width = Math.max(x2 - x1, 0);\n        this.y = y1;\n        this.height = Math.max(y2 - y1, 0);\n        return this;\n    };\n    /**\n     * Enlarges rectangle that way its corners lie on grid\n     *\n     * @param {number} [resolution=1] resolution\n     * @param {number} [eps=0.001] precision\n     * @return {PIXI.Rectangle} Returns itself.\n     */\n    Rectangle.prototype.ceil = function (resolution, eps) {\n        if (resolution === void 0) { resolution = 1; }\n        if (eps === void 0) { eps = 0.001; }\n        var x2 = Math.ceil((this.x + this.width - eps) * resolution) / resolution;\n        var y2 = Math.ceil((this.y + this.height - eps) * resolution) / resolution;\n        this.x = Math.floor((this.x + eps) * resolution) / resolution;\n        this.y = Math.floor((this.y + eps) * resolution) / resolution;\n        this.width = x2 - this.x;\n        this.height = y2 - this.y;\n        return this;\n    };\n    /**\n     * Enlarges this rectangle to include the passed rectangle.\n     *\n     * @param {PIXI.Rectangle} rectangle - The rectangle to include.\n     * @return {PIXI.Rectangle} Returns itself.\n     */\n    Rectangle.prototype.enlarge = function (rectangle) {\n        var x1 = Math.min(this.x, rectangle.x);\n        var x2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);\n        var y1 = Math.min(this.y, rectangle.y);\n        var y2 = Math.max(this.y + this.height, rectangle.y + rectangle.height);\n        this.x = x1;\n        this.width = x2 - x1;\n        this.y = y1;\n        this.height = y2 - y1;\n        return this;\n    };\n    return Rectangle;\n}());\n\n/**\n * The Circle object is used to help draw graphics and can also be used to specify a hit area for displayObjects.\n *\n * @class\n * @memberof PIXI\n */\nvar Circle = /** @class */ (function () {\n    /**\n     * @param {number} [x=0] - The X coordinate of the center of this circle\n     * @param {number} [y=0] - The Y coordinate of the center of this circle\n     * @param {number} [radius=0] - The radius of the circle\n     */\n    function Circle(x, y, radius) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (radius === void 0) { radius = 0; }\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.x = x;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.y = y;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.radius = radius;\n        /**\n         * The type of the object, mainly used to avoid `instanceof` checks\n         *\n         * @member {number}\n         * @readOnly\n         * @default PIXI.SHAPES.CIRC\n         * @see PIXI.SHAPES\n         */\n        this.type = SHAPES.CIRC;\n    }\n    /**\n     * Creates a clone of this Circle instance\n     *\n     * @return {PIXI.Circle} a copy of the Circle\n     */\n    Circle.prototype.clone = function () {\n        return new Circle(this.x, this.y, this.radius);\n    };\n    /**\n     * Checks whether the x and y coordinates given are contained within this circle\n     *\n     * @param {number} x - The X coordinate of the point to test\n     * @param {number} y - The Y coordinate of the point to test\n     * @return {boolean} Whether the x/y coordinates are within this Circle\n     */\n    Circle.prototype.contains = function (x, y) {\n        if (this.radius <= 0) {\n            return false;\n        }\n        var r2 = this.radius * this.radius;\n        var dx = (this.x - x);\n        var dy = (this.y - y);\n        dx *= dx;\n        dy *= dy;\n        return (dx + dy <= r2);\n    };\n    /**\n    * Returns the framing rectangle of the circle as a Rectangle object\n    *\n    * @return {PIXI.Rectangle} the framing rectangle\n    */\n    Circle.prototype.getBounds = function () {\n        return new Rectangle(this.x - this.radius, this.y - this.radius, this.radius * 2, this.radius * 2);\n    };\n    return Circle;\n}());\n\n/**\n * The Ellipse object is used to help draw graphics and can also be used to specify a hit area for displayObjects.\n *\n * @class\n * @memberof PIXI\n */\nvar Ellipse = /** @class */ (function () {\n    /**\n     * @param {number} [x=0] - The X coordinate of the center of this ellipse\n     * @param {number} [y=0] - The Y coordinate of the center of this ellipse\n     * @param {number} [halfWidth=0] - The half width of this ellipse\n     * @param {number} [halfHeight=0] - The half height of this ellipse\n     */\n    function Ellipse(x, y, halfWidth, halfHeight) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (halfWidth === void 0) { halfWidth = 0; }\n        if (halfHeight === void 0) { halfHeight = 0; }\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.x = x;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.y = y;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.width = halfWidth;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.height = halfHeight;\n        /**\n         * The type of the object, mainly used to avoid `instanceof` checks\n         *\n         * @member {number}\n         * @readOnly\n         * @default PIXI.SHAPES.ELIP\n         * @see PIXI.SHAPES\n         */\n        this.type = SHAPES.ELIP;\n    }\n    /**\n     * Creates a clone of this Ellipse instance\n     *\n     * @return {PIXI.Ellipse} a copy of the ellipse\n     */\n    Ellipse.prototype.clone = function () {\n        return new Ellipse(this.x, this.y, this.width, this.height);\n    };\n    /**\n     * Checks whether the x and y coordinates given are contained within this ellipse\n     *\n     * @param {number} x - The X coordinate of the point to test\n     * @param {number} y - The Y coordinate of the point to test\n     * @return {boolean} Whether the x/y coords are within this ellipse\n     */\n    Ellipse.prototype.contains = function (x, y) {\n        if (this.width <= 0 || this.height <= 0) {\n            return false;\n        }\n        // normalize the coords to an ellipse with center 0,0\n        var normx = ((x - this.x) / this.width);\n        var normy = ((y - this.y) / this.height);\n        normx *= normx;\n        normy *= normy;\n        return (normx + normy <= 1);\n    };\n    /**\n     * Returns the framing rectangle of the ellipse as a Rectangle object\n     *\n     * @return {PIXI.Rectangle} the framing rectangle\n     */\n    Ellipse.prototype.getBounds = function () {\n        return new Rectangle(this.x - this.width, this.y - this.height, this.width, this.height);\n    };\n    return Ellipse;\n}());\n\n/**\n * A class to define a shape via user defined co-orinates.\n *\n * @class\n * @memberof PIXI\n */\nvar Polygon = /** @class */ (function () {\n    /**\n     * @param {PIXI.IPoint[]|number[]} points - This can be an array of Points\n     *  that form the polygon, a flat array of numbers that will be interpreted as [x,y, x,y, ...], or\n     *  the arguments passed can be all the points of the polygon e.g.\n     *  `new PIXI.Polygon(new PIXI.Point(), new PIXI.Point(), ...)`, or the arguments passed can be flat\n     *  x,y values e.g. `new Polygon(x,y, x,y, x,y, ...)` where `x` and `y` are Numbers.\n     */\n    function Polygon() {\n        var arguments$1 = arguments;\n\n        var points = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            points[_i] = arguments$1[_i];\n        }\n        var flat = Array.isArray(points[0]) ? points[0] : points;\n        // if this is an array of points, convert it to a flat array of numbers\n        if (typeof flat[0] !== 'number') {\n            var p = [];\n            for (var i = 0, il = flat.length; i < il; i++) {\n                p.push(flat[i].x, flat[i].y);\n            }\n            flat = p;\n        }\n        /**\n         * An array of the points of this polygon\n         *\n         * @member {number[]}\n         */\n        this.points = flat;\n        /**\n         * The type of the object, mainly used to avoid `instanceof` checks\n         *\n         * @member {number}\n         * @readOnly\n         * @default PIXI.SHAPES.POLY\n         * @see PIXI.SHAPES\n         */\n        this.type = SHAPES.POLY;\n        /**\n         * `false` after moveTo, `true` after `closePath`. In all other cases it is `true`.\n         * @member {boolean}\n         * @default true\n         */\n        this.closeStroke = true;\n    }\n    /**\n     * Creates a clone of this polygon\n     *\n     * @return {PIXI.Polygon} a copy of the polygon\n     */\n    Polygon.prototype.clone = function () {\n        var points = this.points.slice();\n        var polygon = new Polygon(points);\n        polygon.closeStroke = this.closeStroke;\n        return polygon;\n    };\n    /**\n     * Checks whether the x and y coordinates passed to this function are contained within this polygon\n     *\n     * @param {number} x - The X coordinate of the point to test\n     * @param {number} y - The Y coordinate of the point to test\n     * @return {boolean} Whether the x/y coordinates are within this polygon\n     */\n    Polygon.prototype.contains = function (x, y) {\n        var inside = false;\n        // use some raycasting to test hits\n        // https://github.com/substack/point-in-polygon/blob/master/index.js\n        var length = this.points.length / 2;\n        for (var i = 0, j = length - 1; i < length; j = i++) {\n            var xi = this.points[i * 2];\n            var yi = this.points[(i * 2) + 1];\n            var xj = this.points[j * 2];\n            var yj = this.points[(j * 2) + 1];\n            var intersect = ((yi > y) !== (yj > y)) && (x < ((xj - xi) * ((y - yi) / (yj - yi))) + xi);\n            if (intersect) {\n                inside = !inside;\n            }\n        }\n        return inside;\n    };\n    return Polygon;\n}());\n\n/**\n * The Rounded Rectangle object is an area that has nice rounded corners, as indicated by its\n * top-left corner point (x, y) and by its width and its height and its radius.\n *\n * @class\n * @memberof PIXI\n */\nvar RoundedRectangle = /** @class */ (function () {\n    /**\n     * @param {number} [x=0] - The X coordinate of the upper-left corner of the rounded rectangle\n     * @param {number} [y=0] - The Y coordinate of the upper-left corner of the rounded rectangle\n     * @param {number} [width=0] - The overall width of this rounded rectangle\n     * @param {number} [height=0] - The overall height of this rounded rectangle\n     * @param {number} [radius=20] - Controls the radius of the rounded corners\n     */\n    function RoundedRectangle(x, y, width, height, radius) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        if (width === void 0) { width = 0; }\n        if (height === void 0) { height = 0; }\n        if (radius === void 0) { radius = 20; }\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.x = x;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.y = y;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.width = width;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.height = height;\n        /**\n         * @member {number}\n         * @default 20\n         */\n        this.radius = radius;\n        /**\n         * The type of the object, mainly used to avoid `instanceof` checks\n         *\n         * @member {number}\n         * @readonly\n         * @default PIXI.SHAPES.RREC\n         * @see PIXI.SHAPES\n         */\n        this.type = SHAPES.RREC;\n    }\n    /**\n     * Creates a clone of this Rounded Rectangle\n     *\n     * @return {PIXI.RoundedRectangle} a copy of the rounded rectangle\n     */\n    RoundedRectangle.prototype.clone = function () {\n        return new RoundedRectangle(this.x, this.y, this.width, this.height, this.radius);\n    };\n    /**\n     * Checks whether the x and y coordinates given are contained within this Rounded Rectangle\n     *\n     * @param {number} x - The X coordinate of the point to test\n     * @param {number} y - The Y coordinate of the point to test\n     * @return {boolean} Whether the x/y coordinates are within this Rounded Rectangle\n     */\n    RoundedRectangle.prototype.contains = function (x, y) {\n        if (this.width <= 0 || this.height <= 0) {\n            return false;\n        }\n        if (x >= this.x && x <= this.x + this.width) {\n            if (y >= this.y && y <= this.y + this.height) {\n                if ((y >= this.y + this.radius && y <= this.y + this.height - this.radius)\n                    || (x >= this.x + this.radius && x <= this.x + this.width - this.radius)) {\n                    return true;\n                }\n                var dx = x - (this.x + this.radius);\n                var dy = y - (this.y + this.radius);\n                var radius2 = this.radius * this.radius;\n                if ((dx * dx) + (dy * dy) <= radius2) {\n                    return true;\n                }\n                dx = x - (this.x + this.width - this.radius);\n                if ((dx * dx) + (dy * dy) <= radius2) {\n                    return true;\n                }\n                dy = y - (this.y + this.height - this.radius);\n                if ((dx * dx) + (dy * dy) <= radius2) {\n                    return true;\n                }\n                dx = x - (this.x + this.radius);\n                if ((dx * dx) + (dy * dy) <= radius2) {\n                    return true;\n                }\n            }\n        }\n        return false;\n    };\n    return RoundedRectangle;\n}());\n\n/**\n * Common interface for points. Both Point and ObservablePoint implement it\n * @memberof PIXI\n * @interface IPointData\n */\n/**\n * X coord\n * @memberof PIXI.IPointData#\n * @member {number} x\n */\n/**\n * Y coord\n * @memberof PIXI.IPointData#\n * @member {number} y\n */\n\n/**\n * Common interface for points. Both Point and ObservablePoint implement it\n * @memberof PIXI\n * @interface IPoint\n * @extends PIXI.IPointData\n */\n/**\n * Sets the point to a new x and y position.\n * If y is omitted, both x and y will be set to x.\n *\n * @method set\n * @memberof PIXI.IPoint#\n * @param {number} [x=0] - position of the point on the x axis\n * @param {number} [y=x] - position of the point on the y axis\n */\n/**\n * Copies x and y from the given point\n * @method copyFrom\n * @memberof PIXI.IPoint#\n * @param {PIXI.IPointData} p - The point to copy from\n * @returns {this} Returns itself.\n */\n/**\n * Copies x and y into the given point\n * @method copyTo\n * @memberof PIXI.IPoint#\n * @param {PIXI.IPoint} p - The point to copy.\n * @returns {PIXI.IPoint} Given point with values updated\n */\n/**\n * Returns true if the given point is equal to this point\n *\n * @method equals\n * @memberof PIXI.IPoint#\n * @param {PIXI.IPointData} p - The point to check\n * @returns {boolean} Whether the given point equal to this point\n */\n\n/**\n * The Point object represents a location in a two-dimensional coordinate system, where x represents\n * the horizontal axis and y represents the vertical axis.\n *\n * @class\n * @memberof PIXI\n * @implements IPoint\n */\nvar Point = /** @class */ (function () {\n    /**\n     * @param {number} [x=0] - position of the point on the x axis\n     * @param {number} [y=0] - position of the point on the y axis\n     */\n    function Point(x, y) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.x = x;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.y = y;\n    }\n    /**\n     * Creates a clone of this point\n     *\n     * @return {PIXI.Point} a copy of the point\n     */\n    Point.prototype.clone = function () {\n        return new Point(this.x, this.y);\n    };\n    /**\n     * Copies x and y from the given point\n     *\n     * @param {PIXI.IPointData} p - The point to copy from\n     * @returns {this} Returns itself.\n     */\n    Point.prototype.copyFrom = function (p) {\n        this.set(p.x, p.y);\n        return this;\n    };\n    /**\n     * Copies x and y into the given point\n     *\n     * @param {PIXI.IPoint} p - The point to copy.\n     * @returns {PIXI.IPoint} Given point with values updated\n     */\n    Point.prototype.copyTo = function (p) {\n        p.set(this.x, this.y);\n        return p;\n    };\n    /**\n     * Returns true if the given point is equal to this point\n     *\n     * @param {PIXI.IPointData} p - The point to check\n     * @returns {boolean} Whether the given point equal to this point\n     */\n    Point.prototype.equals = function (p) {\n        return (p.x === this.x) && (p.y === this.y);\n    };\n    /**\n     * Sets the point to a new x and y position.\n     * If y is omitted, both x and y will be set to x.\n     *\n     * @param {number} [x=0] - position of the point on the x axis\n     * @param {number} [y=x] - position of the point on the y axis\n     * @returns {this} Returns itself.\n     */\n    Point.prototype.set = function (x, y) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = x; }\n        this.x = x;\n        this.y = y;\n        return this;\n    };\n    return Point;\n}());\n\n/**\n * The Point object represents a location in a two-dimensional coordinate system, where x represents\n * the horizontal axis and y represents the vertical axis.\n *\n * An ObservablePoint is a point that triggers a callback when the point's position is changed.\n *\n * @class\n * @memberof PIXI\n * @implements IPoint\n */\nvar ObservablePoint = /** @class */ (function () {\n    /**\n     * @param {Function} cb - callback when changed\n     * @param {object} scope - owner of callback\n     * @param {number} [x=0] - position of the point on the x axis\n     * @param {number} [y=0] - position of the point on the y axis\n     */\n    function ObservablePoint(cb, scope, x, y) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = 0; }\n        this._x = x;\n        this._y = y;\n        this.cb = cb;\n        this.scope = scope;\n    }\n    /**\n     * Creates a clone of this point.\n     * The callback and scope params can be overidden otherwise they will default\n     * to the clone object's values.\n     *\n     * @override\n     * @param {Function} [cb=null] - callback when changed\n     * @param {object} [scope=null] - owner of callback\n     * @return {PIXI.ObservablePoint} a copy of the point\n     */\n    ObservablePoint.prototype.clone = function (cb, scope) {\n        if (cb === void 0) { cb = this.cb; }\n        if (scope === void 0) { scope = this.scope; }\n        return new ObservablePoint(cb, scope, this._x, this._y);\n    };\n    /**\n     * Sets the point to a new x and y position.\n     * If y is omitted, both x and y will be set to x.\n     *\n     * @param {number} [x=0] - position of the point on the x axis\n     * @param {number} [y=x] - position of the point on the y axis\n     * @returns {this} Returns itself.\n     */\n    ObservablePoint.prototype.set = function (x, y) {\n        if (x === void 0) { x = 0; }\n        if (y === void 0) { y = x; }\n        if (this._x !== x || this._y !== y) {\n            this._x = x;\n            this._y = y;\n            this.cb.call(this.scope);\n        }\n        return this;\n    };\n    /**\n     * Copies x and y from the given point\n     *\n     * @param {PIXI.IPointData} p - The point to copy from.\n     * @returns {this} Returns itself.\n     */\n    ObservablePoint.prototype.copyFrom = function (p) {\n        if (this._x !== p.x || this._y !== p.y) {\n            this._x = p.x;\n            this._y = p.y;\n            this.cb.call(this.scope);\n        }\n        return this;\n    };\n    /**\n     * Copies x and y into the given point\n     *\n     * @param {PIXI.IPoint} p - The point to copy.\n     * @returns {PIXI.IPoint} Given point with values updated\n     */\n    ObservablePoint.prototype.copyTo = function (p) {\n        p.set(this._x, this._y);\n        return p;\n    };\n    /**\n     * Returns true if the given point is equal to this point\n     *\n     * @param {PIXI.IPointData} p - The point to check\n     * @returns {boolean} Whether the given point equal to this point\n     */\n    ObservablePoint.prototype.equals = function (p) {\n        return (p.x === this._x) && (p.y === this._y);\n    };\n    Object.defineProperty(ObservablePoint.prototype, \"x\", {\n        /**\n         * The position of the displayObject on the x axis relative to the local coordinates of the parent.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._x;\n        },\n        set: function (value) {\n            if (this._x !== value) {\n                this._x = value;\n                this.cb.call(this.scope);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(ObservablePoint.prototype, \"y\", {\n        /**\n         * The position of the displayObject on the x axis relative to the local coordinates of the parent.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._y;\n        },\n        set: function (value) {\n            if (this._y !== value) {\n                this._y = value;\n                this.cb.call(this.scope);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return ObservablePoint;\n}());\n\n/**\n * The PixiJS Matrix as a class makes it a lot faster.\n *\n * Here is a representation of it:\n * ```js\n * | a | c | tx|\n * | b | d | ty|\n * | 0 | 0 | 1 |\n * ```\n * @class\n * @memberof PIXI\n */\nvar Matrix = /** @class */ (function () {\n    /**\n     * @param {number} [a=1] - x scale\n     * @param {number} [b=0] - x skew\n     * @param {number} [c=0] - y skew\n     * @param {number} [d=1] - y scale\n     * @param {number} [tx=0] - x translation\n     * @param {number} [ty=0] - y translation\n     */\n    function Matrix(a, b, c, d, tx, ty) {\n        if (a === void 0) { a = 1; }\n        if (b === void 0) { b = 0; }\n        if (c === void 0) { c = 0; }\n        if (d === void 0) { d = 1; }\n        if (tx === void 0) { tx = 0; }\n        if (ty === void 0) { ty = 0; }\n        this.array = null;\n        /**\n         * @member {number}\n         * @default 1\n         */\n        this.a = a;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.b = b;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.c = c;\n        /**\n         * @member {number}\n         * @default 1\n         */\n        this.d = d;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.tx = tx;\n        /**\n         * @member {number}\n         * @default 0\n         */\n        this.ty = ty;\n    }\n    /**\n     * Creates a Matrix object based on the given array. The Element to Matrix mapping order is as follows:\n     *\n     * a = array[0]\n     * b = array[1]\n     * c = array[3]\n     * d = array[4]\n     * tx = array[2]\n     * ty = array[5]\n     *\n     * @param {number[]} array - The array that the matrix will be populated from.\n     */\n    Matrix.prototype.fromArray = function (array) {\n        this.a = array[0];\n        this.b = array[1];\n        this.c = array[3];\n        this.d = array[4];\n        this.tx = array[2];\n        this.ty = array[5];\n    };\n    /**\n     * sets the matrix properties\n     *\n     * @param {number} a - Matrix component\n     * @param {number} b - Matrix component\n     * @param {number} c - Matrix component\n     * @param {number} d - Matrix component\n     * @param {number} tx - Matrix component\n     * @param {number} ty - Matrix component\n     *\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.set = function (a, b, c, d, tx, ty) {\n        this.a = a;\n        this.b = b;\n        this.c = c;\n        this.d = d;\n        this.tx = tx;\n        this.ty = ty;\n        return this;\n    };\n    /**\n     * Creates an array from the current Matrix object.\n     *\n     * @param {boolean} transpose - Whether we need to transpose the matrix or not\n     * @param {Float32Array} [out=new Float32Array(9)] - If provided the array will be assigned to out\n     * @return {number[]} the newly created array which contains the matrix\n     */\n    Matrix.prototype.toArray = function (transpose, out) {\n        if (!this.array) {\n            this.array = new Float32Array(9);\n        }\n        var array = out || this.array;\n        if (transpose) {\n            array[0] = this.a;\n            array[1] = this.b;\n            array[2] = 0;\n            array[3] = this.c;\n            array[4] = this.d;\n            array[5] = 0;\n            array[6] = this.tx;\n            array[7] = this.ty;\n            array[8] = 1;\n        }\n        else {\n            array[0] = this.a;\n            array[1] = this.c;\n            array[2] = this.tx;\n            array[3] = this.b;\n            array[4] = this.d;\n            array[5] = this.ty;\n            array[6] = 0;\n            array[7] = 0;\n            array[8] = 1;\n        }\n        return array;\n    };\n    /**\n     * Get a new position with the current transformation applied.\n     * Can be used to go from a child's coordinate space to the world coordinate space. (e.g. rendering)\n     *\n     * @param {PIXI.IPointData} pos - The origin\n     * @param {PIXI.Point} [newPos] - The point that the new position is assigned to (allowed to be same as input)\n     * @return {PIXI.Point} The new point, transformed through this matrix\n     */\n    Matrix.prototype.apply = function (pos, newPos) {\n        newPos = (newPos || new Point());\n        var x = pos.x;\n        var y = pos.y;\n        newPos.x = (this.a * x) + (this.c * y) + this.tx;\n        newPos.y = (this.b * x) + (this.d * y) + this.ty;\n        return newPos;\n    };\n    /**\n     * Get a new position with the inverse of the current transformation applied.\n     * Can be used to go from the world coordinate space to a child's coordinate space. (e.g. input)\n     *\n     * @param {PIXI.IPointData} pos - The origin\n     * @param {PIXI.Point} [newPos] - The point that the new position is assigned to (allowed to be same as input)\n     * @return {PIXI.Point} The new point, inverse-transformed through this matrix\n     */\n    Matrix.prototype.applyInverse = function (pos, newPos) {\n        newPos = (newPos || new Point());\n        var id = 1 / ((this.a * this.d) + (this.c * -this.b));\n        var x = pos.x;\n        var y = pos.y;\n        newPos.x = (this.d * id * x) + (-this.c * id * y) + (((this.ty * this.c) - (this.tx * this.d)) * id);\n        newPos.y = (this.a * id * y) + (-this.b * id * x) + (((-this.ty * this.a) + (this.tx * this.b)) * id);\n        return newPos;\n    };\n    /**\n     * Translates the matrix on the x and y.\n     *\n     * @param {number} x - How much to translate x by\n     * @param {number} y - How much to translate y by\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.translate = function (x, y) {\n        this.tx += x;\n        this.ty += y;\n        return this;\n    };\n    /**\n     * Applies a scale transformation to the matrix.\n     *\n     * @param {number} x - The amount to scale horizontally\n     * @param {number} y - The amount to scale vertically\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.scale = function (x, y) {\n        this.a *= x;\n        this.d *= y;\n        this.c *= x;\n        this.b *= y;\n        this.tx *= x;\n        this.ty *= y;\n        return this;\n    };\n    /**\n     * Applies a rotation transformation to the matrix.\n     *\n     * @param {number} angle - The angle in radians.\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.rotate = function (angle) {\n        var cos = Math.cos(angle);\n        var sin = Math.sin(angle);\n        var a1 = this.a;\n        var c1 = this.c;\n        var tx1 = this.tx;\n        this.a = (a1 * cos) - (this.b * sin);\n        this.b = (a1 * sin) + (this.b * cos);\n        this.c = (c1 * cos) - (this.d * sin);\n        this.d = (c1 * sin) + (this.d * cos);\n        this.tx = (tx1 * cos) - (this.ty * sin);\n        this.ty = (tx1 * sin) + (this.ty * cos);\n        return this;\n    };\n    /**\n     * Appends the given Matrix to this Matrix.\n     *\n     * @param {PIXI.Matrix} matrix - The matrix to append.\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.append = function (matrix) {\n        var a1 = this.a;\n        var b1 = this.b;\n        var c1 = this.c;\n        var d1 = this.d;\n        this.a = (matrix.a * a1) + (matrix.b * c1);\n        this.b = (matrix.a * b1) + (matrix.b * d1);\n        this.c = (matrix.c * a1) + (matrix.d * c1);\n        this.d = (matrix.c * b1) + (matrix.d * d1);\n        this.tx = (matrix.tx * a1) + (matrix.ty * c1) + this.tx;\n        this.ty = (matrix.tx * b1) + (matrix.ty * d1) + this.ty;\n        return this;\n    };\n    /**\n     * Sets the matrix based on all the available properties\n     *\n     * @param {number} x - Position on the x axis\n     * @param {number} y - Position on the y axis\n     * @param {number} pivotX - Pivot on the x axis\n     * @param {number} pivotY - Pivot on the y axis\n     * @param {number} scaleX - Scale on the x axis\n     * @param {number} scaleY - Scale on the y axis\n     * @param {number} rotation - Rotation in radians\n     * @param {number} skewX - Skew on the x axis\n     * @param {number} skewY - Skew on the y axis\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.setTransform = function (x, y, pivotX, pivotY, scaleX, scaleY, rotation, skewX, skewY) {\n        this.a = Math.cos(rotation + skewY) * scaleX;\n        this.b = Math.sin(rotation + skewY) * scaleX;\n        this.c = -Math.sin(rotation - skewX) * scaleY;\n        this.d = Math.cos(rotation - skewX) * scaleY;\n        this.tx = x - ((pivotX * this.a) + (pivotY * this.c));\n        this.ty = y - ((pivotX * this.b) + (pivotY * this.d));\n        return this;\n    };\n    /**\n     * Prepends the given Matrix to this Matrix.\n     *\n     * @param {PIXI.Matrix} matrix - The matrix to prepend\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.prepend = function (matrix) {\n        var tx1 = this.tx;\n        if (matrix.a !== 1 || matrix.b !== 0 || matrix.c !== 0 || matrix.d !== 1) {\n            var a1 = this.a;\n            var c1 = this.c;\n            this.a = (a1 * matrix.a) + (this.b * matrix.c);\n            this.b = (a1 * matrix.b) + (this.b * matrix.d);\n            this.c = (c1 * matrix.a) + (this.d * matrix.c);\n            this.d = (c1 * matrix.b) + (this.d * matrix.d);\n        }\n        this.tx = (tx1 * matrix.a) + (this.ty * matrix.c) + matrix.tx;\n        this.ty = (tx1 * matrix.b) + (this.ty * matrix.d) + matrix.ty;\n        return this;\n    };\n    /**\n     * Decomposes the matrix (x, y, scaleX, scaleY, and rotation) and sets the properties on to a transform.\n     *\n     * @param {PIXI.Transform} transform - The transform to apply the properties to.\n     * @return {PIXI.Transform} The transform with the newly applied properties\n     */\n    Matrix.prototype.decompose = function (transform) {\n        // sort out rotation / skew..\n        var a = this.a;\n        var b = this.b;\n        var c = this.c;\n        var d = this.d;\n        var skewX = -Math.atan2(-c, d);\n        var skewY = Math.atan2(b, a);\n        var delta = Math.abs(skewX + skewY);\n        if (delta < 0.00001 || Math.abs(PI_2 - delta) < 0.00001) {\n            transform.rotation = skewY;\n            transform.skew.x = transform.skew.y = 0;\n        }\n        else {\n            transform.rotation = 0;\n            transform.skew.x = skewX;\n            transform.skew.y = skewY;\n        }\n        // next set scale\n        transform.scale.x = Math.sqrt((a * a) + (b * b));\n        transform.scale.y = Math.sqrt((c * c) + (d * d));\n        // next set position\n        transform.position.x = this.tx;\n        transform.position.y = this.ty;\n        return transform;\n    };\n    /**\n     * Inverts this matrix\n     *\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.invert = function () {\n        var a1 = this.a;\n        var b1 = this.b;\n        var c1 = this.c;\n        var d1 = this.d;\n        var tx1 = this.tx;\n        var n = (a1 * d1) - (b1 * c1);\n        this.a = d1 / n;\n        this.b = -b1 / n;\n        this.c = -c1 / n;\n        this.d = a1 / n;\n        this.tx = ((c1 * this.ty) - (d1 * tx1)) / n;\n        this.ty = -((a1 * this.ty) - (b1 * tx1)) / n;\n        return this;\n    };\n    /**\n     * Resets this Matrix to an identity (default) matrix.\n     *\n     * @return {PIXI.Matrix} This matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.identity = function () {\n        this.a = 1;\n        this.b = 0;\n        this.c = 0;\n        this.d = 1;\n        this.tx = 0;\n        this.ty = 0;\n        return this;\n    };\n    /**\n     * Creates a new Matrix object with the same values as this one.\n     *\n     * @return {PIXI.Matrix} A copy of this matrix. Good for chaining method calls.\n     */\n    Matrix.prototype.clone = function () {\n        var matrix = new Matrix();\n        matrix.a = this.a;\n        matrix.b = this.b;\n        matrix.c = this.c;\n        matrix.d = this.d;\n        matrix.tx = this.tx;\n        matrix.ty = this.ty;\n        return matrix;\n    };\n    /**\n     * Changes the values of the given matrix to be the same as the ones in this matrix\n     *\n     * @param {PIXI.Matrix} matrix - The matrix to copy to.\n     * @return {PIXI.Matrix} The matrix given in parameter with its values updated.\n     */\n    Matrix.prototype.copyTo = function (matrix) {\n        matrix.a = this.a;\n        matrix.b = this.b;\n        matrix.c = this.c;\n        matrix.d = this.d;\n        matrix.tx = this.tx;\n        matrix.ty = this.ty;\n        return matrix;\n    };\n    /**\n     * Changes the values of the matrix to be the same as the ones in given matrix\n     *\n     * @param {PIXI.Matrix} matrix - The matrix to copy from.\n     * @return {PIXI.Matrix} this\n     */\n    Matrix.prototype.copyFrom = function (matrix) {\n        this.a = matrix.a;\n        this.b = matrix.b;\n        this.c = matrix.c;\n        this.d = matrix.d;\n        this.tx = matrix.tx;\n        this.ty = matrix.ty;\n        return this;\n    };\n    Object.defineProperty(Matrix, \"IDENTITY\", {\n        /**\n         * A default (identity) matrix\n         *\n         * @static\n         * @const\n         * @member {PIXI.Matrix}\n         */\n        get: function () {\n            return new Matrix();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Matrix, \"TEMP_MATRIX\", {\n        /**\n         * A temp matrix\n         *\n         * @static\n         * @const\n         * @member {PIXI.Matrix}\n         */\n        get: function () {\n            return new Matrix();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return Matrix;\n}());\n\n// Your friendly neighbour https://en.wikipedia.org/wiki/Dihedral_group\n/*\n * Transform matrix for operation n is:\n * | ux | vx |\n * | uy | vy |\n */\nvar ux = [1, 1, 0, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1, -1, 0, 1];\nvar uy = [0, 1, 1, 1, 0, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1, -1];\nvar vx = [0, -1, -1, -1, 0, 1, 1, 1, 0, 1, 1, 1, 0, -1, -1, -1];\nvar vy = [1, 1, 0, -1, -1, -1, 0, 1, -1, -1, 0, 1, 1, 1, 0, -1];\n/**\n * [Cayley Table]{@link https://en.wikipedia.org/wiki/Cayley_table}\n * for the composition of each rotation in the dihederal group D8.\n *\n * @type number[][]\n * @private\n */\nvar rotationCayley = [];\n/**\n * Matrices for each `GD8Symmetry` rotation.\n *\n * @type Matrix[]\n * @private\n */\nvar rotationMatrices = [];\n/*\n * Alias for {@code Math.sign}.\n */\nvar signum = Math.sign;\n/*\n * Initializes `rotationCayley` and `rotationMatrices`. It is called\n * only once below.\n */\nfunction init() {\n    for (var i = 0; i < 16; i++) {\n        var row = [];\n        rotationCayley.push(row);\n        for (var j = 0; j < 16; j++) {\n            /* Multiplies rotation matrices i and j. */\n            var _ux = signum((ux[i] * ux[j]) + (vx[i] * uy[j]));\n            var _uy = signum((uy[i] * ux[j]) + (vy[i] * uy[j]));\n            var _vx = signum((ux[i] * vx[j]) + (vx[i] * vy[j]));\n            var _vy = signum((uy[i] * vx[j]) + (vy[i] * vy[j]));\n            /* Finds rotation matrix matching the product and pushes it. */\n            for (var k = 0; k < 16; k++) {\n                if (ux[k] === _ux && uy[k] === _uy\n                    && vx[k] === _vx && vy[k] === _vy) {\n                    row.push(k);\n                    break;\n                }\n            }\n        }\n    }\n    for (var i = 0; i < 16; i++) {\n        var mat = new Matrix();\n        mat.set(ux[i], uy[i], vx[i], vy[i], 0, 0);\n        rotationMatrices.push(mat);\n    }\n}\ninit();\n/**\n * @memberof PIXI\n * @typedef {number} GD8Symmetry\n * @see PIXI.groupD8\n */\n/**\n * Implements the dihedral group D8, which is similar to\n * [group D4]{@link http://mathworld.wolfram.com/DihedralGroupD4.html};\n * D8 is the same but with diagonals, and it is used for texture\n * rotations.\n *\n * The directions the U- and V- axes after rotation\n * of an angle of `a: GD8Constant` are the vectors `(uX(a), uY(a))`\n * and `(vX(a), vY(a))`. These aren't necessarily unit vectors.\n *\n * **Origin:**<br>\n *  This is the small part of gameofbombs.com portal system. It works.\n *\n * @see PIXI.groupD8.E\n * @see PIXI.groupD8.SE\n * @see PIXI.groupD8.S\n * @see PIXI.groupD8.SW\n * @see PIXI.groupD8.W\n * @see PIXI.groupD8.NW\n * @see PIXI.groupD8.N\n * @see PIXI.groupD8.NE\n * @author Ivan @ivanpopelyshev\n * @namespace PIXI.groupD8\n * @memberof PIXI\n */\nvar groupD8 = {\n    /**\n     * | Rotation | Direction |\n     * |----------|-----------|\n     * | 0°       | East      |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    E: 0,\n    /**\n     * | Rotation | Direction |\n     * |----------|-----------|\n     * | 45°↻     | Southeast |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    SE: 1,\n    /**\n     * | Rotation | Direction |\n     * |----------|-----------|\n     * | 90°↻     | South     |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    S: 2,\n    /**\n     * | Rotation | Direction |\n     * |----------|-----------|\n     * | 135°↻    | Southwest |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    SW: 3,\n    /**\n     * | Rotation | Direction |\n     * |----------|-----------|\n     * | 180°     | West      |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    W: 4,\n    /**\n     * | Rotation    | Direction    |\n     * |-------------|--------------|\n     * | -135°/225°↻ | Northwest    |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    NW: 5,\n    /**\n     * | Rotation    | Direction    |\n     * |-------------|--------------|\n     * | -90°/270°↻  | North        |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    N: 6,\n    /**\n     * | Rotation    | Direction    |\n     * |-------------|--------------|\n     * | -45°/315°↻  | Northeast    |\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    NE: 7,\n    /**\n     * Reflection about Y-axis.\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    MIRROR_VERTICAL: 8,\n    /**\n     * Reflection about the main diagonal.\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    MAIN_DIAGONAL: 10,\n    /**\n     * Reflection about X-axis.\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    MIRROR_HORIZONTAL: 12,\n    /**\n     * Reflection about reverse diagonal.\n     *\n     * @memberof PIXI.groupD8\n     * @constant {PIXI.GD8Symmetry}\n     */\n    REVERSE_DIAGONAL: 14,\n    /**\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} ind - sprite rotation angle.\n     * @return {PIXI.GD8Symmetry} The X-component of the U-axis\n     *    after rotating the axes.\n     */\n    uX: function (ind) { return ux[ind]; },\n    /**\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} ind - sprite rotation angle.\n     * @return {PIXI.GD8Symmetry} The Y-component of the U-axis\n     *    after rotating the axes.\n     */\n    uY: function (ind) { return uy[ind]; },\n    /**\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} ind - sprite rotation angle.\n     * @return {PIXI.GD8Symmetry} The X-component of the V-axis\n     *    after rotating the axes.\n     */\n    vX: function (ind) { return vx[ind]; },\n    /**\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} ind - sprite rotation angle.\n     * @return {PIXI.GD8Symmetry} The Y-component of the V-axis\n     *    after rotating the axes.\n     */\n    vY: function (ind) { return vy[ind]; },\n    /**\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} rotation - symmetry whose opposite\n     *   is needed. Only rotations have opposite symmetries while\n     *   reflections don't.\n     * @return {PIXI.GD8Symmetry} The opposite symmetry of `rotation`\n     */\n    inv: function (rotation) {\n        if (rotation & 8) // true only if between 8 & 15 (reflections)\n         {\n            return rotation & 15; // or rotation % 16\n        }\n        return (-rotation) & 7; // or (8 - rotation) % 8\n    },\n    /**\n     * Composes the two D8 operations.\n     *\n     * Taking `^` as reflection:\n     *\n     * |       | E=0 | S=2 | W=4 | N=6 | E^=8 | S^=10 | W^=12 | N^=14 |\n     * |-------|-----|-----|-----|-----|------|-------|-------|-------|\n     * | E=0   | E   | S   | W   | N   | E^   | S^    | W^    | N^    |\n     * | S=2   | S   | W   | N   | E   | S^   | W^    | N^    | E^    |\n     * | W=4   | W   | N   | E   | S   | W^   | N^    | E^    | S^    |\n     * | N=6   | N   | E   | S   | W   | N^   | E^    | S^    | W^    |\n     * | E^=8  | E^  | N^  | W^  | S^  | E    | N     | W     | S     |\n     * | S^=10 | S^  | E^  | N^  | W^  | S    | E     | N     | W     |\n     * | W^=12 | W^  | S^  | E^  | N^  | W    | S     | E     | N     |\n     * | N^=14 | N^  | W^  | S^  | E^  | N    | W     | S     | E     |\n     *\n     * [This is a Cayley table]{@link https://en.wikipedia.org/wiki/Cayley_table}\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} rotationSecond - Second operation, which\n     *   is the row in the above cayley table.\n     * @param {PIXI.GD8Symmetry} rotationFirst - First operation, which\n     *   is the column in the above cayley table.\n     * @return {PIXI.GD8Symmetry} Composed operation\n     */\n    add: function (rotationSecond, rotationFirst) { return (rotationCayley[rotationSecond][rotationFirst]); },\n    /**\n     * Reverse of `add`.\n     *\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} rotationSecond - Second operation\n     * @param {PIXI.GD8Symmetry} rotationFirst - First operation\n     * @return {PIXI.GD8Symmetry} Result\n     */\n    sub: function (rotationSecond, rotationFirst) { return (rotationCayley[rotationSecond][groupD8.inv(rotationFirst)]); },\n    /**\n     * Adds 180 degrees to rotation, which is a commutative\n     * operation.\n     *\n     * @memberof PIXI.groupD8\n     * @param {number} rotation - The number to rotate.\n     * @returns {number} Rotated number\n     */\n    rotate180: function (rotation) { return rotation ^ 4; },\n    /**\n     * Checks if the rotation angle is vertical, i.e. south\n     * or north. It doesn't work for reflections.\n     *\n     * @memberof PIXI.groupD8\n     * @param {PIXI.GD8Symmetry} rotation - The number to check.\n     * @returns {boolean} Whether or not the direction is vertical\n     */\n    isVertical: function (rotation) { return (rotation & 3) === 2; },\n    /**\n     * Approximates the vector `V(dx,dy)` into one of the\n     * eight directions provided by `groupD8`.\n     *\n     * @memberof PIXI.groupD8\n     * @param {number} dx - X-component of the vector\n     * @param {number} dy - Y-component of the vector\n     * @return {PIXI.GD8Symmetry} Approximation of the vector into\n     *  one of the eight symmetries.\n     */\n    byDirection: function (dx, dy) {\n        if (Math.abs(dx) * 2 <= Math.abs(dy)) {\n            if (dy >= 0) {\n                return groupD8.S;\n            }\n            return groupD8.N;\n        }\n        else if (Math.abs(dy) * 2 <= Math.abs(dx)) {\n            if (dx > 0) {\n                return groupD8.E;\n            }\n            return groupD8.W;\n        }\n        else if (dy > 0) {\n            if (dx > 0) {\n                return groupD8.SE;\n            }\n            return groupD8.SW;\n        }\n        else if (dx > 0) {\n            return groupD8.NE;\n        }\n        return groupD8.NW;\n    },\n    /**\n     * Helps sprite to compensate texture packer rotation.\n     *\n     * @memberof PIXI.groupD8\n     * @param {PIXI.Matrix} matrix - sprite world matrix\n     * @param {PIXI.GD8Symmetry} rotation - The rotation factor to use.\n     * @param {number} tx - sprite anchoring\n     * @param {number} ty - sprite anchoring\n     */\n    matrixAppendRotationInv: function (matrix, rotation, tx, ty) {\n        if (tx === void 0) { tx = 0; }\n        if (ty === void 0) { ty = 0; }\n        // Packer used \"rotation\", we use \"inv(rotation)\"\n        var mat = rotationMatrices[groupD8.inv(rotation)];\n        mat.tx = tx;\n        mat.ty = ty;\n        matrix.append(mat);\n    },\n};\n\n/**\n * Transform that takes care about its versions\n *\n * @class\n * @memberof PIXI\n */\nvar Transform = /** @class */ (function () {\n    function Transform() {\n        /**\n         * The world transformation matrix.\n         *\n         * @member {PIXI.Matrix}\n         */\n        this.worldTransform = new Matrix();\n        /**\n         * The local transformation matrix.\n         *\n         * @member {PIXI.Matrix}\n         */\n        this.localTransform = new Matrix();\n        /**\n         * The coordinate of the object relative to the local coordinates of the parent.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        this.position = new ObservablePoint(this.onChange, this, 0, 0);\n        /**\n         * The scale factor of the object.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        this.scale = new ObservablePoint(this.onChange, this, 1, 1);\n        /**\n         * The pivot point of the displayObject that it rotates around.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        this.pivot = new ObservablePoint(this.onChange, this, 0, 0);\n        /**\n         * The skew amount, on the x and y axis.\n         *\n         * @member {PIXI.ObservablePoint}\n         */\n        this.skew = new ObservablePoint(this.updateSkew, this, 0, 0);\n        /**\n         * The rotation amount.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._rotation = 0;\n        /**\n         * The X-coordinate value of the normalized local X axis,\n         * the first column of the local transformation matrix without a scale.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._cx = 1;\n        /**\n         * The Y-coordinate value of the normalized local X axis,\n         * the first column of the local transformation matrix without a scale.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._sx = 0;\n        /**\n         * The X-coordinate value of the normalized local Y axis,\n         * the second column of the local transformation matrix without a scale.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._cy = 0;\n        /**\n         * The Y-coordinate value of the normalized local Y axis,\n         * the second column of the local transformation matrix without a scale.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._sy = 1;\n        /**\n         * The locally unique ID of the local transform.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._localID = 0;\n        /**\n         * The locally unique ID of the local transform\n         * used to calculate the current local transformation matrix.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._currentLocalID = 0;\n        /**\n         * The locally unique ID of the world transform.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._worldID = 0;\n        /**\n         * The locally unique ID of the parent's world transform\n         * used to calculate the current world transformation matrix.\n         *\n         * @protected\n         * @member {number}\n         */\n        this._parentID = 0;\n    }\n    /**\n     * Called when a value changes.\n     *\n     * @protected\n     */\n    Transform.prototype.onChange = function () {\n        this._localID++;\n    };\n    /**\n     * Called when the skew or the rotation changes.\n     *\n     * @protected\n     */\n    Transform.prototype.updateSkew = function () {\n        this._cx = Math.cos(this._rotation + this.skew.y);\n        this._sx = Math.sin(this._rotation + this.skew.y);\n        this._cy = -Math.sin(this._rotation - this.skew.x); // cos, added PI/2\n        this._sy = Math.cos(this._rotation - this.skew.x); // sin, added PI/2\n        this._localID++;\n    };\n    /**\n     * Updates the local transformation matrix.\n     */\n    Transform.prototype.updateLocalTransform = function () {\n        var lt = this.localTransform;\n        if (this._localID !== this._currentLocalID) {\n            // get the matrix values of the displayobject based on its transform properties..\n            lt.a = this._cx * this.scale.x;\n            lt.b = this._sx * this.scale.x;\n            lt.c = this._cy * this.scale.y;\n            lt.d = this._sy * this.scale.y;\n            lt.tx = this.position.x - ((this.pivot.x * lt.a) + (this.pivot.y * lt.c));\n            lt.ty = this.position.y - ((this.pivot.x * lt.b) + (this.pivot.y * lt.d));\n            this._currentLocalID = this._localID;\n            // force an update..\n            this._parentID = -1;\n        }\n    };\n    /**\n     * Updates the local and the world transformation matrices.\n     *\n     * @param {PIXI.Transform} parentTransform - The parent transform\n     */\n    Transform.prototype.updateTransform = function (parentTransform) {\n        var lt = this.localTransform;\n        if (this._localID !== this._currentLocalID) {\n            // get the matrix values of the displayobject based on its transform properties..\n            lt.a = this._cx * this.scale.x;\n            lt.b = this._sx * this.scale.x;\n            lt.c = this._cy * this.scale.y;\n            lt.d = this._sy * this.scale.y;\n            lt.tx = this.position.x - ((this.pivot.x * lt.a) + (this.pivot.y * lt.c));\n            lt.ty = this.position.y - ((this.pivot.x * lt.b) + (this.pivot.y * lt.d));\n            this._currentLocalID = this._localID;\n            // force an update..\n            this._parentID = -1;\n        }\n        if (this._parentID !== parentTransform._worldID) {\n            // concat the parent matrix with the objects transform.\n            var pt = parentTransform.worldTransform;\n            var wt = this.worldTransform;\n            wt.a = (lt.a * pt.a) + (lt.b * pt.c);\n            wt.b = (lt.a * pt.b) + (lt.b * pt.d);\n            wt.c = (lt.c * pt.a) + (lt.d * pt.c);\n            wt.d = (lt.c * pt.b) + (lt.d * pt.d);\n            wt.tx = (lt.tx * pt.a) + (lt.ty * pt.c) + pt.tx;\n            wt.ty = (lt.tx * pt.b) + (lt.ty * pt.d) + pt.ty;\n            this._parentID = parentTransform._worldID;\n            // update the id of the transform..\n            this._worldID++;\n        }\n    };\n    /**\n     * Decomposes a matrix and sets the transforms properties based on it.\n     *\n     * @param {PIXI.Matrix} matrix - The matrix to decompose\n     */\n    Transform.prototype.setFromMatrix = function (matrix) {\n        matrix.decompose(this);\n        this._localID++;\n    };\n    Object.defineProperty(Transform.prototype, \"rotation\", {\n        /**\n         * The rotation of the object in radians.\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._rotation;\n        },\n        set: function (value) {\n            if (this._rotation !== value) {\n                this._rotation = value;\n                this.updateSkew();\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * A default (identity) transform\n     *\n     * @static\n     * @constant\n     * @member {PIXI.Transform}\n     */\n    Transform.IDENTITY = new Transform();\n    return Transform;\n}());\n\n/**\n * Math classes and utilities mixed into PIXI namespace.\n *\n * @lends PIXI\n */\n\n\n//# sourceMappingURL=math.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/math/lib/math.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/mesh-extras/lib/mesh-extras.es.js":
/*!**************************************************************!*\
  !*** ./node_modules/@pixi/mesh-extras/lib/mesh-extras.es.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"NineSlicePlane\": () => (/* binding */ NineSlicePlane),\n/* harmony export */   \"PlaneGeometry\": () => (/* binding */ PlaneGeometry),\n/* harmony export */   \"RopeGeometry\": () => (/* binding */ RopeGeometry),\n/* harmony export */   \"SimpleMesh\": () => (/* binding */ SimpleMesh),\n/* harmony export */   \"SimplePlane\": () => (/* binding */ SimplePlane),\n/* harmony export */   \"SimpleRope\": () => (/* binding */ SimpleRope)\n/* harmony export */ });\n/* harmony import */ var _pixi_mesh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/mesh */ \"./node_modules/@pixi/mesh/lib/mesh.es.js\");\n/* harmony import */ var _pixi_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/constants */ \"./node_modules/@pixi/constants/lib/constants.es.js\");\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/*!\n * @pixi/mesh-extras - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/mesh-extras is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\nvar PlaneGeometry = /** @class */ (function (_super) {\n    __extends(PlaneGeometry, _super);\n    function PlaneGeometry(width, height, segWidth, segHeight) {\n        if (width === void 0) { width = 100; }\n        if (height === void 0) { height = 100; }\n        if (segWidth === void 0) { segWidth = 10; }\n        if (segHeight === void 0) { segHeight = 10; }\n        var _this = _super.call(this) || this;\n        _this.segWidth = segWidth;\n        _this.segHeight = segHeight;\n        _this.width = width;\n        _this.height = height;\n        _this.build();\n        return _this;\n    }\n    /**\n     * Refreshes plane coordinates\n     * @private\n     */\n    PlaneGeometry.prototype.build = function () {\n        var total = this.segWidth * this.segHeight;\n        var verts = [];\n        var uvs = [];\n        var indices = [];\n        var segmentsX = this.segWidth - 1;\n        var segmentsY = this.segHeight - 1;\n        var sizeX = (this.width) / segmentsX;\n        var sizeY = (this.height) / segmentsY;\n        for (var i = 0; i < total; i++) {\n            var x = (i % this.segWidth);\n            var y = ((i / this.segWidth) | 0);\n            verts.push(x * sizeX, y * sizeY);\n            uvs.push(x / segmentsX, y / segmentsY);\n        }\n        var totalSub = segmentsX * segmentsY;\n        for (var i = 0; i < totalSub; i++) {\n            var xpos = i % segmentsX;\n            var ypos = (i / segmentsX) | 0;\n            var value = (ypos * this.segWidth) + xpos;\n            var value2 = (ypos * this.segWidth) + xpos + 1;\n            var value3 = ((ypos + 1) * this.segWidth) + xpos;\n            var value4 = ((ypos + 1) * this.segWidth) + xpos + 1;\n            indices.push(value, value2, value3, value2, value4, value3);\n        }\n        this.buffers[0].data = new Float32Array(verts);\n        this.buffers[1].data = new Float32Array(uvs);\n        this.indexBuffer.data = new Uint16Array(indices);\n        // ensure that the changes are uploaded\n        this.buffers[0].update();\n        this.buffers[1].update();\n        this.indexBuffer.update();\n    };\n    return PlaneGeometry;\n}(_pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshGeometry));\n\n/**\n * RopeGeometry allows you to draw a geometry across several points and then manipulate these points.\n *\n * ```js\n * for (let i = 0; i < 20; i++) {\n *     points.push(new PIXI.Point(i * 50, 0));\n * };\n * const rope = new PIXI.RopeGeometry(100, points);\n * ```\n *\n * @class\n * @extends PIXI.MeshGeometry\n * @memberof PIXI\n *\n */\nvar RopeGeometry = /** @class */ (function (_super) {\n    __extends(RopeGeometry, _super);\n    /**\n     * @param {number} [width=200] - The width (i.e., thickness) of the rope.\n     * @param {PIXI.Point[]} [points] - An array of {@link PIXI.Point} objects to construct this rope.\n     * @param {number} [textureScale=0] - By default the rope texture will be stretched to match\n     *     rope length. If textureScale is positive this value will be treated as a scaling\n     *     factor and the texture will preserve its aspect ratio instead. To create a tiling rope\n     *     set baseTexture.wrapMode to {@link PIXI.WRAP_MODES.REPEAT} and use a power of two texture,\n     *     then set textureScale=1 to keep the original texture pixel size.\n     *     In order to reduce alpha channel artifacts provide a larger texture and downsample -\n     *     i.e. set textureScale=0.5 to scale it down twice.\n     */\n    function RopeGeometry(width, points, textureScale) {\n        if (width === void 0) { width = 200; }\n        if (textureScale === void 0) { textureScale = 0; }\n        var _this = _super.call(this, new Float32Array(points.length * 4), new Float32Array(points.length * 4), new Uint16Array((points.length - 1) * 6)) || this;\n        /**\n         * An array of points that determine the rope\n         * @member {PIXI.Point[]}\n         */\n        _this.points = points;\n        /**\n         * The width (i.e., thickness) of the rope.\n         * @member {number}\n         * @readOnly\n         */\n        _this._width = width;\n        /**\n         * Rope texture scale, if zero then the rope texture is stretched.\n         * @member {number}\n         * @readOnly\n         */\n        _this.textureScale = textureScale;\n        _this.build();\n        return _this;\n    }\n    Object.defineProperty(RopeGeometry.prototype, \"width\", {\n        /**\n         * The width (i.e., thickness) of the rope.\n         * @member {number}\n         * @readOnly\n         */\n        get: function () {\n            return this._width;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Refreshes Rope indices and uvs\n     * @private\n     */\n    RopeGeometry.prototype.build = function () {\n        var points = this.points;\n        if (!points)\n            { return; }\n        var vertexBuffer = this.getBuffer('aVertexPosition');\n        var uvBuffer = this.getBuffer('aTextureCoord');\n        var indexBuffer = this.getIndex();\n        // if too little points, or texture hasn't got UVs set yet just move on.\n        if (points.length < 1) {\n            return;\n        }\n        // if the number of points has changed we will need to recreate the arraybuffers\n        if (vertexBuffer.data.length / 4 !== points.length) {\n            vertexBuffer.data = new Float32Array(points.length * 4);\n            uvBuffer.data = new Float32Array(points.length * 4);\n            indexBuffer.data = new Uint16Array((points.length - 1) * 6);\n        }\n        var uvs = uvBuffer.data;\n        var indices = indexBuffer.data;\n        uvs[0] = 0;\n        uvs[1] = 0;\n        uvs[2] = 0;\n        uvs[3] = 1;\n        var amount = 0;\n        var prev = points[0];\n        var textureWidth = this._width * this.textureScale;\n        var total = points.length; // - 1;\n        for (var i = 0; i < total; i++) {\n            // time to do some smart drawing!\n            var index = i * 4;\n            if (this.textureScale > 0) {\n                // calculate pixel distance from previous point\n                var dx = prev.x - points[i].x;\n                var dy = prev.y - points[i].y;\n                var distance = Math.sqrt((dx * dx) + (dy * dy));\n                prev = points[i];\n                amount += distance / textureWidth;\n            }\n            else {\n                // stretch texture\n                amount = i / (total - 1);\n            }\n            uvs[index] = amount;\n            uvs[index + 1] = 0;\n            uvs[index + 2] = amount;\n            uvs[index + 3] = 1;\n        }\n        var indexCount = 0;\n        for (var i = 0; i < total - 1; i++) {\n            var index = i * 2;\n            indices[indexCount++] = index;\n            indices[indexCount++] = index + 1;\n            indices[indexCount++] = index + 2;\n            indices[indexCount++] = index + 2;\n            indices[indexCount++] = index + 1;\n            indices[indexCount++] = index + 3;\n        }\n        // ensure that the changes are uploaded\n        uvBuffer.update();\n        indexBuffer.update();\n        this.updateVertices();\n    };\n    /**\n     * refreshes vertices of Rope mesh\n     */\n    RopeGeometry.prototype.updateVertices = function () {\n        var points = this.points;\n        if (points.length < 1) {\n            return;\n        }\n        var lastPoint = points[0];\n        var nextPoint;\n        var perpX = 0;\n        var perpY = 0;\n        var vertices = this.buffers[0].data;\n        var total = points.length;\n        for (var i = 0; i < total; i++) {\n            var point = points[i];\n            var index = i * 4;\n            if (i < points.length - 1) {\n                nextPoint = points[i + 1];\n            }\n            else {\n                nextPoint = point;\n            }\n            perpY = -(nextPoint.x - lastPoint.x);\n            perpX = nextPoint.y - lastPoint.y;\n            var perpLength = Math.sqrt((perpX * perpX) + (perpY * perpY));\n            var num = this.textureScale > 0 ? this.textureScale * this._width / 2 : this._width / 2;\n            perpX /= perpLength;\n            perpY /= perpLength;\n            perpX *= num;\n            perpY *= num;\n            vertices[index] = point.x + perpX;\n            vertices[index + 1] = point.y + perpY;\n            vertices[index + 2] = point.x - perpX;\n            vertices[index + 3] = point.y - perpY;\n            lastPoint = point;\n        }\n        this.buffers[0].update();\n    };\n    RopeGeometry.prototype.update = function () {\n        if (this.textureScale > 0) {\n            this.build(); // we need to update UVs\n        }\n        else {\n            this.updateVertices();\n        }\n    };\n    return RopeGeometry;\n}(_pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshGeometry));\n\n/**\n * The rope allows you to draw a texture across several points and then manipulate these points\n *\n *```js\n * for (let i = 0; i < 20; i++) {\n *     points.push(new PIXI.Point(i * 50, 0));\n * };\n * let rope = new PIXI.SimpleRope(PIXI.Texture.from(\"snake.png\"), points);\n *  ```\n *\n * @class\n * @extends PIXI.Mesh\n * @memberof PIXI\n *\n */\nvar SimpleRope = /** @class */ (function (_super) {\n    __extends(SimpleRope, _super);\n    /**\n     * @param {PIXI.Texture} texture - The texture to use on the rope.\n     * @param {PIXI.Point[]} points - An array of {@link PIXI.Point} objects to construct this rope.\n     * @param {number} [textureScale=0] - Optional. Positive values scale rope texture\n     * keeping its aspect ratio. You can reduce alpha channel artifacts by providing a larger texture\n     * and downsampling here. If set to zero, texture will be streched instead.\n     */\n    function SimpleRope(texture, points, textureScale) {\n        if (textureScale === void 0) { textureScale = 0; }\n        var _this = this;\n        var ropeGeometry = new RopeGeometry(texture.height, points, textureScale);\n        var meshMaterial = new _pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshMaterial(texture);\n        if (textureScale > 0) {\n            // attempt to set UV wrapping, will fail on non-power of two textures\n            texture.baseTexture.wrapMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_1__.WRAP_MODES.REPEAT;\n        }\n        _this = _super.call(this, ropeGeometry, meshMaterial) || this;\n        /**\n         * re-calculate vertices by rope points each frame\n         *\n         * @member {boolean}\n         */\n        _this.autoUpdate = true;\n        return _this;\n    }\n    SimpleRope.prototype._render = function (renderer) {\n        var geometry = this.geometry;\n        if (this.autoUpdate || geometry._width !== this.shader.texture.height) {\n            geometry._width = this.shader.texture.height;\n            geometry.update();\n        }\n        _super.prototype._render.call(this, renderer);\n    };\n    return SimpleRope;\n}(_pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.Mesh));\n\n/**\n * The SimplePlane allows you to draw a texture across several points and then manipulate these points\n *\n *```js\n * for (let i = 0; i < 20; i++) {\n *     points.push(new PIXI.Point(i * 50, 0));\n * };\n * let SimplePlane = new PIXI.SimplePlane(PIXI.Texture.from(\"snake.png\"), points);\n *  ```\n *\n * @class\n * @extends PIXI.Mesh\n * @memberof PIXI\n *\n */\nvar SimplePlane = /** @class */ (function (_super) {\n    __extends(SimplePlane, _super);\n    /**\n     * @param {PIXI.Texture} texture - The texture to use on the SimplePlane.\n     * @param {number} verticesX - The number of vertices in the x-axis\n     * @param {number} verticesY - The number of vertices in the y-axis\n     */\n    function SimplePlane(texture, verticesX, verticesY) {\n        var _this = this;\n        var planeGeometry = new PlaneGeometry(texture.width, texture.height, verticesX, verticesY);\n        var meshMaterial = new _pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshMaterial(_pixi_core__WEBPACK_IMPORTED_MODULE_2__.Texture.WHITE);\n        _this = _super.call(this, planeGeometry, meshMaterial) || this;\n        // lets call the setter to ensure all necessary updates are performed\n        _this.texture = texture;\n        return _this;\n    }\n    /**\n     * Method used for overrides, to do something in case texture frame was changed.\n     * Meshes based on plane can override it and change more details based on texture.\n     */\n    SimplePlane.prototype.textureUpdated = function () {\n        this._textureID = this.shader.texture._updateID;\n        var geometry = this.geometry;\n        geometry.width = this.shader.texture.width;\n        geometry.height = this.shader.texture.height;\n        geometry.build();\n    };\n    Object.defineProperty(SimplePlane.prototype, \"texture\", {\n        get: function () {\n            return this.shader.texture;\n        },\n        set: function (value) {\n            // Track texture same way sprite does.\n            // For generated meshes like NineSlicePlane it can change the geometry.\n            // Unfortunately, this method might not work if you directly change texture in material.\n            if (this.shader.texture === value) {\n                return;\n            }\n            this.shader.texture = value;\n            this._textureID = -1;\n            if (value.baseTexture.valid) {\n                this.textureUpdated();\n            }\n            else {\n                value.once('update', this.textureUpdated, this);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    SimplePlane.prototype._render = function (renderer) {\n        if (this._textureID !== this.shader.texture._updateID) {\n            this.textureUpdated();\n        }\n        _super.prototype._render.call(this, renderer);\n    };\n    SimplePlane.prototype.destroy = function (options) {\n        this.shader.texture.off('update', this.textureUpdated, this);\n        _super.prototype.destroy.call(this, options);\n    };\n    return SimplePlane;\n}(_pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.Mesh));\n\n/**\n * The Simple Mesh class mimics Mesh in PixiJS v4, providing easy-to-use constructor arguments.\n * For more robust customization, use {@link PIXI.Mesh}.\n *\n * @class\n * @extends PIXI.Mesh\n * @memberof PIXI\n */\nvar SimpleMesh = /** @class */ (function (_super) {\n    __extends(SimpleMesh, _super);\n    /**\n     * @param {PIXI.Texture} [texture=Texture.EMPTY] - The texture to use\n     * @param {Float32Array} [vertices] - if you want to specify the vertices\n     * @param {Float32Array} [uvs] - if you want to specify the uvs\n     * @param {Uint16Array} [indices] - if you want to specify the indices\n     * @param {number} [drawMode] - the drawMode, can be any of the Mesh.DRAW_MODES consts\n     */\n    function SimpleMesh(texture, vertices, uvs, indices, drawMode) {\n        if (texture === void 0) { texture = _pixi_core__WEBPACK_IMPORTED_MODULE_2__.Texture.EMPTY; }\n        var _this = this;\n        var geometry = new _pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshGeometry(vertices, uvs, indices);\n        geometry.getBuffer('aVertexPosition').static = false;\n        var meshMaterial = new _pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.MeshMaterial(texture);\n        _this = _super.call(this, geometry, meshMaterial, null, drawMode) || this;\n        /**\n         * upload vertices buffer each frame\n         * @member {boolean}\n         */\n        _this.autoUpdate = true;\n        return _this;\n    }\n    Object.defineProperty(SimpleMesh.prototype, \"vertices\", {\n        /**\n         * Collection of vertices data.\n         * @member {Float32Array}\n         */\n        get: function () {\n            return this.geometry.getBuffer('aVertexPosition').data;\n        },\n        set: function (value) {\n            this.geometry.getBuffer('aVertexPosition').data = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    SimpleMesh.prototype._render = function (renderer) {\n        if (this.autoUpdate) {\n            this.geometry.getBuffer('aVertexPosition').update();\n        }\n        _super.prototype._render.call(this, renderer);\n    };\n    return SimpleMesh;\n}(_pixi_mesh__WEBPACK_IMPORTED_MODULE_0__.Mesh));\n\nvar DEFAULT_BORDER_SIZE = 10;\n/**\n * The NineSlicePlane allows you to stretch a texture using 9-slice scaling. The corners will remain unscaled (useful\n * for buttons with rounded corners for example) and the other areas will be scaled horizontally and or vertically\n *\n *```js\n * let Plane9 = new PIXI.NineSlicePlane(PIXI.Texture.from('BoxWithRoundedCorners.png'), 15, 15, 15, 15);\n *  ```\n * <pre>\n *      A                          B\n *    +---+----------------------+---+\n *  C | 1 |          2           | 3 |\n *    +---+----------------------+---+\n *    |   |                      |   |\n *    | 4 |          5           | 6 |\n *    |   |                      |   |\n *    +---+----------------------+---+\n *  D | 7 |          8           | 9 |\n *    +---+----------------------+---+\n\n *  When changing this objects width and/or height:\n *     areas 1 3 7 and 9 will remain unscaled.\n *     areas 2 and 8 will be stretched horizontally\n *     areas 4 and 6 will be stretched vertically\n *     area 5 will be stretched both horizontally and vertically\n * </pre>\n *\n * @class\n * @extends PIXI.SimplePlane\n * @memberof PIXI\n *\n */\nvar NineSlicePlane = /** @class */ (function (_super) {\n    __extends(NineSlicePlane, _super);\n    /**\n     * @param {PIXI.Texture} texture - The texture to use on the NineSlicePlane.\n     * @param {number} [leftWidth=10] - size of the left vertical bar (A)\n     * @param {number} [topHeight=10] - size of the top horizontal bar (C)\n     * @param {number} [rightWidth=10] - size of the right vertical bar (B)\n     * @param {number} [bottomHeight=10] - size of the bottom horizontal bar (D)\n     */\n    function NineSlicePlane(texture, leftWidth, topHeight, rightWidth, bottomHeight) {\n        if (leftWidth === void 0) { leftWidth = DEFAULT_BORDER_SIZE; }\n        if (topHeight === void 0) { topHeight = DEFAULT_BORDER_SIZE; }\n        if (rightWidth === void 0) { rightWidth = DEFAULT_BORDER_SIZE; }\n        if (bottomHeight === void 0) { bottomHeight = DEFAULT_BORDER_SIZE; }\n        var _this = _super.call(this, _pixi_core__WEBPACK_IMPORTED_MODULE_2__.Texture.WHITE, 4, 4) || this;\n        _this._origWidth = texture.orig.width;\n        _this._origHeight = texture.orig.height;\n        /**\n         * The width of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane\n         *\n         * @member {number}\n         * @override\n         */\n        _this._width = _this._origWidth;\n        /**\n         * The height of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane\n         *\n         * @member {number}\n         * @override\n         */\n        _this._height = _this._origHeight;\n        /**\n         * The width of the left column (a)\n         *\n         * @member {number}\n         * @private\n         */\n        _this._leftWidth = leftWidth;\n        /**\n         * The width of the right column (b)\n         *\n         * @member {number}\n         * @private\n         */\n        _this._rightWidth = rightWidth;\n        /**\n         * The height of the top row (c)\n         *\n         * @member {number}\n         * @private\n         */\n        _this._topHeight = topHeight;\n        /**\n         * The height of the bottom row (d)\n         *\n         * @member {number}\n         * @private\n         */\n        _this._bottomHeight = bottomHeight;\n        // lets call the setter to ensure all necessary updates are performed\n        _this.texture = texture;\n        return _this;\n    }\n    NineSlicePlane.prototype.textureUpdated = function () {\n        this._textureID = this.shader.texture._updateID;\n        this._refresh();\n    };\n    Object.defineProperty(NineSlicePlane.prototype, \"vertices\", {\n        get: function () {\n            return this.geometry.getBuffer('aVertexPosition').data;\n        },\n        set: function (value) {\n            this.geometry.getBuffer('aVertexPosition').data = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Updates the horizontal vertices.\n     *\n     */\n    NineSlicePlane.prototype.updateHorizontalVertices = function () {\n        var vertices = this.vertices;\n        var scale = this._getMinScale();\n        vertices[9] = vertices[11] = vertices[13] = vertices[15] = this._topHeight * scale;\n        vertices[17] = vertices[19] = vertices[21] = vertices[23] = this._height - (this._bottomHeight * scale);\n        vertices[25] = vertices[27] = vertices[29] = vertices[31] = this._height;\n    };\n    /**\n     * Updates the vertical vertices.\n     *\n     */\n    NineSlicePlane.prototype.updateVerticalVertices = function () {\n        var vertices = this.vertices;\n        var scale = this._getMinScale();\n        vertices[2] = vertices[10] = vertices[18] = vertices[26] = this._leftWidth * scale;\n        vertices[4] = vertices[12] = vertices[20] = vertices[28] = this._width - (this._rightWidth * scale);\n        vertices[6] = vertices[14] = vertices[22] = vertices[30] = this._width;\n    };\n    /**\n     * Returns the smaller of a set of vertical and horizontal scale of nine slice corners.\n     *\n     * @return {number} Smaller number of vertical and horizontal scale.\n     * @private\n     */\n    NineSlicePlane.prototype._getMinScale = function () {\n        var w = this._leftWidth + this._rightWidth;\n        var scaleW = this._width > w ? 1.0 : this._width / w;\n        var h = this._topHeight + this._bottomHeight;\n        var scaleH = this._height > h ? 1.0 : this._height / h;\n        var scale = Math.min(scaleW, scaleH);\n        return scale;\n    };\n    Object.defineProperty(NineSlicePlane.prototype, \"width\", {\n        /**\n         * The width of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._width;\n        },\n        set: function (value) {\n            this._width = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NineSlicePlane.prototype, \"height\", {\n        /**\n         * The height of the NineSlicePlane, setting this will actually modify the vertices and UV's of this plane\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._height;\n        },\n        set: function (value) {\n            this._height = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NineSlicePlane.prototype, \"leftWidth\", {\n        /**\n         * The width of the left column\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._leftWidth;\n        },\n        set: function (value) {\n            this._leftWidth = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NineSlicePlane.prototype, \"rightWidth\", {\n        /**\n         * The width of the right column\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._rightWidth;\n        },\n        set: function (value) {\n            this._rightWidth = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NineSlicePlane.prototype, \"topHeight\", {\n        /**\n         * The height of the top row\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._topHeight;\n        },\n        set: function (value) {\n            this._topHeight = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(NineSlicePlane.prototype, \"bottomHeight\", {\n        /**\n         * The height of the bottom row\n         *\n         * @member {number}\n         */\n        get: function () {\n            return this._bottomHeight;\n        },\n        set: function (value) {\n            this._bottomHeight = value;\n            this._refresh();\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Refreshes NineSlicePlane coords. All of them.\n     */\n    NineSlicePlane.prototype._refresh = function () {\n        var texture = this.texture;\n        var uvs = this.geometry.buffers[1].data;\n        this._origWidth = texture.orig.width;\n        this._origHeight = texture.orig.height;\n        var _uvw = 1.0 / this._origWidth;\n        var _uvh = 1.0 / this._origHeight;\n        uvs[0] = uvs[8] = uvs[16] = uvs[24] = 0;\n        uvs[1] = uvs[3] = uvs[5] = uvs[7] = 0;\n        uvs[6] = uvs[14] = uvs[22] = uvs[30] = 1;\n        uvs[25] = uvs[27] = uvs[29] = uvs[31] = 1;\n        uvs[2] = uvs[10] = uvs[18] = uvs[26] = _uvw * this._leftWidth;\n        uvs[4] = uvs[12] = uvs[20] = uvs[28] = 1 - (_uvw * this._rightWidth);\n        uvs[9] = uvs[11] = uvs[13] = uvs[15] = _uvh * this._topHeight;\n        uvs[17] = uvs[19] = uvs[21] = uvs[23] = 1 - (_uvh * this._bottomHeight);\n        this.updateHorizontalVertices();\n        this.updateVerticalVertices();\n        this.geometry.buffers[0].update();\n        this.geometry.buffers[1].update();\n    };\n    return NineSlicePlane;\n}(SimplePlane));\n\n\n//# sourceMappingURL=mesh-extras.es.js.map\n\n\n//# sourceURL=webpack://MysteryRogueSystem/./node_modules/@pixi/mesh-extras/lib/mesh-extras.es.js?");

/***/ }),

/***/ "./node_modules/@pixi/mesh/lib/mesh.es.js":
/*!************************************************!*\
  !*** ./node_modules/@pixi/mesh/lib/mesh.es.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Mesh\": () => (/* binding */ Mesh),\n/* harmony export */   \"MeshBatchUvs\": () => (/* binding */ MeshBatchUvs),\n/* harmony export */   \"MeshGeometry\": () => (/* binding */ MeshGeometry),\n/* harmony export */   \"MeshMaterial\": () => (/* binding */ MeshMaterial)\n/* harmony export */ });\n/* harmony import */ var _pixi_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @pixi/core */ \"./node_modules/@pixi/core/lib/core.es.js\");\n/* harmony import */ var _pixi_math__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @pixi/math */ \"./node_modules/@pixi/math/lib/math.es.js\");\n/* harmony import */ var _pixi_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @pixi/constants */ \"./node_modules/@pixi/constants/lib/constants.es.js\");\n/* harmony import */ var _pixi_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @pixi/display */ \"./node_modules/@pixi/display/lib/display.es.js\");\n/* harmony import */ var _pixi_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @pixi/settings */ \"./node_modules/@pixi/settings/lib/settings.es.js\");\n/* harmony import */ var _pixi_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @pixi/utils */ \"./node_modules/@pixi/utils/lib/utils.es.js\");\n/*!\n * @pixi/mesh - v5.3.11\n * Compiled Mon, 01 Nov 2021 16:10:12 UTC\n *\n * @pixi/mesh is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n\n\n\n\n\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) { if (b.hasOwnProperty(p)) { d[p] = b[p]; } } };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * Class controls cache for UV mapping from Texture normal space to BaseTexture normal space.\n *\n * @class\n * @memberof PIXI\n */\nvar MeshBatchUvs = /** @class */ (function () {\n    /**\n     * @param {PIXI.Buffer} uvBuffer - Buffer with normalized uv's\n     * @param {PIXI.TextureMatrix} uvMatrix - Material UV matrix\n     */\n    function MeshBatchUvs(uvBuffer, uvMatrix) {\n        /**\n         * Buffer with normalized UV's\n         * @member {PIXI.Buffer}\n         */\n        this.uvBuffer = uvBuffer;\n        /**\n         * Material UV matrix\n         * @member {PIXI.TextureMatrix}\n         */\n        this.uvMatrix = uvMatrix;\n        /**\n         * UV Buffer data\n         * @member {Float32Array}\n         * @readonly\n         */\n        this.data = null;\n        this._bufferUpdateId = -1;\n        this._textureUpdateId = -1;\n        this._updateID = 0;\n    }\n    /**\n     * updates\n     *\n     * @param {boolean} [forceUpdate] - force the update\n     */\n    MeshBatchUvs.prototype.update = function (forceUpdate) {\n        if (!forceUpdate\n            && this._bufferUpdateId === this.uvBuffer._updateID\n            && this._textureUpdateId === this.uvMatrix._updateID) {\n            return;\n        }\n        this._bufferUpdateId = this.uvBuffer._updateID;\n        this._textureUpdateId = this.uvMatrix._updateID;\n        var data = this.uvBuffer.data;\n        if (!this.data || this.data.length !== data.length) {\n            this.data = new Float32Array(data.length);\n        }\n        this.uvMatrix.multiplyUvs(data, this.data);\n        this._updateID++;\n    };\n    return MeshBatchUvs;\n}());\n\nvar tempPoint = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Point();\nvar tempPolygon = new _pixi_math__WEBPACK_IMPORTED_MODULE_1__.Polygon();\n/**\n * Base mesh class.\n *\n * This class empowers you to have maximum flexibility to render any kind of WebGL visuals you can think of.\n * This class assumes a certain level of WebGL knowledge.\n * If you know a bit this should abstract enough away to make you life easier!\n *\n * Pretty much ALL WebGL can be broken down into the following:\n * - Geometry - The structure and data for the mesh. This can include anything from positions, uvs, normals, colors etc..\n * - Shader - This is the shader that PixiJS will render the geometry with (attributes in the shader must match the geometry)\n * - State - This is the state of WebGL required to render the mesh.\n *\n * Through a combination of the above elements you can render anything you want, 2D or 3D!\n *\n * @class\n * @extends PIXI.Container\n * @memberof PIXI\n */\nvar Mesh = /** @class */ (function (_super) {\n    __extends(Mesh, _super);\n    /**\n     * @param {PIXI.Geometry} geometry - the geometry the mesh will use\n     * @param {PIXI.MeshMaterial} shader - the shader the mesh will use\n     * @param {PIXI.State} [state] - the state that the WebGL context is required to be in to render the mesh\n     *        if no state is provided, uses {@link PIXI.State.for2d} to create a 2D state for PixiJS.\n     * @param {number} [drawMode=PIXI.DRAW_MODES.TRIANGLES] - the drawMode, can be any of the PIXI.DRAW_MODES consts\n     */\n    function Mesh(geometry, shader, state, drawMode) {\n        if (drawMode === void 0) { drawMode = _pixi_constants__WEBPACK_IMPORTED_MODULE_2__.DRAW_MODES.TRIANGLES; }\n        var _this = _super.call(this) || this;\n        /**\n         * Includes vertex positions, face indices, normals, colors, UVs, and\n         * custom attributes within buffers, reducing the cost of passing all\n         * this data to the GPU. Can be shared between multiple Mesh objects.\n         * @member {PIXI.Geometry}\n         * @readonly\n         */\n        _this.geometry = geometry;\n        geometry.refCount++;\n        /**\n         * Represents the vertex and fragment shaders that processes the geometry and runs on the GPU.\n         * Can be shared between multiple Mesh objects.\n         * @member {PIXI.Shader|PIXI.MeshMaterial}\n         */\n        _this.shader = shader;\n        /**\n         * Represents the WebGL state the Mesh required to render, excludes shader and geometry. E.g.,\n         * blend mode, culling, depth testing, direction of rendering triangles, backface, etc.\n         * @member {PIXI.State}\n         */\n        _this.state = state || _pixi_core__WEBPACK_IMPORTED_MODULE_0__.State.for2d();\n        /**\n         * The way the Mesh should be drawn, can be any of the {@link PIXI.DRAW_MODES} constants.\n         *\n         * @member {number}\n         * @see PIXI.DRAW_MODES\n         */\n        _this.drawMode = drawMode;\n        /**\n         * Typically the index of the IndexBuffer where to start drawing.\n         * @member {number}\n         * @default 0\n         */\n        _this.start = 0;\n        /**\n         * How much of the geometry to draw, by default `0` renders everything.\n         * @member {number}\n         * @default 0\n         */\n        _this.size = 0;\n        /**\n         * thease are used as easy access for batching\n         * @member {Float32Array}\n         * @private\n         */\n        _this.uvs = null;\n        /**\n         * thease are used as easy access for batching\n         * @member {Uint16Array}\n         * @private\n         */\n        _this.indices = null;\n        /**\n         * this is the caching layer used by the batcher\n         * @member {Float32Array}\n         * @private\n         */\n        _this.vertexData = new Float32Array(1);\n        /**\n         * If geometry is changed used to decide to re-transform\n         * the vertexData.\n         * @member {number}\n         * @private\n         */\n        _this.vertexDirty = 0;\n        _this._transformID = -1;\n        /**\n         * Internal roundPixels field\n         *\n         * @member {boolean}\n         * @private\n         */\n        _this._roundPixels = _pixi_settings__WEBPACK_IMPORTED_MODULE_4__.settings.ROUND_PIXELS;\n        /**\n         * Batched UV's are cached for atlas textures\n         * @member {PIXI.MeshBatchUvs}\n         * @private\n         */\n        _this.batchUvs = null;\n        return _this;\n    }\n    Object.defineProperty(Mesh.prototype, \"uvBuffer\", {\n        /**\n         * To change mesh uv's, change its uvBuffer data and increment its _updateID.\n         * @member {PIXI.Buffer}\n         * @readonly\n         */\n        get: function () {\n            return this.geometry.buffers[1];\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"verticesBuffer\", {\n        /**\n         * To change mesh vertices, change its uvBuffer data and increment its _updateID.\n         * Incrementing _updateID is optional because most of Mesh objects do it anyway.\n         * @member {PIXI.Buffer}\n         * @readonly\n         */\n        get: function () {\n            return this.geometry.buffers[0];\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"material\", {\n        get: function () {\n            return this.shader;\n        },\n        /**\n         * Alias for {@link PIXI.Mesh#shader}.\n         * @member {PIXI.MeshMaterial}\n         */\n        set: function (value) {\n            this.shader = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"blendMode\", {\n        get: function () {\n            return this.state.blendMode;\n        },\n        /**\n         * The blend mode to be applied to the Mesh. Apply a value of\n         * `PIXI.BLEND_MODES.NORMAL` to reset the blend mode.\n         *\n         * @member {number}\n         * @default PIXI.BLEND_MODES.NORMAL;\n         * @see PIXI.BLEND_MODES\n         */\n        set: function (value) {\n            this.state.blendMode = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"roundPixels\", {\n        get: function () {\n            return this._roundPixels;\n        },\n        /**\n         * If true PixiJS will Math.floor() x/y values when rendering, stopping pixel interpolation.\n         * Advantages can include sharper image quality (like text) and faster rendering on canvas.\n         * The main disadvantage is movement of objects may appear less smooth.\n         * To set the global default, change {@link PIXI.settings.ROUND_PIXELS}\n         *\n         * @member {boolean}\n         * @default false\n         */\n        set: function (value) {\n            if (this._roundPixels !== value) {\n                this._transformID = -1;\n            }\n            this._roundPixels = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"tint\", {\n        /**\n         * The multiply tint applied to the Mesh. This is a hex value. A value of\n         * `0xFFFFFF` will remove any tint effect.\n         *\n         * @member {number}\n         * @default 0xFFFFFF\n         */\n        get: function () {\n            return this.shader.tint;\n        },\n        set: function (value) {\n            this.shader.tint = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Mesh.prototype, \"texture\", {\n        /**\n         * The texture that the Mesh uses.\n         *\n         * @member {PIXI.Texture}\n         */\n        get: function () {\n            return this.shader.texture;\n        },\n        set: function (value) {\n            this.shader.texture = value;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Standard renderer draw.\n     * @protected\n     * @param {PIXI.Renderer} renderer - Instance to renderer.\n     */\n    Mesh.prototype._render = function (renderer) {\n        // set properties for batching..\n        // TODO could use a different way to grab verts?\n        var vertices = this.geometry.buffers[0].data;\n        // TODO benchmark check for attribute size..\n        if (this.shader.batchable\n            && this.drawMode === _pixi_constants__WEBPACK_IMPORTED_MODULE_2__.DRAW_MODES.TRIANGLES\n            && vertices.length < Mesh.BATCHABLE_SIZE * 2) {\n            this._renderToBatch(renderer);\n        }\n        else {\n            this._renderDefault(renderer);\n        }\n    };\n    /**\n     * Standard non-batching way of rendering.\n     * @protected\n     * @param {PIXI.Renderer} renderer - Instance to renderer.\n     */\n    Mesh.prototype._renderDefault = function (renderer) {\n        var shader = this.shader;\n        shader.alpha = this.worldAlpha;\n        if (shader.update) {\n            shader.update();\n        }\n        renderer.batch.flush();\n        if (shader.program.uniformData.translationMatrix) {\n            shader.uniforms.translationMatrix = this.transform.worldTransform.toArray(true);\n        }\n        // bind and sync uniforms..\n        renderer.shader.bind(shader);\n        // set state..\n        renderer.state.set(this.state);\n        // bind the geometry...\n        renderer.geometry.bind(this.geometry, shader);\n        // then render it\n        renderer.geometry.draw(this.drawMode, this.size, this.start, this.geometry.instanceCount);\n    };\n    /**\n     * Rendering by using the Batch system.\n     * @protected\n     * @param {PIXI.Renderer} renderer - Instance to renderer.\n     */\n    Mesh.prototype._renderToBatch = function (renderer) {\n        var geometry = this.geometry;\n        if (this.shader.uvMatrix) {\n            this.shader.uvMatrix.update();\n            this.calculateUvs();\n        }\n        // set properties for batching..\n        this.calculateVertices();\n        this.indices = geometry.indexBuffer.data;\n        this._tintRGB = this.shader._tintRGB;\n        this._texture = this.shader.texture;\n        var pluginName = this.material.pluginName;\n        renderer.batch.setObjectRenderer(renderer.plugins[pluginName]);\n        renderer.plugins[pluginName].render(this);\n    };\n    /**\n     * Updates vertexData field based on transform and vertices\n     */\n    Mesh.prototype.calculateVertices = function () {\n        var geometry = this.geometry;\n        var vertices = geometry.buffers[0].data;\n        if (geometry.vertexDir